// (C) 2001-2017 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


//
//              ALTERA CORPORATION
//
//
//


`timescale 1 ps/1 ps
// altera message_off 10036


module twentynm_xcvr_native #(
        parameter device_revision                = "20nm5es",

        parameter bonded_lanes                   = 1,
        parameter bonding_master_ch              = 0,

    // twentynm_pma parameters
        parameter xcvr_native_mode               = "mode_duplex",       // mode_duplex, mode_rx_only, mode_tx_only
    // parameters for twentynm_hssi_pma_adaptation
        parameter pma_adapt_adapt_mode           = "dfe_vga",           // ctle|dfe_vga|ctle_vga|ctle_vga_dfe|manual
        parameter pma_adapt_adp_1s_ctle_bypass   = "radp_1s_ctle_bypass_0",// radp_1s_ctle_bypass_0|radp_1s_ctle_bypass_1
        parameter pma_adapt_adp_4s_ctle_bypass   = "radp_4s_ctle_bypass_0",// radp_4s_ctle_bypass_0|radp_4s_ctle_bypass_1
        parameter pma_adapt_adp_ctle_adapt_cycle_window = "radp_ctle_adapt_cycle_window_6",// radp_ctle_adapt_cycle_window_0|radp_ctle_adapt_cycle_window_1|radp_ctle_adapt_cycle_window_2|radp_ctle_adapt_cycle_window_3|radp_ctle_adapt_cycle_window_4|radp_ctle_adapt_cycle_window_5|radp_ctle_adapt_cycle_window_6|radp_ctle_adapt_cycle_window_7
        parameter pma_adapt_adp_ctle_en          = "radp_ctle_disable", // radp_ctle_disable|radp_ctle_enable
        parameter pma_adapt_adp_dfe_fltap_bypass = "radp_dfe_fltap_bypass_0",// radp_dfe_fltap_bypass_0|radp_dfe_fltap_bypass_1
        parameter pma_adapt_adp_dfe_fltap_en     = "radp_dfe_fltap_disable",// radp_dfe_fltap_disable|radp_dfe_fltap_enable
        parameter pma_adapt_adp_dfe_fxtap_bypass = "radp_dfe_fxtap_bypass_0",// radp_dfe_fxtap_bypass_0|radp_dfe_fxtap_bypass_1
        parameter pma_adapt_adp_dfe_fxtap_en     = "radp_dfe_fxtap_disable",// radp_dfe_fxtap_disable|radp_dfe_fxtap_enable
        parameter pma_adapt_adp_dfe_fxtap_hold_en = "radp_dfe_fxtap_not_held",// radp_dfe_fxtap_not_held|radp_dfe_fxtap_hold
        parameter pma_adapt_adp_dfe_mode         = "radp_dfe_mode_0",   // radp_dfe_mode_0|radp_dfe_mode_1|radp_dfe_mode_2|radp_dfe_mode_3|radp_dfe_mode_4|radp_dfe_mode_5|radp_dfe_mode_6|radp_dfe_mode_7
        parameter pma_adapt_adp_mode             = "radp_mode_0",       // radp_mode_0|radp_mode_1|radp_mode_2|radp_mode_3|radp_mode_4|radp_mode_5|radp_mode_6|radp_mode_7|radp_mode_8|radp_mode_9|radp_mode_10|radp_mode_11|radp_mode_12|radp_mode_13|radp_mode_14|radp_mode_15
        parameter pma_adapt_adp_onetime_dfe      = "radp_onetime_dfe_0",// radp_onetime_dfe_0|radp_onetime_dfe_1
        parameter pma_adapt_adp_vga_bypass       = "radp_vga_bypass_0", // radp_vga_bypass_0|radp_vga_bypass_1
        parameter pma_adapt_adp_vga_en           = "radp_vga_disable",  // radp_vga_disable|radp_vga_enable
        parameter pma_adapt_adp_vref_bypass      = "radp_vref_bypass_0",// radp_vref_bypass_0|radp_vref_bypass_1
        parameter pma_adapt_adp_vref_en          = "radp_vref_disable", // radp_vref_disable|radp_vref_enable
        parameter pma_adapt_datarate             = "0 bps",             //
        parameter pma_adapt_odi_dfe_spec_en      = "rodi_dfe_spec_en_0",// rodi_dfe_spec_en_0|rodi_dfe_spec_en_1
        parameter pma_adapt_prot_mode            = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_adapt_sup_mode             = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_pma_cdr_refclk_select_mux
        parameter pma_cdr_refclk_inclk0_logical_to_physical_mapping = "ref_iqclk0",// ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
        parameter pma_cdr_refclk_inclk1_logical_to_physical_mapping = "ref_iqclk0",// ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
        parameter pma_cdr_refclk_inclk2_logical_to_physical_mapping = "ref_iqclk0",// ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
        parameter pma_cdr_refclk_inclk3_logical_to_physical_mapping = "ref_iqclk0",// ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
        parameter pma_cdr_refclk_inclk4_logical_to_physical_mapping = "ref_iqclk0",// ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
        parameter pma_cdr_refclk_powerdown_mode  = "powerdown",         // powerup|powerdown
        parameter pma_cdr_refclk_refclk_select   = "ref_iqclk0",        // ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
    // parameters for twentynm_hssi_pma_channel_pll
        parameter cdr_pll_atb_select_control     = "atb_off",           // atb_off|atb_select_tp_1|atb_select_tp_2|atb_select_tp_3|atb_select_tp_4|atb_select_tp_5|atb_select_tp_6|atb_select_tp_7|atb_select_tp_8|atb_select_tp_9|atb_select_tp_10|atb_select_tp_11|atb_select_tp_12|atb_select_tp_13|atb_select_tp_14|atb_select_tp_15|atb_select_tp_16|atb_select_tp_17|atb_select_tp_18|atb_select_tp_19|atb_select_tp_20|atb_select_tp_21|atb_select_tp_22|atb_select_tp_23|atb_select_tp_24|atb_select_tp_25|atb_select_tp_26|atb_select_tp_27|atb_select_tp_28|atb_select_tp_29|atb_select_tp_30|atb_select_tp_31|atb_select_tp_32|atb_select_tp_33|atb_select_tp_34|atb_select_tp_35|atb_select_tp_36|atb_select_tp_37|atb_select_tp_38|atb_select_tp_39|atb_select_tp_40|atb_select_tp_41|atb_select_tp_42|atb_select_tp_43|atb_select_tp_44|atb_select_tp_45|atb_select_tp_46|atb_select_tp_47|atb_select_tp_48|atb_select_tp_49|atb_select_tp_50|atb_select_tp_51|atb_select_tp_52|atb_select_tp_53|atb_select_tp_54|atb_select_tp_55|atb_select_tp_56|atb_select_tp_57|atb_select_tp_58|atb_select_tp_59|atb_select_tp_60|atb_select_tp_61|atb_select_tp_62|atb_select_tp_63
        parameter cdr_pll_auto_reset_on          = "auto_reset_on",     // auto_reset_on|auto_reset_off
        parameter cdr_pll_bbpd_data_pattern_filter_select = "bbpd_data_pat_off",// bbpd_data_pat_off|bbpd_data_pat_1|bbpd_data_pat_2|bbpd_data_pat_3
        parameter cdr_pll_bw_sel                 = "low",               // low|medium|high
        parameter cdr_pll_cal_vco_count_length   = "sel_8b_count",      // sel_8b_count|sel_12b_count
        parameter cdr_pll_cdr_odi_select         = "sel_cdr",           // sel_cdr|sel_odi
        parameter cdr_pll_cdr_phaselock_mode     = "no_ignore_lock",    // no_ignore_lock|ignore_lock
        parameter cdr_pll_cdr_powerdown_mode     = "power_down",        // power_down|power_up
        parameter cdr_pll_cgb_div                = 1,                   // 1|2|4|8
        parameter cdr_pll_chgpmp_current_dn_pd   = "cp_current_pd_dn_setting0",// cp_current_pd_dn_setting0|cp_current_pd_dn_setting1|cp_current_pd_dn_setting2|cp_current_pd_dn_setting3|cp_current_pd_dn_setting4
        parameter cdr_pll_chgpmp_current_dn_trim = "cp_current_trimming_dn_setting0",// cp_current_trimming_dn_setting0|cp_current_trimming_dn_setting1|cp_current_trimming_dn_setting2|cp_current_trimming_dn_setting3|cp_current_trimming_dn_setting4|cp_current_trimming_dn_setting5|cp_current_trimming_dn_setting6|cp_current_trimming_dn_setting7|cp_current_trimming_dn_setting8|cp_current_trimming_dn_setting9|cp_current_trimming_dn_setting10|cp_current_trimming_dn_setting11|cp_current_trimming_dn_setting12|cp_current_trimming_dn_setting13|cp_current_trimming_dn_setting14|cp_current_trimming_dn_setting15
        parameter cdr_pll_chgpmp_current_pd      = "cp_current_pd_setting0",// cp_current_pd_setting0|cp_current_pd_setting1|cp_current_pd_setting2|cp_current_pd_setting3|cp_current_pd_setting4
        parameter cdr_pll_chgpmp_current_pfd     = "cp_current_pfd_setting0",// cp_current_pfd_setting0|cp_current_pfd_setting1|cp_current_pfd_setting2|cp_current_pfd_setting3|cp_current_pfd_setting4
        parameter cdr_pll_chgpmp_current_up_pd   = "cp_current_pd_up_setting0",// cp_current_pd_up_setting0|cp_current_pd_up_setting1|cp_current_pd_up_setting2|cp_current_pd_up_setting3|cp_current_pd_up_setting4
        parameter cdr_pll_chgpmp_current_up_trim = "cp_current_trimming_up_setting0",// cp_current_trimming_up_setting0|cp_current_trimming_up_setting1|cp_current_trimming_up_setting2|cp_current_trimming_up_setting3|cp_current_trimming_up_setting4|cp_current_trimming_up_setting5|cp_current_trimming_up_setting6|cp_current_trimming_up_setting7|cp_current_trimming_up_setting8|cp_current_trimming_up_setting9|cp_current_trimming_up_setting10|cp_current_trimming_up_setting11|cp_current_trimming_up_setting12|cp_current_trimming_up_setting13|cp_current_trimming_up_setting14|cp_current_trimming_up_setting15
        parameter cdr_pll_chgpmp_dn_pd_trim_double = "normal_dn_trim_current",// normal_dn_trim_current|double_dn_trim_current
        parameter cdr_pll_chgpmp_replicate       = "false",             // false|true
        parameter cdr_pll_chgpmp_testmode        = "cp_test_disable",   // cp_test_disable|cp_test_up|cp_test_dn|cp_tristate
        parameter cdr_pll_chgpmp_up_pd_trim_double = "normal_up_trim_current",// normal_up_trim_current|double_up_trim_current
        parameter cdr_pll_clklow_mux_select      = "clklow_mux_cdr_fbclk",// clklow_mux_cdr_fbclk|clklow_mux_fpll_test1|clklow_mux_reserved_1|clklow_mux_rx_deser_pclk_test|clklow_mux_reserved_2|clklow_mux_reserved_3|clklow_mux_reserved_4|clklow_mux_dfe_test
        parameter cdr_pll_datarate               = "0 bps",             //
        parameter cdr_pll_diag_loopback_enable   = "false",             // true|false
        parameter cdr_pll_disable_up_dn          = "true",              // true|false
        parameter cdr_pll_fb_select              = "direct_fb",         // iqtxrxclk_fb|direct_fb
        parameter cdr_pll_fref_clklow_div        = 1,                   // 1|2|4|8
        parameter cdr_pll_fref_mux_select        = "fref_mux_cdr_refclk",// fref_mux_cdr_refclk|fref_mux_fpll_test0|fref_mux_reserved_1|fref_mux_tx_ser_pclk_test|fref_mux_reserved_2|fref_mux_reserved_3|fref_mux_reserved_4|fref_mux_reserved_5
        parameter cdr_pll_gpon_lck2ref_control   = "gpon_lck2ref_off",  // gpon_lck2ref_off|gpon_lck2ref_on
        parameter cdr_pll_initial_settings       = "false",             // false|true
        parameter cdr_pll_iqclk_mux_sel          = "power_down",        // iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|power_down
        parameter cdr_pll_is_cascaded_pll        = "false",             // true|false
        parameter cdr_pll_lck2ref_delay_control  = "lck2ref_delay_off", // lck2ref_delay_off|lck2ref_delay_1|lck2ref_delay_2|lck2ref_delay_3|lck2ref_delay_4|lck2ref_delay_5|lck2ref_delay_6|lck2ref_delay_7
        parameter cdr_pll_lf_resistor_pd         = "lf_pd_setting0",    // lf_pd_setting0|lf_pd_setting1|lf_pd_setting2|lf_pd_setting3
        parameter cdr_pll_lf_resistor_pfd        = "lf_pfd_setting0",   // lf_pfd_setting0|lf_pfd_setting1|lf_pfd_setting2|lf_pfd_setting3
        parameter cdr_pll_lf_ripple_cap          = "lf_no_ripple",      // lf_no_ripple|lf_ripple_cap1
        parameter cdr_pll_loop_filter_bias_select = "lpflt_bias_off",   // lpflt_bias_off|lpflt_bias_1|lpflt_bias_2|lpflt_bias_3|lpflt_bias_4|lpflt_bias_5|lpflt_bias_6|lpflt_bias_7
        parameter cdr_pll_loopback_mode          = "loopback_disabled", // loopback_disabled|loopback_recovered_data|rx_refclk|rx_refclk_cdr_loopback|unused2|loopback_received_data|unused1
        parameter cdr_pll_lpd_counter            = 5'b1,
        parameter cdr_pll_lpfd_counter           = 5'b1,
        parameter cdr_pll_ltd_ltr_micro_controller_select = "ltd_ltr_pcs",// ltd_ltr_pcs|ltr_ucontroller|ltd_ucontroller
        parameter cdr_pll_m_counter              = 16,                  // 0..255
        parameter cdr_pll_n_counter              = 1,                   // 1|2|4|8
        parameter cdr_pll_n_counter_scratch      = 6'b1,
        parameter cdr_pll_output_clock_frequency = "0 hz",              //
        parameter cdr_pll_pcie_gen               = "non_pcie",          // pcie_gen1_100mhzref|pcie_gen2_100mhzref|pcie_gen3_100mhzref|pcie_gen1_125mhzref|pcie_gen2_125mhzref|pcie_gen3_125mhzref|non_pcie
        parameter cdr_pll_pd_fastlock_mode       = "false",             // false|true
        parameter cdr_pll_pd_l_counter           = 1,                   // 0|1|2|4|8|16
        parameter cdr_pll_pfd_l_counter          = 1,                   // 0|1|2|4|8|16|100
        parameter cdr_pll_pma_width              = 8,                   // 8|10|16|20|32|40|64
        parameter cdr_pll_primary_use            = "cmu",               // cmu|cdr
        parameter cdr_pll_prot_mode              = "unused",            // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter cdr_pll_reference_clock_frequency = "0 hz",           //
        parameter cdr_pll_reverse_serial_loopback = "no_loopback",      // no_loopback|loopback_data_no_posttap|loopback_data_with_posttap|loopback_data_0_1
        parameter cdr_pll_set_cdr_input_freq_range = 8'b0,
        parameter cdr_pll_set_cdr_v2i_enable     = "true",              // true|false
        parameter cdr_pll_set_cdr_vco_reset      = "false",             // true|false
        parameter cdr_pll_set_cdr_vco_speed      = 5'b1,
        parameter cdr_pll_set_cdr_vco_speed_fix  = 8'b0,
        parameter cdr_pll_set_cdr_vco_speed_pciegen3 = "cdr_vco_max_speedbin_pciegen3",// cdr_vco_min_speedbin_pciegen3|cdr_vco_max_speedbin_pciegen3
        parameter cdr_pll_sup_mode               = "user_mode",         // user_mode|engineering_mode
        parameter cdr_pll_tx_pll_prot_mode       = "txpll_unused",      // txpll_unused|txpll_enable_pcie|txpll_enable
        parameter cdr_pll_txpll_hclk_driver_enable = "false",           // true|false
        parameter cdr_pll_uc_ro_cal              = "uc_ro_cal_off",     // uc_ro_cal_off|uc_ro_cal_on
        parameter cdr_pll_vco_freq               = "0 hz",              //
        parameter cdr_pll_vco_overrange_voltage  = "vco_overrange_off", // vco_overrange_off|vco_overrange_ref_1|vco_overrange_ref_2|vco_overrange_ref_3
        parameter cdr_pll_vco_underrange_voltage = "vco_underange_off", // vco_underange_off|vco_underange_ref_1|vco_underange_ref_2|vco_underange_ref_3
    // parameters for twentynm_hssi_pma_rx_buf
        parameter pma_rx_buf_bypass_eqz_stages_234 = "bypass_off",      // bypass_off|byypass_stages_234
        parameter pma_rx_buf_datarate            = "0 bps",             //
        parameter pma_rx_buf_diag_lp_en          = "dlp_off",           // dlp_off|dlp_on
        parameter pma_rx_buf_loopback_modes      = "lpbk_disable",      // lpbk_disable|pre_cdr|post_cdr
        parameter pma_rx_buf_pm_tx_rx_cvp_mode   = "cvp_off",           // cvp_off|cvp_on
        parameter pma_rx_buf_pm_tx_rx_pcie_gen   = "non_pcie",          // pcie_gen1_100mhzref|pcie_gen2_100mhzref|pcie_gen3_100mhzref|pcie_gen1_125mhzref|pcie_gen2_125mhzref|pcie_gen3_125mhzref|non_pcie
        parameter pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth = "pcie_gen3_32b",// pcie_gen3_32b|pcie_gen3_16b
        parameter pma_rx_buf_prot_mode           = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_buf_qpi_enable          = "non_qpi_mode",      // non_qpi_mode|qpi_mode
        parameter pma_rx_buf_refclk_en           = "enable",            // disable|enable
        parameter pma_rx_buf_rx_refclk_divider   = "bypass_divider",    // bypass_divider|divide_by_2
        parameter pma_rx_buf_sup_mode            = "user_mode",         // user_mode|engineering_mode
        parameter pma_rx_buf_xrx_path_datarate   = "0 bps",             //
        parameter pma_rx_buf_xrx_path_datawidth  = 8'b0,
        parameter pma_rx_buf_xrx_path_pma_rx_divclk_hz = 32'b0,
        parameter pma_rx_buf_xrx_path_prot_mode  = "unused",            // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_buf_xrx_path_sup_mode   = "user_mode",         // user_mode|engineering_mode
        parameter pma_rx_buf_xrx_path_uc_cal_enable = "rx_cal_off",     // rx_cal_off|rx_cal_on
    // parameters for twentynm_hssi_pma_rx_deser
        parameter pma_rx_deser_bitslip_bypass    = "bs_bypass_no",      // bs_bypass_no|bs_bypass_yes
        parameter pma_rx_deser_clkdiv_source     = "vco_bypass_normal", // vco_bypass_normal|clklow_to_clkdivrx|fref_to_clkdivrx
        parameter pma_rx_deser_clkdivrx_user_mode = "clkdivrx_user_disabled",// clkdivrx_user_disabled|clkdivrx_user_clkdiv|clkdivrx_user_clkdiv_div2|clkdivrx_user_div40|clkdivrx_user_div33|clkdivrx_user_div66
        parameter pma_rx_deser_datarate          = "0 bps",             //
        parameter pma_rx_deser_deser_factor      = 8,                   // 8|10|16|20|32|40|64
        parameter pma_rx_deser_force_clkdiv_for_testing = "normal_clkdiv",// normal_clkdiv|forced_0|forced_1
        parameter pma_rx_deser_pcie_gen          = "non_pcie",          // pcie_gen1_100mhzref|pcie_gen2_100mhzref|pcie_gen3_100mhzref|pcie_gen1_125mhzref|pcie_gen2_125mhzref|pcie_gen3_125mhzref|non_pcie
        parameter pma_rx_deser_pcie_gen_bitwidth = "pcie_gen3_32b",     // pcie_gen3_32b|pcie_gen3_16b
        parameter pma_rx_deser_prot_mode         = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_deser_rst_n_adapt_odi   = "no_rst_adapt_odi",  // yes_rst_adapt_odi|no_rst_adapt_odi
        parameter pma_rx_deser_sdclk_enable      = "false",             // false|true
        parameter pma_rx_deser_sup_mode          = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_pma_rx_dfe
        parameter pma_rx_dfe_datarate            = "0 bps",             //
        parameter pma_rx_dfe_dft_en              = "dft_disable",       // dft_disable|dft_enalbe
        parameter pma_rx_dfe_pdb                 = "dfe_enable",        // dfe_powerdown|dfe_reset|dfe_enable
        parameter pma_rx_dfe_pdb_fixedtap        = "fixtap_dfe_powerdown",// fixtap_dfe_powerdown|fixtap_dfe_enable
        parameter pma_rx_dfe_pdb_floattap        = "floattap_dfe_powerdown",// floattap_dfe_powerdown|floattap_dfe_enable
        parameter pma_rx_dfe_pdb_fxtap4t7        = "fxtap4t7_powerdown",// fxtap4t7_powerdown|fxtap4t7_enable
        parameter pma_rx_dfe_prot_mode           = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_dfe_sup_mode            = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_pma_rx_odi
        parameter pma_rx_odi_datarate            = "0 bps",             //
        parameter pma_rx_odi_prot_mode           = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_odi_step_ctrl_sel       = "feedback_mode",     // dprio_mode|feedback_mode|jm_mode
        parameter pma_rx_odi_sup_mode            = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_pma_rx_sd
        parameter pma_rx_sd_prot_mode            = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_sd_sd_output_off        = 1,                   // 0..28
        parameter pma_rx_sd_sd_output_on         = 1,                   // 0..15
        parameter pma_rx_sd_sd_pdb               = "sd_off",            // sd_on|sd_off
        parameter pma_rx_sd_sup_mode             = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_pma_tx_buf
        parameter pma_tx_buf_datarate            = "0 bps",             //
        parameter pma_tx_buf_mcgb_location_for_pcie = 4'b0,
        parameter pma_tx_buf_prot_mode           = "basic_tx",          // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
        parameter pma_tx_buf_rx_det              = "mode_0",            // mode_0|mode_1|mode_2|mode_3|mode_4|mode_5|mode_6|mode_7|mode_8|mode_9|mode_10|mode_11|mode_12|mode_13|mode_14|mode_15
        parameter pma_tx_buf_rx_det_output_sel   = "rx_det_pcie_out",   // rx_det_pcie_out|rx_det_qpi_out
        parameter pma_tx_buf_rx_det_pdb          = "rx_det_off",        // rx_det_off|rx_det_on
        parameter pma_tx_buf_sup_mode            = "user_mode",         // user_mode|engineering_mode
        parameter pma_tx_buf_user_fir_coeff_ctrl_sel = "ram_ctl",       // ram_ctl|dynamic_ctl
        parameter pma_tx_buf_xtx_path_clock_divider_ratio = 4'b0,
        parameter pma_tx_buf_xtx_path_datarate   = "0 bps",             //
        parameter pma_tx_buf_xtx_path_datawidth  = 8'b0,
        parameter pma_tx_buf_xtx_path_pma_tx_divclk_hz = 32'b0,
        parameter pma_tx_buf_xtx_path_prot_mode  = "basic_tx",          // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
        parameter pma_tx_buf_xtx_path_sup_mode   = "user_mode",         // user_mode|engineering_mode
        parameter pma_tx_buf_xtx_path_tx_pll_clk_hz = "0 hz",           //
    // parameters for twentynm_hssi_pma_tx_cgb
        parameter pma_cgb_bitslip_enable         = "enable_bitslip",    // disable_bitslip|enable_bitslip
        parameter pma_cgb_bonding_reset_enable   = "allow_bonding_reset",// disallow_bonding_reset|allow_bonding_reset
        parameter pma_cgb_datarate               = "0 bps",             //
        parameter pma_cgb_input_select_gen3      = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_input_select_x1        = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_input_select_xn        = "unused",            // sel_xn_up|sel_xn_dn|sel_x6_up|sel_x6_dn|sel_cgb_loc|unused
        parameter pma_cgb_pcie_gen3_bitwidth     = "pciegen3_wide",     // pciegen3_wide|pciegen3_narrow
        parameter pma_cgb_prot_mode              = "basic_tx",          // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
        parameter pma_cgb_scratch0_x1_clock_src  = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_scratch1_x1_clock_src  = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_scratch2_x1_clock_src  = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_scratch3_x1_clock_src  = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_select_done_master_or_slave = "choose_slave_pcie_sw_done",// choose_master_pcie_sw_done|choose_slave_pcie_sw_done
        parameter pma_cgb_ser_mode               = "eight_bit",         // eight_bit|ten_bit|sixteen_bit|twenty_bit|thirty_two_bit|forty_bit|sixty_four_bit
        parameter pma_cgb_sup_mode               = "user_mode",         // user_mode|engineering_mode
        parameter pma_cgb_tx_ucontrol_en         = "disable",           // disable|enable
        parameter pma_cgb_x1_div_m_sel           = "divbypass",         // divbypass|divby2|divby4|divby8
    // parameters for twentynm_hssi_pma_tx_ser
        parameter pma_tx_ser_prot_mode           = "basic_tx",          // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
        parameter pma_tx_ser_ser_clk_divtx_user_sel = "divtx_user_33",  // divtx_user_2|divtx_user_40|divtx_user_33|divtx_user_66|divtx_user_1|divtx_user_off
        parameter pma_tx_ser_sup_mode            = "user_mode",         // user_mode|engineering_mode

    // twentynm_pcs parameters
    // parameters for twentynm_hssi_10g_rx_pcs
        parameter hssi_10g_rx_pcs_advanced_user_mode = "disable",       // disable|enable
        parameter hssi_10g_rx_pcs_align_del      = "align_del_en",      // align_del_dis|align_del_en
        parameter hssi_10g_rx_pcs_ber_bit_err_total_cnt = "bit_err_total_cnt_10g",// bit_err_total_cnt_10g
        parameter hssi_10g_rx_pcs_ber_clken      = "ber_clk_dis",       // ber_clk_dis|ber_clk_en
        parameter hssi_10g_rx_pcs_ber_xus_timer_window = 21'b100110001001010,
        parameter hssi_10g_rx_pcs_bitslip_mode   = "bitslip_dis",       // bitslip_dis|bitslip_en
        parameter hssi_10g_rx_pcs_blksync_bitslip_type = "bitslip_comb",// bitslip_comb|bitslip_reg
        parameter hssi_10g_rx_pcs_blksync_bitslip_wait_cnt = 3'b1,
        parameter hssi_10g_rx_pcs_blksync_bitslip_wait_type = "bitslip_match",// bitslip_match|bitslip_cnt
        parameter hssi_10g_rx_pcs_blksync_bypass = "blksync_bypass_dis",// blksync_bypass_dis|blksync_bypass_en
        parameter hssi_10g_rx_pcs_blksync_clken  = "blksync_clk_dis",   // blksync_clk_dis|blksync_clk_en
        parameter hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt = "enum_invalid_sh_cnt_10g",// enum_invalid_sh_cnt_10g
        parameter hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock = "knum_sh_cnt_postlock_10g",// knum_sh_cnt_postlock_10g
        parameter hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock = "knum_sh_cnt_prelock_10g",// knum_sh_cnt_prelock_10g
        parameter hssi_10g_rx_pcs_blksync_pipeln = "blksync_pipeln_dis",// blksync_pipeln_dis|blksync_pipeln_en
        parameter hssi_10g_rx_pcs_clr_errblk_cnt_en = "disable",        // disable|enable
        parameter hssi_10g_rx_pcs_control_del    = "control_del_all",   // control_del_all|control_del_none
        parameter hssi_10g_rx_pcs_crcchk_bypass  = "crcchk_bypass_dis", // crcchk_bypass_dis|crcchk_bypass_en
        parameter hssi_10g_rx_pcs_crcchk_clken   = "crcchk_clk_dis",    // crcchk_clk_dis|crcchk_clk_en
        parameter hssi_10g_rx_pcs_crcchk_inv     = "crcchk_inv_dis",    // crcchk_inv_dis|crcchk_inv_en
        parameter hssi_10g_rx_pcs_crcchk_pipeln  = "crcchk_pipeln_dis", // crcchk_pipeln_dis|crcchk_pipeln_en
        parameter hssi_10g_rx_pcs_crcflag_pipeln = "crcflag_pipeln_dis",// crcflag_pipeln_dis|crcflag_pipeln_en
        parameter hssi_10g_rx_pcs_ctrl_bit_reverse = "ctrl_bit_reverse_dis",// ctrl_bit_reverse_dis|ctrl_bit_reverse_en
        parameter hssi_10g_rx_pcs_data_bit_reverse = "data_bit_reverse_dis",// data_bit_reverse_dis|data_bit_reverse_en
        parameter hssi_10g_rx_pcs_dec64b66b_clken = "dec64b66b_clk_dis",// dec64b66b_clk_dis|dec64b66b_clk_en
        parameter hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass = "dec_64b66b_rxsm_bypass_dis",// dec_64b66b_rxsm_bypass_dis|dec_64b66b_rxsm_bypass_en
        parameter hssi_10g_rx_pcs_descrm_bypass  = "descrm_bypass_en",  // descrm_bypass_dis|descrm_bypass_en
        parameter hssi_10g_rx_pcs_descrm_clken   = "descrm_clk_dis",    // descrm_clk_dis|descrm_clk_en
        parameter hssi_10g_rx_pcs_descrm_mode    = "async",             // async|sync
        parameter hssi_10g_rx_pcs_descrm_pipeln  = "enable",            // disable|enable
        parameter hssi_10g_rx_pcs_dft_clk_out_sel = "rx_master_clk",    // rx_master_clk|rx_gbexp_clk|rx_blksync_clk|rx_descrm_clk|rx_frmsync_clk|rx_64b66bdec_clk|rx_ber_clk|rx_rand_clk|rx_crcchk_clk|rx_wrfifo_clk|rx_rdfifo_clk|rx_fec_clk
        parameter hssi_10g_rx_pcs_dis_signal_ok  = "dis_signal_ok_dis", // dis_signal_ok_dis|dis_signal_ok_en
        parameter hssi_10g_rx_pcs_dispchk_bypass = "dispchk_bypass_dis",// dispchk_bypass_dis|dispchk_bypass_en
        parameter hssi_10g_rx_pcs_empty_flag_type = "empty_rd_side",    // empty_rd_side|empty_wr_side
        parameter hssi_10g_rx_pcs_fast_path      = "fast_path_dis",     // fast_path_dis|fast_path_en
        parameter hssi_10g_rx_pcs_fec_clken      = "fec_clk_dis",       // fec_clk_dis|fec_clk_en
        parameter hssi_10g_rx_pcs_fec_enable     = "fec_dis",           // fec_en|fec_dis
        parameter hssi_10g_rx_pcs_fifo_double_read = "fifo_double_read_dis",// fifo_double_read_dis|fifo_double_read_en
        parameter hssi_10g_rx_pcs_fifo_stop_rd   = "n_rd_empty",        // rd_empty|n_rd_empty
        parameter hssi_10g_rx_pcs_fifo_stop_wr   = "n_wr_full",         // wr_full|n_wr_full
        parameter hssi_10g_rx_pcs_force_align    = "force_align_dis",   // force_align_dis|force_align_en
        parameter hssi_10g_rx_pcs_frmsync_bypass = "frmsync_bypass_dis",// frmsync_bypass_dis|frmsync_bypass_en
        parameter hssi_10g_rx_pcs_frmsync_clken  = "frmsync_clk_dis",   // frmsync_clk_dis|frmsync_clk_en
        parameter hssi_10g_rx_pcs_frmsync_enum_scrm = "enum_scrm_default",// enum_scrm_default
        parameter hssi_10g_rx_pcs_frmsync_enum_sync = "enum_sync_default",// enum_sync_default
        parameter hssi_10g_rx_pcs_frmsync_flag_type = "all_framing_words",// all_framing_words|location_only
        parameter hssi_10g_rx_pcs_frmsync_knum_sync = "knum_sync_default",// knum_sync_default
        parameter hssi_10g_rx_pcs_frmsync_mfrm_length = 16'b100000000000,
        parameter hssi_10g_rx_pcs_frmsync_pipeln = "frmsync_pipeln_dis",// frmsync_pipeln_dis|frmsync_pipeln_en
        parameter hssi_10g_rx_pcs_full_flag_type = "full_wr_side",      // full_rd_side|full_wr_side
        parameter hssi_10g_rx_pcs_gb_rx_idwidth  = "width_32",          // width_40|width_32|width_64
        parameter hssi_10g_rx_pcs_gb_rx_odwidth  = "width_66",          // width_32|width_40|width_50|width_67|width_64|width_66
        parameter hssi_10g_rx_pcs_gbexp_clken    = "gbexp_clk_dis",     // gbexp_clk_dis|gbexp_clk_en
        parameter hssi_10g_rx_pcs_low_latency_en = "enable",            // disable|enable
        parameter hssi_10g_rx_pcs_lpbk_mode      = "lpbk_dis",          // lpbk_dis|lpbk_en
        parameter hssi_10g_rx_pcs_master_clk_sel = "master_rx_pma_clk", // master_rx_pma_clk|master_tx_pma_clk|master_refclk_dig
        parameter hssi_10g_rx_pcs_pempty_flag_type = "pempty_rd_side",  // pempty_rd_side|pempty_wr_side
        parameter hssi_10g_rx_pcs_pfull_flag_type = "pfull_wr_side",    // pfull_rd_side|pfull_wr_side
        parameter hssi_10g_rx_pcs_phcomp_rd_del  = "phcomp_rd_del2",    // phcomp_rd_del4|phcomp_rd_del3|phcomp_rd_del2
        parameter hssi_10g_rx_pcs_pld_if_type    = "fifo",              // fifo|reg
        parameter hssi_10g_rx_pcs_prot_mode      = "disable_mode",      // disable_mode|teng_baser_mode|interlaken_mode|sfis_mode|teng_sdi_mode|basic_mode|test_prp_mode|test_prp_krfec_mode|teng_1588_mode|teng_baser_krfec_mode|teng_1588_krfec_mode|basic_krfec_mode
        parameter hssi_10g_rx_pcs_rand_clken     = "rand_clk_dis",      // rand_clk_dis|rand_clk_en
        parameter hssi_10g_rx_pcs_rd_clk_sel     = "rd_rx_pma_clk",     // rd_rx_pld_clk|rd_rx_pma_clk|rd_refclk_dig
        parameter hssi_10g_rx_pcs_rdfifo_clken   = "rdfifo_clk_dis",    // rdfifo_clk_dis|rdfifo_clk_en
        parameter hssi_10g_rx_pcs_reconfig_settings = "{}",             //
        parameter hssi_10g_rx_pcs_rx_fifo_write_ctrl = "blklock_stops", // blklock_stops|blklock_ignore
        parameter hssi_10g_rx_pcs_rx_scrm_width  = "bit64",             // bit64|bit66|bit67
        parameter hssi_10g_rx_pcs_rx_sh_location = "lsb",               // lsb|msb
        parameter hssi_10g_rx_pcs_rx_signal_ok_sel = "synchronized_ver",// synchronized_ver|nonsync_ver
        parameter hssi_10g_rx_pcs_rx_sm_bypass   = "rx_sm_bypass_dis",  // rx_sm_bypass_dis|rx_sm_bypass_en
        parameter hssi_10g_rx_pcs_rx_sm_hiber    = "rx_sm_hiber_en",    // rx_sm_hiber_en|rx_sm_hiber_dis
        parameter hssi_10g_rx_pcs_rx_sm_pipeln   = "rx_sm_pipeln_dis",  // rx_sm_pipeln_dis|rx_sm_pipeln_en
        parameter hssi_10g_rx_pcs_rx_testbus_sel = "crc32_chk_testbus1",// crc32_chk_testbus1|crc32_chk_testbus2|frame_sync_testbus1|frame_sync_testbus2|dec64b66b_testbus|rxsm_testbus|ber_testbus|blksync_testbus1|blksync_testbus2|gearbox_exp_testbus|random_ver_testbus|descramble_testbus|blank_testbus|rx_fifo_testbus1|rx_fifo_testbus2
        parameter hssi_10g_rx_pcs_rx_true_b2b    = "b2b",               // single|b2b
        parameter hssi_10g_rx_pcs_rxfifo_empty   = "empty_default",     // empty_default
        parameter hssi_10g_rx_pcs_rxfifo_full    = "full_default",      // full_default
        parameter hssi_10g_rx_pcs_rxfifo_mode    = "phase_comp",        // register_mode|clk_comp_10g|generic_interlaken|generic_basic|phase_comp|phase_comp_dv
        parameter hssi_10g_rx_pcs_rxfifo_pempty  = 5'b10,
        parameter hssi_10g_rx_pcs_rxfifo_pfull   = 5'b10111,
        parameter hssi_10g_rx_pcs_stretch_num_stages = "zero_stage",    // zero_stage|one_stage|two_stage|three_stage
        parameter hssi_10g_rx_pcs_sup_mode       = "user_mode",         // user_mode|engineering_mode
        parameter hssi_10g_rx_pcs_test_mode      = "test_off",          // test_off|pseudo_random
        parameter hssi_10g_rx_pcs_wrfifo_clken   = "wrfifo_clk_dis",    // wrfifo_clk_dis|wrfifo_clk_en
    // parameters for twentynm_hssi_10g_tx_pcs
        parameter hssi_10g_tx_pcs_advanced_user_mode = "disable",       // disable|enable
        parameter hssi_10g_tx_pcs_bitslip_en     = "bitslip_dis",       // bitslip_dis|bitslip_en
        parameter hssi_10g_tx_pcs_bonding_dft_en = "dft_dis",           // dft_dis|dft_en
        parameter hssi_10g_tx_pcs_bonding_dft_val = "dft_0",            // dft_0|dft_1
        parameter hssi_10g_tx_pcs_comp_cnt       = 8'b0,
        parameter hssi_10g_tx_pcs_compin_sel     = "compin_master",     // compin_master|compin_slave_top|compin_slave_bot|compin_default
        parameter hssi_10g_tx_pcs_crcgen_bypass  = "crcgen_bypass_dis", // crcgen_bypass_dis|crcgen_bypass_en
        parameter hssi_10g_tx_pcs_crcgen_clken   = "crcgen_clk_dis",    // crcgen_clk_dis|crcgen_clk_en
        parameter hssi_10g_tx_pcs_crcgen_err     = "crcgen_err_dis",    // crcgen_err_dis|crcgen_err_en
        parameter hssi_10g_tx_pcs_crcgen_inv     = "crcgen_inv_dis",    // crcgen_inv_dis|crcgen_inv_en
        parameter hssi_10g_tx_pcs_ctrl_bit_reverse = "ctrl_bit_reverse_dis",// ctrl_bit_reverse_dis|ctrl_bit_reverse_en
        parameter hssi_10g_tx_pcs_ctrl_plane_bonding = "individual",    // individual|ctrl_master|ctrl_slave_abv|ctrl_slave_blw
        parameter hssi_10g_tx_pcs_data_bit_reverse = "data_bit_reverse_dis",// data_bit_reverse_dis|data_bit_reverse_en
        parameter hssi_10g_tx_pcs_dft_clk_out_sel = "tx_master_clk",    // tx_master_clk|tx_rdfifo_clk|tx_frmgen_clk|tx_crcgen_clk|tx_64b66benc_txsm_clk|tx_scrm_clk|tx_dispgen_clk|tx_gbred_clk|tx_wrfifo_clk|tx_fec_clk
        parameter hssi_10g_tx_pcs_dispgen_bypass = "dispgen_bypass_dis",// dispgen_bypass_dis|dispgen_bypass_en
        parameter hssi_10g_tx_pcs_dispgen_clken  = "dispgen_clk_dis",   // dispgen_clk_dis|dispgen_clk_en
        parameter hssi_10g_tx_pcs_dispgen_err    = "dispgen_err_dis",   // dispgen_err_dis|dispgen_err_en
        parameter hssi_10g_tx_pcs_dispgen_pipeln = "dispgen_pipeln_dis",// dispgen_pipeln_dis|dispgen_pipeln_en
        parameter hssi_10g_tx_pcs_distdwn_bypass_pipeln = "distdwn_bypass_pipeln_dis",// distdwn_bypass_pipeln_dis|distdwn_bypass_pipeln_en
        parameter hssi_10g_tx_pcs_distdwn_master = "distdwn_master_en", // distdwn_master_en|distdwn_master_dis
        parameter hssi_10g_tx_pcs_distup_bypass_pipeln = "distup_bypass_pipeln_dis",// distup_bypass_pipeln_dis|distup_bypass_pipeln_en
        parameter hssi_10g_tx_pcs_distup_master  = "distup_master_en",  // distup_master_en|distup_master_dis
        parameter hssi_10g_tx_pcs_dv_bond        = "dv_bond_dis",       // dv_bond_en|dv_bond_dis
        parameter hssi_10g_tx_pcs_empty_flag_type = "empty_rd_side",    // empty_rd_side|empty_wr_side
        parameter hssi_10g_tx_pcs_enc64b66b_txsm_clken = "enc64b66b_txsm_clk_dis",// enc64b66b_txsm_clk_dis|enc64b66b_txsm_clk_en
        parameter hssi_10g_tx_pcs_enc_64b66b_txsm_bypass = "enc_64b66b_txsm_bypass_dis",// enc_64b66b_txsm_bypass_dis|enc_64b66b_txsm_bypass_en
        parameter hssi_10g_tx_pcs_fastpath       = "fastpath_dis",      // fastpath_dis|fastpath_en
        parameter hssi_10g_tx_pcs_fec_clken      = "fec_clk_dis",       // fec_clk_dis|fec_clk_en
        parameter hssi_10g_tx_pcs_fec_enable     = "fec_dis",           // fec_en|fec_dis
        parameter hssi_10g_tx_pcs_fifo_double_write = "fifo_double_write_dis",// fifo_double_write_dis|fifo_double_write_en
        parameter hssi_10g_tx_pcs_fifo_reg_fast  = "fifo_reg_fast_dis", // fifo_reg_fast_dis|fifo_reg_fast_en
        parameter hssi_10g_tx_pcs_fifo_stop_rd   = "n_rd_empty",        // rd_empty|n_rd_empty
        parameter hssi_10g_tx_pcs_fifo_stop_wr   = "n_wr_full",         // wr_full|n_wr_full
        parameter hssi_10g_tx_pcs_frmgen_burst   = "frmgen_burst_dis",  // frmgen_burst_dis|frmgen_burst_en
        parameter hssi_10g_tx_pcs_frmgen_bypass  = "frmgen_bypass_dis", // frmgen_bypass_dis|frmgen_bypass_en
        parameter hssi_10g_tx_pcs_frmgen_clken   = "frmgen_clk_dis",    // frmgen_clk_dis|frmgen_clk_en
        parameter hssi_10g_tx_pcs_frmgen_mfrm_length = 16'b100000000000,
        parameter hssi_10g_tx_pcs_frmgen_pipeln  = "frmgen_pipeln_dis", // frmgen_pipeln_dis|frmgen_pipeln_en
        parameter hssi_10g_tx_pcs_frmgen_pyld_ins = "frmgen_pyld_ins_dis",// frmgen_pyld_ins_dis|frmgen_pyld_ins_en
        parameter hssi_10g_tx_pcs_frmgen_wordslip = "frmgen_wordslip_dis",// frmgen_wordslip_dis|frmgen_wordslip_en
        parameter hssi_10g_tx_pcs_full_flag_type = "full_wr_side",      // full_rd_side|full_wr_side
        parameter hssi_10g_tx_pcs_gb_pipeln_bypass = "enable",          // disable|enable
        parameter hssi_10g_tx_pcs_gb_tx_idwidth  = "width_50",          // width_32|width_40|width_50|width_67|width_64|width_66
        parameter hssi_10g_tx_pcs_gb_tx_odwidth  = "width_32",          // width_32|width_40|width_64
        parameter hssi_10g_tx_pcs_gbred_clken    = "gbred_clk_dis",     // gbred_clk_dis|gbred_clk_en
        parameter hssi_10g_tx_pcs_indv           = "indv_en",           // indv_en|indv_dis
        parameter hssi_10g_tx_pcs_low_latency_en = "enable",            // disable|enable
        parameter hssi_10g_tx_pcs_master_clk_sel = "master_tx_pma_clk", // master_tx_pma_clk|master_refclk_dig
        parameter hssi_10g_tx_pcs_pempty_flag_type = "pempty_rd_side",  // pempty_rd_side|pempty_wr_side
        parameter hssi_10g_tx_pcs_pfull_flag_type = "pfull_wr_side",    // pfull_rd_side|pfull_wr_side
        parameter hssi_10g_tx_pcs_phcomp_rd_del  = "phcomp_rd_del2",    // phcomp_rd_del6|phcomp_rd_del5|phcomp_rd_del4|phcomp_rd_del3|phcomp_rd_del2
        parameter hssi_10g_tx_pcs_pld_if_type    = "fifo",              // fifo|reg|fastreg
        parameter hssi_10g_tx_pcs_prot_mode      = "disable_mode",      // disable_mode|teng_baser_mode|interlaken_mode|sfis_mode|teng_sdi_mode|basic_mode|test_prp_mode|test_prp_krfec_mode|teng_1588_mode|teng_baser_krfec_mode|teng_1588_krfec_mode|basic_krfec_mode
        parameter hssi_10g_tx_pcs_pseudo_random  = "all_0",             // two_lf|all_0
        parameter hssi_10g_tx_pcs_pseudo_seed_a  = 58'b1111111111111111111111111111111111111111111111111111111111,
        parameter hssi_10g_tx_pcs_pseudo_seed_b  = 58'b1111111111111111111111111111111111111111111111111111111111,
        parameter hssi_10g_tx_pcs_random_disp    = "disable",           // disable|enable
        parameter hssi_10g_tx_pcs_rdfifo_clken   = "rdfifo_clk_dis",    // rdfifo_clk_dis|rdfifo_clk_en
        parameter hssi_10g_tx_pcs_reconfig_settings = "{}",             //
        parameter hssi_10g_tx_pcs_scrm_bypass    = "scrm_bypass_dis",   // scrm_bypass_dis|scrm_bypass_en
        parameter hssi_10g_tx_pcs_scrm_clken     = "scrm_clk_dis",      // scrm_clk_dis|scrm_clk_en
        parameter hssi_10g_tx_pcs_scrm_mode      = "async",             // async|sync
        parameter hssi_10g_tx_pcs_scrm_pipeln    = "enable",            // disable|enable
        parameter hssi_10g_tx_pcs_sh_err         = "sh_err_dis",        // sh_err_dis|sh_err_en
        parameter hssi_10g_tx_pcs_sop_mark       = "sop_mark_dis",      // sop_mark_en|sop_mark_dis
        parameter hssi_10g_tx_pcs_stretch_num_stages = "zero_stage",    // zero_stage|one_stage|two_stage|three_stage
        parameter hssi_10g_tx_pcs_sup_mode       = "user_mode",         // user_mode|engineering_mode
        parameter hssi_10g_tx_pcs_test_mode      = "test_off",          // test_off|pseudo_random
        parameter hssi_10g_tx_pcs_tx_scrm_err    = "scrm_err_dis",      // scrm_err_dis|scrm_err_en
        parameter hssi_10g_tx_pcs_tx_scrm_width  = "bit64",             // bit64|bit66|bit67
        parameter hssi_10g_tx_pcs_tx_sh_location = "lsb",               // lsb|msb
        parameter hssi_10g_tx_pcs_tx_sm_bypass   = "tx_sm_bypass_dis",  // tx_sm_bypass_dis|tx_sm_bypass_en
        parameter hssi_10g_tx_pcs_tx_sm_pipeln   = "tx_sm_pipeln_dis",  // tx_sm_pipeln_dis|tx_sm_pipeln_en
        parameter hssi_10g_tx_pcs_tx_testbus_sel = "crc32_gen_testbus1",// crc32_gen_testbus1|crc32_gen_testbus2|disp_gen_testbus1|disp_gen_testbus2|frame_gen_testbus1|frame_gen_testbus2|enc64b66b_testbus|txsm_testbus|tx_cp_bond_testbus|gearbox_red_testbus|scramble_testbus|blank_testbus|tx_fifo_testbus1|tx_fifo_testbus2
        parameter hssi_10g_tx_pcs_txfifo_empty   = "empty_default",     // empty_default
        parameter hssi_10g_tx_pcs_txfifo_full    = "full_default",      // full_default
        parameter hssi_10g_tx_pcs_txfifo_mode    = "phase_comp",        // register_mode|interlaken_generic|basic_generic|phase_comp
        parameter hssi_10g_tx_pcs_txfifo_pempty  = 4'b10,
        parameter hssi_10g_tx_pcs_txfifo_pfull   = 4'b1011,
        parameter hssi_10g_tx_pcs_wr_clk_sel     = "wr_tx_pma_clk",     // wr_tx_pld_clk|wr_tx_pma_clk|wr_refclk_dig
        parameter hssi_10g_tx_pcs_wrfifo_clken   = "wrfifo_clk_dis",    // wrfifo_clk_dis|wrfifo_clk_en
    // parameters for twentynm_hssi_8g_rx_pcs
        parameter hssi_8g_rx_pcs_auto_error_replacement = "dis_err_replace",// dis_err_replace|en_err_replace
        parameter hssi_8g_rx_pcs_auto_speed_nego = "dis_asn",           // dis_asn|en_asn_g2_freq_scal
        parameter hssi_8g_rx_pcs_bit_reversal    = "dis_bit_reversal",  // dis_bit_reversal|en_bit_reversal
        parameter hssi_8g_rx_pcs_bonding_dft_en  = "dft_dis",           // dft_dis|dft_en
        parameter hssi_8g_rx_pcs_bonding_dft_val = "dft_0",             // dft_0|dft_1
        parameter hssi_8g_rx_pcs_bypass_pipeline_reg = "dis_bypass_pipeline",// dis_bypass_pipeline|en_bypass_pipeline
        parameter hssi_8g_rx_pcs_byte_deserializer = "dis_bds",         // dis_bds|en_bds_by_2|en_bds_by_4|en_bds_by_2_det
        parameter hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask = "dis_rxvalid_mask",// dis_rxvalid_mask|en_rxvalid_mask
        parameter hssi_8g_rx_pcs_clkcmp_pattern_n = 20'b0,
        parameter hssi_8g_rx_pcs_clkcmp_pattern_p = 20'b0,
        parameter hssi_8g_rx_pcs_clock_gate_bds_dec_asn = "dis_bds_dec_asn_clk_gating",// dis_bds_dec_asn_clk_gating|en_bds_dec_asn_clk_gating
        parameter hssi_8g_rx_pcs_clock_gate_cdr_eidle = "dis_cdr_eidle_clk_gating",// dis_cdr_eidle_clk_gating|en_cdr_eidle_clk_gating
        parameter hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk = "dis_dw_pc_wrclk_gating",// dis_dw_pc_wrclk_gating|en_dw_pc_wrclk_gating
        parameter hssi_8g_rx_pcs_clock_gate_dw_rm_rd = "dis_dw_rm_rdclk_gating",// dis_dw_rm_rdclk_gating|en_dw_rm_rdclk_gating
        parameter hssi_8g_rx_pcs_clock_gate_dw_rm_wr = "dis_dw_rm_wrclk_gating",// dis_dw_rm_wrclk_gating|en_dw_rm_wrclk_gating
        parameter hssi_8g_rx_pcs_clock_gate_dw_wa = "dis_dw_wa_clk_gating",// dis_dw_wa_clk_gating|en_dw_wa_clk_gating
        parameter hssi_8g_rx_pcs_clock_gate_pc_rdclk = "dis_pc_rdclk_gating",// dis_pc_rdclk_gating|en_pc_rdclk_gating
        parameter hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk = "dis_sw_pc_wrclk_gating",// dis_sw_pc_wrclk_gating|en_sw_pc_wrclk_gating
        parameter hssi_8g_rx_pcs_clock_gate_sw_rm_rd = "dis_sw_rm_rdclk_gating",// dis_sw_rm_rdclk_gating|en_sw_rm_rdclk_gating
        parameter hssi_8g_rx_pcs_clock_gate_sw_rm_wr = "dis_sw_rm_wrclk_gating",// dis_sw_rm_wrclk_gating|en_sw_rm_wrclk_gating
        parameter hssi_8g_rx_pcs_clock_gate_sw_wa = "dis_sw_wa_clk_gating",// dis_sw_wa_clk_gating|en_sw_wa_clk_gating
        parameter hssi_8g_rx_pcs_clock_observation_in_pld_core = "internal_sw_wa_clk",// internal_sw_wa_clk|internal_dw_wa_clk|internal_cdr_eidle_clk|internal_sm_rm_wr_clk|internal_dw_rm_wr_clk|internal_clk_2_b|internal_sw_rm_rd_clk|internal_dw_rm_rd_clk|internal_sw_rx_wr_clk|internal_dw_rx_wr_clk|internal_rx_rd_clk|internal_rx_pma_clk_gen3|internal_rx_rcvd_clk_gen3
        parameter hssi_8g_rx_pcs_ctrl_plane_bonding_compensation = "dis_compensation",// dis_compensation|en_compensation
        parameter hssi_8g_rx_pcs_ctrl_plane_bonding_consumption = "individual",// individual|bundled_master|bundled_slave_below|bundled_slave_above
        parameter hssi_8g_rx_pcs_ctrl_plane_bonding_distribution = "not_master_chnl_distr",// not_master_chnl_distr|master_chnl_distr
        parameter hssi_8g_rx_pcs_eidle_entry_eios = "dis_eidle_eios",   // dis_eidle_eios|en_eidle_eios
        parameter hssi_8g_rx_pcs_eidle_entry_iei = "dis_eidle_iei",     // dis_eidle_iei|en_eidle_iei
        parameter hssi_8g_rx_pcs_eidle_entry_sd  = "dis_eidle_sd",      // dis_eidle_sd|en_eidle_sd
        parameter hssi_8g_rx_pcs_eightb_tenb_decoder = "dis_8b10b",     // dis_8b10b|en_8b10b_ibm|en_8b10b_sgx
        parameter hssi_8g_rx_pcs_err_flags_sel   = "err_flags_wa",      // err_flags_wa|err_flags_8b10b
        parameter hssi_8g_rx_pcs_fixed_pat_det   = "dis_fixed_patdet",  // dis_fixed_patdet|en_fixed_patdet
        parameter hssi_8g_rx_pcs_fixed_pat_num   = 4'b1111,
        parameter hssi_8g_rx_pcs_force_signal_detect = "en_force_signal_detect",// en_force_signal_detect|dis_force_signal_detect
        parameter hssi_8g_rx_pcs_gen3_clk_en     = "disable_clk",       // disable_clk|enable_clk
        parameter hssi_8g_rx_pcs_gen3_rx_clk_sel = "rcvd_clk",          // en_dig_clk1_8g|rcvd_clk
        parameter hssi_8g_rx_pcs_gen3_tx_clk_sel = "tx_pma_clk",        // en_dig_clk2_8g|tx_pma_clk
        parameter hssi_8g_rx_pcs_hip_mode        = "dis_hip",           // dis_hip|en_hip
        parameter hssi_8g_rx_pcs_ibm_invalid_code = "dis_ibm_invalid_code",// dis_ibm_invalid_code|en_ibm_invalid_code
        parameter hssi_8g_rx_pcs_invalid_code_flag_only = "dis_invalid_code_only",// dis_invalid_code_only|en_invalid_code_only
        parameter hssi_8g_rx_pcs_pad_or_edb_error_replace = "replace_edb",// replace_edb|replace_edb_dynamic|replace_pad
        parameter hssi_8g_rx_pcs_pcs_bypass      = "dis_pcs_bypass",    // dis_pcs_bypass|en_pcs_bypass
        parameter hssi_8g_rx_pcs_phase_comp_rdptr = "enable_rdptr",     // disable_rdptr|enable_rdptr
        parameter hssi_8g_rx_pcs_phase_compensation_fifo = "low_latency",// low_latency|normal_latency|register_fifo|pld_ctrl_low_latency|pld_ctrl_normal_latency
        parameter hssi_8g_rx_pcs_pipe_if_enable  = "dis_pipe_rx",       // dis_pipe_rx|en_pipe_rx|en_pipe3_rx
        parameter hssi_8g_rx_pcs_pma_dw          = "eight_bit",         // eight_bit|ten_bit|sixteen_bit|twenty_bit
        parameter hssi_8g_rx_pcs_polinv_8b10b_dec = "dis_polinv_8b10b_dec",// dis_polinv_8b10b_dec|en_polinv_8b10b_dec
        parameter hssi_8g_rx_pcs_prot_mode       = "gige",              // pipe_g1|pipe_g2|pipe_g3|cpri|cpri_rx_tx|gige|gige_1588|basic_rm_enable|basic_rm_disable|disabled_prot_mode
        parameter hssi_8g_rx_pcs_rate_match      = "dis_rm",            // dis_rm|gige_rm|pipe_rm|pipe_rm_0ppm|sw_basic_rm|dw_basic_rm
        parameter hssi_8g_rx_pcs_rate_match_del_thres = "dis_rm_del_thres",// dis_rm_del_thres|gige_rm_del_thres|pipe_rm_del_thres|pipe_rm_0ppm_del_thres|sw_basic_rm_del_thres|dw_basic_rm_del_thres
        parameter hssi_8g_rx_pcs_rate_match_empty_thres = "dis_rm_empty_thres",// dis_rm_empty_thres|gige_rm_empty_thres|pipe_rm_empty_thres|pipe_rm_0ppm_empty_thres|sw_basic_rm_empty_thres|dw_basic_rm_empty_thres
        parameter hssi_8g_rx_pcs_rate_match_full_thres = "dis_rm_full_thres",// dis_rm_full_thres|gige_rm_full_thres|pipe_rm_full_thres|pipe_rm_0ppm_full_thres|sw_basic_rm_full_thres|dw_basic_rm_full_thres
        parameter hssi_8g_rx_pcs_rate_match_ins_thres = "dis_rm_ins_thres",// dis_rm_ins_thres|gige_rm_ins_thres|pipe_rm_ins_thres|pipe_rm_0ppm_ins_thres|sw_basic_rm_ins_thres|dw_basic_rm_ins_thres
        parameter hssi_8g_rx_pcs_rate_match_start_thres = "dis_rm_start_thres",// dis_rm_start_thres|gige_rm_start_thres|pipe_rm_start_thres|pipe_rm_0ppm_start_thres|sw_basic_rm_start_thres|dw_basic_rm_start_thres
        parameter hssi_8g_rx_pcs_reconfig_settings = "{}",              //
        parameter hssi_8g_rx_pcs_rx_clk2         = "rcvd_clk_clk2",     // rcvd_clk_clk2|tx_pma_clock_clk2|refclk_dig2_clk2
        parameter hssi_8g_rx_pcs_rx_clk_free_running = "en_rx_clk_free_run",// dis_rx_clk_free_run|en_rx_clk_free_run
        parameter hssi_8g_rx_pcs_rx_pcs_urst     = "en_rx_pcs_urst",    // dis_rx_pcs_urst|en_rx_pcs_urst
        parameter hssi_8g_rx_pcs_rx_rcvd_clk     = "rcvd_clk_rcvd_clk", // rcvd_clk_rcvd_clk|tx_pma_clock_rcvd_clk
        parameter hssi_8g_rx_pcs_rx_rd_clk       = "pld_rx_clk",        // pld_rx_clk|rx_clk
        parameter hssi_8g_rx_pcs_rx_refclk       = "dis_refclk_sel",    // dis_refclk_sel|en_refclk_sel
        parameter hssi_8g_rx_pcs_rx_wr_clk       = "rx_clk2_div_1_2_4", // rx_clk2_div_1_2_4|txfifo_rd_clk
        parameter hssi_8g_rx_pcs_sup_mode        = "user_mode",         // user_mode|engineering_mode
        parameter hssi_8g_rx_pcs_symbol_swap     = "dis_symbol_swap",   // dis_symbol_swap|en_symbol_swap
        parameter hssi_8g_rx_pcs_sync_sm_idle_eios = "dis_syncsm_idle", // dis_syncsm_idle|en_syncsm_idle
        parameter hssi_8g_rx_pcs_test_bus_sel    = "tx_testbus",        // tx_testbus|tx_ctrl_plane_testbus|wa_testbus|rm_testbus|rx_ctrl_testbus|pcie_ctrl_testbus|rx_ctrl_plane_testbus
        parameter hssi_8g_rx_pcs_tx_rx_parallel_loopback = "dis_plpbk", // dis_plpbk|en_plpbk
        parameter hssi_8g_rx_pcs_wa_boundary_lock_ctrl = "bit_slip",    // bit_slip|sync_sm|deterministic_latency|auto_align_pld_ctrl
        parameter hssi_8g_rx_pcs_wa_clk_slip_spacing = 10'b10000,
        parameter hssi_8g_rx_pcs_wa_det_latency_sync_status_beh = "assert_sync_status_non_imm",// assert_sync_status_imm|assert_sync_status_non_imm|dont_care_assert_sync
        parameter hssi_8g_rx_pcs_wa_disp_err_flag = "dis_disp_err_flag",// dis_disp_err_flag|en_disp_err_flag
        parameter hssi_8g_rx_pcs_wa_kchar        = "dis_kchar",         // dis_kchar|en_kchar
        parameter hssi_8g_rx_pcs_wa_pd           = "wa_pd_10",          // wa_pd_7|wa_pd_10|wa_pd_20|wa_pd_40|wa_pd_8_sw|wa_pd_8_dw|wa_pd_16_sw|wa_pd_16_dw|wa_pd_32
        parameter hssi_8g_rx_pcs_wa_pd_data      = 40'b0,
        parameter hssi_8g_rx_pcs_wa_pd_polarity  = "dis_pd_both_pol",   // dis_pd_both_pol|en_pd_both_pol|dont_care_both_pol
        parameter hssi_8g_rx_pcs_wa_pld_controlled = "dis_pld_ctrl",    // dis_pld_ctrl|pld_ctrl_sw|rising_edge_sensitive_dw|level_sensitive_dw
        parameter hssi_8g_rx_pcs_wa_renumber_data = 6'b0,
        parameter hssi_8g_rx_pcs_wa_rgnumber_data = 8'b0,
        parameter hssi_8g_rx_pcs_wa_rknumber_data = 8'b0,
        parameter hssi_8g_rx_pcs_wa_rosnumber_data = 2'b0,
        parameter hssi_8g_rx_pcs_wa_rvnumber_data = 13'b0,
        parameter hssi_8g_rx_pcs_wa_sync_sm_ctrl = "gige_sync_sm",      // gige_sync_sm|pipe_sync_sm|sw_basic_sync_sm|dw_basic_sync_sm|fibre_channel_sync_sm
        parameter hssi_8g_rx_pcs_wait_cnt        = 12'b0,
    // parameters for twentynm_hssi_8g_tx_pcs
        parameter hssi_8g_tx_pcs_auto_speed_nego_gen2 = "dis_asn_g2",   // dis_asn_g2|en_asn_g2_freq_scal
        parameter hssi_8g_tx_pcs_bit_reversal    = "dis_bit_reversal",  // dis_bit_reversal|en_bit_reversal
        parameter hssi_8g_tx_pcs_bonding_dft_en  = "dft_dis",           // dft_dis|dft_en
        parameter hssi_8g_tx_pcs_bonding_dft_val = "dft_0",             // dft_0|dft_1
        parameter hssi_8g_tx_pcs_bypass_pipeline_reg = "dis_bypass_pipeline",// dis_bypass_pipeline|en_bypass_pipeline
        parameter hssi_8g_tx_pcs_byte_serializer = "dis_bs",            // dis_bs|en_bs_by_2|en_bs_by_4
        parameter hssi_8g_tx_pcs_clock_gate_bs_enc = "dis_bs_enc_clk_gating",// dis_bs_enc_clk_gating|en_bs_enc_clk_gating
        parameter hssi_8g_tx_pcs_clock_gate_dw_fifowr = "dis_dw_fifowr_clk_gating",// dis_dw_fifowr_clk_gating|en_dw_fifowr_clk_gating
        parameter hssi_8g_tx_pcs_clock_gate_fiford = "dis_fiford_clk_gating",// dis_fiford_clk_gating|en_fiford_clk_gating
        parameter hssi_8g_tx_pcs_clock_gate_sw_fifowr = "dis_sw_fifowr_clk_gating",// dis_sw_fifowr_clk_gating|en_sw_fifowr_clk_gating
        parameter hssi_8g_tx_pcs_clock_observation_in_pld_core = "internal_refclk_b",// internal_refclk_b|internal_fifo_rd_clk|internal_sw_fifo_wr_clk|internal_dw_fifo_wr_clk|internal_tx_clk_out_gen3|internal_pipe_tx_clk_out_gen3
        parameter hssi_8g_tx_pcs_ctrl_plane_bonding_compensation = "dis_compensation",// dis_compensation|en_compensation
        parameter hssi_8g_tx_pcs_ctrl_plane_bonding_consumption = "individual",// individual|bundled_master|bundled_slave_below|bundled_slave_above
        parameter hssi_8g_tx_pcs_ctrl_plane_bonding_distribution = "not_master_chnl_distr",// not_master_chnl_distr|master_chnl_distr
        parameter hssi_8g_tx_pcs_data_selection_8b10b_encoder_input = "normal_data_path",// normal_data_path|gige_idle_conversion
        parameter hssi_8g_tx_pcs_dynamic_clk_switch = "dis_dyn_clk_switch",// dis_dyn_clk_switch|en_dyn_clk_switch
        parameter hssi_8g_tx_pcs_eightb_tenb_disp_ctrl = "dis_disp_ctrl",// dis_disp_ctrl|en_disp_ctrl|en_ib_disp_ctrl
        parameter hssi_8g_tx_pcs_eightb_tenb_encoder = "dis_8b10b",     // dis_8b10b|en_8b10b_ibm|en_8b10b_sgx
        parameter hssi_8g_tx_pcs_force_echar     = "dis_force_echar",   // dis_force_echar|en_force_echar
        parameter hssi_8g_tx_pcs_force_kchar     = "dis_force_kchar",   // dis_force_kchar|en_force_kchar
        parameter hssi_8g_tx_pcs_gen3_tx_clk_sel = "tx_pma_clk",        // dis_tx_clk|tx_pma_clk
        parameter hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel = "func_clk",     // dis_tx_pipe_clk|func_clk
        parameter hssi_8g_tx_pcs_hip_mode        = "dis_hip",           // dis_hip|en_hip
        parameter hssi_8g_tx_pcs_pcs_bypass      = "dis_pcs_bypass",    // dis_pcs_bypass|en_pcs_bypass
        parameter hssi_8g_tx_pcs_phase_comp_rdptr = "enable_rdptr",     // disable_rdptr|enable_rdptr
        parameter hssi_8g_tx_pcs_phase_compensation_fifo = "low_latency",// low_latency|normal_latency|register_fifo|pld_ctrl_low_latency|pld_ctrl_normal_latency
        parameter hssi_8g_tx_pcs_phfifo_write_clk_sel = "pld_tx_clk",   // pld_tx_clk|tx_clk
        parameter hssi_8g_tx_pcs_pma_dw          = "eight_bit",         // eight_bit|ten_bit|sixteen_bit|twenty_bit
        parameter hssi_8g_tx_pcs_prot_mode       = "basic",             // pipe_g1|pipe_g2|pipe_g3|cpri|cpri_rx_tx|gige|gige_1588|basic|disabled_prot_mode
        parameter hssi_8g_tx_pcs_reconfig_settings = "{}",              //
        parameter hssi_8g_tx_pcs_refclk_b_clk_sel = "tx_pma_clock",     // tx_pma_clock|refclk_dig
        parameter hssi_8g_tx_pcs_revloop_back_rm = "dis_rev_loopback_rx_rm",// dis_rev_loopback_rx_rm|en_rev_loopback_rx_rm
        parameter hssi_8g_tx_pcs_sup_mode        = "user_mode",         // user_mode|engineering_mode
        parameter hssi_8g_tx_pcs_symbol_swap     = "dis_symbol_swap",   // dis_symbol_swap|en_symbol_swap
        parameter hssi_8g_tx_pcs_tx_bitslip      = "dis_tx_bitslip",    // dis_tx_bitslip|en_tx_bitslip
        parameter hssi_8g_tx_pcs_tx_compliance_controlled_disparity = "dis_txcompliance",// dis_txcompliance|en_txcompliance_pipe2p0|en_txcompliance_pipe3p0
        parameter hssi_8g_tx_pcs_tx_fast_pld_reg = "dis_tx_fast_pld_reg",// dis_tx_fast_pld_reg|en_tx_fast_pld_reg
        parameter hssi_8g_tx_pcs_txclk_freerun   = "dis_freerun_tx",    // dis_freerun_tx|en_freerun_tx
        parameter hssi_8g_tx_pcs_txpcs_urst      = "en_txpcs_urst",     // dis_txpcs_urst|en_txpcs_urst
    // parameters for twentynm_hssi_common_pcs_pma_interface
        parameter hssi_common_pcs_pma_interface_asn_clk_enable = "false",// false|true
        parameter hssi_common_pcs_pma_interface_asn_enable = "dis_asn", // dis_asn|en_asn
        parameter hssi_common_pcs_pma_interface_block_sel = "eight_g_pcs",// eight_g_pcs|pcie_gen3
        parameter hssi_common_pcs_pma_interface_bypass_early_eios = "false",// false|true
        parameter hssi_common_pcs_pma_interface_bypass_pcie_switch = "false",// false|true
        parameter hssi_common_pcs_pma_interface_bypass_pma_ltr = "false",// false|true
        parameter hssi_common_pcs_pma_interface_bypass_pma_sw_done = "false",// false|true
        parameter hssi_common_pcs_pma_interface_bypass_ppm_lock = "false",// false|true
        parameter hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp = "false",// false|true
        parameter hssi_common_pcs_pma_interface_bypass_txdetectrx = "false",// false|true
        parameter hssi_common_pcs_pma_interface_cdr_control = "en_cdr_ctrl",// dis_cdr_ctrl|en_cdr_ctrl
        parameter hssi_common_pcs_pma_interface_cid_enable = "en_cid_mode",// dis_cid_mode|en_cid_mode
        parameter hssi_common_pcs_pma_interface_cp_cons_sel = "cp_cons_default",// cp_cons_master|cp_cons_slave_abv|cp_cons_slave_blw|cp_cons_default
        parameter hssi_common_pcs_pma_interface_cp_dwn_mstr = "true",   // false|true
        parameter hssi_common_pcs_pma_interface_cp_up_mstr = "true",    // false|true
        parameter hssi_common_pcs_pma_interface_ctrl_plane_bonding = "individual",// individual|ctrl_master|ctrl_slave_blw|ctrl_slave_abv
        parameter hssi_common_pcs_pma_interface_data_mask_count = 16'b100111000100,
        parameter hssi_common_pcs_pma_interface_data_mask_count_multi = 3'b1,
        parameter hssi_common_pcs_pma_interface_dft_observation_clock_selection = "dft_clk_obsrv_tx0",// dft_clk_obsrv_tx0|dft_clk_obsrv_tx1|dft_clk_obsrv_tx2|dft_clk_obsrv_tx3|dft_clk_obsrv_tx4|dft_clk_obsrv_rx|dft_clk_obsrv_hclk|dft_clk_obsrv_fref|dft_clk_obsrv_clklow|dft_clk_obsrv_asn0|dft_clk_obsrv_asn1
        parameter hssi_common_pcs_pma_interface_early_eios_counter = 8'b110010,
        parameter hssi_common_pcs_pma_interface_force_freqdet = "force_freqdet_dis",// force_freqdet_dis|force1_freqdet_en|force0_freqdet_en
        parameter hssi_common_pcs_pma_interface_free_run_clk_enable = "true",// false|true
        parameter hssi_common_pcs_pma_interface_ignore_sigdet_g23 = "false",// false|true
        parameter hssi_common_pcs_pma_interface_pc_en_counter = 7'b110111,
        parameter hssi_common_pcs_pma_interface_pc_rst_counter = 5'b10111,
        parameter hssi_common_pcs_pma_interface_pcie_hip_mode = "hip_disable",// hip_enable|hip_disable
        parameter hssi_common_pcs_pma_interface_ph_fifo_reg_mode = "phfifo_reg_mode_dis",// phfifo_reg_mode_dis|phfifo_reg_mode_en
        parameter hssi_common_pcs_pma_interface_phfifo_flush_wait = 6'b100100,
        parameter hssi_common_pcs_pma_interface_pipe_if_g3pcs = "pipe_if_8gpcs",// pipe_if_g3pcs|pipe_if_8gpcs
        parameter hssi_common_pcs_pma_interface_pma_done_counter = 18'b101010101110011000,
        parameter hssi_common_pcs_pma_interface_pma_if_dft_en = "dft_dis",// dft_dis|dft_en
        parameter hssi_common_pcs_pma_interface_pma_if_dft_val = "dft_0",// dft_0|dft_1
        parameter hssi_common_pcs_pma_interface_ppm_cnt_rst = "ppm_cnt_rst_dis",// ppm_cnt_rst_dis|ppm_cnt_rst_en
        parameter hssi_common_pcs_pma_interface_ppm_deassert_early = "deassert_early_dis",// deassert_early_dis|deassert_early_en
        parameter hssi_common_pcs_pma_interface_ppm_det_buckets = "ppm_100_bucket",// disable_prot|ppm_300_bucket|ppm_100_bucket|ppm_300_100_bucket
        parameter hssi_common_pcs_pma_interface_ppm_gen1_2_cnt = "cnt_32k",// cnt_32k|cnt_64k
        parameter hssi_common_pcs_pma_interface_ppm_post_eidle_delay = "cnt_200_cycles",// cnt_200_cycles|cnt_400_cycles
        parameter hssi_common_pcs_pma_interface_ppmsel = "ppmsel_300",  // ppmsel_disable|ppmsel_5000|ppmsel_2500|ppmsel_1000|ppmsel_500|ppmsel_300|ppmsel_250|ppmsel_200|ppmsel_125|ppmsel_100|ppmsel_62p5|ppm_other
        parameter hssi_common_pcs_pma_interface_prot_mode = "disable_prot_mode",// disable_prot_mode|pipe_g12|pipe_g3|other_protocols
        parameter hssi_common_pcs_pma_interface_reconfig_settings = "{}",//
        parameter hssi_common_pcs_pma_interface_rxvalid_mask = "rxvalid_mask_en",// rxvalid_mask_dis|rxvalid_mask_en
        parameter hssi_common_pcs_pma_interface_sigdet_wait_counter = 12'b100111000100,
        parameter hssi_common_pcs_pma_interface_sigdet_wait_counter_multi = 3'b1,
        parameter hssi_common_pcs_pma_interface_sim_mode = "disable",   // disable|enable
        parameter hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en = "true",// false|true
        parameter hssi_common_pcs_pma_interface_sup_mode = "user_mode", // user_mode|engineering_mode
        parameter hssi_common_pcs_pma_interface_testout_sel = "ppm_det_test",// ppm_det_test|asn_test|pma_pll_test|rxpmaif_test|prbs_gen_test|prbs_ver_test|uhsif_1_test|uhsif_2_test|uhsif_3_test
        parameter hssi_common_pcs_pma_interface_wait_clk_on_off_timer = 4'b100,
        parameter hssi_common_pcs_pma_interface_wait_pipe_synchronizing = 5'b10111,
        parameter hssi_common_pcs_pma_interface_wait_send_syncp_fbkp = 11'b11111010,
    // parameters for twentynm_hssi_common_pld_pcs_interface
        parameter hssi_common_pld_pcs_interface_dft_clk_out_en = "dft_clk_out_disable",// dft_clk_out_disable|dft_clk_out_enable
        parameter hssi_common_pld_pcs_interface_dft_clk_out_sel = "teng_rx_dft_clk",// teng_rx_dft_clk|teng_tx_dft_clk|eightg_rx_dft_clk|eightg_tx_dft_clk|pmaif_dft_clk
        parameter hssi_common_pld_pcs_interface_hrdrstctrl_en = "hrst_dis",// hrst_dis|hrst_en
        parameter hssi_common_pld_pcs_interface_pcs_testbus_block_sel = "eightg",// eightg|g3pcs|teng|krfec|pma_if
        parameter hssi_common_pld_pcs_interface_reconfig_settings = "{}",//
    // parameters for twentynm_hssi_fifo_rx_pcs
        parameter hssi_fifo_rx_pcs_double_read_mode = "double_read_dis",// double_read_en|double_read_dis
        parameter hssi_fifo_rx_pcs_prot_mode     = "teng_mode",         // teng_mode|non_teng_mode
    // parameters for twentynm_hssi_fifo_tx_pcs
        parameter hssi_fifo_tx_pcs_double_write_mode = "double_write_dis",// double_write_en|double_write_dis
        parameter hssi_fifo_tx_pcs_prot_mode     = "teng_mode",         // teng_mode|non_teng_mode
    // parameters for twentynm_hssi_gen3_rx_pcs
        parameter hssi_gen3_rx_pcs_block_sync    = "enable_block_sync", // bypass_block_sync|enable_block_sync
        parameter hssi_gen3_rx_pcs_block_sync_sm = "enable_blk_sync_sm",// disable_blk_sync_sm|enable_blk_sync_sm
        parameter hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn = "enable",    // disable|enable
        parameter hssi_gen3_rx_pcs_lpbk_force    = "lpbk_frce_dis",     // lpbk_frce_dis|lpbk_frce_en
        parameter hssi_gen3_rx_pcs_mode          = "gen3_func",         // gen3_func|disable_pcs
        parameter hssi_gen3_rx_pcs_rate_match_fifo = "enable_rm_fifo_600ppm",// bypass_rm_fifo|enable_rm_fifo_600ppm|enable_rm_fifo_0ppm
        parameter hssi_gen3_rx_pcs_rate_match_fifo_latency = "regular_latency",// regular_latency|low_latency
        parameter hssi_gen3_rx_pcs_reconfig_settings = "{}",            //
        parameter hssi_gen3_rx_pcs_reverse_lpbk  = "rev_lpbk_en",       // rev_lpbk_dis|rev_lpbk_en
        parameter hssi_gen3_rx_pcs_rx_b4gb_par_lpbk = "b4gb_par_lpbk_dis",// b4gb_par_lpbk_dis|b4gb_par_lpbk_en
        parameter hssi_gen3_rx_pcs_rx_force_balign = "en_force_balign", // en_force_balign|dis_force_balign
        parameter hssi_gen3_rx_pcs_rx_ins_del_one_skip = "ins_del_one_skip_en",// ins_del_one_skip_dis|ins_del_one_skip_en
        parameter hssi_gen3_rx_pcs_rx_num_fixed_pat = 4'b1000,
        parameter hssi_gen3_rx_pcs_rx_test_out_sel = "rx_test_out0",    // rx_test_out0|rx_test_out1
        parameter hssi_gen3_rx_pcs_sup_mode      = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_gen3_tx_pcs
        parameter hssi_gen3_tx_pcs_mode          = "gen3_func",         // gen3_func|disable_pcs
        parameter hssi_gen3_tx_pcs_reverse_lpbk  = "rev_lpbk_en",       // rev_lpbk_dis|rev_lpbk_en
        parameter hssi_gen3_tx_pcs_sup_mode      = "user_mode",         // user_mode|engineering_mode
        parameter hssi_gen3_tx_pcs_tx_bitslip    = 5'b0,
        parameter hssi_gen3_tx_pcs_tx_gbox_byp   = "bypass_gbox",       // bypass_gbox|enable_gbox
    // parameters for twentynm_hssi_krfec_rx_pcs
        parameter hssi_krfec_rx_pcs_blksync_cor_en = "detect",          // detect|correct
        parameter hssi_krfec_rx_pcs_bypass_gb    = "bypass_dis",        // bypass_dis|bypass_en
        parameter hssi_krfec_rx_pcs_clr_ctrl     = "both_enabled",      // both_enabled|corr_cnt_only|uncorr_cnt_only
        parameter hssi_krfec_rx_pcs_ctrl_bit_reverse = "ctrl_bit_reverse_dis",// ctrl_bit_reverse_dis|ctrl_bit_reverse_en
        parameter hssi_krfec_rx_pcs_data_bit_reverse = "data_bit_reverse_dis",// data_bit_reverse_dis|data_bit_reverse_en
        parameter hssi_krfec_rx_pcs_dv_start     = "with_blklock",      // with_blksync|with_blklock
        parameter hssi_krfec_rx_pcs_err_mark_type = "err_mark_10g",     // err_mark_10g|err_mark_40g
        parameter hssi_krfec_rx_pcs_error_marking_en = "err_mark_dis",  // err_mark_dis|err_mark_en
        parameter hssi_krfec_rx_pcs_low_latency_en = "disable",         // disable|enable
        parameter hssi_krfec_rx_pcs_lpbk_mode    = "lpbk_dis",          // lpbk_dis|lpbk_en
        parameter hssi_krfec_rx_pcs_parity_invalid_enum = 8'b1000,
        parameter hssi_krfec_rx_pcs_parity_valid_num = 4'b100,
        parameter hssi_krfec_rx_pcs_pipeln_blksync = "enable",          // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_descrm = "enable",           // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_errcorrect = "enable",       // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_errtrap_ind = "enable",      // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_errtrap_lfsr = "enable",     // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_errtrap_loc = "enable",      // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_errtrap_pat = "enable",      // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_gearbox = "enable",          // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_syndrm = "enable",           // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_trans_dec = "enable",        // disable|enable
        parameter hssi_krfec_rx_pcs_prot_mode    = "disable_mode",      // disable_mode|teng_basekr_mode|fortyg_basekr_mode|teng_1588_basekr_mode|basic_mode
        parameter hssi_krfec_rx_pcs_receive_order = "receive_lsb",      // receive_lsb|receive_msb
        parameter hssi_krfec_rx_pcs_reconfig_settings = "{}",           //
        parameter hssi_krfec_rx_pcs_rx_testbus_sel = "overall",         // overall|fast_search|fast_search_cntrs|blksync|blksync_cntrs|decoder_master_sm|decoder_master_sm_cntrs|syndrm_sm|syndrm1|syndrm2|errtrap_sm|errtrap_ind1|errtrap_ind2|errtrap_ind3|errtrap_ind4|errtrap_ind5|errtrap_loc|errtrap_pat1|errtrap_pat2|errtrap_pat3|errtrap_pat4|decoder_rd_sm|gb_and_trans
        parameter hssi_krfec_rx_pcs_signal_ok_en = "sig_ok_dis",        // sig_ok_dis|sig_ok_en
        parameter hssi_krfec_rx_pcs_sup_mode     = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_krfec_tx_pcs
        parameter hssi_krfec_tx_pcs_burst_err    = "burst_err_dis",     // burst_err_dis|burst_err_en
        parameter hssi_krfec_tx_pcs_burst_err_len = "burst_err_len1",   // burst_err_len1|burst_err_len2|burst_err_len3|burst_err_len4|burst_err_len5|burst_err_len6|burst_err_len7|burst_err_len8|burst_err_len9|burst_err_len10|burst_err_len11|burst_err_len12|burst_err_len13|burst_err_len14|burst_err_len15|burst_err_len16
        parameter hssi_krfec_tx_pcs_ctrl_bit_reverse = "ctrl_bit_reverse_dis",// ctrl_bit_reverse_dis|ctrl_bit_reverse_en
        parameter hssi_krfec_tx_pcs_data_bit_reverse = "data_bit_reverse_dis",// data_bit_reverse_dis|data_bit_reverse_en
        parameter hssi_krfec_tx_pcs_enc_frame_query = "enc_query_dis",  // enc_query_dis|enc_query_en
        parameter hssi_krfec_tx_pcs_low_latency_en = "disable",         // disable|enable
        parameter hssi_krfec_tx_pcs_pipeln_encoder = "enable",          // disable|enable
        parameter hssi_krfec_tx_pcs_pipeln_scrambler = "enable",        // disable|enable
        parameter hssi_krfec_tx_pcs_prot_mode    = "disable_mode",      // disable_mode|teng_basekr_mode|fortyg_basekr_mode|teng_1588_basekr_mode|basic_mode
        parameter hssi_krfec_tx_pcs_sup_mode     = "user_mode",         // user_mode|engineering_mode
        parameter hssi_krfec_tx_pcs_transcode_err = "trans_err_dis",    // trans_err_dis|trans_err_en
        parameter hssi_krfec_tx_pcs_transmit_order = "transmit_lsb",    // transmit_lsb|transmit_msb
        parameter hssi_krfec_tx_pcs_tx_testbus_sel = "overall",         // overall|encoder1|encoder2|scramble1|scramble2|scramble3|gearbox
    // parameters for twentynm_hssi_pipe_gen1_2
        parameter hssi_pipe_gen1_2_elec_idle_delay_val = 3'b0,
        parameter hssi_pipe_gen1_2_error_replace_pad = "replace_edb",   // replace_edb|replace_pad
        parameter hssi_pipe_gen1_2_hip_mode      = "dis_hip",           // dis_hip|en_hip
        parameter hssi_pipe_gen1_2_ind_error_reporting = "dis_ind_error_reporting",// dis_ind_error_reporting|en_ind_error_reporting
        parameter hssi_pipe_gen1_2_phystatus_delay_val = 3'b0,
        parameter hssi_pipe_gen1_2_phystatus_rst_toggle = "dis_phystatus_rst_toggle",// dis_phystatus_rst_toggle|en_phystatus_rst_toggle
        parameter hssi_pipe_gen1_2_pipe_byte_de_serializer_en = "dont_care_bds",// dis_bds|en_bds_by_2|dont_care_bds
        parameter hssi_pipe_gen1_2_prot_mode     = "pipe_g1",           // pipe_g1|pipe_g2|pipe_g3|basic|disabled_prot_mode
        parameter hssi_pipe_gen1_2_reconfig_settings = "{}",            //
        parameter hssi_pipe_gen1_2_rx_pipe_enable = "dis_pipe_rx",      // dis_pipe_rx|en_pipe_rx|en_pipe3_rx
        parameter hssi_pipe_gen1_2_rxdetect_bypass = "dis_rxdetect_bypass",// dis_rxdetect_bypass|en_rxdetect_bypass
        parameter hssi_pipe_gen1_2_sup_mode      = "user_mode",         // user_mode|engineering_mode
        parameter hssi_pipe_gen1_2_tx_pipe_enable = "dis_pipe_tx",      // dis_pipe_tx|en_pipe_tx|en_pipe3_tx
        parameter hssi_pipe_gen1_2_txswing       = "dis_txswing",       // dis_txswing|en_txswing
    // parameters for twentynm_hssi_pipe_gen3
        parameter hssi_pipe_gen3_bypass_rx_detection_enable = "false",  // false|true
        parameter hssi_pipe_gen3_bypass_rx_preset = 3'b0,
        parameter hssi_pipe_gen3_bypass_rx_preset_enable = "false",     // false|true
        parameter hssi_pipe_gen3_bypass_tx_coefficent = 18'b0,
        parameter hssi_pipe_gen3_bypass_tx_coefficent_enable = "false", // false|true
        parameter hssi_pipe_gen3_elecidle_delay_g3 = 3'b110,
        parameter hssi_pipe_gen3_ind_error_reporting = "dis_ind_error_reporting",// dis_ind_error_reporting|en_ind_error_reporting
        parameter hssi_pipe_gen3_mode            = "pipe_g1",           // pipe_g1|pipe_g2|pipe_g3|disable_pcs
        parameter hssi_pipe_gen3_phy_status_delay_g12 = 3'b101,
        parameter hssi_pipe_gen3_phy_status_delay_g3 = 3'b101,
        parameter hssi_pipe_gen3_phystatus_rst_toggle_g12 = "dis_phystatus_rst_toggle",// dis_phystatus_rst_toggle|en_phystatus_rst_toggle
        parameter hssi_pipe_gen3_phystatus_rst_toggle_g3 = "dis_phystatus_rst_toggle_g3",// dis_phystatus_rst_toggle_g3|en_phystatus_rst_toggle_g3
        parameter hssi_pipe_gen3_rate_match_pad_insertion = "dis_rm_fifo_pad_ins",// dis_rm_fifo_pad_ins|en_rm_fifo_pad_ins
        parameter hssi_pipe_gen3_sup_mode        = "user_mode",         // user_mode|engineering_mode
        parameter hssi_pipe_gen3_test_out_sel    = "disable_test_out",  // tx_test_out|rx_test_out|pipe_test_out1|pipe_test_out2|pipe_test_out3|pipe_ctrl_test_out|disable_test_out
    // parameters for twentynm_hssi_rx_pcs_pma_interface
        parameter hssi_rx_pcs_pma_interface_block_sel = "eight_g_pcs",  // eight_g_pcs|ten_g_pcs|direct_pld
        parameter hssi_rx_pcs_pma_interface_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_rx_pcs_pma_interface_clkslip_sel = "pld",        // pld|slip_eight_g_pcs
        parameter hssi_rx_pcs_pma_interface_lpbk_en = "disable",        // disable|enable
        parameter hssi_rx_pcs_pma_interface_master_clk_sel = "master_rx_pma_clk",// master_rx_pma_clk|master_tx_pma_clk|master_refclk_dig
        parameter hssi_rx_pcs_pma_interface_pldif_datawidth_mode = "pldif_data_10bit",// pldif_data_10bit|pldif_data_8bit
        parameter hssi_rx_pcs_pma_interface_pma_dw_rx = "pma_8b_rx",    // pma_8b_rx|pma_10b_rx|pma_16b_rx|pma_20b_rx|pma_32b_rx|pma_40b_rx|pma_64b_rx|pcie_g3_dyn_dw_rx
        parameter hssi_rx_pcs_pma_interface_pma_if_dft_en = "dft_dis",  // dft_dis|dft_en
        parameter hssi_rx_pcs_pma_interface_pma_if_dft_val = "dft_0",   // dft_0|dft_1
        parameter hssi_rx_pcs_pma_interface_prbs9_dwidth = "prbs9_64b", // prbs9_64b|prbs9_10b
        parameter hssi_rx_pcs_pma_interface_prbs_clken = "prbs_clk_dis",// prbs_clk_dis|prbs_clk_en
        parameter hssi_rx_pcs_pma_interface_prbs_ver = "prbs_off",      // prbs_off|prbs_31|prbs_15|prbs_23|prbs_9|prbs_7
        parameter hssi_rx_pcs_pma_interface_prot_mode_rx = "disabled_prot_mode_rx",// disabled_prot_mode_rx|pcs_direct_mode_rx|eightg_only_pld_mode_rx|eightg_pcie_g12_pld_mode_rx|eightg_g3_pcie_g3_pld_mode_rx|eightg_pcie_g12_hip_mode_rx|eightg_g3_pcie_g3_hip_mode_rx|teng_krfec_mode_rx|eightg_basic_mode_rx|teng_basic_mode_rx|teng_sfis_sdi_mode_rx|prbs_mode_rx
        parameter hssi_rx_pcs_pma_interface_reconfig_settings = "{}",   //
        parameter hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion = "rx_dyn_polinv_dis",// rx_dyn_polinv_dis|rx_dyn_polinv_en
        parameter hssi_rx_pcs_pma_interface_rx_lpbk_en = "lpbk_dis",    // lpbk_dis|lpbk_en
        parameter hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok = "unforce_sig_ok",// unforce_sig_ok|force_sig_ok
        parameter hssi_rx_pcs_pma_interface_rx_prbs_mask = "prbsmask128",// prbsmask128|prbsmask256|prbsmask512|prbsmask1024
        parameter hssi_rx_pcs_pma_interface_rx_prbs_mode = "teng_mode", // teng_mode|eightg_mode
        parameter hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel = "sel_sig_det",// sel_sig_det|sel_sig_ok
        parameter hssi_rx_pcs_pma_interface_rx_static_polarity_inversion = "rx_stat_polinv_dis",// rx_stat_polinv_dis|rx_stat_polinv_en
        parameter hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en = "uhsif_lpbk_dis",// uhsif_lpbk_dis|uhsif_lpbk_en
        parameter hssi_rx_pcs_pma_interface_sup_mode = "user_mode",     // user_mode|engineering_mode
    // parameters for twentynm_hssi_rx_pld_pcs_interface
        parameter hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx = "individual_rx",// individual_rx|ctrl_master_rx|ctrl_slave_abv_rx|ctrl_slave_blw_rx
        parameter hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx = "fifo_rx",// fifo_rx|reg_rx
        parameter hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx = "enable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_10g_lpbk_en = "disable", // disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx = "pma_64b_rx",// pma_32b_rx|pma_40b_rx|pma_64b_rx
        parameter hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx = "disabled_prot_mode_rx",// disabled_prot_mode_rx|teng_baser_mode_rx|interlaken_mode_rx|sfis_mode_rx|teng_sdi_mode_rx|basic_mode_rx|test_prp_mode_rx|test_prp_krfec_mode_rx|teng_1588_mode_rx|teng_baser_krfec_mode_rx|teng_1588_krfec_mode_rx|basic_krfec_mode_rx
        parameter hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx = "single_rx",// single_rx|double_rx
        parameter hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode = "tx",// tx|rx
        parameter hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx = "individual_rx",// individual_rx|ctrl_master_rx|ctrl_slave_abv_rx|ctrl_slave_blw_rx
        parameter hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx = "fifo_rx",// fifo_rx|reg_rx
        parameter hssi_rx_pld_pcs_interface_hd_8g_hip_mode = "disable", // disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_8g_lpbk_en = "disable",  // disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx = "pma_8b_rx",// pma_8b_rx|pma_10b_rx|pma_16b_rx|pma_20b_rx
        parameter hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx = "disabled_prot_mode_rx",// pipe_g1_rx|pipe_g2_rx|pipe_g3_rx|cpri_rx|cpri_rx_tx_rx|gige_rx|gige_1588_rx|basic_rm_enable_rx|basic_rm_disable_rx|disabled_prot_mode_rx
        parameter hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz = 30'b0,
        parameter hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx = "individual_rx",// individual_rx|ctrl_master_rx|ctrl_slave_abv_rx|ctrl_slave_blw_rx
        parameter hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz = 30'b0,
        parameter hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_chnl_func_mode = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_chnl_hip_en = "disable", // disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx = "fifo_rx",// fifo_rx|reg_rx
        parameter hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz = 30'b0,
        parameter hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx = "pma_8b_rx",// pma_8b_rx|pma_10b_rx|pma_16b_rx|pma_20b_rx|pma_32b_rx|pma_40b_rx|pma_64b_rx|pcie_g3_dyn_dw_rx
        parameter hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz = 30'b0,
        parameter hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx = "disabled_prot_mode_rx",// disabled_prot_mode_rx|pcie_g1_capable_rx|pcie_g2_capable_rx|pcie_g3_capable_rx|gige_rx|teng_baser_rx|teng_basekr_krfec_rx|fortyg_basekr_krfec_rx|cpri_8b10b_rx|interlaken_rx|sfis_rx|teng_sdi_rx|gige_1588_rx|teng_1588_baser_rx|teng_1588_basekr_krfec_rx|basic_8gpcs_rm_enable_rx|basic_8gpcs_rm_disable_rx|basic_10gpcs_rx|basic_10gpcs_krfec_rx|pcs_direct_rx|prp_rx|prp_krfec_rx|prbs_rx
        parameter hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx = "single_rx",// single_rx|double_rx
        parameter hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx = "teng_mode_rx",// teng_mode_rx|non_teng_mode_rx
        parameter hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx = "single_rx",// single_rx|double_rx
        parameter hssi_rx_pld_pcs_interface_hd_g3_prot_mode = "disabled_prot_mode",// pipe_g1|pipe_g2|pipe_g3|disabled_prot_mode
        parameter hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx = "disabled_prot_mode_rx",// disabled_prot_mode_rx|teng_basekr_mode_rx|fortyg_basekr_mode_rx|teng_1588_basekr_mode_rx|basic_mode_rx
        parameter hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode = "tx",// tx|rx
        parameter hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx = "disabled_prot_mode_rx",// disabled_prot_mode_rx|eightg_and_g3_pld_fifo_mode_rx|eightg_and_g3_reg_mode_rx|eightg_and_g3_reg_mode_hip_rx|teng_pld_fifo_mode_rx|teng_reg_mode_rx|teng_and_krfec_pld_fifo_mode_rx|teng_and_krfec_reg_mode_rx|pcs_direct_reg_mode_rx
        parameter hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx = "pma_8b_rx",// pma_8b_rx|pma_10b_rx|pma_16b_rx|pma_20b_rx|pma_32b_rx|pma_40b_rx|pma_64b_rx|pcie_g3_dyn_dw_rx
        parameter hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx = "disabled_prot_mode_rx",// disabled_prot_mode_rx|pcs_direct_mode_rx|eightg_only_pld_mode_rx|eightg_pcie_g12_pld_mode_rx|eightg_g3_pcie_g3_pld_mode_rx|eightg_pcie_g12_hip_mode_rx|eightg_g3_pcie_g3_hip_mode_rx|teng_krfec_mode_rx|eightg_basic_mode_rx|teng_basic_mode_rx|teng_sfis_sdi_mode_rx|prbs_mode_rx
        parameter hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_pcs_rx_block_sel = "pcs_direct",// eightg|teng|pcs_direct
        parameter hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel = "teng_clk_out",// eightg_clk_out|teng_clk_out|pma_rx_clk|pma_rx_clk_user
        parameter hssi_rx_pld_pcs_interface_pcs_rx_clk_sel = "pld_rx_clk",// pld_rx_clk|pcs_rx_clk
        parameter hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en = "hip_rx_enable",// hip_rx_enable|hip_rx_disable
        parameter hssi_rx_pld_pcs_interface_pcs_rx_output_sel = "teng_output",// krfec_output|teng_output
        parameter hssi_rx_pld_pcs_interface_reconfig_settings = "{}",   //
    // parameters for twentynm_hssi_tx_pcs_pma_interface
        parameter hssi_tx_pcs_pma_interface_bypass_pma_txelecidle = "false",// false|true
        parameter hssi_tx_pcs_pma_interface_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_tx_pcs_pma_interface_lpbk_en = "disable",        // disable|enable
        parameter hssi_tx_pcs_pma_interface_master_clk_sel = "master_tx_pma_clk",// master_tx_pma_clk|master_refclk_dig
        parameter hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx = "other_prot_mode",// pipe_g12|pipe_g3|other_prot_mode
        parameter hssi_tx_pcs_pma_interface_pldif_datawidth_mode = "pldif_data_10bit",// pldif_data_10bit|pldif_data_8bit
        parameter hssi_tx_pcs_pma_interface_pma_dw_tx = "pma_8b_tx",    // pma_8b_tx|pma_10b_tx|pma_16b_tx|pma_20b_tx|pma_32b_tx|pma_40b_tx|pma_64b_tx|pcie_g3_dyn_dw_tx
        parameter hssi_tx_pcs_pma_interface_pma_if_dft_en = "dft_dis",  // dft_dis|dft_en
        parameter hssi_tx_pcs_pma_interface_pmagate_en = "pmagate_dis", // pmagate_dis|pmagate_en
        parameter hssi_tx_pcs_pma_interface_prbs9_dwidth = "prbs9_64b", // prbs9_64b|prbs9_10b
        parameter hssi_tx_pcs_pma_interface_prbs_clken = "prbs_clk_dis",// prbs_clk_dis|prbs_clk_en
        parameter hssi_tx_pcs_pma_interface_prbs_gen_pat = "prbs_gen_dis",// prbs_gen_dis|prbs_31|prbs_23|prbs_15|prbs_9|prbs_7
        parameter hssi_tx_pcs_pma_interface_prot_mode_tx = "disabled_prot_mode_tx",// disabled_prot_mode_tx|pcs_direct_mode_tx|uhsif_reg_mode_tx|uhsif_direct_mode_tx|eightg_only_pld_mode_tx|eightg_pcie_g12_pld_mode_tx|eightg_g3_pcie_g3_pld_mode_tx|eightg_pcie_g12_hip_mode_tx|eightg_g3_pcie_g3_hip_mode_tx|teng_krfec_mode_tx|eightg_basic_mode_tx|teng_basic_mode_tx|teng_sfis_sdi_mode_tx|prbs_mode_tx|sqwave_mode_tx
        parameter hssi_tx_pcs_pma_interface_reconfig_settings = "{}",   //
        parameter hssi_tx_pcs_pma_interface_sq_wave_num = "sq_wave_4",  // sq_wave_1|sq_wave_4|sq_wave_8|sq_wave_6|sq_wave_default
        parameter hssi_tx_pcs_pma_interface_sqwgen_clken = "sqwgen_clk_dis",// sqwgen_clk_dis|sqwgen_clk_en
        parameter hssi_tx_pcs_pma_interface_sup_mode = "user_mode",     // user_mode|engineering_mode
        parameter hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion = "tx_dyn_polinv_dis",// tx_dyn_polinv_dis|tx_dyn_polinv_en
        parameter hssi_tx_pcs_pma_interface_tx_pma_data_sel = "pld_dir",// pld_dir|pcie_gen3|eight_g_pcs|ten_g_pcs|prbs_pat|sq_wave_pat|block_sel_default|registered_uhsif_dat|directed_uhsif_dat
        parameter hssi_tx_pcs_pma_interface_tx_static_polarity_inversion = "tx_stat_polinv_dis",// tx_stat_polinv_dis|tx_stat_polinv_en
        parameter hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock = "uhsif_filt_stepsz_b4lock_4",// uhsif_filt_stepsz_b4lock_2|uhsif_filt_stepsz_b4lock_4|uhsif_filt_stepsz_b4lock_6|uhsif_filt_stepsz_b4lock_8
        parameter hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value = 4'b1011,
        parameter hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock = "uhsif_filt_cntthr_b4lock_16",// uhsif_filt_cntthr_b4lock_8|uhsif_filt_cntthr_b4lock_16|uhsif_filt_cntthr_b4lock_24|uhsif_filt_cntthr_b4lock_32
        parameter hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period = "uhsif_dcn_test_period_4",// uhsif_dcn_test_period_4|uhsif_dcn_test_period_8|uhsif_dcn_test_period_12|uhsif_dcn_test_period_16
        parameter hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable = "uhsif_dcn_test_mode_disable",// uhsif_dcn_test_mode_enable|uhsif_dcn_test_mode_disable
        parameter hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh = "uhsif_dzt_cnt_thr_4",// uhsif_dzt_cnt_thr_2|uhsif_dzt_cnt_thr_4|uhsif_dzt_cnt_thr_6|uhsif_dzt_cnt_thr_8
        parameter hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable = "uhsif_dzt_enable",// uhsif_dzt_disable|uhsif_dzt_enable
        parameter hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window = "uhsif_dzt_obr_win_32",// uhsif_dzt_obr_win_16|uhsif_dzt_obr_win_32|uhsif_dzt_obr_win_48|uhsif_dzt_obr_win_64
        parameter hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size = "uhsif_dzt_skipsz_8",// uhsif_dzt_skipsz_4|uhsif_dzt_skipsz_8|uhsif_dzt_skipsz_12|uhsif_dzt_skipsz_16
        parameter hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel = "uhsif_index_internal",// uhsif_index_internal|uhsif_index_cram
        parameter hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin = "uhsif_dcn_margin_4",// uhsif_dcn_margin_2|uhsif_dcn_margin_3|uhsif_dcn_margin_4|uhsif_dcn_margin_5
        parameter hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value = 8'b10000000,
        parameter hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control = "uhsif_dft_dz_det_val_0",// uhsif_dft_dz_det_val_0|uhsif_dft_dz_det_val_1
        parameter hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control = "uhsif_dft_up_val_0",// uhsif_dft_up_val_0|uhsif_dft_up_val_1
        parameter hssi_tx_pcs_pma_interface_uhsif_enable = "uhsif_disable",// uhsif_disable|uhsif_enable
        parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock = "uhsif_lkd_segsz_aflock_2048",// uhsif_lkd_segsz_aflock_512|uhsif_lkd_segsz_aflock_1024|uhsif_lkd_segsz_aflock_2048|uhsif_lkd_segsz_aflock_4096
        parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock = "uhsif_lkd_segsz_b4lock_32",// uhsif_lkd_segsz_b4lock_16|uhsif_lkd_segsz_b4lock_32|uhsif_lkd_segsz_b4lock_64|uhsif_lkd_segsz_b4lock_128
        parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value = 4'b1000,
        parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value = 4'b1000,
        parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value = 4'b11,
        parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value = 4'b11,
    // parameters for twentynm_hssi_tx_pld_pcs_interface
        parameter hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx = "individual_tx",// individual_tx|ctrl_master_tx|ctrl_slave_abv_tx|ctrl_slave_blw_tx
        parameter hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx = "fifo_tx",// fifo_tx|reg_tx|fastreg_tx
        parameter hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx = "enable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_10g_lpbk_en = "disable", // disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx = "pma_64b_tx",// pma_32b_tx|pma_40b_tx|pma_64b_tx
        parameter hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx = "disabled_prot_mode_tx",// disabled_prot_mode_tx|teng_baser_mode_tx|interlaken_mode_tx|sfis_mode_tx|teng_sdi_mode_tx|basic_mode_tx|test_prp_mode_tx|test_prp_krfec_mode_tx|teng_1588_mode_tx|teng_baser_krfec_mode_tx|teng_1588_krfec_mode_tx|basic_krfec_mode_tx
        parameter hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx = "single_tx",// single_tx|double_tx
        parameter hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx = "individual_tx",// individual_tx|ctrl_master_tx|ctrl_slave_abv_tx|ctrl_slave_blw_tx
        parameter hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx = "fifo_tx",// fifo_tx|reg_tx|fastreg_tx
        parameter hssi_tx_pld_pcs_interface_hd_8g_hip_mode = "disable", // disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_8g_lpbk_en = "disable",  // disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx = "pma_8b_tx",// pma_8b_tx|pma_10b_tx|pma_16b_tx|pma_20b_tx
        parameter hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx = "disabled_prot_mode_tx",// pipe_g1_tx|pipe_g2_tx|pipe_g3_tx|cpri_tx|cpri_rx_tx_tx|gige_tx|gige_1588_tx|basic_tx|disabled_prot_mode_tx
        parameter hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx = "individual_tx",// individual_tx|ctrl_master_tx|ctrl_slave_abv_tx|ctrl_slave_blw_tx
        parameter hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_chnl_func_mode = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_chnl_hip_en = "disable", // disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx = "fifo_tx",// fifo_tx|reg_tx|fastreg_tx
        parameter hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz = 30'b0,
        parameter hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz = 30'b0,
        parameter hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx = "pma_8b_tx",// pma_8b_tx|pma_10b_tx|pma_16b_tx|pma_20b_tx|pma_32b_tx|pma_40b_tx|pma_64b_tx|pcie_g3_dyn_dw_tx
        parameter hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz = 30'b0,
        parameter hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx = "disabled_prot_mode_tx",// disabled_prot_mode_tx|pcie_g1_capable_tx|pcie_g2_capable_tx|pcie_g3_capable_tx|gige_tx|teng_baser_tx|teng_basekr_krfec_tx|fortyg_basekr_krfec_tx|cpri_8b10b_tx|interlaken_tx|sfis_tx|teng_sdi_tx|gige_1588_tx|teng_1588_baser_tx|teng_1588_basekr_krfec_tx|basic_8gpcs_tx|basic_10gpcs_tx|basic_10gpcs_krfec_tx|pcs_direct_tx|uhsif_tx|prp_tx|prp_krfec_tx|prbs_tx|sqwave_tx
        parameter hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx = "single_tx",// single_tx|double_tx
        parameter hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx = "teng_mode_tx",// teng_mode_tx|non_teng_mode_tx
        parameter hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx = "single_tx",// single_tx|double_tx
        parameter hssi_tx_pld_pcs_interface_hd_g3_prot_mode = "disabled_prot_mode",// pipe_g1|pipe_g2|pipe_g3|disabled_prot_mode
        parameter hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx = "disabled_prot_mode_tx",// disabled_prot_mode_tx|teng_basekr_mode_tx|fortyg_basekr_mode_tx|teng_1588_basekr_mode_tx|basic_mode_tx
        parameter hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx = "disabled_prot_mode_tx",// disabled_prot_mode_tx|eightg_and_g3_pld_fifo_mode_tx|eightg_and_g3_reg_mode_tx|eightg_and_g3_reg_mode_hip_tx|eightg_and_g3_fastreg_mode_tx|teng_pld_fifo_mode_tx|teng_reg_mode_tx|teng_fastreg_mode_tx|teng_and_krfec_pld_fifo_mode_tx|teng_and_krfec_reg_mode_tx|teng_and_krfec_fastreg_mode_tx|pcs_direct_fastreg_mode_tx|uhsif_mode_tx
        parameter hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding = "individual",// individual|ctrl_master|ctrl_slave_abv|ctrl_slave_blw
        parameter hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx = "pma_8b_tx",// pma_8b_tx|pma_10b_tx|pma_16b_tx|pma_20b_tx|pma_32b_tx|pma_40b_tx|pma_64b_tx|pcie_g3_dyn_dw_tx
        parameter hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx = "disabled_prot_mode_tx",// disabled_prot_mode_tx|pcs_direct_mode_tx|uhsif_reg_mode_tx|uhsif_direct_mode_tx|eightg_only_pld_mode_tx|eightg_pcie_g12_pld_mode_tx|eightg_g3_pcie_g3_pld_mode_tx|eightg_pcie_g12_hip_mode_tx|eightg_g3_pcie_g3_hip_mode_tx|teng_krfec_mode_tx|eightg_basic_mode_tx|teng_basic_mode_tx|teng_sfis_sdi_mode_tx|prbs_mode_tx|sqwave_mode_tx
        parameter hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel = "teng_clk_out",// eightg_clk_out|teng_clk_out|pma_tx_clk|pma_tx_clk_user
        parameter hssi_tx_pld_pcs_interface_pcs_tx_clk_source = "teng", // eightg|teng|pma_clk
        parameter hssi_tx_pld_pcs_interface_pcs_tx_data_source = "hip_disable",// hip_disable|hip_enable
        parameter hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en = "delay1_clk_disable",// delay1_clk_enable|delay1_clk_disable
        parameter hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel = "pld_tx_clk",// pld_tx_clk|pcs_tx_clk
        parameter hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl = "delay1_path0",// delay1_path0|delay1_path1|delay1_path2|delay1_path3|delay1_path4
        parameter hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel = "one_ff_delay",// one_ff_delay|two_ff_delay
        parameter hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en = "delay2_clk_disable",// delay2_clk_enable|delay2_clk_disable
        parameter hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl = "delay2_path0",// delay2_path0|delay2_path1|delay2_path2|delay2_path3|delay2_path4
        parameter hssi_tx_pld_pcs_interface_pcs_tx_output_sel = "teng_output",// krfec_output|teng_output
        parameter hssi_tx_pld_pcs_interface_reconfig_settings = "{}",   //

    // twentynm_xcvr_avmm parameters
        parameter avmm_interfaces                = 1,                   //Number of AVMM interfaces required - one for each bonded_lane, PLL, and Master CGB
        parameter rcfg_enable                    = 0,                   //Enable/disable reconfig interface in the Native PHY or PLL IP
        parameter enable_avmm                    = 1,                   //Enable/disable AVMM atom instantiation
        parameter arbiter_ctrl                   = "pld",               //Calibration request at start-up. Valid values: "uc","pld".
    //"uc" =Initial calibration needed at start-up. Internal DPRIO interface is controlled by uC.
    //"pld"=Initial calibration is not needed at start-up. Internal DPRIO interface is controlled by PLD.
        parameter calibration_en                 = "disable",           //Indicates whether calibration by Hard Nios is enabled or not.Should be set to DISABLE in case if Nios is absent or needs to be bypassed. Valid values: enable, disable
        parameter avmm_busy_en                   = "disable",           //Provides a separate interface for determining control of the AVMM bus, and separates its behavior from the avmm_waitreqeust
        parameter hip_cal_en                     = "disable",           //Indicates whether HIP is enabled or not. Valid values: disable, enable
        parameter cal_done                       = "cal_done_assert"    //Indicates whether calibration is done. This is the start-up value for the corresponding CRAM. THe CRAM is eventually accessed and updated by the Hard uC during calibration. Valid values: cal_done_assert, cal_done_deassert
  )(

  // twentynm_pma ports
  input   wire                                  in_adapt_start,
  input   wire                                  in_clk_cdr_b,
  input   wire                                  in_clk_cdr_t,
  input   wire                                  in_clk_fpll_b,
  input   wire                                  in_clk_fpll_t,
  input   wire                                  in_clk_lc_b,
  input   wire                                  in_clk_lc_hs,
  input   wire                                  in_clk_lc_t,
  input   wire                                  in_clkb_cdr_b,
  input   wire                                  in_clkb_cdr_t,
  input   wire                                  in_clkb_fpll_b,
  input   wire                                  in_clkb_fpll_t,
  input   wire                                  in_clkb_lc_b,
  input   wire                                  in_clkb_lc_hs,
  input   wire                                  in_clkb_lc_t,
  input   wire  [5:0]                           in_cpulse_x6_dn_bus,
  input   wire  [5:0]                           in_cpulse_x6_up_bus,
  input   wire  [5:0]                           in_cpulse_xn_dn_bus,
  input   wire  [5:0]                           in_cpulse_xn_up_bus,
  input   wire  [2:0]                           in_i_rxpreset,
  input   wire  [1:0]                           in_pcie_sw_done_master_in,
  input   wire  [11:0]                          in_ref_iqclk,
  input   wire                                  in_rx_n,
  input   wire                                  in_rx_p,
  output  wire                                  out_clk_divrx_iqtxrx,
  output  wire                                  out_clk_divtx_iqtxrx,
  output  wire  [1:0]                           out_pcie_sw_master,
  output  wire                                  out_tx_n,
  output  wire                                  out_tx_p,

  // twentynm_pcs ports
  input   wire  [4:0]                           in_bond_pcs10g_in_bot,
  input   wire  [4:0]                           in_bond_pcs10g_in_top,
  input   wire  [12:0]                          in_bond_pcs8g_in_bot,
  input   wire  [12:0]                          in_bond_pcs8g_in_top,
  input   wire  [11:0]                          in_bond_pmaif_in_bot,
  input   wire  [11:0]                          in_bond_pmaif_in_top,
  input   wire  [63:0]                          in_hip_tx_data,
  input   wire                                  in_pld_10g_krfec_rx_clr_errblk_cnt,
  input   wire                                  in_pld_10g_krfec_rx_pld_rst_n,
  input   wire                                  in_pld_10g_krfec_tx_pld_rst_n,
  input   wire                                  in_pld_10g_rx_align_clr,
  input   wire                                  in_pld_10g_rx_clr_ber_count,
  input   wire                                  in_pld_10g_rx_rd_en,
  input   wire  [6:0]                           in_pld_10g_tx_bitslip,
  input   wire                                  in_pld_10g_tx_burst_en,
  input   wire                                  in_pld_10g_tx_data_valid,
  input   wire  [1:0]                           in_pld_10g_tx_diag_status,
  input   wire                                  in_pld_10g_tx_wordslip,
  input   wire                                  in_pld_8g_a1a2_size,
  input   wire                                  in_pld_8g_bitloc_rev_en,
  input   wire                                  in_pld_8g_byte_rev_en,
  input   wire  [2:0]                           in_pld_8g_eidleinfersel,
  input   wire                                  in_pld_8g_encdt,
  input   wire                                  in_pld_8g_g3_rx_pld_rst_n,
  input   wire                                  in_pld_8g_g3_tx_pld_rst_n,
  input   wire                                  in_pld_8g_rddisable_tx,
  input   wire                                  in_pld_8g_rdenable_rx,
  input   wire                                  in_pld_8g_refclk_dig2,
  input   wire                                  in_pld_8g_rxpolarity,
  input   wire  [4:0]                           in_pld_8g_tx_boundary_sel,
  input   wire                                  in_pld_8g_wrdisable_rx,
  input   wire                                  in_pld_8g_wrenable_tx,
  input   wire                                  in_pld_atpg_los_en_n,
  input   wire                                  in_pld_bitslip,
  input   wire  [17:0]                          in_pld_g3_current_coeff,
  input   wire  [2:0]                           in_pld_g3_current_rxpreset,
  input   wire                                  in_pld_ltr,
  input   wire                                  in_pld_mem_krfec_atpg_rst_n,
  input   wire                                  in_pld_partial_reconfig,
  input   wire                                  in_pld_pcs_refclk_dig,
  input   wire                                  in_pld_pma_adapt_start,
  input   wire                                  in_pld_pma_early_eios,
  input   wire  [5:0]                           in_pld_pma_eye_monitor,
  input   wire                                  in_pld_pma_ltd_b,
  input   wire  [1:0]                           in_pld_pma_pcie_switch,
  input   wire                                  in_pld_pma_ppm_lock,
  input   wire  [4:0]                           in_pld_pma_reserved_out,
  input   wire                                  in_pld_pma_rs_lpbk_b,
  input   wire                                  in_pld_pma_rx_qpi_pullup,
  input   wire                                  in_pld_pma_rxpma_rstb,
  input   wire                                  in_pld_pma_tx_bitslip,
  input   wire                                  in_pld_pma_tx_bonding_rstb,
  input   wire                                  in_pld_pma_tx_qpi_pulldn,
  input   wire                                  in_pld_pma_tx_qpi_pullup,
  input   wire                                  in_pld_pma_txdetectrx,
  input   wire                                  in_pld_pma_txpma_rstb,
  input   wire                                  in_pld_pmaif_rx_pld_rst_n,
  input   wire                                  in_pld_pmaif_rxclkslip,
  input   wire                                  in_pld_pmaif_tx_pld_rst_n,
  input   wire                                  in_pld_polinv_rx,
  input   wire                                  in_pld_polinv_tx,
  input   wire  [1:0]                           in_pld_rate,
  input   wire  [9:0]                           in_pld_reserved_in,
  input   wire                                  in_pld_rx_clk,
  input   wire                                  in_pld_rx_prbs_err_clr,
  input   wire                                  in_pld_syncsm_en,
  input   wire                                  in_pld_tx_clk,
  input   wire  [17:0]                          in_pld_tx_control,
  input   wire  [127:0]                         in_pld_tx_data,
  input   wire                                  in_pld_txelecidle,
  input   wire                                  in_pld_uhsif_tx_clk,
  input   wire                                  in_pma_hclk,
  output  wire  [4:0]                           out_bond_pcs10g_out_bot,
  output  wire  [4:0]                           out_bond_pcs10g_out_top,
  output  wire  [12:0]                          out_bond_pcs8g_out_bot,
  output  wire  [12:0]                          out_bond_pcs8g_out_top,
  output  wire  [11:0]                          out_bond_pmaif_out_bot,
  output  wire  [11:0]                          out_bond_pmaif_out_top,
  output  wire  [2:0]                           out_hip_clk_out,
  output  wire  [7:0]                           out_hip_ctrl_out,
  output  wire                                  out_hip_npor,
  output  wire  [50:0]                          out_hip_rx_data,
  output  wire                                  out_pld_10g_krfec_rx_blk_lock,
  output  wire  [1:0]                           out_pld_10g_krfec_rx_diag_data_status,
  output  wire                                  out_pld_10g_krfec_rx_frame,
  output  wire                                  out_pld_10g_krfec_tx_frame,
  output  wire                                  out_pld_10g_rx_align_val,
  output  wire                                  out_pld_10g_rx_crc32_err,
  output  wire                                  out_pld_10g_rx_data_valid,
  output  wire                                  out_pld_10g_rx_empty,
  output  wire                                  out_pld_10g_rx_fifo_del,
  output  wire                                  out_pld_10g_rx_fifo_insert,
  output  wire  [4:0]                           out_pld_10g_rx_fifo_num,
  output  wire                                  out_pld_10g_rx_frame_lock,
  output  wire                                  out_pld_10g_rx_hi_ber,
  output  wire                                  out_pld_10g_rx_oflw_err,
  output  wire                                  out_pld_10g_rx_pempty,
  output  wire                                  out_pld_10g_rx_pfull,
  output  wire                                  out_pld_10g_tx_burst_en_exe,
  output  wire                                  out_pld_10g_tx_empty,
  output  wire  [3:0]                           out_pld_10g_tx_fifo_num,
  output  wire                                  out_pld_10g_tx_full,
  output  wire                                  out_pld_10g_tx_pempty,
  output  wire                                  out_pld_10g_tx_pfull,
  output  wire                                  out_pld_10g_tx_wordslip_exe,
  output  wire  [3:0]                           out_pld_8g_a1a2_k1k2_flag,
  output  wire                                  out_pld_8g_empty_rmf,
  output  wire                                  out_pld_8g_empty_rx,
  output  wire                                  out_pld_8g_empty_tx,
  output  wire                                  out_pld_8g_full_rmf,
  output  wire                                  out_pld_8g_full_rx,
  output  wire                                  out_pld_8g_full_tx,
  output  wire                                  out_pld_8g_rxelecidle,
  output  wire                                  out_pld_8g_signal_detect_out,
  output  wire  [4:0]                           out_pld_8g_wa_boundary,
  output  wire                                  out_pld_krfec_tx_alignment,
  output  wire                                  out_pld_pcs_rx_clk_out,
  output  wire                                  out_pld_pcs_tx_clk_out,
  output  wire                                  out_pld_pma_adapt_done,
  output  wire                                  out_pld_pma_clkdiv_rx_user,
  output  wire                                  out_pld_pma_clkdiv_tx_user,
  output  wire                                  out_pld_pma_clklow,
  output  wire                                  out_pld_pma_fref,
  output  wire                                  out_pld_pma_hclk,
  output  wire  [1:0]                           out_pld_pma_pcie_sw_done,
  output  wire                                  out_pld_pma_pfdmode_lock,
  output  wire                                  out_pld_pma_rx_clk_out,
  output  wire                                  out_pld_pma_rx_detect_valid,
  output  wire                                  out_pld_pma_rx_found,
  output  wire                                  out_pld_pma_rxpll_lock,
  output  wire                                  out_pld_pma_signal_ok,
  output  wire  [7:0]                           out_pld_pma_testbus,
  output  wire                                  out_pld_pma_tx_clk_out,
  output  wire                                  out_pld_pmaif_mask_tx_pll,
  output  wire  [9:0]                           out_pld_reserved_out,
  output  wire  [19:0]                          out_pld_rx_control,
  output  wire  [127:0]                         out_pld_rx_data,
  output  wire                                  out_pld_rx_prbs_done,
  output  wire                                  out_pld_rx_prbs_err,
  output  wire  [19:0]                          out_pld_test_data,
  output  wire                                  out_pld_uhsif_lock,
  output  wire                                  out_pld_uhsif_tx_clk_out,

  // twentynm_xcvr_avmm ports
  // AVMM slave interface signals (user)
  input   wire  [avmm_interfaces-1     :0]      avmm_clk,
  input   wire  [avmm_interfaces-1     :0]      avmm_reset,
  input   wire  [avmm_interfaces*8-1   :0]      avmm_writedata,
  input   wire  [avmm_interfaces*9-1   :0]      avmm_address,
  input   wire  [avmm_interfaces-1     :0]      avmm_write,
  input   wire  [avmm_interfaces-1     :0]      avmm_read,
  output  wire  [avmm_interfaces*8-1   :0]      avmm_readdata,
  output  wire  [avmm_interfaces-1     :0]      avmm_waitrequest,
  //AVMM interface busy with calibration
  output  wire  [avmm_interfaces-1     :0]      avmm_busy,
  // Calibration Done
  output  wire  [avmm_interfaces-1     :0]      hip_cal_done,                   //To HIP
  output  wire  [avmm_interfaces-1     :0]      pld_cal_done                    //To PLD
);


generate
case (device_revision)

  "20nm1":   begin
               twentynm_xcvr_native_rev_20nm1
                 #(
			
           .bonded_lanes                    		(bonded_lanes                   ),
           .bonding_master_ch               		(bonding_master_ch              ),
           .xcvr_native_mode                		(xcvr_native_mode               ),
           .pma_adapt_adapt_mode            		(pma_adapt_adapt_mode           ),
           .pma_adapt_adp_1s_ctle_bypass    		(pma_adapt_adp_1s_ctle_bypass   ),
           .pma_adapt_adp_4s_ctle_bypass    		(pma_adapt_adp_4s_ctle_bypass   ),
           .pma_adapt_adp_ctle_adapt_cycle_window  		(pma_adapt_adp_ctle_adapt_cycle_window ),
           .pma_adapt_adp_ctle_en           		(pma_adapt_adp_ctle_en          ),
           .pma_adapt_adp_dfe_fltap_bypass  		(pma_adapt_adp_dfe_fltap_bypass ),
           .pma_adapt_adp_dfe_fltap_en      		(pma_adapt_adp_dfe_fltap_en     ),
           .pma_adapt_adp_dfe_fxtap_bypass  		(pma_adapt_adp_dfe_fxtap_bypass ),
           .pma_adapt_adp_dfe_fxtap_en      		(pma_adapt_adp_dfe_fxtap_en     ),
           .pma_adapt_adp_dfe_fxtap_hold_en  		(pma_adapt_adp_dfe_fxtap_hold_en ),
           .pma_adapt_adp_dfe_mode          		(pma_adapt_adp_dfe_mode         ),
           .pma_adapt_adp_mode              		(pma_adapt_adp_mode             ),
           .pma_adapt_adp_onetime_dfe       		(pma_adapt_adp_onetime_dfe      ),
           .pma_adapt_adp_vga_bypass        		(pma_adapt_adp_vga_bypass       ),
           .pma_adapt_adp_vga_en            		(pma_adapt_adp_vga_en           ),
           .pma_adapt_adp_vref_bypass       		(pma_adapt_adp_vref_bypass      ),
           .pma_adapt_adp_vref_en           		(pma_adapt_adp_vref_en          ),
           .pma_adapt_datarate              		(pma_adapt_datarate             ),
           .pma_adapt_odi_dfe_spec_en       		(pma_adapt_odi_dfe_spec_en      ),
           .pma_adapt_prot_mode             		(pma_adapt_prot_mode            ),
           .pma_adapt_sup_mode              		(pma_adapt_sup_mode             ),
           .pma_cdr_refclk_inclk0_logical_to_physical_mapping  		(pma_cdr_refclk_inclk0_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk1_logical_to_physical_mapping  		(pma_cdr_refclk_inclk1_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk2_logical_to_physical_mapping  		(pma_cdr_refclk_inclk2_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk3_logical_to_physical_mapping  		(pma_cdr_refclk_inclk3_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk4_logical_to_physical_mapping  		(pma_cdr_refclk_inclk4_logical_to_physical_mapping ),
           .pma_cdr_refclk_powerdown_mode   		(pma_cdr_refclk_powerdown_mode  ),
           .pma_cdr_refclk_refclk_select    		(pma_cdr_refclk_refclk_select   ),
           .cdr_pll_atb_select_control      		(cdr_pll_atb_select_control     ),
           .cdr_pll_auto_reset_on           		(cdr_pll_auto_reset_on          ),
           .cdr_pll_bbpd_data_pattern_filter_select  		(cdr_pll_bbpd_data_pattern_filter_select ),
           .cdr_pll_bw_sel                  		(cdr_pll_bw_sel                 ),
           .cdr_pll_cal_vco_count_length    		(cdr_pll_cal_vco_count_length   ),
           .cdr_pll_cdr_odi_select          		(cdr_pll_cdr_odi_select         ),
           .cdr_pll_cdr_phaselock_mode      		(cdr_pll_cdr_phaselock_mode     ),
           .cdr_pll_cdr_powerdown_mode      		(cdr_pll_cdr_powerdown_mode     ),
           .cdr_pll_cgb_div                 		(cdr_pll_cgb_div                ),
           .cdr_pll_chgpmp_current_dn_pd    		(cdr_pll_chgpmp_current_dn_pd   ),
           .cdr_pll_chgpmp_current_dn_trim  		(cdr_pll_chgpmp_current_dn_trim ),
           .cdr_pll_chgpmp_current_pd       		(cdr_pll_chgpmp_current_pd      ),
           .cdr_pll_chgpmp_current_pfd      		(cdr_pll_chgpmp_current_pfd     ),
           .cdr_pll_chgpmp_current_up_pd    		(cdr_pll_chgpmp_current_up_pd   ),
           .cdr_pll_chgpmp_current_up_trim  		(cdr_pll_chgpmp_current_up_trim ),
           .cdr_pll_chgpmp_dn_pd_trim_double  		(cdr_pll_chgpmp_dn_pd_trim_double ),
           .cdr_pll_chgpmp_replicate        		(cdr_pll_chgpmp_replicate       ),
           .cdr_pll_chgpmp_testmode         		(cdr_pll_chgpmp_testmode        ),
           .cdr_pll_chgpmp_up_pd_trim_double  		(cdr_pll_chgpmp_up_pd_trim_double ),
           .cdr_pll_clklow_mux_select       		(cdr_pll_clklow_mux_select      ),
           .cdr_pll_datarate                		(cdr_pll_datarate               ),
           .cdr_pll_diag_loopback_enable    		(cdr_pll_diag_loopback_enable   ),
           .cdr_pll_disable_up_dn           		(cdr_pll_disable_up_dn          ),
           .cdr_pll_fb_select               		(cdr_pll_fb_select              ),
           .cdr_pll_fref_clklow_div         		(cdr_pll_fref_clklow_div        ),
           .cdr_pll_fref_mux_select         		(cdr_pll_fref_mux_select        ),
           .cdr_pll_gpon_lck2ref_control    		(cdr_pll_gpon_lck2ref_control   ),
           .cdr_pll_initial_settings        		(cdr_pll_initial_settings       ),
           .cdr_pll_iqclk_mux_sel           		(cdr_pll_iqclk_mux_sel          ),
           .cdr_pll_is_cascaded_pll         		(cdr_pll_is_cascaded_pll        ),
           .cdr_pll_lck2ref_delay_control   		(cdr_pll_lck2ref_delay_control  ),
           .cdr_pll_lf_resistor_pd          		(cdr_pll_lf_resistor_pd         ),
           .cdr_pll_lf_resistor_pfd         		(cdr_pll_lf_resistor_pfd        ),
           .cdr_pll_lf_ripple_cap           		(cdr_pll_lf_ripple_cap          ),
           .cdr_pll_loop_filter_bias_select  		(cdr_pll_loop_filter_bias_select ),
           .cdr_pll_loopback_mode           		(cdr_pll_loopback_mode          ),
           .cdr_pll_lpd_counter             		(cdr_pll_lpd_counter            ),
           .cdr_pll_lpfd_counter            		(cdr_pll_lpfd_counter           ),
           .cdr_pll_ltd_ltr_micro_controller_select  		(cdr_pll_ltd_ltr_micro_controller_select ),
           .cdr_pll_m_counter               		(cdr_pll_m_counter              ),
           .cdr_pll_n_counter               		(cdr_pll_n_counter              ),
           .cdr_pll_n_counter_scratch       		(cdr_pll_n_counter_scratch      ),
           .cdr_pll_output_clock_frequency  		(cdr_pll_output_clock_frequency ),
           .cdr_pll_pcie_gen                		(cdr_pll_pcie_gen               ),
           .cdr_pll_pd_fastlock_mode        		(cdr_pll_pd_fastlock_mode       ),
           .cdr_pll_pd_l_counter            		(cdr_pll_pd_l_counter           ),
           .cdr_pll_pfd_l_counter           		(cdr_pll_pfd_l_counter          ),
           .cdr_pll_pma_width               		(cdr_pll_pma_width              ),
           .cdr_pll_primary_use             		(cdr_pll_primary_use            ),
           .cdr_pll_prot_mode               		(cdr_pll_prot_mode              ),
           .cdr_pll_reference_clock_frequency  		(cdr_pll_reference_clock_frequency ),
           .cdr_pll_reverse_serial_loopback  		(cdr_pll_reverse_serial_loopback ),
           .cdr_pll_set_cdr_input_freq_range  		(cdr_pll_set_cdr_input_freq_range ),
           .cdr_pll_set_cdr_v2i_enable      		(cdr_pll_set_cdr_v2i_enable     ),
           .cdr_pll_set_cdr_vco_reset       		(cdr_pll_set_cdr_vco_reset      ),
           .cdr_pll_set_cdr_vco_speed       		(cdr_pll_set_cdr_vco_speed      ),
           .cdr_pll_set_cdr_vco_speed_fix   		(cdr_pll_set_cdr_vco_speed_fix  ),
           .cdr_pll_set_cdr_vco_speed_pciegen3  		(cdr_pll_set_cdr_vco_speed_pciegen3 ),
           .cdr_pll_sup_mode                		(cdr_pll_sup_mode               ),
           .cdr_pll_tx_pll_prot_mode        		(cdr_pll_tx_pll_prot_mode       ),
           .cdr_pll_txpll_hclk_driver_enable  		(cdr_pll_txpll_hclk_driver_enable ),
           .cdr_pll_uc_ro_cal               		(cdr_pll_uc_ro_cal              ),
           .cdr_pll_vco_freq                		(cdr_pll_vco_freq               ),
           .cdr_pll_vco_overrange_voltage   		(cdr_pll_vco_overrange_voltage  ),
           .cdr_pll_vco_underrange_voltage  		(cdr_pll_vco_underrange_voltage ),
           .pma_rx_buf_bypass_eqz_stages_234  		(pma_rx_buf_bypass_eqz_stages_234 ),
           .pma_rx_buf_datarate             		(pma_rx_buf_datarate            ),
           .pma_rx_buf_diag_lp_en           		(pma_rx_buf_diag_lp_en          ),
           .pma_rx_buf_loopback_modes       		(pma_rx_buf_loopback_modes      ),
           .pma_rx_buf_pm_tx_rx_cvp_mode    		(pma_rx_buf_pm_tx_rx_cvp_mode   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen    		(pma_rx_buf_pm_tx_rx_pcie_gen   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth  		(pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth ),
           .pma_rx_buf_prot_mode            		(pma_rx_buf_prot_mode           ),
           .pma_rx_buf_qpi_enable           		(pma_rx_buf_qpi_enable          ),
           .pma_rx_buf_refclk_en            		(pma_rx_buf_refclk_en           ),
           .pma_rx_buf_rx_refclk_divider    		(pma_rx_buf_rx_refclk_divider   ),
           .pma_rx_buf_sup_mode             		(pma_rx_buf_sup_mode            ),
           .pma_rx_buf_xrx_path_datarate    		(pma_rx_buf_xrx_path_datarate   ),
           .pma_rx_buf_xrx_path_datawidth   		(pma_rx_buf_xrx_path_datawidth  ),
           .pma_rx_buf_xrx_path_pma_rx_divclk_hz  		(pma_rx_buf_xrx_path_pma_rx_divclk_hz ),
           .pma_rx_buf_xrx_path_prot_mode   		(pma_rx_buf_xrx_path_prot_mode  ),
           .pma_rx_buf_xrx_path_sup_mode    		(pma_rx_buf_xrx_path_sup_mode   ),
           .pma_rx_buf_xrx_path_uc_cal_enable  		(pma_rx_buf_xrx_path_uc_cal_enable ),
           .pma_rx_deser_bitslip_bypass     		(pma_rx_deser_bitslip_bypass    ),
           .pma_rx_deser_clkdiv_source      		(pma_rx_deser_clkdiv_source     ),
           .pma_rx_deser_clkdivrx_user_mode  		(pma_rx_deser_clkdivrx_user_mode ),
           .pma_rx_deser_datarate           		(pma_rx_deser_datarate          ),
           .pma_rx_deser_deser_factor       		(pma_rx_deser_deser_factor      ),
           .pma_rx_deser_force_clkdiv_for_testing  		(pma_rx_deser_force_clkdiv_for_testing ),
           .pma_rx_deser_pcie_gen           		(pma_rx_deser_pcie_gen          ),
           .pma_rx_deser_pcie_gen_bitwidth  		(pma_rx_deser_pcie_gen_bitwidth ),
           .pma_rx_deser_prot_mode          		(pma_rx_deser_prot_mode         ),
           .pma_rx_deser_rst_n_adapt_odi    		(pma_rx_deser_rst_n_adapt_odi   ),
           .pma_rx_deser_sdclk_enable       		(pma_rx_deser_sdclk_enable      ),
           .pma_rx_deser_sup_mode           		(pma_rx_deser_sup_mode          ),
           .pma_rx_dfe_datarate             		(pma_rx_dfe_datarate            ),
           .pma_rx_dfe_dft_en               		(pma_rx_dfe_dft_en              ),
           .pma_rx_dfe_pdb                  		(pma_rx_dfe_pdb                 ),
           .pma_rx_dfe_pdb_fixedtap         		(pma_rx_dfe_pdb_fixedtap        ),
           .pma_rx_dfe_pdb_floattap         		(pma_rx_dfe_pdb_floattap        ),
           .pma_rx_dfe_pdb_fxtap4t7         		(pma_rx_dfe_pdb_fxtap4t7        ),
           .pma_rx_dfe_prot_mode            		(pma_rx_dfe_prot_mode           ),
           .pma_rx_dfe_sup_mode             		(pma_rx_dfe_sup_mode            ),
           .pma_rx_odi_datarate             		(pma_rx_odi_datarate            ),
           .pma_rx_odi_prot_mode            		(pma_rx_odi_prot_mode           ),
           .pma_rx_odi_step_ctrl_sel        		(pma_rx_odi_step_ctrl_sel       ),
           .pma_rx_odi_sup_mode             		(pma_rx_odi_sup_mode            ),
           .pma_rx_sd_prot_mode             		(pma_rx_sd_prot_mode            ),
           .pma_rx_sd_sd_output_off         		(pma_rx_sd_sd_output_off        ),
           .pma_rx_sd_sd_output_on          		(pma_rx_sd_sd_output_on         ),
           .pma_rx_sd_sd_pdb                		(pma_rx_sd_sd_pdb               ),
           .pma_rx_sd_sup_mode              		(pma_rx_sd_sup_mode             ),
           .pma_tx_buf_datarate             		(pma_tx_buf_datarate            ),
           .pma_tx_buf_mcgb_location_for_pcie  		(pma_tx_buf_mcgb_location_for_pcie ),
           .pma_tx_buf_prot_mode            		(pma_tx_buf_prot_mode           ),
           .pma_tx_buf_rx_det               		(pma_tx_buf_rx_det              ),
           .pma_tx_buf_rx_det_output_sel    		(pma_tx_buf_rx_det_output_sel   ),
           .pma_tx_buf_rx_det_pdb           		(pma_tx_buf_rx_det_pdb          ),
           .pma_tx_buf_sup_mode             		(pma_tx_buf_sup_mode            ),
           .pma_tx_buf_user_fir_coeff_ctrl_sel  		(pma_tx_buf_user_fir_coeff_ctrl_sel ),
           .pma_tx_buf_xtx_path_clock_divider_ratio  		(pma_tx_buf_xtx_path_clock_divider_ratio ),
           .pma_tx_buf_xtx_path_datarate    		(pma_tx_buf_xtx_path_datarate   ),
           .pma_tx_buf_xtx_path_datawidth   		(pma_tx_buf_xtx_path_datawidth  ),
           .pma_tx_buf_xtx_path_pma_tx_divclk_hz  		(pma_tx_buf_xtx_path_pma_tx_divclk_hz ),
           .pma_tx_buf_xtx_path_prot_mode   		(pma_tx_buf_xtx_path_prot_mode  ),
           .pma_tx_buf_xtx_path_sup_mode    		(pma_tx_buf_xtx_path_sup_mode   ),
           .pma_tx_buf_xtx_path_tx_pll_clk_hz  		(pma_tx_buf_xtx_path_tx_pll_clk_hz ),
           .pma_cgb_bitslip_enable          		(pma_cgb_bitslip_enable         ),
           .pma_cgb_bonding_reset_enable    		(pma_cgb_bonding_reset_enable   ),
           .pma_cgb_datarate                		(pma_cgb_datarate               ),
           .pma_cgb_input_select_gen3       		(pma_cgb_input_select_gen3      ),
           .pma_cgb_input_select_x1         		(pma_cgb_input_select_x1        ),
           .pma_cgb_input_select_xn         		(pma_cgb_input_select_xn        ),
           .pma_cgb_pcie_gen3_bitwidth      		(pma_cgb_pcie_gen3_bitwidth     ),
           .pma_cgb_prot_mode               		(pma_cgb_prot_mode              ),
           .pma_cgb_scratch0_x1_clock_src   		(pma_cgb_scratch0_x1_clock_src  ),
           .pma_cgb_scratch1_x1_clock_src   		(pma_cgb_scratch1_x1_clock_src  ),
           .pma_cgb_scratch2_x1_clock_src   		(pma_cgb_scratch2_x1_clock_src  ),
           .pma_cgb_scratch3_x1_clock_src   		(pma_cgb_scratch3_x1_clock_src  ),
           .pma_cgb_select_done_master_or_slave  		(pma_cgb_select_done_master_or_slave ),
           .pma_cgb_ser_mode                		(pma_cgb_ser_mode               ),
           .pma_cgb_sup_mode                		(pma_cgb_sup_mode               ),
           .pma_cgb_tx_ucontrol_en          		(pma_cgb_tx_ucontrol_en         ),
           .pma_cgb_x1_div_m_sel            		(pma_cgb_x1_div_m_sel           ),
           .pma_tx_ser_prot_mode            		(pma_tx_ser_prot_mode           ),
           .pma_tx_ser_ser_clk_divtx_user_sel  		(pma_tx_ser_ser_clk_divtx_user_sel ),
           .pma_tx_ser_sup_mode             		(pma_tx_ser_sup_mode            ),
           .hssi_10g_rx_pcs_advanced_user_mode  		(hssi_10g_rx_pcs_advanced_user_mode ),
           .hssi_10g_rx_pcs_align_del       		(hssi_10g_rx_pcs_align_del      ),
           .hssi_10g_rx_pcs_ber_bit_err_total_cnt  		(hssi_10g_rx_pcs_ber_bit_err_total_cnt ),
           .hssi_10g_rx_pcs_ber_clken       		(hssi_10g_rx_pcs_ber_clken      ),
           .hssi_10g_rx_pcs_ber_xus_timer_window  		(hssi_10g_rx_pcs_ber_xus_timer_window ),
           .hssi_10g_rx_pcs_bitslip_mode    		(hssi_10g_rx_pcs_bitslip_mode   ),
           .hssi_10g_rx_pcs_blksync_bitslip_type  		(hssi_10g_rx_pcs_blksync_bitslip_type ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_cnt  		(hssi_10g_rx_pcs_blksync_bitslip_wait_cnt ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_type  		(hssi_10g_rx_pcs_blksync_bitslip_wait_type ),
           .hssi_10g_rx_pcs_blksync_bypass  		(hssi_10g_rx_pcs_blksync_bypass ),
           .hssi_10g_rx_pcs_blksync_clken   		(hssi_10g_rx_pcs_blksync_clken  ),
           .hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt  		(hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock ),
           .hssi_10g_rx_pcs_blksync_pipeln  		(hssi_10g_rx_pcs_blksync_pipeln ),
           .hssi_10g_rx_pcs_clr_errblk_cnt_en  		(hssi_10g_rx_pcs_clr_errblk_cnt_en ),
           .hssi_10g_rx_pcs_control_del     		(hssi_10g_rx_pcs_control_del    ),
           .hssi_10g_rx_pcs_crcchk_bypass   		(hssi_10g_rx_pcs_crcchk_bypass  ),
           .hssi_10g_rx_pcs_crcchk_clken    		(hssi_10g_rx_pcs_crcchk_clken   ),
           .hssi_10g_rx_pcs_crcchk_inv      		(hssi_10g_rx_pcs_crcchk_inv     ),
           .hssi_10g_rx_pcs_crcchk_pipeln   		(hssi_10g_rx_pcs_crcchk_pipeln  ),
           .hssi_10g_rx_pcs_crcflag_pipeln  		(hssi_10g_rx_pcs_crcflag_pipeln ),
           .hssi_10g_rx_pcs_ctrl_bit_reverse  		(hssi_10g_rx_pcs_ctrl_bit_reverse ),
           .hssi_10g_rx_pcs_data_bit_reverse  		(hssi_10g_rx_pcs_data_bit_reverse ),
           .hssi_10g_rx_pcs_dec64b66b_clken  		(hssi_10g_rx_pcs_dec64b66b_clken ),
           .hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass  		(hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass ),
           .hssi_10g_rx_pcs_descrm_bypass   		(hssi_10g_rx_pcs_descrm_bypass  ),
           .hssi_10g_rx_pcs_descrm_clken    		(hssi_10g_rx_pcs_descrm_clken   ),
           .hssi_10g_rx_pcs_descrm_mode     		(hssi_10g_rx_pcs_descrm_mode    ),
           .hssi_10g_rx_pcs_descrm_pipeln   		(hssi_10g_rx_pcs_descrm_pipeln  ),
           .hssi_10g_rx_pcs_dft_clk_out_sel  		(hssi_10g_rx_pcs_dft_clk_out_sel ),
           .hssi_10g_rx_pcs_dis_signal_ok   		(hssi_10g_rx_pcs_dis_signal_ok  ),
           .hssi_10g_rx_pcs_dispchk_bypass  		(hssi_10g_rx_pcs_dispchk_bypass ),
           .hssi_10g_rx_pcs_empty_flag_type  		(hssi_10g_rx_pcs_empty_flag_type ),
           .hssi_10g_rx_pcs_fast_path       		(hssi_10g_rx_pcs_fast_path      ),
           .hssi_10g_rx_pcs_fec_clken       		(hssi_10g_rx_pcs_fec_clken      ),
           .hssi_10g_rx_pcs_fec_enable      		(hssi_10g_rx_pcs_fec_enable     ),
           .hssi_10g_rx_pcs_fifo_double_read  		(hssi_10g_rx_pcs_fifo_double_read ),
           .hssi_10g_rx_pcs_fifo_stop_rd    		(hssi_10g_rx_pcs_fifo_stop_rd   ),
           .hssi_10g_rx_pcs_fifo_stop_wr    		(hssi_10g_rx_pcs_fifo_stop_wr   ),
           .hssi_10g_rx_pcs_force_align     		(hssi_10g_rx_pcs_force_align    ),
           .hssi_10g_rx_pcs_frmsync_bypass  		(hssi_10g_rx_pcs_frmsync_bypass ),
           .hssi_10g_rx_pcs_frmsync_clken   		(hssi_10g_rx_pcs_frmsync_clken  ),
           .hssi_10g_rx_pcs_frmsync_enum_scrm  		(hssi_10g_rx_pcs_frmsync_enum_scrm ),
           .hssi_10g_rx_pcs_frmsync_enum_sync  		(hssi_10g_rx_pcs_frmsync_enum_sync ),
           .hssi_10g_rx_pcs_frmsync_flag_type  		(hssi_10g_rx_pcs_frmsync_flag_type ),
           .hssi_10g_rx_pcs_frmsync_knum_sync  		(hssi_10g_rx_pcs_frmsync_knum_sync ),
           .hssi_10g_rx_pcs_frmsync_mfrm_length  		(hssi_10g_rx_pcs_frmsync_mfrm_length ),
           .hssi_10g_rx_pcs_frmsync_pipeln  		(hssi_10g_rx_pcs_frmsync_pipeln ),
           .hssi_10g_rx_pcs_full_flag_type  		(hssi_10g_rx_pcs_full_flag_type ),
           .hssi_10g_rx_pcs_gb_rx_idwidth   		(hssi_10g_rx_pcs_gb_rx_idwidth  ),
           .hssi_10g_rx_pcs_gb_rx_odwidth   		(hssi_10g_rx_pcs_gb_rx_odwidth  ),
           .hssi_10g_rx_pcs_gbexp_clken     		(hssi_10g_rx_pcs_gbexp_clken    ),
           .hssi_10g_rx_pcs_low_latency_en  		(hssi_10g_rx_pcs_low_latency_en ),
           .hssi_10g_rx_pcs_lpbk_mode       		(hssi_10g_rx_pcs_lpbk_mode      ),
           .hssi_10g_rx_pcs_master_clk_sel  		(hssi_10g_rx_pcs_master_clk_sel ),
           .hssi_10g_rx_pcs_pempty_flag_type  		(hssi_10g_rx_pcs_pempty_flag_type ),
           .hssi_10g_rx_pcs_pfull_flag_type  		(hssi_10g_rx_pcs_pfull_flag_type ),
           .hssi_10g_rx_pcs_phcomp_rd_del   		(hssi_10g_rx_pcs_phcomp_rd_del  ),
           .hssi_10g_rx_pcs_pld_if_type     		(hssi_10g_rx_pcs_pld_if_type    ),
           .hssi_10g_rx_pcs_prot_mode       		(hssi_10g_rx_pcs_prot_mode      ),
           .hssi_10g_rx_pcs_rand_clken      		(hssi_10g_rx_pcs_rand_clken     ),
           .hssi_10g_rx_pcs_rd_clk_sel      		(hssi_10g_rx_pcs_rd_clk_sel     ),
           .hssi_10g_rx_pcs_rdfifo_clken    		(hssi_10g_rx_pcs_rdfifo_clken   ),
           .hssi_10g_rx_pcs_reconfig_settings  		(hssi_10g_rx_pcs_reconfig_settings ),
           .hssi_10g_rx_pcs_rx_fifo_write_ctrl  		(hssi_10g_rx_pcs_rx_fifo_write_ctrl ),
           .hssi_10g_rx_pcs_rx_scrm_width   		(hssi_10g_rx_pcs_rx_scrm_width  ),
           .hssi_10g_rx_pcs_rx_sh_location  		(hssi_10g_rx_pcs_rx_sh_location ),
           .hssi_10g_rx_pcs_rx_signal_ok_sel  		(hssi_10g_rx_pcs_rx_signal_ok_sel ),
           .hssi_10g_rx_pcs_rx_sm_bypass    		(hssi_10g_rx_pcs_rx_sm_bypass   ),
           .hssi_10g_rx_pcs_rx_sm_hiber     		(hssi_10g_rx_pcs_rx_sm_hiber    ),
           .hssi_10g_rx_pcs_rx_sm_pipeln    		(hssi_10g_rx_pcs_rx_sm_pipeln   ),
           .hssi_10g_rx_pcs_rx_testbus_sel  		(hssi_10g_rx_pcs_rx_testbus_sel ),
           .hssi_10g_rx_pcs_rx_true_b2b     		(hssi_10g_rx_pcs_rx_true_b2b    ),
           .hssi_10g_rx_pcs_rxfifo_empty    		(hssi_10g_rx_pcs_rxfifo_empty   ),
           .hssi_10g_rx_pcs_rxfifo_full     		(hssi_10g_rx_pcs_rxfifo_full    ),
           .hssi_10g_rx_pcs_rxfifo_mode     		(hssi_10g_rx_pcs_rxfifo_mode    ),
           .hssi_10g_rx_pcs_rxfifo_pempty   		(hssi_10g_rx_pcs_rxfifo_pempty  ),
           .hssi_10g_rx_pcs_rxfifo_pfull    		(hssi_10g_rx_pcs_rxfifo_pfull   ),
           .hssi_10g_rx_pcs_stretch_num_stages  		(hssi_10g_rx_pcs_stretch_num_stages ),
           .hssi_10g_rx_pcs_sup_mode        		(hssi_10g_rx_pcs_sup_mode       ),
           .hssi_10g_rx_pcs_test_mode       		(hssi_10g_rx_pcs_test_mode      ),
           .hssi_10g_rx_pcs_wrfifo_clken    		(hssi_10g_rx_pcs_wrfifo_clken   ),
           .hssi_10g_tx_pcs_advanced_user_mode  		(hssi_10g_tx_pcs_advanced_user_mode ),
           .hssi_10g_tx_pcs_bitslip_en      		(hssi_10g_tx_pcs_bitslip_en     ),
           .hssi_10g_tx_pcs_bonding_dft_en  		(hssi_10g_tx_pcs_bonding_dft_en ),
           .hssi_10g_tx_pcs_bonding_dft_val  		(hssi_10g_tx_pcs_bonding_dft_val ),
           .hssi_10g_tx_pcs_comp_cnt        		(hssi_10g_tx_pcs_comp_cnt       ),
           .hssi_10g_tx_pcs_compin_sel      		(hssi_10g_tx_pcs_compin_sel     ),
           .hssi_10g_tx_pcs_crcgen_bypass   		(hssi_10g_tx_pcs_crcgen_bypass  ),
           .hssi_10g_tx_pcs_crcgen_clken    		(hssi_10g_tx_pcs_crcgen_clken   ),
           .hssi_10g_tx_pcs_crcgen_err      		(hssi_10g_tx_pcs_crcgen_err     ),
           .hssi_10g_tx_pcs_crcgen_inv      		(hssi_10g_tx_pcs_crcgen_inv     ),
           .hssi_10g_tx_pcs_ctrl_bit_reverse  		(hssi_10g_tx_pcs_ctrl_bit_reverse ),
           .hssi_10g_tx_pcs_ctrl_plane_bonding  		(hssi_10g_tx_pcs_ctrl_plane_bonding ),
           .hssi_10g_tx_pcs_data_bit_reverse  		(hssi_10g_tx_pcs_data_bit_reverse ),
           .hssi_10g_tx_pcs_dft_clk_out_sel  		(hssi_10g_tx_pcs_dft_clk_out_sel ),
           .hssi_10g_tx_pcs_dispgen_bypass  		(hssi_10g_tx_pcs_dispgen_bypass ),
           .hssi_10g_tx_pcs_dispgen_clken   		(hssi_10g_tx_pcs_dispgen_clken  ),
           .hssi_10g_tx_pcs_dispgen_err     		(hssi_10g_tx_pcs_dispgen_err    ),
           .hssi_10g_tx_pcs_dispgen_pipeln  		(hssi_10g_tx_pcs_dispgen_pipeln ),
           .hssi_10g_tx_pcs_distdwn_bypass_pipeln  		(hssi_10g_tx_pcs_distdwn_bypass_pipeln ),
           .hssi_10g_tx_pcs_distdwn_master  		(hssi_10g_tx_pcs_distdwn_master ),
           .hssi_10g_tx_pcs_distup_bypass_pipeln  		(hssi_10g_tx_pcs_distup_bypass_pipeln ),
           .hssi_10g_tx_pcs_distup_master   		(hssi_10g_tx_pcs_distup_master  ),
           .hssi_10g_tx_pcs_dv_bond         		(hssi_10g_tx_pcs_dv_bond        ),
           .hssi_10g_tx_pcs_empty_flag_type  		(hssi_10g_tx_pcs_empty_flag_type ),
           .hssi_10g_tx_pcs_enc64b66b_txsm_clken  		(hssi_10g_tx_pcs_enc64b66b_txsm_clken ),
           .hssi_10g_tx_pcs_enc_64b66b_txsm_bypass  		(hssi_10g_tx_pcs_enc_64b66b_txsm_bypass ),
           .hssi_10g_tx_pcs_fastpath        		(hssi_10g_tx_pcs_fastpath       ),
           .hssi_10g_tx_pcs_fec_clken       		(hssi_10g_tx_pcs_fec_clken      ),
           .hssi_10g_tx_pcs_fec_enable      		(hssi_10g_tx_pcs_fec_enable     ),
           .hssi_10g_tx_pcs_fifo_double_write  		(hssi_10g_tx_pcs_fifo_double_write ),
           .hssi_10g_tx_pcs_fifo_reg_fast   		(hssi_10g_tx_pcs_fifo_reg_fast  ),
           .hssi_10g_tx_pcs_fifo_stop_rd    		(hssi_10g_tx_pcs_fifo_stop_rd   ),
           .hssi_10g_tx_pcs_fifo_stop_wr    		(hssi_10g_tx_pcs_fifo_stop_wr   ),
           .hssi_10g_tx_pcs_frmgen_burst    		(hssi_10g_tx_pcs_frmgen_burst   ),
           .hssi_10g_tx_pcs_frmgen_bypass   		(hssi_10g_tx_pcs_frmgen_bypass  ),
           .hssi_10g_tx_pcs_frmgen_clken    		(hssi_10g_tx_pcs_frmgen_clken   ),
           .hssi_10g_tx_pcs_frmgen_mfrm_length  		(hssi_10g_tx_pcs_frmgen_mfrm_length ),
           .hssi_10g_tx_pcs_frmgen_pipeln   		(hssi_10g_tx_pcs_frmgen_pipeln  ),
           .hssi_10g_tx_pcs_frmgen_pyld_ins  		(hssi_10g_tx_pcs_frmgen_pyld_ins ),
           .hssi_10g_tx_pcs_frmgen_wordslip  		(hssi_10g_tx_pcs_frmgen_wordslip ),
           .hssi_10g_tx_pcs_full_flag_type  		(hssi_10g_tx_pcs_full_flag_type ),
           .hssi_10g_tx_pcs_gb_pipeln_bypass  		(hssi_10g_tx_pcs_gb_pipeln_bypass ),
           .hssi_10g_tx_pcs_gb_tx_idwidth   		(hssi_10g_tx_pcs_gb_tx_idwidth  ),
           .hssi_10g_tx_pcs_gb_tx_odwidth   		(hssi_10g_tx_pcs_gb_tx_odwidth  ),
           .hssi_10g_tx_pcs_gbred_clken     		(hssi_10g_tx_pcs_gbred_clken    ),
           .hssi_10g_tx_pcs_indv            		(hssi_10g_tx_pcs_indv           ),
           .hssi_10g_tx_pcs_low_latency_en  		(hssi_10g_tx_pcs_low_latency_en ),
           .hssi_10g_tx_pcs_master_clk_sel  		(hssi_10g_tx_pcs_master_clk_sel ),
           .hssi_10g_tx_pcs_pempty_flag_type  		(hssi_10g_tx_pcs_pempty_flag_type ),
           .hssi_10g_tx_pcs_pfull_flag_type  		(hssi_10g_tx_pcs_pfull_flag_type ),
           .hssi_10g_tx_pcs_phcomp_rd_del   		(hssi_10g_tx_pcs_phcomp_rd_del  ),
           .hssi_10g_tx_pcs_pld_if_type     		(hssi_10g_tx_pcs_pld_if_type    ),
           .hssi_10g_tx_pcs_prot_mode       		(hssi_10g_tx_pcs_prot_mode      ),
           .hssi_10g_tx_pcs_pseudo_random   		(hssi_10g_tx_pcs_pseudo_random  ),
           .hssi_10g_tx_pcs_pseudo_seed_a   		(hssi_10g_tx_pcs_pseudo_seed_a  ),
           .hssi_10g_tx_pcs_pseudo_seed_b   		(hssi_10g_tx_pcs_pseudo_seed_b  ),
           .hssi_10g_tx_pcs_random_disp     		(hssi_10g_tx_pcs_random_disp    ),
           .hssi_10g_tx_pcs_rdfifo_clken    		(hssi_10g_tx_pcs_rdfifo_clken   ),
           .hssi_10g_tx_pcs_reconfig_settings  		(hssi_10g_tx_pcs_reconfig_settings ),
           .hssi_10g_tx_pcs_scrm_bypass     		(hssi_10g_tx_pcs_scrm_bypass    ),
           .hssi_10g_tx_pcs_scrm_clken      		(hssi_10g_tx_pcs_scrm_clken     ),
           .hssi_10g_tx_pcs_scrm_mode       		(hssi_10g_tx_pcs_scrm_mode      ),
           .hssi_10g_tx_pcs_scrm_pipeln     		(hssi_10g_tx_pcs_scrm_pipeln    ),
           .hssi_10g_tx_pcs_sh_err          		(hssi_10g_tx_pcs_sh_err         ),
           .hssi_10g_tx_pcs_sop_mark        		(hssi_10g_tx_pcs_sop_mark       ),
           .hssi_10g_tx_pcs_stretch_num_stages  		(hssi_10g_tx_pcs_stretch_num_stages ),
           .hssi_10g_tx_pcs_sup_mode        		(hssi_10g_tx_pcs_sup_mode       ),
           .hssi_10g_tx_pcs_test_mode       		(hssi_10g_tx_pcs_test_mode      ),
           .hssi_10g_tx_pcs_tx_scrm_err     		(hssi_10g_tx_pcs_tx_scrm_err    ),
           .hssi_10g_tx_pcs_tx_scrm_width   		(hssi_10g_tx_pcs_tx_scrm_width  ),
           .hssi_10g_tx_pcs_tx_sh_location  		(hssi_10g_tx_pcs_tx_sh_location ),
           .hssi_10g_tx_pcs_tx_sm_bypass    		(hssi_10g_tx_pcs_tx_sm_bypass   ),
           .hssi_10g_tx_pcs_tx_sm_pipeln    		(hssi_10g_tx_pcs_tx_sm_pipeln   ),
           .hssi_10g_tx_pcs_tx_testbus_sel  		(hssi_10g_tx_pcs_tx_testbus_sel ),
           .hssi_10g_tx_pcs_txfifo_empty    		(hssi_10g_tx_pcs_txfifo_empty   ),
           .hssi_10g_tx_pcs_txfifo_full     		(hssi_10g_tx_pcs_txfifo_full    ),
           .hssi_10g_tx_pcs_txfifo_mode     		(hssi_10g_tx_pcs_txfifo_mode    ),
           .hssi_10g_tx_pcs_txfifo_pempty   		(hssi_10g_tx_pcs_txfifo_pempty  ),
           .hssi_10g_tx_pcs_txfifo_pfull    		(hssi_10g_tx_pcs_txfifo_pfull   ),
           .hssi_10g_tx_pcs_wr_clk_sel      		(hssi_10g_tx_pcs_wr_clk_sel     ),
           .hssi_10g_tx_pcs_wrfifo_clken    		(hssi_10g_tx_pcs_wrfifo_clken   ),
           .hssi_8g_rx_pcs_auto_error_replacement  		(hssi_8g_rx_pcs_auto_error_replacement ),
           .hssi_8g_rx_pcs_auto_speed_nego  		(hssi_8g_rx_pcs_auto_speed_nego ),
           .hssi_8g_rx_pcs_bit_reversal     		(hssi_8g_rx_pcs_bit_reversal    ),
           .hssi_8g_rx_pcs_bonding_dft_en   		(hssi_8g_rx_pcs_bonding_dft_en  ),
           .hssi_8g_rx_pcs_bonding_dft_val  		(hssi_8g_rx_pcs_bonding_dft_val ),
           .hssi_8g_rx_pcs_bypass_pipeline_reg  		(hssi_8g_rx_pcs_bypass_pipeline_reg ),
           .hssi_8g_rx_pcs_byte_deserializer  		(hssi_8g_rx_pcs_byte_deserializer ),
           .hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask  		(hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask ),
           .hssi_8g_rx_pcs_clkcmp_pattern_n  		(hssi_8g_rx_pcs_clkcmp_pattern_n ),
           .hssi_8g_rx_pcs_clkcmp_pattern_p  		(hssi_8g_rx_pcs_clkcmp_pattern_p ),
           .hssi_8g_rx_pcs_clock_gate_bds_dec_asn  		(hssi_8g_rx_pcs_clock_gate_bds_dec_asn ),
           .hssi_8g_rx_pcs_clock_gate_cdr_eidle  		(hssi_8g_rx_pcs_clock_gate_cdr_eidle ),
           .hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_dw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_dw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_dw_wa  		(hssi_8g_rx_pcs_clock_gate_dw_wa ),
           .hssi_8g_rx_pcs_clock_gate_pc_rdclk  		(hssi_8g_rx_pcs_clock_gate_pc_rdclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_sw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_sw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_sw_wa  		(hssi_8g_rx_pcs_clock_gate_sw_wa ),
           .hssi_8g_rx_pcs_clock_observation_in_pld_core  		(hssi_8g_rx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_rx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_rx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_rx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_rx_pcs_eidle_entry_eios  		(hssi_8g_rx_pcs_eidle_entry_eios ),
           .hssi_8g_rx_pcs_eidle_entry_iei  		(hssi_8g_rx_pcs_eidle_entry_iei ),
           .hssi_8g_rx_pcs_eidle_entry_sd   		(hssi_8g_rx_pcs_eidle_entry_sd  ),
           .hssi_8g_rx_pcs_eightb_tenb_decoder  		(hssi_8g_rx_pcs_eightb_tenb_decoder ),
           .hssi_8g_rx_pcs_err_flags_sel    		(hssi_8g_rx_pcs_err_flags_sel   ),
           .hssi_8g_rx_pcs_fixed_pat_det    		(hssi_8g_rx_pcs_fixed_pat_det   ),
           .hssi_8g_rx_pcs_fixed_pat_num    		(hssi_8g_rx_pcs_fixed_pat_num   ),
           .hssi_8g_rx_pcs_force_signal_detect  		(hssi_8g_rx_pcs_force_signal_detect ),
           .hssi_8g_rx_pcs_gen3_clk_en      		(hssi_8g_rx_pcs_gen3_clk_en     ),
           .hssi_8g_rx_pcs_gen3_rx_clk_sel  		(hssi_8g_rx_pcs_gen3_rx_clk_sel ),
           .hssi_8g_rx_pcs_gen3_tx_clk_sel  		(hssi_8g_rx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_rx_pcs_hip_mode         		(hssi_8g_rx_pcs_hip_mode        ),
           .hssi_8g_rx_pcs_ibm_invalid_code  		(hssi_8g_rx_pcs_ibm_invalid_code ),
           .hssi_8g_rx_pcs_invalid_code_flag_only  		(hssi_8g_rx_pcs_invalid_code_flag_only ),
           .hssi_8g_rx_pcs_pad_or_edb_error_replace  		(hssi_8g_rx_pcs_pad_or_edb_error_replace ),
           .hssi_8g_rx_pcs_pcs_bypass       		(hssi_8g_rx_pcs_pcs_bypass      ),
           .hssi_8g_rx_pcs_phase_comp_rdptr  		(hssi_8g_rx_pcs_phase_comp_rdptr ),
           .hssi_8g_rx_pcs_phase_compensation_fifo  		(hssi_8g_rx_pcs_phase_compensation_fifo ),
           .hssi_8g_rx_pcs_pipe_if_enable   		(hssi_8g_rx_pcs_pipe_if_enable  ),
           .hssi_8g_rx_pcs_pma_dw           		(hssi_8g_rx_pcs_pma_dw          ),
           .hssi_8g_rx_pcs_polinv_8b10b_dec  		(hssi_8g_rx_pcs_polinv_8b10b_dec ),
           .hssi_8g_rx_pcs_prot_mode        		(hssi_8g_rx_pcs_prot_mode       ),
           .hssi_8g_rx_pcs_rate_match       		(hssi_8g_rx_pcs_rate_match      ),
           .hssi_8g_rx_pcs_rate_match_del_thres  		(hssi_8g_rx_pcs_rate_match_del_thres ),
           .hssi_8g_rx_pcs_rate_match_empty_thres  		(hssi_8g_rx_pcs_rate_match_empty_thres ),
           .hssi_8g_rx_pcs_rate_match_full_thres  		(hssi_8g_rx_pcs_rate_match_full_thres ),
           .hssi_8g_rx_pcs_rate_match_ins_thres  		(hssi_8g_rx_pcs_rate_match_ins_thres ),
           .hssi_8g_rx_pcs_rate_match_start_thres  		(hssi_8g_rx_pcs_rate_match_start_thres ),
           .hssi_8g_rx_pcs_reconfig_settings  		(hssi_8g_rx_pcs_reconfig_settings ),
           .hssi_8g_rx_pcs_rx_clk2          		(hssi_8g_rx_pcs_rx_clk2         ),
           .hssi_8g_rx_pcs_rx_clk_free_running  		(hssi_8g_rx_pcs_rx_clk_free_running ),
           .hssi_8g_rx_pcs_rx_pcs_urst      		(hssi_8g_rx_pcs_rx_pcs_urst     ),
           .hssi_8g_rx_pcs_rx_rcvd_clk      		(hssi_8g_rx_pcs_rx_rcvd_clk     ),
           .hssi_8g_rx_pcs_rx_rd_clk        		(hssi_8g_rx_pcs_rx_rd_clk       ),
           .hssi_8g_rx_pcs_rx_refclk        		(hssi_8g_rx_pcs_rx_refclk       ),
           .hssi_8g_rx_pcs_rx_wr_clk        		(hssi_8g_rx_pcs_rx_wr_clk       ),
           .hssi_8g_rx_pcs_sup_mode         		(hssi_8g_rx_pcs_sup_mode        ),
           .hssi_8g_rx_pcs_symbol_swap      		(hssi_8g_rx_pcs_symbol_swap     ),
           .hssi_8g_rx_pcs_sync_sm_idle_eios  		(hssi_8g_rx_pcs_sync_sm_idle_eios ),
           .hssi_8g_rx_pcs_test_bus_sel     		(hssi_8g_rx_pcs_test_bus_sel    ),
           .hssi_8g_rx_pcs_tx_rx_parallel_loopback  		(hssi_8g_rx_pcs_tx_rx_parallel_loopback ),
           .hssi_8g_rx_pcs_wa_boundary_lock_ctrl  		(hssi_8g_rx_pcs_wa_boundary_lock_ctrl ),
           .hssi_8g_rx_pcs_wa_clk_slip_spacing  		(hssi_8g_rx_pcs_wa_clk_slip_spacing ),
           .hssi_8g_rx_pcs_wa_det_latency_sync_status_beh  		(hssi_8g_rx_pcs_wa_det_latency_sync_status_beh ),
           .hssi_8g_rx_pcs_wa_disp_err_flag  		(hssi_8g_rx_pcs_wa_disp_err_flag ),
           .hssi_8g_rx_pcs_wa_kchar         		(hssi_8g_rx_pcs_wa_kchar        ),
           .hssi_8g_rx_pcs_wa_pd            		(hssi_8g_rx_pcs_wa_pd           ),
           .hssi_8g_rx_pcs_wa_pd_data       		(hssi_8g_rx_pcs_wa_pd_data      ),
           .hssi_8g_rx_pcs_wa_pd_polarity   		(hssi_8g_rx_pcs_wa_pd_polarity  ),
           .hssi_8g_rx_pcs_wa_pld_controlled  		(hssi_8g_rx_pcs_wa_pld_controlled ),
           .hssi_8g_rx_pcs_wa_renumber_data  		(hssi_8g_rx_pcs_wa_renumber_data ),
           .hssi_8g_rx_pcs_wa_rgnumber_data  		(hssi_8g_rx_pcs_wa_rgnumber_data ),
           .hssi_8g_rx_pcs_wa_rknumber_data  		(hssi_8g_rx_pcs_wa_rknumber_data ),
           .hssi_8g_rx_pcs_wa_rosnumber_data  		(hssi_8g_rx_pcs_wa_rosnumber_data ),
           .hssi_8g_rx_pcs_wa_rvnumber_data  		(hssi_8g_rx_pcs_wa_rvnumber_data ),
           .hssi_8g_rx_pcs_wa_sync_sm_ctrl  		(hssi_8g_rx_pcs_wa_sync_sm_ctrl ),
           .hssi_8g_rx_pcs_wait_cnt         		(hssi_8g_rx_pcs_wait_cnt        ),
           .hssi_8g_tx_pcs_auto_speed_nego_gen2  		(hssi_8g_tx_pcs_auto_speed_nego_gen2 ),
           .hssi_8g_tx_pcs_bit_reversal     		(hssi_8g_tx_pcs_bit_reversal    ),
           .hssi_8g_tx_pcs_bonding_dft_en   		(hssi_8g_tx_pcs_bonding_dft_en  ),
           .hssi_8g_tx_pcs_bonding_dft_val  		(hssi_8g_tx_pcs_bonding_dft_val ),
           .hssi_8g_tx_pcs_bypass_pipeline_reg  		(hssi_8g_tx_pcs_bypass_pipeline_reg ),
           .hssi_8g_tx_pcs_byte_serializer  		(hssi_8g_tx_pcs_byte_serializer ),
           .hssi_8g_tx_pcs_clock_gate_bs_enc  		(hssi_8g_tx_pcs_clock_gate_bs_enc ),
           .hssi_8g_tx_pcs_clock_gate_dw_fifowr  		(hssi_8g_tx_pcs_clock_gate_dw_fifowr ),
           .hssi_8g_tx_pcs_clock_gate_fiford  		(hssi_8g_tx_pcs_clock_gate_fiford ),
           .hssi_8g_tx_pcs_clock_gate_sw_fifowr  		(hssi_8g_tx_pcs_clock_gate_sw_fifowr ),
           .hssi_8g_tx_pcs_clock_observation_in_pld_core  		(hssi_8g_tx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_tx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_tx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_tx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_tx_pcs_data_selection_8b10b_encoder_input  		(hssi_8g_tx_pcs_data_selection_8b10b_encoder_input ),
           .hssi_8g_tx_pcs_dynamic_clk_switch  		(hssi_8g_tx_pcs_dynamic_clk_switch ),
           .hssi_8g_tx_pcs_eightb_tenb_disp_ctrl  		(hssi_8g_tx_pcs_eightb_tenb_disp_ctrl ),
           .hssi_8g_tx_pcs_eightb_tenb_encoder  		(hssi_8g_tx_pcs_eightb_tenb_encoder ),
           .hssi_8g_tx_pcs_force_echar      		(hssi_8g_tx_pcs_force_echar     ),
           .hssi_8g_tx_pcs_force_kchar      		(hssi_8g_tx_pcs_force_kchar     ),
           .hssi_8g_tx_pcs_gen3_tx_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel ),
           .hssi_8g_tx_pcs_hip_mode         		(hssi_8g_tx_pcs_hip_mode        ),
           .hssi_8g_tx_pcs_pcs_bypass       		(hssi_8g_tx_pcs_pcs_bypass      ),
           .hssi_8g_tx_pcs_phase_comp_rdptr  		(hssi_8g_tx_pcs_phase_comp_rdptr ),
           .hssi_8g_tx_pcs_phase_compensation_fifo  		(hssi_8g_tx_pcs_phase_compensation_fifo ),
           .hssi_8g_tx_pcs_phfifo_write_clk_sel  		(hssi_8g_tx_pcs_phfifo_write_clk_sel ),
           .hssi_8g_tx_pcs_pma_dw           		(hssi_8g_tx_pcs_pma_dw          ),
           .hssi_8g_tx_pcs_prot_mode        		(hssi_8g_tx_pcs_prot_mode       ),
           .hssi_8g_tx_pcs_reconfig_settings  		(hssi_8g_tx_pcs_reconfig_settings ),
           .hssi_8g_tx_pcs_refclk_b_clk_sel  		(hssi_8g_tx_pcs_refclk_b_clk_sel ),
           .hssi_8g_tx_pcs_revloop_back_rm  		(hssi_8g_tx_pcs_revloop_back_rm ),
           .hssi_8g_tx_pcs_sup_mode         		(hssi_8g_tx_pcs_sup_mode        ),
           .hssi_8g_tx_pcs_symbol_swap      		(hssi_8g_tx_pcs_symbol_swap     ),
           .hssi_8g_tx_pcs_tx_bitslip       		(hssi_8g_tx_pcs_tx_bitslip      ),
           .hssi_8g_tx_pcs_tx_compliance_controlled_disparity  		(hssi_8g_tx_pcs_tx_compliance_controlled_disparity ),
           .hssi_8g_tx_pcs_tx_fast_pld_reg  		(hssi_8g_tx_pcs_tx_fast_pld_reg ),
           .hssi_8g_tx_pcs_txclk_freerun    		(hssi_8g_tx_pcs_txclk_freerun   ),
           .hssi_8g_tx_pcs_txpcs_urst       		(hssi_8g_tx_pcs_txpcs_urst      ),
           .hssi_common_pcs_pma_interface_asn_clk_enable  		(hssi_common_pcs_pma_interface_asn_clk_enable ),
           .hssi_common_pcs_pma_interface_asn_enable  		(hssi_common_pcs_pma_interface_asn_enable ),
           .hssi_common_pcs_pma_interface_block_sel  		(hssi_common_pcs_pma_interface_block_sel ),
           .hssi_common_pcs_pma_interface_bypass_early_eios  		(hssi_common_pcs_pma_interface_bypass_early_eios ),
           .hssi_common_pcs_pma_interface_bypass_pcie_switch  		(hssi_common_pcs_pma_interface_bypass_pcie_switch ),
           .hssi_common_pcs_pma_interface_bypass_pma_ltr  		(hssi_common_pcs_pma_interface_bypass_pma_ltr ),
           .hssi_common_pcs_pma_interface_bypass_pma_sw_done  		(hssi_common_pcs_pma_interface_bypass_pma_sw_done ),
           .hssi_common_pcs_pma_interface_bypass_ppm_lock  		(hssi_common_pcs_pma_interface_bypass_ppm_lock ),
           .hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp ),
           .hssi_common_pcs_pma_interface_bypass_txdetectrx  		(hssi_common_pcs_pma_interface_bypass_txdetectrx ),
           .hssi_common_pcs_pma_interface_cdr_control  		(hssi_common_pcs_pma_interface_cdr_control ),
           .hssi_common_pcs_pma_interface_cid_enable  		(hssi_common_pcs_pma_interface_cid_enable ),
           .hssi_common_pcs_pma_interface_cp_cons_sel  		(hssi_common_pcs_pma_interface_cp_cons_sel ),
           .hssi_common_pcs_pma_interface_cp_dwn_mstr  		(hssi_common_pcs_pma_interface_cp_dwn_mstr ),
           .hssi_common_pcs_pma_interface_cp_up_mstr  		(hssi_common_pcs_pma_interface_cp_up_mstr ),
           .hssi_common_pcs_pma_interface_ctrl_plane_bonding  		(hssi_common_pcs_pma_interface_ctrl_plane_bonding ),
           .hssi_common_pcs_pma_interface_data_mask_count  		(hssi_common_pcs_pma_interface_data_mask_count ),
           .hssi_common_pcs_pma_interface_data_mask_count_multi  		(hssi_common_pcs_pma_interface_data_mask_count_multi ),
           .hssi_common_pcs_pma_interface_dft_observation_clock_selection  		(hssi_common_pcs_pma_interface_dft_observation_clock_selection ),
           .hssi_common_pcs_pma_interface_early_eios_counter  		(hssi_common_pcs_pma_interface_early_eios_counter ),
           .hssi_common_pcs_pma_interface_force_freqdet  		(hssi_common_pcs_pma_interface_force_freqdet ),
           .hssi_common_pcs_pma_interface_free_run_clk_enable  		(hssi_common_pcs_pma_interface_free_run_clk_enable ),
           .hssi_common_pcs_pma_interface_ignore_sigdet_g23  		(hssi_common_pcs_pma_interface_ignore_sigdet_g23 ),
           .hssi_common_pcs_pma_interface_pc_en_counter  		(hssi_common_pcs_pma_interface_pc_en_counter ),
           .hssi_common_pcs_pma_interface_pc_rst_counter  		(hssi_common_pcs_pma_interface_pc_rst_counter ),
           .hssi_common_pcs_pma_interface_pcie_hip_mode  		(hssi_common_pcs_pma_interface_pcie_hip_mode ),
           .hssi_common_pcs_pma_interface_ph_fifo_reg_mode  		(hssi_common_pcs_pma_interface_ph_fifo_reg_mode ),
           .hssi_common_pcs_pma_interface_phfifo_flush_wait  		(hssi_common_pcs_pma_interface_phfifo_flush_wait ),
           .hssi_common_pcs_pma_interface_pipe_if_g3pcs  		(hssi_common_pcs_pma_interface_pipe_if_g3pcs ),
           .hssi_common_pcs_pma_interface_pma_done_counter  		(hssi_common_pcs_pma_interface_pma_done_counter ),
           .hssi_common_pcs_pma_interface_pma_if_dft_en  		(hssi_common_pcs_pma_interface_pma_if_dft_en ),
           .hssi_common_pcs_pma_interface_pma_if_dft_val  		(hssi_common_pcs_pma_interface_pma_if_dft_val ),
           .hssi_common_pcs_pma_interface_ppm_cnt_rst  		(hssi_common_pcs_pma_interface_ppm_cnt_rst ),
           .hssi_common_pcs_pma_interface_ppm_deassert_early  		(hssi_common_pcs_pma_interface_ppm_deassert_early ),
           .hssi_common_pcs_pma_interface_ppm_det_buckets  		(hssi_common_pcs_pma_interface_ppm_det_buckets ),
           .hssi_common_pcs_pma_interface_ppm_gen1_2_cnt  		(hssi_common_pcs_pma_interface_ppm_gen1_2_cnt ),
           .hssi_common_pcs_pma_interface_ppm_post_eidle_delay  		(hssi_common_pcs_pma_interface_ppm_post_eidle_delay ),
           .hssi_common_pcs_pma_interface_ppmsel  		(hssi_common_pcs_pma_interface_ppmsel ),
           .hssi_common_pcs_pma_interface_prot_mode  		(hssi_common_pcs_pma_interface_prot_mode ),
           .hssi_common_pcs_pma_interface_reconfig_settings  		(hssi_common_pcs_pma_interface_reconfig_settings ),
           .hssi_common_pcs_pma_interface_rxvalid_mask  		(hssi_common_pcs_pma_interface_rxvalid_mask ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter  		(hssi_common_pcs_pma_interface_sigdet_wait_counter ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter_multi  		(hssi_common_pcs_pma_interface_sigdet_wait_counter_multi ),
           .hssi_common_pcs_pma_interface_sim_mode  		(hssi_common_pcs_pma_interface_sim_mode ),
           .hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en  		(hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en ),
           .hssi_common_pcs_pma_interface_sup_mode  		(hssi_common_pcs_pma_interface_sup_mode ),
           .hssi_common_pcs_pma_interface_testout_sel  		(hssi_common_pcs_pma_interface_testout_sel ),
           .hssi_common_pcs_pma_interface_wait_clk_on_off_timer  		(hssi_common_pcs_pma_interface_wait_clk_on_off_timer ),
           .hssi_common_pcs_pma_interface_wait_pipe_synchronizing  		(hssi_common_pcs_pma_interface_wait_pipe_synchronizing ),
           .hssi_common_pcs_pma_interface_wait_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_wait_send_syncp_fbkp ),
           .hssi_common_pld_pcs_interface_dft_clk_out_en  		(hssi_common_pld_pcs_interface_dft_clk_out_en ),
           .hssi_common_pld_pcs_interface_dft_clk_out_sel  		(hssi_common_pld_pcs_interface_dft_clk_out_sel ),
           .hssi_common_pld_pcs_interface_hrdrstctrl_en  		(hssi_common_pld_pcs_interface_hrdrstctrl_en ),
           .hssi_common_pld_pcs_interface_pcs_testbus_block_sel  		(hssi_common_pld_pcs_interface_pcs_testbus_block_sel ),
           .hssi_common_pld_pcs_interface_reconfig_settings  		(hssi_common_pld_pcs_interface_reconfig_settings ),
           .hssi_fifo_rx_pcs_double_read_mode  		(hssi_fifo_rx_pcs_double_read_mode ),
           .hssi_fifo_rx_pcs_prot_mode      		(hssi_fifo_rx_pcs_prot_mode     ),
           .hssi_fifo_tx_pcs_double_write_mode  		(hssi_fifo_tx_pcs_double_write_mode ),
           .hssi_fifo_tx_pcs_prot_mode      		(hssi_fifo_tx_pcs_prot_mode     ),
           .hssi_gen3_rx_pcs_block_sync     		(hssi_gen3_rx_pcs_block_sync    ),
           .hssi_gen3_rx_pcs_block_sync_sm  		(hssi_gen3_rx_pcs_block_sync_sm ),
           .hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn  		(hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn ),
           .hssi_gen3_rx_pcs_lpbk_force     		(hssi_gen3_rx_pcs_lpbk_force    ),
           .hssi_gen3_rx_pcs_mode           		(hssi_gen3_rx_pcs_mode          ),
           .hssi_gen3_rx_pcs_rate_match_fifo  		(hssi_gen3_rx_pcs_rate_match_fifo ),
           .hssi_gen3_rx_pcs_rate_match_fifo_latency  		(hssi_gen3_rx_pcs_rate_match_fifo_latency ),
           .hssi_gen3_rx_pcs_reconfig_settings  		(hssi_gen3_rx_pcs_reconfig_settings ),
           .hssi_gen3_rx_pcs_reverse_lpbk   		(hssi_gen3_rx_pcs_reverse_lpbk  ),
           .hssi_gen3_rx_pcs_rx_b4gb_par_lpbk  		(hssi_gen3_rx_pcs_rx_b4gb_par_lpbk ),
           .hssi_gen3_rx_pcs_rx_force_balign  		(hssi_gen3_rx_pcs_rx_force_balign ),
           .hssi_gen3_rx_pcs_rx_ins_del_one_skip  		(hssi_gen3_rx_pcs_rx_ins_del_one_skip ),
           .hssi_gen3_rx_pcs_rx_num_fixed_pat  		(hssi_gen3_rx_pcs_rx_num_fixed_pat ),
           .hssi_gen3_rx_pcs_rx_test_out_sel  		(hssi_gen3_rx_pcs_rx_test_out_sel ),
           .hssi_gen3_rx_pcs_sup_mode       		(hssi_gen3_rx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_mode           		(hssi_gen3_tx_pcs_mode          ),
           .hssi_gen3_tx_pcs_reverse_lpbk   		(hssi_gen3_tx_pcs_reverse_lpbk  ),
           .hssi_gen3_tx_pcs_sup_mode       		(hssi_gen3_tx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_tx_bitslip     		(hssi_gen3_tx_pcs_tx_bitslip    ),
           .hssi_gen3_tx_pcs_tx_gbox_byp    		(hssi_gen3_tx_pcs_tx_gbox_byp   ),
           .hssi_krfec_rx_pcs_blksync_cor_en  		(hssi_krfec_rx_pcs_blksync_cor_en ),
           .hssi_krfec_rx_pcs_bypass_gb     		(hssi_krfec_rx_pcs_bypass_gb    ),
           .hssi_krfec_rx_pcs_clr_ctrl      		(hssi_krfec_rx_pcs_clr_ctrl     ),
           .hssi_krfec_rx_pcs_ctrl_bit_reverse  		(hssi_krfec_rx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_rx_pcs_data_bit_reverse  		(hssi_krfec_rx_pcs_data_bit_reverse ),
           .hssi_krfec_rx_pcs_dv_start      		(hssi_krfec_rx_pcs_dv_start     ),
           .hssi_krfec_rx_pcs_err_mark_type  		(hssi_krfec_rx_pcs_err_mark_type ),
           .hssi_krfec_rx_pcs_error_marking_en  		(hssi_krfec_rx_pcs_error_marking_en ),
           .hssi_krfec_rx_pcs_low_latency_en  		(hssi_krfec_rx_pcs_low_latency_en ),
           .hssi_krfec_rx_pcs_lpbk_mode     		(hssi_krfec_rx_pcs_lpbk_mode    ),
           .hssi_krfec_rx_pcs_parity_invalid_enum  		(hssi_krfec_rx_pcs_parity_invalid_enum ),
           .hssi_krfec_rx_pcs_parity_valid_num  		(hssi_krfec_rx_pcs_parity_valid_num ),
           .hssi_krfec_rx_pcs_pipeln_blksync  		(hssi_krfec_rx_pcs_pipeln_blksync ),
           .hssi_krfec_rx_pcs_pipeln_descrm  		(hssi_krfec_rx_pcs_pipeln_descrm ),
           .hssi_krfec_rx_pcs_pipeln_errcorrect  		(hssi_krfec_rx_pcs_pipeln_errcorrect ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_ind  		(hssi_krfec_rx_pcs_pipeln_errtrap_ind ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_lfsr  		(hssi_krfec_rx_pcs_pipeln_errtrap_lfsr ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_loc  		(hssi_krfec_rx_pcs_pipeln_errtrap_loc ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_pat  		(hssi_krfec_rx_pcs_pipeln_errtrap_pat ),
           .hssi_krfec_rx_pcs_pipeln_gearbox  		(hssi_krfec_rx_pcs_pipeln_gearbox ),
           .hssi_krfec_rx_pcs_pipeln_syndrm  		(hssi_krfec_rx_pcs_pipeln_syndrm ),
           .hssi_krfec_rx_pcs_pipeln_trans_dec  		(hssi_krfec_rx_pcs_pipeln_trans_dec ),
           .hssi_krfec_rx_pcs_prot_mode     		(hssi_krfec_rx_pcs_prot_mode    ),
           .hssi_krfec_rx_pcs_receive_order  		(hssi_krfec_rx_pcs_receive_order ),
           .hssi_krfec_rx_pcs_reconfig_settings  		(hssi_krfec_rx_pcs_reconfig_settings ),
           .hssi_krfec_rx_pcs_rx_testbus_sel  		(hssi_krfec_rx_pcs_rx_testbus_sel ),
           .hssi_krfec_rx_pcs_signal_ok_en  		(hssi_krfec_rx_pcs_signal_ok_en ),
           .hssi_krfec_rx_pcs_sup_mode      		(hssi_krfec_rx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_burst_err     		(hssi_krfec_tx_pcs_burst_err    ),
           .hssi_krfec_tx_pcs_burst_err_len  		(hssi_krfec_tx_pcs_burst_err_len ),
           .hssi_krfec_tx_pcs_ctrl_bit_reverse  		(hssi_krfec_tx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_tx_pcs_data_bit_reverse  		(hssi_krfec_tx_pcs_data_bit_reverse ),
           .hssi_krfec_tx_pcs_enc_frame_query  		(hssi_krfec_tx_pcs_enc_frame_query ),
           .hssi_krfec_tx_pcs_low_latency_en  		(hssi_krfec_tx_pcs_low_latency_en ),
           .hssi_krfec_tx_pcs_pipeln_encoder  		(hssi_krfec_tx_pcs_pipeln_encoder ),
           .hssi_krfec_tx_pcs_pipeln_scrambler  		(hssi_krfec_tx_pcs_pipeln_scrambler ),
           .hssi_krfec_tx_pcs_prot_mode     		(hssi_krfec_tx_pcs_prot_mode    ),
           .hssi_krfec_tx_pcs_sup_mode      		(hssi_krfec_tx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_transcode_err  		(hssi_krfec_tx_pcs_transcode_err ),
           .hssi_krfec_tx_pcs_transmit_order  		(hssi_krfec_tx_pcs_transmit_order ),
           .hssi_krfec_tx_pcs_tx_testbus_sel  		(hssi_krfec_tx_pcs_tx_testbus_sel ),
           .hssi_pipe_gen1_2_elec_idle_delay_val  		(hssi_pipe_gen1_2_elec_idle_delay_val ),
           .hssi_pipe_gen1_2_error_replace_pad  		(hssi_pipe_gen1_2_error_replace_pad ),
           .hssi_pipe_gen1_2_hip_mode       		(hssi_pipe_gen1_2_hip_mode      ),
           .hssi_pipe_gen1_2_ind_error_reporting  		(hssi_pipe_gen1_2_ind_error_reporting ),
           .hssi_pipe_gen1_2_phystatus_delay_val  		(hssi_pipe_gen1_2_phystatus_delay_val ),
           .hssi_pipe_gen1_2_phystatus_rst_toggle  		(hssi_pipe_gen1_2_phystatus_rst_toggle ),
           .hssi_pipe_gen1_2_pipe_byte_de_serializer_en  		(hssi_pipe_gen1_2_pipe_byte_de_serializer_en ),
           .hssi_pipe_gen1_2_prot_mode      		(hssi_pipe_gen1_2_prot_mode     ),
           .hssi_pipe_gen1_2_reconfig_settings  		(hssi_pipe_gen1_2_reconfig_settings ),
           .hssi_pipe_gen1_2_rx_pipe_enable  		(hssi_pipe_gen1_2_rx_pipe_enable ),
           .hssi_pipe_gen1_2_rxdetect_bypass  		(hssi_pipe_gen1_2_rxdetect_bypass ),
           .hssi_pipe_gen1_2_sup_mode       		(hssi_pipe_gen1_2_sup_mode      ),
           .hssi_pipe_gen1_2_tx_pipe_enable  		(hssi_pipe_gen1_2_tx_pipe_enable ),
           .hssi_pipe_gen1_2_txswing        		(hssi_pipe_gen1_2_txswing       ),
           .hssi_pipe_gen3_bypass_rx_detection_enable  		(hssi_pipe_gen3_bypass_rx_detection_enable ),
           .hssi_pipe_gen3_bypass_rx_preset  		(hssi_pipe_gen3_bypass_rx_preset ),
           .hssi_pipe_gen3_bypass_rx_preset_enable  		(hssi_pipe_gen3_bypass_rx_preset_enable ),
           .hssi_pipe_gen3_bypass_tx_coefficent  		(hssi_pipe_gen3_bypass_tx_coefficent ),
           .hssi_pipe_gen3_bypass_tx_coefficent_enable  		(hssi_pipe_gen3_bypass_tx_coefficent_enable ),
           .hssi_pipe_gen3_elecidle_delay_g3  		(hssi_pipe_gen3_elecidle_delay_g3 ),
           .hssi_pipe_gen3_ind_error_reporting  		(hssi_pipe_gen3_ind_error_reporting ),
           .hssi_pipe_gen3_mode             		(hssi_pipe_gen3_mode            ),
           .hssi_pipe_gen3_phy_status_delay_g12  		(hssi_pipe_gen3_phy_status_delay_g12 ),
           .hssi_pipe_gen3_phy_status_delay_g3  		(hssi_pipe_gen3_phy_status_delay_g3 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g12  		(hssi_pipe_gen3_phystatus_rst_toggle_g12 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g3  		(hssi_pipe_gen3_phystatus_rst_toggle_g3 ),
           .hssi_pipe_gen3_rate_match_pad_insertion  		(hssi_pipe_gen3_rate_match_pad_insertion ),
           .hssi_pipe_gen3_sup_mode         		(hssi_pipe_gen3_sup_mode        ),
           .hssi_pipe_gen3_test_out_sel     		(hssi_pipe_gen3_test_out_sel    ),
           .hssi_rx_pcs_pma_interface_block_sel  		(hssi_rx_pcs_pma_interface_block_sel ),
           .hssi_rx_pcs_pma_interface_channel_operation_mode  		(hssi_rx_pcs_pma_interface_channel_operation_mode ),
           .hssi_rx_pcs_pma_interface_clkslip_sel  		(hssi_rx_pcs_pma_interface_clkslip_sel ),
           .hssi_rx_pcs_pma_interface_lpbk_en  		(hssi_rx_pcs_pma_interface_lpbk_en ),
           .hssi_rx_pcs_pma_interface_master_clk_sel  		(hssi_rx_pcs_pma_interface_master_clk_sel ),
           .hssi_rx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_rx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_rx_pcs_pma_interface_pma_dw_rx  		(hssi_rx_pcs_pma_interface_pma_dw_rx ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_en  		(hssi_rx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_val  		(hssi_rx_pcs_pma_interface_pma_if_dft_val ),
           .hssi_rx_pcs_pma_interface_prbs9_dwidth  		(hssi_rx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_rx_pcs_pma_interface_prbs_clken  		(hssi_rx_pcs_pma_interface_prbs_clken ),
           .hssi_rx_pcs_pma_interface_prbs_ver  		(hssi_rx_pcs_pma_interface_prbs_ver ),
           .hssi_rx_pcs_pma_interface_prot_mode_rx  		(hssi_rx_pcs_pma_interface_prot_mode_rx ),
           .hssi_rx_pcs_pma_interface_reconfig_settings  		(hssi_rx_pcs_pma_interface_reconfig_settings ),
           .hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_lpbk_en ),
           .hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok  		(hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mask  		(hssi_rx_pcs_pma_interface_rx_prbs_mask ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mode  		(hssi_rx_pcs_pma_interface_rx_prbs_mode ),
           .hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel  		(hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel ),
           .hssi_rx_pcs_pma_interface_rx_static_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_static_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en ),
           .hssi_rx_pcs_pma_interface_sup_mode  		(hssi_rx_pcs_pma_interface_sup_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_rx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_rx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_rx_pld_pcs_interface_pcs_rx_block_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_block_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en  		(hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en ),
           .hssi_rx_pld_pcs_interface_pcs_rx_output_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_output_sel ),
           .hssi_rx_pld_pcs_interface_reconfig_settings  		(hssi_rx_pld_pcs_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_bypass_pma_txelecidle  		(hssi_tx_pcs_pma_interface_bypass_pma_txelecidle ),
           .hssi_tx_pcs_pma_interface_channel_operation_mode  		(hssi_tx_pcs_pma_interface_channel_operation_mode ),
           .hssi_tx_pcs_pma_interface_lpbk_en  		(hssi_tx_pcs_pma_interface_lpbk_en ),
           .hssi_tx_pcs_pma_interface_master_clk_sel  		(hssi_tx_pcs_pma_interface_master_clk_sel ),
           .hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx  		(hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_tx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_tx_pcs_pma_interface_pma_dw_tx  		(hssi_tx_pcs_pma_interface_pma_dw_tx ),
           .hssi_tx_pcs_pma_interface_pma_if_dft_en  		(hssi_tx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_tx_pcs_pma_interface_pmagate_en  		(hssi_tx_pcs_pma_interface_pmagate_en ),
           .hssi_tx_pcs_pma_interface_prbs9_dwidth  		(hssi_tx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_tx_pcs_pma_interface_prbs_clken  		(hssi_tx_pcs_pma_interface_prbs_clken ),
           .hssi_tx_pcs_pma_interface_prbs_gen_pat  		(hssi_tx_pcs_pma_interface_prbs_gen_pat ),
           .hssi_tx_pcs_pma_interface_prot_mode_tx  		(hssi_tx_pcs_pma_interface_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_reconfig_settings  		(hssi_tx_pcs_pma_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_sq_wave_num  		(hssi_tx_pcs_pma_interface_sq_wave_num ),
           .hssi_tx_pcs_pma_interface_sqwgen_clken  		(hssi_tx_pcs_pma_interface_sqwgen_clken ),
           .hssi_tx_pcs_pma_interface_sup_mode  		(hssi_tx_pcs_pma_interface_sup_mode ),
           .hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_tx_pma_data_sel  		(hssi_tx_pcs_pma_interface_tx_pma_data_sel ),
           .hssi_tx_pcs_pma_interface_tx_static_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_static_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period  		(hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable  		(hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control ),
           .hssi_tx_pcs_pma_interface_uhsif_enable  		(hssi_tx_pcs_pma_interface_uhsif_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value ),
           .hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_tx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_tx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding  		(hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_source  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_data_source  		(hssi_tx_pld_pcs_interface_pcs_tx_data_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_output_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_output_sel ),
           .hssi_tx_pld_pcs_interface_reconfig_settings  		(hssi_tx_pld_pcs_interface_reconfig_settings ),
           .avmm_interfaces                 		(avmm_interfaces                ),
           .rcfg_enable                     		(rcfg_enable                    ),
           .enable_avmm                     		(enable_avmm                    ),
           .arbiter_ctrl                    		(arbiter_ctrl                   ),
           .calibration_en                  		(calibration_en                 ),
           .avmm_busy_en                    		(avmm_busy_en                   ),
           .hip_cal_en                      		(hip_cal_en                     ),
           .cal_done                        		(cal_done                       )
                  )
               twentynm_xcvr_native_inst(.*);
             end


  "20nm2":   begin
               twentynm_xcvr_native_rev_20nm2
                 #(
			
           .bonded_lanes                    		(bonded_lanes                   ),
           .bonding_master_ch               		(bonding_master_ch              ),
           .xcvr_native_mode                		(xcvr_native_mode               ),
           .pma_adapt_adapt_mode            		(pma_adapt_adapt_mode           ),
           .pma_adapt_adp_1s_ctle_bypass    		(pma_adapt_adp_1s_ctle_bypass   ),
           .pma_adapt_adp_4s_ctle_bypass    		(pma_adapt_adp_4s_ctle_bypass   ),
           .pma_adapt_adp_ctle_adapt_cycle_window  		(pma_adapt_adp_ctle_adapt_cycle_window ),
           .pma_adapt_adp_ctle_en           		(pma_adapt_adp_ctle_en          ),
           .pma_adapt_adp_dfe_fltap_bypass  		(pma_adapt_adp_dfe_fltap_bypass ),
           .pma_adapt_adp_dfe_fltap_en      		(pma_adapt_adp_dfe_fltap_en     ),
           .pma_adapt_adp_dfe_fxtap_bypass  		(pma_adapt_adp_dfe_fxtap_bypass ),
           .pma_adapt_adp_dfe_fxtap_en      		(pma_adapt_adp_dfe_fxtap_en     ),
           .pma_adapt_adp_dfe_fxtap_hold_en  		(pma_adapt_adp_dfe_fxtap_hold_en ),
           .pma_adapt_adp_dfe_mode          		(pma_adapt_adp_dfe_mode         ),
           .pma_adapt_adp_mode              		(pma_adapt_adp_mode             ),
           .pma_adapt_adp_onetime_dfe       		(pma_adapt_adp_onetime_dfe      ),
           .pma_adapt_adp_vga_bypass        		(pma_adapt_adp_vga_bypass       ),
           .pma_adapt_adp_vga_en            		(pma_adapt_adp_vga_en           ),
           .pma_adapt_adp_vref_bypass       		(pma_adapt_adp_vref_bypass      ),
           .pma_adapt_adp_vref_en           		(pma_adapt_adp_vref_en          ),
           .pma_adapt_datarate              		(pma_adapt_datarate             ),
           .pma_adapt_odi_dfe_spec_en       		(pma_adapt_odi_dfe_spec_en      ),
           .pma_adapt_prot_mode             		(pma_adapt_prot_mode            ),
           .pma_adapt_sup_mode              		(pma_adapt_sup_mode             ),
           .pma_cdr_refclk_inclk0_logical_to_physical_mapping  		(pma_cdr_refclk_inclk0_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk1_logical_to_physical_mapping  		(pma_cdr_refclk_inclk1_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk2_logical_to_physical_mapping  		(pma_cdr_refclk_inclk2_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk3_logical_to_physical_mapping  		(pma_cdr_refclk_inclk3_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk4_logical_to_physical_mapping  		(pma_cdr_refclk_inclk4_logical_to_physical_mapping ),
           .pma_cdr_refclk_powerdown_mode   		(pma_cdr_refclk_powerdown_mode  ),
           .pma_cdr_refclk_refclk_select    		(pma_cdr_refclk_refclk_select   ),
           .cdr_pll_atb_select_control      		(cdr_pll_atb_select_control     ),
           .cdr_pll_auto_reset_on           		(cdr_pll_auto_reset_on          ),
           .cdr_pll_bbpd_data_pattern_filter_select  		(cdr_pll_bbpd_data_pattern_filter_select ),
           .cdr_pll_bw_sel                  		(cdr_pll_bw_sel                 ),
           .cdr_pll_cal_vco_count_length    		(cdr_pll_cal_vco_count_length   ),
           .cdr_pll_cdr_odi_select          		(cdr_pll_cdr_odi_select         ),
           .cdr_pll_cdr_phaselock_mode      		(cdr_pll_cdr_phaselock_mode     ),
           .cdr_pll_cdr_powerdown_mode      		(cdr_pll_cdr_powerdown_mode     ),
           .cdr_pll_cgb_div                 		(cdr_pll_cgb_div                ),
           .cdr_pll_chgpmp_current_dn_pd    		(cdr_pll_chgpmp_current_dn_pd   ),
           .cdr_pll_chgpmp_current_dn_trim  		(cdr_pll_chgpmp_current_dn_trim ),
           .cdr_pll_chgpmp_current_pd       		(cdr_pll_chgpmp_current_pd      ),
           .cdr_pll_chgpmp_current_pfd      		(cdr_pll_chgpmp_current_pfd     ),
           .cdr_pll_chgpmp_current_up_pd    		(cdr_pll_chgpmp_current_up_pd   ),
           .cdr_pll_chgpmp_current_up_trim  		(cdr_pll_chgpmp_current_up_trim ),
           .cdr_pll_chgpmp_dn_pd_trim_double  		(cdr_pll_chgpmp_dn_pd_trim_double ),
           .cdr_pll_chgpmp_replicate        		(cdr_pll_chgpmp_replicate       ),
           .cdr_pll_chgpmp_testmode         		(cdr_pll_chgpmp_testmode        ),
           .cdr_pll_chgpmp_up_pd_trim_double  		(cdr_pll_chgpmp_up_pd_trim_double ),
           .cdr_pll_clklow_mux_select       		(cdr_pll_clklow_mux_select      ),
           .cdr_pll_datarate                		(cdr_pll_datarate               ),
           .cdr_pll_diag_loopback_enable    		(cdr_pll_diag_loopback_enable   ),
           .cdr_pll_disable_up_dn           		(cdr_pll_disable_up_dn          ),
           .cdr_pll_fb_select               		(cdr_pll_fb_select              ),
           .cdr_pll_fref_clklow_div         		(cdr_pll_fref_clklow_div        ),
           .cdr_pll_fref_mux_select         		(cdr_pll_fref_mux_select        ),
           .cdr_pll_gpon_lck2ref_control    		(cdr_pll_gpon_lck2ref_control   ),
           .cdr_pll_initial_settings        		(cdr_pll_initial_settings       ),
           .cdr_pll_iqclk_mux_sel           		(cdr_pll_iqclk_mux_sel          ),
           .cdr_pll_is_cascaded_pll         		(cdr_pll_is_cascaded_pll        ),
           .cdr_pll_lck2ref_delay_control   		(cdr_pll_lck2ref_delay_control  ),
           .cdr_pll_lf_resistor_pd          		(cdr_pll_lf_resistor_pd         ),
           .cdr_pll_lf_resistor_pfd         		(cdr_pll_lf_resistor_pfd        ),
           .cdr_pll_lf_ripple_cap           		(cdr_pll_lf_ripple_cap          ),
           .cdr_pll_loop_filter_bias_select  		(cdr_pll_loop_filter_bias_select ),
           .cdr_pll_loopback_mode           		(cdr_pll_loopback_mode          ),
           .cdr_pll_lpd_counter             		(cdr_pll_lpd_counter            ),
           .cdr_pll_lpfd_counter            		(cdr_pll_lpfd_counter           ),
           .cdr_pll_ltd_ltr_micro_controller_select  		(cdr_pll_ltd_ltr_micro_controller_select ),
           .cdr_pll_m_counter               		(cdr_pll_m_counter              ),
           .cdr_pll_n_counter               		(cdr_pll_n_counter              ),
           .cdr_pll_n_counter_scratch       		(cdr_pll_n_counter_scratch      ),
           .cdr_pll_output_clock_frequency  		(cdr_pll_output_clock_frequency ),
           .cdr_pll_pcie_gen                		(cdr_pll_pcie_gen               ),
           .cdr_pll_pd_fastlock_mode        		(cdr_pll_pd_fastlock_mode       ),
           .cdr_pll_pd_l_counter            		(cdr_pll_pd_l_counter           ),
           .cdr_pll_pfd_l_counter           		(cdr_pll_pfd_l_counter          ),
           .cdr_pll_pma_width               		(cdr_pll_pma_width              ),
           .cdr_pll_primary_use             		(cdr_pll_primary_use            ),
           .cdr_pll_prot_mode               		(cdr_pll_prot_mode              ),
           .cdr_pll_reference_clock_frequency  		(cdr_pll_reference_clock_frequency ),
           .cdr_pll_reverse_serial_loopback  		(cdr_pll_reverse_serial_loopback ),
           .cdr_pll_set_cdr_input_freq_range  		(cdr_pll_set_cdr_input_freq_range ),
           .cdr_pll_set_cdr_v2i_enable      		(cdr_pll_set_cdr_v2i_enable     ),
           .cdr_pll_set_cdr_vco_reset       		(cdr_pll_set_cdr_vco_reset      ),
           .cdr_pll_set_cdr_vco_speed       		(cdr_pll_set_cdr_vco_speed      ),
           .cdr_pll_set_cdr_vco_speed_fix   		(cdr_pll_set_cdr_vco_speed_fix  ),
           .cdr_pll_set_cdr_vco_speed_pciegen3  		(cdr_pll_set_cdr_vco_speed_pciegen3 ),
           .cdr_pll_sup_mode                		(cdr_pll_sup_mode               ),
           .cdr_pll_tx_pll_prot_mode        		(cdr_pll_tx_pll_prot_mode       ),
           .cdr_pll_txpll_hclk_driver_enable  		(cdr_pll_txpll_hclk_driver_enable ),
           .cdr_pll_uc_ro_cal               		(cdr_pll_uc_ro_cal              ),
           .cdr_pll_vco_freq                		(cdr_pll_vco_freq               ),
           .cdr_pll_vco_overrange_voltage   		(cdr_pll_vco_overrange_voltage  ),
           .cdr_pll_vco_underrange_voltage  		(cdr_pll_vco_underrange_voltage ),
           .pma_rx_buf_bypass_eqz_stages_234  		(pma_rx_buf_bypass_eqz_stages_234 ),
           .pma_rx_buf_datarate             		(pma_rx_buf_datarate            ),
           .pma_rx_buf_diag_lp_en           		(pma_rx_buf_diag_lp_en          ),
           .pma_rx_buf_loopback_modes       		(pma_rx_buf_loopback_modes      ),
           .pma_rx_buf_pm_tx_rx_cvp_mode    		(pma_rx_buf_pm_tx_rx_cvp_mode   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen    		(pma_rx_buf_pm_tx_rx_pcie_gen   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth  		(pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth ),
           .pma_rx_buf_prot_mode            		(pma_rx_buf_prot_mode           ),
           .pma_rx_buf_qpi_enable           		(pma_rx_buf_qpi_enable          ),
           .pma_rx_buf_refclk_en            		(pma_rx_buf_refclk_en           ),
           .pma_rx_buf_rx_refclk_divider    		(pma_rx_buf_rx_refclk_divider   ),
           .pma_rx_buf_sup_mode             		(pma_rx_buf_sup_mode            ),
           .pma_rx_buf_xrx_path_datarate    		(pma_rx_buf_xrx_path_datarate   ),
           .pma_rx_buf_xrx_path_datawidth   		(pma_rx_buf_xrx_path_datawidth  ),
           .pma_rx_buf_xrx_path_pma_rx_divclk_hz  		(pma_rx_buf_xrx_path_pma_rx_divclk_hz ),
           .pma_rx_buf_xrx_path_prot_mode   		(pma_rx_buf_xrx_path_prot_mode  ),
           .pma_rx_buf_xrx_path_sup_mode    		(pma_rx_buf_xrx_path_sup_mode   ),
           .pma_rx_buf_xrx_path_uc_cal_enable  		(pma_rx_buf_xrx_path_uc_cal_enable ),
           .pma_rx_deser_bitslip_bypass     		(pma_rx_deser_bitslip_bypass    ),
           .pma_rx_deser_clkdiv_source      		(pma_rx_deser_clkdiv_source     ),
           .pma_rx_deser_clkdivrx_user_mode  		(pma_rx_deser_clkdivrx_user_mode ),
           .pma_rx_deser_datarate           		(pma_rx_deser_datarate          ),
           .pma_rx_deser_deser_factor       		(pma_rx_deser_deser_factor      ),
           .pma_rx_deser_force_clkdiv_for_testing  		(pma_rx_deser_force_clkdiv_for_testing ),
           .pma_rx_deser_pcie_gen           		(pma_rx_deser_pcie_gen          ),
           .pma_rx_deser_pcie_gen_bitwidth  		(pma_rx_deser_pcie_gen_bitwidth ),
           .pma_rx_deser_prot_mode          		(pma_rx_deser_prot_mode         ),
           .pma_rx_deser_rst_n_adapt_odi    		(pma_rx_deser_rst_n_adapt_odi   ),
           .pma_rx_deser_sdclk_enable       		(pma_rx_deser_sdclk_enable      ),
           .pma_rx_deser_sup_mode           		(pma_rx_deser_sup_mode          ),
           .pma_rx_dfe_datarate             		(pma_rx_dfe_datarate            ),
           .pma_rx_dfe_dft_en               		(pma_rx_dfe_dft_en              ),
           .pma_rx_dfe_pdb                  		(pma_rx_dfe_pdb                 ),
           .pma_rx_dfe_pdb_fixedtap         		(pma_rx_dfe_pdb_fixedtap        ),
           .pma_rx_dfe_pdb_floattap         		(pma_rx_dfe_pdb_floattap        ),
           .pma_rx_dfe_pdb_fxtap4t7         		(pma_rx_dfe_pdb_fxtap4t7        ),
           .pma_rx_dfe_prot_mode            		(pma_rx_dfe_prot_mode           ),
           .pma_rx_dfe_sup_mode             		(pma_rx_dfe_sup_mode            ),
           .pma_rx_odi_datarate             		(pma_rx_odi_datarate            ),
           .pma_rx_odi_prot_mode            		(pma_rx_odi_prot_mode           ),
           .pma_rx_odi_step_ctrl_sel        		(pma_rx_odi_step_ctrl_sel       ),
           .pma_rx_odi_sup_mode             		(pma_rx_odi_sup_mode            ),
           .pma_rx_sd_prot_mode             		(pma_rx_sd_prot_mode            ),
           .pma_rx_sd_sd_output_off         		(pma_rx_sd_sd_output_off        ),
           .pma_rx_sd_sd_output_on          		(pma_rx_sd_sd_output_on         ),
           .pma_rx_sd_sd_pdb                		(pma_rx_sd_sd_pdb               ),
           .pma_rx_sd_sup_mode              		(pma_rx_sd_sup_mode             ),
           .pma_tx_buf_datarate             		(pma_tx_buf_datarate            ),
           .pma_tx_buf_mcgb_location_for_pcie  		(pma_tx_buf_mcgb_location_for_pcie ),
           .pma_tx_buf_prot_mode            		(pma_tx_buf_prot_mode           ),
           .pma_tx_buf_rx_det               		(pma_tx_buf_rx_det              ),
           .pma_tx_buf_rx_det_output_sel    		(pma_tx_buf_rx_det_output_sel   ),
           .pma_tx_buf_rx_det_pdb           		(pma_tx_buf_rx_det_pdb          ),
           .pma_tx_buf_sup_mode             		(pma_tx_buf_sup_mode            ),
           .pma_tx_buf_user_fir_coeff_ctrl_sel  		(pma_tx_buf_user_fir_coeff_ctrl_sel ),
           .pma_tx_buf_xtx_path_clock_divider_ratio  		(pma_tx_buf_xtx_path_clock_divider_ratio ),
           .pma_tx_buf_xtx_path_datarate    		(pma_tx_buf_xtx_path_datarate   ),
           .pma_tx_buf_xtx_path_datawidth   		(pma_tx_buf_xtx_path_datawidth  ),
           .pma_tx_buf_xtx_path_pma_tx_divclk_hz  		(pma_tx_buf_xtx_path_pma_tx_divclk_hz ),
           .pma_tx_buf_xtx_path_prot_mode   		(pma_tx_buf_xtx_path_prot_mode  ),
           .pma_tx_buf_xtx_path_sup_mode    		(pma_tx_buf_xtx_path_sup_mode   ),
           .pma_tx_buf_xtx_path_tx_pll_clk_hz  		(pma_tx_buf_xtx_path_tx_pll_clk_hz ),
           .pma_cgb_bitslip_enable          		(pma_cgb_bitslip_enable         ),
           .pma_cgb_bonding_reset_enable    		(pma_cgb_bonding_reset_enable   ),
           .pma_cgb_datarate                		(pma_cgb_datarate               ),
           .pma_cgb_input_select_gen3       		(pma_cgb_input_select_gen3      ),
           .pma_cgb_input_select_x1         		(pma_cgb_input_select_x1        ),
           .pma_cgb_input_select_xn         		(pma_cgb_input_select_xn        ),
           .pma_cgb_pcie_gen3_bitwidth      		(pma_cgb_pcie_gen3_bitwidth     ),
           .pma_cgb_prot_mode               		(pma_cgb_prot_mode              ),
           .pma_cgb_scratch0_x1_clock_src   		(pma_cgb_scratch0_x1_clock_src  ),
           .pma_cgb_scratch1_x1_clock_src   		(pma_cgb_scratch1_x1_clock_src  ),
           .pma_cgb_scratch2_x1_clock_src   		(pma_cgb_scratch2_x1_clock_src  ),
           .pma_cgb_scratch3_x1_clock_src   		(pma_cgb_scratch3_x1_clock_src  ),
           .pma_cgb_select_done_master_or_slave  		(pma_cgb_select_done_master_or_slave ),
           .pma_cgb_ser_mode                		(pma_cgb_ser_mode               ),
           .pma_cgb_sup_mode                		(pma_cgb_sup_mode               ),
           .pma_cgb_tx_ucontrol_en          		(pma_cgb_tx_ucontrol_en         ),
           .pma_cgb_x1_div_m_sel            		(pma_cgb_x1_div_m_sel           ),
           .pma_tx_ser_prot_mode            		(pma_tx_ser_prot_mode           ),
           .pma_tx_ser_ser_clk_divtx_user_sel  		(pma_tx_ser_ser_clk_divtx_user_sel ),
           .pma_tx_ser_sup_mode             		(pma_tx_ser_sup_mode            ),
           .hssi_10g_rx_pcs_advanced_user_mode  		(hssi_10g_rx_pcs_advanced_user_mode ),
           .hssi_10g_rx_pcs_align_del       		(hssi_10g_rx_pcs_align_del      ),
           .hssi_10g_rx_pcs_ber_bit_err_total_cnt  		(hssi_10g_rx_pcs_ber_bit_err_total_cnt ),
           .hssi_10g_rx_pcs_ber_clken       		(hssi_10g_rx_pcs_ber_clken      ),
           .hssi_10g_rx_pcs_ber_xus_timer_window  		(hssi_10g_rx_pcs_ber_xus_timer_window ),
           .hssi_10g_rx_pcs_bitslip_mode    		(hssi_10g_rx_pcs_bitslip_mode   ),
           .hssi_10g_rx_pcs_blksync_bitslip_type  		(hssi_10g_rx_pcs_blksync_bitslip_type ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_cnt  		(hssi_10g_rx_pcs_blksync_bitslip_wait_cnt ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_type  		(hssi_10g_rx_pcs_blksync_bitslip_wait_type ),
           .hssi_10g_rx_pcs_blksync_bypass  		(hssi_10g_rx_pcs_blksync_bypass ),
           .hssi_10g_rx_pcs_blksync_clken   		(hssi_10g_rx_pcs_blksync_clken  ),
           .hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt  		(hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock ),
           .hssi_10g_rx_pcs_blksync_pipeln  		(hssi_10g_rx_pcs_blksync_pipeln ),
           .hssi_10g_rx_pcs_clr_errblk_cnt_en  		(hssi_10g_rx_pcs_clr_errblk_cnt_en ),
           .hssi_10g_rx_pcs_control_del     		(hssi_10g_rx_pcs_control_del    ),
           .hssi_10g_rx_pcs_crcchk_bypass   		(hssi_10g_rx_pcs_crcchk_bypass  ),
           .hssi_10g_rx_pcs_crcchk_clken    		(hssi_10g_rx_pcs_crcchk_clken   ),
           .hssi_10g_rx_pcs_crcchk_inv      		(hssi_10g_rx_pcs_crcchk_inv     ),
           .hssi_10g_rx_pcs_crcchk_pipeln   		(hssi_10g_rx_pcs_crcchk_pipeln  ),
           .hssi_10g_rx_pcs_crcflag_pipeln  		(hssi_10g_rx_pcs_crcflag_pipeln ),
           .hssi_10g_rx_pcs_ctrl_bit_reverse  		(hssi_10g_rx_pcs_ctrl_bit_reverse ),
           .hssi_10g_rx_pcs_data_bit_reverse  		(hssi_10g_rx_pcs_data_bit_reverse ),
           .hssi_10g_rx_pcs_dec64b66b_clken  		(hssi_10g_rx_pcs_dec64b66b_clken ),
           .hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass  		(hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass ),
           .hssi_10g_rx_pcs_descrm_bypass   		(hssi_10g_rx_pcs_descrm_bypass  ),
           .hssi_10g_rx_pcs_descrm_clken    		(hssi_10g_rx_pcs_descrm_clken   ),
           .hssi_10g_rx_pcs_descrm_mode     		(hssi_10g_rx_pcs_descrm_mode    ),
           .hssi_10g_rx_pcs_descrm_pipeln   		(hssi_10g_rx_pcs_descrm_pipeln  ),
           .hssi_10g_rx_pcs_dft_clk_out_sel  		(hssi_10g_rx_pcs_dft_clk_out_sel ),
           .hssi_10g_rx_pcs_dis_signal_ok   		(hssi_10g_rx_pcs_dis_signal_ok  ),
           .hssi_10g_rx_pcs_dispchk_bypass  		(hssi_10g_rx_pcs_dispchk_bypass ),
           .hssi_10g_rx_pcs_empty_flag_type  		(hssi_10g_rx_pcs_empty_flag_type ),
           .hssi_10g_rx_pcs_fast_path       		(hssi_10g_rx_pcs_fast_path      ),
           .hssi_10g_rx_pcs_fec_clken       		(hssi_10g_rx_pcs_fec_clken      ),
           .hssi_10g_rx_pcs_fec_enable      		(hssi_10g_rx_pcs_fec_enable     ),
           .hssi_10g_rx_pcs_fifo_double_read  		(hssi_10g_rx_pcs_fifo_double_read ),
           .hssi_10g_rx_pcs_fifo_stop_rd    		(hssi_10g_rx_pcs_fifo_stop_rd   ),
           .hssi_10g_rx_pcs_fifo_stop_wr    		(hssi_10g_rx_pcs_fifo_stop_wr   ),
           .hssi_10g_rx_pcs_force_align     		(hssi_10g_rx_pcs_force_align    ),
           .hssi_10g_rx_pcs_frmsync_bypass  		(hssi_10g_rx_pcs_frmsync_bypass ),
           .hssi_10g_rx_pcs_frmsync_clken   		(hssi_10g_rx_pcs_frmsync_clken  ),
           .hssi_10g_rx_pcs_frmsync_enum_scrm  		(hssi_10g_rx_pcs_frmsync_enum_scrm ),
           .hssi_10g_rx_pcs_frmsync_enum_sync  		(hssi_10g_rx_pcs_frmsync_enum_sync ),
           .hssi_10g_rx_pcs_frmsync_flag_type  		(hssi_10g_rx_pcs_frmsync_flag_type ),
           .hssi_10g_rx_pcs_frmsync_knum_sync  		(hssi_10g_rx_pcs_frmsync_knum_sync ),
           .hssi_10g_rx_pcs_frmsync_mfrm_length  		(hssi_10g_rx_pcs_frmsync_mfrm_length ),
           .hssi_10g_rx_pcs_frmsync_pipeln  		(hssi_10g_rx_pcs_frmsync_pipeln ),
           .hssi_10g_rx_pcs_full_flag_type  		(hssi_10g_rx_pcs_full_flag_type ),
           .hssi_10g_rx_pcs_gb_rx_idwidth   		(hssi_10g_rx_pcs_gb_rx_idwidth  ),
           .hssi_10g_rx_pcs_gb_rx_odwidth   		(hssi_10g_rx_pcs_gb_rx_odwidth  ),
           .hssi_10g_rx_pcs_gbexp_clken     		(hssi_10g_rx_pcs_gbexp_clken    ),
           .hssi_10g_rx_pcs_low_latency_en  		(hssi_10g_rx_pcs_low_latency_en ),
           .hssi_10g_rx_pcs_lpbk_mode       		(hssi_10g_rx_pcs_lpbk_mode      ),
           .hssi_10g_rx_pcs_master_clk_sel  		(hssi_10g_rx_pcs_master_clk_sel ),
           .hssi_10g_rx_pcs_pempty_flag_type  		(hssi_10g_rx_pcs_pempty_flag_type ),
           .hssi_10g_rx_pcs_pfull_flag_type  		(hssi_10g_rx_pcs_pfull_flag_type ),
           .hssi_10g_rx_pcs_phcomp_rd_del   		(hssi_10g_rx_pcs_phcomp_rd_del  ),
           .hssi_10g_rx_pcs_pld_if_type     		(hssi_10g_rx_pcs_pld_if_type    ),
           .hssi_10g_rx_pcs_prot_mode       		(hssi_10g_rx_pcs_prot_mode      ),
           .hssi_10g_rx_pcs_rand_clken      		(hssi_10g_rx_pcs_rand_clken     ),
           .hssi_10g_rx_pcs_rd_clk_sel      		(hssi_10g_rx_pcs_rd_clk_sel     ),
           .hssi_10g_rx_pcs_rdfifo_clken    		(hssi_10g_rx_pcs_rdfifo_clken   ),
           .hssi_10g_rx_pcs_reconfig_settings  		(hssi_10g_rx_pcs_reconfig_settings ),
           .hssi_10g_rx_pcs_rx_fifo_write_ctrl  		(hssi_10g_rx_pcs_rx_fifo_write_ctrl ),
           .hssi_10g_rx_pcs_rx_scrm_width   		(hssi_10g_rx_pcs_rx_scrm_width  ),
           .hssi_10g_rx_pcs_rx_sh_location  		(hssi_10g_rx_pcs_rx_sh_location ),
           .hssi_10g_rx_pcs_rx_signal_ok_sel  		(hssi_10g_rx_pcs_rx_signal_ok_sel ),
           .hssi_10g_rx_pcs_rx_sm_bypass    		(hssi_10g_rx_pcs_rx_sm_bypass   ),
           .hssi_10g_rx_pcs_rx_sm_hiber     		(hssi_10g_rx_pcs_rx_sm_hiber    ),
           .hssi_10g_rx_pcs_rx_sm_pipeln    		(hssi_10g_rx_pcs_rx_sm_pipeln   ),
           .hssi_10g_rx_pcs_rx_testbus_sel  		(hssi_10g_rx_pcs_rx_testbus_sel ),
           .hssi_10g_rx_pcs_rx_true_b2b     		(hssi_10g_rx_pcs_rx_true_b2b    ),
           .hssi_10g_rx_pcs_rxfifo_empty    		(hssi_10g_rx_pcs_rxfifo_empty   ),
           .hssi_10g_rx_pcs_rxfifo_full     		(hssi_10g_rx_pcs_rxfifo_full    ),
           .hssi_10g_rx_pcs_rxfifo_mode     		(hssi_10g_rx_pcs_rxfifo_mode    ),
           .hssi_10g_rx_pcs_rxfifo_pempty   		(hssi_10g_rx_pcs_rxfifo_pempty  ),
           .hssi_10g_rx_pcs_rxfifo_pfull    		(hssi_10g_rx_pcs_rxfifo_pfull   ),
           .hssi_10g_rx_pcs_stretch_num_stages  		(hssi_10g_rx_pcs_stretch_num_stages ),
           .hssi_10g_rx_pcs_sup_mode        		(hssi_10g_rx_pcs_sup_mode       ),
           .hssi_10g_rx_pcs_test_mode       		(hssi_10g_rx_pcs_test_mode      ),
           .hssi_10g_rx_pcs_wrfifo_clken    		(hssi_10g_rx_pcs_wrfifo_clken   ),
           .hssi_10g_tx_pcs_advanced_user_mode  		(hssi_10g_tx_pcs_advanced_user_mode ),
           .hssi_10g_tx_pcs_bitslip_en      		(hssi_10g_tx_pcs_bitslip_en     ),
           .hssi_10g_tx_pcs_bonding_dft_en  		(hssi_10g_tx_pcs_bonding_dft_en ),
           .hssi_10g_tx_pcs_bonding_dft_val  		(hssi_10g_tx_pcs_bonding_dft_val ),
           .hssi_10g_tx_pcs_comp_cnt        		(hssi_10g_tx_pcs_comp_cnt       ),
           .hssi_10g_tx_pcs_compin_sel      		(hssi_10g_tx_pcs_compin_sel     ),
           .hssi_10g_tx_pcs_crcgen_bypass   		(hssi_10g_tx_pcs_crcgen_bypass  ),
           .hssi_10g_tx_pcs_crcgen_clken    		(hssi_10g_tx_pcs_crcgen_clken   ),
           .hssi_10g_tx_pcs_crcgen_err      		(hssi_10g_tx_pcs_crcgen_err     ),
           .hssi_10g_tx_pcs_crcgen_inv      		(hssi_10g_tx_pcs_crcgen_inv     ),
           .hssi_10g_tx_pcs_ctrl_bit_reverse  		(hssi_10g_tx_pcs_ctrl_bit_reverse ),
           .hssi_10g_tx_pcs_ctrl_plane_bonding  		(hssi_10g_tx_pcs_ctrl_plane_bonding ),
           .hssi_10g_tx_pcs_data_bit_reverse  		(hssi_10g_tx_pcs_data_bit_reverse ),
           .hssi_10g_tx_pcs_dft_clk_out_sel  		(hssi_10g_tx_pcs_dft_clk_out_sel ),
           .hssi_10g_tx_pcs_dispgen_bypass  		(hssi_10g_tx_pcs_dispgen_bypass ),
           .hssi_10g_tx_pcs_dispgen_clken   		(hssi_10g_tx_pcs_dispgen_clken  ),
           .hssi_10g_tx_pcs_dispgen_err     		(hssi_10g_tx_pcs_dispgen_err    ),
           .hssi_10g_tx_pcs_dispgen_pipeln  		(hssi_10g_tx_pcs_dispgen_pipeln ),
           .hssi_10g_tx_pcs_distdwn_bypass_pipeln  		(hssi_10g_tx_pcs_distdwn_bypass_pipeln ),
           .hssi_10g_tx_pcs_distdwn_master  		(hssi_10g_tx_pcs_distdwn_master ),
           .hssi_10g_tx_pcs_distup_bypass_pipeln  		(hssi_10g_tx_pcs_distup_bypass_pipeln ),
           .hssi_10g_tx_pcs_distup_master   		(hssi_10g_tx_pcs_distup_master  ),
           .hssi_10g_tx_pcs_dv_bond         		(hssi_10g_tx_pcs_dv_bond        ),
           .hssi_10g_tx_pcs_empty_flag_type  		(hssi_10g_tx_pcs_empty_flag_type ),
           .hssi_10g_tx_pcs_enc64b66b_txsm_clken  		(hssi_10g_tx_pcs_enc64b66b_txsm_clken ),
           .hssi_10g_tx_pcs_enc_64b66b_txsm_bypass  		(hssi_10g_tx_pcs_enc_64b66b_txsm_bypass ),
           .hssi_10g_tx_pcs_fastpath        		(hssi_10g_tx_pcs_fastpath       ),
           .hssi_10g_tx_pcs_fec_clken       		(hssi_10g_tx_pcs_fec_clken      ),
           .hssi_10g_tx_pcs_fec_enable      		(hssi_10g_tx_pcs_fec_enable     ),
           .hssi_10g_tx_pcs_fifo_double_write  		(hssi_10g_tx_pcs_fifo_double_write ),
           .hssi_10g_tx_pcs_fifo_reg_fast   		(hssi_10g_tx_pcs_fifo_reg_fast  ),
           .hssi_10g_tx_pcs_fifo_stop_rd    		(hssi_10g_tx_pcs_fifo_stop_rd   ),
           .hssi_10g_tx_pcs_fifo_stop_wr    		(hssi_10g_tx_pcs_fifo_stop_wr   ),
           .hssi_10g_tx_pcs_frmgen_burst    		(hssi_10g_tx_pcs_frmgen_burst   ),
           .hssi_10g_tx_pcs_frmgen_bypass   		(hssi_10g_tx_pcs_frmgen_bypass  ),
           .hssi_10g_tx_pcs_frmgen_clken    		(hssi_10g_tx_pcs_frmgen_clken   ),
           .hssi_10g_tx_pcs_frmgen_mfrm_length  		(hssi_10g_tx_pcs_frmgen_mfrm_length ),
           .hssi_10g_tx_pcs_frmgen_pipeln   		(hssi_10g_tx_pcs_frmgen_pipeln  ),
           .hssi_10g_tx_pcs_frmgen_pyld_ins  		(hssi_10g_tx_pcs_frmgen_pyld_ins ),
           .hssi_10g_tx_pcs_frmgen_wordslip  		(hssi_10g_tx_pcs_frmgen_wordslip ),
           .hssi_10g_tx_pcs_full_flag_type  		(hssi_10g_tx_pcs_full_flag_type ),
           .hssi_10g_tx_pcs_gb_pipeln_bypass  		(hssi_10g_tx_pcs_gb_pipeln_bypass ),
           .hssi_10g_tx_pcs_gb_tx_idwidth   		(hssi_10g_tx_pcs_gb_tx_idwidth  ),
           .hssi_10g_tx_pcs_gb_tx_odwidth   		(hssi_10g_tx_pcs_gb_tx_odwidth  ),
           .hssi_10g_tx_pcs_gbred_clken     		(hssi_10g_tx_pcs_gbred_clken    ),
           .hssi_10g_tx_pcs_indv            		(hssi_10g_tx_pcs_indv           ),
           .hssi_10g_tx_pcs_low_latency_en  		(hssi_10g_tx_pcs_low_latency_en ),
           .hssi_10g_tx_pcs_master_clk_sel  		(hssi_10g_tx_pcs_master_clk_sel ),
           .hssi_10g_tx_pcs_pempty_flag_type  		(hssi_10g_tx_pcs_pempty_flag_type ),
           .hssi_10g_tx_pcs_pfull_flag_type  		(hssi_10g_tx_pcs_pfull_flag_type ),
           .hssi_10g_tx_pcs_phcomp_rd_del   		(hssi_10g_tx_pcs_phcomp_rd_del  ),
           .hssi_10g_tx_pcs_pld_if_type     		(hssi_10g_tx_pcs_pld_if_type    ),
           .hssi_10g_tx_pcs_prot_mode       		(hssi_10g_tx_pcs_prot_mode      ),
           .hssi_10g_tx_pcs_pseudo_random   		(hssi_10g_tx_pcs_pseudo_random  ),
           .hssi_10g_tx_pcs_pseudo_seed_a   		(hssi_10g_tx_pcs_pseudo_seed_a  ),
           .hssi_10g_tx_pcs_pseudo_seed_b   		(hssi_10g_tx_pcs_pseudo_seed_b  ),
           .hssi_10g_tx_pcs_random_disp     		(hssi_10g_tx_pcs_random_disp    ),
           .hssi_10g_tx_pcs_rdfifo_clken    		(hssi_10g_tx_pcs_rdfifo_clken   ),
           .hssi_10g_tx_pcs_reconfig_settings  		(hssi_10g_tx_pcs_reconfig_settings ),
           .hssi_10g_tx_pcs_scrm_bypass     		(hssi_10g_tx_pcs_scrm_bypass    ),
           .hssi_10g_tx_pcs_scrm_clken      		(hssi_10g_tx_pcs_scrm_clken     ),
           .hssi_10g_tx_pcs_scrm_mode       		(hssi_10g_tx_pcs_scrm_mode      ),
           .hssi_10g_tx_pcs_scrm_pipeln     		(hssi_10g_tx_pcs_scrm_pipeln    ),
           .hssi_10g_tx_pcs_sh_err          		(hssi_10g_tx_pcs_sh_err         ),
           .hssi_10g_tx_pcs_sop_mark        		(hssi_10g_tx_pcs_sop_mark       ),
           .hssi_10g_tx_pcs_stretch_num_stages  		(hssi_10g_tx_pcs_stretch_num_stages ),
           .hssi_10g_tx_pcs_sup_mode        		(hssi_10g_tx_pcs_sup_mode       ),
           .hssi_10g_tx_pcs_test_mode       		(hssi_10g_tx_pcs_test_mode      ),
           .hssi_10g_tx_pcs_tx_scrm_err     		(hssi_10g_tx_pcs_tx_scrm_err    ),
           .hssi_10g_tx_pcs_tx_scrm_width   		(hssi_10g_tx_pcs_tx_scrm_width  ),
           .hssi_10g_tx_pcs_tx_sh_location  		(hssi_10g_tx_pcs_tx_sh_location ),
           .hssi_10g_tx_pcs_tx_sm_bypass    		(hssi_10g_tx_pcs_tx_sm_bypass   ),
           .hssi_10g_tx_pcs_tx_sm_pipeln    		(hssi_10g_tx_pcs_tx_sm_pipeln   ),
           .hssi_10g_tx_pcs_tx_testbus_sel  		(hssi_10g_tx_pcs_tx_testbus_sel ),
           .hssi_10g_tx_pcs_txfifo_empty    		(hssi_10g_tx_pcs_txfifo_empty   ),
           .hssi_10g_tx_pcs_txfifo_full     		(hssi_10g_tx_pcs_txfifo_full    ),
           .hssi_10g_tx_pcs_txfifo_mode     		(hssi_10g_tx_pcs_txfifo_mode    ),
           .hssi_10g_tx_pcs_txfifo_pempty   		(hssi_10g_tx_pcs_txfifo_pempty  ),
           .hssi_10g_tx_pcs_txfifo_pfull    		(hssi_10g_tx_pcs_txfifo_pfull   ),
           .hssi_10g_tx_pcs_wr_clk_sel      		(hssi_10g_tx_pcs_wr_clk_sel     ),
           .hssi_10g_tx_pcs_wrfifo_clken    		(hssi_10g_tx_pcs_wrfifo_clken   ),
           .hssi_8g_rx_pcs_auto_error_replacement  		(hssi_8g_rx_pcs_auto_error_replacement ),
           .hssi_8g_rx_pcs_auto_speed_nego  		(hssi_8g_rx_pcs_auto_speed_nego ),
           .hssi_8g_rx_pcs_bit_reversal     		(hssi_8g_rx_pcs_bit_reversal    ),
           .hssi_8g_rx_pcs_bonding_dft_en   		(hssi_8g_rx_pcs_bonding_dft_en  ),
           .hssi_8g_rx_pcs_bonding_dft_val  		(hssi_8g_rx_pcs_bonding_dft_val ),
           .hssi_8g_rx_pcs_bypass_pipeline_reg  		(hssi_8g_rx_pcs_bypass_pipeline_reg ),
           .hssi_8g_rx_pcs_byte_deserializer  		(hssi_8g_rx_pcs_byte_deserializer ),
           .hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask  		(hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask ),
           .hssi_8g_rx_pcs_clkcmp_pattern_n  		(hssi_8g_rx_pcs_clkcmp_pattern_n ),
           .hssi_8g_rx_pcs_clkcmp_pattern_p  		(hssi_8g_rx_pcs_clkcmp_pattern_p ),
           .hssi_8g_rx_pcs_clock_gate_bds_dec_asn  		(hssi_8g_rx_pcs_clock_gate_bds_dec_asn ),
           .hssi_8g_rx_pcs_clock_gate_cdr_eidle  		(hssi_8g_rx_pcs_clock_gate_cdr_eidle ),
           .hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_dw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_dw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_dw_wa  		(hssi_8g_rx_pcs_clock_gate_dw_wa ),
           .hssi_8g_rx_pcs_clock_gate_pc_rdclk  		(hssi_8g_rx_pcs_clock_gate_pc_rdclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_sw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_sw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_sw_wa  		(hssi_8g_rx_pcs_clock_gate_sw_wa ),
           .hssi_8g_rx_pcs_clock_observation_in_pld_core  		(hssi_8g_rx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_rx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_rx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_rx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_rx_pcs_eidle_entry_eios  		(hssi_8g_rx_pcs_eidle_entry_eios ),
           .hssi_8g_rx_pcs_eidle_entry_iei  		(hssi_8g_rx_pcs_eidle_entry_iei ),
           .hssi_8g_rx_pcs_eidle_entry_sd   		(hssi_8g_rx_pcs_eidle_entry_sd  ),
           .hssi_8g_rx_pcs_eightb_tenb_decoder  		(hssi_8g_rx_pcs_eightb_tenb_decoder ),
           .hssi_8g_rx_pcs_err_flags_sel    		(hssi_8g_rx_pcs_err_flags_sel   ),
           .hssi_8g_rx_pcs_fixed_pat_det    		(hssi_8g_rx_pcs_fixed_pat_det   ),
           .hssi_8g_rx_pcs_fixed_pat_num    		(hssi_8g_rx_pcs_fixed_pat_num   ),
           .hssi_8g_rx_pcs_force_signal_detect  		(hssi_8g_rx_pcs_force_signal_detect ),
           .hssi_8g_rx_pcs_gen3_clk_en      		(hssi_8g_rx_pcs_gen3_clk_en     ),
           .hssi_8g_rx_pcs_gen3_rx_clk_sel  		(hssi_8g_rx_pcs_gen3_rx_clk_sel ),
           .hssi_8g_rx_pcs_gen3_tx_clk_sel  		(hssi_8g_rx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_rx_pcs_hip_mode         		(hssi_8g_rx_pcs_hip_mode        ),
           .hssi_8g_rx_pcs_ibm_invalid_code  		(hssi_8g_rx_pcs_ibm_invalid_code ),
           .hssi_8g_rx_pcs_invalid_code_flag_only  		(hssi_8g_rx_pcs_invalid_code_flag_only ),
           .hssi_8g_rx_pcs_pad_or_edb_error_replace  		(hssi_8g_rx_pcs_pad_or_edb_error_replace ),
           .hssi_8g_rx_pcs_pcs_bypass       		(hssi_8g_rx_pcs_pcs_bypass      ),
           .hssi_8g_rx_pcs_phase_comp_rdptr  		(hssi_8g_rx_pcs_phase_comp_rdptr ),
           .hssi_8g_rx_pcs_phase_compensation_fifo  		(hssi_8g_rx_pcs_phase_compensation_fifo ),
           .hssi_8g_rx_pcs_pipe_if_enable   		(hssi_8g_rx_pcs_pipe_if_enable  ),
           .hssi_8g_rx_pcs_pma_dw           		(hssi_8g_rx_pcs_pma_dw          ),
           .hssi_8g_rx_pcs_polinv_8b10b_dec  		(hssi_8g_rx_pcs_polinv_8b10b_dec ),
           .hssi_8g_rx_pcs_prot_mode        		(hssi_8g_rx_pcs_prot_mode       ),
           .hssi_8g_rx_pcs_rate_match       		(hssi_8g_rx_pcs_rate_match      ),
           .hssi_8g_rx_pcs_rate_match_del_thres  		(hssi_8g_rx_pcs_rate_match_del_thres ),
           .hssi_8g_rx_pcs_rate_match_empty_thres  		(hssi_8g_rx_pcs_rate_match_empty_thres ),
           .hssi_8g_rx_pcs_rate_match_full_thres  		(hssi_8g_rx_pcs_rate_match_full_thres ),
           .hssi_8g_rx_pcs_rate_match_ins_thres  		(hssi_8g_rx_pcs_rate_match_ins_thres ),
           .hssi_8g_rx_pcs_rate_match_start_thres  		(hssi_8g_rx_pcs_rate_match_start_thres ),
           .hssi_8g_rx_pcs_reconfig_settings  		(hssi_8g_rx_pcs_reconfig_settings ),
           .hssi_8g_rx_pcs_rx_clk2          		(hssi_8g_rx_pcs_rx_clk2         ),
           .hssi_8g_rx_pcs_rx_clk_free_running  		(hssi_8g_rx_pcs_rx_clk_free_running ),
           .hssi_8g_rx_pcs_rx_pcs_urst      		(hssi_8g_rx_pcs_rx_pcs_urst     ),
           .hssi_8g_rx_pcs_rx_rcvd_clk      		(hssi_8g_rx_pcs_rx_rcvd_clk     ),
           .hssi_8g_rx_pcs_rx_rd_clk        		(hssi_8g_rx_pcs_rx_rd_clk       ),
           .hssi_8g_rx_pcs_rx_refclk        		(hssi_8g_rx_pcs_rx_refclk       ),
           .hssi_8g_rx_pcs_rx_wr_clk        		(hssi_8g_rx_pcs_rx_wr_clk       ),
           .hssi_8g_rx_pcs_sup_mode         		(hssi_8g_rx_pcs_sup_mode        ),
           .hssi_8g_rx_pcs_symbol_swap      		(hssi_8g_rx_pcs_symbol_swap     ),
           .hssi_8g_rx_pcs_sync_sm_idle_eios  		(hssi_8g_rx_pcs_sync_sm_idle_eios ),
           .hssi_8g_rx_pcs_test_bus_sel     		(hssi_8g_rx_pcs_test_bus_sel    ),
           .hssi_8g_rx_pcs_tx_rx_parallel_loopback  		(hssi_8g_rx_pcs_tx_rx_parallel_loopback ),
           .hssi_8g_rx_pcs_wa_boundary_lock_ctrl  		(hssi_8g_rx_pcs_wa_boundary_lock_ctrl ),
           .hssi_8g_rx_pcs_wa_clk_slip_spacing  		(hssi_8g_rx_pcs_wa_clk_slip_spacing ),
           .hssi_8g_rx_pcs_wa_det_latency_sync_status_beh  		(hssi_8g_rx_pcs_wa_det_latency_sync_status_beh ),
           .hssi_8g_rx_pcs_wa_disp_err_flag  		(hssi_8g_rx_pcs_wa_disp_err_flag ),
           .hssi_8g_rx_pcs_wa_kchar         		(hssi_8g_rx_pcs_wa_kchar        ),
           .hssi_8g_rx_pcs_wa_pd            		(hssi_8g_rx_pcs_wa_pd           ),
           .hssi_8g_rx_pcs_wa_pd_data       		(hssi_8g_rx_pcs_wa_pd_data      ),
           .hssi_8g_rx_pcs_wa_pd_polarity   		(hssi_8g_rx_pcs_wa_pd_polarity  ),
           .hssi_8g_rx_pcs_wa_pld_controlled  		(hssi_8g_rx_pcs_wa_pld_controlled ),
           .hssi_8g_rx_pcs_wa_renumber_data  		(hssi_8g_rx_pcs_wa_renumber_data ),
           .hssi_8g_rx_pcs_wa_rgnumber_data  		(hssi_8g_rx_pcs_wa_rgnumber_data ),
           .hssi_8g_rx_pcs_wa_rknumber_data  		(hssi_8g_rx_pcs_wa_rknumber_data ),
           .hssi_8g_rx_pcs_wa_rosnumber_data  		(hssi_8g_rx_pcs_wa_rosnumber_data ),
           .hssi_8g_rx_pcs_wa_rvnumber_data  		(hssi_8g_rx_pcs_wa_rvnumber_data ),
           .hssi_8g_rx_pcs_wa_sync_sm_ctrl  		(hssi_8g_rx_pcs_wa_sync_sm_ctrl ),
           .hssi_8g_rx_pcs_wait_cnt         		(hssi_8g_rx_pcs_wait_cnt        ),
           .hssi_8g_tx_pcs_auto_speed_nego_gen2  		(hssi_8g_tx_pcs_auto_speed_nego_gen2 ),
           .hssi_8g_tx_pcs_bit_reversal     		(hssi_8g_tx_pcs_bit_reversal    ),
           .hssi_8g_tx_pcs_bonding_dft_en   		(hssi_8g_tx_pcs_bonding_dft_en  ),
           .hssi_8g_tx_pcs_bonding_dft_val  		(hssi_8g_tx_pcs_bonding_dft_val ),
           .hssi_8g_tx_pcs_bypass_pipeline_reg  		(hssi_8g_tx_pcs_bypass_pipeline_reg ),
           .hssi_8g_tx_pcs_byte_serializer  		(hssi_8g_tx_pcs_byte_serializer ),
           .hssi_8g_tx_pcs_clock_gate_bs_enc  		(hssi_8g_tx_pcs_clock_gate_bs_enc ),
           .hssi_8g_tx_pcs_clock_gate_dw_fifowr  		(hssi_8g_tx_pcs_clock_gate_dw_fifowr ),
           .hssi_8g_tx_pcs_clock_gate_fiford  		(hssi_8g_tx_pcs_clock_gate_fiford ),
           .hssi_8g_tx_pcs_clock_gate_sw_fifowr  		(hssi_8g_tx_pcs_clock_gate_sw_fifowr ),
           .hssi_8g_tx_pcs_clock_observation_in_pld_core  		(hssi_8g_tx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_tx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_tx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_tx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_tx_pcs_data_selection_8b10b_encoder_input  		(hssi_8g_tx_pcs_data_selection_8b10b_encoder_input ),
           .hssi_8g_tx_pcs_dynamic_clk_switch  		(hssi_8g_tx_pcs_dynamic_clk_switch ),
           .hssi_8g_tx_pcs_eightb_tenb_disp_ctrl  		(hssi_8g_tx_pcs_eightb_tenb_disp_ctrl ),
           .hssi_8g_tx_pcs_eightb_tenb_encoder  		(hssi_8g_tx_pcs_eightb_tenb_encoder ),
           .hssi_8g_tx_pcs_force_echar      		(hssi_8g_tx_pcs_force_echar     ),
           .hssi_8g_tx_pcs_force_kchar      		(hssi_8g_tx_pcs_force_kchar     ),
           .hssi_8g_tx_pcs_gen3_tx_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel ),
           .hssi_8g_tx_pcs_hip_mode         		(hssi_8g_tx_pcs_hip_mode        ),
           .hssi_8g_tx_pcs_pcs_bypass       		(hssi_8g_tx_pcs_pcs_bypass      ),
           .hssi_8g_tx_pcs_phase_comp_rdptr  		(hssi_8g_tx_pcs_phase_comp_rdptr ),
           .hssi_8g_tx_pcs_phase_compensation_fifo  		(hssi_8g_tx_pcs_phase_compensation_fifo ),
           .hssi_8g_tx_pcs_phfifo_write_clk_sel  		(hssi_8g_tx_pcs_phfifo_write_clk_sel ),
           .hssi_8g_tx_pcs_pma_dw           		(hssi_8g_tx_pcs_pma_dw          ),
           .hssi_8g_tx_pcs_prot_mode        		(hssi_8g_tx_pcs_prot_mode       ),
           .hssi_8g_tx_pcs_reconfig_settings  		(hssi_8g_tx_pcs_reconfig_settings ),
           .hssi_8g_tx_pcs_refclk_b_clk_sel  		(hssi_8g_tx_pcs_refclk_b_clk_sel ),
           .hssi_8g_tx_pcs_revloop_back_rm  		(hssi_8g_tx_pcs_revloop_back_rm ),
           .hssi_8g_tx_pcs_sup_mode         		(hssi_8g_tx_pcs_sup_mode        ),
           .hssi_8g_tx_pcs_symbol_swap      		(hssi_8g_tx_pcs_symbol_swap     ),
           .hssi_8g_tx_pcs_tx_bitslip       		(hssi_8g_tx_pcs_tx_bitslip      ),
           .hssi_8g_tx_pcs_tx_compliance_controlled_disparity  		(hssi_8g_tx_pcs_tx_compliance_controlled_disparity ),
           .hssi_8g_tx_pcs_tx_fast_pld_reg  		(hssi_8g_tx_pcs_tx_fast_pld_reg ),
           .hssi_8g_tx_pcs_txclk_freerun    		(hssi_8g_tx_pcs_txclk_freerun   ),
           .hssi_8g_tx_pcs_txpcs_urst       		(hssi_8g_tx_pcs_txpcs_urst      ),
           .hssi_common_pcs_pma_interface_asn_clk_enable  		(hssi_common_pcs_pma_interface_asn_clk_enable ),
           .hssi_common_pcs_pma_interface_asn_enable  		(hssi_common_pcs_pma_interface_asn_enable ),
           .hssi_common_pcs_pma_interface_block_sel  		(hssi_common_pcs_pma_interface_block_sel ),
           .hssi_common_pcs_pma_interface_bypass_early_eios  		(hssi_common_pcs_pma_interface_bypass_early_eios ),
           .hssi_common_pcs_pma_interface_bypass_pcie_switch  		(hssi_common_pcs_pma_interface_bypass_pcie_switch ),
           .hssi_common_pcs_pma_interface_bypass_pma_ltr  		(hssi_common_pcs_pma_interface_bypass_pma_ltr ),
           .hssi_common_pcs_pma_interface_bypass_pma_sw_done  		(hssi_common_pcs_pma_interface_bypass_pma_sw_done ),
           .hssi_common_pcs_pma_interface_bypass_ppm_lock  		(hssi_common_pcs_pma_interface_bypass_ppm_lock ),
           .hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp ),
           .hssi_common_pcs_pma_interface_bypass_txdetectrx  		(hssi_common_pcs_pma_interface_bypass_txdetectrx ),
           .hssi_common_pcs_pma_interface_cdr_control  		(hssi_common_pcs_pma_interface_cdr_control ),
           .hssi_common_pcs_pma_interface_cid_enable  		(hssi_common_pcs_pma_interface_cid_enable ),
           .hssi_common_pcs_pma_interface_cp_cons_sel  		(hssi_common_pcs_pma_interface_cp_cons_sel ),
           .hssi_common_pcs_pma_interface_cp_dwn_mstr  		(hssi_common_pcs_pma_interface_cp_dwn_mstr ),
           .hssi_common_pcs_pma_interface_cp_up_mstr  		(hssi_common_pcs_pma_interface_cp_up_mstr ),
           .hssi_common_pcs_pma_interface_ctrl_plane_bonding  		(hssi_common_pcs_pma_interface_ctrl_plane_bonding ),
           .hssi_common_pcs_pma_interface_data_mask_count  		(hssi_common_pcs_pma_interface_data_mask_count ),
           .hssi_common_pcs_pma_interface_data_mask_count_multi  		(hssi_common_pcs_pma_interface_data_mask_count_multi ),
           .hssi_common_pcs_pma_interface_dft_observation_clock_selection  		(hssi_common_pcs_pma_interface_dft_observation_clock_selection ),
           .hssi_common_pcs_pma_interface_early_eios_counter  		(hssi_common_pcs_pma_interface_early_eios_counter ),
           .hssi_common_pcs_pma_interface_force_freqdet  		(hssi_common_pcs_pma_interface_force_freqdet ),
           .hssi_common_pcs_pma_interface_free_run_clk_enable  		(hssi_common_pcs_pma_interface_free_run_clk_enable ),
           .hssi_common_pcs_pma_interface_ignore_sigdet_g23  		(hssi_common_pcs_pma_interface_ignore_sigdet_g23 ),
           .hssi_common_pcs_pma_interface_pc_en_counter  		(hssi_common_pcs_pma_interface_pc_en_counter ),
           .hssi_common_pcs_pma_interface_pc_rst_counter  		(hssi_common_pcs_pma_interface_pc_rst_counter ),
           .hssi_common_pcs_pma_interface_pcie_hip_mode  		(hssi_common_pcs_pma_interface_pcie_hip_mode ),
           .hssi_common_pcs_pma_interface_ph_fifo_reg_mode  		(hssi_common_pcs_pma_interface_ph_fifo_reg_mode ),
           .hssi_common_pcs_pma_interface_phfifo_flush_wait  		(hssi_common_pcs_pma_interface_phfifo_flush_wait ),
           .hssi_common_pcs_pma_interface_pipe_if_g3pcs  		(hssi_common_pcs_pma_interface_pipe_if_g3pcs ),
           .hssi_common_pcs_pma_interface_pma_done_counter  		(hssi_common_pcs_pma_interface_pma_done_counter ),
           .hssi_common_pcs_pma_interface_pma_if_dft_en  		(hssi_common_pcs_pma_interface_pma_if_dft_en ),
           .hssi_common_pcs_pma_interface_pma_if_dft_val  		(hssi_common_pcs_pma_interface_pma_if_dft_val ),
           .hssi_common_pcs_pma_interface_ppm_cnt_rst  		(hssi_common_pcs_pma_interface_ppm_cnt_rst ),
           .hssi_common_pcs_pma_interface_ppm_deassert_early  		(hssi_common_pcs_pma_interface_ppm_deassert_early ),
           .hssi_common_pcs_pma_interface_ppm_det_buckets  		(hssi_common_pcs_pma_interface_ppm_det_buckets ),
           .hssi_common_pcs_pma_interface_ppm_gen1_2_cnt  		(hssi_common_pcs_pma_interface_ppm_gen1_2_cnt ),
           .hssi_common_pcs_pma_interface_ppm_post_eidle_delay  		(hssi_common_pcs_pma_interface_ppm_post_eidle_delay ),
           .hssi_common_pcs_pma_interface_ppmsel  		(hssi_common_pcs_pma_interface_ppmsel ),
           .hssi_common_pcs_pma_interface_prot_mode  		(hssi_common_pcs_pma_interface_prot_mode ),
           .hssi_common_pcs_pma_interface_reconfig_settings  		(hssi_common_pcs_pma_interface_reconfig_settings ),
           .hssi_common_pcs_pma_interface_rxvalid_mask  		(hssi_common_pcs_pma_interface_rxvalid_mask ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter  		(hssi_common_pcs_pma_interface_sigdet_wait_counter ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter_multi  		(hssi_common_pcs_pma_interface_sigdet_wait_counter_multi ),
           .hssi_common_pcs_pma_interface_sim_mode  		(hssi_common_pcs_pma_interface_sim_mode ),
           .hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en  		(hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en ),
           .hssi_common_pcs_pma_interface_sup_mode  		(hssi_common_pcs_pma_interface_sup_mode ),
           .hssi_common_pcs_pma_interface_testout_sel  		(hssi_common_pcs_pma_interface_testout_sel ),
           .hssi_common_pcs_pma_interface_wait_clk_on_off_timer  		(hssi_common_pcs_pma_interface_wait_clk_on_off_timer ),
           .hssi_common_pcs_pma_interface_wait_pipe_synchronizing  		(hssi_common_pcs_pma_interface_wait_pipe_synchronizing ),
           .hssi_common_pcs_pma_interface_wait_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_wait_send_syncp_fbkp ),
           .hssi_common_pld_pcs_interface_dft_clk_out_en  		(hssi_common_pld_pcs_interface_dft_clk_out_en ),
           .hssi_common_pld_pcs_interface_dft_clk_out_sel  		(hssi_common_pld_pcs_interface_dft_clk_out_sel ),
           .hssi_common_pld_pcs_interface_hrdrstctrl_en  		(hssi_common_pld_pcs_interface_hrdrstctrl_en ),
           .hssi_common_pld_pcs_interface_pcs_testbus_block_sel  		(hssi_common_pld_pcs_interface_pcs_testbus_block_sel ),
           .hssi_common_pld_pcs_interface_reconfig_settings  		(hssi_common_pld_pcs_interface_reconfig_settings ),
           .hssi_fifo_rx_pcs_double_read_mode  		(hssi_fifo_rx_pcs_double_read_mode ),
           .hssi_fifo_rx_pcs_prot_mode      		(hssi_fifo_rx_pcs_prot_mode     ),
           .hssi_fifo_tx_pcs_double_write_mode  		(hssi_fifo_tx_pcs_double_write_mode ),
           .hssi_fifo_tx_pcs_prot_mode      		(hssi_fifo_tx_pcs_prot_mode     ),
           .hssi_gen3_rx_pcs_block_sync     		(hssi_gen3_rx_pcs_block_sync    ),
           .hssi_gen3_rx_pcs_block_sync_sm  		(hssi_gen3_rx_pcs_block_sync_sm ),
           .hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn  		(hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn ),
           .hssi_gen3_rx_pcs_lpbk_force     		(hssi_gen3_rx_pcs_lpbk_force    ),
           .hssi_gen3_rx_pcs_mode           		(hssi_gen3_rx_pcs_mode          ),
           .hssi_gen3_rx_pcs_rate_match_fifo  		(hssi_gen3_rx_pcs_rate_match_fifo ),
           .hssi_gen3_rx_pcs_rate_match_fifo_latency  		(hssi_gen3_rx_pcs_rate_match_fifo_latency ),
           .hssi_gen3_rx_pcs_reconfig_settings  		(hssi_gen3_rx_pcs_reconfig_settings ),
           .hssi_gen3_rx_pcs_reverse_lpbk   		(hssi_gen3_rx_pcs_reverse_lpbk  ),
           .hssi_gen3_rx_pcs_rx_b4gb_par_lpbk  		(hssi_gen3_rx_pcs_rx_b4gb_par_lpbk ),
           .hssi_gen3_rx_pcs_rx_force_balign  		(hssi_gen3_rx_pcs_rx_force_balign ),
           .hssi_gen3_rx_pcs_rx_ins_del_one_skip  		(hssi_gen3_rx_pcs_rx_ins_del_one_skip ),
           .hssi_gen3_rx_pcs_rx_num_fixed_pat  		(hssi_gen3_rx_pcs_rx_num_fixed_pat ),
           .hssi_gen3_rx_pcs_rx_test_out_sel  		(hssi_gen3_rx_pcs_rx_test_out_sel ),
           .hssi_gen3_rx_pcs_sup_mode       		(hssi_gen3_rx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_mode           		(hssi_gen3_tx_pcs_mode          ),
           .hssi_gen3_tx_pcs_reverse_lpbk   		(hssi_gen3_tx_pcs_reverse_lpbk  ),
           .hssi_gen3_tx_pcs_sup_mode       		(hssi_gen3_tx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_tx_bitslip     		(hssi_gen3_tx_pcs_tx_bitslip    ),
           .hssi_gen3_tx_pcs_tx_gbox_byp    		(hssi_gen3_tx_pcs_tx_gbox_byp   ),
           .hssi_krfec_rx_pcs_blksync_cor_en  		(hssi_krfec_rx_pcs_blksync_cor_en ),
           .hssi_krfec_rx_pcs_bypass_gb     		(hssi_krfec_rx_pcs_bypass_gb    ),
           .hssi_krfec_rx_pcs_clr_ctrl      		(hssi_krfec_rx_pcs_clr_ctrl     ),
           .hssi_krfec_rx_pcs_ctrl_bit_reverse  		(hssi_krfec_rx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_rx_pcs_data_bit_reverse  		(hssi_krfec_rx_pcs_data_bit_reverse ),
           .hssi_krfec_rx_pcs_dv_start      		(hssi_krfec_rx_pcs_dv_start     ),
           .hssi_krfec_rx_pcs_err_mark_type  		(hssi_krfec_rx_pcs_err_mark_type ),
           .hssi_krfec_rx_pcs_error_marking_en  		(hssi_krfec_rx_pcs_error_marking_en ),
           .hssi_krfec_rx_pcs_low_latency_en  		(hssi_krfec_rx_pcs_low_latency_en ),
           .hssi_krfec_rx_pcs_lpbk_mode     		(hssi_krfec_rx_pcs_lpbk_mode    ),
           .hssi_krfec_rx_pcs_parity_invalid_enum  		(hssi_krfec_rx_pcs_parity_invalid_enum ),
           .hssi_krfec_rx_pcs_parity_valid_num  		(hssi_krfec_rx_pcs_parity_valid_num ),
           .hssi_krfec_rx_pcs_pipeln_blksync  		(hssi_krfec_rx_pcs_pipeln_blksync ),
           .hssi_krfec_rx_pcs_pipeln_descrm  		(hssi_krfec_rx_pcs_pipeln_descrm ),
           .hssi_krfec_rx_pcs_pipeln_errcorrect  		(hssi_krfec_rx_pcs_pipeln_errcorrect ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_ind  		(hssi_krfec_rx_pcs_pipeln_errtrap_ind ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_lfsr  		(hssi_krfec_rx_pcs_pipeln_errtrap_lfsr ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_loc  		(hssi_krfec_rx_pcs_pipeln_errtrap_loc ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_pat  		(hssi_krfec_rx_pcs_pipeln_errtrap_pat ),
           .hssi_krfec_rx_pcs_pipeln_gearbox  		(hssi_krfec_rx_pcs_pipeln_gearbox ),
           .hssi_krfec_rx_pcs_pipeln_syndrm  		(hssi_krfec_rx_pcs_pipeln_syndrm ),
           .hssi_krfec_rx_pcs_pipeln_trans_dec  		(hssi_krfec_rx_pcs_pipeln_trans_dec ),
           .hssi_krfec_rx_pcs_prot_mode     		(hssi_krfec_rx_pcs_prot_mode    ),
           .hssi_krfec_rx_pcs_receive_order  		(hssi_krfec_rx_pcs_receive_order ),
           .hssi_krfec_rx_pcs_reconfig_settings  		(hssi_krfec_rx_pcs_reconfig_settings ),
           .hssi_krfec_rx_pcs_rx_testbus_sel  		(hssi_krfec_rx_pcs_rx_testbus_sel ),
           .hssi_krfec_rx_pcs_signal_ok_en  		(hssi_krfec_rx_pcs_signal_ok_en ),
           .hssi_krfec_rx_pcs_sup_mode      		(hssi_krfec_rx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_burst_err     		(hssi_krfec_tx_pcs_burst_err    ),
           .hssi_krfec_tx_pcs_burst_err_len  		(hssi_krfec_tx_pcs_burst_err_len ),
           .hssi_krfec_tx_pcs_ctrl_bit_reverse  		(hssi_krfec_tx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_tx_pcs_data_bit_reverse  		(hssi_krfec_tx_pcs_data_bit_reverse ),
           .hssi_krfec_tx_pcs_enc_frame_query  		(hssi_krfec_tx_pcs_enc_frame_query ),
           .hssi_krfec_tx_pcs_low_latency_en  		(hssi_krfec_tx_pcs_low_latency_en ),
           .hssi_krfec_tx_pcs_pipeln_encoder  		(hssi_krfec_tx_pcs_pipeln_encoder ),
           .hssi_krfec_tx_pcs_pipeln_scrambler  		(hssi_krfec_tx_pcs_pipeln_scrambler ),
           .hssi_krfec_tx_pcs_prot_mode     		(hssi_krfec_tx_pcs_prot_mode    ),
           .hssi_krfec_tx_pcs_sup_mode      		(hssi_krfec_tx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_transcode_err  		(hssi_krfec_tx_pcs_transcode_err ),
           .hssi_krfec_tx_pcs_transmit_order  		(hssi_krfec_tx_pcs_transmit_order ),
           .hssi_krfec_tx_pcs_tx_testbus_sel  		(hssi_krfec_tx_pcs_tx_testbus_sel ),
           .hssi_pipe_gen1_2_elec_idle_delay_val  		(hssi_pipe_gen1_2_elec_idle_delay_val ),
           .hssi_pipe_gen1_2_error_replace_pad  		(hssi_pipe_gen1_2_error_replace_pad ),
           .hssi_pipe_gen1_2_hip_mode       		(hssi_pipe_gen1_2_hip_mode      ),
           .hssi_pipe_gen1_2_ind_error_reporting  		(hssi_pipe_gen1_2_ind_error_reporting ),
           .hssi_pipe_gen1_2_phystatus_delay_val  		(hssi_pipe_gen1_2_phystatus_delay_val ),
           .hssi_pipe_gen1_2_phystatus_rst_toggle  		(hssi_pipe_gen1_2_phystatus_rst_toggle ),
           .hssi_pipe_gen1_2_pipe_byte_de_serializer_en  		(hssi_pipe_gen1_2_pipe_byte_de_serializer_en ),
           .hssi_pipe_gen1_2_prot_mode      		(hssi_pipe_gen1_2_prot_mode     ),
           .hssi_pipe_gen1_2_reconfig_settings  		(hssi_pipe_gen1_2_reconfig_settings ),
           .hssi_pipe_gen1_2_rx_pipe_enable  		(hssi_pipe_gen1_2_rx_pipe_enable ),
           .hssi_pipe_gen1_2_rxdetect_bypass  		(hssi_pipe_gen1_2_rxdetect_bypass ),
           .hssi_pipe_gen1_2_sup_mode       		(hssi_pipe_gen1_2_sup_mode      ),
           .hssi_pipe_gen1_2_tx_pipe_enable  		(hssi_pipe_gen1_2_tx_pipe_enable ),
           .hssi_pipe_gen1_2_txswing        		(hssi_pipe_gen1_2_txswing       ),
           .hssi_pipe_gen3_bypass_rx_detection_enable  		(hssi_pipe_gen3_bypass_rx_detection_enable ),
           .hssi_pipe_gen3_bypass_rx_preset  		(hssi_pipe_gen3_bypass_rx_preset ),
           .hssi_pipe_gen3_bypass_rx_preset_enable  		(hssi_pipe_gen3_bypass_rx_preset_enable ),
           .hssi_pipe_gen3_bypass_tx_coefficent  		(hssi_pipe_gen3_bypass_tx_coefficent ),
           .hssi_pipe_gen3_bypass_tx_coefficent_enable  		(hssi_pipe_gen3_bypass_tx_coefficent_enable ),
           .hssi_pipe_gen3_elecidle_delay_g3  		(hssi_pipe_gen3_elecidle_delay_g3 ),
           .hssi_pipe_gen3_ind_error_reporting  		(hssi_pipe_gen3_ind_error_reporting ),
           .hssi_pipe_gen3_mode             		(hssi_pipe_gen3_mode            ),
           .hssi_pipe_gen3_phy_status_delay_g12  		(hssi_pipe_gen3_phy_status_delay_g12 ),
           .hssi_pipe_gen3_phy_status_delay_g3  		(hssi_pipe_gen3_phy_status_delay_g3 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g12  		(hssi_pipe_gen3_phystatus_rst_toggle_g12 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g3  		(hssi_pipe_gen3_phystatus_rst_toggle_g3 ),
           .hssi_pipe_gen3_rate_match_pad_insertion  		(hssi_pipe_gen3_rate_match_pad_insertion ),
           .hssi_pipe_gen3_sup_mode         		(hssi_pipe_gen3_sup_mode        ),
           .hssi_pipe_gen3_test_out_sel     		(hssi_pipe_gen3_test_out_sel    ),
           .hssi_rx_pcs_pma_interface_block_sel  		(hssi_rx_pcs_pma_interface_block_sel ),
           .hssi_rx_pcs_pma_interface_channel_operation_mode  		(hssi_rx_pcs_pma_interface_channel_operation_mode ),
           .hssi_rx_pcs_pma_interface_clkslip_sel  		(hssi_rx_pcs_pma_interface_clkslip_sel ),
           .hssi_rx_pcs_pma_interface_lpbk_en  		(hssi_rx_pcs_pma_interface_lpbk_en ),
           .hssi_rx_pcs_pma_interface_master_clk_sel  		(hssi_rx_pcs_pma_interface_master_clk_sel ),
           .hssi_rx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_rx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_rx_pcs_pma_interface_pma_dw_rx  		(hssi_rx_pcs_pma_interface_pma_dw_rx ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_en  		(hssi_rx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_val  		(hssi_rx_pcs_pma_interface_pma_if_dft_val ),
           .hssi_rx_pcs_pma_interface_prbs9_dwidth  		(hssi_rx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_rx_pcs_pma_interface_prbs_clken  		(hssi_rx_pcs_pma_interface_prbs_clken ),
           .hssi_rx_pcs_pma_interface_prbs_ver  		(hssi_rx_pcs_pma_interface_prbs_ver ),
           .hssi_rx_pcs_pma_interface_prot_mode_rx  		(hssi_rx_pcs_pma_interface_prot_mode_rx ),
           .hssi_rx_pcs_pma_interface_reconfig_settings  		(hssi_rx_pcs_pma_interface_reconfig_settings ),
           .hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_lpbk_en ),
           .hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok  		(hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mask  		(hssi_rx_pcs_pma_interface_rx_prbs_mask ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mode  		(hssi_rx_pcs_pma_interface_rx_prbs_mode ),
           .hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel  		(hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel ),
           .hssi_rx_pcs_pma_interface_rx_static_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_static_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en ),
           .hssi_rx_pcs_pma_interface_sup_mode  		(hssi_rx_pcs_pma_interface_sup_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_rx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_rx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_rx_pld_pcs_interface_pcs_rx_block_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_block_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en  		(hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en ),
           .hssi_rx_pld_pcs_interface_pcs_rx_output_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_output_sel ),
           .hssi_rx_pld_pcs_interface_reconfig_settings  		(hssi_rx_pld_pcs_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_bypass_pma_txelecidle  		(hssi_tx_pcs_pma_interface_bypass_pma_txelecidle ),
           .hssi_tx_pcs_pma_interface_channel_operation_mode  		(hssi_tx_pcs_pma_interface_channel_operation_mode ),
           .hssi_tx_pcs_pma_interface_lpbk_en  		(hssi_tx_pcs_pma_interface_lpbk_en ),
           .hssi_tx_pcs_pma_interface_master_clk_sel  		(hssi_tx_pcs_pma_interface_master_clk_sel ),
           .hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx  		(hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_tx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_tx_pcs_pma_interface_pma_dw_tx  		(hssi_tx_pcs_pma_interface_pma_dw_tx ),
           .hssi_tx_pcs_pma_interface_pma_if_dft_en  		(hssi_tx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_tx_pcs_pma_interface_pmagate_en  		(hssi_tx_pcs_pma_interface_pmagate_en ),
           .hssi_tx_pcs_pma_interface_prbs9_dwidth  		(hssi_tx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_tx_pcs_pma_interface_prbs_clken  		(hssi_tx_pcs_pma_interface_prbs_clken ),
           .hssi_tx_pcs_pma_interface_prbs_gen_pat  		(hssi_tx_pcs_pma_interface_prbs_gen_pat ),
           .hssi_tx_pcs_pma_interface_prot_mode_tx  		(hssi_tx_pcs_pma_interface_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_reconfig_settings  		(hssi_tx_pcs_pma_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_sq_wave_num  		(hssi_tx_pcs_pma_interface_sq_wave_num ),
           .hssi_tx_pcs_pma_interface_sqwgen_clken  		(hssi_tx_pcs_pma_interface_sqwgen_clken ),
           .hssi_tx_pcs_pma_interface_sup_mode  		(hssi_tx_pcs_pma_interface_sup_mode ),
           .hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_tx_pma_data_sel  		(hssi_tx_pcs_pma_interface_tx_pma_data_sel ),
           .hssi_tx_pcs_pma_interface_tx_static_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_static_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period  		(hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable  		(hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control ),
           .hssi_tx_pcs_pma_interface_uhsif_enable  		(hssi_tx_pcs_pma_interface_uhsif_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value ),
           .hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_tx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_tx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding  		(hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_source  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_data_source  		(hssi_tx_pld_pcs_interface_pcs_tx_data_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_output_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_output_sel ),
           .hssi_tx_pld_pcs_interface_reconfig_settings  		(hssi_tx_pld_pcs_interface_reconfig_settings ),
           .avmm_interfaces                 		(avmm_interfaces                ),
           .rcfg_enable                     		(rcfg_enable                    ),
           .enable_avmm                     		(enable_avmm                    ),
           .arbiter_ctrl                    		(arbiter_ctrl                   ),
           .calibration_en                  		(calibration_en                 ),
           .avmm_busy_en                    		(avmm_busy_en                   ),
           .hip_cal_en                      		(hip_cal_en                     ),
           .cal_done                        		(cal_done                       )
                  )
               twentynm_xcvr_native_inst(.*);
             end


  "20nm3":   begin
               twentynm_xcvr_native_rev_20nm3
                 #(
			
           .bonded_lanes                    		(bonded_lanes                   ),
           .bonding_master_ch               		(bonding_master_ch              ),
           .xcvr_native_mode                		(xcvr_native_mode               ),
           .pma_adapt_adapt_mode            		(pma_adapt_adapt_mode           ),
           .pma_adapt_adp_1s_ctle_bypass    		(pma_adapt_adp_1s_ctle_bypass   ),
           .pma_adapt_adp_4s_ctle_bypass    		(pma_adapt_adp_4s_ctle_bypass   ),
           .pma_adapt_adp_ctle_adapt_cycle_window  		(pma_adapt_adp_ctle_adapt_cycle_window ),
           .pma_adapt_adp_ctle_en           		(pma_adapt_adp_ctle_en          ),
           .pma_adapt_adp_dfe_fltap_bypass  		(pma_adapt_adp_dfe_fltap_bypass ),
           .pma_adapt_adp_dfe_fltap_en      		(pma_adapt_adp_dfe_fltap_en     ),
           .pma_adapt_adp_dfe_fxtap_bypass  		(pma_adapt_adp_dfe_fxtap_bypass ),
           .pma_adapt_adp_dfe_fxtap_en      		(pma_adapt_adp_dfe_fxtap_en     ),
           .pma_adapt_adp_dfe_fxtap_hold_en  		(pma_adapt_adp_dfe_fxtap_hold_en ),
           .pma_adapt_adp_dfe_mode          		(pma_adapt_adp_dfe_mode         ),
           .pma_adapt_adp_mode              		(pma_adapt_adp_mode             ),
           .pma_adapt_adp_onetime_dfe       		(pma_adapt_adp_onetime_dfe      ),
           .pma_adapt_adp_vga_bypass        		(pma_adapt_adp_vga_bypass       ),
           .pma_adapt_adp_vga_en            		(pma_adapt_adp_vga_en           ),
           .pma_adapt_adp_vref_bypass       		(pma_adapt_adp_vref_bypass      ),
           .pma_adapt_adp_vref_en           		(pma_adapt_adp_vref_en          ),
           .pma_adapt_datarate              		(pma_adapt_datarate             ),
           .pma_adapt_odi_dfe_spec_en       		(pma_adapt_odi_dfe_spec_en      ),
           .pma_adapt_prot_mode             		(pma_adapt_prot_mode            ),
           .pma_adapt_sup_mode              		(pma_adapt_sup_mode             ),
           .pma_cdr_refclk_inclk0_logical_to_physical_mapping  		(pma_cdr_refclk_inclk0_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk1_logical_to_physical_mapping  		(pma_cdr_refclk_inclk1_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk2_logical_to_physical_mapping  		(pma_cdr_refclk_inclk2_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk3_logical_to_physical_mapping  		(pma_cdr_refclk_inclk3_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk4_logical_to_physical_mapping  		(pma_cdr_refclk_inclk4_logical_to_physical_mapping ),
           .pma_cdr_refclk_powerdown_mode   		(pma_cdr_refclk_powerdown_mode  ),
           .pma_cdr_refclk_refclk_select    		(pma_cdr_refclk_refclk_select   ),
           .cdr_pll_atb_select_control      		(cdr_pll_atb_select_control     ),
           .cdr_pll_auto_reset_on           		(cdr_pll_auto_reset_on          ),
           .cdr_pll_bbpd_data_pattern_filter_select  		(cdr_pll_bbpd_data_pattern_filter_select ),
           .cdr_pll_bw_sel                  		(cdr_pll_bw_sel                 ),
           .cdr_pll_cal_vco_count_length    		(cdr_pll_cal_vco_count_length   ),
           .cdr_pll_cdr_odi_select          		(cdr_pll_cdr_odi_select         ),
           .cdr_pll_cdr_phaselock_mode      		(cdr_pll_cdr_phaselock_mode     ),
           .cdr_pll_cdr_powerdown_mode      		(cdr_pll_cdr_powerdown_mode     ),
           .cdr_pll_cgb_div                 		(cdr_pll_cgb_div                ),
           .cdr_pll_chgpmp_current_dn_pd    		(cdr_pll_chgpmp_current_dn_pd   ),
           .cdr_pll_chgpmp_current_dn_trim  		(cdr_pll_chgpmp_current_dn_trim ),
           .cdr_pll_chgpmp_current_pd       		(cdr_pll_chgpmp_current_pd      ),
           .cdr_pll_chgpmp_current_pfd      		(cdr_pll_chgpmp_current_pfd     ),
           .cdr_pll_chgpmp_current_up_pd    		(cdr_pll_chgpmp_current_up_pd   ),
           .cdr_pll_chgpmp_current_up_trim  		(cdr_pll_chgpmp_current_up_trim ),
           .cdr_pll_chgpmp_dn_pd_trim_double  		(cdr_pll_chgpmp_dn_pd_trim_double ),
           .cdr_pll_chgpmp_replicate        		(cdr_pll_chgpmp_replicate       ),
           .cdr_pll_chgpmp_testmode         		(cdr_pll_chgpmp_testmode        ),
           .cdr_pll_chgpmp_up_pd_trim_double  		(cdr_pll_chgpmp_up_pd_trim_double ),
           .cdr_pll_clklow_mux_select       		(cdr_pll_clklow_mux_select      ),
           .cdr_pll_datarate                		(cdr_pll_datarate               ),
           .cdr_pll_diag_loopback_enable    		(cdr_pll_diag_loopback_enable   ),
           .cdr_pll_disable_up_dn           		(cdr_pll_disable_up_dn          ),
           .cdr_pll_fb_select               		(cdr_pll_fb_select              ),
           .cdr_pll_fref_clklow_div         		(cdr_pll_fref_clklow_div        ),
           .cdr_pll_fref_mux_select         		(cdr_pll_fref_mux_select        ),
           .cdr_pll_gpon_lck2ref_control    		(cdr_pll_gpon_lck2ref_control   ),
           .cdr_pll_initial_settings        		(cdr_pll_initial_settings       ),
           .cdr_pll_iqclk_mux_sel           		(cdr_pll_iqclk_mux_sel          ),
           .cdr_pll_is_cascaded_pll         		(cdr_pll_is_cascaded_pll        ),
           .cdr_pll_lck2ref_delay_control   		(cdr_pll_lck2ref_delay_control  ),
           .cdr_pll_lf_resistor_pd          		(cdr_pll_lf_resistor_pd         ),
           .cdr_pll_lf_resistor_pfd         		(cdr_pll_lf_resistor_pfd        ),
           .cdr_pll_lf_ripple_cap           		(cdr_pll_lf_ripple_cap          ),
           .cdr_pll_loop_filter_bias_select  		(cdr_pll_loop_filter_bias_select ),
           .cdr_pll_loopback_mode           		(cdr_pll_loopback_mode          ),
           .cdr_pll_lpd_counter             		(cdr_pll_lpd_counter            ),
           .cdr_pll_lpfd_counter            		(cdr_pll_lpfd_counter           ),
           .cdr_pll_ltd_ltr_micro_controller_select  		(cdr_pll_ltd_ltr_micro_controller_select ),
           .cdr_pll_m_counter               		(cdr_pll_m_counter              ),
           .cdr_pll_n_counter               		(cdr_pll_n_counter              ),
           .cdr_pll_n_counter_scratch       		(cdr_pll_n_counter_scratch      ),
           .cdr_pll_output_clock_frequency  		(cdr_pll_output_clock_frequency ),
           .cdr_pll_pcie_gen                		(cdr_pll_pcie_gen               ),
           .cdr_pll_pd_fastlock_mode        		(cdr_pll_pd_fastlock_mode       ),
           .cdr_pll_pd_l_counter            		(cdr_pll_pd_l_counter           ),
           .cdr_pll_pfd_l_counter           		(cdr_pll_pfd_l_counter          ),
           .cdr_pll_pma_width               		(cdr_pll_pma_width              ),
           .cdr_pll_primary_use             		(cdr_pll_primary_use            ),
           .cdr_pll_prot_mode               		(cdr_pll_prot_mode              ),
           .cdr_pll_reference_clock_frequency  		(cdr_pll_reference_clock_frequency ),
           .cdr_pll_reverse_serial_loopback  		(cdr_pll_reverse_serial_loopback ),
           .cdr_pll_set_cdr_input_freq_range  		(cdr_pll_set_cdr_input_freq_range ),
           .cdr_pll_set_cdr_v2i_enable      		(cdr_pll_set_cdr_v2i_enable     ),
           .cdr_pll_set_cdr_vco_reset       		(cdr_pll_set_cdr_vco_reset      ),
           .cdr_pll_set_cdr_vco_speed       		(cdr_pll_set_cdr_vco_speed      ),
           .cdr_pll_set_cdr_vco_speed_fix   		(cdr_pll_set_cdr_vco_speed_fix  ),
           .cdr_pll_set_cdr_vco_speed_pciegen3  		(cdr_pll_set_cdr_vco_speed_pciegen3 ),
           .cdr_pll_sup_mode                		(cdr_pll_sup_mode               ),
           .cdr_pll_tx_pll_prot_mode        		(cdr_pll_tx_pll_prot_mode       ),
           .cdr_pll_txpll_hclk_driver_enable  		(cdr_pll_txpll_hclk_driver_enable ),
           .cdr_pll_uc_ro_cal               		(cdr_pll_uc_ro_cal              ),
           .cdr_pll_vco_freq                		(cdr_pll_vco_freq               ),
           .cdr_pll_vco_overrange_voltage   		(cdr_pll_vco_overrange_voltage  ),
           .cdr_pll_vco_underrange_voltage  		(cdr_pll_vco_underrange_voltage ),
           .pma_rx_buf_bypass_eqz_stages_234  		(pma_rx_buf_bypass_eqz_stages_234 ),
           .pma_rx_buf_datarate             		(pma_rx_buf_datarate            ),
           .pma_rx_buf_diag_lp_en           		(pma_rx_buf_diag_lp_en          ),
           .pma_rx_buf_loopback_modes       		(pma_rx_buf_loopback_modes      ),
           .pma_rx_buf_pm_tx_rx_cvp_mode    		(pma_rx_buf_pm_tx_rx_cvp_mode   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen    		(pma_rx_buf_pm_tx_rx_pcie_gen   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth  		(pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth ),
           .pma_rx_buf_prot_mode            		(pma_rx_buf_prot_mode           ),
           .pma_rx_buf_qpi_enable           		(pma_rx_buf_qpi_enable          ),
           .pma_rx_buf_refclk_en            		(pma_rx_buf_refclk_en           ),
           .pma_rx_buf_rx_refclk_divider    		(pma_rx_buf_rx_refclk_divider   ),
           .pma_rx_buf_sup_mode             		(pma_rx_buf_sup_mode            ),
           .pma_rx_buf_xrx_path_datarate    		(pma_rx_buf_xrx_path_datarate   ),
           .pma_rx_buf_xrx_path_datawidth   		(pma_rx_buf_xrx_path_datawidth  ),
           .pma_rx_buf_xrx_path_pma_rx_divclk_hz  		(pma_rx_buf_xrx_path_pma_rx_divclk_hz ),
           .pma_rx_buf_xrx_path_prot_mode   		(pma_rx_buf_xrx_path_prot_mode  ),
           .pma_rx_buf_xrx_path_sup_mode    		(pma_rx_buf_xrx_path_sup_mode   ),
           .pma_rx_buf_xrx_path_uc_cal_enable  		(pma_rx_buf_xrx_path_uc_cal_enable ),
           .pma_rx_deser_bitslip_bypass     		(pma_rx_deser_bitslip_bypass    ),
           .pma_rx_deser_clkdiv_source      		(pma_rx_deser_clkdiv_source     ),
           .pma_rx_deser_clkdivrx_user_mode  		(pma_rx_deser_clkdivrx_user_mode ),
           .pma_rx_deser_datarate           		(pma_rx_deser_datarate          ),
           .pma_rx_deser_deser_factor       		(pma_rx_deser_deser_factor      ),
           .pma_rx_deser_force_clkdiv_for_testing  		(pma_rx_deser_force_clkdiv_for_testing ),
           .pma_rx_deser_pcie_gen           		(pma_rx_deser_pcie_gen          ),
           .pma_rx_deser_pcie_gen_bitwidth  		(pma_rx_deser_pcie_gen_bitwidth ),
           .pma_rx_deser_prot_mode          		(pma_rx_deser_prot_mode         ),
           .pma_rx_deser_rst_n_adapt_odi    		(pma_rx_deser_rst_n_adapt_odi   ),
           .pma_rx_deser_sdclk_enable       		(pma_rx_deser_sdclk_enable      ),
           .pma_rx_deser_sup_mode           		(pma_rx_deser_sup_mode          ),
           .pma_rx_dfe_datarate             		(pma_rx_dfe_datarate            ),
           .pma_rx_dfe_dft_en               		(pma_rx_dfe_dft_en              ),
           .pma_rx_dfe_pdb                  		(pma_rx_dfe_pdb                 ),
           .pma_rx_dfe_pdb_fixedtap         		(pma_rx_dfe_pdb_fixedtap        ),
           .pma_rx_dfe_pdb_floattap         		(pma_rx_dfe_pdb_floattap        ),
           .pma_rx_dfe_pdb_fxtap4t7         		(pma_rx_dfe_pdb_fxtap4t7        ),
           .pma_rx_dfe_prot_mode            		(pma_rx_dfe_prot_mode           ),
           .pma_rx_dfe_sup_mode             		(pma_rx_dfe_sup_mode            ),
           .pma_rx_odi_datarate             		(pma_rx_odi_datarate            ),
           .pma_rx_odi_prot_mode            		(pma_rx_odi_prot_mode           ),
           .pma_rx_odi_step_ctrl_sel        		(pma_rx_odi_step_ctrl_sel       ),
           .pma_rx_odi_sup_mode             		(pma_rx_odi_sup_mode            ),
           .pma_rx_sd_prot_mode             		(pma_rx_sd_prot_mode            ),
           .pma_rx_sd_sd_output_off         		(pma_rx_sd_sd_output_off        ),
           .pma_rx_sd_sd_output_on          		(pma_rx_sd_sd_output_on         ),
           .pma_rx_sd_sd_pdb                		(pma_rx_sd_sd_pdb               ),
           .pma_rx_sd_sup_mode              		(pma_rx_sd_sup_mode             ),
           .pma_tx_buf_datarate             		(pma_tx_buf_datarate            ),
           .pma_tx_buf_mcgb_location_for_pcie  		(pma_tx_buf_mcgb_location_for_pcie ),
           .pma_tx_buf_prot_mode            		(pma_tx_buf_prot_mode           ),
           .pma_tx_buf_rx_det               		(pma_tx_buf_rx_det              ),
           .pma_tx_buf_rx_det_output_sel    		(pma_tx_buf_rx_det_output_sel   ),
           .pma_tx_buf_rx_det_pdb           		(pma_tx_buf_rx_det_pdb          ),
           .pma_tx_buf_sup_mode             		(pma_tx_buf_sup_mode            ),
           .pma_tx_buf_user_fir_coeff_ctrl_sel  		(pma_tx_buf_user_fir_coeff_ctrl_sel ),
           .pma_tx_buf_xtx_path_clock_divider_ratio  		(pma_tx_buf_xtx_path_clock_divider_ratio ),
           .pma_tx_buf_xtx_path_datarate    		(pma_tx_buf_xtx_path_datarate   ),
           .pma_tx_buf_xtx_path_datawidth   		(pma_tx_buf_xtx_path_datawidth  ),
           .pma_tx_buf_xtx_path_pma_tx_divclk_hz  		(pma_tx_buf_xtx_path_pma_tx_divclk_hz ),
           .pma_tx_buf_xtx_path_prot_mode   		(pma_tx_buf_xtx_path_prot_mode  ),
           .pma_tx_buf_xtx_path_sup_mode    		(pma_tx_buf_xtx_path_sup_mode   ),
           .pma_tx_buf_xtx_path_tx_pll_clk_hz  		(pma_tx_buf_xtx_path_tx_pll_clk_hz ),
           .pma_cgb_bitslip_enable          		(pma_cgb_bitslip_enable         ),
           .pma_cgb_bonding_reset_enable    		(pma_cgb_bonding_reset_enable   ),
           .pma_cgb_datarate                		(pma_cgb_datarate               ),
           .pma_cgb_input_select_gen3       		(pma_cgb_input_select_gen3      ),
           .pma_cgb_input_select_x1         		(pma_cgb_input_select_x1        ),
           .pma_cgb_input_select_xn         		(pma_cgb_input_select_xn        ),
           .pma_cgb_pcie_gen3_bitwidth      		(pma_cgb_pcie_gen3_bitwidth     ),
           .pma_cgb_prot_mode               		(pma_cgb_prot_mode              ),
           .pma_cgb_scratch0_x1_clock_src   		(pma_cgb_scratch0_x1_clock_src  ),
           .pma_cgb_scratch1_x1_clock_src   		(pma_cgb_scratch1_x1_clock_src  ),
           .pma_cgb_scratch2_x1_clock_src   		(pma_cgb_scratch2_x1_clock_src  ),
           .pma_cgb_scratch3_x1_clock_src   		(pma_cgb_scratch3_x1_clock_src  ),
           .pma_cgb_select_done_master_or_slave  		(pma_cgb_select_done_master_or_slave ),
           .pma_cgb_ser_mode                		(pma_cgb_ser_mode               ),
           .pma_cgb_sup_mode                		(pma_cgb_sup_mode               ),
           .pma_cgb_tx_ucontrol_en          		(pma_cgb_tx_ucontrol_en         ),
           .pma_cgb_x1_div_m_sel            		(pma_cgb_x1_div_m_sel           ),
           .pma_tx_ser_prot_mode            		(pma_tx_ser_prot_mode           ),
           .pma_tx_ser_ser_clk_divtx_user_sel  		(pma_tx_ser_ser_clk_divtx_user_sel ),
           .pma_tx_ser_sup_mode             		(pma_tx_ser_sup_mode            ),
           .hssi_10g_rx_pcs_advanced_user_mode  		(hssi_10g_rx_pcs_advanced_user_mode ),
           .hssi_10g_rx_pcs_align_del       		(hssi_10g_rx_pcs_align_del      ),
           .hssi_10g_rx_pcs_ber_bit_err_total_cnt  		(hssi_10g_rx_pcs_ber_bit_err_total_cnt ),
           .hssi_10g_rx_pcs_ber_clken       		(hssi_10g_rx_pcs_ber_clken      ),
           .hssi_10g_rx_pcs_ber_xus_timer_window  		(hssi_10g_rx_pcs_ber_xus_timer_window ),
           .hssi_10g_rx_pcs_bitslip_mode    		(hssi_10g_rx_pcs_bitslip_mode   ),
           .hssi_10g_rx_pcs_blksync_bitslip_type  		(hssi_10g_rx_pcs_blksync_bitslip_type ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_cnt  		(hssi_10g_rx_pcs_blksync_bitslip_wait_cnt ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_type  		(hssi_10g_rx_pcs_blksync_bitslip_wait_type ),
           .hssi_10g_rx_pcs_blksync_bypass  		(hssi_10g_rx_pcs_blksync_bypass ),
           .hssi_10g_rx_pcs_blksync_clken   		(hssi_10g_rx_pcs_blksync_clken  ),
           .hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt  		(hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock ),
           .hssi_10g_rx_pcs_blksync_pipeln  		(hssi_10g_rx_pcs_blksync_pipeln ),
           .hssi_10g_rx_pcs_clr_errblk_cnt_en  		(hssi_10g_rx_pcs_clr_errblk_cnt_en ),
           .hssi_10g_rx_pcs_control_del     		(hssi_10g_rx_pcs_control_del    ),
           .hssi_10g_rx_pcs_crcchk_bypass   		(hssi_10g_rx_pcs_crcchk_bypass  ),
           .hssi_10g_rx_pcs_crcchk_clken    		(hssi_10g_rx_pcs_crcchk_clken   ),
           .hssi_10g_rx_pcs_crcchk_inv      		(hssi_10g_rx_pcs_crcchk_inv     ),
           .hssi_10g_rx_pcs_crcchk_pipeln   		(hssi_10g_rx_pcs_crcchk_pipeln  ),
           .hssi_10g_rx_pcs_crcflag_pipeln  		(hssi_10g_rx_pcs_crcflag_pipeln ),
           .hssi_10g_rx_pcs_ctrl_bit_reverse  		(hssi_10g_rx_pcs_ctrl_bit_reverse ),
           .hssi_10g_rx_pcs_data_bit_reverse  		(hssi_10g_rx_pcs_data_bit_reverse ),
           .hssi_10g_rx_pcs_dec64b66b_clken  		(hssi_10g_rx_pcs_dec64b66b_clken ),
           .hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass  		(hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass ),
           .hssi_10g_rx_pcs_descrm_bypass   		(hssi_10g_rx_pcs_descrm_bypass  ),
           .hssi_10g_rx_pcs_descrm_clken    		(hssi_10g_rx_pcs_descrm_clken   ),
           .hssi_10g_rx_pcs_descrm_mode     		(hssi_10g_rx_pcs_descrm_mode    ),
           .hssi_10g_rx_pcs_descrm_pipeln   		(hssi_10g_rx_pcs_descrm_pipeln  ),
           .hssi_10g_rx_pcs_dft_clk_out_sel  		(hssi_10g_rx_pcs_dft_clk_out_sel ),
           .hssi_10g_rx_pcs_dis_signal_ok   		(hssi_10g_rx_pcs_dis_signal_ok  ),
           .hssi_10g_rx_pcs_dispchk_bypass  		(hssi_10g_rx_pcs_dispchk_bypass ),
           .hssi_10g_rx_pcs_empty_flag_type  		(hssi_10g_rx_pcs_empty_flag_type ),
           .hssi_10g_rx_pcs_fast_path       		(hssi_10g_rx_pcs_fast_path      ),
           .hssi_10g_rx_pcs_fec_clken       		(hssi_10g_rx_pcs_fec_clken      ),
           .hssi_10g_rx_pcs_fec_enable      		(hssi_10g_rx_pcs_fec_enable     ),
           .hssi_10g_rx_pcs_fifo_double_read  		(hssi_10g_rx_pcs_fifo_double_read ),
           .hssi_10g_rx_pcs_fifo_stop_rd    		(hssi_10g_rx_pcs_fifo_stop_rd   ),
           .hssi_10g_rx_pcs_fifo_stop_wr    		(hssi_10g_rx_pcs_fifo_stop_wr   ),
           .hssi_10g_rx_pcs_force_align     		(hssi_10g_rx_pcs_force_align    ),
           .hssi_10g_rx_pcs_frmsync_bypass  		(hssi_10g_rx_pcs_frmsync_bypass ),
           .hssi_10g_rx_pcs_frmsync_clken   		(hssi_10g_rx_pcs_frmsync_clken  ),
           .hssi_10g_rx_pcs_frmsync_enum_scrm  		(hssi_10g_rx_pcs_frmsync_enum_scrm ),
           .hssi_10g_rx_pcs_frmsync_enum_sync  		(hssi_10g_rx_pcs_frmsync_enum_sync ),
           .hssi_10g_rx_pcs_frmsync_flag_type  		(hssi_10g_rx_pcs_frmsync_flag_type ),
           .hssi_10g_rx_pcs_frmsync_knum_sync  		(hssi_10g_rx_pcs_frmsync_knum_sync ),
           .hssi_10g_rx_pcs_frmsync_mfrm_length  		(hssi_10g_rx_pcs_frmsync_mfrm_length ),
           .hssi_10g_rx_pcs_frmsync_pipeln  		(hssi_10g_rx_pcs_frmsync_pipeln ),
           .hssi_10g_rx_pcs_full_flag_type  		(hssi_10g_rx_pcs_full_flag_type ),
           .hssi_10g_rx_pcs_gb_rx_idwidth   		(hssi_10g_rx_pcs_gb_rx_idwidth  ),
           .hssi_10g_rx_pcs_gb_rx_odwidth   		(hssi_10g_rx_pcs_gb_rx_odwidth  ),
           .hssi_10g_rx_pcs_gbexp_clken     		(hssi_10g_rx_pcs_gbexp_clken    ),
           .hssi_10g_rx_pcs_low_latency_en  		(hssi_10g_rx_pcs_low_latency_en ),
           .hssi_10g_rx_pcs_lpbk_mode       		(hssi_10g_rx_pcs_lpbk_mode      ),
           .hssi_10g_rx_pcs_master_clk_sel  		(hssi_10g_rx_pcs_master_clk_sel ),
           .hssi_10g_rx_pcs_pempty_flag_type  		(hssi_10g_rx_pcs_pempty_flag_type ),
           .hssi_10g_rx_pcs_pfull_flag_type  		(hssi_10g_rx_pcs_pfull_flag_type ),
           .hssi_10g_rx_pcs_phcomp_rd_del   		(hssi_10g_rx_pcs_phcomp_rd_del  ),
           .hssi_10g_rx_pcs_pld_if_type     		(hssi_10g_rx_pcs_pld_if_type    ),
           .hssi_10g_rx_pcs_prot_mode       		(hssi_10g_rx_pcs_prot_mode      ),
           .hssi_10g_rx_pcs_rand_clken      		(hssi_10g_rx_pcs_rand_clken     ),
           .hssi_10g_rx_pcs_rd_clk_sel      		(hssi_10g_rx_pcs_rd_clk_sel     ),
           .hssi_10g_rx_pcs_rdfifo_clken    		(hssi_10g_rx_pcs_rdfifo_clken   ),
           .hssi_10g_rx_pcs_reconfig_settings  		(hssi_10g_rx_pcs_reconfig_settings ),
           .hssi_10g_rx_pcs_rx_fifo_write_ctrl  		(hssi_10g_rx_pcs_rx_fifo_write_ctrl ),
           .hssi_10g_rx_pcs_rx_scrm_width   		(hssi_10g_rx_pcs_rx_scrm_width  ),
           .hssi_10g_rx_pcs_rx_sh_location  		(hssi_10g_rx_pcs_rx_sh_location ),
           .hssi_10g_rx_pcs_rx_signal_ok_sel  		(hssi_10g_rx_pcs_rx_signal_ok_sel ),
           .hssi_10g_rx_pcs_rx_sm_bypass    		(hssi_10g_rx_pcs_rx_sm_bypass   ),
           .hssi_10g_rx_pcs_rx_sm_hiber     		(hssi_10g_rx_pcs_rx_sm_hiber    ),
           .hssi_10g_rx_pcs_rx_sm_pipeln    		(hssi_10g_rx_pcs_rx_sm_pipeln   ),
           .hssi_10g_rx_pcs_rx_testbus_sel  		(hssi_10g_rx_pcs_rx_testbus_sel ),
           .hssi_10g_rx_pcs_rx_true_b2b     		(hssi_10g_rx_pcs_rx_true_b2b    ),
           .hssi_10g_rx_pcs_rxfifo_empty    		(hssi_10g_rx_pcs_rxfifo_empty   ),
           .hssi_10g_rx_pcs_rxfifo_full     		(hssi_10g_rx_pcs_rxfifo_full    ),
           .hssi_10g_rx_pcs_rxfifo_mode     		(hssi_10g_rx_pcs_rxfifo_mode    ),
           .hssi_10g_rx_pcs_rxfifo_pempty   		(hssi_10g_rx_pcs_rxfifo_pempty  ),
           .hssi_10g_rx_pcs_rxfifo_pfull    		(hssi_10g_rx_pcs_rxfifo_pfull   ),
           .hssi_10g_rx_pcs_stretch_num_stages  		(hssi_10g_rx_pcs_stretch_num_stages ),
           .hssi_10g_rx_pcs_sup_mode        		(hssi_10g_rx_pcs_sup_mode       ),
           .hssi_10g_rx_pcs_test_mode       		(hssi_10g_rx_pcs_test_mode      ),
           .hssi_10g_rx_pcs_wrfifo_clken    		(hssi_10g_rx_pcs_wrfifo_clken   ),
           .hssi_10g_tx_pcs_advanced_user_mode  		(hssi_10g_tx_pcs_advanced_user_mode ),
           .hssi_10g_tx_pcs_bitslip_en      		(hssi_10g_tx_pcs_bitslip_en     ),
           .hssi_10g_tx_pcs_bonding_dft_en  		(hssi_10g_tx_pcs_bonding_dft_en ),
           .hssi_10g_tx_pcs_bonding_dft_val  		(hssi_10g_tx_pcs_bonding_dft_val ),
           .hssi_10g_tx_pcs_comp_cnt        		(hssi_10g_tx_pcs_comp_cnt       ),
           .hssi_10g_tx_pcs_compin_sel      		(hssi_10g_tx_pcs_compin_sel     ),
           .hssi_10g_tx_pcs_crcgen_bypass   		(hssi_10g_tx_pcs_crcgen_bypass  ),
           .hssi_10g_tx_pcs_crcgen_clken    		(hssi_10g_tx_pcs_crcgen_clken   ),
           .hssi_10g_tx_pcs_crcgen_err      		(hssi_10g_tx_pcs_crcgen_err     ),
           .hssi_10g_tx_pcs_crcgen_inv      		(hssi_10g_tx_pcs_crcgen_inv     ),
           .hssi_10g_tx_pcs_ctrl_bit_reverse  		(hssi_10g_tx_pcs_ctrl_bit_reverse ),
           .hssi_10g_tx_pcs_ctrl_plane_bonding  		(hssi_10g_tx_pcs_ctrl_plane_bonding ),
           .hssi_10g_tx_pcs_data_bit_reverse  		(hssi_10g_tx_pcs_data_bit_reverse ),
           .hssi_10g_tx_pcs_dft_clk_out_sel  		(hssi_10g_tx_pcs_dft_clk_out_sel ),
           .hssi_10g_tx_pcs_dispgen_bypass  		(hssi_10g_tx_pcs_dispgen_bypass ),
           .hssi_10g_tx_pcs_dispgen_clken   		(hssi_10g_tx_pcs_dispgen_clken  ),
           .hssi_10g_tx_pcs_dispgen_err     		(hssi_10g_tx_pcs_dispgen_err    ),
           .hssi_10g_tx_pcs_dispgen_pipeln  		(hssi_10g_tx_pcs_dispgen_pipeln ),
           .hssi_10g_tx_pcs_distdwn_bypass_pipeln  		(hssi_10g_tx_pcs_distdwn_bypass_pipeln ),
           .hssi_10g_tx_pcs_distdwn_master  		(hssi_10g_tx_pcs_distdwn_master ),
           .hssi_10g_tx_pcs_distup_bypass_pipeln  		(hssi_10g_tx_pcs_distup_bypass_pipeln ),
           .hssi_10g_tx_pcs_distup_master   		(hssi_10g_tx_pcs_distup_master  ),
           .hssi_10g_tx_pcs_dv_bond         		(hssi_10g_tx_pcs_dv_bond        ),
           .hssi_10g_tx_pcs_empty_flag_type  		(hssi_10g_tx_pcs_empty_flag_type ),
           .hssi_10g_tx_pcs_enc64b66b_txsm_clken  		(hssi_10g_tx_pcs_enc64b66b_txsm_clken ),
           .hssi_10g_tx_pcs_enc_64b66b_txsm_bypass  		(hssi_10g_tx_pcs_enc_64b66b_txsm_bypass ),
           .hssi_10g_tx_pcs_fastpath        		(hssi_10g_tx_pcs_fastpath       ),
           .hssi_10g_tx_pcs_fec_clken       		(hssi_10g_tx_pcs_fec_clken      ),
           .hssi_10g_tx_pcs_fec_enable      		(hssi_10g_tx_pcs_fec_enable     ),
           .hssi_10g_tx_pcs_fifo_double_write  		(hssi_10g_tx_pcs_fifo_double_write ),
           .hssi_10g_tx_pcs_fifo_reg_fast   		(hssi_10g_tx_pcs_fifo_reg_fast  ),
           .hssi_10g_tx_pcs_fifo_stop_rd    		(hssi_10g_tx_pcs_fifo_stop_rd   ),
           .hssi_10g_tx_pcs_fifo_stop_wr    		(hssi_10g_tx_pcs_fifo_stop_wr   ),
           .hssi_10g_tx_pcs_frmgen_burst    		(hssi_10g_tx_pcs_frmgen_burst   ),
           .hssi_10g_tx_pcs_frmgen_bypass   		(hssi_10g_tx_pcs_frmgen_bypass  ),
           .hssi_10g_tx_pcs_frmgen_clken    		(hssi_10g_tx_pcs_frmgen_clken   ),
           .hssi_10g_tx_pcs_frmgen_mfrm_length  		(hssi_10g_tx_pcs_frmgen_mfrm_length ),
           .hssi_10g_tx_pcs_frmgen_pipeln   		(hssi_10g_tx_pcs_frmgen_pipeln  ),
           .hssi_10g_tx_pcs_frmgen_pyld_ins  		(hssi_10g_tx_pcs_frmgen_pyld_ins ),
           .hssi_10g_tx_pcs_frmgen_wordslip  		(hssi_10g_tx_pcs_frmgen_wordslip ),
           .hssi_10g_tx_pcs_full_flag_type  		(hssi_10g_tx_pcs_full_flag_type ),
           .hssi_10g_tx_pcs_gb_pipeln_bypass  		(hssi_10g_tx_pcs_gb_pipeln_bypass ),
           .hssi_10g_tx_pcs_gb_tx_idwidth   		(hssi_10g_tx_pcs_gb_tx_idwidth  ),
           .hssi_10g_tx_pcs_gb_tx_odwidth   		(hssi_10g_tx_pcs_gb_tx_odwidth  ),
           .hssi_10g_tx_pcs_gbred_clken     		(hssi_10g_tx_pcs_gbred_clken    ),
           .hssi_10g_tx_pcs_indv            		(hssi_10g_tx_pcs_indv           ),
           .hssi_10g_tx_pcs_low_latency_en  		(hssi_10g_tx_pcs_low_latency_en ),
           .hssi_10g_tx_pcs_master_clk_sel  		(hssi_10g_tx_pcs_master_clk_sel ),
           .hssi_10g_tx_pcs_pempty_flag_type  		(hssi_10g_tx_pcs_pempty_flag_type ),
           .hssi_10g_tx_pcs_pfull_flag_type  		(hssi_10g_tx_pcs_pfull_flag_type ),
           .hssi_10g_tx_pcs_phcomp_rd_del   		(hssi_10g_tx_pcs_phcomp_rd_del  ),
           .hssi_10g_tx_pcs_pld_if_type     		(hssi_10g_tx_pcs_pld_if_type    ),
           .hssi_10g_tx_pcs_prot_mode       		(hssi_10g_tx_pcs_prot_mode      ),
           .hssi_10g_tx_pcs_pseudo_random   		(hssi_10g_tx_pcs_pseudo_random  ),
           .hssi_10g_tx_pcs_pseudo_seed_a   		(hssi_10g_tx_pcs_pseudo_seed_a  ),
           .hssi_10g_tx_pcs_pseudo_seed_b   		(hssi_10g_tx_pcs_pseudo_seed_b  ),
           .hssi_10g_tx_pcs_random_disp     		(hssi_10g_tx_pcs_random_disp    ),
           .hssi_10g_tx_pcs_rdfifo_clken    		(hssi_10g_tx_pcs_rdfifo_clken   ),
           .hssi_10g_tx_pcs_reconfig_settings  		(hssi_10g_tx_pcs_reconfig_settings ),
           .hssi_10g_tx_pcs_scrm_bypass     		(hssi_10g_tx_pcs_scrm_bypass    ),
           .hssi_10g_tx_pcs_scrm_clken      		(hssi_10g_tx_pcs_scrm_clken     ),
           .hssi_10g_tx_pcs_scrm_mode       		(hssi_10g_tx_pcs_scrm_mode      ),
           .hssi_10g_tx_pcs_scrm_pipeln     		(hssi_10g_tx_pcs_scrm_pipeln    ),
           .hssi_10g_tx_pcs_sh_err          		(hssi_10g_tx_pcs_sh_err         ),
           .hssi_10g_tx_pcs_sop_mark        		(hssi_10g_tx_pcs_sop_mark       ),
           .hssi_10g_tx_pcs_stretch_num_stages  		(hssi_10g_tx_pcs_stretch_num_stages ),
           .hssi_10g_tx_pcs_sup_mode        		(hssi_10g_tx_pcs_sup_mode       ),
           .hssi_10g_tx_pcs_test_mode       		(hssi_10g_tx_pcs_test_mode      ),
           .hssi_10g_tx_pcs_tx_scrm_err     		(hssi_10g_tx_pcs_tx_scrm_err    ),
           .hssi_10g_tx_pcs_tx_scrm_width   		(hssi_10g_tx_pcs_tx_scrm_width  ),
           .hssi_10g_tx_pcs_tx_sh_location  		(hssi_10g_tx_pcs_tx_sh_location ),
           .hssi_10g_tx_pcs_tx_sm_bypass    		(hssi_10g_tx_pcs_tx_sm_bypass   ),
           .hssi_10g_tx_pcs_tx_sm_pipeln    		(hssi_10g_tx_pcs_tx_sm_pipeln   ),
           .hssi_10g_tx_pcs_tx_testbus_sel  		(hssi_10g_tx_pcs_tx_testbus_sel ),
           .hssi_10g_tx_pcs_txfifo_empty    		(hssi_10g_tx_pcs_txfifo_empty   ),
           .hssi_10g_tx_pcs_txfifo_full     		(hssi_10g_tx_pcs_txfifo_full    ),
           .hssi_10g_tx_pcs_txfifo_mode     		(hssi_10g_tx_pcs_txfifo_mode    ),
           .hssi_10g_tx_pcs_txfifo_pempty   		(hssi_10g_tx_pcs_txfifo_pempty  ),
           .hssi_10g_tx_pcs_txfifo_pfull    		(hssi_10g_tx_pcs_txfifo_pfull   ),
           .hssi_10g_tx_pcs_wr_clk_sel      		(hssi_10g_tx_pcs_wr_clk_sel     ),
           .hssi_10g_tx_pcs_wrfifo_clken    		(hssi_10g_tx_pcs_wrfifo_clken   ),
           .hssi_8g_rx_pcs_auto_error_replacement  		(hssi_8g_rx_pcs_auto_error_replacement ),
           .hssi_8g_rx_pcs_auto_speed_nego  		(hssi_8g_rx_pcs_auto_speed_nego ),
           .hssi_8g_rx_pcs_bit_reversal     		(hssi_8g_rx_pcs_bit_reversal    ),
           .hssi_8g_rx_pcs_bonding_dft_en   		(hssi_8g_rx_pcs_bonding_dft_en  ),
           .hssi_8g_rx_pcs_bonding_dft_val  		(hssi_8g_rx_pcs_bonding_dft_val ),
           .hssi_8g_rx_pcs_bypass_pipeline_reg  		(hssi_8g_rx_pcs_bypass_pipeline_reg ),
           .hssi_8g_rx_pcs_byte_deserializer  		(hssi_8g_rx_pcs_byte_deserializer ),
           .hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask  		(hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask ),
           .hssi_8g_rx_pcs_clkcmp_pattern_n  		(hssi_8g_rx_pcs_clkcmp_pattern_n ),
           .hssi_8g_rx_pcs_clkcmp_pattern_p  		(hssi_8g_rx_pcs_clkcmp_pattern_p ),
           .hssi_8g_rx_pcs_clock_gate_bds_dec_asn  		(hssi_8g_rx_pcs_clock_gate_bds_dec_asn ),
           .hssi_8g_rx_pcs_clock_gate_cdr_eidle  		(hssi_8g_rx_pcs_clock_gate_cdr_eidle ),
           .hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_dw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_dw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_dw_wa  		(hssi_8g_rx_pcs_clock_gate_dw_wa ),
           .hssi_8g_rx_pcs_clock_gate_pc_rdclk  		(hssi_8g_rx_pcs_clock_gate_pc_rdclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_sw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_sw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_sw_wa  		(hssi_8g_rx_pcs_clock_gate_sw_wa ),
           .hssi_8g_rx_pcs_clock_observation_in_pld_core  		(hssi_8g_rx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_rx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_rx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_rx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_rx_pcs_eidle_entry_eios  		(hssi_8g_rx_pcs_eidle_entry_eios ),
           .hssi_8g_rx_pcs_eidle_entry_iei  		(hssi_8g_rx_pcs_eidle_entry_iei ),
           .hssi_8g_rx_pcs_eidle_entry_sd   		(hssi_8g_rx_pcs_eidle_entry_sd  ),
           .hssi_8g_rx_pcs_eightb_tenb_decoder  		(hssi_8g_rx_pcs_eightb_tenb_decoder ),
           .hssi_8g_rx_pcs_err_flags_sel    		(hssi_8g_rx_pcs_err_flags_sel   ),
           .hssi_8g_rx_pcs_fixed_pat_det    		(hssi_8g_rx_pcs_fixed_pat_det   ),
           .hssi_8g_rx_pcs_fixed_pat_num    		(hssi_8g_rx_pcs_fixed_pat_num   ),
           .hssi_8g_rx_pcs_force_signal_detect  		(hssi_8g_rx_pcs_force_signal_detect ),
           .hssi_8g_rx_pcs_gen3_clk_en      		(hssi_8g_rx_pcs_gen3_clk_en     ),
           .hssi_8g_rx_pcs_gen3_rx_clk_sel  		(hssi_8g_rx_pcs_gen3_rx_clk_sel ),
           .hssi_8g_rx_pcs_gen3_tx_clk_sel  		(hssi_8g_rx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_rx_pcs_hip_mode         		(hssi_8g_rx_pcs_hip_mode        ),
           .hssi_8g_rx_pcs_ibm_invalid_code  		(hssi_8g_rx_pcs_ibm_invalid_code ),
           .hssi_8g_rx_pcs_invalid_code_flag_only  		(hssi_8g_rx_pcs_invalid_code_flag_only ),
           .hssi_8g_rx_pcs_pad_or_edb_error_replace  		(hssi_8g_rx_pcs_pad_or_edb_error_replace ),
           .hssi_8g_rx_pcs_pcs_bypass       		(hssi_8g_rx_pcs_pcs_bypass      ),
           .hssi_8g_rx_pcs_phase_comp_rdptr  		(hssi_8g_rx_pcs_phase_comp_rdptr ),
           .hssi_8g_rx_pcs_phase_compensation_fifo  		(hssi_8g_rx_pcs_phase_compensation_fifo ),
           .hssi_8g_rx_pcs_pipe_if_enable   		(hssi_8g_rx_pcs_pipe_if_enable  ),
           .hssi_8g_rx_pcs_pma_dw           		(hssi_8g_rx_pcs_pma_dw          ),
           .hssi_8g_rx_pcs_polinv_8b10b_dec  		(hssi_8g_rx_pcs_polinv_8b10b_dec ),
           .hssi_8g_rx_pcs_prot_mode        		(hssi_8g_rx_pcs_prot_mode       ),
           .hssi_8g_rx_pcs_rate_match       		(hssi_8g_rx_pcs_rate_match      ),
           .hssi_8g_rx_pcs_rate_match_del_thres  		(hssi_8g_rx_pcs_rate_match_del_thres ),
           .hssi_8g_rx_pcs_rate_match_empty_thres  		(hssi_8g_rx_pcs_rate_match_empty_thres ),
           .hssi_8g_rx_pcs_rate_match_full_thres  		(hssi_8g_rx_pcs_rate_match_full_thres ),
           .hssi_8g_rx_pcs_rate_match_ins_thres  		(hssi_8g_rx_pcs_rate_match_ins_thres ),
           .hssi_8g_rx_pcs_rate_match_start_thres  		(hssi_8g_rx_pcs_rate_match_start_thres ),
           .hssi_8g_rx_pcs_reconfig_settings  		(hssi_8g_rx_pcs_reconfig_settings ),
           .hssi_8g_rx_pcs_rx_clk2          		(hssi_8g_rx_pcs_rx_clk2         ),
           .hssi_8g_rx_pcs_rx_clk_free_running  		(hssi_8g_rx_pcs_rx_clk_free_running ),
           .hssi_8g_rx_pcs_rx_pcs_urst      		(hssi_8g_rx_pcs_rx_pcs_urst     ),
           .hssi_8g_rx_pcs_rx_rcvd_clk      		(hssi_8g_rx_pcs_rx_rcvd_clk     ),
           .hssi_8g_rx_pcs_rx_rd_clk        		(hssi_8g_rx_pcs_rx_rd_clk       ),
           .hssi_8g_rx_pcs_rx_refclk        		(hssi_8g_rx_pcs_rx_refclk       ),
           .hssi_8g_rx_pcs_rx_wr_clk        		(hssi_8g_rx_pcs_rx_wr_clk       ),
           .hssi_8g_rx_pcs_sup_mode         		(hssi_8g_rx_pcs_sup_mode        ),
           .hssi_8g_rx_pcs_symbol_swap      		(hssi_8g_rx_pcs_symbol_swap     ),
           .hssi_8g_rx_pcs_sync_sm_idle_eios  		(hssi_8g_rx_pcs_sync_sm_idle_eios ),
           .hssi_8g_rx_pcs_test_bus_sel     		(hssi_8g_rx_pcs_test_bus_sel    ),
           .hssi_8g_rx_pcs_tx_rx_parallel_loopback  		(hssi_8g_rx_pcs_tx_rx_parallel_loopback ),
           .hssi_8g_rx_pcs_wa_boundary_lock_ctrl  		(hssi_8g_rx_pcs_wa_boundary_lock_ctrl ),
           .hssi_8g_rx_pcs_wa_clk_slip_spacing  		(hssi_8g_rx_pcs_wa_clk_slip_spacing ),
           .hssi_8g_rx_pcs_wa_det_latency_sync_status_beh  		(hssi_8g_rx_pcs_wa_det_latency_sync_status_beh ),
           .hssi_8g_rx_pcs_wa_disp_err_flag  		(hssi_8g_rx_pcs_wa_disp_err_flag ),
           .hssi_8g_rx_pcs_wa_kchar         		(hssi_8g_rx_pcs_wa_kchar        ),
           .hssi_8g_rx_pcs_wa_pd            		(hssi_8g_rx_pcs_wa_pd           ),
           .hssi_8g_rx_pcs_wa_pd_data       		(hssi_8g_rx_pcs_wa_pd_data      ),
           .hssi_8g_rx_pcs_wa_pd_polarity   		(hssi_8g_rx_pcs_wa_pd_polarity  ),
           .hssi_8g_rx_pcs_wa_pld_controlled  		(hssi_8g_rx_pcs_wa_pld_controlled ),
           .hssi_8g_rx_pcs_wa_renumber_data  		(hssi_8g_rx_pcs_wa_renumber_data ),
           .hssi_8g_rx_pcs_wa_rgnumber_data  		(hssi_8g_rx_pcs_wa_rgnumber_data ),
           .hssi_8g_rx_pcs_wa_rknumber_data  		(hssi_8g_rx_pcs_wa_rknumber_data ),
           .hssi_8g_rx_pcs_wa_rosnumber_data  		(hssi_8g_rx_pcs_wa_rosnumber_data ),
           .hssi_8g_rx_pcs_wa_rvnumber_data  		(hssi_8g_rx_pcs_wa_rvnumber_data ),
           .hssi_8g_rx_pcs_wa_sync_sm_ctrl  		(hssi_8g_rx_pcs_wa_sync_sm_ctrl ),
           .hssi_8g_rx_pcs_wait_cnt         		(hssi_8g_rx_pcs_wait_cnt        ),
           .hssi_8g_tx_pcs_auto_speed_nego_gen2  		(hssi_8g_tx_pcs_auto_speed_nego_gen2 ),
           .hssi_8g_tx_pcs_bit_reversal     		(hssi_8g_tx_pcs_bit_reversal    ),
           .hssi_8g_tx_pcs_bonding_dft_en   		(hssi_8g_tx_pcs_bonding_dft_en  ),
           .hssi_8g_tx_pcs_bonding_dft_val  		(hssi_8g_tx_pcs_bonding_dft_val ),
           .hssi_8g_tx_pcs_bypass_pipeline_reg  		(hssi_8g_tx_pcs_bypass_pipeline_reg ),
           .hssi_8g_tx_pcs_byte_serializer  		(hssi_8g_tx_pcs_byte_serializer ),
           .hssi_8g_tx_pcs_clock_gate_bs_enc  		(hssi_8g_tx_pcs_clock_gate_bs_enc ),
           .hssi_8g_tx_pcs_clock_gate_dw_fifowr  		(hssi_8g_tx_pcs_clock_gate_dw_fifowr ),
           .hssi_8g_tx_pcs_clock_gate_fiford  		(hssi_8g_tx_pcs_clock_gate_fiford ),
           .hssi_8g_tx_pcs_clock_gate_sw_fifowr  		(hssi_8g_tx_pcs_clock_gate_sw_fifowr ),
           .hssi_8g_tx_pcs_clock_observation_in_pld_core  		(hssi_8g_tx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_tx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_tx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_tx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_tx_pcs_data_selection_8b10b_encoder_input  		(hssi_8g_tx_pcs_data_selection_8b10b_encoder_input ),
           .hssi_8g_tx_pcs_dynamic_clk_switch  		(hssi_8g_tx_pcs_dynamic_clk_switch ),
           .hssi_8g_tx_pcs_eightb_tenb_disp_ctrl  		(hssi_8g_tx_pcs_eightb_tenb_disp_ctrl ),
           .hssi_8g_tx_pcs_eightb_tenb_encoder  		(hssi_8g_tx_pcs_eightb_tenb_encoder ),
           .hssi_8g_tx_pcs_force_echar      		(hssi_8g_tx_pcs_force_echar     ),
           .hssi_8g_tx_pcs_force_kchar      		(hssi_8g_tx_pcs_force_kchar     ),
           .hssi_8g_tx_pcs_gen3_tx_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel ),
           .hssi_8g_tx_pcs_hip_mode         		(hssi_8g_tx_pcs_hip_mode        ),
           .hssi_8g_tx_pcs_pcs_bypass       		(hssi_8g_tx_pcs_pcs_bypass      ),
           .hssi_8g_tx_pcs_phase_comp_rdptr  		(hssi_8g_tx_pcs_phase_comp_rdptr ),
           .hssi_8g_tx_pcs_phase_compensation_fifo  		(hssi_8g_tx_pcs_phase_compensation_fifo ),
           .hssi_8g_tx_pcs_phfifo_write_clk_sel  		(hssi_8g_tx_pcs_phfifo_write_clk_sel ),
           .hssi_8g_tx_pcs_pma_dw           		(hssi_8g_tx_pcs_pma_dw          ),
           .hssi_8g_tx_pcs_prot_mode        		(hssi_8g_tx_pcs_prot_mode       ),
           .hssi_8g_tx_pcs_reconfig_settings  		(hssi_8g_tx_pcs_reconfig_settings ),
           .hssi_8g_tx_pcs_refclk_b_clk_sel  		(hssi_8g_tx_pcs_refclk_b_clk_sel ),
           .hssi_8g_tx_pcs_revloop_back_rm  		(hssi_8g_tx_pcs_revloop_back_rm ),
           .hssi_8g_tx_pcs_sup_mode         		(hssi_8g_tx_pcs_sup_mode        ),
           .hssi_8g_tx_pcs_symbol_swap      		(hssi_8g_tx_pcs_symbol_swap     ),
           .hssi_8g_tx_pcs_tx_bitslip       		(hssi_8g_tx_pcs_tx_bitslip      ),
           .hssi_8g_tx_pcs_tx_compliance_controlled_disparity  		(hssi_8g_tx_pcs_tx_compliance_controlled_disparity ),
           .hssi_8g_tx_pcs_tx_fast_pld_reg  		(hssi_8g_tx_pcs_tx_fast_pld_reg ),
           .hssi_8g_tx_pcs_txclk_freerun    		(hssi_8g_tx_pcs_txclk_freerun   ),
           .hssi_8g_tx_pcs_txpcs_urst       		(hssi_8g_tx_pcs_txpcs_urst      ),
           .hssi_common_pcs_pma_interface_asn_clk_enable  		(hssi_common_pcs_pma_interface_asn_clk_enable ),
           .hssi_common_pcs_pma_interface_asn_enable  		(hssi_common_pcs_pma_interface_asn_enable ),
           .hssi_common_pcs_pma_interface_block_sel  		(hssi_common_pcs_pma_interface_block_sel ),
           .hssi_common_pcs_pma_interface_bypass_early_eios  		(hssi_common_pcs_pma_interface_bypass_early_eios ),
           .hssi_common_pcs_pma_interface_bypass_pcie_switch  		(hssi_common_pcs_pma_interface_bypass_pcie_switch ),
           .hssi_common_pcs_pma_interface_bypass_pma_ltr  		(hssi_common_pcs_pma_interface_bypass_pma_ltr ),
           .hssi_common_pcs_pma_interface_bypass_pma_sw_done  		(hssi_common_pcs_pma_interface_bypass_pma_sw_done ),
           .hssi_common_pcs_pma_interface_bypass_ppm_lock  		(hssi_common_pcs_pma_interface_bypass_ppm_lock ),
           .hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp ),
           .hssi_common_pcs_pma_interface_bypass_txdetectrx  		(hssi_common_pcs_pma_interface_bypass_txdetectrx ),
           .hssi_common_pcs_pma_interface_cdr_control  		(hssi_common_pcs_pma_interface_cdr_control ),
           .hssi_common_pcs_pma_interface_cid_enable  		(hssi_common_pcs_pma_interface_cid_enable ),
           .hssi_common_pcs_pma_interface_cp_cons_sel  		(hssi_common_pcs_pma_interface_cp_cons_sel ),
           .hssi_common_pcs_pma_interface_cp_dwn_mstr  		(hssi_common_pcs_pma_interface_cp_dwn_mstr ),
           .hssi_common_pcs_pma_interface_cp_up_mstr  		(hssi_common_pcs_pma_interface_cp_up_mstr ),
           .hssi_common_pcs_pma_interface_ctrl_plane_bonding  		(hssi_common_pcs_pma_interface_ctrl_plane_bonding ),
           .hssi_common_pcs_pma_interface_data_mask_count  		(hssi_common_pcs_pma_interface_data_mask_count ),
           .hssi_common_pcs_pma_interface_data_mask_count_multi  		(hssi_common_pcs_pma_interface_data_mask_count_multi ),
           .hssi_common_pcs_pma_interface_dft_observation_clock_selection  		(hssi_common_pcs_pma_interface_dft_observation_clock_selection ),
           .hssi_common_pcs_pma_interface_early_eios_counter  		(hssi_common_pcs_pma_interface_early_eios_counter ),
           .hssi_common_pcs_pma_interface_force_freqdet  		(hssi_common_pcs_pma_interface_force_freqdet ),
           .hssi_common_pcs_pma_interface_free_run_clk_enable  		(hssi_common_pcs_pma_interface_free_run_clk_enable ),
           .hssi_common_pcs_pma_interface_ignore_sigdet_g23  		(hssi_common_pcs_pma_interface_ignore_sigdet_g23 ),
           .hssi_common_pcs_pma_interface_pc_en_counter  		(hssi_common_pcs_pma_interface_pc_en_counter ),
           .hssi_common_pcs_pma_interface_pc_rst_counter  		(hssi_common_pcs_pma_interface_pc_rst_counter ),
           .hssi_common_pcs_pma_interface_pcie_hip_mode  		(hssi_common_pcs_pma_interface_pcie_hip_mode ),
           .hssi_common_pcs_pma_interface_ph_fifo_reg_mode  		(hssi_common_pcs_pma_interface_ph_fifo_reg_mode ),
           .hssi_common_pcs_pma_interface_phfifo_flush_wait  		(hssi_common_pcs_pma_interface_phfifo_flush_wait ),
           .hssi_common_pcs_pma_interface_pipe_if_g3pcs  		(hssi_common_pcs_pma_interface_pipe_if_g3pcs ),
           .hssi_common_pcs_pma_interface_pma_done_counter  		(hssi_common_pcs_pma_interface_pma_done_counter ),
           .hssi_common_pcs_pma_interface_pma_if_dft_en  		(hssi_common_pcs_pma_interface_pma_if_dft_en ),
           .hssi_common_pcs_pma_interface_pma_if_dft_val  		(hssi_common_pcs_pma_interface_pma_if_dft_val ),
           .hssi_common_pcs_pma_interface_ppm_cnt_rst  		(hssi_common_pcs_pma_interface_ppm_cnt_rst ),
           .hssi_common_pcs_pma_interface_ppm_deassert_early  		(hssi_common_pcs_pma_interface_ppm_deassert_early ),
           .hssi_common_pcs_pma_interface_ppm_det_buckets  		(hssi_common_pcs_pma_interface_ppm_det_buckets ),
           .hssi_common_pcs_pma_interface_ppm_gen1_2_cnt  		(hssi_common_pcs_pma_interface_ppm_gen1_2_cnt ),
           .hssi_common_pcs_pma_interface_ppm_post_eidle_delay  		(hssi_common_pcs_pma_interface_ppm_post_eidle_delay ),
           .hssi_common_pcs_pma_interface_ppmsel  		(hssi_common_pcs_pma_interface_ppmsel ),
           .hssi_common_pcs_pma_interface_prot_mode  		(hssi_common_pcs_pma_interface_prot_mode ),
           .hssi_common_pcs_pma_interface_reconfig_settings  		(hssi_common_pcs_pma_interface_reconfig_settings ),
           .hssi_common_pcs_pma_interface_rxvalid_mask  		(hssi_common_pcs_pma_interface_rxvalid_mask ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter  		(hssi_common_pcs_pma_interface_sigdet_wait_counter ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter_multi  		(hssi_common_pcs_pma_interface_sigdet_wait_counter_multi ),
           .hssi_common_pcs_pma_interface_sim_mode  		(hssi_common_pcs_pma_interface_sim_mode ),
           .hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en  		(hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en ),
           .hssi_common_pcs_pma_interface_sup_mode  		(hssi_common_pcs_pma_interface_sup_mode ),
           .hssi_common_pcs_pma_interface_testout_sel  		(hssi_common_pcs_pma_interface_testout_sel ),
           .hssi_common_pcs_pma_interface_wait_clk_on_off_timer  		(hssi_common_pcs_pma_interface_wait_clk_on_off_timer ),
           .hssi_common_pcs_pma_interface_wait_pipe_synchronizing  		(hssi_common_pcs_pma_interface_wait_pipe_synchronizing ),
           .hssi_common_pcs_pma_interface_wait_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_wait_send_syncp_fbkp ),
           .hssi_common_pld_pcs_interface_dft_clk_out_en  		(hssi_common_pld_pcs_interface_dft_clk_out_en ),
           .hssi_common_pld_pcs_interface_dft_clk_out_sel  		(hssi_common_pld_pcs_interface_dft_clk_out_sel ),
           .hssi_common_pld_pcs_interface_hrdrstctrl_en  		(hssi_common_pld_pcs_interface_hrdrstctrl_en ),
           .hssi_common_pld_pcs_interface_pcs_testbus_block_sel  		(hssi_common_pld_pcs_interface_pcs_testbus_block_sel ),
           .hssi_common_pld_pcs_interface_reconfig_settings  		(hssi_common_pld_pcs_interface_reconfig_settings ),
           .hssi_fifo_rx_pcs_double_read_mode  		(hssi_fifo_rx_pcs_double_read_mode ),
           .hssi_fifo_rx_pcs_prot_mode      		(hssi_fifo_rx_pcs_prot_mode     ),
           .hssi_fifo_tx_pcs_double_write_mode  		(hssi_fifo_tx_pcs_double_write_mode ),
           .hssi_fifo_tx_pcs_prot_mode      		(hssi_fifo_tx_pcs_prot_mode     ),
           .hssi_gen3_rx_pcs_block_sync     		(hssi_gen3_rx_pcs_block_sync    ),
           .hssi_gen3_rx_pcs_block_sync_sm  		(hssi_gen3_rx_pcs_block_sync_sm ),
           .hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn  		(hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn ),
           .hssi_gen3_rx_pcs_lpbk_force     		(hssi_gen3_rx_pcs_lpbk_force    ),
           .hssi_gen3_rx_pcs_mode           		(hssi_gen3_rx_pcs_mode          ),
           .hssi_gen3_rx_pcs_rate_match_fifo  		(hssi_gen3_rx_pcs_rate_match_fifo ),
           .hssi_gen3_rx_pcs_rate_match_fifo_latency  		(hssi_gen3_rx_pcs_rate_match_fifo_latency ),
           .hssi_gen3_rx_pcs_reconfig_settings  		(hssi_gen3_rx_pcs_reconfig_settings ),
           .hssi_gen3_rx_pcs_reverse_lpbk   		(hssi_gen3_rx_pcs_reverse_lpbk  ),
           .hssi_gen3_rx_pcs_rx_b4gb_par_lpbk  		(hssi_gen3_rx_pcs_rx_b4gb_par_lpbk ),
           .hssi_gen3_rx_pcs_rx_force_balign  		(hssi_gen3_rx_pcs_rx_force_balign ),
           .hssi_gen3_rx_pcs_rx_ins_del_one_skip  		(hssi_gen3_rx_pcs_rx_ins_del_one_skip ),
           .hssi_gen3_rx_pcs_rx_num_fixed_pat  		(hssi_gen3_rx_pcs_rx_num_fixed_pat ),
           .hssi_gen3_rx_pcs_rx_test_out_sel  		(hssi_gen3_rx_pcs_rx_test_out_sel ),
           .hssi_gen3_rx_pcs_sup_mode       		(hssi_gen3_rx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_mode           		(hssi_gen3_tx_pcs_mode          ),
           .hssi_gen3_tx_pcs_reverse_lpbk   		(hssi_gen3_tx_pcs_reverse_lpbk  ),
           .hssi_gen3_tx_pcs_sup_mode       		(hssi_gen3_tx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_tx_bitslip     		(hssi_gen3_tx_pcs_tx_bitslip    ),
           .hssi_gen3_tx_pcs_tx_gbox_byp    		(hssi_gen3_tx_pcs_tx_gbox_byp   ),
           .hssi_krfec_rx_pcs_blksync_cor_en  		(hssi_krfec_rx_pcs_blksync_cor_en ),
           .hssi_krfec_rx_pcs_bypass_gb     		(hssi_krfec_rx_pcs_bypass_gb    ),
           .hssi_krfec_rx_pcs_clr_ctrl      		(hssi_krfec_rx_pcs_clr_ctrl     ),
           .hssi_krfec_rx_pcs_ctrl_bit_reverse  		(hssi_krfec_rx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_rx_pcs_data_bit_reverse  		(hssi_krfec_rx_pcs_data_bit_reverse ),
           .hssi_krfec_rx_pcs_dv_start      		(hssi_krfec_rx_pcs_dv_start     ),
           .hssi_krfec_rx_pcs_err_mark_type  		(hssi_krfec_rx_pcs_err_mark_type ),
           .hssi_krfec_rx_pcs_error_marking_en  		(hssi_krfec_rx_pcs_error_marking_en ),
           .hssi_krfec_rx_pcs_low_latency_en  		(hssi_krfec_rx_pcs_low_latency_en ),
           .hssi_krfec_rx_pcs_lpbk_mode     		(hssi_krfec_rx_pcs_lpbk_mode    ),
           .hssi_krfec_rx_pcs_parity_invalid_enum  		(hssi_krfec_rx_pcs_parity_invalid_enum ),
           .hssi_krfec_rx_pcs_parity_valid_num  		(hssi_krfec_rx_pcs_parity_valid_num ),
           .hssi_krfec_rx_pcs_pipeln_blksync  		(hssi_krfec_rx_pcs_pipeln_blksync ),
           .hssi_krfec_rx_pcs_pipeln_descrm  		(hssi_krfec_rx_pcs_pipeln_descrm ),
           .hssi_krfec_rx_pcs_pipeln_errcorrect  		(hssi_krfec_rx_pcs_pipeln_errcorrect ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_ind  		(hssi_krfec_rx_pcs_pipeln_errtrap_ind ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_lfsr  		(hssi_krfec_rx_pcs_pipeln_errtrap_lfsr ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_loc  		(hssi_krfec_rx_pcs_pipeln_errtrap_loc ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_pat  		(hssi_krfec_rx_pcs_pipeln_errtrap_pat ),
           .hssi_krfec_rx_pcs_pipeln_gearbox  		(hssi_krfec_rx_pcs_pipeln_gearbox ),
           .hssi_krfec_rx_pcs_pipeln_syndrm  		(hssi_krfec_rx_pcs_pipeln_syndrm ),
           .hssi_krfec_rx_pcs_pipeln_trans_dec  		(hssi_krfec_rx_pcs_pipeln_trans_dec ),
           .hssi_krfec_rx_pcs_prot_mode     		(hssi_krfec_rx_pcs_prot_mode    ),
           .hssi_krfec_rx_pcs_receive_order  		(hssi_krfec_rx_pcs_receive_order ),
           .hssi_krfec_rx_pcs_reconfig_settings  		(hssi_krfec_rx_pcs_reconfig_settings ),
           .hssi_krfec_rx_pcs_rx_testbus_sel  		(hssi_krfec_rx_pcs_rx_testbus_sel ),
           .hssi_krfec_rx_pcs_signal_ok_en  		(hssi_krfec_rx_pcs_signal_ok_en ),
           .hssi_krfec_rx_pcs_sup_mode      		(hssi_krfec_rx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_burst_err     		(hssi_krfec_tx_pcs_burst_err    ),
           .hssi_krfec_tx_pcs_burst_err_len  		(hssi_krfec_tx_pcs_burst_err_len ),
           .hssi_krfec_tx_pcs_ctrl_bit_reverse  		(hssi_krfec_tx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_tx_pcs_data_bit_reverse  		(hssi_krfec_tx_pcs_data_bit_reverse ),
           .hssi_krfec_tx_pcs_enc_frame_query  		(hssi_krfec_tx_pcs_enc_frame_query ),
           .hssi_krfec_tx_pcs_low_latency_en  		(hssi_krfec_tx_pcs_low_latency_en ),
           .hssi_krfec_tx_pcs_pipeln_encoder  		(hssi_krfec_tx_pcs_pipeln_encoder ),
           .hssi_krfec_tx_pcs_pipeln_scrambler  		(hssi_krfec_tx_pcs_pipeln_scrambler ),
           .hssi_krfec_tx_pcs_prot_mode     		(hssi_krfec_tx_pcs_prot_mode    ),
           .hssi_krfec_tx_pcs_sup_mode      		(hssi_krfec_tx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_transcode_err  		(hssi_krfec_tx_pcs_transcode_err ),
           .hssi_krfec_tx_pcs_transmit_order  		(hssi_krfec_tx_pcs_transmit_order ),
           .hssi_krfec_tx_pcs_tx_testbus_sel  		(hssi_krfec_tx_pcs_tx_testbus_sel ),
           .hssi_pipe_gen1_2_elec_idle_delay_val  		(hssi_pipe_gen1_2_elec_idle_delay_val ),
           .hssi_pipe_gen1_2_error_replace_pad  		(hssi_pipe_gen1_2_error_replace_pad ),
           .hssi_pipe_gen1_2_hip_mode       		(hssi_pipe_gen1_2_hip_mode      ),
           .hssi_pipe_gen1_2_ind_error_reporting  		(hssi_pipe_gen1_2_ind_error_reporting ),
           .hssi_pipe_gen1_2_phystatus_delay_val  		(hssi_pipe_gen1_2_phystatus_delay_val ),
           .hssi_pipe_gen1_2_phystatus_rst_toggle  		(hssi_pipe_gen1_2_phystatus_rst_toggle ),
           .hssi_pipe_gen1_2_pipe_byte_de_serializer_en  		(hssi_pipe_gen1_2_pipe_byte_de_serializer_en ),
           .hssi_pipe_gen1_2_prot_mode      		(hssi_pipe_gen1_2_prot_mode     ),
           .hssi_pipe_gen1_2_reconfig_settings  		(hssi_pipe_gen1_2_reconfig_settings ),
           .hssi_pipe_gen1_2_rx_pipe_enable  		(hssi_pipe_gen1_2_rx_pipe_enable ),
           .hssi_pipe_gen1_2_rxdetect_bypass  		(hssi_pipe_gen1_2_rxdetect_bypass ),
           .hssi_pipe_gen1_2_sup_mode       		(hssi_pipe_gen1_2_sup_mode      ),
           .hssi_pipe_gen1_2_tx_pipe_enable  		(hssi_pipe_gen1_2_tx_pipe_enable ),
           .hssi_pipe_gen1_2_txswing        		(hssi_pipe_gen1_2_txswing       ),
           .hssi_pipe_gen3_bypass_rx_detection_enable  		(hssi_pipe_gen3_bypass_rx_detection_enable ),
           .hssi_pipe_gen3_bypass_rx_preset  		(hssi_pipe_gen3_bypass_rx_preset ),
           .hssi_pipe_gen3_bypass_rx_preset_enable  		(hssi_pipe_gen3_bypass_rx_preset_enable ),
           .hssi_pipe_gen3_bypass_tx_coefficent  		(hssi_pipe_gen3_bypass_tx_coefficent ),
           .hssi_pipe_gen3_bypass_tx_coefficent_enable  		(hssi_pipe_gen3_bypass_tx_coefficent_enable ),
           .hssi_pipe_gen3_elecidle_delay_g3  		(hssi_pipe_gen3_elecidle_delay_g3 ),
           .hssi_pipe_gen3_ind_error_reporting  		(hssi_pipe_gen3_ind_error_reporting ),
           .hssi_pipe_gen3_mode             		(hssi_pipe_gen3_mode            ),
           .hssi_pipe_gen3_phy_status_delay_g12  		(hssi_pipe_gen3_phy_status_delay_g12 ),
           .hssi_pipe_gen3_phy_status_delay_g3  		(hssi_pipe_gen3_phy_status_delay_g3 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g12  		(hssi_pipe_gen3_phystatus_rst_toggle_g12 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g3  		(hssi_pipe_gen3_phystatus_rst_toggle_g3 ),
           .hssi_pipe_gen3_rate_match_pad_insertion  		(hssi_pipe_gen3_rate_match_pad_insertion ),
           .hssi_pipe_gen3_sup_mode         		(hssi_pipe_gen3_sup_mode        ),
           .hssi_pipe_gen3_test_out_sel     		(hssi_pipe_gen3_test_out_sel    ),
           .hssi_rx_pcs_pma_interface_block_sel  		(hssi_rx_pcs_pma_interface_block_sel ),
           .hssi_rx_pcs_pma_interface_channel_operation_mode  		(hssi_rx_pcs_pma_interface_channel_operation_mode ),
           .hssi_rx_pcs_pma_interface_clkslip_sel  		(hssi_rx_pcs_pma_interface_clkslip_sel ),
           .hssi_rx_pcs_pma_interface_lpbk_en  		(hssi_rx_pcs_pma_interface_lpbk_en ),
           .hssi_rx_pcs_pma_interface_master_clk_sel  		(hssi_rx_pcs_pma_interface_master_clk_sel ),
           .hssi_rx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_rx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_rx_pcs_pma_interface_pma_dw_rx  		(hssi_rx_pcs_pma_interface_pma_dw_rx ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_en  		(hssi_rx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_val  		(hssi_rx_pcs_pma_interface_pma_if_dft_val ),
           .hssi_rx_pcs_pma_interface_prbs9_dwidth  		(hssi_rx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_rx_pcs_pma_interface_prbs_clken  		(hssi_rx_pcs_pma_interface_prbs_clken ),
           .hssi_rx_pcs_pma_interface_prbs_ver  		(hssi_rx_pcs_pma_interface_prbs_ver ),
           .hssi_rx_pcs_pma_interface_prot_mode_rx  		(hssi_rx_pcs_pma_interface_prot_mode_rx ),
           .hssi_rx_pcs_pma_interface_reconfig_settings  		(hssi_rx_pcs_pma_interface_reconfig_settings ),
           .hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_lpbk_en ),
           .hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok  		(hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mask  		(hssi_rx_pcs_pma_interface_rx_prbs_mask ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mode  		(hssi_rx_pcs_pma_interface_rx_prbs_mode ),
           .hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel  		(hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel ),
           .hssi_rx_pcs_pma_interface_rx_static_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_static_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en ),
           .hssi_rx_pcs_pma_interface_sup_mode  		(hssi_rx_pcs_pma_interface_sup_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_rx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_rx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_rx_pld_pcs_interface_pcs_rx_block_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_block_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en  		(hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en ),
           .hssi_rx_pld_pcs_interface_pcs_rx_output_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_output_sel ),
           .hssi_rx_pld_pcs_interface_reconfig_settings  		(hssi_rx_pld_pcs_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_bypass_pma_txelecidle  		(hssi_tx_pcs_pma_interface_bypass_pma_txelecidle ),
           .hssi_tx_pcs_pma_interface_channel_operation_mode  		(hssi_tx_pcs_pma_interface_channel_operation_mode ),
           .hssi_tx_pcs_pma_interface_lpbk_en  		(hssi_tx_pcs_pma_interface_lpbk_en ),
           .hssi_tx_pcs_pma_interface_master_clk_sel  		(hssi_tx_pcs_pma_interface_master_clk_sel ),
           .hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx  		(hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_tx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_tx_pcs_pma_interface_pma_dw_tx  		(hssi_tx_pcs_pma_interface_pma_dw_tx ),
           .hssi_tx_pcs_pma_interface_pma_if_dft_en  		(hssi_tx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_tx_pcs_pma_interface_pmagate_en  		(hssi_tx_pcs_pma_interface_pmagate_en ),
           .hssi_tx_pcs_pma_interface_prbs9_dwidth  		(hssi_tx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_tx_pcs_pma_interface_prbs_clken  		(hssi_tx_pcs_pma_interface_prbs_clken ),
           .hssi_tx_pcs_pma_interface_prbs_gen_pat  		(hssi_tx_pcs_pma_interface_prbs_gen_pat ),
           .hssi_tx_pcs_pma_interface_prot_mode_tx  		(hssi_tx_pcs_pma_interface_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_reconfig_settings  		(hssi_tx_pcs_pma_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_sq_wave_num  		(hssi_tx_pcs_pma_interface_sq_wave_num ),
           .hssi_tx_pcs_pma_interface_sqwgen_clken  		(hssi_tx_pcs_pma_interface_sqwgen_clken ),
           .hssi_tx_pcs_pma_interface_sup_mode  		(hssi_tx_pcs_pma_interface_sup_mode ),
           .hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_tx_pma_data_sel  		(hssi_tx_pcs_pma_interface_tx_pma_data_sel ),
           .hssi_tx_pcs_pma_interface_tx_static_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_static_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period  		(hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable  		(hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control ),
           .hssi_tx_pcs_pma_interface_uhsif_enable  		(hssi_tx_pcs_pma_interface_uhsif_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value ),
           .hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_tx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_tx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding  		(hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_source  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_data_source  		(hssi_tx_pld_pcs_interface_pcs_tx_data_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_output_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_output_sel ),
           .hssi_tx_pld_pcs_interface_reconfig_settings  		(hssi_tx_pld_pcs_interface_reconfig_settings ),
           .avmm_interfaces                 		(avmm_interfaces                ),
           .rcfg_enable                     		(rcfg_enable                    ),
           .enable_avmm                     		(enable_avmm                    ),
           .arbiter_ctrl                    		(arbiter_ctrl                   ),
           .calibration_en                  		(calibration_en                 ),
           .avmm_busy_en                    		(avmm_busy_en                   ),
           .hip_cal_en                      		(hip_cal_en                     ),
           .cal_done                        		(cal_done                       )
                  )
               twentynm_xcvr_native_inst(.*);
             end


  "20nm4":   begin
               twentynm_xcvr_native_rev_20nm4
                 #(
			
           .bonded_lanes                    		(bonded_lanes                   ),
           .bonding_master_ch               		(bonding_master_ch              ),
           .xcvr_native_mode                		(xcvr_native_mode               ),
           .pma_adapt_adapt_mode            		(pma_adapt_adapt_mode           ),
           .pma_adapt_adp_1s_ctle_bypass    		(pma_adapt_adp_1s_ctle_bypass   ),
           .pma_adapt_adp_4s_ctle_bypass    		(pma_adapt_adp_4s_ctle_bypass   ),
           .pma_adapt_adp_ctle_adapt_cycle_window  		(pma_adapt_adp_ctle_adapt_cycle_window ),
           .pma_adapt_adp_ctle_en           		(pma_adapt_adp_ctle_en          ),
           .pma_adapt_adp_dfe_fltap_bypass  		(pma_adapt_adp_dfe_fltap_bypass ),
           .pma_adapt_adp_dfe_fltap_en      		(pma_adapt_adp_dfe_fltap_en     ),
           .pma_adapt_adp_dfe_fxtap_bypass  		(pma_adapt_adp_dfe_fxtap_bypass ),
           .pma_adapt_adp_dfe_fxtap_en      		(pma_adapt_adp_dfe_fxtap_en     ),
           .pma_adapt_adp_dfe_fxtap_hold_en  		(pma_adapt_adp_dfe_fxtap_hold_en ),
           .pma_adapt_adp_dfe_mode          		(pma_adapt_adp_dfe_mode         ),
           .pma_adapt_adp_mode              		(pma_adapt_adp_mode             ),
           .pma_adapt_adp_onetime_dfe       		(pma_adapt_adp_onetime_dfe      ),
           .pma_adapt_adp_vga_bypass        		(pma_adapt_adp_vga_bypass       ),
           .pma_adapt_adp_vga_en            		(pma_adapt_adp_vga_en           ),
           .pma_adapt_adp_vref_bypass       		(pma_adapt_adp_vref_bypass      ),
           .pma_adapt_adp_vref_en           		(pma_adapt_adp_vref_en          ),
           .pma_adapt_datarate              		(pma_adapt_datarate             ),
           .pma_adapt_odi_dfe_spec_en       		(pma_adapt_odi_dfe_spec_en      ),
           .pma_adapt_prot_mode             		(pma_adapt_prot_mode            ),
           .pma_adapt_sup_mode              		(pma_adapt_sup_mode             ),
           .pma_cdr_refclk_inclk0_logical_to_physical_mapping  		(pma_cdr_refclk_inclk0_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk1_logical_to_physical_mapping  		(pma_cdr_refclk_inclk1_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk2_logical_to_physical_mapping  		(pma_cdr_refclk_inclk2_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk3_logical_to_physical_mapping  		(pma_cdr_refclk_inclk3_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk4_logical_to_physical_mapping  		(pma_cdr_refclk_inclk4_logical_to_physical_mapping ),
           .pma_cdr_refclk_powerdown_mode   		(pma_cdr_refclk_powerdown_mode  ),
           .pma_cdr_refclk_refclk_select    		(pma_cdr_refclk_refclk_select   ),
           .cdr_pll_atb_select_control      		(cdr_pll_atb_select_control     ),
           .cdr_pll_auto_reset_on           		(cdr_pll_auto_reset_on          ),
           .cdr_pll_bbpd_data_pattern_filter_select  		(cdr_pll_bbpd_data_pattern_filter_select ),
           .cdr_pll_bw_sel                  		(cdr_pll_bw_sel                 ),
           .cdr_pll_cal_vco_count_length    		(cdr_pll_cal_vco_count_length   ),
           .cdr_pll_cdr_odi_select          		(cdr_pll_cdr_odi_select         ),
           .cdr_pll_cdr_phaselock_mode      		(cdr_pll_cdr_phaselock_mode     ),
           .cdr_pll_cdr_powerdown_mode      		(cdr_pll_cdr_powerdown_mode     ),
           .cdr_pll_cgb_div                 		(cdr_pll_cgb_div                ),
           .cdr_pll_chgpmp_current_dn_pd    		(cdr_pll_chgpmp_current_dn_pd   ),
           .cdr_pll_chgpmp_current_dn_trim  		(cdr_pll_chgpmp_current_dn_trim ),
           .cdr_pll_chgpmp_current_pd       		(cdr_pll_chgpmp_current_pd      ),
           .cdr_pll_chgpmp_current_pfd      		(cdr_pll_chgpmp_current_pfd     ),
           .cdr_pll_chgpmp_current_up_pd    		(cdr_pll_chgpmp_current_up_pd   ),
           .cdr_pll_chgpmp_current_up_trim  		(cdr_pll_chgpmp_current_up_trim ),
           .cdr_pll_chgpmp_dn_pd_trim_double  		(cdr_pll_chgpmp_dn_pd_trim_double ),
           .cdr_pll_chgpmp_replicate        		(cdr_pll_chgpmp_replicate       ),
           .cdr_pll_chgpmp_testmode         		(cdr_pll_chgpmp_testmode        ),
           .cdr_pll_chgpmp_up_pd_trim_double  		(cdr_pll_chgpmp_up_pd_trim_double ),
           .cdr_pll_clklow_mux_select       		(cdr_pll_clklow_mux_select      ),
           .cdr_pll_datarate                		(cdr_pll_datarate               ),
           .cdr_pll_diag_loopback_enable    		(cdr_pll_diag_loopback_enable   ),
           .cdr_pll_disable_up_dn           		(cdr_pll_disable_up_dn          ),
           .cdr_pll_fb_select               		(cdr_pll_fb_select              ),
           .cdr_pll_fref_clklow_div         		(cdr_pll_fref_clklow_div        ),
           .cdr_pll_fref_mux_select         		(cdr_pll_fref_mux_select        ),
           .cdr_pll_gpon_lck2ref_control    		(cdr_pll_gpon_lck2ref_control   ),
           .cdr_pll_initial_settings        		(cdr_pll_initial_settings       ),
           .cdr_pll_iqclk_mux_sel           		(cdr_pll_iqclk_mux_sel          ),
           .cdr_pll_is_cascaded_pll         		(cdr_pll_is_cascaded_pll        ),
           .cdr_pll_lck2ref_delay_control   		(cdr_pll_lck2ref_delay_control  ),
           .cdr_pll_lf_resistor_pd          		(cdr_pll_lf_resistor_pd         ),
           .cdr_pll_lf_resistor_pfd         		(cdr_pll_lf_resistor_pfd        ),
           .cdr_pll_lf_ripple_cap           		(cdr_pll_lf_ripple_cap          ),
           .cdr_pll_loop_filter_bias_select  		(cdr_pll_loop_filter_bias_select ),
           .cdr_pll_loopback_mode           		(cdr_pll_loopback_mode          ),
           .cdr_pll_lpd_counter             		(cdr_pll_lpd_counter            ),
           .cdr_pll_lpfd_counter            		(cdr_pll_lpfd_counter           ),
           .cdr_pll_ltd_ltr_micro_controller_select  		(cdr_pll_ltd_ltr_micro_controller_select ),
           .cdr_pll_m_counter               		(cdr_pll_m_counter              ),
           .cdr_pll_n_counter               		(cdr_pll_n_counter              ),
           .cdr_pll_n_counter_scratch       		(cdr_pll_n_counter_scratch      ),
           .cdr_pll_output_clock_frequency  		(cdr_pll_output_clock_frequency ),
           .cdr_pll_pcie_gen                		(cdr_pll_pcie_gen               ),
           .cdr_pll_pd_fastlock_mode        		(cdr_pll_pd_fastlock_mode       ),
           .cdr_pll_pd_l_counter            		(cdr_pll_pd_l_counter           ),
           .cdr_pll_pfd_l_counter           		(cdr_pll_pfd_l_counter          ),
           .cdr_pll_pma_width               		(cdr_pll_pma_width              ),
           .cdr_pll_primary_use             		(cdr_pll_primary_use            ),
           .cdr_pll_prot_mode               		(cdr_pll_prot_mode              ),
           .cdr_pll_reference_clock_frequency  		(cdr_pll_reference_clock_frequency ),
           .cdr_pll_reverse_serial_loopback  		(cdr_pll_reverse_serial_loopback ),
           .cdr_pll_set_cdr_input_freq_range  		(cdr_pll_set_cdr_input_freq_range ),
           .cdr_pll_set_cdr_v2i_enable      		(cdr_pll_set_cdr_v2i_enable     ),
           .cdr_pll_set_cdr_vco_reset       		(cdr_pll_set_cdr_vco_reset      ),
           .cdr_pll_set_cdr_vco_speed       		(cdr_pll_set_cdr_vco_speed      ),
           .cdr_pll_set_cdr_vco_speed_fix   		(cdr_pll_set_cdr_vco_speed_fix  ),
           .cdr_pll_set_cdr_vco_speed_pciegen3  		(cdr_pll_set_cdr_vco_speed_pciegen3 ),
           .cdr_pll_sup_mode                		(cdr_pll_sup_mode               ),
           .cdr_pll_tx_pll_prot_mode        		(cdr_pll_tx_pll_prot_mode       ),
           .cdr_pll_txpll_hclk_driver_enable  		(cdr_pll_txpll_hclk_driver_enable ),
           .cdr_pll_uc_ro_cal               		(cdr_pll_uc_ro_cal              ),
           .cdr_pll_vco_freq                		(cdr_pll_vco_freq               ),
           .cdr_pll_vco_overrange_voltage   		(cdr_pll_vco_overrange_voltage  ),
           .cdr_pll_vco_underrange_voltage  		(cdr_pll_vco_underrange_voltage ),
           .pma_rx_buf_bypass_eqz_stages_234  		(pma_rx_buf_bypass_eqz_stages_234 ),
           .pma_rx_buf_datarate             		(pma_rx_buf_datarate            ),
           .pma_rx_buf_diag_lp_en           		(pma_rx_buf_diag_lp_en          ),
           .pma_rx_buf_loopback_modes       		(pma_rx_buf_loopback_modes      ),
           .pma_rx_buf_pm_tx_rx_cvp_mode    		(pma_rx_buf_pm_tx_rx_cvp_mode   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen    		(pma_rx_buf_pm_tx_rx_pcie_gen   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth  		(pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth ),
           .pma_rx_buf_prot_mode            		(pma_rx_buf_prot_mode           ),
           .pma_rx_buf_qpi_enable           		(pma_rx_buf_qpi_enable          ),
           .pma_rx_buf_refclk_en            		(pma_rx_buf_refclk_en           ),
           .pma_rx_buf_rx_refclk_divider    		(pma_rx_buf_rx_refclk_divider   ),
           .pma_rx_buf_sup_mode             		(pma_rx_buf_sup_mode            ),
           .pma_rx_buf_xrx_path_datarate    		(pma_rx_buf_xrx_path_datarate   ),
           .pma_rx_buf_xrx_path_datawidth   		(pma_rx_buf_xrx_path_datawidth  ),
           .pma_rx_buf_xrx_path_pma_rx_divclk_hz  		(pma_rx_buf_xrx_path_pma_rx_divclk_hz ),
           .pma_rx_buf_xrx_path_prot_mode   		(pma_rx_buf_xrx_path_prot_mode  ),
           .pma_rx_buf_xrx_path_sup_mode    		(pma_rx_buf_xrx_path_sup_mode   ),
           .pma_rx_buf_xrx_path_uc_cal_enable  		(pma_rx_buf_xrx_path_uc_cal_enable ),
           .pma_rx_deser_bitslip_bypass     		(pma_rx_deser_bitslip_bypass    ),
           .pma_rx_deser_clkdiv_source      		(pma_rx_deser_clkdiv_source     ),
           .pma_rx_deser_clkdivrx_user_mode  		(pma_rx_deser_clkdivrx_user_mode ),
           .pma_rx_deser_datarate           		(pma_rx_deser_datarate          ),
           .pma_rx_deser_deser_factor       		(pma_rx_deser_deser_factor      ),
           .pma_rx_deser_force_clkdiv_for_testing  		(pma_rx_deser_force_clkdiv_for_testing ),
           .pma_rx_deser_pcie_gen           		(pma_rx_deser_pcie_gen          ),
           .pma_rx_deser_pcie_gen_bitwidth  		(pma_rx_deser_pcie_gen_bitwidth ),
           .pma_rx_deser_prot_mode          		(pma_rx_deser_prot_mode         ),
           .pma_rx_deser_rst_n_adapt_odi    		(pma_rx_deser_rst_n_adapt_odi   ),
           .pma_rx_deser_sdclk_enable       		(pma_rx_deser_sdclk_enable      ),
           .pma_rx_deser_sup_mode           		(pma_rx_deser_sup_mode          ),
           .pma_rx_dfe_datarate             		(pma_rx_dfe_datarate            ),
           .pma_rx_dfe_dft_en               		(pma_rx_dfe_dft_en              ),
           .pma_rx_dfe_pdb                  		(pma_rx_dfe_pdb                 ),
           .pma_rx_dfe_pdb_fixedtap         		(pma_rx_dfe_pdb_fixedtap        ),
           .pma_rx_dfe_pdb_floattap         		(pma_rx_dfe_pdb_floattap        ),
           .pma_rx_dfe_pdb_fxtap4t7         		(pma_rx_dfe_pdb_fxtap4t7        ),
           .pma_rx_dfe_prot_mode            		(pma_rx_dfe_prot_mode           ),
           .pma_rx_dfe_sup_mode             		(pma_rx_dfe_sup_mode            ),
           .pma_rx_odi_datarate             		(pma_rx_odi_datarate            ),
           .pma_rx_odi_prot_mode            		(pma_rx_odi_prot_mode           ),
           .pma_rx_odi_step_ctrl_sel        		(pma_rx_odi_step_ctrl_sel       ),
           .pma_rx_odi_sup_mode             		(pma_rx_odi_sup_mode            ),
           .pma_rx_sd_prot_mode             		(pma_rx_sd_prot_mode            ),
           .pma_rx_sd_sd_output_off         		(pma_rx_sd_sd_output_off        ),
           .pma_rx_sd_sd_output_on          		(pma_rx_sd_sd_output_on         ),
           .pma_rx_sd_sd_pdb                		(pma_rx_sd_sd_pdb               ),
           .pma_rx_sd_sup_mode              		(pma_rx_sd_sup_mode             ),
           .pma_tx_buf_datarate             		(pma_tx_buf_datarate            ),
           .pma_tx_buf_mcgb_location_for_pcie  		(pma_tx_buf_mcgb_location_for_pcie ),
           .pma_tx_buf_prot_mode            		(pma_tx_buf_prot_mode           ),
           .pma_tx_buf_rx_det               		(pma_tx_buf_rx_det              ),
           .pma_tx_buf_rx_det_output_sel    		(pma_tx_buf_rx_det_output_sel   ),
           .pma_tx_buf_rx_det_pdb           		(pma_tx_buf_rx_det_pdb          ),
           .pma_tx_buf_sup_mode             		(pma_tx_buf_sup_mode            ),
           .pma_tx_buf_user_fir_coeff_ctrl_sel  		(pma_tx_buf_user_fir_coeff_ctrl_sel ),
           .pma_tx_buf_xtx_path_clock_divider_ratio  		(pma_tx_buf_xtx_path_clock_divider_ratio ),
           .pma_tx_buf_xtx_path_datarate    		(pma_tx_buf_xtx_path_datarate   ),
           .pma_tx_buf_xtx_path_datawidth   		(pma_tx_buf_xtx_path_datawidth  ),
           .pma_tx_buf_xtx_path_pma_tx_divclk_hz  		(pma_tx_buf_xtx_path_pma_tx_divclk_hz ),
           .pma_tx_buf_xtx_path_prot_mode   		(pma_tx_buf_xtx_path_prot_mode  ),
           .pma_tx_buf_xtx_path_sup_mode    		(pma_tx_buf_xtx_path_sup_mode   ),
           .pma_tx_buf_xtx_path_tx_pll_clk_hz  		(pma_tx_buf_xtx_path_tx_pll_clk_hz ),
           .pma_cgb_bitslip_enable          		(pma_cgb_bitslip_enable         ),
           .pma_cgb_bonding_reset_enable    		(pma_cgb_bonding_reset_enable   ),
           .pma_cgb_datarate                		(pma_cgb_datarate               ),
           .pma_cgb_input_select_gen3       		(pma_cgb_input_select_gen3      ),
           .pma_cgb_input_select_x1         		(pma_cgb_input_select_x1        ),
           .pma_cgb_input_select_xn         		(pma_cgb_input_select_xn        ),
           .pma_cgb_pcie_gen3_bitwidth      		(pma_cgb_pcie_gen3_bitwidth     ),
           .pma_cgb_prot_mode               		(pma_cgb_prot_mode              ),
           .pma_cgb_scratch0_x1_clock_src   		(pma_cgb_scratch0_x1_clock_src  ),
           .pma_cgb_scratch1_x1_clock_src   		(pma_cgb_scratch1_x1_clock_src  ),
           .pma_cgb_scratch2_x1_clock_src   		(pma_cgb_scratch2_x1_clock_src  ),
           .pma_cgb_scratch3_x1_clock_src   		(pma_cgb_scratch3_x1_clock_src  ),
           .pma_cgb_select_done_master_or_slave  		(pma_cgb_select_done_master_or_slave ),
           .pma_cgb_ser_mode                		(pma_cgb_ser_mode               ),
           .pma_cgb_sup_mode                		(pma_cgb_sup_mode               ),
           .pma_cgb_tx_ucontrol_en          		(pma_cgb_tx_ucontrol_en         ),
           .pma_cgb_x1_div_m_sel            		(pma_cgb_x1_div_m_sel           ),
           .pma_tx_ser_prot_mode            		(pma_tx_ser_prot_mode           ),
           .pma_tx_ser_ser_clk_divtx_user_sel  		(pma_tx_ser_ser_clk_divtx_user_sel ),
           .pma_tx_ser_sup_mode             		(pma_tx_ser_sup_mode            ),
           .hssi_10g_rx_pcs_advanced_user_mode  		(hssi_10g_rx_pcs_advanced_user_mode ),
           .hssi_10g_rx_pcs_align_del       		(hssi_10g_rx_pcs_align_del      ),
           .hssi_10g_rx_pcs_ber_bit_err_total_cnt  		(hssi_10g_rx_pcs_ber_bit_err_total_cnt ),
           .hssi_10g_rx_pcs_ber_clken       		(hssi_10g_rx_pcs_ber_clken      ),
           .hssi_10g_rx_pcs_ber_xus_timer_window  		(hssi_10g_rx_pcs_ber_xus_timer_window ),
           .hssi_10g_rx_pcs_bitslip_mode    		(hssi_10g_rx_pcs_bitslip_mode   ),
           .hssi_10g_rx_pcs_blksync_bitslip_type  		(hssi_10g_rx_pcs_blksync_bitslip_type ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_cnt  		(hssi_10g_rx_pcs_blksync_bitslip_wait_cnt ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_type  		(hssi_10g_rx_pcs_blksync_bitslip_wait_type ),
           .hssi_10g_rx_pcs_blksync_bypass  		(hssi_10g_rx_pcs_blksync_bypass ),
           .hssi_10g_rx_pcs_blksync_clken   		(hssi_10g_rx_pcs_blksync_clken  ),
           .hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt  		(hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock ),
           .hssi_10g_rx_pcs_blksync_pipeln  		(hssi_10g_rx_pcs_blksync_pipeln ),
           .hssi_10g_rx_pcs_clr_errblk_cnt_en  		(hssi_10g_rx_pcs_clr_errblk_cnt_en ),
           .hssi_10g_rx_pcs_control_del     		(hssi_10g_rx_pcs_control_del    ),
           .hssi_10g_rx_pcs_crcchk_bypass   		(hssi_10g_rx_pcs_crcchk_bypass  ),
           .hssi_10g_rx_pcs_crcchk_clken    		(hssi_10g_rx_pcs_crcchk_clken   ),
           .hssi_10g_rx_pcs_crcchk_inv      		(hssi_10g_rx_pcs_crcchk_inv     ),
           .hssi_10g_rx_pcs_crcchk_pipeln   		(hssi_10g_rx_pcs_crcchk_pipeln  ),
           .hssi_10g_rx_pcs_crcflag_pipeln  		(hssi_10g_rx_pcs_crcflag_pipeln ),
           .hssi_10g_rx_pcs_ctrl_bit_reverse  		(hssi_10g_rx_pcs_ctrl_bit_reverse ),
           .hssi_10g_rx_pcs_data_bit_reverse  		(hssi_10g_rx_pcs_data_bit_reverse ),
           .hssi_10g_rx_pcs_dec64b66b_clken  		(hssi_10g_rx_pcs_dec64b66b_clken ),
           .hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass  		(hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass ),
           .hssi_10g_rx_pcs_descrm_bypass   		(hssi_10g_rx_pcs_descrm_bypass  ),
           .hssi_10g_rx_pcs_descrm_clken    		(hssi_10g_rx_pcs_descrm_clken   ),
           .hssi_10g_rx_pcs_descrm_mode     		(hssi_10g_rx_pcs_descrm_mode    ),
           .hssi_10g_rx_pcs_descrm_pipeln   		(hssi_10g_rx_pcs_descrm_pipeln  ),
           .hssi_10g_rx_pcs_dft_clk_out_sel  		(hssi_10g_rx_pcs_dft_clk_out_sel ),
           .hssi_10g_rx_pcs_dis_signal_ok   		(hssi_10g_rx_pcs_dis_signal_ok  ),
           .hssi_10g_rx_pcs_dispchk_bypass  		(hssi_10g_rx_pcs_dispchk_bypass ),
           .hssi_10g_rx_pcs_empty_flag_type  		(hssi_10g_rx_pcs_empty_flag_type ),
           .hssi_10g_rx_pcs_fast_path       		(hssi_10g_rx_pcs_fast_path      ),
           .hssi_10g_rx_pcs_fec_clken       		(hssi_10g_rx_pcs_fec_clken      ),
           .hssi_10g_rx_pcs_fec_enable      		(hssi_10g_rx_pcs_fec_enable     ),
           .hssi_10g_rx_pcs_fifo_double_read  		(hssi_10g_rx_pcs_fifo_double_read ),
           .hssi_10g_rx_pcs_fifo_stop_rd    		(hssi_10g_rx_pcs_fifo_stop_rd   ),
           .hssi_10g_rx_pcs_fifo_stop_wr    		(hssi_10g_rx_pcs_fifo_stop_wr   ),
           .hssi_10g_rx_pcs_force_align     		(hssi_10g_rx_pcs_force_align    ),
           .hssi_10g_rx_pcs_frmsync_bypass  		(hssi_10g_rx_pcs_frmsync_bypass ),
           .hssi_10g_rx_pcs_frmsync_clken   		(hssi_10g_rx_pcs_frmsync_clken  ),
           .hssi_10g_rx_pcs_frmsync_enum_scrm  		(hssi_10g_rx_pcs_frmsync_enum_scrm ),
           .hssi_10g_rx_pcs_frmsync_enum_sync  		(hssi_10g_rx_pcs_frmsync_enum_sync ),
           .hssi_10g_rx_pcs_frmsync_flag_type  		(hssi_10g_rx_pcs_frmsync_flag_type ),
           .hssi_10g_rx_pcs_frmsync_knum_sync  		(hssi_10g_rx_pcs_frmsync_knum_sync ),
           .hssi_10g_rx_pcs_frmsync_mfrm_length  		(hssi_10g_rx_pcs_frmsync_mfrm_length ),
           .hssi_10g_rx_pcs_frmsync_pipeln  		(hssi_10g_rx_pcs_frmsync_pipeln ),
           .hssi_10g_rx_pcs_full_flag_type  		(hssi_10g_rx_pcs_full_flag_type ),
           .hssi_10g_rx_pcs_gb_rx_idwidth   		(hssi_10g_rx_pcs_gb_rx_idwidth  ),
           .hssi_10g_rx_pcs_gb_rx_odwidth   		(hssi_10g_rx_pcs_gb_rx_odwidth  ),
           .hssi_10g_rx_pcs_gbexp_clken     		(hssi_10g_rx_pcs_gbexp_clken    ),
           .hssi_10g_rx_pcs_low_latency_en  		(hssi_10g_rx_pcs_low_latency_en ),
           .hssi_10g_rx_pcs_lpbk_mode       		(hssi_10g_rx_pcs_lpbk_mode      ),
           .hssi_10g_rx_pcs_master_clk_sel  		(hssi_10g_rx_pcs_master_clk_sel ),
           .hssi_10g_rx_pcs_pempty_flag_type  		(hssi_10g_rx_pcs_pempty_flag_type ),
           .hssi_10g_rx_pcs_pfull_flag_type  		(hssi_10g_rx_pcs_pfull_flag_type ),
           .hssi_10g_rx_pcs_phcomp_rd_del   		(hssi_10g_rx_pcs_phcomp_rd_del  ),
           .hssi_10g_rx_pcs_pld_if_type     		(hssi_10g_rx_pcs_pld_if_type    ),
           .hssi_10g_rx_pcs_prot_mode       		(hssi_10g_rx_pcs_prot_mode      ),
           .hssi_10g_rx_pcs_rand_clken      		(hssi_10g_rx_pcs_rand_clken     ),
           .hssi_10g_rx_pcs_rd_clk_sel      		(hssi_10g_rx_pcs_rd_clk_sel     ),
           .hssi_10g_rx_pcs_rdfifo_clken    		(hssi_10g_rx_pcs_rdfifo_clken   ),
           .hssi_10g_rx_pcs_reconfig_settings  		(hssi_10g_rx_pcs_reconfig_settings ),
           .hssi_10g_rx_pcs_rx_fifo_write_ctrl  		(hssi_10g_rx_pcs_rx_fifo_write_ctrl ),
           .hssi_10g_rx_pcs_rx_scrm_width   		(hssi_10g_rx_pcs_rx_scrm_width  ),
           .hssi_10g_rx_pcs_rx_sh_location  		(hssi_10g_rx_pcs_rx_sh_location ),
           .hssi_10g_rx_pcs_rx_signal_ok_sel  		(hssi_10g_rx_pcs_rx_signal_ok_sel ),
           .hssi_10g_rx_pcs_rx_sm_bypass    		(hssi_10g_rx_pcs_rx_sm_bypass   ),
           .hssi_10g_rx_pcs_rx_sm_hiber     		(hssi_10g_rx_pcs_rx_sm_hiber    ),
           .hssi_10g_rx_pcs_rx_sm_pipeln    		(hssi_10g_rx_pcs_rx_sm_pipeln   ),
           .hssi_10g_rx_pcs_rx_testbus_sel  		(hssi_10g_rx_pcs_rx_testbus_sel ),
           .hssi_10g_rx_pcs_rx_true_b2b     		(hssi_10g_rx_pcs_rx_true_b2b    ),
           .hssi_10g_rx_pcs_rxfifo_empty    		(hssi_10g_rx_pcs_rxfifo_empty   ),
           .hssi_10g_rx_pcs_rxfifo_full     		(hssi_10g_rx_pcs_rxfifo_full    ),
           .hssi_10g_rx_pcs_rxfifo_mode     		(hssi_10g_rx_pcs_rxfifo_mode    ),
           .hssi_10g_rx_pcs_rxfifo_pempty   		(hssi_10g_rx_pcs_rxfifo_pempty  ),
           .hssi_10g_rx_pcs_rxfifo_pfull    		(hssi_10g_rx_pcs_rxfifo_pfull   ),
           .hssi_10g_rx_pcs_stretch_num_stages  		(hssi_10g_rx_pcs_stretch_num_stages ),
           .hssi_10g_rx_pcs_sup_mode        		(hssi_10g_rx_pcs_sup_mode       ),
           .hssi_10g_rx_pcs_test_mode       		(hssi_10g_rx_pcs_test_mode      ),
           .hssi_10g_rx_pcs_wrfifo_clken    		(hssi_10g_rx_pcs_wrfifo_clken   ),
           .hssi_10g_tx_pcs_advanced_user_mode  		(hssi_10g_tx_pcs_advanced_user_mode ),
           .hssi_10g_tx_pcs_bitslip_en      		(hssi_10g_tx_pcs_bitslip_en     ),
           .hssi_10g_tx_pcs_bonding_dft_en  		(hssi_10g_tx_pcs_bonding_dft_en ),
           .hssi_10g_tx_pcs_bonding_dft_val  		(hssi_10g_tx_pcs_bonding_dft_val ),
           .hssi_10g_tx_pcs_comp_cnt        		(hssi_10g_tx_pcs_comp_cnt       ),
           .hssi_10g_tx_pcs_compin_sel      		(hssi_10g_tx_pcs_compin_sel     ),
           .hssi_10g_tx_pcs_crcgen_bypass   		(hssi_10g_tx_pcs_crcgen_bypass  ),
           .hssi_10g_tx_pcs_crcgen_clken    		(hssi_10g_tx_pcs_crcgen_clken   ),
           .hssi_10g_tx_pcs_crcgen_err      		(hssi_10g_tx_pcs_crcgen_err     ),
           .hssi_10g_tx_pcs_crcgen_inv      		(hssi_10g_tx_pcs_crcgen_inv     ),
           .hssi_10g_tx_pcs_ctrl_bit_reverse  		(hssi_10g_tx_pcs_ctrl_bit_reverse ),
           .hssi_10g_tx_pcs_ctrl_plane_bonding  		(hssi_10g_tx_pcs_ctrl_plane_bonding ),
           .hssi_10g_tx_pcs_data_bit_reverse  		(hssi_10g_tx_pcs_data_bit_reverse ),
           .hssi_10g_tx_pcs_dft_clk_out_sel  		(hssi_10g_tx_pcs_dft_clk_out_sel ),
           .hssi_10g_tx_pcs_dispgen_bypass  		(hssi_10g_tx_pcs_dispgen_bypass ),
           .hssi_10g_tx_pcs_dispgen_clken   		(hssi_10g_tx_pcs_dispgen_clken  ),
           .hssi_10g_tx_pcs_dispgen_err     		(hssi_10g_tx_pcs_dispgen_err    ),
           .hssi_10g_tx_pcs_dispgen_pipeln  		(hssi_10g_tx_pcs_dispgen_pipeln ),
           .hssi_10g_tx_pcs_distdwn_bypass_pipeln  		(hssi_10g_tx_pcs_distdwn_bypass_pipeln ),
           .hssi_10g_tx_pcs_distdwn_master  		(hssi_10g_tx_pcs_distdwn_master ),
           .hssi_10g_tx_pcs_distup_bypass_pipeln  		(hssi_10g_tx_pcs_distup_bypass_pipeln ),
           .hssi_10g_tx_pcs_distup_master   		(hssi_10g_tx_pcs_distup_master  ),
           .hssi_10g_tx_pcs_dv_bond         		(hssi_10g_tx_pcs_dv_bond        ),
           .hssi_10g_tx_pcs_empty_flag_type  		(hssi_10g_tx_pcs_empty_flag_type ),
           .hssi_10g_tx_pcs_enc64b66b_txsm_clken  		(hssi_10g_tx_pcs_enc64b66b_txsm_clken ),
           .hssi_10g_tx_pcs_enc_64b66b_txsm_bypass  		(hssi_10g_tx_pcs_enc_64b66b_txsm_bypass ),
           .hssi_10g_tx_pcs_fastpath        		(hssi_10g_tx_pcs_fastpath       ),
           .hssi_10g_tx_pcs_fec_clken       		(hssi_10g_tx_pcs_fec_clken      ),
           .hssi_10g_tx_pcs_fec_enable      		(hssi_10g_tx_pcs_fec_enable     ),
           .hssi_10g_tx_pcs_fifo_double_write  		(hssi_10g_tx_pcs_fifo_double_write ),
           .hssi_10g_tx_pcs_fifo_reg_fast   		(hssi_10g_tx_pcs_fifo_reg_fast  ),
           .hssi_10g_tx_pcs_fifo_stop_rd    		(hssi_10g_tx_pcs_fifo_stop_rd   ),
           .hssi_10g_tx_pcs_fifo_stop_wr    		(hssi_10g_tx_pcs_fifo_stop_wr   ),
           .hssi_10g_tx_pcs_frmgen_burst    		(hssi_10g_tx_pcs_frmgen_burst   ),
           .hssi_10g_tx_pcs_frmgen_bypass   		(hssi_10g_tx_pcs_frmgen_bypass  ),
           .hssi_10g_tx_pcs_frmgen_clken    		(hssi_10g_tx_pcs_frmgen_clken   ),
           .hssi_10g_tx_pcs_frmgen_mfrm_length  		(hssi_10g_tx_pcs_frmgen_mfrm_length ),
           .hssi_10g_tx_pcs_frmgen_pipeln   		(hssi_10g_tx_pcs_frmgen_pipeln  ),
           .hssi_10g_tx_pcs_frmgen_pyld_ins  		(hssi_10g_tx_pcs_frmgen_pyld_ins ),
           .hssi_10g_tx_pcs_frmgen_wordslip  		(hssi_10g_tx_pcs_frmgen_wordslip ),
           .hssi_10g_tx_pcs_full_flag_type  		(hssi_10g_tx_pcs_full_flag_type ),
           .hssi_10g_tx_pcs_gb_pipeln_bypass  		(hssi_10g_tx_pcs_gb_pipeln_bypass ),
           .hssi_10g_tx_pcs_gb_tx_idwidth   		(hssi_10g_tx_pcs_gb_tx_idwidth  ),
           .hssi_10g_tx_pcs_gb_tx_odwidth   		(hssi_10g_tx_pcs_gb_tx_odwidth  ),
           .hssi_10g_tx_pcs_gbred_clken     		(hssi_10g_tx_pcs_gbred_clken    ),
           .hssi_10g_tx_pcs_indv            		(hssi_10g_tx_pcs_indv           ),
           .hssi_10g_tx_pcs_low_latency_en  		(hssi_10g_tx_pcs_low_latency_en ),
           .hssi_10g_tx_pcs_master_clk_sel  		(hssi_10g_tx_pcs_master_clk_sel ),
           .hssi_10g_tx_pcs_pempty_flag_type  		(hssi_10g_tx_pcs_pempty_flag_type ),
           .hssi_10g_tx_pcs_pfull_flag_type  		(hssi_10g_tx_pcs_pfull_flag_type ),
           .hssi_10g_tx_pcs_phcomp_rd_del   		(hssi_10g_tx_pcs_phcomp_rd_del  ),
           .hssi_10g_tx_pcs_pld_if_type     		(hssi_10g_tx_pcs_pld_if_type    ),
           .hssi_10g_tx_pcs_prot_mode       		(hssi_10g_tx_pcs_prot_mode      ),
           .hssi_10g_tx_pcs_pseudo_random   		(hssi_10g_tx_pcs_pseudo_random  ),
           .hssi_10g_tx_pcs_pseudo_seed_a   		(hssi_10g_tx_pcs_pseudo_seed_a  ),
           .hssi_10g_tx_pcs_pseudo_seed_b   		(hssi_10g_tx_pcs_pseudo_seed_b  ),
           .hssi_10g_tx_pcs_random_disp     		(hssi_10g_tx_pcs_random_disp    ),
           .hssi_10g_tx_pcs_rdfifo_clken    		(hssi_10g_tx_pcs_rdfifo_clken   ),
           .hssi_10g_tx_pcs_reconfig_settings  		(hssi_10g_tx_pcs_reconfig_settings ),
           .hssi_10g_tx_pcs_scrm_bypass     		(hssi_10g_tx_pcs_scrm_bypass    ),
           .hssi_10g_tx_pcs_scrm_clken      		(hssi_10g_tx_pcs_scrm_clken     ),
           .hssi_10g_tx_pcs_scrm_mode       		(hssi_10g_tx_pcs_scrm_mode      ),
           .hssi_10g_tx_pcs_scrm_pipeln     		(hssi_10g_tx_pcs_scrm_pipeln    ),
           .hssi_10g_tx_pcs_sh_err          		(hssi_10g_tx_pcs_sh_err         ),
           .hssi_10g_tx_pcs_sop_mark        		(hssi_10g_tx_pcs_sop_mark       ),
           .hssi_10g_tx_pcs_stretch_num_stages  		(hssi_10g_tx_pcs_stretch_num_stages ),
           .hssi_10g_tx_pcs_sup_mode        		(hssi_10g_tx_pcs_sup_mode       ),
           .hssi_10g_tx_pcs_test_mode       		(hssi_10g_tx_pcs_test_mode      ),
           .hssi_10g_tx_pcs_tx_scrm_err     		(hssi_10g_tx_pcs_tx_scrm_err    ),
           .hssi_10g_tx_pcs_tx_scrm_width   		(hssi_10g_tx_pcs_tx_scrm_width  ),
           .hssi_10g_tx_pcs_tx_sh_location  		(hssi_10g_tx_pcs_tx_sh_location ),
           .hssi_10g_tx_pcs_tx_sm_bypass    		(hssi_10g_tx_pcs_tx_sm_bypass   ),
           .hssi_10g_tx_pcs_tx_sm_pipeln    		(hssi_10g_tx_pcs_tx_sm_pipeln   ),
           .hssi_10g_tx_pcs_tx_testbus_sel  		(hssi_10g_tx_pcs_tx_testbus_sel ),
           .hssi_10g_tx_pcs_txfifo_empty    		(hssi_10g_tx_pcs_txfifo_empty   ),
           .hssi_10g_tx_pcs_txfifo_full     		(hssi_10g_tx_pcs_txfifo_full    ),
           .hssi_10g_tx_pcs_txfifo_mode     		(hssi_10g_tx_pcs_txfifo_mode    ),
           .hssi_10g_tx_pcs_txfifo_pempty   		(hssi_10g_tx_pcs_txfifo_pempty  ),
           .hssi_10g_tx_pcs_txfifo_pfull    		(hssi_10g_tx_pcs_txfifo_pfull   ),
           .hssi_10g_tx_pcs_wr_clk_sel      		(hssi_10g_tx_pcs_wr_clk_sel     ),
           .hssi_10g_tx_pcs_wrfifo_clken    		(hssi_10g_tx_pcs_wrfifo_clken   ),
           .hssi_8g_rx_pcs_auto_error_replacement  		(hssi_8g_rx_pcs_auto_error_replacement ),
           .hssi_8g_rx_pcs_auto_speed_nego  		(hssi_8g_rx_pcs_auto_speed_nego ),
           .hssi_8g_rx_pcs_bit_reversal     		(hssi_8g_rx_pcs_bit_reversal    ),
           .hssi_8g_rx_pcs_bonding_dft_en   		(hssi_8g_rx_pcs_bonding_dft_en  ),
           .hssi_8g_rx_pcs_bonding_dft_val  		(hssi_8g_rx_pcs_bonding_dft_val ),
           .hssi_8g_rx_pcs_bypass_pipeline_reg  		(hssi_8g_rx_pcs_bypass_pipeline_reg ),
           .hssi_8g_rx_pcs_byte_deserializer  		(hssi_8g_rx_pcs_byte_deserializer ),
           .hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask  		(hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask ),
           .hssi_8g_rx_pcs_clkcmp_pattern_n  		(hssi_8g_rx_pcs_clkcmp_pattern_n ),
           .hssi_8g_rx_pcs_clkcmp_pattern_p  		(hssi_8g_rx_pcs_clkcmp_pattern_p ),
           .hssi_8g_rx_pcs_clock_gate_bds_dec_asn  		(hssi_8g_rx_pcs_clock_gate_bds_dec_asn ),
           .hssi_8g_rx_pcs_clock_gate_cdr_eidle  		(hssi_8g_rx_pcs_clock_gate_cdr_eidle ),
           .hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_dw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_dw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_dw_wa  		(hssi_8g_rx_pcs_clock_gate_dw_wa ),
           .hssi_8g_rx_pcs_clock_gate_pc_rdclk  		(hssi_8g_rx_pcs_clock_gate_pc_rdclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_sw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_sw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_sw_wa  		(hssi_8g_rx_pcs_clock_gate_sw_wa ),
           .hssi_8g_rx_pcs_clock_observation_in_pld_core  		(hssi_8g_rx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_rx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_rx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_rx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_rx_pcs_eidle_entry_eios  		(hssi_8g_rx_pcs_eidle_entry_eios ),
           .hssi_8g_rx_pcs_eidle_entry_iei  		(hssi_8g_rx_pcs_eidle_entry_iei ),
           .hssi_8g_rx_pcs_eidle_entry_sd   		(hssi_8g_rx_pcs_eidle_entry_sd  ),
           .hssi_8g_rx_pcs_eightb_tenb_decoder  		(hssi_8g_rx_pcs_eightb_tenb_decoder ),
           .hssi_8g_rx_pcs_err_flags_sel    		(hssi_8g_rx_pcs_err_flags_sel   ),
           .hssi_8g_rx_pcs_fixed_pat_det    		(hssi_8g_rx_pcs_fixed_pat_det   ),
           .hssi_8g_rx_pcs_fixed_pat_num    		(hssi_8g_rx_pcs_fixed_pat_num   ),
           .hssi_8g_rx_pcs_force_signal_detect  		(hssi_8g_rx_pcs_force_signal_detect ),
           .hssi_8g_rx_pcs_gen3_clk_en      		(hssi_8g_rx_pcs_gen3_clk_en     ),
           .hssi_8g_rx_pcs_gen3_rx_clk_sel  		(hssi_8g_rx_pcs_gen3_rx_clk_sel ),
           .hssi_8g_rx_pcs_gen3_tx_clk_sel  		(hssi_8g_rx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_rx_pcs_hip_mode         		(hssi_8g_rx_pcs_hip_mode        ),
           .hssi_8g_rx_pcs_ibm_invalid_code  		(hssi_8g_rx_pcs_ibm_invalid_code ),
           .hssi_8g_rx_pcs_invalid_code_flag_only  		(hssi_8g_rx_pcs_invalid_code_flag_only ),
           .hssi_8g_rx_pcs_pad_or_edb_error_replace  		(hssi_8g_rx_pcs_pad_or_edb_error_replace ),
           .hssi_8g_rx_pcs_pcs_bypass       		(hssi_8g_rx_pcs_pcs_bypass      ),
           .hssi_8g_rx_pcs_phase_comp_rdptr  		(hssi_8g_rx_pcs_phase_comp_rdptr ),
           .hssi_8g_rx_pcs_phase_compensation_fifo  		(hssi_8g_rx_pcs_phase_compensation_fifo ),
           .hssi_8g_rx_pcs_pipe_if_enable   		(hssi_8g_rx_pcs_pipe_if_enable  ),
           .hssi_8g_rx_pcs_pma_dw           		(hssi_8g_rx_pcs_pma_dw          ),
           .hssi_8g_rx_pcs_polinv_8b10b_dec  		(hssi_8g_rx_pcs_polinv_8b10b_dec ),
           .hssi_8g_rx_pcs_prot_mode        		(hssi_8g_rx_pcs_prot_mode       ),
           .hssi_8g_rx_pcs_rate_match       		(hssi_8g_rx_pcs_rate_match      ),
           .hssi_8g_rx_pcs_rate_match_del_thres  		(hssi_8g_rx_pcs_rate_match_del_thres ),
           .hssi_8g_rx_pcs_rate_match_empty_thres  		(hssi_8g_rx_pcs_rate_match_empty_thres ),
           .hssi_8g_rx_pcs_rate_match_full_thres  		(hssi_8g_rx_pcs_rate_match_full_thres ),
           .hssi_8g_rx_pcs_rate_match_ins_thres  		(hssi_8g_rx_pcs_rate_match_ins_thres ),
           .hssi_8g_rx_pcs_rate_match_start_thres  		(hssi_8g_rx_pcs_rate_match_start_thres ),
           .hssi_8g_rx_pcs_reconfig_settings  		(hssi_8g_rx_pcs_reconfig_settings ),
           .hssi_8g_rx_pcs_rx_clk2          		(hssi_8g_rx_pcs_rx_clk2         ),
           .hssi_8g_rx_pcs_rx_clk_free_running  		(hssi_8g_rx_pcs_rx_clk_free_running ),
           .hssi_8g_rx_pcs_rx_pcs_urst      		(hssi_8g_rx_pcs_rx_pcs_urst     ),
           .hssi_8g_rx_pcs_rx_rcvd_clk      		(hssi_8g_rx_pcs_rx_rcvd_clk     ),
           .hssi_8g_rx_pcs_rx_rd_clk        		(hssi_8g_rx_pcs_rx_rd_clk       ),
           .hssi_8g_rx_pcs_rx_refclk        		(hssi_8g_rx_pcs_rx_refclk       ),
           .hssi_8g_rx_pcs_rx_wr_clk        		(hssi_8g_rx_pcs_rx_wr_clk       ),
           .hssi_8g_rx_pcs_sup_mode         		(hssi_8g_rx_pcs_sup_mode        ),
           .hssi_8g_rx_pcs_symbol_swap      		(hssi_8g_rx_pcs_symbol_swap     ),
           .hssi_8g_rx_pcs_sync_sm_idle_eios  		(hssi_8g_rx_pcs_sync_sm_idle_eios ),
           .hssi_8g_rx_pcs_test_bus_sel     		(hssi_8g_rx_pcs_test_bus_sel    ),
           .hssi_8g_rx_pcs_tx_rx_parallel_loopback  		(hssi_8g_rx_pcs_tx_rx_parallel_loopback ),
           .hssi_8g_rx_pcs_wa_boundary_lock_ctrl  		(hssi_8g_rx_pcs_wa_boundary_lock_ctrl ),
           .hssi_8g_rx_pcs_wa_clk_slip_spacing  		(hssi_8g_rx_pcs_wa_clk_slip_spacing ),
           .hssi_8g_rx_pcs_wa_det_latency_sync_status_beh  		(hssi_8g_rx_pcs_wa_det_latency_sync_status_beh ),
           .hssi_8g_rx_pcs_wa_disp_err_flag  		(hssi_8g_rx_pcs_wa_disp_err_flag ),
           .hssi_8g_rx_pcs_wa_kchar         		(hssi_8g_rx_pcs_wa_kchar        ),
           .hssi_8g_rx_pcs_wa_pd            		(hssi_8g_rx_pcs_wa_pd           ),
           .hssi_8g_rx_pcs_wa_pd_data       		(hssi_8g_rx_pcs_wa_pd_data      ),
           .hssi_8g_rx_pcs_wa_pd_polarity   		(hssi_8g_rx_pcs_wa_pd_polarity  ),
           .hssi_8g_rx_pcs_wa_pld_controlled  		(hssi_8g_rx_pcs_wa_pld_controlled ),
           .hssi_8g_rx_pcs_wa_renumber_data  		(hssi_8g_rx_pcs_wa_renumber_data ),
           .hssi_8g_rx_pcs_wa_rgnumber_data  		(hssi_8g_rx_pcs_wa_rgnumber_data ),
           .hssi_8g_rx_pcs_wa_rknumber_data  		(hssi_8g_rx_pcs_wa_rknumber_data ),
           .hssi_8g_rx_pcs_wa_rosnumber_data  		(hssi_8g_rx_pcs_wa_rosnumber_data ),
           .hssi_8g_rx_pcs_wa_rvnumber_data  		(hssi_8g_rx_pcs_wa_rvnumber_data ),
           .hssi_8g_rx_pcs_wa_sync_sm_ctrl  		(hssi_8g_rx_pcs_wa_sync_sm_ctrl ),
           .hssi_8g_rx_pcs_wait_cnt         		(hssi_8g_rx_pcs_wait_cnt        ),
           .hssi_8g_tx_pcs_auto_speed_nego_gen2  		(hssi_8g_tx_pcs_auto_speed_nego_gen2 ),
           .hssi_8g_tx_pcs_bit_reversal     		(hssi_8g_tx_pcs_bit_reversal    ),
           .hssi_8g_tx_pcs_bonding_dft_en   		(hssi_8g_tx_pcs_bonding_dft_en  ),
           .hssi_8g_tx_pcs_bonding_dft_val  		(hssi_8g_tx_pcs_bonding_dft_val ),
           .hssi_8g_tx_pcs_bypass_pipeline_reg  		(hssi_8g_tx_pcs_bypass_pipeline_reg ),
           .hssi_8g_tx_pcs_byte_serializer  		(hssi_8g_tx_pcs_byte_serializer ),
           .hssi_8g_tx_pcs_clock_gate_bs_enc  		(hssi_8g_tx_pcs_clock_gate_bs_enc ),
           .hssi_8g_tx_pcs_clock_gate_dw_fifowr  		(hssi_8g_tx_pcs_clock_gate_dw_fifowr ),
           .hssi_8g_tx_pcs_clock_gate_fiford  		(hssi_8g_tx_pcs_clock_gate_fiford ),
           .hssi_8g_tx_pcs_clock_gate_sw_fifowr  		(hssi_8g_tx_pcs_clock_gate_sw_fifowr ),
           .hssi_8g_tx_pcs_clock_observation_in_pld_core  		(hssi_8g_tx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_tx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_tx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_tx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_tx_pcs_data_selection_8b10b_encoder_input  		(hssi_8g_tx_pcs_data_selection_8b10b_encoder_input ),
           .hssi_8g_tx_pcs_dynamic_clk_switch  		(hssi_8g_tx_pcs_dynamic_clk_switch ),
           .hssi_8g_tx_pcs_eightb_tenb_disp_ctrl  		(hssi_8g_tx_pcs_eightb_tenb_disp_ctrl ),
           .hssi_8g_tx_pcs_eightb_tenb_encoder  		(hssi_8g_tx_pcs_eightb_tenb_encoder ),
           .hssi_8g_tx_pcs_force_echar      		(hssi_8g_tx_pcs_force_echar     ),
           .hssi_8g_tx_pcs_force_kchar      		(hssi_8g_tx_pcs_force_kchar     ),
           .hssi_8g_tx_pcs_gen3_tx_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel ),
           .hssi_8g_tx_pcs_hip_mode         		(hssi_8g_tx_pcs_hip_mode        ),
           .hssi_8g_tx_pcs_pcs_bypass       		(hssi_8g_tx_pcs_pcs_bypass      ),
           .hssi_8g_tx_pcs_phase_comp_rdptr  		(hssi_8g_tx_pcs_phase_comp_rdptr ),
           .hssi_8g_tx_pcs_phase_compensation_fifo  		(hssi_8g_tx_pcs_phase_compensation_fifo ),
           .hssi_8g_tx_pcs_phfifo_write_clk_sel  		(hssi_8g_tx_pcs_phfifo_write_clk_sel ),
           .hssi_8g_tx_pcs_pma_dw           		(hssi_8g_tx_pcs_pma_dw          ),
           .hssi_8g_tx_pcs_prot_mode        		(hssi_8g_tx_pcs_prot_mode       ),
           .hssi_8g_tx_pcs_reconfig_settings  		(hssi_8g_tx_pcs_reconfig_settings ),
           .hssi_8g_tx_pcs_refclk_b_clk_sel  		(hssi_8g_tx_pcs_refclk_b_clk_sel ),
           .hssi_8g_tx_pcs_revloop_back_rm  		(hssi_8g_tx_pcs_revloop_back_rm ),
           .hssi_8g_tx_pcs_sup_mode         		(hssi_8g_tx_pcs_sup_mode        ),
           .hssi_8g_tx_pcs_symbol_swap      		(hssi_8g_tx_pcs_symbol_swap     ),
           .hssi_8g_tx_pcs_tx_bitslip       		(hssi_8g_tx_pcs_tx_bitslip      ),
           .hssi_8g_tx_pcs_tx_compliance_controlled_disparity  		(hssi_8g_tx_pcs_tx_compliance_controlled_disparity ),
           .hssi_8g_tx_pcs_tx_fast_pld_reg  		(hssi_8g_tx_pcs_tx_fast_pld_reg ),
           .hssi_8g_tx_pcs_txclk_freerun    		(hssi_8g_tx_pcs_txclk_freerun   ),
           .hssi_8g_tx_pcs_txpcs_urst       		(hssi_8g_tx_pcs_txpcs_urst      ),
           .hssi_common_pcs_pma_interface_asn_clk_enable  		(hssi_common_pcs_pma_interface_asn_clk_enable ),
           .hssi_common_pcs_pma_interface_asn_enable  		(hssi_common_pcs_pma_interface_asn_enable ),
           .hssi_common_pcs_pma_interface_block_sel  		(hssi_common_pcs_pma_interface_block_sel ),
           .hssi_common_pcs_pma_interface_bypass_early_eios  		(hssi_common_pcs_pma_interface_bypass_early_eios ),
           .hssi_common_pcs_pma_interface_bypass_pcie_switch  		(hssi_common_pcs_pma_interface_bypass_pcie_switch ),
           .hssi_common_pcs_pma_interface_bypass_pma_ltr  		(hssi_common_pcs_pma_interface_bypass_pma_ltr ),
           .hssi_common_pcs_pma_interface_bypass_pma_sw_done  		(hssi_common_pcs_pma_interface_bypass_pma_sw_done ),
           .hssi_common_pcs_pma_interface_bypass_ppm_lock  		(hssi_common_pcs_pma_interface_bypass_ppm_lock ),
           .hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp ),
           .hssi_common_pcs_pma_interface_bypass_txdetectrx  		(hssi_common_pcs_pma_interface_bypass_txdetectrx ),
           .hssi_common_pcs_pma_interface_cdr_control  		(hssi_common_pcs_pma_interface_cdr_control ),
           .hssi_common_pcs_pma_interface_cid_enable  		(hssi_common_pcs_pma_interface_cid_enable ),
           .hssi_common_pcs_pma_interface_cp_cons_sel  		(hssi_common_pcs_pma_interface_cp_cons_sel ),
           .hssi_common_pcs_pma_interface_cp_dwn_mstr  		(hssi_common_pcs_pma_interface_cp_dwn_mstr ),
           .hssi_common_pcs_pma_interface_cp_up_mstr  		(hssi_common_pcs_pma_interface_cp_up_mstr ),
           .hssi_common_pcs_pma_interface_ctrl_plane_bonding  		(hssi_common_pcs_pma_interface_ctrl_plane_bonding ),
           .hssi_common_pcs_pma_interface_data_mask_count  		(hssi_common_pcs_pma_interface_data_mask_count ),
           .hssi_common_pcs_pma_interface_data_mask_count_multi  		(hssi_common_pcs_pma_interface_data_mask_count_multi ),
           .hssi_common_pcs_pma_interface_dft_observation_clock_selection  		(hssi_common_pcs_pma_interface_dft_observation_clock_selection ),
           .hssi_common_pcs_pma_interface_early_eios_counter  		(hssi_common_pcs_pma_interface_early_eios_counter ),
           .hssi_common_pcs_pma_interface_force_freqdet  		(hssi_common_pcs_pma_interface_force_freqdet ),
           .hssi_common_pcs_pma_interface_free_run_clk_enable  		(hssi_common_pcs_pma_interface_free_run_clk_enable ),
           .hssi_common_pcs_pma_interface_ignore_sigdet_g23  		(hssi_common_pcs_pma_interface_ignore_sigdet_g23 ),
           .hssi_common_pcs_pma_interface_pc_en_counter  		(hssi_common_pcs_pma_interface_pc_en_counter ),
           .hssi_common_pcs_pma_interface_pc_rst_counter  		(hssi_common_pcs_pma_interface_pc_rst_counter ),
           .hssi_common_pcs_pma_interface_pcie_hip_mode  		(hssi_common_pcs_pma_interface_pcie_hip_mode ),
           .hssi_common_pcs_pma_interface_ph_fifo_reg_mode  		(hssi_common_pcs_pma_interface_ph_fifo_reg_mode ),
           .hssi_common_pcs_pma_interface_phfifo_flush_wait  		(hssi_common_pcs_pma_interface_phfifo_flush_wait ),
           .hssi_common_pcs_pma_interface_pipe_if_g3pcs  		(hssi_common_pcs_pma_interface_pipe_if_g3pcs ),
           .hssi_common_pcs_pma_interface_pma_done_counter  		(hssi_common_pcs_pma_interface_pma_done_counter ),
           .hssi_common_pcs_pma_interface_pma_if_dft_en  		(hssi_common_pcs_pma_interface_pma_if_dft_en ),
           .hssi_common_pcs_pma_interface_pma_if_dft_val  		(hssi_common_pcs_pma_interface_pma_if_dft_val ),
           .hssi_common_pcs_pma_interface_ppm_cnt_rst  		(hssi_common_pcs_pma_interface_ppm_cnt_rst ),
           .hssi_common_pcs_pma_interface_ppm_deassert_early  		(hssi_common_pcs_pma_interface_ppm_deassert_early ),
           .hssi_common_pcs_pma_interface_ppm_det_buckets  		(hssi_common_pcs_pma_interface_ppm_det_buckets ),
           .hssi_common_pcs_pma_interface_ppm_gen1_2_cnt  		(hssi_common_pcs_pma_interface_ppm_gen1_2_cnt ),
           .hssi_common_pcs_pma_interface_ppm_post_eidle_delay  		(hssi_common_pcs_pma_interface_ppm_post_eidle_delay ),
           .hssi_common_pcs_pma_interface_ppmsel  		(hssi_common_pcs_pma_interface_ppmsel ),
           .hssi_common_pcs_pma_interface_prot_mode  		(hssi_common_pcs_pma_interface_prot_mode ),
           .hssi_common_pcs_pma_interface_reconfig_settings  		(hssi_common_pcs_pma_interface_reconfig_settings ),
           .hssi_common_pcs_pma_interface_rxvalid_mask  		(hssi_common_pcs_pma_interface_rxvalid_mask ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter  		(hssi_common_pcs_pma_interface_sigdet_wait_counter ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter_multi  		(hssi_common_pcs_pma_interface_sigdet_wait_counter_multi ),
           .hssi_common_pcs_pma_interface_sim_mode  		(hssi_common_pcs_pma_interface_sim_mode ),
           .hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en  		(hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en ),
           .hssi_common_pcs_pma_interface_sup_mode  		(hssi_common_pcs_pma_interface_sup_mode ),
           .hssi_common_pcs_pma_interface_testout_sel  		(hssi_common_pcs_pma_interface_testout_sel ),
           .hssi_common_pcs_pma_interface_wait_clk_on_off_timer  		(hssi_common_pcs_pma_interface_wait_clk_on_off_timer ),
           .hssi_common_pcs_pma_interface_wait_pipe_synchronizing  		(hssi_common_pcs_pma_interface_wait_pipe_synchronizing ),
           .hssi_common_pcs_pma_interface_wait_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_wait_send_syncp_fbkp ),
           .hssi_common_pld_pcs_interface_dft_clk_out_en  		(hssi_common_pld_pcs_interface_dft_clk_out_en ),
           .hssi_common_pld_pcs_interface_dft_clk_out_sel  		(hssi_common_pld_pcs_interface_dft_clk_out_sel ),
           .hssi_common_pld_pcs_interface_hrdrstctrl_en  		(hssi_common_pld_pcs_interface_hrdrstctrl_en ),
           .hssi_common_pld_pcs_interface_pcs_testbus_block_sel  		(hssi_common_pld_pcs_interface_pcs_testbus_block_sel ),
           .hssi_common_pld_pcs_interface_reconfig_settings  		(hssi_common_pld_pcs_interface_reconfig_settings ),
           .hssi_fifo_rx_pcs_double_read_mode  		(hssi_fifo_rx_pcs_double_read_mode ),
           .hssi_fifo_rx_pcs_prot_mode      		(hssi_fifo_rx_pcs_prot_mode     ),
           .hssi_fifo_tx_pcs_double_write_mode  		(hssi_fifo_tx_pcs_double_write_mode ),
           .hssi_fifo_tx_pcs_prot_mode      		(hssi_fifo_tx_pcs_prot_mode     ),
           .hssi_gen3_rx_pcs_block_sync     		(hssi_gen3_rx_pcs_block_sync    ),
           .hssi_gen3_rx_pcs_block_sync_sm  		(hssi_gen3_rx_pcs_block_sync_sm ),
           .hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn  		(hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn ),
           .hssi_gen3_rx_pcs_lpbk_force     		(hssi_gen3_rx_pcs_lpbk_force    ),
           .hssi_gen3_rx_pcs_mode           		(hssi_gen3_rx_pcs_mode          ),
           .hssi_gen3_rx_pcs_rate_match_fifo  		(hssi_gen3_rx_pcs_rate_match_fifo ),
           .hssi_gen3_rx_pcs_rate_match_fifo_latency  		(hssi_gen3_rx_pcs_rate_match_fifo_latency ),
           .hssi_gen3_rx_pcs_reconfig_settings  		(hssi_gen3_rx_pcs_reconfig_settings ),
           .hssi_gen3_rx_pcs_reverse_lpbk   		(hssi_gen3_rx_pcs_reverse_lpbk  ),
           .hssi_gen3_rx_pcs_rx_b4gb_par_lpbk  		(hssi_gen3_rx_pcs_rx_b4gb_par_lpbk ),
           .hssi_gen3_rx_pcs_rx_force_balign  		(hssi_gen3_rx_pcs_rx_force_balign ),
           .hssi_gen3_rx_pcs_rx_ins_del_one_skip  		(hssi_gen3_rx_pcs_rx_ins_del_one_skip ),
           .hssi_gen3_rx_pcs_rx_num_fixed_pat  		(hssi_gen3_rx_pcs_rx_num_fixed_pat ),
           .hssi_gen3_rx_pcs_rx_test_out_sel  		(hssi_gen3_rx_pcs_rx_test_out_sel ),
           .hssi_gen3_rx_pcs_sup_mode       		(hssi_gen3_rx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_mode           		(hssi_gen3_tx_pcs_mode          ),
           .hssi_gen3_tx_pcs_reverse_lpbk   		(hssi_gen3_tx_pcs_reverse_lpbk  ),
           .hssi_gen3_tx_pcs_sup_mode       		(hssi_gen3_tx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_tx_bitslip     		(hssi_gen3_tx_pcs_tx_bitslip    ),
           .hssi_gen3_tx_pcs_tx_gbox_byp    		(hssi_gen3_tx_pcs_tx_gbox_byp   ),
           .hssi_krfec_rx_pcs_blksync_cor_en  		(hssi_krfec_rx_pcs_blksync_cor_en ),
           .hssi_krfec_rx_pcs_bypass_gb     		(hssi_krfec_rx_pcs_bypass_gb    ),
           .hssi_krfec_rx_pcs_clr_ctrl      		(hssi_krfec_rx_pcs_clr_ctrl     ),
           .hssi_krfec_rx_pcs_ctrl_bit_reverse  		(hssi_krfec_rx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_rx_pcs_data_bit_reverse  		(hssi_krfec_rx_pcs_data_bit_reverse ),
           .hssi_krfec_rx_pcs_dv_start      		(hssi_krfec_rx_pcs_dv_start     ),
           .hssi_krfec_rx_pcs_err_mark_type  		(hssi_krfec_rx_pcs_err_mark_type ),
           .hssi_krfec_rx_pcs_error_marking_en  		(hssi_krfec_rx_pcs_error_marking_en ),
           .hssi_krfec_rx_pcs_low_latency_en  		(hssi_krfec_rx_pcs_low_latency_en ),
           .hssi_krfec_rx_pcs_lpbk_mode     		(hssi_krfec_rx_pcs_lpbk_mode    ),
           .hssi_krfec_rx_pcs_parity_invalid_enum  		(hssi_krfec_rx_pcs_parity_invalid_enum ),
           .hssi_krfec_rx_pcs_parity_valid_num  		(hssi_krfec_rx_pcs_parity_valid_num ),
           .hssi_krfec_rx_pcs_pipeln_blksync  		(hssi_krfec_rx_pcs_pipeln_blksync ),
           .hssi_krfec_rx_pcs_pipeln_descrm  		(hssi_krfec_rx_pcs_pipeln_descrm ),
           .hssi_krfec_rx_pcs_pipeln_errcorrect  		(hssi_krfec_rx_pcs_pipeln_errcorrect ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_ind  		(hssi_krfec_rx_pcs_pipeln_errtrap_ind ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_lfsr  		(hssi_krfec_rx_pcs_pipeln_errtrap_lfsr ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_loc  		(hssi_krfec_rx_pcs_pipeln_errtrap_loc ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_pat  		(hssi_krfec_rx_pcs_pipeln_errtrap_pat ),
           .hssi_krfec_rx_pcs_pipeln_gearbox  		(hssi_krfec_rx_pcs_pipeln_gearbox ),
           .hssi_krfec_rx_pcs_pipeln_syndrm  		(hssi_krfec_rx_pcs_pipeln_syndrm ),
           .hssi_krfec_rx_pcs_pipeln_trans_dec  		(hssi_krfec_rx_pcs_pipeln_trans_dec ),
           .hssi_krfec_rx_pcs_prot_mode     		(hssi_krfec_rx_pcs_prot_mode    ),
           .hssi_krfec_rx_pcs_receive_order  		(hssi_krfec_rx_pcs_receive_order ),
           .hssi_krfec_rx_pcs_reconfig_settings  		(hssi_krfec_rx_pcs_reconfig_settings ),
           .hssi_krfec_rx_pcs_rx_testbus_sel  		(hssi_krfec_rx_pcs_rx_testbus_sel ),
           .hssi_krfec_rx_pcs_signal_ok_en  		(hssi_krfec_rx_pcs_signal_ok_en ),
           .hssi_krfec_rx_pcs_sup_mode      		(hssi_krfec_rx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_burst_err     		(hssi_krfec_tx_pcs_burst_err    ),
           .hssi_krfec_tx_pcs_burst_err_len  		(hssi_krfec_tx_pcs_burst_err_len ),
           .hssi_krfec_tx_pcs_ctrl_bit_reverse  		(hssi_krfec_tx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_tx_pcs_data_bit_reverse  		(hssi_krfec_tx_pcs_data_bit_reverse ),
           .hssi_krfec_tx_pcs_enc_frame_query  		(hssi_krfec_tx_pcs_enc_frame_query ),
           .hssi_krfec_tx_pcs_low_latency_en  		(hssi_krfec_tx_pcs_low_latency_en ),
           .hssi_krfec_tx_pcs_pipeln_encoder  		(hssi_krfec_tx_pcs_pipeln_encoder ),
           .hssi_krfec_tx_pcs_pipeln_scrambler  		(hssi_krfec_tx_pcs_pipeln_scrambler ),
           .hssi_krfec_tx_pcs_prot_mode     		(hssi_krfec_tx_pcs_prot_mode    ),
           .hssi_krfec_tx_pcs_sup_mode      		(hssi_krfec_tx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_transcode_err  		(hssi_krfec_tx_pcs_transcode_err ),
           .hssi_krfec_tx_pcs_transmit_order  		(hssi_krfec_tx_pcs_transmit_order ),
           .hssi_krfec_tx_pcs_tx_testbus_sel  		(hssi_krfec_tx_pcs_tx_testbus_sel ),
           .hssi_pipe_gen1_2_elec_idle_delay_val  		(hssi_pipe_gen1_2_elec_idle_delay_val ),
           .hssi_pipe_gen1_2_error_replace_pad  		(hssi_pipe_gen1_2_error_replace_pad ),
           .hssi_pipe_gen1_2_hip_mode       		(hssi_pipe_gen1_2_hip_mode      ),
           .hssi_pipe_gen1_2_ind_error_reporting  		(hssi_pipe_gen1_2_ind_error_reporting ),
           .hssi_pipe_gen1_2_phystatus_delay_val  		(hssi_pipe_gen1_2_phystatus_delay_val ),
           .hssi_pipe_gen1_2_phystatus_rst_toggle  		(hssi_pipe_gen1_2_phystatus_rst_toggle ),
           .hssi_pipe_gen1_2_pipe_byte_de_serializer_en  		(hssi_pipe_gen1_2_pipe_byte_de_serializer_en ),
           .hssi_pipe_gen1_2_prot_mode      		(hssi_pipe_gen1_2_prot_mode     ),
           .hssi_pipe_gen1_2_reconfig_settings  		(hssi_pipe_gen1_2_reconfig_settings ),
           .hssi_pipe_gen1_2_rx_pipe_enable  		(hssi_pipe_gen1_2_rx_pipe_enable ),
           .hssi_pipe_gen1_2_rxdetect_bypass  		(hssi_pipe_gen1_2_rxdetect_bypass ),
           .hssi_pipe_gen1_2_sup_mode       		(hssi_pipe_gen1_2_sup_mode      ),
           .hssi_pipe_gen1_2_tx_pipe_enable  		(hssi_pipe_gen1_2_tx_pipe_enable ),
           .hssi_pipe_gen1_2_txswing        		(hssi_pipe_gen1_2_txswing       ),
           .hssi_pipe_gen3_bypass_rx_detection_enable  		(hssi_pipe_gen3_bypass_rx_detection_enable ),
           .hssi_pipe_gen3_bypass_rx_preset  		(hssi_pipe_gen3_bypass_rx_preset ),
           .hssi_pipe_gen3_bypass_rx_preset_enable  		(hssi_pipe_gen3_bypass_rx_preset_enable ),
           .hssi_pipe_gen3_bypass_tx_coefficent  		(hssi_pipe_gen3_bypass_tx_coefficent ),
           .hssi_pipe_gen3_bypass_tx_coefficent_enable  		(hssi_pipe_gen3_bypass_tx_coefficent_enable ),
           .hssi_pipe_gen3_elecidle_delay_g3  		(hssi_pipe_gen3_elecidle_delay_g3 ),
           .hssi_pipe_gen3_ind_error_reporting  		(hssi_pipe_gen3_ind_error_reporting ),
           .hssi_pipe_gen3_mode             		(hssi_pipe_gen3_mode            ),
           .hssi_pipe_gen3_phy_status_delay_g12  		(hssi_pipe_gen3_phy_status_delay_g12 ),
           .hssi_pipe_gen3_phy_status_delay_g3  		(hssi_pipe_gen3_phy_status_delay_g3 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g12  		(hssi_pipe_gen3_phystatus_rst_toggle_g12 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g3  		(hssi_pipe_gen3_phystatus_rst_toggle_g3 ),
           .hssi_pipe_gen3_rate_match_pad_insertion  		(hssi_pipe_gen3_rate_match_pad_insertion ),
           .hssi_pipe_gen3_sup_mode         		(hssi_pipe_gen3_sup_mode        ),
           .hssi_pipe_gen3_test_out_sel     		(hssi_pipe_gen3_test_out_sel    ),
           .hssi_rx_pcs_pma_interface_block_sel  		(hssi_rx_pcs_pma_interface_block_sel ),
           .hssi_rx_pcs_pma_interface_channel_operation_mode  		(hssi_rx_pcs_pma_interface_channel_operation_mode ),
           .hssi_rx_pcs_pma_interface_clkslip_sel  		(hssi_rx_pcs_pma_interface_clkslip_sel ),
           .hssi_rx_pcs_pma_interface_lpbk_en  		(hssi_rx_pcs_pma_interface_lpbk_en ),
           .hssi_rx_pcs_pma_interface_master_clk_sel  		(hssi_rx_pcs_pma_interface_master_clk_sel ),
           .hssi_rx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_rx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_rx_pcs_pma_interface_pma_dw_rx  		(hssi_rx_pcs_pma_interface_pma_dw_rx ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_en  		(hssi_rx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_val  		(hssi_rx_pcs_pma_interface_pma_if_dft_val ),
           .hssi_rx_pcs_pma_interface_prbs9_dwidth  		(hssi_rx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_rx_pcs_pma_interface_prbs_clken  		(hssi_rx_pcs_pma_interface_prbs_clken ),
           .hssi_rx_pcs_pma_interface_prbs_ver  		(hssi_rx_pcs_pma_interface_prbs_ver ),
           .hssi_rx_pcs_pma_interface_prot_mode_rx  		(hssi_rx_pcs_pma_interface_prot_mode_rx ),
           .hssi_rx_pcs_pma_interface_reconfig_settings  		(hssi_rx_pcs_pma_interface_reconfig_settings ),
           .hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_lpbk_en ),
           .hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok  		(hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mask  		(hssi_rx_pcs_pma_interface_rx_prbs_mask ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mode  		(hssi_rx_pcs_pma_interface_rx_prbs_mode ),
           .hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel  		(hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel ),
           .hssi_rx_pcs_pma_interface_rx_static_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_static_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en ),
           .hssi_rx_pcs_pma_interface_sup_mode  		(hssi_rx_pcs_pma_interface_sup_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_rx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_rx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_rx_pld_pcs_interface_pcs_rx_block_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_block_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en  		(hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en ),
           .hssi_rx_pld_pcs_interface_pcs_rx_output_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_output_sel ),
           .hssi_rx_pld_pcs_interface_reconfig_settings  		(hssi_rx_pld_pcs_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_bypass_pma_txelecidle  		(hssi_tx_pcs_pma_interface_bypass_pma_txelecidle ),
           .hssi_tx_pcs_pma_interface_channel_operation_mode  		(hssi_tx_pcs_pma_interface_channel_operation_mode ),
           .hssi_tx_pcs_pma_interface_lpbk_en  		(hssi_tx_pcs_pma_interface_lpbk_en ),
           .hssi_tx_pcs_pma_interface_master_clk_sel  		(hssi_tx_pcs_pma_interface_master_clk_sel ),
           .hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx  		(hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_tx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_tx_pcs_pma_interface_pma_dw_tx  		(hssi_tx_pcs_pma_interface_pma_dw_tx ),
           .hssi_tx_pcs_pma_interface_pma_if_dft_en  		(hssi_tx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_tx_pcs_pma_interface_pmagate_en  		(hssi_tx_pcs_pma_interface_pmagate_en ),
           .hssi_tx_pcs_pma_interface_prbs9_dwidth  		(hssi_tx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_tx_pcs_pma_interface_prbs_clken  		(hssi_tx_pcs_pma_interface_prbs_clken ),
           .hssi_tx_pcs_pma_interface_prbs_gen_pat  		(hssi_tx_pcs_pma_interface_prbs_gen_pat ),
           .hssi_tx_pcs_pma_interface_prot_mode_tx  		(hssi_tx_pcs_pma_interface_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_reconfig_settings  		(hssi_tx_pcs_pma_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_sq_wave_num  		(hssi_tx_pcs_pma_interface_sq_wave_num ),
           .hssi_tx_pcs_pma_interface_sqwgen_clken  		(hssi_tx_pcs_pma_interface_sqwgen_clken ),
           .hssi_tx_pcs_pma_interface_sup_mode  		(hssi_tx_pcs_pma_interface_sup_mode ),
           .hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_tx_pma_data_sel  		(hssi_tx_pcs_pma_interface_tx_pma_data_sel ),
           .hssi_tx_pcs_pma_interface_tx_static_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_static_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period  		(hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable  		(hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control ),
           .hssi_tx_pcs_pma_interface_uhsif_enable  		(hssi_tx_pcs_pma_interface_uhsif_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value ),
           .hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_tx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_tx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding  		(hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_source  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_data_source  		(hssi_tx_pld_pcs_interface_pcs_tx_data_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_output_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_output_sel ),
           .hssi_tx_pld_pcs_interface_reconfig_settings  		(hssi_tx_pld_pcs_interface_reconfig_settings ),
           .avmm_interfaces                 		(avmm_interfaces                ),
           .rcfg_enable                     		(rcfg_enable                    ),
           .enable_avmm                     		(enable_avmm                    ),
           .arbiter_ctrl                    		(arbiter_ctrl                   ),
           .calibration_en                  		(calibration_en                 ),
           .avmm_busy_en                    		(avmm_busy_en                   ),
           .hip_cal_en                      		(hip_cal_en                     ),
           .cal_done                        		(cal_done                       )
                  )
               twentynm_xcvr_native_inst(.*);
             end

  "20nm4es": begin
               twentynm_xcvr_native_rev_20nm4es
                 #(
			
           .bonded_lanes                    		(bonded_lanes                   ),
           .bonding_master_ch               		(bonding_master_ch              ),
           .xcvr_native_mode                		(xcvr_native_mode               ),
           .pma_adapt_adapt_mode            		(pma_adapt_adapt_mode           ),
           .pma_adapt_adp_1s_ctle_bypass    		(pma_adapt_adp_1s_ctle_bypass   ),
           .pma_adapt_adp_4s_ctle_bypass    		(pma_adapt_adp_4s_ctle_bypass   ),
           .pma_adapt_adp_ctle_adapt_cycle_window  		(pma_adapt_adp_ctle_adapt_cycle_window ),
           .pma_adapt_adp_ctle_en           		(pma_adapt_adp_ctle_en          ),
           .pma_adapt_adp_dfe_fltap_bypass  		(pma_adapt_adp_dfe_fltap_bypass ),
           .pma_adapt_adp_dfe_fltap_en      		(pma_adapt_adp_dfe_fltap_en     ),
           .pma_adapt_adp_dfe_fxtap_bypass  		(pma_adapt_adp_dfe_fxtap_bypass ),
           .pma_adapt_adp_dfe_fxtap_en      		(pma_adapt_adp_dfe_fxtap_en     ),
           .pma_adapt_adp_dfe_fxtap_hold_en  		(pma_adapt_adp_dfe_fxtap_hold_en ),
           .pma_adapt_adp_dfe_mode          		(pma_adapt_adp_dfe_mode         ),
           .pma_adapt_adp_mode              		(pma_adapt_adp_mode             ),
           .pma_adapt_adp_onetime_dfe       		(pma_adapt_adp_onetime_dfe      ),
           .pma_adapt_adp_vga_bypass        		(pma_adapt_adp_vga_bypass       ),
           .pma_adapt_adp_vga_en            		(pma_adapt_adp_vga_en           ),
           .pma_adapt_adp_vref_bypass       		(pma_adapt_adp_vref_bypass      ),
           .pma_adapt_adp_vref_en           		(pma_adapt_adp_vref_en          ),
           .pma_adapt_datarate              		(pma_adapt_datarate             ),
           .pma_adapt_odi_dfe_spec_en       		(pma_adapt_odi_dfe_spec_en      ),
           .pma_adapt_prot_mode             		(pma_adapt_prot_mode            ),
           .pma_adapt_sup_mode              		(pma_adapt_sup_mode             ),
           .pma_cdr_refclk_inclk0_logical_to_physical_mapping  		(pma_cdr_refclk_inclk0_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk1_logical_to_physical_mapping  		(pma_cdr_refclk_inclk1_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk2_logical_to_physical_mapping  		(pma_cdr_refclk_inclk2_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk3_logical_to_physical_mapping  		(pma_cdr_refclk_inclk3_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk4_logical_to_physical_mapping  		(pma_cdr_refclk_inclk4_logical_to_physical_mapping ),
           .pma_cdr_refclk_powerdown_mode   		(pma_cdr_refclk_powerdown_mode  ),
           .pma_cdr_refclk_refclk_select    		(pma_cdr_refclk_refclk_select   ),
           .cdr_pll_atb_select_control      		(cdr_pll_atb_select_control     ),
           .cdr_pll_auto_reset_on           		(cdr_pll_auto_reset_on          ),
           .cdr_pll_bbpd_data_pattern_filter_select  		(cdr_pll_bbpd_data_pattern_filter_select ),
           .cdr_pll_bw_sel                  		(cdr_pll_bw_sel                 ),
           .cdr_pll_cal_vco_count_length    		(cdr_pll_cal_vco_count_length   ),
           .cdr_pll_cdr_odi_select          		(cdr_pll_cdr_odi_select         ),
           .cdr_pll_cdr_phaselock_mode      		(cdr_pll_cdr_phaselock_mode     ),
           .cdr_pll_cdr_powerdown_mode      		(cdr_pll_cdr_powerdown_mode     ),
           .cdr_pll_cgb_div                 		(cdr_pll_cgb_div                ),
           .cdr_pll_chgpmp_current_dn_pd    		(cdr_pll_chgpmp_current_dn_pd   ),
           .cdr_pll_chgpmp_current_dn_trim  		(cdr_pll_chgpmp_current_dn_trim ),
           .cdr_pll_chgpmp_current_pd       		(cdr_pll_chgpmp_current_pd      ),
           .cdr_pll_chgpmp_current_pfd      		(cdr_pll_chgpmp_current_pfd     ),
           .cdr_pll_chgpmp_current_up_pd    		(cdr_pll_chgpmp_current_up_pd   ),
           .cdr_pll_chgpmp_current_up_trim  		(cdr_pll_chgpmp_current_up_trim ),
           .cdr_pll_chgpmp_dn_pd_trim_double  		(cdr_pll_chgpmp_dn_pd_trim_double ),
           .cdr_pll_chgpmp_replicate        		(cdr_pll_chgpmp_replicate       ),
           .cdr_pll_chgpmp_testmode         		(cdr_pll_chgpmp_testmode        ),
           .cdr_pll_chgpmp_up_pd_trim_double  		(cdr_pll_chgpmp_up_pd_trim_double ),
           .cdr_pll_clklow_mux_select       		(cdr_pll_clklow_mux_select      ),
           .cdr_pll_datarate                		(cdr_pll_datarate               ),
           .cdr_pll_diag_loopback_enable    		(cdr_pll_diag_loopback_enable   ),
           .cdr_pll_disable_up_dn           		(cdr_pll_disable_up_dn          ),
           .cdr_pll_fb_select               		(cdr_pll_fb_select              ),
           .cdr_pll_fref_clklow_div         		(cdr_pll_fref_clklow_div        ),
           .cdr_pll_fref_mux_select         		(cdr_pll_fref_mux_select        ),
           .cdr_pll_gpon_lck2ref_control    		(cdr_pll_gpon_lck2ref_control   ),
           .cdr_pll_initial_settings        		(cdr_pll_initial_settings       ),
           .cdr_pll_iqclk_mux_sel           		(cdr_pll_iqclk_mux_sel          ),
           .cdr_pll_is_cascaded_pll         		(cdr_pll_is_cascaded_pll        ),
           .cdr_pll_lck2ref_delay_control   		(cdr_pll_lck2ref_delay_control  ),
           .cdr_pll_lf_resistor_pd          		(cdr_pll_lf_resistor_pd         ),
           .cdr_pll_lf_resistor_pfd         		(cdr_pll_lf_resistor_pfd        ),
           .cdr_pll_lf_ripple_cap           		(cdr_pll_lf_ripple_cap          ),
           .cdr_pll_loop_filter_bias_select  		(cdr_pll_loop_filter_bias_select ),
           .cdr_pll_loopback_mode           		(cdr_pll_loopback_mode          ),
           .cdr_pll_lpd_counter             		(cdr_pll_lpd_counter            ),
           .cdr_pll_lpfd_counter            		(cdr_pll_lpfd_counter           ),
           .cdr_pll_ltd_ltr_micro_controller_select  		(cdr_pll_ltd_ltr_micro_controller_select ),
           .cdr_pll_m_counter               		(cdr_pll_m_counter              ),
           .cdr_pll_n_counter               		(cdr_pll_n_counter              ),
           .cdr_pll_n_counter_scratch       		(cdr_pll_n_counter_scratch      ),
           .cdr_pll_output_clock_frequency  		(cdr_pll_output_clock_frequency ),
           .cdr_pll_pcie_gen                		(cdr_pll_pcie_gen               ),
           .cdr_pll_pd_fastlock_mode        		(cdr_pll_pd_fastlock_mode       ),
           .cdr_pll_pd_l_counter            		(cdr_pll_pd_l_counter           ),
           .cdr_pll_pfd_l_counter           		(cdr_pll_pfd_l_counter          ),
           .cdr_pll_pma_width               		(cdr_pll_pma_width              ),
           .cdr_pll_primary_use             		(cdr_pll_primary_use            ),
           .cdr_pll_prot_mode               		(cdr_pll_prot_mode              ),
           .cdr_pll_reference_clock_frequency  		(cdr_pll_reference_clock_frequency ),
           .cdr_pll_reverse_serial_loopback  		(cdr_pll_reverse_serial_loopback ),
           .cdr_pll_set_cdr_input_freq_range  		(cdr_pll_set_cdr_input_freq_range ),
           .cdr_pll_set_cdr_v2i_enable      		(cdr_pll_set_cdr_v2i_enable     ),
           .cdr_pll_set_cdr_vco_reset       		(cdr_pll_set_cdr_vco_reset      ),
           .cdr_pll_set_cdr_vco_speed       		(cdr_pll_set_cdr_vco_speed      ),
           .cdr_pll_set_cdr_vco_speed_fix   		(cdr_pll_set_cdr_vco_speed_fix  ),
           .cdr_pll_set_cdr_vco_speed_pciegen3  		(cdr_pll_set_cdr_vco_speed_pciegen3 ),
           .cdr_pll_sup_mode                		(cdr_pll_sup_mode               ),
           .cdr_pll_tx_pll_prot_mode        		(cdr_pll_tx_pll_prot_mode       ),
           .cdr_pll_txpll_hclk_driver_enable  		(cdr_pll_txpll_hclk_driver_enable ),
           .cdr_pll_uc_ro_cal               		(cdr_pll_uc_ro_cal              ),
           .cdr_pll_vco_freq                		(cdr_pll_vco_freq               ),
           .cdr_pll_vco_overrange_voltage   		(cdr_pll_vco_overrange_voltage  ),
           .cdr_pll_vco_underrange_voltage  		(cdr_pll_vco_underrange_voltage ),
           .pma_rx_buf_bypass_eqz_stages_234  		(pma_rx_buf_bypass_eqz_stages_234 ),
           .pma_rx_buf_datarate             		(pma_rx_buf_datarate            ),
           .pma_rx_buf_diag_lp_en           		(pma_rx_buf_diag_lp_en          ),
           .pma_rx_buf_loopback_modes       		(pma_rx_buf_loopback_modes      ),
           .pma_rx_buf_pm_tx_rx_cvp_mode    		(pma_rx_buf_pm_tx_rx_cvp_mode   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen    		(pma_rx_buf_pm_tx_rx_pcie_gen   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth  		(pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth ),
           .pma_rx_buf_prot_mode            		(pma_rx_buf_prot_mode           ),
           .pma_rx_buf_qpi_enable           		(pma_rx_buf_qpi_enable          ),
           .pma_rx_buf_refclk_en            		(pma_rx_buf_refclk_en           ),
           .pma_rx_buf_rx_refclk_divider    		(pma_rx_buf_rx_refclk_divider   ),
           .pma_rx_buf_sup_mode             		(pma_rx_buf_sup_mode            ),
           .pma_rx_buf_xrx_path_datarate    		(pma_rx_buf_xrx_path_datarate   ),
           .pma_rx_buf_xrx_path_datawidth   		(pma_rx_buf_xrx_path_datawidth  ),
           .pma_rx_buf_xrx_path_pma_rx_divclk_hz  		(pma_rx_buf_xrx_path_pma_rx_divclk_hz ),
           .pma_rx_buf_xrx_path_prot_mode   		(pma_rx_buf_xrx_path_prot_mode  ),
           .pma_rx_buf_xrx_path_sup_mode    		(pma_rx_buf_xrx_path_sup_mode   ),
           .pma_rx_buf_xrx_path_uc_cal_enable  		(pma_rx_buf_xrx_path_uc_cal_enable ),
           .pma_rx_deser_bitslip_bypass     		(pma_rx_deser_bitslip_bypass    ),
           .pma_rx_deser_clkdiv_source      		(pma_rx_deser_clkdiv_source     ),
           .pma_rx_deser_clkdivrx_user_mode  		(pma_rx_deser_clkdivrx_user_mode ),
           .pma_rx_deser_datarate           		(pma_rx_deser_datarate          ),
           .pma_rx_deser_deser_factor       		(pma_rx_deser_deser_factor      ),
           .pma_rx_deser_force_clkdiv_for_testing  		(pma_rx_deser_force_clkdiv_for_testing ),
           .pma_rx_deser_pcie_gen           		(pma_rx_deser_pcie_gen          ),
           .pma_rx_deser_pcie_gen_bitwidth  		(pma_rx_deser_pcie_gen_bitwidth ),
           .pma_rx_deser_prot_mode          		(pma_rx_deser_prot_mode         ),
           .pma_rx_deser_rst_n_adapt_odi    		(pma_rx_deser_rst_n_adapt_odi   ),
           .pma_rx_deser_sdclk_enable       		(pma_rx_deser_sdclk_enable      ),
           .pma_rx_deser_sup_mode           		(pma_rx_deser_sup_mode          ),
           .pma_rx_dfe_datarate             		(pma_rx_dfe_datarate            ),
           .pma_rx_dfe_dft_en               		(pma_rx_dfe_dft_en              ),
           .pma_rx_dfe_pdb                  		(pma_rx_dfe_pdb                 ),
           .pma_rx_dfe_pdb_fixedtap         		(pma_rx_dfe_pdb_fixedtap        ),
           .pma_rx_dfe_pdb_floattap         		(pma_rx_dfe_pdb_floattap        ),
           .pma_rx_dfe_pdb_fxtap4t7         		(pma_rx_dfe_pdb_fxtap4t7        ),
           .pma_rx_dfe_prot_mode            		(pma_rx_dfe_prot_mode           ),
           .pma_rx_dfe_sup_mode             		(pma_rx_dfe_sup_mode            ),
           .pma_rx_odi_datarate             		(pma_rx_odi_datarate            ),
           .pma_rx_odi_prot_mode            		(pma_rx_odi_prot_mode           ),
           .pma_rx_odi_step_ctrl_sel        		(pma_rx_odi_step_ctrl_sel       ),
           .pma_rx_odi_sup_mode             		(pma_rx_odi_sup_mode            ),
           .pma_rx_sd_prot_mode             		(pma_rx_sd_prot_mode            ),
           .pma_rx_sd_sd_output_off         		(pma_rx_sd_sd_output_off        ),
           .pma_rx_sd_sd_output_on          		(pma_rx_sd_sd_output_on         ),
           .pma_rx_sd_sd_pdb                		(pma_rx_sd_sd_pdb               ),
           .pma_rx_sd_sup_mode              		(pma_rx_sd_sup_mode             ),
           .pma_tx_buf_datarate             		(pma_tx_buf_datarate            ),
           .pma_tx_buf_mcgb_location_for_pcie  		(pma_tx_buf_mcgb_location_for_pcie ),
           .pma_tx_buf_prot_mode            		(pma_tx_buf_prot_mode           ),
           .pma_tx_buf_rx_det               		(pma_tx_buf_rx_det              ),
           .pma_tx_buf_rx_det_output_sel    		(pma_tx_buf_rx_det_output_sel   ),
           .pma_tx_buf_rx_det_pdb           		(pma_tx_buf_rx_det_pdb          ),
           .pma_tx_buf_sup_mode             		(pma_tx_buf_sup_mode            ),
           .pma_tx_buf_user_fir_coeff_ctrl_sel  		(pma_tx_buf_user_fir_coeff_ctrl_sel ),
           .pma_tx_buf_xtx_path_clock_divider_ratio  		(pma_tx_buf_xtx_path_clock_divider_ratio ),
           .pma_tx_buf_xtx_path_datarate    		(pma_tx_buf_xtx_path_datarate   ),
           .pma_tx_buf_xtx_path_datawidth   		(pma_tx_buf_xtx_path_datawidth  ),
           .pma_tx_buf_xtx_path_pma_tx_divclk_hz  		(pma_tx_buf_xtx_path_pma_tx_divclk_hz ),
           .pma_tx_buf_xtx_path_prot_mode   		(pma_tx_buf_xtx_path_prot_mode  ),
           .pma_tx_buf_xtx_path_sup_mode    		(pma_tx_buf_xtx_path_sup_mode   ),
           .pma_tx_buf_xtx_path_tx_pll_clk_hz  		(pma_tx_buf_xtx_path_tx_pll_clk_hz ),
           .pma_cgb_bitslip_enable          		(pma_cgb_bitslip_enable         ),
           .pma_cgb_bonding_reset_enable    		(pma_cgb_bonding_reset_enable   ),
           .pma_cgb_datarate                		(pma_cgb_datarate               ),
           .pma_cgb_input_select_gen3       		(pma_cgb_input_select_gen3      ),
           .pma_cgb_input_select_x1         		(pma_cgb_input_select_x1        ),
           .pma_cgb_input_select_xn         		(pma_cgb_input_select_xn        ),
           .pma_cgb_pcie_gen3_bitwidth      		(pma_cgb_pcie_gen3_bitwidth     ),
           .pma_cgb_prot_mode               		(pma_cgb_prot_mode              ),
           .pma_cgb_scratch0_x1_clock_src   		(pma_cgb_scratch0_x1_clock_src  ),
           .pma_cgb_scratch1_x1_clock_src   		(pma_cgb_scratch1_x1_clock_src  ),
           .pma_cgb_scratch2_x1_clock_src   		(pma_cgb_scratch2_x1_clock_src  ),
           .pma_cgb_scratch3_x1_clock_src   		(pma_cgb_scratch3_x1_clock_src  ),
           .pma_cgb_select_done_master_or_slave  		(pma_cgb_select_done_master_or_slave ),
           .pma_cgb_ser_mode                		(pma_cgb_ser_mode               ),
           .pma_cgb_sup_mode                		(pma_cgb_sup_mode               ),
           .pma_cgb_tx_ucontrol_en          		(pma_cgb_tx_ucontrol_en         ),
           .pma_cgb_x1_div_m_sel            		(pma_cgb_x1_div_m_sel           ),
           .pma_tx_ser_prot_mode            		(pma_tx_ser_prot_mode           ),
           .pma_tx_ser_ser_clk_divtx_user_sel  		(pma_tx_ser_ser_clk_divtx_user_sel ),
           .pma_tx_ser_sup_mode             		(pma_tx_ser_sup_mode            ),
           .hssi_10g_rx_pcs_advanced_user_mode  		(hssi_10g_rx_pcs_advanced_user_mode ),
           .hssi_10g_rx_pcs_align_del       		(hssi_10g_rx_pcs_align_del      ),
           .hssi_10g_rx_pcs_ber_bit_err_total_cnt  		(hssi_10g_rx_pcs_ber_bit_err_total_cnt ),
           .hssi_10g_rx_pcs_ber_clken       		(hssi_10g_rx_pcs_ber_clken      ),
           .hssi_10g_rx_pcs_ber_xus_timer_window  		(hssi_10g_rx_pcs_ber_xus_timer_window ),
           .hssi_10g_rx_pcs_bitslip_mode    		(hssi_10g_rx_pcs_bitslip_mode   ),
           .hssi_10g_rx_pcs_blksync_bitslip_type  		(hssi_10g_rx_pcs_blksync_bitslip_type ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_cnt  		(hssi_10g_rx_pcs_blksync_bitslip_wait_cnt ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_type  		(hssi_10g_rx_pcs_blksync_bitslip_wait_type ),
           .hssi_10g_rx_pcs_blksync_bypass  		(hssi_10g_rx_pcs_blksync_bypass ),
           .hssi_10g_rx_pcs_blksync_clken   		(hssi_10g_rx_pcs_blksync_clken  ),
           .hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt  		(hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock ),
           .hssi_10g_rx_pcs_blksync_pipeln  		(hssi_10g_rx_pcs_blksync_pipeln ),
           .hssi_10g_rx_pcs_clr_errblk_cnt_en  		(hssi_10g_rx_pcs_clr_errblk_cnt_en ),
           .hssi_10g_rx_pcs_control_del     		(hssi_10g_rx_pcs_control_del    ),
           .hssi_10g_rx_pcs_crcchk_bypass   		(hssi_10g_rx_pcs_crcchk_bypass  ),
           .hssi_10g_rx_pcs_crcchk_clken    		(hssi_10g_rx_pcs_crcchk_clken   ),
           .hssi_10g_rx_pcs_crcchk_inv      		(hssi_10g_rx_pcs_crcchk_inv     ),
           .hssi_10g_rx_pcs_crcchk_pipeln   		(hssi_10g_rx_pcs_crcchk_pipeln  ),
           .hssi_10g_rx_pcs_crcflag_pipeln  		(hssi_10g_rx_pcs_crcflag_pipeln ),
           .hssi_10g_rx_pcs_ctrl_bit_reverse  		(hssi_10g_rx_pcs_ctrl_bit_reverse ),
           .hssi_10g_rx_pcs_data_bit_reverse  		(hssi_10g_rx_pcs_data_bit_reverse ),
           .hssi_10g_rx_pcs_dec64b66b_clken  		(hssi_10g_rx_pcs_dec64b66b_clken ),
           .hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass  		(hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass ),
           .hssi_10g_rx_pcs_descrm_bypass   		(hssi_10g_rx_pcs_descrm_bypass  ),
           .hssi_10g_rx_pcs_descrm_clken    		(hssi_10g_rx_pcs_descrm_clken   ),
           .hssi_10g_rx_pcs_descrm_mode     		(hssi_10g_rx_pcs_descrm_mode    ),
           .hssi_10g_rx_pcs_descrm_pipeln   		(hssi_10g_rx_pcs_descrm_pipeln  ),
           .hssi_10g_rx_pcs_dft_clk_out_sel  		(hssi_10g_rx_pcs_dft_clk_out_sel ),
           .hssi_10g_rx_pcs_dis_signal_ok   		(hssi_10g_rx_pcs_dis_signal_ok  ),
           .hssi_10g_rx_pcs_dispchk_bypass  		(hssi_10g_rx_pcs_dispchk_bypass ),
           .hssi_10g_rx_pcs_empty_flag_type  		(hssi_10g_rx_pcs_empty_flag_type ),
           .hssi_10g_rx_pcs_fast_path       		(hssi_10g_rx_pcs_fast_path      ),
           .hssi_10g_rx_pcs_fec_clken       		(hssi_10g_rx_pcs_fec_clken      ),
           .hssi_10g_rx_pcs_fec_enable      		(hssi_10g_rx_pcs_fec_enable     ),
           .hssi_10g_rx_pcs_fifo_double_read  		(hssi_10g_rx_pcs_fifo_double_read ),
           .hssi_10g_rx_pcs_fifo_stop_rd    		(hssi_10g_rx_pcs_fifo_stop_rd   ),
           .hssi_10g_rx_pcs_fifo_stop_wr    		(hssi_10g_rx_pcs_fifo_stop_wr   ),
           .hssi_10g_rx_pcs_force_align     		(hssi_10g_rx_pcs_force_align    ),
           .hssi_10g_rx_pcs_frmsync_bypass  		(hssi_10g_rx_pcs_frmsync_bypass ),
           .hssi_10g_rx_pcs_frmsync_clken   		(hssi_10g_rx_pcs_frmsync_clken  ),
           .hssi_10g_rx_pcs_frmsync_enum_scrm  		(hssi_10g_rx_pcs_frmsync_enum_scrm ),
           .hssi_10g_rx_pcs_frmsync_enum_sync  		(hssi_10g_rx_pcs_frmsync_enum_sync ),
           .hssi_10g_rx_pcs_frmsync_flag_type  		(hssi_10g_rx_pcs_frmsync_flag_type ),
           .hssi_10g_rx_pcs_frmsync_knum_sync  		(hssi_10g_rx_pcs_frmsync_knum_sync ),
           .hssi_10g_rx_pcs_frmsync_mfrm_length  		(hssi_10g_rx_pcs_frmsync_mfrm_length ),
           .hssi_10g_rx_pcs_frmsync_pipeln  		(hssi_10g_rx_pcs_frmsync_pipeln ),
           .hssi_10g_rx_pcs_full_flag_type  		(hssi_10g_rx_pcs_full_flag_type ),
           .hssi_10g_rx_pcs_gb_rx_idwidth   		(hssi_10g_rx_pcs_gb_rx_idwidth  ),
           .hssi_10g_rx_pcs_gb_rx_odwidth   		(hssi_10g_rx_pcs_gb_rx_odwidth  ),
           .hssi_10g_rx_pcs_gbexp_clken     		(hssi_10g_rx_pcs_gbexp_clken    ),
           .hssi_10g_rx_pcs_low_latency_en  		(hssi_10g_rx_pcs_low_latency_en ),
           .hssi_10g_rx_pcs_lpbk_mode       		(hssi_10g_rx_pcs_lpbk_mode      ),
           .hssi_10g_rx_pcs_master_clk_sel  		(hssi_10g_rx_pcs_master_clk_sel ),
           .hssi_10g_rx_pcs_pempty_flag_type  		(hssi_10g_rx_pcs_pempty_flag_type ),
           .hssi_10g_rx_pcs_pfull_flag_type  		(hssi_10g_rx_pcs_pfull_flag_type ),
           .hssi_10g_rx_pcs_phcomp_rd_del   		(hssi_10g_rx_pcs_phcomp_rd_del  ),
           .hssi_10g_rx_pcs_pld_if_type     		(hssi_10g_rx_pcs_pld_if_type    ),
           .hssi_10g_rx_pcs_prot_mode       		(hssi_10g_rx_pcs_prot_mode      ),
           .hssi_10g_rx_pcs_rand_clken      		(hssi_10g_rx_pcs_rand_clken     ),
           .hssi_10g_rx_pcs_rd_clk_sel      		(hssi_10g_rx_pcs_rd_clk_sel     ),
           .hssi_10g_rx_pcs_rdfifo_clken    		(hssi_10g_rx_pcs_rdfifo_clken   ),
           .hssi_10g_rx_pcs_reconfig_settings  		(hssi_10g_rx_pcs_reconfig_settings ),
           .hssi_10g_rx_pcs_rx_fifo_write_ctrl  		(hssi_10g_rx_pcs_rx_fifo_write_ctrl ),
           .hssi_10g_rx_pcs_rx_scrm_width   		(hssi_10g_rx_pcs_rx_scrm_width  ),
           .hssi_10g_rx_pcs_rx_sh_location  		(hssi_10g_rx_pcs_rx_sh_location ),
           .hssi_10g_rx_pcs_rx_signal_ok_sel  		(hssi_10g_rx_pcs_rx_signal_ok_sel ),
           .hssi_10g_rx_pcs_rx_sm_bypass    		(hssi_10g_rx_pcs_rx_sm_bypass   ),
           .hssi_10g_rx_pcs_rx_sm_hiber     		(hssi_10g_rx_pcs_rx_sm_hiber    ),
           .hssi_10g_rx_pcs_rx_sm_pipeln    		(hssi_10g_rx_pcs_rx_sm_pipeln   ),
           .hssi_10g_rx_pcs_rx_testbus_sel  		(hssi_10g_rx_pcs_rx_testbus_sel ),
           .hssi_10g_rx_pcs_rx_true_b2b     		(hssi_10g_rx_pcs_rx_true_b2b    ),
           .hssi_10g_rx_pcs_rxfifo_empty    		(hssi_10g_rx_pcs_rxfifo_empty   ),
           .hssi_10g_rx_pcs_rxfifo_full     		(hssi_10g_rx_pcs_rxfifo_full    ),
           .hssi_10g_rx_pcs_rxfifo_mode     		(hssi_10g_rx_pcs_rxfifo_mode    ),
           .hssi_10g_rx_pcs_rxfifo_pempty   		(hssi_10g_rx_pcs_rxfifo_pempty  ),
           .hssi_10g_rx_pcs_rxfifo_pfull    		(hssi_10g_rx_pcs_rxfifo_pfull   ),
           .hssi_10g_rx_pcs_stretch_num_stages  		(hssi_10g_rx_pcs_stretch_num_stages ),
           .hssi_10g_rx_pcs_sup_mode        		(hssi_10g_rx_pcs_sup_mode       ),
           .hssi_10g_rx_pcs_test_mode       		(hssi_10g_rx_pcs_test_mode      ),
           .hssi_10g_rx_pcs_wrfifo_clken    		(hssi_10g_rx_pcs_wrfifo_clken   ),
           .hssi_10g_tx_pcs_advanced_user_mode  		(hssi_10g_tx_pcs_advanced_user_mode ),
           .hssi_10g_tx_pcs_bitslip_en      		(hssi_10g_tx_pcs_bitslip_en     ),
           .hssi_10g_tx_pcs_bonding_dft_en  		(hssi_10g_tx_pcs_bonding_dft_en ),
           .hssi_10g_tx_pcs_bonding_dft_val  		(hssi_10g_tx_pcs_bonding_dft_val ),
           .hssi_10g_tx_pcs_comp_cnt        		(hssi_10g_tx_pcs_comp_cnt       ),
           .hssi_10g_tx_pcs_compin_sel      		(hssi_10g_tx_pcs_compin_sel     ),
           .hssi_10g_tx_pcs_crcgen_bypass   		(hssi_10g_tx_pcs_crcgen_bypass  ),
           .hssi_10g_tx_pcs_crcgen_clken    		(hssi_10g_tx_pcs_crcgen_clken   ),
           .hssi_10g_tx_pcs_crcgen_err      		(hssi_10g_tx_pcs_crcgen_err     ),
           .hssi_10g_tx_pcs_crcgen_inv      		(hssi_10g_tx_pcs_crcgen_inv     ),
           .hssi_10g_tx_pcs_ctrl_bit_reverse  		(hssi_10g_tx_pcs_ctrl_bit_reverse ),
           .hssi_10g_tx_pcs_ctrl_plane_bonding  		(hssi_10g_tx_pcs_ctrl_plane_bonding ),
           .hssi_10g_tx_pcs_data_bit_reverse  		(hssi_10g_tx_pcs_data_bit_reverse ),
           .hssi_10g_tx_pcs_dft_clk_out_sel  		(hssi_10g_tx_pcs_dft_clk_out_sel ),
           .hssi_10g_tx_pcs_dispgen_bypass  		(hssi_10g_tx_pcs_dispgen_bypass ),
           .hssi_10g_tx_pcs_dispgen_clken   		(hssi_10g_tx_pcs_dispgen_clken  ),
           .hssi_10g_tx_pcs_dispgen_err     		(hssi_10g_tx_pcs_dispgen_err    ),
           .hssi_10g_tx_pcs_dispgen_pipeln  		(hssi_10g_tx_pcs_dispgen_pipeln ),
           .hssi_10g_tx_pcs_distdwn_bypass_pipeln  		(hssi_10g_tx_pcs_distdwn_bypass_pipeln ),
           .hssi_10g_tx_pcs_distdwn_master  		(hssi_10g_tx_pcs_distdwn_master ),
           .hssi_10g_tx_pcs_distup_bypass_pipeln  		(hssi_10g_tx_pcs_distup_bypass_pipeln ),
           .hssi_10g_tx_pcs_distup_master   		(hssi_10g_tx_pcs_distup_master  ),
           .hssi_10g_tx_pcs_dv_bond         		(hssi_10g_tx_pcs_dv_bond        ),
           .hssi_10g_tx_pcs_empty_flag_type  		(hssi_10g_tx_pcs_empty_flag_type ),
           .hssi_10g_tx_pcs_enc64b66b_txsm_clken  		(hssi_10g_tx_pcs_enc64b66b_txsm_clken ),
           .hssi_10g_tx_pcs_enc_64b66b_txsm_bypass  		(hssi_10g_tx_pcs_enc_64b66b_txsm_bypass ),
           .hssi_10g_tx_pcs_fastpath        		(hssi_10g_tx_pcs_fastpath       ),
           .hssi_10g_tx_pcs_fec_clken       		(hssi_10g_tx_pcs_fec_clken      ),
           .hssi_10g_tx_pcs_fec_enable      		(hssi_10g_tx_pcs_fec_enable     ),
           .hssi_10g_tx_pcs_fifo_double_write  		(hssi_10g_tx_pcs_fifo_double_write ),
           .hssi_10g_tx_pcs_fifo_reg_fast   		(hssi_10g_tx_pcs_fifo_reg_fast  ),
           .hssi_10g_tx_pcs_fifo_stop_rd    		(hssi_10g_tx_pcs_fifo_stop_rd   ),
           .hssi_10g_tx_pcs_fifo_stop_wr    		(hssi_10g_tx_pcs_fifo_stop_wr   ),
           .hssi_10g_tx_pcs_frmgen_burst    		(hssi_10g_tx_pcs_frmgen_burst   ),
           .hssi_10g_tx_pcs_frmgen_bypass   		(hssi_10g_tx_pcs_frmgen_bypass  ),
           .hssi_10g_tx_pcs_frmgen_clken    		(hssi_10g_tx_pcs_frmgen_clken   ),
           .hssi_10g_tx_pcs_frmgen_mfrm_length  		(hssi_10g_tx_pcs_frmgen_mfrm_length ),
           .hssi_10g_tx_pcs_frmgen_pipeln   		(hssi_10g_tx_pcs_frmgen_pipeln  ),
           .hssi_10g_tx_pcs_frmgen_pyld_ins  		(hssi_10g_tx_pcs_frmgen_pyld_ins ),
           .hssi_10g_tx_pcs_frmgen_wordslip  		(hssi_10g_tx_pcs_frmgen_wordslip ),
           .hssi_10g_tx_pcs_full_flag_type  		(hssi_10g_tx_pcs_full_flag_type ),
           .hssi_10g_tx_pcs_gb_pipeln_bypass  		(hssi_10g_tx_pcs_gb_pipeln_bypass ),
           .hssi_10g_tx_pcs_gb_tx_idwidth   		(hssi_10g_tx_pcs_gb_tx_idwidth  ),
           .hssi_10g_tx_pcs_gb_tx_odwidth   		(hssi_10g_tx_pcs_gb_tx_odwidth  ),
           .hssi_10g_tx_pcs_gbred_clken     		(hssi_10g_tx_pcs_gbred_clken    ),
           .hssi_10g_tx_pcs_indv            		(hssi_10g_tx_pcs_indv           ),
           .hssi_10g_tx_pcs_low_latency_en  		(hssi_10g_tx_pcs_low_latency_en ),
           .hssi_10g_tx_pcs_master_clk_sel  		(hssi_10g_tx_pcs_master_clk_sel ),
           .hssi_10g_tx_pcs_pempty_flag_type  		(hssi_10g_tx_pcs_pempty_flag_type ),
           .hssi_10g_tx_pcs_pfull_flag_type  		(hssi_10g_tx_pcs_pfull_flag_type ),
           .hssi_10g_tx_pcs_phcomp_rd_del   		(hssi_10g_tx_pcs_phcomp_rd_del  ),
           .hssi_10g_tx_pcs_pld_if_type     		(hssi_10g_tx_pcs_pld_if_type    ),
           .hssi_10g_tx_pcs_prot_mode       		(hssi_10g_tx_pcs_prot_mode      ),
           .hssi_10g_tx_pcs_pseudo_random   		(hssi_10g_tx_pcs_pseudo_random  ),
           .hssi_10g_tx_pcs_pseudo_seed_a   		(hssi_10g_tx_pcs_pseudo_seed_a  ),
           .hssi_10g_tx_pcs_pseudo_seed_b   		(hssi_10g_tx_pcs_pseudo_seed_b  ),
           .hssi_10g_tx_pcs_random_disp     		(hssi_10g_tx_pcs_random_disp    ),
           .hssi_10g_tx_pcs_rdfifo_clken    		(hssi_10g_tx_pcs_rdfifo_clken   ),
           .hssi_10g_tx_pcs_reconfig_settings  		(hssi_10g_tx_pcs_reconfig_settings ),
           .hssi_10g_tx_pcs_scrm_bypass     		(hssi_10g_tx_pcs_scrm_bypass    ),
           .hssi_10g_tx_pcs_scrm_clken      		(hssi_10g_tx_pcs_scrm_clken     ),
           .hssi_10g_tx_pcs_scrm_mode       		(hssi_10g_tx_pcs_scrm_mode      ),
           .hssi_10g_tx_pcs_scrm_pipeln     		(hssi_10g_tx_pcs_scrm_pipeln    ),
           .hssi_10g_tx_pcs_sh_err          		(hssi_10g_tx_pcs_sh_err         ),
           .hssi_10g_tx_pcs_sop_mark        		(hssi_10g_tx_pcs_sop_mark       ),
           .hssi_10g_tx_pcs_stretch_num_stages  		(hssi_10g_tx_pcs_stretch_num_stages ),
           .hssi_10g_tx_pcs_sup_mode        		(hssi_10g_tx_pcs_sup_mode       ),
           .hssi_10g_tx_pcs_test_mode       		(hssi_10g_tx_pcs_test_mode      ),
           .hssi_10g_tx_pcs_tx_scrm_err     		(hssi_10g_tx_pcs_tx_scrm_err    ),
           .hssi_10g_tx_pcs_tx_scrm_width   		(hssi_10g_tx_pcs_tx_scrm_width  ),
           .hssi_10g_tx_pcs_tx_sh_location  		(hssi_10g_tx_pcs_tx_sh_location ),
           .hssi_10g_tx_pcs_tx_sm_bypass    		(hssi_10g_tx_pcs_tx_sm_bypass   ),
           .hssi_10g_tx_pcs_tx_sm_pipeln    		(hssi_10g_tx_pcs_tx_sm_pipeln   ),
           .hssi_10g_tx_pcs_tx_testbus_sel  		(hssi_10g_tx_pcs_tx_testbus_sel ),
           .hssi_10g_tx_pcs_txfifo_empty    		(hssi_10g_tx_pcs_txfifo_empty   ),
           .hssi_10g_tx_pcs_txfifo_full     		(hssi_10g_tx_pcs_txfifo_full    ),
           .hssi_10g_tx_pcs_txfifo_mode     		(hssi_10g_tx_pcs_txfifo_mode    ),
           .hssi_10g_tx_pcs_txfifo_pempty   		(hssi_10g_tx_pcs_txfifo_pempty  ),
           .hssi_10g_tx_pcs_txfifo_pfull    		(hssi_10g_tx_pcs_txfifo_pfull   ),
           .hssi_10g_tx_pcs_wr_clk_sel      		(hssi_10g_tx_pcs_wr_clk_sel     ),
           .hssi_10g_tx_pcs_wrfifo_clken    		(hssi_10g_tx_pcs_wrfifo_clken   ),
           .hssi_8g_rx_pcs_auto_error_replacement  		(hssi_8g_rx_pcs_auto_error_replacement ),
           .hssi_8g_rx_pcs_auto_speed_nego  		(hssi_8g_rx_pcs_auto_speed_nego ),
           .hssi_8g_rx_pcs_bit_reversal     		(hssi_8g_rx_pcs_bit_reversal    ),
           .hssi_8g_rx_pcs_bonding_dft_en   		(hssi_8g_rx_pcs_bonding_dft_en  ),
           .hssi_8g_rx_pcs_bonding_dft_val  		(hssi_8g_rx_pcs_bonding_dft_val ),
           .hssi_8g_rx_pcs_bypass_pipeline_reg  		(hssi_8g_rx_pcs_bypass_pipeline_reg ),
           .hssi_8g_rx_pcs_byte_deserializer  		(hssi_8g_rx_pcs_byte_deserializer ),
           .hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask  		(hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask ),
           .hssi_8g_rx_pcs_clkcmp_pattern_n  		(hssi_8g_rx_pcs_clkcmp_pattern_n ),
           .hssi_8g_rx_pcs_clkcmp_pattern_p  		(hssi_8g_rx_pcs_clkcmp_pattern_p ),
           .hssi_8g_rx_pcs_clock_gate_bds_dec_asn  		(hssi_8g_rx_pcs_clock_gate_bds_dec_asn ),
           .hssi_8g_rx_pcs_clock_gate_cdr_eidle  		(hssi_8g_rx_pcs_clock_gate_cdr_eidle ),
           .hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_dw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_dw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_dw_wa  		(hssi_8g_rx_pcs_clock_gate_dw_wa ),
           .hssi_8g_rx_pcs_clock_gate_pc_rdclk  		(hssi_8g_rx_pcs_clock_gate_pc_rdclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_sw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_sw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_sw_wa  		(hssi_8g_rx_pcs_clock_gate_sw_wa ),
           .hssi_8g_rx_pcs_clock_observation_in_pld_core  		(hssi_8g_rx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_rx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_rx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_rx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_rx_pcs_eidle_entry_eios  		(hssi_8g_rx_pcs_eidle_entry_eios ),
           .hssi_8g_rx_pcs_eidle_entry_iei  		(hssi_8g_rx_pcs_eidle_entry_iei ),
           .hssi_8g_rx_pcs_eidle_entry_sd   		(hssi_8g_rx_pcs_eidle_entry_sd  ),
           .hssi_8g_rx_pcs_eightb_tenb_decoder  		(hssi_8g_rx_pcs_eightb_tenb_decoder ),
           .hssi_8g_rx_pcs_err_flags_sel    		(hssi_8g_rx_pcs_err_flags_sel   ),
           .hssi_8g_rx_pcs_fixed_pat_det    		(hssi_8g_rx_pcs_fixed_pat_det   ),
           .hssi_8g_rx_pcs_fixed_pat_num    		(hssi_8g_rx_pcs_fixed_pat_num   ),
           .hssi_8g_rx_pcs_force_signal_detect  		(hssi_8g_rx_pcs_force_signal_detect ),
           .hssi_8g_rx_pcs_gen3_clk_en      		(hssi_8g_rx_pcs_gen3_clk_en     ),
           .hssi_8g_rx_pcs_gen3_rx_clk_sel  		(hssi_8g_rx_pcs_gen3_rx_clk_sel ),
           .hssi_8g_rx_pcs_gen3_tx_clk_sel  		(hssi_8g_rx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_rx_pcs_hip_mode         		(hssi_8g_rx_pcs_hip_mode        ),
           .hssi_8g_rx_pcs_ibm_invalid_code  		(hssi_8g_rx_pcs_ibm_invalid_code ),
           .hssi_8g_rx_pcs_invalid_code_flag_only  		(hssi_8g_rx_pcs_invalid_code_flag_only ),
           .hssi_8g_rx_pcs_pad_or_edb_error_replace  		(hssi_8g_rx_pcs_pad_or_edb_error_replace ),
           .hssi_8g_rx_pcs_pcs_bypass       		(hssi_8g_rx_pcs_pcs_bypass      ),
           .hssi_8g_rx_pcs_phase_comp_rdptr  		(hssi_8g_rx_pcs_phase_comp_rdptr ),
           .hssi_8g_rx_pcs_phase_compensation_fifo  		(hssi_8g_rx_pcs_phase_compensation_fifo ),
           .hssi_8g_rx_pcs_pipe_if_enable   		(hssi_8g_rx_pcs_pipe_if_enable  ),
           .hssi_8g_rx_pcs_pma_dw           		(hssi_8g_rx_pcs_pma_dw          ),
           .hssi_8g_rx_pcs_polinv_8b10b_dec  		(hssi_8g_rx_pcs_polinv_8b10b_dec ),
           .hssi_8g_rx_pcs_prot_mode        		(hssi_8g_rx_pcs_prot_mode       ),
           .hssi_8g_rx_pcs_rate_match       		(hssi_8g_rx_pcs_rate_match      ),
           .hssi_8g_rx_pcs_rate_match_del_thres  		(hssi_8g_rx_pcs_rate_match_del_thres ),
           .hssi_8g_rx_pcs_rate_match_empty_thres  		(hssi_8g_rx_pcs_rate_match_empty_thres ),
           .hssi_8g_rx_pcs_rate_match_full_thres  		(hssi_8g_rx_pcs_rate_match_full_thres ),
           .hssi_8g_rx_pcs_rate_match_ins_thres  		(hssi_8g_rx_pcs_rate_match_ins_thres ),
           .hssi_8g_rx_pcs_rate_match_start_thres  		(hssi_8g_rx_pcs_rate_match_start_thres ),
           .hssi_8g_rx_pcs_reconfig_settings  		(hssi_8g_rx_pcs_reconfig_settings ),
           .hssi_8g_rx_pcs_rx_clk2          		(hssi_8g_rx_pcs_rx_clk2         ),
           .hssi_8g_rx_pcs_rx_clk_free_running  		(hssi_8g_rx_pcs_rx_clk_free_running ),
           .hssi_8g_rx_pcs_rx_pcs_urst      		(hssi_8g_rx_pcs_rx_pcs_urst     ),
           .hssi_8g_rx_pcs_rx_rcvd_clk      		(hssi_8g_rx_pcs_rx_rcvd_clk     ),
           .hssi_8g_rx_pcs_rx_rd_clk        		(hssi_8g_rx_pcs_rx_rd_clk       ),
           .hssi_8g_rx_pcs_rx_refclk        		(hssi_8g_rx_pcs_rx_refclk       ),
           .hssi_8g_rx_pcs_rx_wr_clk        		(hssi_8g_rx_pcs_rx_wr_clk       ),
           .hssi_8g_rx_pcs_sup_mode         		(hssi_8g_rx_pcs_sup_mode        ),
           .hssi_8g_rx_pcs_symbol_swap      		(hssi_8g_rx_pcs_symbol_swap     ),
           .hssi_8g_rx_pcs_sync_sm_idle_eios  		(hssi_8g_rx_pcs_sync_sm_idle_eios ),
           .hssi_8g_rx_pcs_test_bus_sel     		(hssi_8g_rx_pcs_test_bus_sel    ),
           .hssi_8g_rx_pcs_tx_rx_parallel_loopback  		(hssi_8g_rx_pcs_tx_rx_parallel_loopback ),
           .hssi_8g_rx_pcs_wa_boundary_lock_ctrl  		(hssi_8g_rx_pcs_wa_boundary_lock_ctrl ),
           .hssi_8g_rx_pcs_wa_clk_slip_spacing  		(hssi_8g_rx_pcs_wa_clk_slip_spacing ),
           .hssi_8g_rx_pcs_wa_det_latency_sync_status_beh  		(hssi_8g_rx_pcs_wa_det_latency_sync_status_beh ),
           .hssi_8g_rx_pcs_wa_disp_err_flag  		(hssi_8g_rx_pcs_wa_disp_err_flag ),
           .hssi_8g_rx_pcs_wa_kchar         		(hssi_8g_rx_pcs_wa_kchar        ),
           .hssi_8g_rx_pcs_wa_pd            		(hssi_8g_rx_pcs_wa_pd           ),
           .hssi_8g_rx_pcs_wa_pd_data       		(hssi_8g_rx_pcs_wa_pd_data      ),
           .hssi_8g_rx_pcs_wa_pd_polarity   		(hssi_8g_rx_pcs_wa_pd_polarity  ),
           .hssi_8g_rx_pcs_wa_pld_controlled  		(hssi_8g_rx_pcs_wa_pld_controlled ),
           .hssi_8g_rx_pcs_wa_renumber_data  		(hssi_8g_rx_pcs_wa_renumber_data ),
           .hssi_8g_rx_pcs_wa_rgnumber_data  		(hssi_8g_rx_pcs_wa_rgnumber_data ),
           .hssi_8g_rx_pcs_wa_rknumber_data  		(hssi_8g_rx_pcs_wa_rknumber_data ),
           .hssi_8g_rx_pcs_wa_rosnumber_data  		(hssi_8g_rx_pcs_wa_rosnumber_data ),
           .hssi_8g_rx_pcs_wa_rvnumber_data  		(hssi_8g_rx_pcs_wa_rvnumber_data ),
           .hssi_8g_rx_pcs_wa_sync_sm_ctrl  		(hssi_8g_rx_pcs_wa_sync_sm_ctrl ),
           .hssi_8g_rx_pcs_wait_cnt         		(hssi_8g_rx_pcs_wait_cnt        ),
           .hssi_8g_tx_pcs_auto_speed_nego_gen2  		(hssi_8g_tx_pcs_auto_speed_nego_gen2 ),
           .hssi_8g_tx_pcs_bit_reversal     		(hssi_8g_tx_pcs_bit_reversal    ),
           .hssi_8g_tx_pcs_bonding_dft_en   		(hssi_8g_tx_pcs_bonding_dft_en  ),
           .hssi_8g_tx_pcs_bonding_dft_val  		(hssi_8g_tx_pcs_bonding_dft_val ),
           .hssi_8g_tx_pcs_bypass_pipeline_reg  		(hssi_8g_tx_pcs_bypass_pipeline_reg ),
           .hssi_8g_tx_pcs_byte_serializer  		(hssi_8g_tx_pcs_byte_serializer ),
           .hssi_8g_tx_pcs_clock_gate_bs_enc  		(hssi_8g_tx_pcs_clock_gate_bs_enc ),
           .hssi_8g_tx_pcs_clock_gate_dw_fifowr  		(hssi_8g_tx_pcs_clock_gate_dw_fifowr ),
           .hssi_8g_tx_pcs_clock_gate_fiford  		(hssi_8g_tx_pcs_clock_gate_fiford ),
           .hssi_8g_tx_pcs_clock_gate_sw_fifowr  		(hssi_8g_tx_pcs_clock_gate_sw_fifowr ),
           .hssi_8g_tx_pcs_clock_observation_in_pld_core  		(hssi_8g_tx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_tx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_tx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_tx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_tx_pcs_data_selection_8b10b_encoder_input  		(hssi_8g_tx_pcs_data_selection_8b10b_encoder_input ),
           .hssi_8g_tx_pcs_dynamic_clk_switch  		(hssi_8g_tx_pcs_dynamic_clk_switch ),
           .hssi_8g_tx_pcs_eightb_tenb_disp_ctrl  		(hssi_8g_tx_pcs_eightb_tenb_disp_ctrl ),
           .hssi_8g_tx_pcs_eightb_tenb_encoder  		(hssi_8g_tx_pcs_eightb_tenb_encoder ),
           .hssi_8g_tx_pcs_force_echar      		(hssi_8g_tx_pcs_force_echar     ),
           .hssi_8g_tx_pcs_force_kchar      		(hssi_8g_tx_pcs_force_kchar     ),
           .hssi_8g_tx_pcs_gen3_tx_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel ),
           .hssi_8g_tx_pcs_hip_mode         		(hssi_8g_tx_pcs_hip_mode        ),
           .hssi_8g_tx_pcs_pcs_bypass       		(hssi_8g_tx_pcs_pcs_bypass      ),
           .hssi_8g_tx_pcs_phase_comp_rdptr  		(hssi_8g_tx_pcs_phase_comp_rdptr ),
           .hssi_8g_tx_pcs_phase_compensation_fifo  		(hssi_8g_tx_pcs_phase_compensation_fifo ),
           .hssi_8g_tx_pcs_phfifo_write_clk_sel  		(hssi_8g_tx_pcs_phfifo_write_clk_sel ),
           .hssi_8g_tx_pcs_pma_dw           		(hssi_8g_tx_pcs_pma_dw          ),
           .hssi_8g_tx_pcs_prot_mode        		(hssi_8g_tx_pcs_prot_mode       ),
           .hssi_8g_tx_pcs_reconfig_settings  		(hssi_8g_tx_pcs_reconfig_settings ),
           .hssi_8g_tx_pcs_refclk_b_clk_sel  		(hssi_8g_tx_pcs_refclk_b_clk_sel ),
           .hssi_8g_tx_pcs_revloop_back_rm  		(hssi_8g_tx_pcs_revloop_back_rm ),
           .hssi_8g_tx_pcs_sup_mode         		(hssi_8g_tx_pcs_sup_mode        ),
           .hssi_8g_tx_pcs_symbol_swap      		(hssi_8g_tx_pcs_symbol_swap     ),
           .hssi_8g_tx_pcs_tx_bitslip       		(hssi_8g_tx_pcs_tx_bitslip      ),
           .hssi_8g_tx_pcs_tx_compliance_controlled_disparity  		(hssi_8g_tx_pcs_tx_compliance_controlled_disparity ),
           .hssi_8g_tx_pcs_tx_fast_pld_reg  		(hssi_8g_tx_pcs_tx_fast_pld_reg ),
           .hssi_8g_tx_pcs_txclk_freerun    		(hssi_8g_tx_pcs_txclk_freerun   ),
           .hssi_8g_tx_pcs_txpcs_urst       		(hssi_8g_tx_pcs_txpcs_urst      ),
           .hssi_common_pcs_pma_interface_asn_clk_enable  		(hssi_common_pcs_pma_interface_asn_clk_enable ),
           .hssi_common_pcs_pma_interface_asn_enable  		(hssi_common_pcs_pma_interface_asn_enable ),
           .hssi_common_pcs_pma_interface_block_sel  		(hssi_common_pcs_pma_interface_block_sel ),
           .hssi_common_pcs_pma_interface_bypass_early_eios  		(hssi_common_pcs_pma_interface_bypass_early_eios ),
           .hssi_common_pcs_pma_interface_bypass_pcie_switch  		(hssi_common_pcs_pma_interface_bypass_pcie_switch ),
           .hssi_common_pcs_pma_interface_bypass_pma_ltr  		(hssi_common_pcs_pma_interface_bypass_pma_ltr ),
           .hssi_common_pcs_pma_interface_bypass_pma_sw_done  		(hssi_common_pcs_pma_interface_bypass_pma_sw_done ),
           .hssi_common_pcs_pma_interface_bypass_ppm_lock  		(hssi_common_pcs_pma_interface_bypass_ppm_lock ),
           .hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp ),
           .hssi_common_pcs_pma_interface_bypass_txdetectrx  		(hssi_common_pcs_pma_interface_bypass_txdetectrx ),
           .hssi_common_pcs_pma_interface_cdr_control  		(hssi_common_pcs_pma_interface_cdr_control ),
           .hssi_common_pcs_pma_interface_cid_enable  		(hssi_common_pcs_pma_interface_cid_enable ),
           .hssi_common_pcs_pma_interface_cp_cons_sel  		(hssi_common_pcs_pma_interface_cp_cons_sel ),
           .hssi_common_pcs_pma_interface_cp_dwn_mstr  		(hssi_common_pcs_pma_interface_cp_dwn_mstr ),
           .hssi_common_pcs_pma_interface_cp_up_mstr  		(hssi_common_pcs_pma_interface_cp_up_mstr ),
           .hssi_common_pcs_pma_interface_ctrl_plane_bonding  		(hssi_common_pcs_pma_interface_ctrl_plane_bonding ),
           .hssi_common_pcs_pma_interface_data_mask_count  		(hssi_common_pcs_pma_interface_data_mask_count ),
           .hssi_common_pcs_pma_interface_data_mask_count_multi  		(hssi_common_pcs_pma_interface_data_mask_count_multi ),
           .hssi_common_pcs_pma_interface_dft_observation_clock_selection  		(hssi_common_pcs_pma_interface_dft_observation_clock_selection ),
           .hssi_common_pcs_pma_interface_early_eios_counter  		(hssi_common_pcs_pma_interface_early_eios_counter ),
           .hssi_common_pcs_pma_interface_force_freqdet  		(hssi_common_pcs_pma_interface_force_freqdet ),
           .hssi_common_pcs_pma_interface_free_run_clk_enable  		(hssi_common_pcs_pma_interface_free_run_clk_enable ),
           .hssi_common_pcs_pma_interface_ignore_sigdet_g23  		(hssi_common_pcs_pma_interface_ignore_sigdet_g23 ),
           .hssi_common_pcs_pma_interface_pc_en_counter  		(hssi_common_pcs_pma_interface_pc_en_counter ),
           .hssi_common_pcs_pma_interface_pc_rst_counter  		(hssi_common_pcs_pma_interface_pc_rst_counter ),
           .hssi_common_pcs_pma_interface_pcie_hip_mode  		(hssi_common_pcs_pma_interface_pcie_hip_mode ),
           .hssi_common_pcs_pma_interface_ph_fifo_reg_mode  		(hssi_common_pcs_pma_interface_ph_fifo_reg_mode ),
           .hssi_common_pcs_pma_interface_phfifo_flush_wait  		(hssi_common_pcs_pma_interface_phfifo_flush_wait ),
           .hssi_common_pcs_pma_interface_pipe_if_g3pcs  		(hssi_common_pcs_pma_interface_pipe_if_g3pcs ),
           .hssi_common_pcs_pma_interface_pma_done_counter  		(hssi_common_pcs_pma_interface_pma_done_counter ),
           .hssi_common_pcs_pma_interface_pma_if_dft_en  		(hssi_common_pcs_pma_interface_pma_if_dft_en ),
           .hssi_common_pcs_pma_interface_pma_if_dft_val  		(hssi_common_pcs_pma_interface_pma_if_dft_val ),
           .hssi_common_pcs_pma_interface_ppm_cnt_rst  		(hssi_common_pcs_pma_interface_ppm_cnt_rst ),
           .hssi_common_pcs_pma_interface_ppm_deassert_early  		(hssi_common_pcs_pma_interface_ppm_deassert_early ),
           .hssi_common_pcs_pma_interface_ppm_det_buckets  		(hssi_common_pcs_pma_interface_ppm_det_buckets ),
           .hssi_common_pcs_pma_interface_ppm_gen1_2_cnt  		(hssi_common_pcs_pma_interface_ppm_gen1_2_cnt ),
           .hssi_common_pcs_pma_interface_ppm_post_eidle_delay  		(hssi_common_pcs_pma_interface_ppm_post_eidle_delay ),
           .hssi_common_pcs_pma_interface_ppmsel  		(hssi_common_pcs_pma_interface_ppmsel ),
           .hssi_common_pcs_pma_interface_prot_mode  		(hssi_common_pcs_pma_interface_prot_mode ),
           .hssi_common_pcs_pma_interface_reconfig_settings  		(hssi_common_pcs_pma_interface_reconfig_settings ),
           .hssi_common_pcs_pma_interface_rxvalid_mask  		(hssi_common_pcs_pma_interface_rxvalid_mask ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter  		(hssi_common_pcs_pma_interface_sigdet_wait_counter ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter_multi  		(hssi_common_pcs_pma_interface_sigdet_wait_counter_multi ),
           .hssi_common_pcs_pma_interface_sim_mode  		(hssi_common_pcs_pma_interface_sim_mode ),
           .hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en  		(hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en ),
           .hssi_common_pcs_pma_interface_sup_mode  		(hssi_common_pcs_pma_interface_sup_mode ),
           .hssi_common_pcs_pma_interface_testout_sel  		(hssi_common_pcs_pma_interface_testout_sel ),
           .hssi_common_pcs_pma_interface_wait_clk_on_off_timer  		(hssi_common_pcs_pma_interface_wait_clk_on_off_timer ),
           .hssi_common_pcs_pma_interface_wait_pipe_synchronizing  		(hssi_common_pcs_pma_interface_wait_pipe_synchronizing ),
           .hssi_common_pcs_pma_interface_wait_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_wait_send_syncp_fbkp ),
           .hssi_common_pld_pcs_interface_dft_clk_out_en  		(hssi_common_pld_pcs_interface_dft_clk_out_en ),
           .hssi_common_pld_pcs_interface_dft_clk_out_sel  		(hssi_common_pld_pcs_interface_dft_clk_out_sel ),
           .hssi_common_pld_pcs_interface_hrdrstctrl_en  		(hssi_common_pld_pcs_interface_hrdrstctrl_en ),
           .hssi_common_pld_pcs_interface_pcs_testbus_block_sel  		(hssi_common_pld_pcs_interface_pcs_testbus_block_sel ),
           .hssi_common_pld_pcs_interface_reconfig_settings  		(hssi_common_pld_pcs_interface_reconfig_settings ),
           .hssi_fifo_rx_pcs_double_read_mode  		(hssi_fifo_rx_pcs_double_read_mode ),
           .hssi_fifo_rx_pcs_prot_mode      		(hssi_fifo_rx_pcs_prot_mode     ),
           .hssi_fifo_tx_pcs_double_write_mode  		(hssi_fifo_tx_pcs_double_write_mode ),
           .hssi_fifo_tx_pcs_prot_mode      		(hssi_fifo_tx_pcs_prot_mode     ),
           .hssi_gen3_rx_pcs_block_sync     		(hssi_gen3_rx_pcs_block_sync    ),
           .hssi_gen3_rx_pcs_block_sync_sm  		(hssi_gen3_rx_pcs_block_sync_sm ),
           .hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn  		(hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn ),
           .hssi_gen3_rx_pcs_lpbk_force     		(hssi_gen3_rx_pcs_lpbk_force    ),
           .hssi_gen3_rx_pcs_mode           		(hssi_gen3_rx_pcs_mode          ),
           .hssi_gen3_rx_pcs_rate_match_fifo  		(hssi_gen3_rx_pcs_rate_match_fifo ),
           .hssi_gen3_rx_pcs_rate_match_fifo_latency  		(hssi_gen3_rx_pcs_rate_match_fifo_latency ),
           .hssi_gen3_rx_pcs_reconfig_settings  		(hssi_gen3_rx_pcs_reconfig_settings ),
           .hssi_gen3_rx_pcs_reverse_lpbk   		(hssi_gen3_rx_pcs_reverse_lpbk  ),
           .hssi_gen3_rx_pcs_rx_b4gb_par_lpbk  		(hssi_gen3_rx_pcs_rx_b4gb_par_lpbk ),
           .hssi_gen3_rx_pcs_rx_force_balign  		(hssi_gen3_rx_pcs_rx_force_balign ),
           .hssi_gen3_rx_pcs_rx_ins_del_one_skip  		(hssi_gen3_rx_pcs_rx_ins_del_one_skip ),
           .hssi_gen3_rx_pcs_rx_num_fixed_pat  		(hssi_gen3_rx_pcs_rx_num_fixed_pat ),
           .hssi_gen3_rx_pcs_rx_test_out_sel  		(hssi_gen3_rx_pcs_rx_test_out_sel ),
           .hssi_gen3_rx_pcs_sup_mode       		(hssi_gen3_rx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_mode           		(hssi_gen3_tx_pcs_mode          ),
           .hssi_gen3_tx_pcs_reverse_lpbk   		(hssi_gen3_tx_pcs_reverse_lpbk  ),
           .hssi_gen3_tx_pcs_sup_mode       		(hssi_gen3_tx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_tx_bitslip     		(hssi_gen3_tx_pcs_tx_bitslip    ),
           .hssi_gen3_tx_pcs_tx_gbox_byp    		(hssi_gen3_tx_pcs_tx_gbox_byp   ),
           .hssi_krfec_rx_pcs_blksync_cor_en  		(hssi_krfec_rx_pcs_blksync_cor_en ),
           .hssi_krfec_rx_pcs_bypass_gb     		(hssi_krfec_rx_pcs_bypass_gb    ),
           .hssi_krfec_rx_pcs_clr_ctrl      		(hssi_krfec_rx_pcs_clr_ctrl     ),
           .hssi_krfec_rx_pcs_ctrl_bit_reverse  		(hssi_krfec_rx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_rx_pcs_data_bit_reverse  		(hssi_krfec_rx_pcs_data_bit_reverse ),
           .hssi_krfec_rx_pcs_dv_start      		(hssi_krfec_rx_pcs_dv_start     ),
           .hssi_krfec_rx_pcs_err_mark_type  		(hssi_krfec_rx_pcs_err_mark_type ),
           .hssi_krfec_rx_pcs_error_marking_en  		(hssi_krfec_rx_pcs_error_marking_en ),
           .hssi_krfec_rx_pcs_low_latency_en  		(hssi_krfec_rx_pcs_low_latency_en ),
           .hssi_krfec_rx_pcs_lpbk_mode     		(hssi_krfec_rx_pcs_lpbk_mode    ),
           .hssi_krfec_rx_pcs_parity_invalid_enum  		(hssi_krfec_rx_pcs_parity_invalid_enum ),
           .hssi_krfec_rx_pcs_parity_valid_num  		(hssi_krfec_rx_pcs_parity_valid_num ),
           .hssi_krfec_rx_pcs_pipeln_blksync  		(hssi_krfec_rx_pcs_pipeln_blksync ),
           .hssi_krfec_rx_pcs_pipeln_descrm  		(hssi_krfec_rx_pcs_pipeln_descrm ),
           .hssi_krfec_rx_pcs_pipeln_errcorrect  		(hssi_krfec_rx_pcs_pipeln_errcorrect ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_ind  		(hssi_krfec_rx_pcs_pipeln_errtrap_ind ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_lfsr  		(hssi_krfec_rx_pcs_pipeln_errtrap_lfsr ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_loc  		(hssi_krfec_rx_pcs_pipeln_errtrap_loc ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_pat  		(hssi_krfec_rx_pcs_pipeln_errtrap_pat ),
           .hssi_krfec_rx_pcs_pipeln_gearbox  		(hssi_krfec_rx_pcs_pipeln_gearbox ),
           .hssi_krfec_rx_pcs_pipeln_syndrm  		(hssi_krfec_rx_pcs_pipeln_syndrm ),
           .hssi_krfec_rx_pcs_pipeln_trans_dec  		(hssi_krfec_rx_pcs_pipeln_trans_dec ),
           .hssi_krfec_rx_pcs_prot_mode     		(hssi_krfec_rx_pcs_prot_mode    ),
           .hssi_krfec_rx_pcs_receive_order  		(hssi_krfec_rx_pcs_receive_order ),
           .hssi_krfec_rx_pcs_reconfig_settings  		(hssi_krfec_rx_pcs_reconfig_settings ),
           .hssi_krfec_rx_pcs_rx_testbus_sel  		(hssi_krfec_rx_pcs_rx_testbus_sel ),
           .hssi_krfec_rx_pcs_signal_ok_en  		(hssi_krfec_rx_pcs_signal_ok_en ),
           .hssi_krfec_rx_pcs_sup_mode      		(hssi_krfec_rx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_burst_err     		(hssi_krfec_tx_pcs_burst_err    ),
           .hssi_krfec_tx_pcs_burst_err_len  		(hssi_krfec_tx_pcs_burst_err_len ),
           .hssi_krfec_tx_pcs_ctrl_bit_reverse  		(hssi_krfec_tx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_tx_pcs_data_bit_reverse  		(hssi_krfec_tx_pcs_data_bit_reverse ),
           .hssi_krfec_tx_pcs_enc_frame_query  		(hssi_krfec_tx_pcs_enc_frame_query ),
           .hssi_krfec_tx_pcs_low_latency_en  		(hssi_krfec_tx_pcs_low_latency_en ),
           .hssi_krfec_tx_pcs_pipeln_encoder  		(hssi_krfec_tx_pcs_pipeln_encoder ),
           .hssi_krfec_tx_pcs_pipeln_scrambler  		(hssi_krfec_tx_pcs_pipeln_scrambler ),
           .hssi_krfec_tx_pcs_prot_mode     		(hssi_krfec_tx_pcs_prot_mode    ),
           .hssi_krfec_tx_pcs_sup_mode      		(hssi_krfec_tx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_transcode_err  		(hssi_krfec_tx_pcs_transcode_err ),
           .hssi_krfec_tx_pcs_transmit_order  		(hssi_krfec_tx_pcs_transmit_order ),
           .hssi_krfec_tx_pcs_tx_testbus_sel  		(hssi_krfec_tx_pcs_tx_testbus_sel ),
           .hssi_pipe_gen1_2_elec_idle_delay_val  		(hssi_pipe_gen1_2_elec_idle_delay_val ),
           .hssi_pipe_gen1_2_error_replace_pad  		(hssi_pipe_gen1_2_error_replace_pad ),
           .hssi_pipe_gen1_2_hip_mode       		(hssi_pipe_gen1_2_hip_mode      ),
           .hssi_pipe_gen1_2_ind_error_reporting  		(hssi_pipe_gen1_2_ind_error_reporting ),
           .hssi_pipe_gen1_2_phystatus_delay_val  		(hssi_pipe_gen1_2_phystatus_delay_val ),
           .hssi_pipe_gen1_2_phystatus_rst_toggle  		(hssi_pipe_gen1_2_phystatus_rst_toggle ),
           .hssi_pipe_gen1_2_pipe_byte_de_serializer_en  		(hssi_pipe_gen1_2_pipe_byte_de_serializer_en ),
           .hssi_pipe_gen1_2_prot_mode      		(hssi_pipe_gen1_2_prot_mode     ),
           .hssi_pipe_gen1_2_reconfig_settings  		(hssi_pipe_gen1_2_reconfig_settings ),
           .hssi_pipe_gen1_2_rx_pipe_enable  		(hssi_pipe_gen1_2_rx_pipe_enable ),
           .hssi_pipe_gen1_2_rxdetect_bypass  		(hssi_pipe_gen1_2_rxdetect_bypass ),
           .hssi_pipe_gen1_2_sup_mode       		(hssi_pipe_gen1_2_sup_mode      ),
           .hssi_pipe_gen1_2_tx_pipe_enable  		(hssi_pipe_gen1_2_tx_pipe_enable ),
           .hssi_pipe_gen1_2_txswing        		(hssi_pipe_gen1_2_txswing       ),
           .hssi_pipe_gen3_bypass_rx_detection_enable  		(hssi_pipe_gen3_bypass_rx_detection_enable ),
           .hssi_pipe_gen3_bypass_rx_preset  		(hssi_pipe_gen3_bypass_rx_preset ),
           .hssi_pipe_gen3_bypass_rx_preset_enable  		(hssi_pipe_gen3_bypass_rx_preset_enable ),
           .hssi_pipe_gen3_bypass_tx_coefficent  		(hssi_pipe_gen3_bypass_tx_coefficent ),
           .hssi_pipe_gen3_bypass_tx_coefficent_enable  		(hssi_pipe_gen3_bypass_tx_coefficent_enable ),
           .hssi_pipe_gen3_elecidle_delay_g3  		(hssi_pipe_gen3_elecidle_delay_g3 ),
           .hssi_pipe_gen3_ind_error_reporting  		(hssi_pipe_gen3_ind_error_reporting ),
           .hssi_pipe_gen3_mode             		(hssi_pipe_gen3_mode            ),
           .hssi_pipe_gen3_phy_status_delay_g12  		(hssi_pipe_gen3_phy_status_delay_g12 ),
           .hssi_pipe_gen3_phy_status_delay_g3  		(hssi_pipe_gen3_phy_status_delay_g3 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g12  		(hssi_pipe_gen3_phystatus_rst_toggle_g12 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g3  		(hssi_pipe_gen3_phystatus_rst_toggle_g3 ),
           .hssi_pipe_gen3_rate_match_pad_insertion  		(hssi_pipe_gen3_rate_match_pad_insertion ),
           .hssi_pipe_gen3_sup_mode         		(hssi_pipe_gen3_sup_mode        ),
           .hssi_pipe_gen3_test_out_sel     		(hssi_pipe_gen3_test_out_sel    ),
           .hssi_rx_pcs_pma_interface_block_sel  		(hssi_rx_pcs_pma_interface_block_sel ),
           .hssi_rx_pcs_pma_interface_channel_operation_mode  		(hssi_rx_pcs_pma_interface_channel_operation_mode ),
           .hssi_rx_pcs_pma_interface_clkslip_sel  		(hssi_rx_pcs_pma_interface_clkslip_sel ),
           .hssi_rx_pcs_pma_interface_lpbk_en  		(hssi_rx_pcs_pma_interface_lpbk_en ),
           .hssi_rx_pcs_pma_interface_master_clk_sel  		(hssi_rx_pcs_pma_interface_master_clk_sel ),
           .hssi_rx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_rx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_rx_pcs_pma_interface_pma_dw_rx  		(hssi_rx_pcs_pma_interface_pma_dw_rx ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_en  		(hssi_rx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_val  		(hssi_rx_pcs_pma_interface_pma_if_dft_val ),
           .hssi_rx_pcs_pma_interface_prbs9_dwidth  		(hssi_rx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_rx_pcs_pma_interface_prbs_clken  		(hssi_rx_pcs_pma_interface_prbs_clken ),
           .hssi_rx_pcs_pma_interface_prbs_ver  		(hssi_rx_pcs_pma_interface_prbs_ver ),
           .hssi_rx_pcs_pma_interface_prot_mode_rx  		(hssi_rx_pcs_pma_interface_prot_mode_rx ),
           .hssi_rx_pcs_pma_interface_reconfig_settings  		(hssi_rx_pcs_pma_interface_reconfig_settings ),
           .hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_lpbk_en ),
           .hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok  		(hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mask  		(hssi_rx_pcs_pma_interface_rx_prbs_mask ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mode  		(hssi_rx_pcs_pma_interface_rx_prbs_mode ),
           .hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel  		(hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel ),
           .hssi_rx_pcs_pma_interface_rx_static_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_static_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en ),
           .hssi_rx_pcs_pma_interface_sup_mode  		(hssi_rx_pcs_pma_interface_sup_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_rx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_rx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_rx_pld_pcs_interface_pcs_rx_block_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_block_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en  		(hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en ),
           .hssi_rx_pld_pcs_interface_pcs_rx_output_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_output_sel ),
           .hssi_rx_pld_pcs_interface_reconfig_settings  		(hssi_rx_pld_pcs_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_bypass_pma_txelecidle  		(hssi_tx_pcs_pma_interface_bypass_pma_txelecidle ),
           .hssi_tx_pcs_pma_interface_channel_operation_mode  		(hssi_tx_pcs_pma_interface_channel_operation_mode ),
           .hssi_tx_pcs_pma_interface_lpbk_en  		(hssi_tx_pcs_pma_interface_lpbk_en ),
           .hssi_tx_pcs_pma_interface_master_clk_sel  		(hssi_tx_pcs_pma_interface_master_clk_sel ),
           .hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx  		(hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_tx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_tx_pcs_pma_interface_pma_dw_tx  		(hssi_tx_pcs_pma_interface_pma_dw_tx ),
           .hssi_tx_pcs_pma_interface_pma_if_dft_en  		(hssi_tx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_tx_pcs_pma_interface_pmagate_en  		(hssi_tx_pcs_pma_interface_pmagate_en ),
           .hssi_tx_pcs_pma_interface_prbs9_dwidth  		(hssi_tx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_tx_pcs_pma_interface_prbs_clken  		(hssi_tx_pcs_pma_interface_prbs_clken ),
           .hssi_tx_pcs_pma_interface_prbs_gen_pat  		(hssi_tx_pcs_pma_interface_prbs_gen_pat ),
           .hssi_tx_pcs_pma_interface_prot_mode_tx  		(hssi_tx_pcs_pma_interface_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_reconfig_settings  		(hssi_tx_pcs_pma_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_sq_wave_num  		(hssi_tx_pcs_pma_interface_sq_wave_num ),
           .hssi_tx_pcs_pma_interface_sqwgen_clken  		(hssi_tx_pcs_pma_interface_sqwgen_clken ),
           .hssi_tx_pcs_pma_interface_sup_mode  		(hssi_tx_pcs_pma_interface_sup_mode ),
           .hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_tx_pma_data_sel  		(hssi_tx_pcs_pma_interface_tx_pma_data_sel ),
           .hssi_tx_pcs_pma_interface_tx_static_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_static_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period  		(hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable  		(hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control ),
           .hssi_tx_pcs_pma_interface_uhsif_enable  		(hssi_tx_pcs_pma_interface_uhsif_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value ),
           .hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_tx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_tx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding  		(hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_source  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_data_source  		(hssi_tx_pld_pcs_interface_pcs_tx_data_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_output_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_output_sel ),
           .hssi_tx_pld_pcs_interface_reconfig_settings  		(hssi_tx_pld_pcs_interface_reconfig_settings ),
           .avmm_interfaces                 		(avmm_interfaces                ),
           .rcfg_enable                     		(rcfg_enable                    ),
           .enable_avmm                     		(enable_avmm                    ),
           .arbiter_ctrl                    		(arbiter_ctrl                   ),
           .calibration_en                  		(calibration_en                 ),
           .avmm_busy_en                    		(avmm_busy_en                   ),
           .hip_cal_en                      		(hip_cal_en                     ),
           .cal_done                        		(cal_done                       )
                  )
               twentynm_xcvr_native_inst(.*);
             end


  "20nm5":   begin
               twentynm_xcvr_native_rev_20nm5
                 #(
			
           .bonded_lanes                    		(bonded_lanes                   ),
           .bonding_master_ch               		(bonding_master_ch              ),
           .xcvr_native_mode                		(xcvr_native_mode               ),
           .pma_adapt_adapt_mode            		(pma_adapt_adapt_mode           ),
           .pma_adapt_adp_1s_ctle_bypass    		(pma_adapt_adp_1s_ctle_bypass   ),
           .pma_adapt_adp_4s_ctle_bypass    		(pma_adapt_adp_4s_ctle_bypass   ),
           .pma_adapt_adp_ctle_adapt_cycle_window  		(pma_adapt_adp_ctle_adapt_cycle_window ),
           .pma_adapt_adp_ctle_en           		(pma_adapt_adp_ctle_en          ),
           .pma_adapt_adp_dfe_fltap_bypass  		(pma_adapt_adp_dfe_fltap_bypass ),
           .pma_adapt_adp_dfe_fltap_en      		(pma_adapt_adp_dfe_fltap_en     ),
           .pma_adapt_adp_dfe_fxtap_bypass  		(pma_adapt_adp_dfe_fxtap_bypass ),
           .pma_adapt_adp_dfe_fxtap_en      		(pma_adapt_adp_dfe_fxtap_en     ),
           .pma_adapt_adp_dfe_fxtap_hold_en  		(pma_adapt_adp_dfe_fxtap_hold_en ),
           .pma_adapt_adp_dfe_mode          		(pma_adapt_adp_dfe_mode         ),
           .pma_adapt_adp_mode              		(pma_adapt_adp_mode             ),
           .pma_adapt_adp_onetime_dfe       		(pma_adapt_adp_onetime_dfe      ),
           .pma_adapt_adp_vga_bypass        		(pma_adapt_adp_vga_bypass       ),
           .pma_adapt_adp_vga_en            		(pma_adapt_adp_vga_en           ),
           .pma_adapt_adp_vref_bypass       		(pma_adapt_adp_vref_bypass      ),
           .pma_adapt_adp_vref_en           		(pma_adapt_adp_vref_en          ),
           .pma_adapt_datarate              		(pma_adapt_datarate             ),
           .pma_adapt_odi_dfe_spec_en       		(pma_adapt_odi_dfe_spec_en      ),
           .pma_adapt_prot_mode             		(pma_adapt_prot_mode            ),
           .pma_adapt_sup_mode              		(pma_adapt_sup_mode             ),
           .pma_cdr_refclk_inclk0_logical_to_physical_mapping  		(pma_cdr_refclk_inclk0_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk1_logical_to_physical_mapping  		(pma_cdr_refclk_inclk1_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk2_logical_to_physical_mapping  		(pma_cdr_refclk_inclk2_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk3_logical_to_physical_mapping  		(pma_cdr_refclk_inclk3_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk4_logical_to_physical_mapping  		(pma_cdr_refclk_inclk4_logical_to_physical_mapping ),
           .pma_cdr_refclk_powerdown_mode   		(pma_cdr_refclk_powerdown_mode  ),
           .pma_cdr_refclk_refclk_select    		(pma_cdr_refclk_refclk_select   ),
           .cdr_pll_atb_select_control      		(cdr_pll_atb_select_control     ),
           .cdr_pll_auto_reset_on           		(cdr_pll_auto_reset_on          ),
           .cdr_pll_bbpd_data_pattern_filter_select  		(cdr_pll_bbpd_data_pattern_filter_select ),
           .cdr_pll_bw_sel                  		(cdr_pll_bw_sel                 ),
           .cdr_pll_cal_vco_count_length    		(cdr_pll_cal_vco_count_length   ),
           .cdr_pll_cdr_odi_select          		(cdr_pll_cdr_odi_select         ),
           .cdr_pll_cdr_phaselock_mode      		(cdr_pll_cdr_phaselock_mode     ),
           .cdr_pll_cdr_powerdown_mode      		(cdr_pll_cdr_powerdown_mode     ),
           .cdr_pll_cgb_div                 		(cdr_pll_cgb_div                ),
           .cdr_pll_chgpmp_current_dn_pd    		(cdr_pll_chgpmp_current_dn_pd   ),
           .cdr_pll_chgpmp_current_dn_trim  		(cdr_pll_chgpmp_current_dn_trim ),
           .cdr_pll_chgpmp_current_pd       		(cdr_pll_chgpmp_current_pd      ),
           .cdr_pll_chgpmp_current_pfd      		(cdr_pll_chgpmp_current_pfd     ),
           .cdr_pll_chgpmp_current_up_pd    		(cdr_pll_chgpmp_current_up_pd   ),
           .cdr_pll_chgpmp_current_up_trim  		(cdr_pll_chgpmp_current_up_trim ),
           .cdr_pll_chgpmp_dn_pd_trim_double  		(cdr_pll_chgpmp_dn_pd_trim_double ),
           .cdr_pll_chgpmp_replicate        		(cdr_pll_chgpmp_replicate       ),
           .cdr_pll_chgpmp_testmode         		(cdr_pll_chgpmp_testmode        ),
           .cdr_pll_chgpmp_up_pd_trim_double  		(cdr_pll_chgpmp_up_pd_trim_double ),
           .cdr_pll_clklow_mux_select       		(cdr_pll_clklow_mux_select      ),
           .cdr_pll_datarate                		(cdr_pll_datarate               ),
           .cdr_pll_diag_loopback_enable    		(cdr_pll_diag_loopback_enable   ),
           .cdr_pll_disable_up_dn           		(cdr_pll_disable_up_dn          ),
           .cdr_pll_fb_select               		(cdr_pll_fb_select              ),
           .cdr_pll_fref_clklow_div         		(cdr_pll_fref_clklow_div        ),
           .cdr_pll_fref_mux_select         		(cdr_pll_fref_mux_select        ),
           .cdr_pll_gpon_lck2ref_control    		(cdr_pll_gpon_lck2ref_control   ),
           .cdr_pll_initial_settings        		(cdr_pll_initial_settings       ),
           .cdr_pll_iqclk_mux_sel           		(cdr_pll_iqclk_mux_sel          ),
           .cdr_pll_is_cascaded_pll         		(cdr_pll_is_cascaded_pll        ),
           .cdr_pll_lck2ref_delay_control   		(cdr_pll_lck2ref_delay_control  ),
           .cdr_pll_lf_resistor_pd          		(cdr_pll_lf_resistor_pd         ),
           .cdr_pll_lf_resistor_pfd         		(cdr_pll_lf_resistor_pfd        ),
           .cdr_pll_lf_ripple_cap           		(cdr_pll_lf_ripple_cap          ),
           .cdr_pll_loop_filter_bias_select  		(cdr_pll_loop_filter_bias_select ),
           .cdr_pll_loopback_mode           		(cdr_pll_loopback_mode          ),
           .cdr_pll_lpd_counter             		(cdr_pll_lpd_counter            ),
           .cdr_pll_lpfd_counter            		(cdr_pll_lpfd_counter           ),
           .cdr_pll_ltd_ltr_micro_controller_select  		(cdr_pll_ltd_ltr_micro_controller_select ),
           .cdr_pll_m_counter               		(cdr_pll_m_counter              ),
           .cdr_pll_n_counter               		(cdr_pll_n_counter              ),
           .cdr_pll_n_counter_scratch       		(cdr_pll_n_counter_scratch      ),
           .cdr_pll_output_clock_frequency  		(cdr_pll_output_clock_frequency ),
           .cdr_pll_pcie_gen                		(cdr_pll_pcie_gen               ),
           .cdr_pll_pd_fastlock_mode        		(cdr_pll_pd_fastlock_mode       ),
           .cdr_pll_pd_l_counter            		(cdr_pll_pd_l_counter           ),
           .cdr_pll_pfd_l_counter           		(cdr_pll_pfd_l_counter          ),
           .cdr_pll_pma_width               		(cdr_pll_pma_width              ),
           .cdr_pll_primary_use             		(cdr_pll_primary_use            ),
           .cdr_pll_prot_mode               		(cdr_pll_prot_mode              ),
           .cdr_pll_reference_clock_frequency  		(cdr_pll_reference_clock_frequency ),
           .cdr_pll_reverse_serial_loopback  		(cdr_pll_reverse_serial_loopback ),
           .cdr_pll_set_cdr_input_freq_range  		(cdr_pll_set_cdr_input_freq_range ),
           .cdr_pll_set_cdr_v2i_enable      		(cdr_pll_set_cdr_v2i_enable     ),
           .cdr_pll_set_cdr_vco_reset       		(cdr_pll_set_cdr_vco_reset      ),
           .cdr_pll_set_cdr_vco_speed       		(cdr_pll_set_cdr_vco_speed      ),
           .cdr_pll_set_cdr_vco_speed_fix   		(cdr_pll_set_cdr_vco_speed_fix  ),
           .cdr_pll_set_cdr_vco_speed_pciegen3  		(cdr_pll_set_cdr_vco_speed_pciegen3 ),
           .cdr_pll_sup_mode                		(cdr_pll_sup_mode               ),
           .cdr_pll_tx_pll_prot_mode        		(cdr_pll_tx_pll_prot_mode       ),
           .cdr_pll_txpll_hclk_driver_enable  		(cdr_pll_txpll_hclk_driver_enable ),
           .cdr_pll_uc_ro_cal               		(cdr_pll_uc_ro_cal              ),
           .cdr_pll_vco_freq                		(cdr_pll_vco_freq               ),
           .cdr_pll_vco_overrange_voltage   		(cdr_pll_vco_overrange_voltage  ),
           .cdr_pll_vco_underrange_voltage  		(cdr_pll_vco_underrange_voltage ),
           .pma_rx_buf_bypass_eqz_stages_234  		(pma_rx_buf_bypass_eqz_stages_234 ),
           .pma_rx_buf_datarate             		(pma_rx_buf_datarate            ),
           .pma_rx_buf_diag_lp_en           		(pma_rx_buf_diag_lp_en          ),
           .pma_rx_buf_loopback_modes       		(pma_rx_buf_loopback_modes      ),
           .pma_rx_buf_pm_tx_rx_cvp_mode    		(pma_rx_buf_pm_tx_rx_cvp_mode   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen    		(pma_rx_buf_pm_tx_rx_pcie_gen   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth  		(pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth ),
           .pma_rx_buf_prot_mode            		(pma_rx_buf_prot_mode           ),
           .pma_rx_buf_qpi_enable           		(pma_rx_buf_qpi_enable          ),
           .pma_rx_buf_refclk_en            		(pma_rx_buf_refclk_en           ),
           .pma_rx_buf_rx_refclk_divider    		(pma_rx_buf_rx_refclk_divider   ),
           .pma_rx_buf_sup_mode             		(pma_rx_buf_sup_mode            ),
           .pma_rx_buf_xrx_path_datarate    		(pma_rx_buf_xrx_path_datarate   ),
           .pma_rx_buf_xrx_path_datawidth   		(pma_rx_buf_xrx_path_datawidth  ),
           .pma_rx_buf_xrx_path_pma_rx_divclk_hz  		(pma_rx_buf_xrx_path_pma_rx_divclk_hz ),
           .pma_rx_buf_xrx_path_prot_mode   		(pma_rx_buf_xrx_path_prot_mode  ),
           .pma_rx_buf_xrx_path_sup_mode    		(pma_rx_buf_xrx_path_sup_mode   ),
           .pma_rx_buf_xrx_path_uc_cal_enable  		(pma_rx_buf_xrx_path_uc_cal_enable ),
           .pma_rx_deser_bitslip_bypass     		(pma_rx_deser_bitslip_bypass    ),
           .pma_rx_deser_clkdiv_source      		(pma_rx_deser_clkdiv_source     ),
           .pma_rx_deser_clkdivrx_user_mode  		(pma_rx_deser_clkdivrx_user_mode ),
           .pma_rx_deser_datarate           		(pma_rx_deser_datarate          ),
           .pma_rx_deser_deser_factor       		(pma_rx_deser_deser_factor      ),
           .pma_rx_deser_force_clkdiv_for_testing  		(pma_rx_deser_force_clkdiv_for_testing ),
           .pma_rx_deser_pcie_gen           		(pma_rx_deser_pcie_gen          ),
           .pma_rx_deser_pcie_gen_bitwidth  		(pma_rx_deser_pcie_gen_bitwidth ),
           .pma_rx_deser_prot_mode          		(pma_rx_deser_prot_mode         ),
           .pma_rx_deser_rst_n_adapt_odi    		(pma_rx_deser_rst_n_adapt_odi   ),
           .pma_rx_deser_sdclk_enable       		(pma_rx_deser_sdclk_enable      ),
           .pma_rx_deser_sup_mode           		(pma_rx_deser_sup_mode          ),
           .pma_rx_dfe_datarate             		(pma_rx_dfe_datarate            ),
           .pma_rx_dfe_dft_en               		(pma_rx_dfe_dft_en              ),
           .pma_rx_dfe_pdb                  		(pma_rx_dfe_pdb                 ),
           .pma_rx_dfe_pdb_fixedtap         		(pma_rx_dfe_pdb_fixedtap        ),
           .pma_rx_dfe_pdb_floattap         		(pma_rx_dfe_pdb_floattap        ),
           .pma_rx_dfe_pdb_fxtap4t7         		(pma_rx_dfe_pdb_fxtap4t7        ),
           .pma_rx_dfe_prot_mode            		(pma_rx_dfe_prot_mode           ),
           .pma_rx_dfe_sup_mode             		(pma_rx_dfe_sup_mode            ),
           .pma_rx_odi_datarate             		(pma_rx_odi_datarate            ),
           .pma_rx_odi_prot_mode            		(pma_rx_odi_prot_mode           ),
           .pma_rx_odi_step_ctrl_sel        		(pma_rx_odi_step_ctrl_sel       ),
           .pma_rx_odi_sup_mode             		(pma_rx_odi_sup_mode            ),
           .pma_rx_sd_prot_mode             		(pma_rx_sd_prot_mode            ),
           .pma_rx_sd_sd_output_off         		(pma_rx_sd_sd_output_off        ),
           .pma_rx_sd_sd_output_on          		(pma_rx_sd_sd_output_on         ),
           .pma_rx_sd_sd_pdb                		(pma_rx_sd_sd_pdb               ),
           .pma_rx_sd_sup_mode              		(pma_rx_sd_sup_mode             ),
           .pma_tx_buf_datarate             		(pma_tx_buf_datarate            ),
           .pma_tx_buf_mcgb_location_for_pcie  		(pma_tx_buf_mcgb_location_for_pcie ),
           .pma_tx_buf_prot_mode            		(pma_tx_buf_prot_mode           ),
           .pma_tx_buf_rx_det               		(pma_tx_buf_rx_det              ),
           .pma_tx_buf_rx_det_output_sel    		(pma_tx_buf_rx_det_output_sel   ),
           .pma_tx_buf_rx_det_pdb           		(pma_tx_buf_rx_det_pdb          ),
           .pma_tx_buf_sup_mode             		(pma_tx_buf_sup_mode            ),
           .pma_tx_buf_user_fir_coeff_ctrl_sel  		(pma_tx_buf_user_fir_coeff_ctrl_sel ),
           .pma_tx_buf_xtx_path_clock_divider_ratio  		(pma_tx_buf_xtx_path_clock_divider_ratio ),
           .pma_tx_buf_xtx_path_datarate    		(pma_tx_buf_xtx_path_datarate   ),
           .pma_tx_buf_xtx_path_datawidth   		(pma_tx_buf_xtx_path_datawidth  ),
           .pma_tx_buf_xtx_path_pma_tx_divclk_hz  		(pma_tx_buf_xtx_path_pma_tx_divclk_hz ),
           .pma_tx_buf_xtx_path_prot_mode   		(pma_tx_buf_xtx_path_prot_mode  ),
           .pma_tx_buf_xtx_path_sup_mode    		(pma_tx_buf_xtx_path_sup_mode   ),
           .pma_tx_buf_xtx_path_tx_pll_clk_hz  		(pma_tx_buf_xtx_path_tx_pll_clk_hz ),
           .pma_cgb_bitslip_enable          		(pma_cgb_bitslip_enable         ),
           .pma_cgb_bonding_reset_enable    		(pma_cgb_bonding_reset_enable   ),
           .pma_cgb_datarate                		(pma_cgb_datarate               ),
           .pma_cgb_input_select_gen3       		(pma_cgb_input_select_gen3      ),
           .pma_cgb_input_select_x1         		(pma_cgb_input_select_x1        ),
           .pma_cgb_input_select_xn         		(pma_cgb_input_select_xn        ),
           .pma_cgb_pcie_gen3_bitwidth      		(pma_cgb_pcie_gen3_bitwidth     ),
           .pma_cgb_prot_mode               		(pma_cgb_prot_mode              ),
           .pma_cgb_scratch0_x1_clock_src   		(pma_cgb_scratch0_x1_clock_src  ),
           .pma_cgb_scratch1_x1_clock_src   		(pma_cgb_scratch1_x1_clock_src  ),
           .pma_cgb_scratch2_x1_clock_src   		(pma_cgb_scratch2_x1_clock_src  ),
           .pma_cgb_scratch3_x1_clock_src   		(pma_cgb_scratch3_x1_clock_src  ),
           .pma_cgb_select_done_master_or_slave  		(pma_cgb_select_done_master_or_slave ),
           .pma_cgb_ser_mode                		(pma_cgb_ser_mode               ),
           .pma_cgb_sup_mode                		(pma_cgb_sup_mode               ),
           .pma_cgb_tx_ucontrol_en          		(pma_cgb_tx_ucontrol_en         ),
           .pma_cgb_x1_div_m_sel            		(pma_cgb_x1_div_m_sel           ),
           .pma_tx_ser_prot_mode            		(pma_tx_ser_prot_mode           ),
           .pma_tx_ser_ser_clk_divtx_user_sel  		(pma_tx_ser_ser_clk_divtx_user_sel ),
           .pma_tx_ser_sup_mode             		(pma_tx_ser_sup_mode            ),
           .hssi_10g_rx_pcs_advanced_user_mode  		(hssi_10g_rx_pcs_advanced_user_mode ),
           .hssi_10g_rx_pcs_align_del       		(hssi_10g_rx_pcs_align_del      ),
           .hssi_10g_rx_pcs_ber_bit_err_total_cnt  		(hssi_10g_rx_pcs_ber_bit_err_total_cnt ),
           .hssi_10g_rx_pcs_ber_clken       		(hssi_10g_rx_pcs_ber_clken      ),
           .hssi_10g_rx_pcs_ber_xus_timer_window  		(hssi_10g_rx_pcs_ber_xus_timer_window ),
           .hssi_10g_rx_pcs_bitslip_mode    		(hssi_10g_rx_pcs_bitslip_mode   ),
           .hssi_10g_rx_pcs_blksync_bitslip_type  		(hssi_10g_rx_pcs_blksync_bitslip_type ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_cnt  		(hssi_10g_rx_pcs_blksync_bitslip_wait_cnt ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_type  		(hssi_10g_rx_pcs_blksync_bitslip_wait_type ),
           .hssi_10g_rx_pcs_blksync_bypass  		(hssi_10g_rx_pcs_blksync_bypass ),
           .hssi_10g_rx_pcs_blksync_clken   		(hssi_10g_rx_pcs_blksync_clken  ),
           .hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt  		(hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock ),
           .hssi_10g_rx_pcs_blksync_pipeln  		(hssi_10g_rx_pcs_blksync_pipeln ),
           .hssi_10g_rx_pcs_clr_errblk_cnt_en  		(hssi_10g_rx_pcs_clr_errblk_cnt_en ),
           .hssi_10g_rx_pcs_control_del     		(hssi_10g_rx_pcs_control_del    ),
           .hssi_10g_rx_pcs_crcchk_bypass   		(hssi_10g_rx_pcs_crcchk_bypass  ),
           .hssi_10g_rx_pcs_crcchk_clken    		(hssi_10g_rx_pcs_crcchk_clken   ),
           .hssi_10g_rx_pcs_crcchk_inv      		(hssi_10g_rx_pcs_crcchk_inv     ),
           .hssi_10g_rx_pcs_crcchk_pipeln   		(hssi_10g_rx_pcs_crcchk_pipeln  ),
           .hssi_10g_rx_pcs_crcflag_pipeln  		(hssi_10g_rx_pcs_crcflag_pipeln ),
           .hssi_10g_rx_pcs_ctrl_bit_reverse  		(hssi_10g_rx_pcs_ctrl_bit_reverse ),
           .hssi_10g_rx_pcs_data_bit_reverse  		(hssi_10g_rx_pcs_data_bit_reverse ),
           .hssi_10g_rx_pcs_dec64b66b_clken  		(hssi_10g_rx_pcs_dec64b66b_clken ),
           .hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass  		(hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass ),
           .hssi_10g_rx_pcs_descrm_bypass   		(hssi_10g_rx_pcs_descrm_bypass  ),
           .hssi_10g_rx_pcs_descrm_clken    		(hssi_10g_rx_pcs_descrm_clken   ),
           .hssi_10g_rx_pcs_descrm_mode     		(hssi_10g_rx_pcs_descrm_mode    ),
           .hssi_10g_rx_pcs_descrm_pipeln   		(hssi_10g_rx_pcs_descrm_pipeln  ),
           .hssi_10g_rx_pcs_dft_clk_out_sel  		(hssi_10g_rx_pcs_dft_clk_out_sel ),
           .hssi_10g_rx_pcs_dis_signal_ok   		(hssi_10g_rx_pcs_dis_signal_ok  ),
           .hssi_10g_rx_pcs_dispchk_bypass  		(hssi_10g_rx_pcs_dispchk_bypass ),
           .hssi_10g_rx_pcs_empty_flag_type  		(hssi_10g_rx_pcs_empty_flag_type ),
           .hssi_10g_rx_pcs_fast_path       		(hssi_10g_rx_pcs_fast_path      ),
           .hssi_10g_rx_pcs_fec_clken       		(hssi_10g_rx_pcs_fec_clken      ),
           .hssi_10g_rx_pcs_fec_enable      		(hssi_10g_rx_pcs_fec_enable     ),
           .hssi_10g_rx_pcs_fifo_double_read  		(hssi_10g_rx_pcs_fifo_double_read ),
           .hssi_10g_rx_pcs_fifo_stop_rd    		(hssi_10g_rx_pcs_fifo_stop_rd   ),
           .hssi_10g_rx_pcs_fifo_stop_wr    		(hssi_10g_rx_pcs_fifo_stop_wr   ),
           .hssi_10g_rx_pcs_force_align     		(hssi_10g_rx_pcs_force_align    ),
           .hssi_10g_rx_pcs_frmsync_bypass  		(hssi_10g_rx_pcs_frmsync_bypass ),
           .hssi_10g_rx_pcs_frmsync_clken   		(hssi_10g_rx_pcs_frmsync_clken  ),
           .hssi_10g_rx_pcs_frmsync_enum_scrm  		(hssi_10g_rx_pcs_frmsync_enum_scrm ),
           .hssi_10g_rx_pcs_frmsync_enum_sync  		(hssi_10g_rx_pcs_frmsync_enum_sync ),
           .hssi_10g_rx_pcs_frmsync_flag_type  		(hssi_10g_rx_pcs_frmsync_flag_type ),
           .hssi_10g_rx_pcs_frmsync_knum_sync  		(hssi_10g_rx_pcs_frmsync_knum_sync ),
           .hssi_10g_rx_pcs_frmsync_mfrm_length  		(hssi_10g_rx_pcs_frmsync_mfrm_length ),
           .hssi_10g_rx_pcs_frmsync_pipeln  		(hssi_10g_rx_pcs_frmsync_pipeln ),
           .hssi_10g_rx_pcs_full_flag_type  		(hssi_10g_rx_pcs_full_flag_type ),
           .hssi_10g_rx_pcs_gb_rx_idwidth   		(hssi_10g_rx_pcs_gb_rx_idwidth  ),
           .hssi_10g_rx_pcs_gb_rx_odwidth   		(hssi_10g_rx_pcs_gb_rx_odwidth  ),
           .hssi_10g_rx_pcs_gbexp_clken     		(hssi_10g_rx_pcs_gbexp_clken    ),
           .hssi_10g_rx_pcs_low_latency_en  		(hssi_10g_rx_pcs_low_latency_en ),
           .hssi_10g_rx_pcs_lpbk_mode       		(hssi_10g_rx_pcs_lpbk_mode      ),
           .hssi_10g_rx_pcs_master_clk_sel  		(hssi_10g_rx_pcs_master_clk_sel ),
           .hssi_10g_rx_pcs_pempty_flag_type  		(hssi_10g_rx_pcs_pempty_flag_type ),
           .hssi_10g_rx_pcs_pfull_flag_type  		(hssi_10g_rx_pcs_pfull_flag_type ),
           .hssi_10g_rx_pcs_phcomp_rd_del   		(hssi_10g_rx_pcs_phcomp_rd_del  ),
           .hssi_10g_rx_pcs_pld_if_type     		(hssi_10g_rx_pcs_pld_if_type    ),
           .hssi_10g_rx_pcs_prot_mode       		(hssi_10g_rx_pcs_prot_mode      ),
           .hssi_10g_rx_pcs_rand_clken      		(hssi_10g_rx_pcs_rand_clken     ),
           .hssi_10g_rx_pcs_rd_clk_sel      		(hssi_10g_rx_pcs_rd_clk_sel     ),
           .hssi_10g_rx_pcs_rdfifo_clken    		(hssi_10g_rx_pcs_rdfifo_clken   ),
           .hssi_10g_rx_pcs_reconfig_settings  		(hssi_10g_rx_pcs_reconfig_settings ),
           .hssi_10g_rx_pcs_rx_fifo_write_ctrl  		(hssi_10g_rx_pcs_rx_fifo_write_ctrl ),
           .hssi_10g_rx_pcs_rx_scrm_width   		(hssi_10g_rx_pcs_rx_scrm_width  ),
           .hssi_10g_rx_pcs_rx_sh_location  		(hssi_10g_rx_pcs_rx_sh_location ),
           .hssi_10g_rx_pcs_rx_signal_ok_sel  		(hssi_10g_rx_pcs_rx_signal_ok_sel ),
           .hssi_10g_rx_pcs_rx_sm_bypass    		(hssi_10g_rx_pcs_rx_sm_bypass   ),
           .hssi_10g_rx_pcs_rx_sm_hiber     		(hssi_10g_rx_pcs_rx_sm_hiber    ),
           .hssi_10g_rx_pcs_rx_sm_pipeln    		(hssi_10g_rx_pcs_rx_sm_pipeln   ),
           .hssi_10g_rx_pcs_rx_testbus_sel  		(hssi_10g_rx_pcs_rx_testbus_sel ),
           .hssi_10g_rx_pcs_rx_true_b2b     		(hssi_10g_rx_pcs_rx_true_b2b    ),
           .hssi_10g_rx_pcs_rxfifo_empty    		(hssi_10g_rx_pcs_rxfifo_empty   ),
           .hssi_10g_rx_pcs_rxfifo_full     		(hssi_10g_rx_pcs_rxfifo_full    ),
           .hssi_10g_rx_pcs_rxfifo_mode     		(hssi_10g_rx_pcs_rxfifo_mode    ),
           .hssi_10g_rx_pcs_rxfifo_pempty   		(hssi_10g_rx_pcs_rxfifo_pempty  ),
           .hssi_10g_rx_pcs_rxfifo_pfull    		(hssi_10g_rx_pcs_rxfifo_pfull   ),
           .hssi_10g_rx_pcs_stretch_num_stages  		(hssi_10g_rx_pcs_stretch_num_stages ),
           .hssi_10g_rx_pcs_sup_mode        		(hssi_10g_rx_pcs_sup_mode       ),
           .hssi_10g_rx_pcs_test_mode       		(hssi_10g_rx_pcs_test_mode      ),
           .hssi_10g_rx_pcs_wrfifo_clken    		(hssi_10g_rx_pcs_wrfifo_clken   ),
           .hssi_10g_tx_pcs_advanced_user_mode  		(hssi_10g_tx_pcs_advanced_user_mode ),
           .hssi_10g_tx_pcs_bitslip_en      		(hssi_10g_tx_pcs_bitslip_en     ),
           .hssi_10g_tx_pcs_bonding_dft_en  		(hssi_10g_tx_pcs_bonding_dft_en ),
           .hssi_10g_tx_pcs_bonding_dft_val  		(hssi_10g_tx_pcs_bonding_dft_val ),
           .hssi_10g_tx_pcs_comp_cnt        		(hssi_10g_tx_pcs_comp_cnt       ),
           .hssi_10g_tx_pcs_compin_sel      		(hssi_10g_tx_pcs_compin_sel     ),
           .hssi_10g_tx_pcs_crcgen_bypass   		(hssi_10g_tx_pcs_crcgen_bypass  ),
           .hssi_10g_tx_pcs_crcgen_clken    		(hssi_10g_tx_pcs_crcgen_clken   ),
           .hssi_10g_tx_pcs_crcgen_err      		(hssi_10g_tx_pcs_crcgen_err     ),
           .hssi_10g_tx_pcs_crcgen_inv      		(hssi_10g_tx_pcs_crcgen_inv     ),
           .hssi_10g_tx_pcs_ctrl_bit_reverse  		(hssi_10g_tx_pcs_ctrl_bit_reverse ),
           .hssi_10g_tx_pcs_ctrl_plane_bonding  		(hssi_10g_tx_pcs_ctrl_plane_bonding ),
           .hssi_10g_tx_pcs_data_bit_reverse  		(hssi_10g_tx_pcs_data_bit_reverse ),
           .hssi_10g_tx_pcs_dft_clk_out_sel  		(hssi_10g_tx_pcs_dft_clk_out_sel ),
           .hssi_10g_tx_pcs_dispgen_bypass  		(hssi_10g_tx_pcs_dispgen_bypass ),
           .hssi_10g_tx_pcs_dispgen_clken   		(hssi_10g_tx_pcs_dispgen_clken  ),
           .hssi_10g_tx_pcs_dispgen_err     		(hssi_10g_tx_pcs_dispgen_err    ),
           .hssi_10g_tx_pcs_dispgen_pipeln  		(hssi_10g_tx_pcs_dispgen_pipeln ),
           .hssi_10g_tx_pcs_distdwn_bypass_pipeln  		(hssi_10g_tx_pcs_distdwn_bypass_pipeln ),
           .hssi_10g_tx_pcs_distdwn_master  		(hssi_10g_tx_pcs_distdwn_master ),
           .hssi_10g_tx_pcs_distup_bypass_pipeln  		(hssi_10g_tx_pcs_distup_bypass_pipeln ),
           .hssi_10g_tx_pcs_distup_master   		(hssi_10g_tx_pcs_distup_master  ),
           .hssi_10g_tx_pcs_dv_bond         		(hssi_10g_tx_pcs_dv_bond        ),
           .hssi_10g_tx_pcs_empty_flag_type  		(hssi_10g_tx_pcs_empty_flag_type ),
           .hssi_10g_tx_pcs_enc64b66b_txsm_clken  		(hssi_10g_tx_pcs_enc64b66b_txsm_clken ),
           .hssi_10g_tx_pcs_enc_64b66b_txsm_bypass  		(hssi_10g_tx_pcs_enc_64b66b_txsm_bypass ),
           .hssi_10g_tx_pcs_fastpath        		(hssi_10g_tx_pcs_fastpath       ),
           .hssi_10g_tx_pcs_fec_clken       		(hssi_10g_tx_pcs_fec_clken      ),
           .hssi_10g_tx_pcs_fec_enable      		(hssi_10g_tx_pcs_fec_enable     ),
           .hssi_10g_tx_pcs_fifo_double_write  		(hssi_10g_tx_pcs_fifo_double_write ),
           .hssi_10g_tx_pcs_fifo_reg_fast   		(hssi_10g_tx_pcs_fifo_reg_fast  ),
           .hssi_10g_tx_pcs_fifo_stop_rd    		(hssi_10g_tx_pcs_fifo_stop_rd   ),
           .hssi_10g_tx_pcs_fifo_stop_wr    		(hssi_10g_tx_pcs_fifo_stop_wr   ),
           .hssi_10g_tx_pcs_frmgen_burst    		(hssi_10g_tx_pcs_frmgen_burst   ),
           .hssi_10g_tx_pcs_frmgen_bypass   		(hssi_10g_tx_pcs_frmgen_bypass  ),
           .hssi_10g_tx_pcs_frmgen_clken    		(hssi_10g_tx_pcs_frmgen_clken   ),
           .hssi_10g_tx_pcs_frmgen_mfrm_length  		(hssi_10g_tx_pcs_frmgen_mfrm_length ),
           .hssi_10g_tx_pcs_frmgen_pipeln   		(hssi_10g_tx_pcs_frmgen_pipeln  ),
           .hssi_10g_tx_pcs_frmgen_pyld_ins  		(hssi_10g_tx_pcs_frmgen_pyld_ins ),
           .hssi_10g_tx_pcs_frmgen_wordslip  		(hssi_10g_tx_pcs_frmgen_wordslip ),
           .hssi_10g_tx_pcs_full_flag_type  		(hssi_10g_tx_pcs_full_flag_type ),
           .hssi_10g_tx_pcs_gb_pipeln_bypass  		(hssi_10g_tx_pcs_gb_pipeln_bypass ),
           .hssi_10g_tx_pcs_gb_tx_idwidth   		(hssi_10g_tx_pcs_gb_tx_idwidth  ),
           .hssi_10g_tx_pcs_gb_tx_odwidth   		(hssi_10g_tx_pcs_gb_tx_odwidth  ),
           .hssi_10g_tx_pcs_gbred_clken     		(hssi_10g_tx_pcs_gbred_clken    ),
           .hssi_10g_tx_pcs_indv            		(hssi_10g_tx_pcs_indv           ),
           .hssi_10g_tx_pcs_low_latency_en  		(hssi_10g_tx_pcs_low_latency_en ),
           .hssi_10g_tx_pcs_master_clk_sel  		(hssi_10g_tx_pcs_master_clk_sel ),
           .hssi_10g_tx_pcs_pempty_flag_type  		(hssi_10g_tx_pcs_pempty_flag_type ),
           .hssi_10g_tx_pcs_pfull_flag_type  		(hssi_10g_tx_pcs_pfull_flag_type ),
           .hssi_10g_tx_pcs_phcomp_rd_del   		(hssi_10g_tx_pcs_phcomp_rd_del  ),
           .hssi_10g_tx_pcs_pld_if_type     		(hssi_10g_tx_pcs_pld_if_type    ),
           .hssi_10g_tx_pcs_prot_mode       		(hssi_10g_tx_pcs_prot_mode      ),
           .hssi_10g_tx_pcs_pseudo_random   		(hssi_10g_tx_pcs_pseudo_random  ),
           .hssi_10g_tx_pcs_pseudo_seed_a   		(hssi_10g_tx_pcs_pseudo_seed_a  ),
           .hssi_10g_tx_pcs_pseudo_seed_b   		(hssi_10g_tx_pcs_pseudo_seed_b  ),
           .hssi_10g_tx_pcs_random_disp     		(hssi_10g_tx_pcs_random_disp    ),
           .hssi_10g_tx_pcs_rdfifo_clken    		(hssi_10g_tx_pcs_rdfifo_clken   ),
           .hssi_10g_tx_pcs_reconfig_settings  		(hssi_10g_tx_pcs_reconfig_settings ),
           .hssi_10g_tx_pcs_scrm_bypass     		(hssi_10g_tx_pcs_scrm_bypass    ),
           .hssi_10g_tx_pcs_scrm_clken      		(hssi_10g_tx_pcs_scrm_clken     ),
           .hssi_10g_tx_pcs_scrm_mode       		(hssi_10g_tx_pcs_scrm_mode      ),
           .hssi_10g_tx_pcs_scrm_pipeln     		(hssi_10g_tx_pcs_scrm_pipeln    ),
           .hssi_10g_tx_pcs_sh_err          		(hssi_10g_tx_pcs_sh_err         ),
           .hssi_10g_tx_pcs_sop_mark        		(hssi_10g_tx_pcs_sop_mark       ),
           .hssi_10g_tx_pcs_stretch_num_stages  		(hssi_10g_tx_pcs_stretch_num_stages ),
           .hssi_10g_tx_pcs_sup_mode        		(hssi_10g_tx_pcs_sup_mode       ),
           .hssi_10g_tx_pcs_test_mode       		(hssi_10g_tx_pcs_test_mode      ),
           .hssi_10g_tx_pcs_tx_scrm_err     		(hssi_10g_tx_pcs_tx_scrm_err    ),
           .hssi_10g_tx_pcs_tx_scrm_width   		(hssi_10g_tx_pcs_tx_scrm_width  ),
           .hssi_10g_tx_pcs_tx_sh_location  		(hssi_10g_tx_pcs_tx_sh_location ),
           .hssi_10g_tx_pcs_tx_sm_bypass    		(hssi_10g_tx_pcs_tx_sm_bypass   ),
           .hssi_10g_tx_pcs_tx_sm_pipeln    		(hssi_10g_tx_pcs_tx_sm_pipeln   ),
           .hssi_10g_tx_pcs_tx_testbus_sel  		(hssi_10g_tx_pcs_tx_testbus_sel ),
           .hssi_10g_tx_pcs_txfifo_empty    		(hssi_10g_tx_pcs_txfifo_empty   ),
           .hssi_10g_tx_pcs_txfifo_full     		(hssi_10g_tx_pcs_txfifo_full    ),
           .hssi_10g_tx_pcs_txfifo_mode     		(hssi_10g_tx_pcs_txfifo_mode    ),
           .hssi_10g_tx_pcs_txfifo_pempty   		(hssi_10g_tx_pcs_txfifo_pempty  ),
           .hssi_10g_tx_pcs_txfifo_pfull    		(hssi_10g_tx_pcs_txfifo_pfull   ),
           .hssi_10g_tx_pcs_wr_clk_sel      		(hssi_10g_tx_pcs_wr_clk_sel     ),
           .hssi_10g_tx_pcs_wrfifo_clken    		(hssi_10g_tx_pcs_wrfifo_clken   ),
           .hssi_8g_rx_pcs_auto_error_replacement  		(hssi_8g_rx_pcs_auto_error_replacement ),
           .hssi_8g_rx_pcs_auto_speed_nego  		(hssi_8g_rx_pcs_auto_speed_nego ),
           .hssi_8g_rx_pcs_bit_reversal     		(hssi_8g_rx_pcs_bit_reversal    ),
           .hssi_8g_rx_pcs_bonding_dft_en   		(hssi_8g_rx_pcs_bonding_dft_en  ),
           .hssi_8g_rx_pcs_bonding_dft_val  		(hssi_8g_rx_pcs_bonding_dft_val ),
           .hssi_8g_rx_pcs_bypass_pipeline_reg  		(hssi_8g_rx_pcs_bypass_pipeline_reg ),
           .hssi_8g_rx_pcs_byte_deserializer  		(hssi_8g_rx_pcs_byte_deserializer ),
           .hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask  		(hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask ),
           .hssi_8g_rx_pcs_clkcmp_pattern_n  		(hssi_8g_rx_pcs_clkcmp_pattern_n ),
           .hssi_8g_rx_pcs_clkcmp_pattern_p  		(hssi_8g_rx_pcs_clkcmp_pattern_p ),
           .hssi_8g_rx_pcs_clock_gate_bds_dec_asn  		(hssi_8g_rx_pcs_clock_gate_bds_dec_asn ),
           .hssi_8g_rx_pcs_clock_gate_cdr_eidle  		(hssi_8g_rx_pcs_clock_gate_cdr_eidle ),
           .hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_dw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_dw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_dw_wa  		(hssi_8g_rx_pcs_clock_gate_dw_wa ),
           .hssi_8g_rx_pcs_clock_gate_pc_rdclk  		(hssi_8g_rx_pcs_clock_gate_pc_rdclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_sw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_sw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_sw_wa  		(hssi_8g_rx_pcs_clock_gate_sw_wa ),
           .hssi_8g_rx_pcs_clock_observation_in_pld_core  		(hssi_8g_rx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_rx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_rx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_rx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_rx_pcs_eidle_entry_eios  		(hssi_8g_rx_pcs_eidle_entry_eios ),
           .hssi_8g_rx_pcs_eidle_entry_iei  		(hssi_8g_rx_pcs_eidle_entry_iei ),
           .hssi_8g_rx_pcs_eidle_entry_sd   		(hssi_8g_rx_pcs_eidle_entry_sd  ),
           .hssi_8g_rx_pcs_eightb_tenb_decoder  		(hssi_8g_rx_pcs_eightb_tenb_decoder ),
           .hssi_8g_rx_pcs_err_flags_sel    		(hssi_8g_rx_pcs_err_flags_sel   ),
           .hssi_8g_rx_pcs_fixed_pat_det    		(hssi_8g_rx_pcs_fixed_pat_det   ),
           .hssi_8g_rx_pcs_fixed_pat_num    		(hssi_8g_rx_pcs_fixed_pat_num   ),
           .hssi_8g_rx_pcs_force_signal_detect  		(hssi_8g_rx_pcs_force_signal_detect ),
           .hssi_8g_rx_pcs_gen3_clk_en      		(hssi_8g_rx_pcs_gen3_clk_en     ),
           .hssi_8g_rx_pcs_gen3_rx_clk_sel  		(hssi_8g_rx_pcs_gen3_rx_clk_sel ),
           .hssi_8g_rx_pcs_gen3_tx_clk_sel  		(hssi_8g_rx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_rx_pcs_hip_mode         		(hssi_8g_rx_pcs_hip_mode        ),
           .hssi_8g_rx_pcs_ibm_invalid_code  		(hssi_8g_rx_pcs_ibm_invalid_code ),
           .hssi_8g_rx_pcs_invalid_code_flag_only  		(hssi_8g_rx_pcs_invalid_code_flag_only ),
           .hssi_8g_rx_pcs_pad_or_edb_error_replace  		(hssi_8g_rx_pcs_pad_or_edb_error_replace ),
           .hssi_8g_rx_pcs_pcs_bypass       		(hssi_8g_rx_pcs_pcs_bypass      ),
           .hssi_8g_rx_pcs_phase_comp_rdptr  		(hssi_8g_rx_pcs_phase_comp_rdptr ),
           .hssi_8g_rx_pcs_phase_compensation_fifo  		(hssi_8g_rx_pcs_phase_compensation_fifo ),
           .hssi_8g_rx_pcs_pipe_if_enable   		(hssi_8g_rx_pcs_pipe_if_enable  ),
           .hssi_8g_rx_pcs_pma_dw           		(hssi_8g_rx_pcs_pma_dw          ),
           .hssi_8g_rx_pcs_polinv_8b10b_dec  		(hssi_8g_rx_pcs_polinv_8b10b_dec ),
           .hssi_8g_rx_pcs_prot_mode        		(hssi_8g_rx_pcs_prot_mode       ),
           .hssi_8g_rx_pcs_rate_match       		(hssi_8g_rx_pcs_rate_match      ),
           .hssi_8g_rx_pcs_rate_match_del_thres  		(hssi_8g_rx_pcs_rate_match_del_thres ),
           .hssi_8g_rx_pcs_rate_match_empty_thres  		(hssi_8g_rx_pcs_rate_match_empty_thres ),
           .hssi_8g_rx_pcs_rate_match_full_thres  		(hssi_8g_rx_pcs_rate_match_full_thres ),
           .hssi_8g_rx_pcs_rate_match_ins_thres  		(hssi_8g_rx_pcs_rate_match_ins_thres ),
           .hssi_8g_rx_pcs_rate_match_start_thres  		(hssi_8g_rx_pcs_rate_match_start_thres ),
           .hssi_8g_rx_pcs_reconfig_settings  		(hssi_8g_rx_pcs_reconfig_settings ),
           .hssi_8g_rx_pcs_rx_clk2          		(hssi_8g_rx_pcs_rx_clk2         ),
           .hssi_8g_rx_pcs_rx_clk_free_running  		(hssi_8g_rx_pcs_rx_clk_free_running ),
           .hssi_8g_rx_pcs_rx_pcs_urst      		(hssi_8g_rx_pcs_rx_pcs_urst     ),
           .hssi_8g_rx_pcs_rx_rcvd_clk      		(hssi_8g_rx_pcs_rx_rcvd_clk     ),
           .hssi_8g_rx_pcs_rx_rd_clk        		(hssi_8g_rx_pcs_rx_rd_clk       ),
           .hssi_8g_rx_pcs_rx_refclk        		(hssi_8g_rx_pcs_rx_refclk       ),
           .hssi_8g_rx_pcs_rx_wr_clk        		(hssi_8g_rx_pcs_rx_wr_clk       ),
           .hssi_8g_rx_pcs_sup_mode         		(hssi_8g_rx_pcs_sup_mode        ),
           .hssi_8g_rx_pcs_symbol_swap      		(hssi_8g_rx_pcs_symbol_swap     ),
           .hssi_8g_rx_pcs_sync_sm_idle_eios  		(hssi_8g_rx_pcs_sync_sm_idle_eios ),
           .hssi_8g_rx_pcs_test_bus_sel     		(hssi_8g_rx_pcs_test_bus_sel    ),
           .hssi_8g_rx_pcs_tx_rx_parallel_loopback  		(hssi_8g_rx_pcs_tx_rx_parallel_loopback ),
           .hssi_8g_rx_pcs_wa_boundary_lock_ctrl  		(hssi_8g_rx_pcs_wa_boundary_lock_ctrl ),
           .hssi_8g_rx_pcs_wa_clk_slip_spacing  		(hssi_8g_rx_pcs_wa_clk_slip_spacing ),
           .hssi_8g_rx_pcs_wa_det_latency_sync_status_beh  		(hssi_8g_rx_pcs_wa_det_latency_sync_status_beh ),
           .hssi_8g_rx_pcs_wa_disp_err_flag  		(hssi_8g_rx_pcs_wa_disp_err_flag ),
           .hssi_8g_rx_pcs_wa_kchar         		(hssi_8g_rx_pcs_wa_kchar        ),
           .hssi_8g_rx_pcs_wa_pd            		(hssi_8g_rx_pcs_wa_pd           ),
           .hssi_8g_rx_pcs_wa_pd_data       		(hssi_8g_rx_pcs_wa_pd_data      ),
           .hssi_8g_rx_pcs_wa_pd_polarity   		(hssi_8g_rx_pcs_wa_pd_polarity  ),
           .hssi_8g_rx_pcs_wa_pld_controlled  		(hssi_8g_rx_pcs_wa_pld_controlled ),
           .hssi_8g_rx_pcs_wa_renumber_data  		(hssi_8g_rx_pcs_wa_renumber_data ),
           .hssi_8g_rx_pcs_wa_rgnumber_data  		(hssi_8g_rx_pcs_wa_rgnumber_data ),
           .hssi_8g_rx_pcs_wa_rknumber_data  		(hssi_8g_rx_pcs_wa_rknumber_data ),
           .hssi_8g_rx_pcs_wa_rosnumber_data  		(hssi_8g_rx_pcs_wa_rosnumber_data ),
           .hssi_8g_rx_pcs_wa_rvnumber_data  		(hssi_8g_rx_pcs_wa_rvnumber_data ),
           .hssi_8g_rx_pcs_wa_sync_sm_ctrl  		(hssi_8g_rx_pcs_wa_sync_sm_ctrl ),
           .hssi_8g_rx_pcs_wait_cnt         		(hssi_8g_rx_pcs_wait_cnt        ),
           .hssi_8g_tx_pcs_auto_speed_nego_gen2  		(hssi_8g_tx_pcs_auto_speed_nego_gen2 ),
           .hssi_8g_tx_pcs_bit_reversal     		(hssi_8g_tx_pcs_bit_reversal    ),
           .hssi_8g_tx_pcs_bonding_dft_en   		(hssi_8g_tx_pcs_bonding_dft_en  ),
           .hssi_8g_tx_pcs_bonding_dft_val  		(hssi_8g_tx_pcs_bonding_dft_val ),
           .hssi_8g_tx_pcs_bypass_pipeline_reg  		(hssi_8g_tx_pcs_bypass_pipeline_reg ),
           .hssi_8g_tx_pcs_byte_serializer  		(hssi_8g_tx_pcs_byte_serializer ),
           .hssi_8g_tx_pcs_clock_gate_bs_enc  		(hssi_8g_tx_pcs_clock_gate_bs_enc ),
           .hssi_8g_tx_pcs_clock_gate_dw_fifowr  		(hssi_8g_tx_pcs_clock_gate_dw_fifowr ),
           .hssi_8g_tx_pcs_clock_gate_fiford  		(hssi_8g_tx_pcs_clock_gate_fiford ),
           .hssi_8g_tx_pcs_clock_gate_sw_fifowr  		(hssi_8g_tx_pcs_clock_gate_sw_fifowr ),
           .hssi_8g_tx_pcs_clock_observation_in_pld_core  		(hssi_8g_tx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_tx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_tx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_tx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_tx_pcs_data_selection_8b10b_encoder_input  		(hssi_8g_tx_pcs_data_selection_8b10b_encoder_input ),
           .hssi_8g_tx_pcs_dynamic_clk_switch  		(hssi_8g_tx_pcs_dynamic_clk_switch ),
           .hssi_8g_tx_pcs_eightb_tenb_disp_ctrl  		(hssi_8g_tx_pcs_eightb_tenb_disp_ctrl ),
           .hssi_8g_tx_pcs_eightb_tenb_encoder  		(hssi_8g_tx_pcs_eightb_tenb_encoder ),
           .hssi_8g_tx_pcs_force_echar      		(hssi_8g_tx_pcs_force_echar     ),
           .hssi_8g_tx_pcs_force_kchar      		(hssi_8g_tx_pcs_force_kchar     ),
           .hssi_8g_tx_pcs_gen3_tx_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel ),
           .hssi_8g_tx_pcs_hip_mode         		(hssi_8g_tx_pcs_hip_mode        ),
           .hssi_8g_tx_pcs_pcs_bypass       		(hssi_8g_tx_pcs_pcs_bypass      ),
           .hssi_8g_tx_pcs_phase_comp_rdptr  		(hssi_8g_tx_pcs_phase_comp_rdptr ),
           .hssi_8g_tx_pcs_phase_compensation_fifo  		(hssi_8g_tx_pcs_phase_compensation_fifo ),
           .hssi_8g_tx_pcs_phfifo_write_clk_sel  		(hssi_8g_tx_pcs_phfifo_write_clk_sel ),
           .hssi_8g_tx_pcs_pma_dw           		(hssi_8g_tx_pcs_pma_dw          ),
           .hssi_8g_tx_pcs_prot_mode        		(hssi_8g_tx_pcs_prot_mode       ),
           .hssi_8g_tx_pcs_reconfig_settings  		(hssi_8g_tx_pcs_reconfig_settings ),
           .hssi_8g_tx_pcs_refclk_b_clk_sel  		(hssi_8g_tx_pcs_refclk_b_clk_sel ),
           .hssi_8g_tx_pcs_revloop_back_rm  		(hssi_8g_tx_pcs_revloop_back_rm ),
           .hssi_8g_tx_pcs_sup_mode         		(hssi_8g_tx_pcs_sup_mode        ),
           .hssi_8g_tx_pcs_symbol_swap      		(hssi_8g_tx_pcs_symbol_swap     ),
           .hssi_8g_tx_pcs_tx_bitslip       		(hssi_8g_tx_pcs_tx_bitslip      ),
           .hssi_8g_tx_pcs_tx_compliance_controlled_disparity  		(hssi_8g_tx_pcs_tx_compliance_controlled_disparity ),
           .hssi_8g_tx_pcs_tx_fast_pld_reg  		(hssi_8g_tx_pcs_tx_fast_pld_reg ),
           .hssi_8g_tx_pcs_txclk_freerun    		(hssi_8g_tx_pcs_txclk_freerun   ),
           .hssi_8g_tx_pcs_txpcs_urst       		(hssi_8g_tx_pcs_txpcs_urst      ),
           .hssi_common_pcs_pma_interface_asn_clk_enable  		(hssi_common_pcs_pma_interface_asn_clk_enable ),
           .hssi_common_pcs_pma_interface_asn_enable  		(hssi_common_pcs_pma_interface_asn_enable ),
           .hssi_common_pcs_pma_interface_block_sel  		(hssi_common_pcs_pma_interface_block_sel ),
           .hssi_common_pcs_pma_interface_bypass_early_eios  		(hssi_common_pcs_pma_interface_bypass_early_eios ),
           .hssi_common_pcs_pma_interface_bypass_pcie_switch  		(hssi_common_pcs_pma_interface_bypass_pcie_switch ),
           .hssi_common_pcs_pma_interface_bypass_pma_ltr  		(hssi_common_pcs_pma_interface_bypass_pma_ltr ),
           .hssi_common_pcs_pma_interface_bypass_pma_sw_done  		(hssi_common_pcs_pma_interface_bypass_pma_sw_done ),
           .hssi_common_pcs_pma_interface_bypass_ppm_lock  		(hssi_common_pcs_pma_interface_bypass_ppm_lock ),
           .hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp ),
           .hssi_common_pcs_pma_interface_bypass_txdetectrx  		(hssi_common_pcs_pma_interface_bypass_txdetectrx ),
           .hssi_common_pcs_pma_interface_cdr_control  		(hssi_common_pcs_pma_interface_cdr_control ),
           .hssi_common_pcs_pma_interface_cid_enable  		(hssi_common_pcs_pma_interface_cid_enable ),
           .hssi_common_pcs_pma_interface_cp_cons_sel  		(hssi_common_pcs_pma_interface_cp_cons_sel ),
           .hssi_common_pcs_pma_interface_cp_dwn_mstr  		(hssi_common_pcs_pma_interface_cp_dwn_mstr ),
           .hssi_common_pcs_pma_interface_cp_up_mstr  		(hssi_common_pcs_pma_interface_cp_up_mstr ),
           .hssi_common_pcs_pma_interface_ctrl_plane_bonding  		(hssi_common_pcs_pma_interface_ctrl_plane_bonding ),
           .hssi_common_pcs_pma_interface_data_mask_count  		(hssi_common_pcs_pma_interface_data_mask_count ),
           .hssi_common_pcs_pma_interface_data_mask_count_multi  		(hssi_common_pcs_pma_interface_data_mask_count_multi ),
           .hssi_common_pcs_pma_interface_dft_observation_clock_selection  		(hssi_common_pcs_pma_interface_dft_observation_clock_selection ),
           .hssi_common_pcs_pma_interface_early_eios_counter  		(hssi_common_pcs_pma_interface_early_eios_counter ),
           .hssi_common_pcs_pma_interface_force_freqdet  		(hssi_common_pcs_pma_interface_force_freqdet ),
           .hssi_common_pcs_pma_interface_free_run_clk_enable  		(hssi_common_pcs_pma_interface_free_run_clk_enable ),
           .hssi_common_pcs_pma_interface_ignore_sigdet_g23  		(hssi_common_pcs_pma_interface_ignore_sigdet_g23 ),
           .hssi_common_pcs_pma_interface_pc_en_counter  		(hssi_common_pcs_pma_interface_pc_en_counter ),
           .hssi_common_pcs_pma_interface_pc_rst_counter  		(hssi_common_pcs_pma_interface_pc_rst_counter ),
           .hssi_common_pcs_pma_interface_pcie_hip_mode  		(hssi_common_pcs_pma_interface_pcie_hip_mode ),
           .hssi_common_pcs_pma_interface_ph_fifo_reg_mode  		(hssi_common_pcs_pma_interface_ph_fifo_reg_mode ),
           .hssi_common_pcs_pma_interface_phfifo_flush_wait  		(hssi_common_pcs_pma_interface_phfifo_flush_wait ),
           .hssi_common_pcs_pma_interface_pipe_if_g3pcs  		(hssi_common_pcs_pma_interface_pipe_if_g3pcs ),
           .hssi_common_pcs_pma_interface_pma_done_counter  		(hssi_common_pcs_pma_interface_pma_done_counter ),
           .hssi_common_pcs_pma_interface_pma_if_dft_en  		(hssi_common_pcs_pma_interface_pma_if_dft_en ),
           .hssi_common_pcs_pma_interface_pma_if_dft_val  		(hssi_common_pcs_pma_interface_pma_if_dft_val ),
           .hssi_common_pcs_pma_interface_ppm_cnt_rst  		(hssi_common_pcs_pma_interface_ppm_cnt_rst ),
           .hssi_common_pcs_pma_interface_ppm_deassert_early  		(hssi_common_pcs_pma_interface_ppm_deassert_early ),
           .hssi_common_pcs_pma_interface_ppm_det_buckets  		(hssi_common_pcs_pma_interface_ppm_det_buckets ),
           .hssi_common_pcs_pma_interface_ppm_gen1_2_cnt  		(hssi_common_pcs_pma_interface_ppm_gen1_2_cnt ),
           .hssi_common_pcs_pma_interface_ppm_post_eidle_delay  		(hssi_common_pcs_pma_interface_ppm_post_eidle_delay ),
           .hssi_common_pcs_pma_interface_ppmsel  		(hssi_common_pcs_pma_interface_ppmsel ),
           .hssi_common_pcs_pma_interface_prot_mode  		(hssi_common_pcs_pma_interface_prot_mode ),
           .hssi_common_pcs_pma_interface_reconfig_settings  		(hssi_common_pcs_pma_interface_reconfig_settings ),
           .hssi_common_pcs_pma_interface_rxvalid_mask  		(hssi_common_pcs_pma_interface_rxvalid_mask ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter  		(hssi_common_pcs_pma_interface_sigdet_wait_counter ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter_multi  		(hssi_common_pcs_pma_interface_sigdet_wait_counter_multi ),
           .hssi_common_pcs_pma_interface_sim_mode  		(hssi_common_pcs_pma_interface_sim_mode ),
           .hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en  		(hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en ),
           .hssi_common_pcs_pma_interface_sup_mode  		(hssi_common_pcs_pma_interface_sup_mode ),
           .hssi_common_pcs_pma_interface_testout_sel  		(hssi_common_pcs_pma_interface_testout_sel ),
           .hssi_common_pcs_pma_interface_wait_clk_on_off_timer  		(hssi_common_pcs_pma_interface_wait_clk_on_off_timer ),
           .hssi_common_pcs_pma_interface_wait_pipe_synchronizing  		(hssi_common_pcs_pma_interface_wait_pipe_synchronizing ),
           .hssi_common_pcs_pma_interface_wait_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_wait_send_syncp_fbkp ),
           .hssi_common_pld_pcs_interface_dft_clk_out_en  		(hssi_common_pld_pcs_interface_dft_clk_out_en ),
           .hssi_common_pld_pcs_interface_dft_clk_out_sel  		(hssi_common_pld_pcs_interface_dft_clk_out_sel ),
           .hssi_common_pld_pcs_interface_hrdrstctrl_en  		(hssi_common_pld_pcs_interface_hrdrstctrl_en ),
           .hssi_common_pld_pcs_interface_pcs_testbus_block_sel  		(hssi_common_pld_pcs_interface_pcs_testbus_block_sel ),
           .hssi_common_pld_pcs_interface_reconfig_settings  		(hssi_common_pld_pcs_interface_reconfig_settings ),
           .hssi_fifo_rx_pcs_double_read_mode  		(hssi_fifo_rx_pcs_double_read_mode ),
           .hssi_fifo_rx_pcs_prot_mode      		(hssi_fifo_rx_pcs_prot_mode     ),
           .hssi_fifo_tx_pcs_double_write_mode  		(hssi_fifo_tx_pcs_double_write_mode ),
           .hssi_fifo_tx_pcs_prot_mode      		(hssi_fifo_tx_pcs_prot_mode     ),
           .hssi_gen3_rx_pcs_block_sync     		(hssi_gen3_rx_pcs_block_sync    ),
           .hssi_gen3_rx_pcs_block_sync_sm  		(hssi_gen3_rx_pcs_block_sync_sm ),
           .hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn  		(hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn ),
           .hssi_gen3_rx_pcs_lpbk_force     		(hssi_gen3_rx_pcs_lpbk_force    ),
           .hssi_gen3_rx_pcs_mode           		(hssi_gen3_rx_pcs_mode          ),
           .hssi_gen3_rx_pcs_rate_match_fifo  		(hssi_gen3_rx_pcs_rate_match_fifo ),
           .hssi_gen3_rx_pcs_rate_match_fifo_latency  		(hssi_gen3_rx_pcs_rate_match_fifo_latency ),
           .hssi_gen3_rx_pcs_reconfig_settings  		(hssi_gen3_rx_pcs_reconfig_settings ),
           .hssi_gen3_rx_pcs_reverse_lpbk   		(hssi_gen3_rx_pcs_reverse_lpbk  ),
           .hssi_gen3_rx_pcs_rx_b4gb_par_lpbk  		(hssi_gen3_rx_pcs_rx_b4gb_par_lpbk ),
           .hssi_gen3_rx_pcs_rx_force_balign  		(hssi_gen3_rx_pcs_rx_force_balign ),
           .hssi_gen3_rx_pcs_rx_ins_del_one_skip  		(hssi_gen3_rx_pcs_rx_ins_del_one_skip ),
           .hssi_gen3_rx_pcs_rx_num_fixed_pat  		(hssi_gen3_rx_pcs_rx_num_fixed_pat ),
           .hssi_gen3_rx_pcs_rx_test_out_sel  		(hssi_gen3_rx_pcs_rx_test_out_sel ),
           .hssi_gen3_rx_pcs_sup_mode       		(hssi_gen3_rx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_mode           		(hssi_gen3_tx_pcs_mode          ),
           .hssi_gen3_tx_pcs_reverse_lpbk   		(hssi_gen3_tx_pcs_reverse_lpbk  ),
           .hssi_gen3_tx_pcs_sup_mode       		(hssi_gen3_tx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_tx_bitslip     		(hssi_gen3_tx_pcs_tx_bitslip    ),
           .hssi_gen3_tx_pcs_tx_gbox_byp    		(hssi_gen3_tx_pcs_tx_gbox_byp   ),
           .hssi_krfec_rx_pcs_blksync_cor_en  		(hssi_krfec_rx_pcs_blksync_cor_en ),
           .hssi_krfec_rx_pcs_bypass_gb     		(hssi_krfec_rx_pcs_bypass_gb    ),
           .hssi_krfec_rx_pcs_clr_ctrl      		(hssi_krfec_rx_pcs_clr_ctrl     ),
           .hssi_krfec_rx_pcs_ctrl_bit_reverse  		(hssi_krfec_rx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_rx_pcs_data_bit_reverse  		(hssi_krfec_rx_pcs_data_bit_reverse ),
           .hssi_krfec_rx_pcs_dv_start      		(hssi_krfec_rx_pcs_dv_start     ),
           .hssi_krfec_rx_pcs_err_mark_type  		(hssi_krfec_rx_pcs_err_mark_type ),
           .hssi_krfec_rx_pcs_error_marking_en  		(hssi_krfec_rx_pcs_error_marking_en ),
           .hssi_krfec_rx_pcs_low_latency_en  		(hssi_krfec_rx_pcs_low_latency_en ),
           .hssi_krfec_rx_pcs_lpbk_mode     		(hssi_krfec_rx_pcs_lpbk_mode    ),
           .hssi_krfec_rx_pcs_parity_invalid_enum  		(hssi_krfec_rx_pcs_parity_invalid_enum ),
           .hssi_krfec_rx_pcs_parity_valid_num  		(hssi_krfec_rx_pcs_parity_valid_num ),
           .hssi_krfec_rx_pcs_pipeln_blksync  		(hssi_krfec_rx_pcs_pipeln_blksync ),
           .hssi_krfec_rx_pcs_pipeln_descrm  		(hssi_krfec_rx_pcs_pipeln_descrm ),
           .hssi_krfec_rx_pcs_pipeln_errcorrect  		(hssi_krfec_rx_pcs_pipeln_errcorrect ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_ind  		(hssi_krfec_rx_pcs_pipeln_errtrap_ind ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_lfsr  		(hssi_krfec_rx_pcs_pipeln_errtrap_lfsr ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_loc  		(hssi_krfec_rx_pcs_pipeln_errtrap_loc ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_pat  		(hssi_krfec_rx_pcs_pipeln_errtrap_pat ),
           .hssi_krfec_rx_pcs_pipeln_gearbox  		(hssi_krfec_rx_pcs_pipeln_gearbox ),
           .hssi_krfec_rx_pcs_pipeln_syndrm  		(hssi_krfec_rx_pcs_pipeln_syndrm ),
           .hssi_krfec_rx_pcs_pipeln_trans_dec  		(hssi_krfec_rx_pcs_pipeln_trans_dec ),
           .hssi_krfec_rx_pcs_prot_mode     		(hssi_krfec_rx_pcs_prot_mode    ),
           .hssi_krfec_rx_pcs_receive_order  		(hssi_krfec_rx_pcs_receive_order ),
           .hssi_krfec_rx_pcs_reconfig_settings  		(hssi_krfec_rx_pcs_reconfig_settings ),
           .hssi_krfec_rx_pcs_rx_testbus_sel  		(hssi_krfec_rx_pcs_rx_testbus_sel ),
           .hssi_krfec_rx_pcs_signal_ok_en  		(hssi_krfec_rx_pcs_signal_ok_en ),
           .hssi_krfec_rx_pcs_sup_mode      		(hssi_krfec_rx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_burst_err     		(hssi_krfec_tx_pcs_burst_err    ),
           .hssi_krfec_tx_pcs_burst_err_len  		(hssi_krfec_tx_pcs_burst_err_len ),
           .hssi_krfec_tx_pcs_ctrl_bit_reverse  		(hssi_krfec_tx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_tx_pcs_data_bit_reverse  		(hssi_krfec_tx_pcs_data_bit_reverse ),
           .hssi_krfec_tx_pcs_enc_frame_query  		(hssi_krfec_tx_pcs_enc_frame_query ),
           .hssi_krfec_tx_pcs_low_latency_en  		(hssi_krfec_tx_pcs_low_latency_en ),
           .hssi_krfec_tx_pcs_pipeln_encoder  		(hssi_krfec_tx_pcs_pipeln_encoder ),
           .hssi_krfec_tx_pcs_pipeln_scrambler  		(hssi_krfec_tx_pcs_pipeln_scrambler ),
           .hssi_krfec_tx_pcs_prot_mode     		(hssi_krfec_tx_pcs_prot_mode    ),
           .hssi_krfec_tx_pcs_sup_mode      		(hssi_krfec_tx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_transcode_err  		(hssi_krfec_tx_pcs_transcode_err ),
           .hssi_krfec_tx_pcs_transmit_order  		(hssi_krfec_tx_pcs_transmit_order ),
           .hssi_krfec_tx_pcs_tx_testbus_sel  		(hssi_krfec_tx_pcs_tx_testbus_sel ),
           .hssi_pipe_gen1_2_elec_idle_delay_val  		(hssi_pipe_gen1_2_elec_idle_delay_val ),
           .hssi_pipe_gen1_2_error_replace_pad  		(hssi_pipe_gen1_2_error_replace_pad ),
           .hssi_pipe_gen1_2_hip_mode       		(hssi_pipe_gen1_2_hip_mode      ),
           .hssi_pipe_gen1_2_ind_error_reporting  		(hssi_pipe_gen1_2_ind_error_reporting ),
           .hssi_pipe_gen1_2_phystatus_delay_val  		(hssi_pipe_gen1_2_phystatus_delay_val ),
           .hssi_pipe_gen1_2_phystatus_rst_toggle  		(hssi_pipe_gen1_2_phystatus_rst_toggle ),
           .hssi_pipe_gen1_2_pipe_byte_de_serializer_en  		(hssi_pipe_gen1_2_pipe_byte_de_serializer_en ),
           .hssi_pipe_gen1_2_prot_mode      		(hssi_pipe_gen1_2_prot_mode     ),
           .hssi_pipe_gen1_2_reconfig_settings  		(hssi_pipe_gen1_2_reconfig_settings ),
           .hssi_pipe_gen1_2_rx_pipe_enable  		(hssi_pipe_gen1_2_rx_pipe_enable ),
           .hssi_pipe_gen1_2_rxdetect_bypass  		(hssi_pipe_gen1_2_rxdetect_bypass ),
           .hssi_pipe_gen1_2_sup_mode       		(hssi_pipe_gen1_2_sup_mode      ),
           .hssi_pipe_gen1_2_tx_pipe_enable  		(hssi_pipe_gen1_2_tx_pipe_enable ),
           .hssi_pipe_gen1_2_txswing        		(hssi_pipe_gen1_2_txswing       ),
           .hssi_pipe_gen3_bypass_rx_detection_enable  		(hssi_pipe_gen3_bypass_rx_detection_enable ),
           .hssi_pipe_gen3_bypass_rx_preset  		(hssi_pipe_gen3_bypass_rx_preset ),
           .hssi_pipe_gen3_bypass_rx_preset_enable  		(hssi_pipe_gen3_bypass_rx_preset_enable ),
           .hssi_pipe_gen3_bypass_tx_coefficent  		(hssi_pipe_gen3_bypass_tx_coefficent ),
           .hssi_pipe_gen3_bypass_tx_coefficent_enable  		(hssi_pipe_gen3_bypass_tx_coefficent_enable ),
           .hssi_pipe_gen3_elecidle_delay_g3  		(hssi_pipe_gen3_elecidle_delay_g3 ),
           .hssi_pipe_gen3_ind_error_reporting  		(hssi_pipe_gen3_ind_error_reporting ),
           .hssi_pipe_gen3_mode             		(hssi_pipe_gen3_mode            ),
           .hssi_pipe_gen3_phy_status_delay_g12  		(hssi_pipe_gen3_phy_status_delay_g12 ),
           .hssi_pipe_gen3_phy_status_delay_g3  		(hssi_pipe_gen3_phy_status_delay_g3 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g12  		(hssi_pipe_gen3_phystatus_rst_toggle_g12 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g3  		(hssi_pipe_gen3_phystatus_rst_toggle_g3 ),
           .hssi_pipe_gen3_rate_match_pad_insertion  		(hssi_pipe_gen3_rate_match_pad_insertion ),
           .hssi_pipe_gen3_sup_mode         		(hssi_pipe_gen3_sup_mode        ),
           .hssi_pipe_gen3_test_out_sel     		(hssi_pipe_gen3_test_out_sel    ),
           .hssi_rx_pcs_pma_interface_block_sel  		(hssi_rx_pcs_pma_interface_block_sel ),
           .hssi_rx_pcs_pma_interface_channel_operation_mode  		(hssi_rx_pcs_pma_interface_channel_operation_mode ),
           .hssi_rx_pcs_pma_interface_clkslip_sel  		(hssi_rx_pcs_pma_interface_clkslip_sel ),
           .hssi_rx_pcs_pma_interface_lpbk_en  		(hssi_rx_pcs_pma_interface_lpbk_en ),
           .hssi_rx_pcs_pma_interface_master_clk_sel  		(hssi_rx_pcs_pma_interface_master_clk_sel ),
           .hssi_rx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_rx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_rx_pcs_pma_interface_pma_dw_rx  		(hssi_rx_pcs_pma_interface_pma_dw_rx ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_en  		(hssi_rx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_val  		(hssi_rx_pcs_pma_interface_pma_if_dft_val ),
           .hssi_rx_pcs_pma_interface_prbs9_dwidth  		(hssi_rx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_rx_pcs_pma_interface_prbs_clken  		(hssi_rx_pcs_pma_interface_prbs_clken ),
           .hssi_rx_pcs_pma_interface_prbs_ver  		(hssi_rx_pcs_pma_interface_prbs_ver ),
           .hssi_rx_pcs_pma_interface_prot_mode_rx  		(hssi_rx_pcs_pma_interface_prot_mode_rx ),
           .hssi_rx_pcs_pma_interface_reconfig_settings  		(hssi_rx_pcs_pma_interface_reconfig_settings ),
           .hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_lpbk_en ),
           .hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok  		(hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mask  		(hssi_rx_pcs_pma_interface_rx_prbs_mask ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mode  		(hssi_rx_pcs_pma_interface_rx_prbs_mode ),
           .hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel  		(hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel ),
           .hssi_rx_pcs_pma_interface_rx_static_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_static_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en ),
           .hssi_rx_pcs_pma_interface_sup_mode  		(hssi_rx_pcs_pma_interface_sup_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_rx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_rx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_rx_pld_pcs_interface_pcs_rx_block_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_block_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en  		(hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en ),
           .hssi_rx_pld_pcs_interface_pcs_rx_output_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_output_sel ),
           .hssi_rx_pld_pcs_interface_reconfig_settings  		(hssi_rx_pld_pcs_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_bypass_pma_txelecidle  		(hssi_tx_pcs_pma_interface_bypass_pma_txelecidle ),
           .hssi_tx_pcs_pma_interface_channel_operation_mode  		(hssi_tx_pcs_pma_interface_channel_operation_mode ),
           .hssi_tx_pcs_pma_interface_lpbk_en  		(hssi_tx_pcs_pma_interface_lpbk_en ),
           .hssi_tx_pcs_pma_interface_master_clk_sel  		(hssi_tx_pcs_pma_interface_master_clk_sel ),
           .hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx  		(hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_tx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_tx_pcs_pma_interface_pma_dw_tx  		(hssi_tx_pcs_pma_interface_pma_dw_tx ),
           .hssi_tx_pcs_pma_interface_pma_if_dft_en  		(hssi_tx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_tx_pcs_pma_interface_pmagate_en  		(hssi_tx_pcs_pma_interface_pmagate_en ),
           .hssi_tx_pcs_pma_interface_prbs9_dwidth  		(hssi_tx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_tx_pcs_pma_interface_prbs_clken  		(hssi_tx_pcs_pma_interface_prbs_clken ),
           .hssi_tx_pcs_pma_interface_prbs_gen_pat  		(hssi_tx_pcs_pma_interface_prbs_gen_pat ),
           .hssi_tx_pcs_pma_interface_prot_mode_tx  		(hssi_tx_pcs_pma_interface_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_reconfig_settings  		(hssi_tx_pcs_pma_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_sq_wave_num  		(hssi_tx_pcs_pma_interface_sq_wave_num ),
           .hssi_tx_pcs_pma_interface_sqwgen_clken  		(hssi_tx_pcs_pma_interface_sqwgen_clken ),
           .hssi_tx_pcs_pma_interface_sup_mode  		(hssi_tx_pcs_pma_interface_sup_mode ),
           .hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_tx_pma_data_sel  		(hssi_tx_pcs_pma_interface_tx_pma_data_sel ),
           .hssi_tx_pcs_pma_interface_tx_static_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_static_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period  		(hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable  		(hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control ),
           .hssi_tx_pcs_pma_interface_uhsif_enable  		(hssi_tx_pcs_pma_interface_uhsif_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value ),
           .hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_tx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_tx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding  		(hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_source  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_data_source  		(hssi_tx_pld_pcs_interface_pcs_tx_data_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_output_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_output_sel ),
           .hssi_tx_pld_pcs_interface_reconfig_settings  		(hssi_tx_pld_pcs_interface_reconfig_settings ),
           .avmm_interfaces                 		(avmm_interfaces                ),
           .rcfg_enable                     		(rcfg_enable                    ),
           .enable_avmm                     		(enable_avmm                    ),
           .arbiter_ctrl                    		(arbiter_ctrl                   ),
           .calibration_en                  		(calibration_en                 ),
           .avmm_busy_en                    		(avmm_busy_en                   ),
           .hip_cal_en                      		(hip_cal_en                     ),
           .cal_done                        		(cal_done                       )
                  )
               twentynm_xcvr_native_inst(.*);
             end


  "20nm5es":  begin
               twentynm_xcvr_native_rev_20nm5es
                 #(
			
           .bonded_lanes                    		(bonded_lanes                   ),
           .bonding_master_ch               		(bonding_master_ch              ),
           .xcvr_native_mode                		(xcvr_native_mode               ),
           .pma_adapt_adapt_mode            		(pma_adapt_adapt_mode           ),
           .pma_adapt_adp_1s_ctle_bypass    		(pma_adapt_adp_1s_ctle_bypass   ),
           .pma_adapt_adp_4s_ctle_bypass    		(pma_adapt_adp_4s_ctle_bypass   ),
           .pma_adapt_adp_ctle_adapt_cycle_window  		(pma_adapt_adp_ctle_adapt_cycle_window ),
           .pma_adapt_adp_ctle_en           		(pma_adapt_adp_ctle_en          ),
           .pma_adapt_adp_dfe_fltap_bypass  		(pma_adapt_adp_dfe_fltap_bypass ),
           .pma_adapt_adp_dfe_fltap_en      		(pma_adapt_adp_dfe_fltap_en     ),
           .pma_adapt_adp_dfe_fxtap_bypass  		(pma_adapt_adp_dfe_fxtap_bypass ),
           .pma_adapt_adp_dfe_fxtap_en      		(pma_adapt_adp_dfe_fxtap_en     ),
           .pma_adapt_adp_dfe_fxtap_hold_en  		(pma_adapt_adp_dfe_fxtap_hold_en ),
           .pma_adapt_adp_dfe_mode          		(pma_adapt_adp_dfe_mode         ),
           .pma_adapt_adp_mode              		(pma_adapt_adp_mode             ),
           .pma_adapt_adp_onetime_dfe       		(pma_adapt_adp_onetime_dfe      ),
           .pma_adapt_adp_vga_bypass        		(pma_adapt_adp_vga_bypass       ),
           .pma_adapt_adp_vga_en            		(pma_adapt_adp_vga_en           ),
           .pma_adapt_adp_vref_bypass       		(pma_adapt_adp_vref_bypass      ),
           .pma_adapt_adp_vref_en           		(pma_adapt_adp_vref_en          ),
           .pma_adapt_datarate              		(pma_adapt_datarate             ),
           .pma_adapt_odi_dfe_spec_en       		(pma_adapt_odi_dfe_spec_en      ),
           .pma_adapt_prot_mode             		(pma_adapt_prot_mode            ),
           .pma_adapt_sup_mode              		(pma_adapt_sup_mode             ),
           .pma_cdr_refclk_inclk0_logical_to_physical_mapping  		(pma_cdr_refclk_inclk0_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk1_logical_to_physical_mapping  		(pma_cdr_refclk_inclk1_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk2_logical_to_physical_mapping  		(pma_cdr_refclk_inclk2_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk3_logical_to_physical_mapping  		(pma_cdr_refclk_inclk3_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk4_logical_to_physical_mapping  		(pma_cdr_refclk_inclk4_logical_to_physical_mapping ),
           .pma_cdr_refclk_powerdown_mode   		(pma_cdr_refclk_powerdown_mode  ),
           .pma_cdr_refclk_refclk_select    		(pma_cdr_refclk_refclk_select   ),
           .cdr_pll_atb_select_control      		(cdr_pll_atb_select_control     ),
           .cdr_pll_auto_reset_on           		(cdr_pll_auto_reset_on          ),
           .cdr_pll_bbpd_data_pattern_filter_select  		(cdr_pll_bbpd_data_pattern_filter_select ),
           .cdr_pll_bw_sel                  		(cdr_pll_bw_sel                 ),
           .cdr_pll_cal_vco_count_length    		(cdr_pll_cal_vco_count_length   ),
           .cdr_pll_cdr_odi_select          		(cdr_pll_cdr_odi_select         ),
           .cdr_pll_cdr_phaselock_mode      		(cdr_pll_cdr_phaselock_mode     ),
           .cdr_pll_cdr_powerdown_mode      		(cdr_pll_cdr_powerdown_mode     ),
           .cdr_pll_cgb_div                 		(cdr_pll_cgb_div                ),
           .cdr_pll_chgpmp_current_dn_pd    		(cdr_pll_chgpmp_current_dn_pd   ),
           .cdr_pll_chgpmp_current_dn_trim  		(cdr_pll_chgpmp_current_dn_trim ),
           .cdr_pll_chgpmp_current_pd       		(cdr_pll_chgpmp_current_pd      ),
           .cdr_pll_chgpmp_current_pfd      		(cdr_pll_chgpmp_current_pfd     ),
           .cdr_pll_chgpmp_current_up_pd    		(cdr_pll_chgpmp_current_up_pd   ),
           .cdr_pll_chgpmp_current_up_trim  		(cdr_pll_chgpmp_current_up_trim ),
           .cdr_pll_chgpmp_dn_pd_trim_double  		(cdr_pll_chgpmp_dn_pd_trim_double ),
           .cdr_pll_chgpmp_replicate        		(cdr_pll_chgpmp_replicate       ),
           .cdr_pll_chgpmp_testmode         		(cdr_pll_chgpmp_testmode        ),
           .cdr_pll_chgpmp_up_pd_trim_double  		(cdr_pll_chgpmp_up_pd_trim_double ),
           .cdr_pll_clklow_mux_select       		(cdr_pll_clklow_mux_select      ),
           .cdr_pll_datarate                		(cdr_pll_datarate               ),
           .cdr_pll_diag_loopback_enable    		(cdr_pll_diag_loopback_enable   ),
           .cdr_pll_disable_up_dn           		(cdr_pll_disable_up_dn          ),
           .cdr_pll_fb_select               		(cdr_pll_fb_select              ),
           .cdr_pll_fref_clklow_div         		(cdr_pll_fref_clklow_div        ),
           .cdr_pll_fref_mux_select         		(cdr_pll_fref_mux_select        ),
           .cdr_pll_gpon_lck2ref_control    		(cdr_pll_gpon_lck2ref_control   ),
           .cdr_pll_initial_settings        		(cdr_pll_initial_settings       ),
           .cdr_pll_iqclk_mux_sel           		(cdr_pll_iqclk_mux_sel          ),
           .cdr_pll_is_cascaded_pll         		(cdr_pll_is_cascaded_pll        ),
           .cdr_pll_lck2ref_delay_control   		(cdr_pll_lck2ref_delay_control  ),
           .cdr_pll_lf_resistor_pd          		(cdr_pll_lf_resistor_pd         ),
           .cdr_pll_lf_resistor_pfd         		(cdr_pll_lf_resistor_pfd        ),
           .cdr_pll_lf_ripple_cap           		(cdr_pll_lf_ripple_cap          ),
           .cdr_pll_loop_filter_bias_select  		(cdr_pll_loop_filter_bias_select ),
           .cdr_pll_loopback_mode           		(cdr_pll_loopback_mode          ),
           .cdr_pll_lpd_counter             		(cdr_pll_lpd_counter            ),
           .cdr_pll_lpfd_counter            		(cdr_pll_lpfd_counter           ),
           .cdr_pll_ltd_ltr_micro_controller_select  		(cdr_pll_ltd_ltr_micro_controller_select ),
           .cdr_pll_m_counter               		(cdr_pll_m_counter              ),
           .cdr_pll_n_counter               		(cdr_pll_n_counter              ),
           .cdr_pll_n_counter_scratch       		(cdr_pll_n_counter_scratch      ),
           .cdr_pll_output_clock_frequency  		(cdr_pll_output_clock_frequency ),
           .cdr_pll_pcie_gen                		(cdr_pll_pcie_gen               ),
           .cdr_pll_pd_fastlock_mode        		(cdr_pll_pd_fastlock_mode       ),
           .cdr_pll_pd_l_counter            		(cdr_pll_pd_l_counter           ),
           .cdr_pll_pfd_l_counter           		(cdr_pll_pfd_l_counter          ),
           .cdr_pll_pma_width               		(cdr_pll_pma_width              ),
           .cdr_pll_primary_use             		(cdr_pll_primary_use            ),
           .cdr_pll_prot_mode               		(cdr_pll_prot_mode              ),
           .cdr_pll_reference_clock_frequency  		(cdr_pll_reference_clock_frequency ),
           .cdr_pll_reverse_serial_loopback  		(cdr_pll_reverse_serial_loopback ),
           .cdr_pll_set_cdr_input_freq_range  		(cdr_pll_set_cdr_input_freq_range ),
           .cdr_pll_set_cdr_v2i_enable      		(cdr_pll_set_cdr_v2i_enable     ),
           .cdr_pll_set_cdr_vco_reset       		(cdr_pll_set_cdr_vco_reset      ),
           .cdr_pll_set_cdr_vco_speed       		(cdr_pll_set_cdr_vco_speed      ),
           .cdr_pll_set_cdr_vco_speed_fix   		(cdr_pll_set_cdr_vco_speed_fix  ),
           .cdr_pll_set_cdr_vco_speed_pciegen3  		(cdr_pll_set_cdr_vco_speed_pciegen3 ),
           .cdr_pll_sup_mode                		(cdr_pll_sup_mode               ),
           .cdr_pll_tx_pll_prot_mode        		(cdr_pll_tx_pll_prot_mode       ),
           .cdr_pll_txpll_hclk_driver_enable  		(cdr_pll_txpll_hclk_driver_enable ),
           .cdr_pll_uc_ro_cal               		(cdr_pll_uc_ro_cal              ),
           .cdr_pll_vco_freq                		(cdr_pll_vco_freq               ),
           .cdr_pll_vco_overrange_voltage   		(cdr_pll_vco_overrange_voltage  ),
           .cdr_pll_vco_underrange_voltage  		(cdr_pll_vco_underrange_voltage ),
           .pma_rx_buf_bypass_eqz_stages_234  		(pma_rx_buf_bypass_eqz_stages_234 ),
           .pma_rx_buf_datarate             		(pma_rx_buf_datarate            ),
           .pma_rx_buf_diag_lp_en           		(pma_rx_buf_diag_lp_en          ),
           .pma_rx_buf_loopback_modes       		(pma_rx_buf_loopback_modes      ),
           .pma_rx_buf_pm_tx_rx_cvp_mode    		(pma_rx_buf_pm_tx_rx_cvp_mode   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen    		(pma_rx_buf_pm_tx_rx_pcie_gen   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth  		(pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth ),
           .pma_rx_buf_prot_mode            		(pma_rx_buf_prot_mode           ),
           .pma_rx_buf_qpi_enable           		(pma_rx_buf_qpi_enable          ),
           .pma_rx_buf_refclk_en            		(pma_rx_buf_refclk_en           ),
           .pma_rx_buf_rx_refclk_divider    		(pma_rx_buf_rx_refclk_divider   ),
           .pma_rx_buf_sup_mode             		(pma_rx_buf_sup_mode            ),
           .pma_rx_buf_xrx_path_datarate    		(pma_rx_buf_xrx_path_datarate   ),
           .pma_rx_buf_xrx_path_datawidth   		(pma_rx_buf_xrx_path_datawidth  ),
           .pma_rx_buf_xrx_path_pma_rx_divclk_hz  		(pma_rx_buf_xrx_path_pma_rx_divclk_hz ),
           .pma_rx_buf_xrx_path_prot_mode   		(pma_rx_buf_xrx_path_prot_mode  ),
           .pma_rx_buf_xrx_path_sup_mode    		(pma_rx_buf_xrx_path_sup_mode   ),
           .pma_rx_buf_xrx_path_uc_cal_enable  		(pma_rx_buf_xrx_path_uc_cal_enable ),
           .pma_rx_deser_bitslip_bypass     		(pma_rx_deser_bitslip_bypass    ),
           .pma_rx_deser_clkdiv_source      		(pma_rx_deser_clkdiv_source     ),
           .pma_rx_deser_clkdivrx_user_mode  		(pma_rx_deser_clkdivrx_user_mode ),
           .pma_rx_deser_datarate           		(pma_rx_deser_datarate          ),
           .pma_rx_deser_deser_factor       		(pma_rx_deser_deser_factor      ),
           .pma_rx_deser_force_clkdiv_for_testing  		(pma_rx_deser_force_clkdiv_for_testing ),
           .pma_rx_deser_pcie_gen           		(pma_rx_deser_pcie_gen          ),
           .pma_rx_deser_pcie_gen_bitwidth  		(pma_rx_deser_pcie_gen_bitwidth ),
           .pma_rx_deser_prot_mode          		(pma_rx_deser_prot_mode         ),
           .pma_rx_deser_rst_n_adapt_odi    		(pma_rx_deser_rst_n_adapt_odi   ),
           .pma_rx_deser_sdclk_enable       		(pma_rx_deser_sdclk_enable      ),
           .pma_rx_deser_sup_mode           		(pma_rx_deser_sup_mode          ),
           .pma_rx_dfe_datarate             		(pma_rx_dfe_datarate            ),
           .pma_rx_dfe_dft_en               		(pma_rx_dfe_dft_en              ),
           .pma_rx_dfe_pdb                  		(pma_rx_dfe_pdb                 ),
           .pma_rx_dfe_pdb_fixedtap         		(pma_rx_dfe_pdb_fixedtap        ),
           .pma_rx_dfe_pdb_floattap         		(pma_rx_dfe_pdb_floattap        ),
           .pma_rx_dfe_pdb_fxtap4t7         		(pma_rx_dfe_pdb_fxtap4t7        ),
           .pma_rx_dfe_prot_mode            		(pma_rx_dfe_prot_mode           ),
           .pma_rx_dfe_sup_mode             		(pma_rx_dfe_sup_mode            ),
           .pma_rx_odi_datarate             		(pma_rx_odi_datarate            ),
           .pma_rx_odi_prot_mode            		(pma_rx_odi_prot_mode           ),
           .pma_rx_odi_step_ctrl_sel        		(pma_rx_odi_step_ctrl_sel       ),
           .pma_rx_odi_sup_mode             		(pma_rx_odi_sup_mode            ),
           .pma_rx_sd_prot_mode             		(pma_rx_sd_prot_mode            ),
           .pma_rx_sd_sd_output_off         		(pma_rx_sd_sd_output_off        ),
           .pma_rx_sd_sd_output_on          		(pma_rx_sd_sd_output_on         ),
           .pma_rx_sd_sd_pdb                		(pma_rx_sd_sd_pdb               ),
           .pma_rx_sd_sup_mode              		(pma_rx_sd_sup_mode             ),
           .pma_tx_buf_datarate             		(pma_tx_buf_datarate            ),
           .pma_tx_buf_mcgb_location_for_pcie  		(pma_tx_buf_mcgb_location_for_pcie ),
           .pma_tx_buf_prot_mode            		(pma_tx_buf_prot_mode           ),
           .pma_tx_buf_rx_det               		(pma_tx_buf_rx_det              ),
           .pma_tx_buf_rx_det_output_sel    		(pma_tx_buf_rx_det_output_sel   ),
           .pma_tx_buf_rx_det_pdb           		(pma_tx_buf_rx_det_pdb          ),
           .pma_tx_buf_sup_mode             		(pma_tx_buf_sup_mode            ),
           .pma_tx_buf_user_fir_coeff_ctrl_sel  		(pma_tx_buf_user_fir_coeff_ctrl_sel ),
           .pma_tx_buf_xtx_path_clock_divider_ratio  		(pma_tx_buf_xtx_path_clock_divider_ratio ),
           .pma_tx_buf_xtx_path_datarate    		(pma_tx_buf_xtx_path_datarate   ),
           .pma_tx_buf_xtx_path_datawidth   		(pma_tx_buf_xtx_path_datawidth  ),
           .pma_tx_buf_xtx_path_pma_tx_divclk_hz  		(pma_tx_buf_xtx_path_pma_tx_divclk_hz ),
           .pma_tx_buf_xtx_path_prot_mode   		(pma_tx_buf_xtx_path_prot_mode  ),
           .pma_tx_buf_xtx_path_sup_mode    		(pma_tx_buf_xtx_path_sup_mode   ),
           .pma_tx_buf_xtx_path_tx_pll_clk_hz  		(pma_tx_buf_xtx_path_tx_pll_clk_hz ),
           .pma_cgb_bitslip_enable          		(pma_cgb_bitslip_enable         ),
           .pma_cgb_bonding_reset_enable    		(pma_cgb_bonding_reset_enable   ),
           .pma_cgb_datarate                		(pma_cgb_datarate               ),
           .pma_cgb_input_select_gen3       		(pma_cgb_input_select_gen3      ),
           .pma_cgb_input_select_x1         		(pma_cgb_input_select_x1        ),
           .pma_cgb_input_select_xn         		(pma_cgb_input_select_xn        ),
           .pma_cgb_pcie_gen3_bitwidth      		(pma_cgb_pcie_gen3_bitwidth     ),
           .pma_cgb_prot_mode               		(pma_cgb_prot_mode              ),
           .pma_cgb_scratch0_x1_clock_src   		(pma_cgb_scratch0_x1_clock_src  ),
           .pma_cgb_scratch1_x1_clock_src   		(pma_cgb_scratch1_x1_clock_src  ),
           .pma_cgb_scratch2_x1_clock_src   		(pma_cgb_scratch2_x1_clock_src  ),
           .pma_cgb_scratch3_x1_clock_src   		(pma_cgb_scratch3_x1_clock_src  ),
           .pma_cgb_select_done_master_or_slave  		(pma_cgb_select_done_master_or_slave ),
           .pma_cgb_ser_mode                		(pma_cgb_ser_mode               ),
           .pma_cgb_sup_mode                		(pma_cgb_sup_mode               ),
           .pma_cgb_tx_ucontrol_en          		(pma_cgb_tx_ucontrol_en         ),
           .pma_cgb_x1_div_m_sel            		(pma_cgb_x1_div_m_sel           ),
           .pma_tx_ser_prot_mode            		(pma_tx_ser_prot_mode           ),
           .pma_tx_ser_ser_clk_divtx_user_sel  		(pma_tx_ser_ser_clk_divtx_user_sel ),
           .pma_tx_ser_sup_mode             		(pma_tx_ser_sup_mode            ),
           .hssi_10g_rx_pcs_advanced_user_mode  		(hssi_10g_rx_pcs_advanced_user_mode ),
           .hssi_10g_rx_pcs_align_del       		(hssi_10g_rx_pcs_align_del      ),
           .hssi_10g_rx_pcs_ber_bit_err_total_cnt  		(hssi_10g_rx_pcs_ber_bit_err_total_cnt ),
           .hssi_10g_rx_pcs_ber_clken       		(hssi_10g_rx_pcs_ber_clken      ),
           .hssi_10g_rx_pcs_ber_xus_timer_window  		(hssi_10g_rx_pcs_ber_xus_timer_window ),
           .hssi_10g_rx_pcs_bitslip_mode    		(hssi_10g_rx_pcs_bitslip_mode   ),
           .hssi_10g_rx_pcs_blksync_bitslip_type  		(hssi_10g_rx_pcs_blksync_bitslip_type ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_cnt  		(hssi_10g_rx_pcs_blksync_bitslip_wait_cnt ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_type  		(hssi_10g_rx_pcs_blksync_bitslip_wait_type ),
           .hssi_10g_rx_pcs_blksync_bypass  		(hssi_10g_rx_pcs_blksync_bypass ),
           .hssi_10g_rx_pcs_blksync_clken   		(hssi_10g_rx_pcs_blksync_clken  ),
           .hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt  		(hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock ),
           .hssi_10g_rx_pcs_blksync_pipeln  		(hssi_10g_rx_pcs_blksync_pipeln ),
           .hssi_10g_rx_pcs_clr_errblk_cnt_en  		(hssi_10g_rx_pcs_clr_errblk_cnt_en ),
           .hssi_10g_rx_pcs_control_del     		(hssi_10g_rx_pcs_control_del    ),
           .hssi_10g_rx_pcs_crcchk_bypass   		(hssi_10g_rx_pcs_crcchk_bypass  ),
           .hssi_10g_rx_pcs_crcchk_clken    		(hssi_10g_rx_pcs_crcchk_clken   ),
           .hssi_10g_rx_pcs_crcchk_inv      		(hssi_10g_rx_pcs_crcchk_inv     ),
           .hssi_10g_rx_pcs_crcchk_pipeln   		(hssi_10g_rx_pcs_crcchk_pipeln  ),
           .hssi_10g_rx_pcs_crcflag_pipeln  		(hssi_10g_rx_pcs_crcflag_pipeln ),
           .hssi_10g_rx_pcs_ctrl_bit_reverse  		(hssi_10g_rx_pcs_ctrl_bit_reverse ),
           .hssi_10g_rx_pcs_data_bit_reverse  		(hssi_10g_rx_pcs_data_bit_reverse ),
           .hssi_10g_rx_pcs_dec64b66b_clken  		(hssi_10g_rx_pcs_dec64b66b_clken ),
           .hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass  		(hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass ),
           .hssi_10g_rx_pcs_descrm_bypass   		(hssi_10g_rx_pcs_descrm_bypass  ),
           .hssi_10g_rx_pcs_descrm_clken    		(hssi_10g_rx_pcs_descrm_clken   ),
           .hssi_10g_rx_pcs_descrm_mode     		(hssi_10g_rx_pcs_descrm_mode    ),
           .hssi_10g_rx_pcs_descrm_pipeln   		(hssi_10g_rx_pcs_descrm_pipeln  ),
           .hssi_10g_rx_pcs_dft_clk_out_sel  		(hssi_10g_rx_pcs_dft_clk_out_sel ),
           .hssi_10g_rx_pcs_dis_signal_ok   		(hssi_10g_rx_pcs_dis_signal_ok  ),
           .hssi_10g_rx_pcs_dispchk_bypass  		(hssi_10g_rx_pcs_dispchk_bypass ),
           .hssi_10g_rx_pcs_empty_flag_type  		(hssi_10g_rx_pcs_empty_flag_type ),
           .hssi_10g_rx_pcs_fast_path       		(hssi_10g_rx_pcs_fast_path      ),
           .hssi_10g_rx_pcs_fec_clken       		(hssi_10g_rx_pcs_fec_clken      ),
           .hssi_10g_rx_pcs_fec_enable      		(hssi_10g_rx_pcs_fec_enable     ),
           .hssi_10g_rx_pcs_fifo_double_read  		(hssi_10g_rx_pcs_fifo_double_read ),
           .hssi_10g_rx_pcs_fifo_stop_rd    		(hssi_10g_rx_pcs_fifo_stop_rd   ),
           .hssi_10g_rx_pcs_fifo_stop_wr    		(hssi_10g_rx_pcs_fifo_stop_wr   ),
           .hssi_10g_rx_pcs_force_align     		(hssi_10g_rx_pcs_force_align    ),
           .hssi_10g_rx_pcs_frmsync_bypass  		(hssi_10g_rx_pcs_frmsync_bypass ),
           .hssi_10g_rx_pcs_frmsync_clken   		(hssi_10g_rx_pcs_frmsync_clken  ),
           .hssi_10g_rx_pcs_frmsync_enum_scrm  		(hssi_10g_rx_pcs_frmsync_enum_scrm ),
           .hssi_10g_rx_pcs_frmsync_enum_sync  		(hssi_10g_rx_pcs_frmsync_enum_sync ),
           .hssi_10g_rx_pcs_frmsync_flag_type  		(hssi_10g_rx_pcs_frmsync_flag_type ),
           .hssi_10g_rx_pcs_frmsync_knum_sync  		(hssi_10g_rx_pcs_frmsync_knum_sync ),
           .hssi_10g_rx_pcs_frmsync_mfrm_length  		(hssi_10g_rx_pcs_frmsync_mfrm_length ),
           .hssi_10g_rx_pcs_frmsync_pipeln  		(hssi_10g_rx_pcs_frmsync_pipeln ),
           .hssi_10g_rx_pcs_full_flag_type  		(hssi_10g_rx_pcs_full_flag_type ),
           .hssi_10g_rx_pcs_gb_rx_idwidth   		(hssi_10g_rx_pcs_gb_rx_idwidth  ),
           .hssi_10g_rx_pcs_gb_rx_odwidth   		(hssi_10g_rx_pcs_gb_rx_odwidth  ),
           .hssi_10g_rx_pcs_gbexp_clken     		(hssi_10g_rx_pcs_gbexp_clken    ),
           .hssi_10g_rx_pcs_low_latency_en  		(hssi_10g_rx_pcs_low_latency_en ),
           .hssi_10g_rx_pcs_lpbk_mode       		(hssi_10g_rx_pcs_lpbk_mode      ),
           .hssi_10g_rx_pcs_master_clk_sel  		(hssi_10g_rx_pcs_master_clk_sel ),
           .hssi_10g_rx_pcs_pempty_flag_type  		(hssi_10g_rx_pcs_pempty_flag_type ),
           .hssi_10g_rx_pcs_pfull_flag_type  		(hssi_10g_rx_pcs_pfull_flag_type ),
           .hssi_10g_rx_pcs_phcomp_rd_del   		(hssi_10g_rx_pcs_phcomp_rd_del  ),
           .hssi_10g_rx_pcs_pld_if_type     		(hssi_10g_rx_pcs_pld_if_type    ),
           .hssi_10g_rx_pcs_prot_mode       		(hssi_10g_rx_pcs_prot_mode      ),
           .hssi_10g_rx_pcs_rand_clken      		(hssi_10g_rx_pcs_rand_clken     ),
           .hssi_10g_rx_pcs_rd_clk_sel      		(hssi_10g_rx_pcs_rd_clk_sel     ),
           .hssi_10g_rx_pcs_rdfifo_clken    		(hssi_10g_rx_pcs_rdfifo_clken   ),
           .hssi_10g_rx_pcs_reconfig_settings  		(hssi_10g_rx_pcs_reconfig_settings ),
           .hssi_10g_rx_pcs_rx_fifo_write_ctrl  		(hssi_10g_rx_pcs_rx_fifo_write_ctrl ),
           .hssi_10g_rx_pcs_rx_scrm_width   		(hssi_10g_rx_pcs_rx_scrm_width  ),
           .hssi_10g_rx_pcs_rx_sh_location  		(hssi_10g_rx_pcs_rx_sh_location ),
           .hssi_10g_rx_pcs_rx_signal_ok_sel  		(hssi_10g_rx_pcs_rx_signal_ok_sel ),
           .hssi_10g_rx_pcs_rx_sm_bypass    		(hssi_10g_rx_pcs_rx_sm_bypass   ),
           .hssi_10g_rx_pcs_rx_sm_hiber     		(hssi_10g_rx_pcs_rx_sm_hiber    ),
           .hssi_10g_rx_pcs_rx_sm_pipeln    		(hssi_10g_rx_pcs_rx_sm_pipeln   ),
           .hssi_10g_rx_pcs_rx_testbus_sel  		(hssi_10g_rx_pcs_rx_testbus_sel ),
           .hssi_10g_rx_pcs_rx_true_b2b     		(hssi_10g_rx_pcs_rx_true_b2b    ),
           .hssi_10g_rx_pcs_rxfifo_empty    		(hssi_10g_rx_pcs_rxfifo_empty   ),
           .hssi_10g_rx_pcs_rxfifo_full     		(hssi_10g_rx_pcs_rxfifo_full    ),
           .hssi_10g_rx_pcs_rxfifo_mode     		(hssi_10g_rx_pcs_rxfifo_mode    ),
           .hssi_10g_rx_pcs_rxfifo_pempty   		(hssi_10g_rx_pcs_rxfifo_pempty  ),
           .hssi_10g_rx_pcs_rxfifo_pfull    		(hssi_10g_rx_pcs_rxfifo_pfull   ),
           .hssi_10g_rx_pcs_stretch_num_stages  		(hssi_10g_rx_pcs_stretch_num_stages ),
           .hssi_10g_rx_pcs_sup_mode        		(hssi_10g_rx_pcs_sup_mode       ),
           .hssi_10g_rx_pcs_test_mode       		(hssi_10g_rx_pcs_test_mode      ),
           .hssi_10g_rx_pcs_wrfifo_clken    		(hssi_10g_rx_pcs_wrfifo_clken   ),
           .hssi_10g_tx_pcs_advanced_user_mode  		(hssi_10g_tx_pcs_advanced_user_mode ),
           .hssi_10g_tx_pcs_bitslip_en      		(hssi_10g_tx_pcs_bitslip_en     ),
           .hssi_10g_tx_pcs_bonding_dft_en  		(hssi_10g_tx_pcs_bonding_dft_en ),
           .hssi_10g_tx_pcs_bonding_dft_val  		(hssi_10g_tx_pcs_bonding_dft_val ),
           .hssi_10g_tx_pcs_comp_cnt        		(hssi_10g_tx_pcs_comp_cnt       ),
           .hssi_10g_tx_pcs_compin_sel      		(hssi_10g_tx_pcs_compin_sel     ),
           .hssi_10g_tx_pcs_crcgen_bypass   		(hssi_10g_tx_pcs_crcgen_bypass  ),
           .hssi_10g_tx_pcs_crcgen_clken    		(hssi_10g_tx_pcs_crcgen_clken   ),
           .hssi_10g_tx_pcs_crcgen_err      		(hssi_10g_tx_pcs_crcgen_err     ),
           .hssi_10g_tx_pcs_crcgen_inv      		(hssi_10g_tx_pcs_crcgen_inv     ),
           .hssi_10g_tx_pcs_ctrl_bit_reverse  		(hssi_10g_tx_pcs_ctrl_bit_reverse ),
           .hssi_10g_tx_pcs_ctrl_plane_bonding  		(hssi_10g_tx_pcs_ctrl_plane_bonding ),
           .hssi_10g_tx_pcs_data_bit_reverse  		(hssi_10g_tx_pcs_data_bit_reverse ),
           .hssi_10g_tx_pcs_dft_clk_out_sel  		(hssi_10g_tx_pcs_dft_clk_out_sel ),
           .hssi_10g_tx_pcs_dispgen_bypass  		(hssi_10g_tx_pcs_dispgen_bypass ),
           .hssi_10g_tx_pcs_dispgen_clken   		(hssi_10g_tx_pcs_dispgen_clken  ),
           .hssi_10g_tx_pcs_dispgen_err     		(hssi_10g_tx_pcs_dispgen_err    ),
           .hssi_10g_tx_pcs_dispgen_pipeln  		(hssi_10g_tx_pcs_dispgen_pipeln ),
           .hssi_10g_tx_pcs_distdwn_bypass_pipeln  		(hssi_10g_tx_pcs_distdwn_bypass_pipeln ),
           .hssi_10g_tx_pcs_distdwn_master  		(hssi_10g_tx_pcs_distdwn_master ),
           .hssi_10g_tx_pcs_distup_bypass_pipeln  		(hssi_10g_tx_pcs_distup_bypass_pipeln ),
           .hssi_10g_tx_pcs_distup_master   		(hssi_10g_tx_pcs_distup_master  ),
           .hssi_10g_tx_pcs_dv_bond         		(hssi_10g_tx_pcs_dv_bond        ),
           .hssi_10g_tx_pcs_empty_flag_type  		(hssi_10g_tx_pcs_empty_flag_type ),
           .hssi_10g_tx_pcs_enc64b66b_txsm_clken  		(hssi_10g_tx_pcs_enc64b66b_txsm_clken ),
           .hssi_10g_tx_pcs_enc_64b66b_txsm_bypass  		(hssi_10g_tx_pcs_enc_64b66b_txsm_bypass ),
           .hssi_10g_tx_pcs_fastpath        		(hssi_10g_tx_pcs_fastpath       ),
           .hssi_10g_tx_pcs_fec_clken       		(hssi_10g_tx_pcs_fec_clken      ),
           .hssi_10g_tx_pcs_fec_enable      		(hssi_10g_tx_pcs_fec_enable     ),
           .hssi_10g_tx_pcs_fifo_double_write  		(hssi_10g_tx_pcs_fifo_double_write ),
           .hssi_10g_tx_pcs_fifo_reg_fast   		(hssi_10g_tx_pcs_fifo_reg_fast  ),
           .hssi_10g_tx_pcs_fifo_stop_rd    		(hssi_10g_tx_pcs_fifo_stop_rd   ),
           .hssi_10g_tx_pcs_fifo_stop_wr    		(hssi_10g_tx_pcs_fifo_stop_wr   ),
           .hssi_10g_tx_pcs_frmgen_burst    		(hssi_10g_tx_pcs_frmgen_burst   ),
           .hssi_10g_tx_pcs_frmgen_bypass   		(hssi_10g_tx_pcs_frmgen_bypass  ),
           .hssi_10g_tx_pcs_frmgen_clken    		(hssi_10g_tx_pcs_frmgen_clken   ),
           .hssi_10g_tx_pcs_frmgen_mfrm_length  		(hssi_10g_tx_pcs_frmgen_mfrm_length ),
           .hssi_10g_tx_pcs_frmgen_pipeln   		(hssi_10g_tx_pcs_frmgen_pipeln  ),
           .hssi_10g_tx_pcs_frmgen_pyld_ins  		(hssi_10g_tx_pcs_frmgen_pyld_ins ),
           .hssi_10g_tx_pcs_frmgen_wordslip  		(hssi_10g_tx_pcs_frmgen_wordslip ),
           .hssi_10g_tx_pcs_full_flag_type  		(hssi_10g_tx_pcs_full_flag_type ),
           .hssi_10g_tx_pcs_gb_pipeln_bypass  		(hssi_10g_tx_pcs_gb_pipeln_bypass ),
           .hssi_10g_tx_pcs_gb_tx_idwidth   		(hssi_10g_tx_pcs_gb_tx_idwidth  ),
           .hssi_10g_tx_pcs_gb_tx_odwidth   		(hssi_10g_tx_pcs_gb_tx_odwidth  ),
           .hssi_10g_tx_pcs_gbred_clken     		(hssi_10g_tx_pcs_gbred_clken    ),
           .hssi_10g_tx_pcs_indv            		(hssi_10g_tx_pcs_indv           ),
           .hssi_10g_tx_pcs_low_latency_en  		(hssi_10g_tx_pcs_low_latency_en ),
           .hssi_10g_tx_pcs_master_clk_sel  		(hssi_10g_tx_pcs_master_clk_sel ),
           .hssi_10g_tx_pcs_pempty_flag_type  		(hssi_10g_tx_pcs_pempty_flag_type ),
           .hssi_10g_tx_pcs_pfull_flag_type  		(hssi_10g_tx_pcs_pfull_flag_type ),
           .hssi_10g_tx_pcs_phcomp_rd_del   		(hssi_10g_tx_pcs_phcomp_rd_del  ),
           .hssi_10g_tx_pcs_pld_if_type     		(hssi_10g_tx_pcs_pld_if_type    ),
           .hssi_10g_tx_pcs_prot_mode       		(hssi_10g_tx_pcs_prot_mode      ),
           .hssi_10g_tx_pcs_pseudo_random   		(hssi_10g_tx_pcs_pseudo_random  ),
           .hssi_10g_tx_pcs_pseudo_seed_a   		(hssi_10g_tx_pcs_pseudo_seed_a  ),
           .hssi_10g_tx_pcs_pseudo_seed_b   		(hssi_10g_tx_pcs_pseudo_seed_b  ),
           .hssi_10g_tx_pcs_random_disp     		(hssi_10g_tx_pcs_random_disp    ),
           .hssi_10g_tx_pcs_rdfifo_clken    		(hssi_10g_tx_pcs_rdfifo_clken   ),
           .hssi_10g_tx_pcs_reconfig_settings  		(hssi_10g_tx_pcs_reconfig_settings ),
           .hssi_10g_tx_pcs_scrm_bypass     		(hssi_10g_tx_pcs_scrm_bypass    ),
           .hssi_10g_tx_pcs_scrm_clken      		(hssi_10g_tx_pcs_scrm_clken     ),
           .hssi_10g_tx_pcs_scrm_mode       		(hssi_10g_tx_pcs_scrm_mode      ),
           .hssi_10g_tx_pcs_scrm_pipeln     		(hssi_10g_tx_pcs_scrm_pipeln    ),
           .hssi_10g_tx_pcs_sh_err          		(hssi_10g_tx_pcs_sh_err         ),
           .hssi_10g_tx_pcs_sop_mark        		(hssi_10g_tx_pcs_sop_mark       ),
           .hssi_10g_tx_pcs_stretch_num_stages  		(hssi_10g_tx_pcs_stretch_num_stages ),
           .hssi_10g_tx_pcs_sup_mode        		(hssi_10g_tx_pcs_sup_mode       ),
           .hssi_10g_tx_pcs_test_mode       		(hssi_10g_tx_pcs_test_mode      ),
           .hssi_10g_tx_pcs_tx_scrm_err     		(hssi_10g_tx_pcs_tx_scrm_err    ),
           .hssi_10g_tx_pcs_tx_scrm_width   		(hssi_10g_tx_pcs_tx_scrm_width  ),
           .hssi_10g_tx_pcs_tx_sh_location  		(hssi_10g_tx_pcs_tx_sh_location ),
           .hssi_10g_tx_pcs_tx_sm_bypass    		(hssi_10g_tx_pcs_tx_sm_bypass   ),
           .hssi_10g_tx_pcs_tx_sm_pipeln    		(hssi_10g_tx_pcs_tx_sm_pipeln   ),
           .hssi_10g_tx_pcs_tx_testbus_sel  		(hssi_10g_tx_pcs_tx_testbus_sel ),
           .hssi_10g_tx_pcs_txfifo_empty    		(hssi_10g_tx_pcs_txfifo_empty   ),
           .hssi_10g_tx_pcs_txfifo_full     		(hssi_10g_tx_pcs_txfifo_full    ),
           .hssi_10g_tx_pcs_txfifo_mode     		(hssi_10g_tx_pcs_txfifo_mode    ),
           .hssi_10g_tx_pcs_txfifo_pempty   		(hssi_10g_tx_pcs_txfifo_pempty  ),
           .hssi_10g_tx_pcs_txfifo_pfull    		(hssi_10g_tx_pcs_txfifo_pfull   ),
           .hssi_10g_tx_pcs_wr_clk_sel      		(hssi_10g_tx_pcs_wr_clk_sel     ),
           .hssi_10g_tx_pcs_wrfifo_clken    		(hssi_10g_tx_pcs_wrfifo_clken   ),
           .hssi_8g_rx_pcs_auto_error_replacement  		(hssi_8g_rx_pcs_auto_error_replacement ),
           .hssi_8g_rx_pcs_auto_speed_nego  		(hssi_8g_rx_pcs_auto_speed_nego ),
           .hssi_8g_rx_pcs_bit_reversal     		(hssi_8g_rx_pcs_bit_reversal    ),
           .hssi_8g_rx_pcs_bonding_dft_en   		(hssi_8g_rx_pcs_bonding_dft_en  ),
           .hssi_8g_rx_pcs_bonding_dft_val  		(hssi_8g_rx_pcs_bonding_dft_val ),
           .hssi_8g_rx_pcs_bypass_pipeline_reg  		(hssi_8g_rx_pcs_bypass_pipeline_reg ),
           .hssi_8g_rx_pcs_byte_deserializer  		(hssi_8g_rx_pcs_byte_deserializer ),
           .hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask  		(hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask ),
           .hssi_8g_rx_pcs_clkcmp_pattern_n  		(hssi_8g_rx_pcs_clkcmp_pattern_n ),
           .hssi_8g_rx_pcs_clkcmp_pattern_p  		(hssi_8g_rx_pcs_clkcmp_pattern_p ),
           .hssi_8g_rx_pcs_clock_gate_bds_dec_asn  		(hssi_8g_rx_pcs_clock_gate_bds_dec_asn ),
           .hssi_8g_rx_pcs_clock_gate_cdr_eidle  		(hssi_8g_rx_pcs_clock_gate_cdr_eidle ),
           .hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_dw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_dw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_dw_wa  		(hssi_8g_rx_pcs_clock_gate_dw_wa ),
           .hssi_8g_rx_pcs_clock_gate_pc_rdclk  		(hssi_8g_rx_pcs_clock_gate_pc_rdclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_sw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_sw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_sw_wa  		(hssi_8g_rx_pcs_clock_gate_sw_wa ),
           .hssi_8g_rx_pcs_clock_observation_in_pld_core  		(hssi_8g_rx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_rx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_rx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_rx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_rx_pcs_eidle_entry_eios  		(hssi_8g_rx_pcs_eidle_entry_eios ),
           .hssi_8g_rx_pcs_eidle_entry_iei  		(hssi_8g_rx_pcs_eidle_entry_iei ),
           .hssi_8g_rx_pcs_eidle_entry_sd   		(hssi_8g_rx_pcs_eidle_entry_sd  ),
           .hssi_8g_rx_pcs_eightb_tenb_decoder  		(hssi_8g_rx_pcs_eightb_tenb_decoder ),
           .hssi_8g_rx_pcs_err_flags_sel    		(hssi_8g_rx_pcs_err_flags_sel   ),
           .hssi_8g_rx_pcs_fixed_pat_det    		(hssi_8g_rx_pcs_fixed_pat_det   ),
           .hssi_8g_rx_pcs_fixed_pat_num    		(hssi_8g_rx_pcs_fixed_pat_num   ),
           .hssi_8g_rx_pcs_force_signal_detect  		(hssi_8g_rx_pcs_force_signal_detect ),
           .hssi_8g_rx_pcs_gen3_clk_en      		(hssi_8g_rx_pcs_gen3_clk_en     ),
           .hssi_8g_rx_pcs_gen3_rx_clk_sel  		(hssi_8g_rx_pcs_gen3_rx_clk_sel ),
           .hssi_8g_rx_pcs_gen3_tx_clk_sel  		(hssi_8g_rx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_rx_pcs_hip_mode         		(hssi_8g_rx_pcs_hip_mode        ),
           .hssi_8g_rx_pcs_ibm_invalid_code  		(hssi_8g_rx_pcs_ibm_invalid_code ),
           .hssi_8g_rx_pcs_invalid_code_flag_only  		(hssi_8g_rx_pcs_invalid_code_flag_only ),
           .hssi_8g_rx_pcs_pad_or_edb_error_replace  		(hssi_8g_rx_pcs_pad_or_edb_error_replace ),
           .hssi_8g_rx_pcs_pcs_bypass       		(hssi_8g_rx_pcs_pcs_bypass      ),
           .hssi_8g_rx_pcs_phase_comp_rdptr  		(hssi_8g_rx_pcs_phase_comp_rdptr ),
           .hssi_8g_rx_pcs_phase_compensation_fifo  		(hssi_8g_rx_pcs_phase_compensation_fifo ),
           .hssi_8g_rx_pcs_pipe_if_enable   		(hssi_8g_rx_pcs_pipe_if_enable  ),
           .hssi_8g_rx_pcs_pma_dw           		(hssi_8g_rx_pcs_pma_dw          ),
           .hssi_8g_rx_pcs_polinv_8b10b_dec  		(hssi_8g_rx_pcs_polinv_8b10b_dec ),
           .hssi_8g_rx_pcs_prot_mode        		(hssi_8g_rx_pcs_prot_mode       ),
           .hssi_8g_rx_pcs_rate_match       		(hssi_8g_rx_pcs_rate_match      ),
           .hssi_8g_rx_pcs_rate_match_del_thres  		(hssi_8g_rx_pcs_rate_match_del_thres ),
           .hssi_8g_rx_pcs_rate_match_empty_thres  		(hssi_8g_rx_pcs_rate_match_empty_thres ),
           .hssi_8g_rx_pcs_rate_match_full_thres  		(hssi_8g_rx_pcs_rate_match_full_thres ),
           .hssi_8g_rx_pcs_rate_match_ins_thres  		(hssi_8g_rx_pcs_rate_match_ins_thres ),
           .hssi_8g_rx_pcs_rate_match_start_thres  		(hssi_8g_rx_pcs_rate_match_start_thres ),
           .hssi_8g_rx_pcs_reconfig_settings  		(hssi_8g_rx_pcs_reconfig_settings ),
           .hssi_8g_rx_pcs_rx_clk2          		(hssi_8g_rx_pcs_rx_clk2         ),
           .hssi_8g_rx_pcs_rx_clk_free_running  		(hssi_8g_rx_pcs_rx_clk_free_running ),
           .hssi_8g_rx_pcs_rx_pcs_urst      		(hssi_8g_rx_pcs_rx_pcs_urst     ),
           .hssi_8g_rx_pcs_rx_rcvd_clk      		(hssi_8g_rx_pcs_rx_rcvd_clk     ),
           .hssi_8g_rx_pcs_rx_rd_clk        		(hssi_8g_rx_pcs_rx_rd_clk       ),
           .hssi_8g_rx_pcs_rx_refclk        		(hssi_8g_rx_pcs_rx_refclk       ),
           .hssi_8g_rx_pcs_rx_wr_clk        		(hssi_8g_rx_pcs_rx_wr_clk       ),
           .hssi_8g_rx_pcs_sup_mode         		(hssi_8g_rx_pcs_sup_mode        ),
           .hssi_8g_rx_pcs_symbol_swap      		(hssi_8g_rx_pcs_symbol_swap     ),
           .hssi_8g_rx_pcs_sync_sm_idle_eios  		(hssi_8g_rx_pcs_sync_sm_idle_eios ),
           .hssi_8g_rx_pcs_test_bus_sel     		(hssi_8g_rx_pcs_test_bus_sel    ),
           .hssi_8g_rx_pcs_tx_rx_parallel_loopback  		(hssi_8g_rx_pcs_tx_rx_parallel_loopback ),
           .hssi_8g_rx_pcs_wa_boundary_lock_ctrl  		(hssi_8g_rx_pcs_wa_boundary_lock_ctrl ),
           .hssi_8g_rx_pcs_wa_clk_slip_spacing  		(hssi_8g_rx_pcs_wa_clk_slip_spacing ),
           .hssi_8g_rx_pcs_wa_det_latency_sync_status_beh  		(hssi_8g_rx_pcs_wa_det_latency_sync_status_beh ),
           .hssi_8g_rx_pcs_wa_disp_err_flag  		(hssi_8g_rx_pcs_wa_disp_err_flag ),
           .hssi_8g_rx_pcs_wa_kchar         		(hssi_8g_rx_pcs_wa_kchar        ),
           .hssi_8g_rx_pcs_wa_pd            		(hssi_8g_rx_pcs_wa_pd           ),
           .hssi_8g_rx_pcs_wa_pd_data       		(hssi_8g_rx_pcs_wa_pd_data      ),
           .hssi_8g_rx_pcs_wa_pd_polarity   		(hssi_8g_rx_pcs_wa_pd_polarity  ),
           .hssi_8g_rx_pcs_wa_pld_controlled  		(hssi_8g_rx_pcs_wa_pld_controlled ),
           .hssi_8g_rx_pcs_wa_renumber_data  		(hssi_8g_rx_pcs_wa_renumber_data ),
           .hssi_8g_rx_pcs_wa_rgnumber_data  		(hssi_8g_rx_pcs_wa_rgnumber_data ),
           .hssi_8g_rx_pcs_wa_rknumber_data  		(hssi_8g_rx_pcs_wa_rknumber_data ),
           .hssi_8g_rx_pcs_wa_rosnumber_data  		(hssi_8g_rx_pcs_wa_rosnumber_data ),
           .hssi_8g_rx_pcs_wa_rvnumber_data  		(hssi_8g_rx_pcs_wa_rvnumber_data ),
           .hssi_8g_rx_pcs_wa_sync_sm_ctrl  		(hssi_8g_rx_pcs_wa_sync_sm_ctrl ),
           .hssi_8g_rx_pcs_wait_cnt         		(hssi_8g_rx_pcs_wait_cnt        ),
           .hssi_8g_tx_pcs_auto_speed_nego_gen2  		(hssi_8g_tx_pcs_auto_speed_nego_gen2 ),
           .hssi_8g_tx_pcs_bit_reversal     		(hssi_8g_tx_pcs_bit_reversal    ),
           .hssi_8g_tx_pcs_bonding_dft_en   		(hssi_8g_tx_pcs_bonding_dft_en  ),
           .hssi_8g_tx_pcs_bonding_dft_val  		(hssi_8g_tx_pcs_bonding_dft_val ),
           .hssi_8g_tx_pcs_bypass_pipeline_reg  		(hssi_8g_tx_pcs_bypass_pipeline_reg ),
           .hssi_8g_tx_pcs_byte_serializer  		(hssi_8g_tx_pcs_byte_serializer ),
           .hssi_8g_tx_pcs_clock_gate_bs_enc  		(hssi_8g_tx_pcs_clock_gate_bs_enc ),
           .hssi_8g_tx_pcs_clock_gate_dw_fifowr  		(hssi_8g_tx_pcs_clock_gate_dw_fifowr ),
           .hssi_8g_tx_pcs_clock_gate_fiford  		(hssi_8g_tx_pcs_clock_gate_fiford ),
           .hssi_8g_tx_pcs_clock_gate_sw_fifowr  		(hssi_8g_tx_pcs_clock_gate_sw_fifowr ),
           .hssi_8g_tx_pcs_clock_observation_in_pld_core  		(hssi_8g_tx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_tx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_tx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_tx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_tx_pcs_data_selection_8b10b_encoder_input  		(hssi_8g_tx_pcs_data_selection_8b10b_encoder_input ),
           .hssi_8g_tx_pcs_dynamic_clk_switch  		(hssi_8g_tx_pcs_dynamic_clk_switch ),
           .hssi_8g_tx_pcs_eightb_tenb_disp_ctrl  		(hssi_8g_tx_pcs_eightb_tenb_disp_ctrl ),
           .hssi_8g_tx_pcs_eightb_tenb_encoder  		(hssi_8g_tx_pcs_eightb_tenb_encoder ),
           .hssi_8g_tx_pcs_force_echar      		(hssi_8g_tx_pcs_force_echar     ),
           .hssi_8g_tx_pcs_force_kchar      		(hssi_8g_tx_pcs_force_kchar     ),
           .hssi_8g_tx_pcs_gen3_tx_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel ),
           .hssi_8g_tx_pcs_hip_mode         		(hssi_8g_tx_pcs_hip_mode        ),
           .hssi_8g_tx_pcs_pcs_bypass       		(hssi_8g_tx_pcs_pcs_bypass      ),
           .hssi_8g_tx_pcs_phase_comp_rdptr  		(hssi_8g_tx_pcs_phase_comp_rdptr ),
           .hssi_8g_tx_pcs_phase_compensation_fifo  		(hssi_8g_tx_pcs_phase_compensation_fifo ),
           .hssi_8g_tx_pcs_phfifo_write_clk_sel  		(hssi_8g_tx_pcs_phfifo_write_clk_sel ),
           .hssi_8g_tx_pcs_pma_dw           		(hssi_8g_tx_pcs_pma_dw          ),
           .hssi_8g_tx_pcs_prot_mode        		(hssi_8g_tx_pcs_prot_mode       ),
           .hssi_8g_tx_pcs_reconfig_settings  		(hssi_8g_tx_pcs_reconfig_settings ),
           .hssi_8g_tx_pcs_refclk_b_clk_sel  		(hssi_8g_tx_pcs_refclk_b_clk_sel ),
           .hssi_8g_tx_pcs_revloop_back_rm  		(hssi_8g_tx_pcs_revloop_back_rm ),
           .hssi_8g_tx_pcs_sup_mode         		(hssi_8g_tx_pcs_sup_mode        ),
           .hssi_8g_tx_pcs_symbol_swap      		(hssi_8g_tx_pcs_symbol_swap     ),
           .hssi_8g_tx_pcs_tx_bitslip       		(hssi_8g_tx_pcs_tx_bitslip      ),
           .hssi_8g_tx_pcs_tx_compliance_controlled_disparity  		(hssi_8g_tx_pcs_tx_compliance_controlled_disparity ),
           .hssi_8g_tx_pcs_tx_fast_pld_reg  		(hssi_8g_tx_pcs_tx_fast_pld_reg ),
           .hssi_8g_tx_pcs_txclk_freerun    		(hssi_8g_tx_pcs_txclk_freerun   ),
           .hssi_8g_tx_pcs_txpcs_urst       		(hssi_8g_tx_pcs_txpcs_urst      ),
           .hssi_common_pcs_pma_interface_asn_clk_enable  		(hssi_common_pcs_pma_interface_asn_clk_enable ),
           .hssi_common_pcs_pma_interface_asn_enable  		(hssi_common_pcs_pma_interface_asn_enable ),
           .hssi_common_pcs_pma_interface_block_sel  		(hssi_common_pcs_pma_interface_block_sel ),
           .hssi_common_pcs_pma_interface_bypass_early_eios  		(hssi_common_pcs_pma_interface_bypass_early_eios ),
           .hssi_common_pcs_pma_interface_bypass_pcie_switch  		(hssi_common_pcs_pma_interface_bypass_pcie_switch ),
           .hssi_common_pcs_pma_interface_bypass_pma_ltr  		(hssi_common_pcs_pma_interface_bypass_pma_ltr ),
           .hssi_common_pcs_pma_interface_bypass_pma_sw_done  		(hssi_common_pcs_pma_interface_bypass_pma_sw_done ),
           .hssi_common_pcs_pma_interface_bypass_ppm_lock  		(hssi_common_pcs_pma_interface_bypass_ppm_lock ),
           .hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp ),
           .hssi_common_pcs_pma_interface_bypass_txdetectrx  		(hssi_common_pcs_pma_interface_bypass_txdetectrx ),
           .hssi_common_pcs_pma_interface_cdr_control  		(hssi_common_pcs_pma_interface_cdr_control ),
           .hssi_common_pcs_pma_interface_cid_enable  		(hssi_common_pcs_pma_interface_cid_enable ),
           .hssi_common_pcs_pma_interface_cp_cons_sel  		(hssi_common_pcs_pma_interface_cp_cons_sel ),
           .hssi_common_pcs_pma_interface_cp_dwn_mstr  		(hssi_common_pcs_pma_interface_cp_dwn_mstr ),
           .hssi_common_pcs_pma_interface_cp_up_mstr  		(hssi_common_pcs_pma_interface_cp_up_mstr ),
           .hssi_common_pcs_pma_interface_ctrl_plane_bonding  		(hssi_common_pcs_pma_interface_ctrl_plane_bonding ),
           .hssi_common_pcs_pma_interface_data_mask_count  		(hssi_common_pcs_pma_interface_data_mask_count ),
           .hssi_common_pcs_pma_interface_data_mask_count_multi  		(hssi_common_pcs_pma_interface_data_mask_count_multi ),
           .hssi_common_pcs_pma_interface_dft_observation_clock_selection  		(hssi_common_pcs_pma_interface_dft_observation_clock_selection ),
           .hssi_common_pcs_pma_interface_early_eios_counter  		(hssi_common_pcs_pma_interface_early_eios_counter ),
           .hssi_common_pcs_pma_interface_force_freqdet  		(hssi_common_pcs_pma_interface_force_freqdet ),
           .hssi_common_pcs_pma_interface_free_run_clk_enable  		(hssi_common_pcs_pma_interface_free_run_clk_enable ),
           .hssi_common_pcs_pma_interface_ignore_sigdet_g23  		(hssi_common_pcs_pma_interface_ignore_sigdet_g23 ),
           .hssi_common_pcs_pma_interface_pc_en_counter  		(hssi_common_pcs_pma_interface_pc_en_counter ),
           .hssi_common_pcs_pma_interface_pc_rst_counter  		(hssi_common_pcs_pma_interface_pc_rst_counter ),
           .hssi_common_pcs_pma_interface_pcie_hip_mode  		(hssi_common_pcs_pma_interface_pcie_hip_mode ),
           .hssi_common_pcs_pma_interface_ph_fifo_reg_mode  		(hssi_common_pcs_pma_interface_ph_fifo_reg_mode ),
           .hssi_common_pcs_pma_interface_phfifo_flush_wait  		(hssi_common_pcs_pma_interface_phfifo_flush_wait ),
           .hssi_common_pcs_pma_interface_pipe_if_g3pcs  		(hssi_common_pcs_pma_interface_pipe_if_g3pcs ),
           .hssi_common_pcs_pma_interface_pma_done_counter  		(hssi_common_pcs_pma_interface_pma_done_counter ),
           .hssi_common_pcs_pma_interface_pma_if_dft_en  		(hssi_common_pcs_pma_interface_pma_if_dft_en ),
           .hssi_common_pcs_pma_interface_pma_if_dft_val  		(hssi_common_pcs_pma_interface_pma_if_dft_val ),
           .hssi_common_pcs_pma_interface_ppm_cnt_rst  		(hssi_common_pcs_pma_interface_ppm_cnt_rst ),
           .hssi_common_pcs_pma_interface_ppm_deassert_early  		(hssi_common_pcs_pma_interface_ppm_deassert_early ),
           .hssi_common_pcs_pma_interface_ppm_det_buckets  		(hssi_common_pcs_pma_interface_ppm_det_buckets ),
           .hssi_common_pcs_pma_interface_ppm_gen1_2_cnt  		(hssi_common_pcs_pma_interface_ppm_gen1_2_cnt ),
           .hssi_common_pcs_pma_interface_ppm_post_eidle_delay  		(hssi_common_pcs_pma_interface_ppm_post_eidle_delay ),
           .hssi_common_pcs_pma_interface_ppmsel  		(hssi_common_pcs_pma_interface_ppmsel ),
           .hssi_common_pcs_pma_interface_prot_mode  		(hssi_common_pcs_pma_interface_prot_mode ),
           .hssi_common_pcs_pma_interface_reconfig_settings  		(hssi_common_pcs_pma_interface_reconfig_settings ),
           .hssi_common_pcs_pma_interface_rxvalid_mask  		(hssi_common_pcs_pma_interface_rxvalid_mask ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter  		(hssi_common_pcs_pma_interface_sigdet_wait_counter ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter_multi  		(hssi_common_pcs_pma_interface_sigdet_wait_counter_multi ),
           .hssi_common_pcs_pma_interface_sim_mode  		(hssi_common_pcs_pma_interface_sim_mode ),
           .hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en  		(hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en ),
           .hssi_common_pcs_pma_interface_sup_mode  		(hssi_common_pcs_pma_interface_sup_mode ),
           .hssi_common_pcs_pma_interface_testout_sel  		(hssi_common_pcs_pma_interface_testout_sel ),
           .hssi_common_pcs_pma_interface_wait_clk_on_off_timer  		(hssi_common_pcs_pma_interface_wait_clk_on_off_timer ),
           .hssi_common_pcs_pma_interface_wait_pipe_synchronizing  		(hssi_common_pcs_pma_interface_wait_pipe_synchronizing ),
           .hssi_common_pcs_pma_interface_wait_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_wait_send_syncp_fbkp ),
           .hssi_common_pld_pcs_interface_dft_clk_out_en  		(hssi_common_pld_pcs_interface_dft_clk_out_en ),
           .hssi_common_pld_pcs_interface_dft_clk_out_sel  		(hssi_common_pld_pcs_interface_dft_clk_out_sel ),
           .hssi_common_pld_pcs_interface_hrdrstctrl_en  		(hssi_common_pld_pcs_interface_hrdrstctrl_en ),
           .hssi_common_pld_pcs_interface_pcs_testbus_block_sel  		(hssi_common_pld_pcs_interface_pcs_testbus_block_sel ),
           .hssi_common_pld_pcs_interface_reconfig_settings  		(hssi_common_pld_pcs_interface_reconfig_settings ),
           .hssi_fifo_rx_pcs_double_read_mode  		(hssi_fifo_rx_pcs_double_read_mode ),
           .hssi_fifo_rx_pcs_prot_mode      		(hssi_fifo_rx_pcs_prot_mode     ),
           .hssi_fifo_tx_pcs_double_write_mode  		(hssi_fifo_tx_pcs_double_write_mode ),
           .hssi_fifo_tx_pcs_prot_mode      		(hssi_fifo_tx_pcs_prot_mode     ),
           .hssi_gen3_rx_pcs_block_sync     		(hssi_gen3_rx_pcs_block_sync    ),
           .hssi_gen3_rx_pcs_block_sync_sm  		(hssi_gen3_rx_pcs_block_sync_sm ),
           .hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn  		(hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn ),
           .hssi_gen3_rx_pcs_lpbk_force     		(hssi_gen3_rx_pcs_lpbk_force    ),
           .hssi_gen3_rx_pcs_mode           		(hssi_gen3_rx_pcs_mode          ),
           .hssi_gen3_rx_pcs_rate_match_fifo  		(hssi_gen3_rx_pcs_rate_match_fifo ),
           .hssi_gen3_rx_pcs_rate_match_fifo_latency  		(hssi_gen3_rx_pcs_rate_match_fifo_latency ),
           .hssi_gen3_rx_pcs_reconfig_settings  		(hssi_gen3_rx_pcs_reconfig_settings ),
           .hssi_gen3_rx_pcs_reverse_lpbk   		(hssi_gen3_rx_pcs_reverse_lpbk  ),
           .hssi_gen3_rx_pcs_rx_b4gb_par_lpbk  		(hssi_gen3_rx_pcs_rx_b4gb_par_lpbk ),
           .hssi_gen3_rx_pcs_rx_force_balign  		(hssi_gen3_rx_pcs_rx_force_balign ),
           .hssi_gen3_rx_pcs_rx_ins_del_one_skip  		(hssi_gen3_rx_pcs_rx_ins_del_one_skip ),
           .hssi_gen3_rx_pcs_rx_num_fixed_pat  		(hssi_gen3_rx_pcs_rx_num_fixed_pat ),
           .hssi_gen3_rx_pcs_rx_test_out_sel  		(hssi_gen3_rx_pcs_rx_test_out_sel ),
           .hssi_gen3_rx_pcs_sup_mode       		(hssi_gen3_rx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_mode           		(hssi_gen3_tx_pcs_mode          ),
           .hssi_gen3_tx_pcs_reverse_lpbk   		(hssi_gen3_tx_pcs_reverse_lpbk  ),
           .hssi_gen3_tx_pcs_sup_mode       		(hssi_gen3_tx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_tx_bitslip     		(hssi_gen3_tx_pcs_tx_bitslip    ),
           .hssi_gen3_tx_pcs_tx_gbox_byp    		(hssi_gen3_tx_pcs_tx_gbox_byp   ),
           .hssi_krfec_rx_pcs_blksync_cor_en  		(hssi_krfec_rx_pcs_blksync_cor_en ),
           .hssi_krfec_rx_pcs_bypass_gb     		(hssi_krfec_rx_pcs_bypass_gb    ),
           .hssi_krfec_rx_pcs_clr_ctrl      		(hssi_krfec_rx_pcs_clr_ctrl     ),
           .hssi_krfec_rx_pcs_ctrl_bit_reverse  		(hssi_krfec_rx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_rx_pcs_data_bit_reverse  		(hssi_krfec_rx_pcs_data_bit_reverse ),
           .hssi_krfec_rx_pcs_dv_start      		(hssi_krfec_rx_pcs_dv_start     ),
           .hssi_krfec_rx_pcs_err_mark_type  		(hssi_krfec_rx_pcs_err_mark_type ),
           .hssi_krfec_rx_pcs_error_marking_en  		(hssi_krfec_rx_pcs_error_marking_en ),
           .hssi_krfec_rx_pcs_low_latency_en  		(hssi_krfec_rx_pcs_low_latency_en ),
           .hssi_krfec_rx_pcs_lpbk_mode     		(hssi_krfec_rx_pcs_lpbk_mode    ),
           .hssi_krfec_rx_pcs_parity_invalid_enum  		(hssi_krfec_rx_pcs_parity_invalid_enum ),
           .hssi_krfec_rx_pcs_parity_valid_num  		(hssi_krfec_rx_pcs_parity_valid_num ),
           .hssi_krfec_rx_pcs_pipeln_blksync  		(hssi_krfec_rx_pcs_pipeln_blksync ),
           .hssi_krfec_rx_pcs_pipeln_descrm  		(hssi_krfec_rx_pcs_pipeln_descrm ),
           .hssi_krfec_rx_pcs_pipeln_errcorrect  		(hssi_krfec_rx_pcs_pipeln_errcorrect ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_ind  		(hssi_krfec_rx_pcs_pipeln_errtrap_ind ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_lfsr  		(hssi_krfec_rx_pcs_pipeln_errtrap_lfsr ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_loc  		(hssi_krfec_rx_pcs_pipeln_errtrap_loc ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_pat  		(hssi_krfec_rx_pcs_pipeln_errtrap_pat ),
           .hssi_krfec_rx_pcs_pipeln_gearbox  		(hssi_krfec_rx_pcs_pipeln_gearbox ),
           .hssi_krfec_rx_pcs_pipeln_syndrm  		(hssi_krfec_rx_pcs_pipeln_syndrm ),
           .hssi_krfec_rx_pcs_pipeln_trans_dec  		(hssi_krfec_rx_pcs_pipeln_trans_dec ),
           .hssi_krfec_rx_pcs_prot_mode     		(hssi_krfec_rx_pcs_prot_mode    ),
           .hssi_krfec_rx_pcs_receive_order  		(hssi_krfec_rx_pcs_receive_order ),
           .hssi_krfec_rx_pcs_reconfig_settings  		(hssi_krfec_rx_pcs_reconfig_settings ),
           .hssi_krfec_rx_pcs_rx_testbus_sel  		(hssi_krfec_rx_pcs_rx_testbus_sel ),
           .hssi_krfec_rx_pcs_signal_ok_en  		(hssi_krfec_rx_pcs_signal_ok_en ),
           .hssi_krfec_rx_pcs_sup_mode      		(hssi_krfec_rx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_burst_err     		(hssi_krfec_tx_pcs_burst_err    ),
           .hssi_krfec_tx_pcs_burst_err_len  		(hssi_krfec_tx_pcs_burst_err_len ),
           .hssi_krfec_tx_pcs_ctrl_bit_reverse  		(hssi_krfec_tx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_tx_pcs_data_bit_reverse  		(hssi_krfec_tx_pcs_data_bit_reverse ),
           .hssi_krfec_tx_pcs_enc_frame_query  		(hssi_krfec_tx_pcs_enc_frame_query ),
           .hssi_krfec_tx_pcs_low_latency_en  		(hssi_krfec_tx_pcs_low_latency_en ),
           .hssi_krfec_tx_pcs_pipeln_encoder  		(hssi_krfec_tx_pcs_pipeln_encoder ),
           .hssi_krfec_tx_pcs_pipeln_scrambler  		(hssi_krfec_tx_pcs_pipeln_scrambler ),
           .hssi_krfec_tx_pcs_prot_mode     		(hssi_krfec_tx_pcs_prot_mode    ),
           .hssi_krfec_tx_pcs_sup_mode      		(hssi_krfec_tx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_transcode_err  		(hssi_krfec_tx_pcs_transcode_err ),
           .hssi_krfec_tx_pcs_transmit_order  		(hssi_krfec_tx_pcs_transmit_order ),
           .hssi_krfec_tx_pcs_tx_testbus_sel  		(hssi_krfec_tx_pcs_tx_testbus_sel ),
           .hssi_pipe_gen1_2_elec_idle_delay_val  		(hssi_pipe_gen1_2_elec_idle_delay_val ),
           .hssi_pipe_gen1_2_error_replace_pad  		(hssi_pipe_gen1_2_error_replace_pad ),
           .hssi_pipe_gen1_2_hip_mode       		(hssi_pipe_gen1_2_hip_mode      ),
           .hssi_pipe_gen1_2_ind_error_reporting  		(hssi_pipe_gen1_2_ind_error_reporting ),
           .hssi_pipe_gen1_2_phystatus_delay_val  		(hssi_pipe_gen1_2_phystatus_delay_val ),
           .hssi_pipe_gen1_2_phystatus_rst_toggle  		(hssi_pipe_gen1_2_phystatus_rst_toggle ),
           .hssi_pipe_gen1_2_pipe_byte_de_serializer_en  		(hssi_pipe_gen1_2_pipe_byte_de_serializer_en ),
           .hssi_pipe_gen1_2_prot_mode      		(hssi_pipe_gen1_2_prot_mode     ),
           .hssi_pipe_gen1_2_reconfig_settings  		(hssi_pipe_gen1_2_reconfig_settings ),
           .hssi_pipe_gen1_2_rx_pipe_enable  		(hssi_pipe_gen1_2_rx_pipe_enable ),
           .hssi_pipe_gen1_2_rxdetect_bypass  		(hssi_pipe_gen1_2_rxdetect_bypass ),
           .hssi_pipe_gen1_2_sup_mode       		(hssi_pipe_gen1_2_sup_mode      ),
           .hssi_pipe_gen1_2_tx_pipe_enable  		(hssi_pipe_gen1_2_tx_pipe_enable ),
           .hssi_pipe_gen1_2_txswing        		(hssi_pipe_gen1_2_txswing       ),
           .hssi_pipe_gen3_bypass_rx_detection_enable  		(hssi_pipe_gen3_bypass_rx_detection_enable ),
           .hssi_pipe_gen3_bypass_rx_preset  		(hssi_pipe_gen3_bypass_rx_preset ),
           .hssi_pipe_gen3_bypass_rx_preset_enable  		(hssi_pipe_gen3_bypass_rx_preset_enable ),
           .hssi_pipe_gen3_bypass_tx_coefficent  		(hssi_pipe_gen3_bypass_tx_coefficent ),
           .hssi_pipe_gen3_bypass_tx_coefficent_enable  		(hssi_pipe_gen3_bypass_tx_coefficent_enable ),
           .hssi_pipe_gen3_elecidle_delay_g3  		(hssi_pipe_gen3_elecidle_delay_g3 ),
           .hssi_pipe_gen3_ind_error_reporting  		(hssi_pipe_gen3_ind_error_reporting ),
           .hssi_pipe_gen3_mode             		(hssi_pipe_gen3_mode            ),
           .hssi_pipe_gen3_phy_status_delay_g12  		(hssi_pipe_gen3_phy_status_delay_g12 ),
           .hssi_pipe_gen3_phy_status_delay_g3  		(hssi_pipe_gen3_phy_status_delay_g3 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g12  		(hssi_pipe_gen3_phystatus_rst_toggle_g12 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g3  		(hssi_pipe_gen3_phystatus_rst_toggle_g3 ),
           .hssi_pipe_gen3_rate_match_pad_insertion  		(hssi_pipe_gen3_rate_match_pad_insertion ),
           .hssi_pipe_gen3_sup_mode         		(hssi_pipe_gen3_sup_mode        ),
           .hssi_pipe_gen3_test_out_sel     		(hssi_pipe_gen3_test_out_sel    ),
           .hssi_rx_pcs_pma_interface_block_sel  		(hssi_rx_pcs_pma_interface_block_sel ),
           .hssi_rx_pcs_pma_interface_channel_operation_mode  		(hssi_rx_pcs_pma_interface_channel_operation_mode ),
           .hssi_rx_pcs_pma_interface_clkslip_sel  		(hssi_rx_pcs_pma_interface_clkslip_sel ),
           .hssi_rx_pcs_pma_interface_lpbk_en  		(hssi_rx_pcs_pma_interface_lpbk_en ),
           .hssi_rx_pcs_pma_interface_master_clk_sel  		(hssi_rx_pcs_pma_interface_master_clk_sel ),
           .hssi_rx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_rx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_rx_pcs_pma_interface_pma_dw_rx  		(hssi_rx_pcs_pma_interface_pma_dw_rx ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_en  		(hssi_rx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_val  		(hssi_rx_pcs_pma_interface_pma_if_dft_val ),
           .hssi_rx_pcs_pma_interface_prbs9_dwidth  		(hssi_rx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_rx_pcs_pma_interface_prbs_clken  		(hssi_rx_pcs_pma_interface_prbs_clken ),
           .hssi_rx_pcs_pma_interface_prbs_ver  		(hssi_rx_pcs_pma_interface_prbs_ver ),
           .hssi_rx_pcs_pma_interface_prot_mode_rx  		(hssi_rx_pcs_pma_interface_prot_mode_rx ),
           .hssi_rx_pcs_pma_interface_reconfig_settings  		(hssi_rx_pcs_pma_interface_reconfig_settings ),
           .hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_lpbk_en ),
           .hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok  		(hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mask  		(hssi_rx_pcs_pma_interface_rx_prbs_mask ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mode  		(hssi_rx_pcs_pma_interface_rx_prbs_mode ),
           .hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel  		(hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel ),
           .hssi_rx_pcs_pma_interface_rx_static_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_static_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en ),
           .hssi_rx_pcs_pma_interface_sup_mode  		(hssi_rx_pcs_pma_interface_sup_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_rx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_rx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_rx_pld_pcs_interface_pcs_rx_block_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_block_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en  		(hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en ),
           .hssi_rx_pld_pcs_interface_pcs_rx_output_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_output_sel ),
           .hssi_rx_pld_pcs_interface_reconfig_settings  		(hssi_rx_pld_pcs_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_bypass_pma_txelecidle  		(hssi_tx_pcs_pma_interface_bypass_pma_txelecidle ),
           .hssi_tx_pcs_pma_interface_channel_operation_mode  		(hssi_tx_pcs_pma_interface_channel_operation_mode ),
           .hssi_tx_pcs_pma_interface_lpbk_en  		(hssi_tx_pcs_pma_interface_lpbk_en ),
           .hssi_tx_pcs_pma_interface_master_clk_sel  		(hssi_tx_pcs_pma_interface_master_clk_sel ),
           .hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx  		(hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_tx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_tx_pcs_pma_interface_pma_dw_tx  		(hssi_tx_pcs_pma_interface_pma_dw_tx ),
           .hssi_tx_pcs_pma_interface_pma_if_dft_en  		(hssi_tx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_tx_pcs_pma_interface_pmagate_en  		(hssi_tx_pcs_pma_interface_pmagate_en ),
           .hssi_tx_pcs_pma_interface_prbs9_dwidth  		(hssi_tx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_tx_pcs_pma_interface_prbs_clken  		(hssi_tx_pcs_pma_interface_prbs_clken ),
           .hssi_tx_pcs_pma_interface_prbs_gen_pat  		(hssi_tx_pcs_pma_interface_prbs_gen_pat ),
           .hssi_tx_pcs_pma_interface_prot_mode_tx  		(hssi_tx_pcs_pma_interface_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_reconfig_settings  		(hssi_tx_pcs_pma_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_sq_wave_num  		(hssi_tx_pcs_pma_interface_sq_wave_num ),
           .hssi_tx_pcs_pma_interface_sqwgen_clken  		(hssi_tx_pcs_pma_interface_sqwgen_clken ),
           .hssi_tx_pcs_pma_interface_sup_mode  		(hssi_tx_pcs_pma_interface_sup_mode ),
           .hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_tx_pma_data_sel  		(hssi_tx_pcs_pma_interface_tx_pma_data_sel ),
           .hssi_tx_pcs_pma_interface_tx_static_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_static_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period  		(hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable  		(hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control ),
           .hssi_tx_pcs_pma_interface_uhsif_enable  		(hssi_tx_pcs_pma_interface_uhsif_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value ),
           .hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_tx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_tx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding  		(hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_source  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_data_source  		(hssi_tx_pld_pcs_interface_pcs_tx_data_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_output_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_output_sel ),
           .hssi_tx_pld_pcs_interface_reconfig_settings  		(hssi_tx_pld_pcs_interface_reconfig_settings ),
           .avmm_interfaces                 		(avmm_interfaces                ),
           .rcfg_enable                     		(rcfg_enable                    ),
           .enable_avmm                     		(enable_avmm                    ),
           .arbiter_ctrl                    		(arbiter_ctrl                   ),
           .calibration_en                  		(calibration_en                 ),
           .avmm_busy_en                    		(avmm_busy_en                   ),
           .hip_cal_en                      		(hip_cal_en                     ),
           .cal_done                        		(cal_done                       )
                  )
               twentynm_xcvr_native_inst(.*);
             end


  "20nm5es2": begin
               twentynm_xcvr_native_rev_20nm5es2
                 #(
			
           .bonded_lanes                    		(bonded_lanes                   ),
           .bonding_master_ch               		(bonding_master_ch              ),
           .xcvr_native_mode                		(xcvr_native_mode               ),
           .pma_adapt_adapt_mode            		(pma_adapt_adapt_mode           ),
           .pma_adapt_adp_1s_ctle_bypass    		(pma_adapt_adp_1s_ctle_bypass   ),
           .pma_adapt_adp_4s_ctle_bypass    		(pma_adapt_adp_4s_ctle_bypass   ),
           .pma_adapt_adp_ctle_adapt_cycle_window  		(pma_adapt_adp_ctle_adapt_cycle_window ),
           .pma_adapt_adp_ctle_en           		(pma_adapt_adp_ctle_en          ),
           .pma_adapt_adp_dfe_fltap_bypass  		(pma_adapt_adp_dfe_fltap_bypass ),
           .pma_adapt_adp_dfe_fltap_en      		(pma_adapt_adp_dfe_fltap_en     ),
           .pma_adapt_adp_dfe_fxtap_bypass  		(pma_adapt_adp_dfe_fxtap_bypass ),
           .pma_adapt_adp_dfe_fxtap_en      		(pma_adapt_adp_dfe_fxtap_en     ),
           .pma_adapt_adp_dfe_fxtap_hold_en  		(pma_adapt_adp_dfe_fxtap_hold_en ),
           .pma_adapt_adp_dfe_mode          		(pma_adapt_adp_dfe_mode         ),
           .pma_adapt_adp_mode              		(pma_adapt_adp_mode             ),
           .pma_adapt_adp_onetime_dfe       		(pma_adapt_adp_onetime_dfe      ),
           .pma_adapt_adp_vga_bypass        		(pma_adapt_adp_vga_bypass       ),
           .pma_adapt_adp_vga_en            		(pma_adapt_adp_vga_en           ),
           .pma_adapt_adp_vref_bypass       		(pma_adapt_adp_vref_bypass      ),
           .pma_adapt_adp_vref_en           		(pma_adapt_adp_vref_en          ),
           .pma_adapt_datarate              		(pma_adapt_datarate             ),
           .pma_adapt_odi_dfe_spec_en       		(pma_adapt_odi_dfe_spec_en      ),
           .pma_adapt_prot_mode             		(pma_adapt_prot_mode            ),
           .pma_adapt_sup_mode              		(pma_adapt_sup_mode             ),
           .pma_cdr_refclk_inclk0_logical_to_physical_mapping  		(pma_cdr_refclk_inclk0_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk1_logical_to_physical_mapping  		(pma_cdr_refclk_inclk1_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk2_logical_to_physical_mapping  		(pma_cdr_refclk_inclk2_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk3_logical_to_physical_mapping  		(pma_cdr_refclk_inclk3_logical_to_physical_mapping ),
           .pma_cdr_refclk_inclk4_logical_to_physical_mapping  		(pma_cdr_refclk_inclk4_logical_to_physical_mapping ),
           .pma_cdr_refclk_powerdown_mode   		(pma_cdr_refclk_powerdown_mode  ),
           .pma_cdr_refclk_refclk_select    		(pma_cdr_refclk_refclk_select   ),
           .cdr_pll_atb_select_control      		(cdr_pll_atb_select_control     ),
           .cdr_pll_auto_reset_on           		(cdr_pll_auto_reset_on          ),
           .cdr_pll_bbpd_data_pattern_filter_select  		(cdr_pll_bbpd_data_pattern_filter_select ),
           .cdr_pll_bw_sel                  		(cdr_pll_bw_sel                 ),
           .cdr_pll_cal_vco_count_length    		(cdr_pll_cal_vco_count_length   ),
           .cdr_pll_cdr_odi_select          		(cdr_pll_cdr_odi_select         ),
           .cdr_pll_cdr_phaselock_mode      		(cdr_pll_cdr_phaselock_mode     ),
           .cdr_pll_cdr_powerdown_mode      		(cdr_pll_cdr_powerdown_mode     ),
           .cdr_pll_cgb_div                 		(cdr_pll_cgb_div                ),
           .cdr_pll_chgpmp_current_dn_pd    		(cdr_pll_chgpmp_current_dn_pd   ),
           .cdr_pll_chgpmp_current_dn_trim  		(cdr_pll_chgpmp_current_dn_trim ),
           .cdr_pll_chgpmp_current_pd       		(cdr_pll_chgpmp_current_pd      ),
           .cdr_pll_chgpmp_current_pfd      		(cdr_pll_chgpmp_current_pfd     ),
           .cdr_pll_chgpmp_current_up_pd    		(cdr_pll_chgpmp_current_up_pd   ),
           .cdr_pll_chgpmp_current_up_trim  		(cdr_pll_chgpmp_current_up_trim ),
           .cdr_pll_chgpmp_dn_pd_trim_double  		(cdr_pll_chgpmp_dn_pd_trim_double ),
           .cdr_pll_chgpmp_replicate        		(cdr_pll_chgpmp_replicate       ),
           .cdr_pll_chgpmp_testmode         		(cdr_pll_chgpmp_testmode        ),
           .cdr_pll_chgpmp_up_pd_trim_double  		(cdr_pll_chgpmp_up_pd_trim_double ),
           .cdr_pll_clklow_mux_select       		(cdr_pll_clklow_mux_select      ),
           .cdr_pll_datarate                		(cdr_pll_datarate               ),
           .cdr_pll_diag_loopback_enable    		(cdr_pll_diag_loopback_enable   ),
           .cdr_pll_disable_up_dn           		(cdr_pll_disable_up_dn          ),
           .cdr_pll_fb_select               		(cdr_pll_fb_select              ),
           .cdr_pll_fref_clklow_div         		(cdr_pll_fref_clklow_div        ),
           .cdr_pll_fref_mux_select         		(cdr_pll_fref_mux_select        ),
           .cdr_pll_gpon_lck2ref_control    		(cdr_pll_gpon_lck2ref_control   ),
           .cdr_pll_initial_settings        		(cdr_pll_initial_settings       ),
           .cdr_pll_iqclk_mux_sel           		(cdr_pll_iqclk_mux_sel          ),
           .cdr_pll_is_cascaded_pll         		(cdr_pll_is_cascaded_pll        ),
           .cdr_pll_lck2ref_delay_control   		(cdr_pll_lck2ref_delay_control  ),
           .cdr_pll_lf_resistor_pd          		(cdr_pll_lf_resistor_pd         ),
           .cdr_pll_lf_resistor_pfd         		(cdr_pll_lf_resistor_pfd        ),
           .cdr_pll_lf_ripple_cap           		(cdr_pll_lf_ripple_cap          ),
           .cdr_pll_loop_filter_bias_select  		(cdr_pll_loop_filter_bias_select ),
           .cdr_pll_loopback_mode           		(cdr_pll_loopback_mode          ),
           .cdr_pll_lpd_counter             		(cdr_pll_lpd_counter            ),
           .cdr_pll_lpfd_counter            		(cdr_pll_lpfd_counter           ),
           .cdr_pll_ltd_ltr_micro_controller_select  		(cdr_pll_ltd_ltr_micro_controller_select ),
           .cdr_pll_m_counter               		(cdr_pll_m_counter              ),
           .cdr_pll_n_counter               		(cdr_pll_n_counter              ),
           .cdr_pll_n_counter_scratch       		(cdr_pll_n_counter_scratch      ),
           .cdr_pll_output_clock_frequency  		(cdr_pll_output_clock_frequency ),
           .cdr_pll_pcie_gen                		(cdr_pll_pcie_gen               ),
           .cdr_pll_pd_fastlock_mode        		(cdr_pll_pd_fastlock_mode       ),
           .cdr_pll_pd_l_counter            		(cdr_pll_pd_l_counter           ),
           .cdr_pll_pfd_l_counter           		(cdr_pll_pfd_l_counter          ),
           .cdr_pll_pma_width               		(cdr_pll_pma_width              ),
           .cdr_pll_primary_use             		(cdr_pll_primary_use            ),
           .cdr_pll_prot_mode               		(cdr_pll_prot_mode              ),
           .cdr_pll_reference_clock_frequency  		(cdr_pll_reference_clock_frequency ),
           .cdr_pll_reverse_serial_loopback  		(cdr_pll_reverse_serial_loopback ),
           .cdr_pll_set_cdr_input_freq_range  		(cdr_pll_set_cdr_input_freq_range ),
           .cdr_pll_set_cdr_v2i_enable      		(cdr_pll_set_cdr_v2i_enable     ),
           .cdr_pll_set_cdr_vco_reset       		(cdr_pll_set_cdr_vco_reset      ),
           .cdr_pll_set_cdr_vco_speed       		(cdr_pll_set_cdr_vco_speed      ),
           .cdr_pll_set_cdr_vco_speed_fix   		(cdr_pll_set_cdr_vco_speed_fix  ),
           .cdr_pll_set_cdr_vco_speed_pciegen3  		(cdr_pll_set_cdr_vco_speed_pciegen3 ),
           .cdr_pll_sup_mode                		(cdr_pll_sup_mode               ),
           .cdr_pll_tx_pll_prot_mode        		(cdr_pll_tx_pll_prot_mode       ),
           .cdr_pll_txpll_hclk_driver_enable  		(cdr_pll_txpll_hclk_driver_enable ),
           .cdr_pll_uc_ro_cal               		(cdr_pll_uc_ro_cal              ),
           .cdr_pll_vco_freq                		(cdr_pll_vco_freq               ),
           .cdr_pll_vco_overrange_voltage   		(cdr_pll_vco_overrange_voltage  ),
           .cdr_pll_vco_underrange_voltage  		(cdr_pll_vco_underrange_voltage ),
           .pma_rx_buf_bypass_eqz_stages_234  		(pma_rx_buf_bypass_eqz_stages_234 ),
           .pma_rx_buf_datarate             		(pma_rx_buf_datarate            ),
           .pma_rx_buf_diag_lp_en           		(pma_rx_buf_diag_lp_en          ),
           .pma_rx_buf_loopback_modes       		(pma_rx_buf_loopback_modes      ),
           .pma_rx_buf_pm_tx_rx_cvp_mode    		(pma_rx_buf_pm_tx_rx_cvp_mode   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen    		(pma_rx_buf_pm_tx_rx_pcie_gen   ),
           .pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth  		(pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth ),
           .pma_rx_buf_prot_mode            		(pma_rx_buf_prot_mode           ),
           .pma_rx_buf_qpi_enable           		(pma_rx_buf_qpi_enable          ),
           .pma_rx_buf_refclk_en            		(pma_rx_buf_refclk_en           ),
           .pma_rx_buf_rx_refclk_divider    		(pma_rx_buf_rx_refclk_divider   ),
           .pma_rx_buf_sup_mode             		(pma_rx_buf_sup_mode            ),
           .pma_rx_buf_xrx_path_datarate    		(pma_rx_buf_xrx_path_datarate   ),
           .pma_rx_buf_xrx_path_datawidth   		(pma_rx_buf_xrx_path_datawidth  ),
           .pma_rx_buf_xrx_path_pma_rx_divclk_hz  		(pma_rx_buf_xrx_path_pma_rx_divclk_hz ),
           .pma_rx_buf_xrx_path_prot_mode   		(pma_rx_buf_xrx_path_prot_mode  ),
           .pma_rx_buf_xrx_path_sup_mode    		(pma_rx_buf_xrx_path_sup_mode   ),
           .pma_rx_buf_xrx_path_uc_cal_enable  		(pma_rx_buf_xrx_path_uc_cal_enable ),
           .pma_rx_deser_bitslip_bypass     		(pma_rx_deser_bitslip_bypass    ),
           .pma_rx_deser_clkdiv_source      		(pma_rx_deser_clkdiv_source     ),
           .pma_rx_deser_clkdivrx_user_mode  		(pma_rx_deser_clkdivrx_user_mode ),
           .pma_rx_deser_datarate           		(pma_rx_deser_datarate          ),
           .pma_rx_deser_deser_factor       		(pma_rx_deser_deser_factor      ),
           .pma_rx_deser_force_clkdiv_for_testing  		(pma_rx_deser_force_clkdiv_for_testing ),
           .pma_rx_deser_pcie_gen           		(pma_rx_deser_pcie_gen          ),
           .pma_rx_deser_pcie_gen_bitwidth  		(pma_rx_deser_pcie_gen_bitwidth ),
           .pma_rx_deser_prot_mode          		(pma_rx_deser_prot_mode         ),
           .pma_rx_deser_rst_n_adapt_odi    		(pma_rx_deser_rst_n_adapt_odi   ),
           .pma_rx_deser_sdclk_enable       		(pma_rx_deser_sdclk_enable      ),
           .pma_rx_deser_sup_mode           		(pma_rx_deser_sup_mode          ),
           .pma_rx_dfe_datarate             		(pma_rx_dfe_datarate            ),
           .pma_rx_dfe_dft_en               		(pma_rx_dfe_dft_en              ),
           .pma_rx_dfe_pdb                  		(pma_rx_dfe_pdb                 ),
           .pma_rx_dfe_pdb_fixedtap         		(pma_rx_dfe_pdb_fixedtap        ),
           .pma_rx_dfe_pdb_floattap         		(pma_rx_dfe_pdb_floattap        ),
           .pma_rx_dfe_pdb_fxtap4t7         		(pma_rx_dfe_pdb_fxtap4t7        ),
           .pma_rx_dfe_prot_mode            		(pma_rx_dfe_prot_mode           ),
           .pma_rx_dfe_sup_mode             		(pma_rx_dfe_sup_mode            ),
           .pma_rx_odi_datarate             		(pma_rx_odi_datarate            ),
           .pma_rx_odi_prot_mode            		(pma_rx_odi_prot_mode           ),
           .pma_rx_odi_step_ctrl_sel        		(pma_rx_odi_step_ctrl_sel       ),
           .pma_rx_odi_sup_mode             		(pma_rx_odi_sup_mode            ),
           .pma_rx_sd_prot_mode             		(pma_rx_sd_prot_mode            ),
           .pma_rx_sd_sd_output_off         		(pma_rx_sd_sd_output_off        ),
           .pma_rx_sd_sd_output_on          		(pma_rx_sd_sd_output_on         ),
           .pma_rx_sd_sd_pdb                		(pma_rx_sd_sd_pdb               ),
           .pma_rx_sd_sup_mode              		(pma_rx_sd_sup_mode             ),
           .pma_tx_buf_datarate             		(pma_tx_buf_datarate            ),
           .pma_tx_buf_mcgb_location_for_pcie  		(pma_tx_buf_mcgb_location_for_pcie ),
           .pma_tx_buf_prot_mode            		(pma_tx_buf_prot_mode           ),
           .pma_tx_buf_rx_det               		(pma_tx_buf_rx_det              ),
           .pma_tx_buf_rx_det_output_sel    		(pma_tx_buf_rx_det_output_sel   ),
           .pma_tx_buf_rx_det_pdb           		(pma_tx_buf_rx_det_pdb          ),
           .pma_tx_buf_sup_mode             		(pma_tx_buf_sup_mode            ),
           .pma_tx_buf_user_fir_coeff_ctrl_sel  		(pma_tx_buf_user_fir_coeff_ctrl_sel ),
           .pma_tx_buf_xtx_path_clock_divider_ratio  		(pma_tx_buf_xtx_path_clock_divider_ratio ),
           .pma_tx_buf_xtx_path_datarate    		(pma_tx_buf_xtx_path_datarate   ),
           .pma_tx_buf_xtx_path_datawidth   		(pma_tx_buf_xtx_path_datawidth  ),
           .pma_tx_buf_xtx_path_pma_tx_divclk_hz  		(pma_tx_buf_xtx_path_pma_tx_divclk_hz ),
           .pma_tx_buf_xtx_path_prot_mode   		(pma_tx_buf_xtx_path_prot_mode  ),
           .pma_tx_buf_xtx_path_sup_mode    		(pma_tx_buf_xtx_path_sup_mode   ),
           .pma_tx_buf_xtx_path_tx_pll_clk_hz  		(pma_tx_buf_xtx_path_tx_pll_clk_hz ),
           .pma_cgb_bitslip_enable          		(pma_cgb_bitslip_enable         ),
           .pma_cgb_bonding_reset_enable    		(pma_cgb_bonding_reset_enable   ),
           .pma_cgb_datarate                		(pma_cgb_datarate               ),
           .pma_cgb_input_select_gen3       		(pma_cgb_input_select_gen3      ),
           .pma_cgb_input_select_x1         		(pma_cgb_input_select_x1        ),
           .pma_cgb_input_select_xn         		(pma_cgb_input_select_xn        ),
           .pma_cgb_pcie_gen3_bitwidth      		(pma_cgb_pcie_gen3_bitwidth     ),
           .pma_cgb_prot_mode               		(pma_cgb_prot_mode              ),
           .pma_cgb_scratch0_x1_clock_src   		(pma_cgb_scratch0_x1_clock_src  ),
           .pma_cgb_scratch1_x1_clock_src   		(pma_cgb_scratch1_x1_clock_src  ),
           .pma_cgb_scratch2_x1_clock_src   		(pma_cgb_scratch2_x1_clock_src  ),
           .pma_cgb_scratch3_x1_clock_src   		(pma_cgb_scratch3_x1_clock_src  ),
           .pma_cgb_select_done_master_or_slave  		(pma_cgb_select_done_master_or_slave ),
           .pma_cgb_ser_mode                		(pma_cgb_ser_mode               ),
           .pma_cgb_sup_mode                		(pma_cgb_sup_mode               ),
           .pma_cgb_tx_ucontrol_en          		(pma_cgb_tx_ucontrol_en         ),
           .pma_cgb_x1_div_m_sel            		(pma_cgb_x1_div_m_sel           ),
           .pma_tx_ser_prot_mode            		(pma_tx_ser_prot_mode           ),
           .pma_tx_ser_ser_clk_divtx_user_sel  		(pma_tx_ser_ser_clk_divtx_user_sel ),
           .pma_tx_ser_sup_mode             		(pma_tx_ser_sup_mode            ),
           .hssi_10g_rx_pcs_advanced_user_mode  		(hssi_10g_rx_pcs_advanced_user_mode ),
           .hssi_10g_rx_pcs_align_del       		(hssi_10g_rx_pcs_align_del      ),
           .hssi_10g_rx_pcs_ber_bit_err_total_cnt  		(hssi_10g_rx_pcs_ber_bit_err_total_cnt ),
           .hssi_10g_rx_pcs_ber_clken       		(hssi_10g_rx_pcs_ber_clken      ),
           .hssi_10g_rx_pcs_ber_xus_timer_window  		(hssi_10g_rx_pcs_ber_xus_timer_window ),
           .hssi_10g_rx_pcs_bitslip_mode    		(hssi_10g_rx_pcs_bitslip_mode   ),
           .hssi_10g_rx_pcs_blksync_bitslip_type  		(hssi_10g_rx_pcs_blksync_bitslip_type ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_cnt  		(hssi_10g_rx_pcs_blksync_bitslip_wait_cnt ),
           .hssi_10g_rx_pcs_blksync_bitslip_wait_type  		(hssi_10g_rx_pcs_blksync_bitslip_wait_type ),
           .hssi_10g_rx_pcs_blksync_bypass  		(hssi_10g_rx_pcs_blksync_bypass ),
           .hssi_10g_rx_pcs_blksync_clken   		(hssi_10g_rx_pcs_blksync_clken  ),
           .hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt  		(hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock ),
           .hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock  		(hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock ),
           .hssi_10g_rx_pcs_blksync_pipeln  		(hssi_10g_rx_pcs_blksync_pipeln ),
           .hssi_10g_rx_pcs_clr_errblk_cnt_en  		(hssi_10g_rx_pcs_clr_errblk_cnt_en ),
           .hssi_10g_rx_pcs_control_del     		(hssi_10g_rx_pcs_control_del    ),
           .hssi_10g_rx_pcs_crcchk_bypass   		(hssi_10g_rx_pcs_crcchk_bypass  ),
           .hssi_10g_rx_pcs_crcchk_clken    		(hssi_10g_rx_pcs_crcchk_clken   ),
           .hssi_10g_rx_pcs_crcchk_inv      		(hssi_10g_rx_pcs_crcchk_inv     ),
           .hssi_10g_rx_pcs_crcchk_pipeln   		(hssi_10g_rx_pcs_crcchk_pipeln  ),
           .hssi_10g_rx_pcs_crcflag_pipeln  		(hssi_10g_rx_pcs_crcflag_pipeln ),
           .hssi_10g_rx_pcs_ctrl_bit_reverse  		(hssi_10g_rx_pcs_ctrl_bit_reverse ),
           .hssi_10g_rx_pcs_data_bit_reverse  		(hssi_10g_rx_pcs_data_bit_reverse ),
           .hssi_10g_rx_pcs_dec64b66b_clken  		(hssi_10g_rx_pcs_dec64b66b_clken ),
           .hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass  		(hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass ),
           .hssi_10g_rx_pcs_descrm_bypass   		(hssi_10g_rx_pcs_descrm_bypass  ),
           .hssi_10g_rx_pcs_descrm_clken    		(hssi_10g_rx_pcs_descrm_clken   ),
           .hssi_10g_rx_pcs_descrm_mode     		(hssi_10g_rx_pcs_descrm_mode    ),
           .hssi_10g_rx_pcs_descrm_pipeln   		(hssi_10g_rx_pcs_descrm_pipeln  ),
           .hssi_10g_rx_pcs_dft_clk_out_sel  		(hssi_10g_rx_pcs_dft_clk_out_sel ),
           .hssi_10g_rx_pcs_dis_signal_ok   		(hssi_10g_rx_pcs_dis_signal_ok  ),
           .hssi_10g_rx_pcs_dispchk_bypass  		(hssi_10g_rx_pcs_dispchk_bypass ),
           .hssi_10g_rx_pcs_empty_flag_type  		(hssi_10g_rx_pcs_empty_flag_type ),
           .hssi_10g_rx_pcs_fast_path       		(hssi_10g_rx_pcs_fast_path      ),
           .hssi_10g_rx_pcs_fec_clken       		(hssi_10g_rx_pcs_fec_clken      ),
           .hssi_10g_rx_pcs_fec_enable      		(hssi_10g_rx_pcs_fec_enable     ),
           .hssi_10g_rx_pcs_fifo_double_read  		(hssi_10g_rx_pcs_fifo_double_read ),
           .hssi_10g_rx_pcs_fifo_stop_rd    		(hssi_10g_rx_pcs_fifo_stop_rd   ),
           .hssi_10g_rx_pcs_fifo_stop_wr    		(hssi_10g_rx_pcs_fifo_stop_wr   ),
           .hssi_10g_rx_pcs_force_align     		(hssi_10g_rx_pcs_force_align    ),
           .hssi_10g_rx_pcs_frmsync_bypass  		(hssi_10g_rx_pcs_frmsync_bypass ),
           .hssi_10g_rx_pcs_frmsync_clken   		(hssi_10g_rx_pcs_frmsync_clken  ),
           .hssi_10g_rx_pcs_frmsync_enum_scrm  		(hssi_10g_rx_pcs_frmsync_enum_scrm ),
           .hssi_10g_rx_pcs_frmsync_enum_sync  		(hssi_10g_rx_pcs_frmsync_enum_sync ),
           .hssi_10g_rx_pcs_frmsync_flag_type  		(hssi_10g_rx_pcs_frmsync_flag_type ),
           .hssi_10g_rx_pcs_frmsync_knum_sync  		(hssi_10g_rx_pcs_frmsync_knum_sync ),
           .hssi_10g_rx_pcs_frmsync_mfrm_length  		(hssi_10g_rx_pcs_frmsync_mfrm_length ),
           .hssi_10g_rx_pcs_frmsync_pipeln  		(hssi_10g_rx_pcs_frmsync_pipeln ),
           .hssi_10g_rx_pcs_full_flag_type  		(hssi_10g_rx_pcs_full_flag_type ),
           .hssi_10g_rx_pcs_gb_rx_idwidth   		(hssi_10g_rx_pcs_gb_rx_idwidth  ),
           .hssi_10g_rx_pcs_gb_rx_odwidth   		(hssi_10g_rx_pcs_gb_rx_odwidth  ),
           .hssi_10g_rx_pcs_gbexp_clken     		(hssi_10g_rx_pcs_gbexp_clken    ),
           .hssi_10g_rx_pcs_low_latency_en  		(hssi_10g_rx_pcs_low_latency_en ),
           .hssi_10g_rx_pcs_lpbk_mode       		(hssi_10g_rx_pcs_lpbk_mode      ),
           .hssi_10g_rx_pcs_master_clk_sel  		(hssi_10g_rx_pcs_master_clk_sel ),
           .hssi_10g_rx_pcs_pempty_flag_type  		(hssi_10g_rx_pcs_pempty_flag_type ),
           .hssi_10g_rx_pcs_pfull_flag_type  		(hssi_10g_rx_pcs_pfull_flag_type ),
           .hssi_10g_rx_pcs_phcomp_rd_del   		(hssi_10g_rx_pcs_phcomp_rd_del  ),
           .hssi_10g_rx_pcs_pld_if_type     		(hssi_10g_rx_pcs_pld_if_type    ),
           .hssi_10g_rx_pcs_prot_mode       		(hssi_10g_rx_pcs_prot_mode      ),
           .hssi_10g_rx_pcs_rand_clken      		(hssi_10g_rx_pcs_rand_clken     ),
           .hssi_10g_rx_pcs_rd_clk_sel      		(hssi_10g_rx_pcs_rd_clk_sel     ),
           .hssi_10g_rx_pcs_rdfifo_clken    		(hssi_10g_rx_pcs_rdfifo_clken   ),
           .hssi_10g_rx_pcs_reconfig_settings  		(hssi_10g_rx_pcs_reconfig_settings ),
           .hssi_10g_rx_pcs_rx_fifo_write_ctrl  		(hssi_10g_rx_pcs_rx_fifo_write_ctrl ),
           .hssi_10g_rx_pcs_rx_scrm_width   		(hssi_10g_rx_pcs_rx_scrm_width  ),
           .hssi_10g_rx_pcs_rx_sh_location  		(hssi_10g_rx_pcs_rx_sh_location ),
           .hssi_10g_rx_pcs_rx_signal_ok_sel  		(hssi_10g_rx_pcs_rx_signal_ok_sel ),
           .hssi_10g_rx_pcs_rx_sm_bypass    		(hssi_10g_rx_pcs_rx_sm_bypass   ),
           .hssi_10g_rx_pcs_rx_sm_hiber     		(hssi_10g_rx_pcs_rx_sm_hiber    ),
           .hssi_10g_rx_pcs_rx_sm_pipeln    		(hssi_10g_rx_pcs_rx_sm_pipeln   ),
           .hssi_10g_rx_pcs_rx_testbus_sel  		(hssi_10g_rx_pcs_rx_testbus_sel ),
           .hssi_10g_rx_pcs_rx_true_b2b     		(hssi_10g_rx_pcs_rx_true_b2b    ),
           .hssi_10g_rx_pcs_rxfifo_empty    		(hssi_10g_rx_pcs_rxfifo_empty   ),
           .hssi_10g_rx_pcs_rxfifo_full     		(hssi_10g_rx_pcs_rxfifo_full    ),
           .hssi_10g_rx_pcs_rxfifo_mode     		(hssi_10g_rx_pcs_rxfifo_mode    ),
           .hssi_10g_rx_pcs_rxfifo_pempty   		(hssi_10g_rx_pcs_rxfifo_pempty  ),
           .hssi_10g_rx_pcs_rxfifo_pfull    		(hssi_10g_rx_pcs_rxfifo_pfull   ),
           .hssi_10g_rx_pcs_stretch_num_stages  		(hssi_10g_rx_pcs_stretch_num_stages ),
           .hssi_10g_rx_pcs_sup_mode        		(hssi_10g_rx_pcs_sup_mode       ),
           .hssi_10g_rx_pcs_test_mode       		(hssi_10g_rx_pcs_test_mode      ),
           .hssi_10g_rx_pcs_wrfifo_clken    		(hssi_10g_rx_pcs_wrfifo_clken   ),
           .hssi_10g_tx_pcs_advanced_user_mode  		(hssi_10g_tx_pcs_advanced_user_mode ),
           .hssi_10g_tx_pcs_bitslip_en      		(hssi_10g_tx_pcs_bitslip_en     ),
           .hssi_10g_tx_pcs_bonding_dft_en  		(hssi_10g_tx_pcs_bonding_dft_en ),
           .hssi_10g_tx_pcs_bonding_dft_val  		(hssi_10g_tx_pcs_bonding_dft_val ),
           .hssi_10g_tx_pcs_comp_cnt        		(hssi_10g_tx_pcs_comp_cnt       ),
           .hssi_10g_tx_pcs_compin_sel      		(hssi_10g_tx_pcs_compin_sel     ),
           .hssi_10g_tx_pcs_crcgen_bypass   		(hssi_10g_tx_pcs_crcgen_bypass  ),
           .hssi_10g_tx_pcs_crcgen_clken    		(hssi_10g_tx_pcs_crcgen_clken   ),
           .hssi_10g_tx_pcs_crcgen_err      		(hssi_10g_tx_pcs_crcgen_err     ),
           .hssi_10g_tx_pcs_crcgen_inv      		(hssi_10g_tx_pcs_crcgen_inv     ),
           .hssi_10g_tx_pcs_ctrl_bit_reverse  		(hssi_10g_tx_pcs_ctrl_bit_reverse ),
           .hssi_10g_tx_pcs_ctrl_plane_bonding  		(hssi_10g_tx_pcs_ctrl_plane_bonding ),
           .hssi_10g_tx_pcs_data_bit_reverse  		(hssi_10g_tx_pcs_data_bit_reverse ),
           .hssi_10g_tx_pcs_dft_clk_out_sel  		(hssi_10g_tx_pcs_dft_clk_out_sel ),
           .hssi_10g_tx_pcs_dispgen_bypass  		(hssi_10g_tx_pcs_dispgen_bypass ),
           .hssi_10g_tx_pcs_dispgen_clken   		(hssi_10g_tx_pcs_dispgen_clken  ),
           .hssi_10g_tx_pcs_dispgen_err     		(hssi_10g_tx_pcs_dispgen_err    ),
           .hssi_10g_tx_pcs_dispgen_pipeln  		(hssi_10g_tx_pcs_dispgen_pipeln ),
           .hssi_10g_tx_pcs_distdwn_bypass_pipeln  		(hssi_10g_tx_pcs_distdwn_bypass_pipeln ),
           .hssi_10g_tx_pcs_distdwn_master  		(hssi_10g_tx_pcs_distdwn_master ),
           .hssi_10g_tx_pcs_distup_bypass_pipeln  		(hssi_10g_tx_pcs_distup_bypass_pipeln ),
           .hssi_10g_tx_pcs_distup_master   		(hssi_10g_tx_pcs_distup_master  ),
           .hssi_10g_tx_pcs_dv_bond         		(hssi_10g_tx_pcs_dv_bond        ),
           .hssi_10g_tx_pcs_empty_flag_type  		(hssi_10g_tx_pcs_empty_flag_type ),
           .hssi_10g_tx_pcs_enc64b66b_txsm_clken  		(hssi_10g_tx_pcs_enc64b66b_txsm_clken ),
           .hssi_10g_tx_pcs_enc_64b66b_txsm_bypass  		(hssi_10g_tx_pcs_enc_64b66b_txsm_bypass ),
           .hssi_10g_tx_pcs_fastpath        		(hssi_10g_tx_pcs_fastpath       ),
           .hssi_10g_tx_pcs_fec_clken       		(hssi_10g_tx_pcs_fec_clken      ),
           .hssi_10g_tx_pcs_fec_enable      		(hssi_10g_tx_pcs_fec_enable     ),
           .hssi_10g_tx_pcs_fifo_double_write  		(hssi_10g_tx_pcs_fifo_double_write ),
           .hssi_10g_tx_pcs_fifo_reg_fast   		(hssi_10g_tx_pcs_fifo_reg_fast  ),
           .hssi_10g_tx_pcs_fifo_stop_rd    		(hssi_10g_tx_pcs_fifo_stop_rd   ),
           .hssi_10g_tx_pcs_fifo_stop_wr    		(hssi_10g_tx_pcs_fifo_stop_wr   ),
           .hssi_10g_tx_pcs_frmgen_burst    		(hssi_10g_tx_pcs_frmgen_burst   ),
           .hssi_10g_tx_pcs_frmgen_bypass   		(hssi_10g_tx_pcs_frmgen_bypass  ),
           .hssi_10g_tx_pcs_frmgen_clken    		(hssi_10g_tx_pcs_frmgen_clken   ),
           .hssi_10g_tx_pcs_frmgen_mfrm_length  		(hssi_10g_tx_pcs_frmgen_mfrm_length ),
           .hssi_10g_tx_pcs_frmgen_pipeln   		(hssi_10g_tx_pcs_frmgen_pipeln  ),
           .hssi_10g_tx_pcs_frmgen_pyld_ins  		(hssi_10g_tx_pcs_frmgen_pyld_ins ),
           .hssi_10g_tx_pcs_frmgen_wordslip  		(hssi_10g_tx_pcs_frmgen_wordslip ),
           .hssi_10g_tx_pcs_full_flag_type  		(hssi_10g_tx_pcs_full_flag_type ),
           .hssi_10g_tx_pcs_gb_pipeln_bypass  		(hssi_10g_tx_pcs_gb_pipeln_bypass ),
           .hssi_10g_tx_pcs_gb_tx_idwidth   		(hssi_10g_tx_pcs_gb_tx_idwidth  ),
           .hssi_10g_tx_pcs_gb_tx_odwidth   		(hssi_10g_tx_pcs_gb_tx_odwidth  ),
           .hssi_10g_tx_pcs_gbred_clken     		(hssi_10g_tx_pcs_gbred_clken    ),
           .hssi_10g_tx_pcs_indv            		(hssi_10g_tx_pcs_indv           ),
           .hssi_10g_tx_pcs_low_latency_en  		(hssi_10g_tx_pcs_low_latency_en ),
           .hssi_10g_tx_pcs_master_clk_sel  		(hssi_10g_tx_pcs_master_clk_sel ),
           .hssi_10g_tx_pcs_pempty_flag_type  		(hssi_10g_tx_pcs_pempty_flag_type ),
           .hssi_10g_tx_pcs_pfull_flag_type  		(hssi_10g_tx_pcs_pfull_flag_type ),
           .hssi_10g_tx_pcs_phcomp_rd_del   		(hssi_10g_tx_pcs_phcomp_rd_del  ),
           .hssi_10g_tx_pcs_pld_if_type     		(hssi_10g_tx_pcs_pld_if_type    ),
           .hssi_10g_tx_pcs_prot_mode       		(hssi_10g_tx_pcs_prot_mode      ),
           .hssi_10g_tx_pcs_pseudo_random   		(hssi_10g_tx_pcs_pseudo_random  ),
           .hssi_10g_tx_pcs_pseudo_seed_a   		(hssi_10g_tx_pcs_pseudo_seed_a  ),
           .hssi_10g_tx_pcs_pseudo_seed_b   		(hssi_10g_tx_pcs_pseudo_seed_b  ),
           .hssi_10g_tx_pcs_random_disp     		(hssi_10g_tx_pcs_random_disp    ),
           .hssi_10g_tx_pcs_rdfifo_clken    		(hssi_10g_tx_pcs_rdfifo_clken   ),
           .hssi_10g_tx_pcs_reconfig_settings  		(hssi_10g_tx_pcs_reconfig_settings ),
           .hssi_10g_tx_pcs_scrm_bypass     		(hssi_10g_tx_pcs_scrm_bypass    ),
           .hssi_10g_tx_pcs_scrm_clken      		(hssi_10g_tx_pcs_scrm_clken     ),
           .hssi_10g_tx_pcs_scrm_mode       		(hssi_10g_tx_pcs_scrm_mode      ),
           .hssi_10g_tx_pcs_scrm_pipeln     		(hssi_10g_tx_pcs_scrm_pipeln    ),
           .hssi_10g_tx_pcs_sh_err          		(hssi_10g_tx_pcs_sh_err         ),
           .hssi_10g_tx_pcs_sop_mark        		(hssi_10g_tx_pcs_sop_mark       ),
           .hssi_10g_tx_pcs_stretch_num_stages  		(hssi_10g_tx_pcs_stretch_num_stages ),
           .hssi_10g_tx_pcs_sup_mode        		(hssi_10g_tx_pcs_sup_mode       ),
           .hssi_10g_tx_pcs_test_mode       		(hssi_10g_tx_pcs_test_mode      ),
           .hssi_10g_tx_pcs_tx_scrm_err     		(hssi_10g_tx_pcs_tx_scrm_err    ),
           .hssi_10g_tx_pcs_tx_scrm_width   		(hssi_10g_tx_pcs_tx_scrm_width  ),
           .hssi_10g_tx_pcs_tx_sh_location  		(hssi_10g_tx_pcs_tx_sh_location ),
           .hssi_10g_tx_pcs_tx_sm_bypass    		(hssi_10g_tx_pcs_tx_sm_bypass   ),
           .hssi_10g_tx_pcs_tx_sm_pipeln    		(hssi_10g_tx_pcs_tx_sm_pipeln   ),
           .hssi_10g_tx_pcs_tx_testbus_sel  		(hssi_10g_tx_pcs_tx_testbus_sel ),
           .hssi_10g_tx_pcs_txfifo_empty    		(hssi_10g_tx_pcs_txfifo_empty   ),
           .hssi_10g_tx_pcs_txfifo_full     		(hssi_10g_tx_pcs_txfifo_full    ),
           .hssi_10g_tx_pcs_txfifo_mode     		(hssi_10g_tx_pcs_txfifo_mode    ),
           .hssi_10g_tx_pcs_txfifo_pempty   		(hssi_10g_tx_pcs_txfifo_pempty  ),
           .hssi_10g_tx_pcs_txfifo_pfull    		(hssi_10g_tx_pcs_txfifo_pfull   ),
           .hssi_10g_tx_pcs_wr_clk_sel      		(hssi_10g_tx_pcs_wr_clk_sel     ),
           .hssi_10g_tx_pcs_wrfifo_clken    		(hssi_10g_tx_pcs_wrfifo_clken   ),
           .hssi_8g_rx_pcs_auto_error_replacement  		(hssi_8g_rx_pcs_auto_error_replacement ),
           .hssi_8g_rx_pcs_auto_speed_nego  		(hssi_8g_rx_pcs_auto_speed_nego ),
           .hssi_8g_rx_pcs_bit_reversal     		(hssi_8g_rx_pcs_bit_reversal    ),
           .hssi_8g_rx_pcs_bonding_dft_en   		(hssi_8g_rx_pcs_bonding_dft_en  ),
           .hssi_8g_rx_pcs_bonding_dft_val  		(hssi_8g_rx_pcs_bonding_dft_val ),
           .hssi_8g_rx_pcs_bypass_pipeline_reg  		(hssi_8g_rx_pcs_bypass_pipeline_reg ),
           .hssi_8g_rx_pcs_byte_deserializer  		(hssi_8g_rx_pcs_byte_deserializer ),
           .hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask  		(hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask ),
           .hssi_8g_rx_pcs_clkcmp_pattern_n  		(hssi_8g_rx_pcs_clkcmp_pattern_n ),
           .hssi_8g_rx_pcs_clkcmp_pattern_p  		(hssi_8g_rx_pcs_clkcmp_pattern_p ),
           .hssi_8g_rx_pcs_clock_gate_bds_dec_asn  		(hssi_8g_rx_pcs_clock_gate_bds_dec_asn ),
           .hssi_8g_rx_pcs_clock_gate_cdr_eidle  		(hssi_8g_rx_pcs_clock_gate_cdr_eidle ),
           .hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_dw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_dw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_dw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_dw_wa  		(hssi_8g_rx_pcs_clock_gate_dw_wa ),
           .hssi_8g_rx_pcs_clock_gate_pc_rdclk  		(hssi_8g_rx_pcs_clock_gate_pc_rdclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk  		(hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_rd  		(hssi_8g_rx_pcs_clock_gate_sw_rm_rd ),
           .hssi_8g_rx_pcs_clock_gate_sw_rm_wr  		(hssi_8g_rx_pcs_clock_gate_sw_rm_wr ),
           .hssi_8g_rx_pcs_clock_gate_sw_wa  		(hssi_8g_rx_pcs_clock_gate_sw_wa ),
           .hssi_8g_rx_pcs_clock_observation_in_pld_core  		(hssi_8g_rx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_rx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_rx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_rx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_rx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_rx_pcs_eidle_entry_eios  		(hssi_8g_rx_pcs_eidle_entry_eios ),
           .hssi_8g_rx_pcs_eidle_entry_iei  		(hssi_8g_rx_pcs_eidle_entry_iei ),
           .hssi_8g_rx_pcs_eidle_entry_sd   		(hssi_8g_rx_pcs_eidle_entry_sd  ),
           .hssi_8g_rx_pcs_eightb_tenb_decoder  		(hssi_8g_rx_pcs_eightb_tenb_decoder ),
           .hssi_8g_rx_pcs_err_flags_sel    		(hssi_8g_rx_pcs_err_flags_sel   ),
           .hssi_8g_rx_pcs_fixed_pat_det    		(hssi_8g_rx_pcs_fixed_pat_det   ),
           .hssi_8g_rx_pcs_fixed_pat_num    		(hssi_8g_rx_pcs_fixed_pat_num   ),
           .hssi_8g_rx_pcs_force_signal_detect  		(hssi_8g_rx_pcs_force_signal_detect ),
           .hssi_8g_rx_pcs_gen3_clk_en      		(hssi_8g_rx_pcs_gen3_clk_en     ),
           .hssi_8g_rx_pcs_gen3_rx_clk_sel  		(hssi_8g_rx_pcs_gen3_rx_clk_sel ),
           .hssi_8g_rx_pcs_gen3_tx_clk_sel  		(hssi_8g_rx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_rx_pcs_hip_mode         		(hssi_8g_rx_pcs_hip_mode        ),
           .hssi_8g_rx_pcs_ibm_invalid_code  		(hssi_8g_rx_pcs_ibm_invalid_code ),
           .hssi_8g_rx_pcs_invalid_code_flag_only  		(hssi_8g_rx_pcs_invalid_code_flag_only ),
           .hssi_8g_rx_pcs_pad_or_edb_error_replace  		(hssi_8g_rx_pcs_pad_or_edb_error_replace ),
           .hssi_8g_rx_pcs_pcs_bypass       		(hssi_8g_rx_pcs_pcs_bypass      ),
           .hssi_8g_rx_pcs_phase_comp_rdptr  		(hssi_8g_rx_pcs_phase_comp_rdptr ),
           .hssi_8g_rx_pcs_phase_compensation_fifo  		(hssi_8g_rx_pcs_phase_compensation_fifo ),
           .hssi_8g_rx_pcs_pipe_if_enable   		(hssi_8g_rx_pcs_pipe_if_enable  ),
           .hssi_8g_rx_pcs_pma_dw           		(hssi_8g_rx_pcs_pma_dw          ),
           .hssi_8g_rx_pcs_polinv_8b10b_dec  		(hssi_8g_rx_pcs_polinv_8b10b_dec ),
           .hssi_8g_rx_pcs_prot_mode        		(hssi_8g_rx_pcs_prot_mode       ),
           .hssi_8g_rx_pcs_rate_match       		(hssi_8g_rx_pcs_rate_match      ),
           .hssi_8g_rx_pcs_rate_match_del_thres  		(hssi_8g_rx_pcs_rate_match_del_thres ),
           .hssi_8g_rx_pcs_rate_match_empty_thres  		(hssi_8g_rx_pcs_rate_match_empty_thres ),
           .hssi_8g_rx_pcs_rate_match_full_thres  		(hssi_8g_rx_pcs_rate_match_full_thres ),
           .hssi_8g_rx_pcs_rate_match_ins_thres  		(hssi_8g_rx_pcs_rate_match_ins_thres ),
           .hssi_8g_rx_pcs_rate_match_start_thres  		(hssi_8g_rx_pcs_rate_match_start_thres ),
           .hssi_8g_rx_pcs_reconfig_settings  		(hssi_8g_rx_pcs_reconfig_settings ),
           .hssi_8g_rx_pcs_rx_clk2          		(hssi_8g_rx_pcs_rx_clk2         ),
           .hssi_8g_rx_pcs_rx_clk_free_running  		(hssi_8g_rx_pcs_rx_clk_free_running ),
           .hssi_8g_rx_pcs_rx_pcs_urst      		(hssi_8g_rx_pcs_rx_pcs_urst     ),
           .hssi_8g_rx_pcs_rx_rcvd_clk      		(hssi_8g_rx_pcs_rx_rcvd_clk     ),
           .hssi_8g_rx_pcs_rx_rd_clk        		(hssi_8g_rx_pcs_rx_rd_clk       ),
           .hssi_8g_rx_pcs_rx_refclk        		(hssi_8g_rx_pcs_rx_refclk       ),
           .hssi_8g_rx_pcs_rx_wr_clk        		(hssi_8g_rx_pcs_rx_wr_clk       ),
           .hssi_8g_rx_pcs_sup_mode         		(hssi_8g_rx_pcs_sup_mode        ),
           .hssi_8g_rx_pcs_symbol_swap      		(hssi_8g_rx_pcs_symbol_swap     ),
           .hssi_8g_rx_pcs_sync_sm_idle_eios  		(hssi_8g_rx_pcs_sync_sm_idle_eios ),
           .hssi_8g_rx_pcs_test_bus_sel     		(hssi_8g_rx_pcs_test_bus_sel    ),
           .hssi_8g_rx_pcs_tx_rx_parallel_loopback  		(hssi_8g_rx_pcs_tx_rx_parallel_loopback ),
           .hssi_8g_rx_pcs_wa_boundary_lock_ctrl  		(hssi_8g_rx_pcs_wa_boundary_lock_ctrl ),
           .hssi_8g_rx_pcs_wa_clk_slip_spacing  		(hssi_8g_rx_pcs_wa_clk_slip_spacing ),
           .hssi_8g_rx_pcs_wa_det_latency_sync_status_beh  		(hssi_8g_rx_pcs_wa_det_latency_sync_status_beh ),
           .hssi_8g_rx_pcs_wa_disp_err_flag  		(hssi_8g_rx_pcs_wa_disp_err_flag ),
           .hssi_8g_rx_pcs_wa_kchar         		(hssi_8g_rx_pcs_wa_kchar        ),
           .hssi_8g_rx_pcs_wa_pd            		(hssi_8g_rx_pcs_wa_pd           ),
           .hssi_8g_rx_pcs_wa_pd_data       		(hssi_8g_rx_pcs_wa_pd_data      ),
           .hssi_8g_rx_pcs_wa_pd_polarity   		(hssi_8g_rx_pcs_wa_pd_polarity  ),
           .hssi_8g_rx_pcs_wa_pld_controlled  		(hssi_8g_rx_pcs_wa_pld_controlled ),
           .hssi_8g_rx_pcs_wa_renumber_data  		(hssi_8g_rx_pcs_wa_renumber_data ),
           .hssi_8g_rx_pcs_wa_rgnumber_data  		(hssi_8g_rx_pcs_wa_rgnumber_data ),
           .hssi_8g_rx_pcs_wa_rknumber_data  		(hssi_8g_rx_pcs_wa_rknumber_data ),
           .hssi_8g_rx_pcs_wa_rosnumber_data  		(hssi_8g_rx_pcs_wa_rosnumber_data ),
           .hssi_8g_rx_pcs_wa_rvnumber_data  		(hssi_8g_rx_pcs_wa_rvnumber_data ),
           .hssi_8g_rx_pcs_wa_sync_sm_ctrl  		(hssi_8g_rx_pcs_wa_sync_sm_ctrl ),
           .hssi_8g_rx_pcs_wait_cnt         		(hssi_8g_rx_pcs_wait_cnt        ),
           .hssi_8g_tx_pcs_auto_speed_nego_gen2  		(hssi_8g_tx_pcs_auto_speed_nego_gen2 ),
           .hssi_8g_tx_pcs_bit_reversal     		(hssi_8g_tx_pcs_bit_reversal    ),
           .hssi_8g_tx_pcs_bonding_dft_en   		(hssi_8g_tx_pcs_bonding_dft_en  ),
           .hssi_8g_tx_pcs_bonding_dft_val  		(hssi_8g_tx_pcs_bonding_dft_val ),
           .hssi_8g_tx_pcs_bypass_pipeline_reg  		(hssi_8g_tx_pcs_bypass_pipeline_reg ),
           .hssi_8g_tx_pcs_byte_serializer  		(hssi_8g_tx_pcs_byte_serializer ),
           .hssi_8g_tx_pcs_clock_gate_bs_enc  		(hssi_8g_tx_pcs_clock_gate_bs_enc ),
           .hssi_8g_tx_pcs_clock_gate_dw_fifowr  		(hssi_8g_tx_pcs_clock_gate_dw_fifowr ),
           .hssi_8g_tx_pcs_clock_gate_fiford  		(hssi_8g_tx_pcs_clock_gate_fiford ),
           .hssi_8g_tx_pcs_clock_gate_sw_fifowr  		(hssi_8g_tx_pcs_clock_gate_sw_fifowr ),
           .hssi_8g_tx_pcs_clock_observation_in_pld_core  		(hssi_8g_tx_pcs_clock_observation_in_pld_core ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_compensation  		(hssi_8g_tx_pcs_ctrl_plane_bonding_compensation ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_consumption  		(hssi_8g_tx_pcs_ctrl_plane_bonding_consumption ),
           .hssi_8g_tx_pcs_ctrl_plane_bonding_distribution  		(hssi_8g_tx_pcs_ctrl_plane_bonding_distribution ),
           .hssi_8g_tx_pcs_data_selection_8b10b_encoder_input  		(hssi_8g_tx_pcs_data_selection_8b10b_encoder_input ),
           .hssi_8g_tx_pcs_dynamic_clk_switch  		(hssi_8g_tx_pcs_dynamic_clk_switch ),
           .hssi_8g_tx_pcs_eightb_tenb_disp_ctrl  		(hssi_8g_tx_pcs_eightb_tenb_disp_ctrl ),
           .hssi_8g_tx_pcs_eightb_tenb_encoder  		(hssi_8g_tx_pcs_eightb_tenb_encoder ),
           .hssi_8g_tx_pcs_force_echar      		(hssi_8g_tx_pcs_force_echar     ),
           .hssi_8g_tx_pcs_force_kchar      		(hssi_8g_tx_pcs_force_kchar     ),
           .hssi_8g_tx_pcs_gen3_tx_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_clk_sel ),
           .hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel  		(hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel ),
           .hssi_8g_tx_pcs_hip_mode         		(hssi_8g_tx_pcs_hip_mode        ),
           .hssi_8g_tx_pcs_pcs_bypass       		(hssi_8g_tx_pcs_pcs_bypass      ),
           .hssi_8g_tx_pcs_phase_comp_rdptr  		(hssi_8g_tx_pcs_phase_comp_rdptr ),
           .hssi_8g_tx_pcs_phase_compensation_fifo  		(hssi_8g_tx_pcs_phase_compensation_fifo ),
           .hssi_8g_tx_pcs_phfifo_write_clk_sel  		(hssi_8g_tx_pcs_phfifo_write_clk_sel ),
           .hssi_8g_tx_pcs_pma_dw           		(hssi_8g_tx_pcs_pma_dw          ),
           .hssi_8g_tx_pcs_prot_mode        		(hssi_8g_tx_pcs_prot_mode       ),
           .hssi_8g_tx_pcs_reconfig_settings  		(hssi_8g_tx_pcs_reconfig_settings ),
           .hssi_8g_tx_pcs_refclk_b_clk_sel  		(hssi_8g_tx_pcs_refclk_b_clk_sel ),
           .hssi_8g_tx_pcs_revloop_back_rm  		(hssi_8g_tx_pcs_revloop_back_rm ),
           .hssi_8g_tx_pcs_sup_mode         		(hssi_8g_tx_pcs_sup_mode        ),
           .hssi_8g_tx_pcs_symbol_swap      		(hssi_8g_tx_pcs_symbol_swap     ),
           .hssi_8g_tx_pcs_tx_bitslip       		(hssi_8g_tx_pcs_tx_bitslip      ),
           .hssi_8g_tx_pcs_tx_compliance_controlled_disparity  		(hssi_8g_tx_pcs_tx_compliance_controlled_disparity ),
           .hssi_8g_tx_pcs_tx_fast_pld_reg  		(hssi_8g_tx_pcs_tx_fast_pld_reg ),
           .hssi_8g_tx_pcs_txclk_freerun    		(hssi_8g_tx_pcs_txclk_freerun   ),
           .hssi_8g_tx_pcs_txpcs_urst       		(hssi_8g_tx_pcs_txpcs_urst      ),
           .hssi_common_pcs_pma_interface_asn_clk_enable  		(hssi_common_pcs_pma_interface_asn_clk_enable ),
           .hssi_common_pcs_pma_interface_asn_enable  		(hssi_common_pcs_pma_interface_asn_enable ),
           .hssi_common_pcs_pma_interface_block_sel  		(hssi_common_pcs_pma_interface_block_sel ),
           .hssi_common_pcs_pma_interface_bypass_early_eios  		(hssi_common_pcs_pma_interface_bypass_early_eios ),
           .hssi_common_pcs_pma_interface_bypass_pcie_switch  		(hssi_common_pcs_pma_interface_bypass_pcie_switch ),
           .hssi_common_pcs_pma_interface_bypass_pma_ltr  		(hssi_common_pcs_pma_interface_bypass_pma_ltr ),
           .hssi_common_pcs_pma_interface_bypass_pma_sw_done  		(hssi_common_pcs_pma_interface_bypass_pma_sw_done ),
           .hssi_common_pcs_pma_interface_bypass_ppm_lock  		(hssi_common_pcs_pma_interface_bypass_ppm_lock ),
           .hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp ),
           .hssi_common_pcs_pma_interface_bypass_txdetectrx  		(hssi_common_pcs_pma_interface_bypass_txdetectrx ),
           .hssi_common_pcs_pma_interface_cdr_control  		(hssi_common_pcs_pma_interface_cdr_control ),
           .hssi_common_pcs_pma_interface_cid_enable  		(hssi_common_pcs_pma_interface_cid_enable ),
           .hssi_common_pcs_pma_interface_cp_cons_sel  		(hssi_common_pcs_pma_interface_cp_cons_sel ),
           .hssi_common_pcs_pma_interface_cp_dwn_mstr  		(hssi_common_pcs_pma_interface_cp_dwn_mstr ),
           .hssi_common_pcs_pma_interface_cp_up_mstr  		(hssi_common_pcs_pma_interface_cp_up_mstr ),
           .hssi_common_pcs_pma_interface_ctrl_plane_bonding  		(hssi_common_pcs_pma_interface_ctrl_plane_bonding ),
           .hssi_common_pcs_pma_interface_data_mask_count  		(hssi_common_pcs_pma_interface_data_mask_count ),
           .hssi_common_pcs_pma_interface_data_mask_count_multi  		(hssi_common_pcs_pma_interface_data_mask_count_multi ),
           .hssi_common_pcs_pma_interface_dft_observation_clock_selection  		(hssi_common_pcs_pma_interface_dft_observation_clock_selection ),
           .hssi_common_pcs_pma_interface_early_eios_counter  		(hssi_common_pcs_pma_interface_early_eios_counter ),
           .hssi_common_pcs_pma_interface_force_freqdet  		(hssi_common_pcs_pma_interface_force_freqdet ),
           .hssi_common_pcs_pma_interface_free_run_clk_enable  		(hssi_common_pcs_pma_interface_free_run_clk_enable ),
           .hssi_common_pcs_pma_interface_ignore_sigdet_g23  		(hssi_common_pcs_pma_interface_ignore_sigdet_g23 ),
           .hssi_common_pcs_pma_interface_pc_en_counter  		(hssi_common_pcs_pma_interface_pc_en_counter ),
           .hssi_common_pcs_pma_interface_pc_rst_counter  		(hssi_common_pcs_pma_interface_pc_rst_counter ),
           .hssi_common_pcs_pma_interface_pcie_hip_mode  		(hssi_common_pcs_pma_interface_pcie_hip_mode ),
           .hssi_common_pcs_pma_interface_ph_fifo_reg_mode  		(hssi_common_pcs_pma_interface_ph_fifo_reg_mode ),
           .hssi_common_pcs_pma_interface_phfifo_flush_wait  		(hssi_common_pcs_pma_interface_phfifo_flush_wait ),
           .hssi_common_pcs_pma_interface_pipe_if_g3pcs  		(hssi_common_pcs_pma_interface_pipe_if_g3pcs ),
           .hssi_common_pcs_pma_interface_pma_done_counter  		(hssi_common_pcs_pma_interface_pma_done_counter ),
           .hssi_common_pcs_pma_interface_pma_if_dft_en  		(hssi_common_pcs_pma_interface_pma_if_dft_en ),
           .hssi_common_pcs_pma_interface_pma_if_dft_val  		(hssi_common_pcs_pma_interface_pma_if_dft_val ),
           .hssi_common_pcs_pma_interface_ppm_cnt_rst  		(hssi_common_pcs_pma_interface_ppm_cnt_rst ),
           .hssi_common_pcs_pma_interface_ppm_deassert_early  		(hssi_common_pcs_pma_interface_ppm_deassert_early ),
           .hssi_common_pcs_pma_interface_ppm_det_buckets  		(hssi_common_pcs_pma_interface_ppm_det_buckets ),
           .hssi_common_pcs_pma_interface_ppm_gen1_2_cnt  		(hssi_common_pcs_pma_interface_ppm_gen1_2_cnt ),
           .hssi_common_pcs_pma_interface_ppm_post_eidle_delay  		(hssi_common_pcs_pma_interface_ppm_post_eidle_delay ),
           .hssi_common_pcs_pma_interface_ppmsel  		(hssi_common_pcs_pma_interface_ppmsel ),
           .hssi_common_pcs_pma_interface_prot_mode  		(hssi_common_pcs_pma_interface_prot_mode ),
           .hssi_common_pcs_pma_interface_reconfig_settings  		(hssi_common_pcs_pma_interface_reconfig_settings ),
           .hssi_common_pcs_pma_interface_rxvalid_mask  		(hssi_common_pcs_pma_interface_rxvalid_mask ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter  		(hssi_common_pcs_pma_interface_sigdet_wait_counter ),
           .hssi_common_pcs_pma_interface_sigdet_wait_counter_multi  		(hssi_common_pcs_pma_interface_sigdet_wait_counter_multi ),
           .hssi_common_pcs_pma_interface_sim_mode  		(hssi_common_pcs_pma_interface_sim_mode ),
           .hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en  		(hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en ),
           .hssi_common_pcs_pma_interface_sup_mode  		(hssi_common_pcs_pma_interface_sup_mode ),
           .hssi_common_pcs_pma_interface_testout_sel  		(hssi_common_pcs_pma_interface_testout_sel ),
           .hssi_common_pcs_pma_interface_wait_clk_on_off_timer  		(hssi_common_pcs_pma_interface_wait_clk_on_off_timer ),
           .hssi_common_pcs_pma_interface_wait_pipe_synchronizing  		(hssi_common_pcs_pma_interface_wait_pipe_synchronizing ),
           .hssi_common_pcs_pma_interface_wait_send_syncp_fbkp  		(hssi_common_pcs_pma_interface_wait_send_syncp_fbkp ),
           .hssi_common_pld_pcs_interface_dft_clk_out_en  		(hssi_common_pld_pcs_interface_dft_clk_out_en ),
           .hssi_common_pld_pcs_interface_dft_clk_out_sel  		(hssi_common_pld_pcs_interface_dft_clk_out_sel ),
           .hssi_common_pld_pcs_interface_hrdrstctrl_en  		(hssi_common_pld_pcs_interface_hrdrstctrl_en ),
           .hssi_common_pld_pcs_interface_pcs_testbus_block_sel  		(hssi_common_pld_pcs_interface_pcs_testbus_block_sel ),
           .hssi_common_pld_pcs_interface_reconfig_settings  		(hssi_common_pld_pcs_interface_reconfig_settings ),
           .hssi_fifo_rx_pcs_double_read_mode  		(hssi_fifo_rx_pcs_double_read_mode ),
           .hssi_fifo_rx_pcs_prot_mode      		(hssi_fifo_rx_pcs_prot_mode     ),
           .hssi_fifo_tx_pcs_double_write_mode  		(hssi_fifo_tx_pcs_double_write_mode ),
           .hssi_fifo_tx_pcs_prot_mode      		(hssi_fifo_tx_pcs_prot_mode     ),
           .hssi_gen3_rx_pcs_block_sync     		(hssi_gen3_rx_pcs_block_sync    ),
           .hssi_gen3_rx_pcs_block_sync_sm  		(hssi_gen3_rx_pcs_block_sync_sm ),
           .hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn  		(hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn ),
           .hssi_gen3_rx_pcs_lpbk_force     		(hssi_gen3_rx_pcs_lpbk_force    ),
           .hssi_gen3_rx_pcs_mode           		(hssi_gen3_rx_pcs_mode          ),
           .hssi_gen3_rx_pcs_rate_match_fifo  		(hssi_gen3_rx_pcs_rate_match_fifo ),
           .hssi_gen3_rx_pcs_rate_match_fifo_latency  		(hssi_gen3_rx_pcs_rate_match_fifo_latency ),
           .hssi_gen3_rx_pcs_reconfig_settings  		(hssi_gen3_rx_pcs_reconfig_settings ),
           .hssi_gen3_rx_pcs_reverse_lpbk   		(hssi_gen3_rx_pcs_reverse_lpbk  ),
           .hssi_gen3_rx_pcs_rx_b4gb_par_lpbk  		(hssi_gen3_rx_pcs_rx_b4gb_par_lpbk ),
           .hssi_gen3_rx_pcs_rx_force_balign  		(hssi_gen3_rx_pcs_rx_force_balign ),
           .hssi_gen3_rx_pcs_rx_ins_del_one_skip  		(hssi_gen3_rx_pcs_rx_ins_del_one_skip ),
           .hssi_gen3_rx_pcs_rx_num_fixed_pat  		(hssi_gen3_rx_pcs_rx_num_fixed_pat ),
           .hssi_gen3_rx_pcs_rx_test_out_sel  		(hssi_gen3_rx_pcs_rx_test_out_sel ),
           .hssi_gen3_rx_pcs_sup_mode       		(hssi_gen3_rx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_mode           		(hssi_gen3_tx_pcs_mode          ),
           .hssi_gen3_tx_pcs_reverse_lpbk   		(hssi_gen3_tx_pcs_reverse_lpbk  ),
           .hssi_gen3_tx_pcs_sup_mode       		(hssi_gen3_tx_pcs_sup_mode      ),
           .hssi_gen3_tx_pcs_tx_bitslip     		(hssi_gen3_tx_pcs_tx_bitslip    ),
           .hssi_gen3_tx_pcs_tx_gbox_byp    		(hssi_gen3_tx_pcs_tx_gbox_byp   ),
           .hssi_krfec_rx_pcs_blksync_cor_en  		(hssi_krfec_rx_pcs_blksync_cor_en ),
           .hssi_krfec_rx_pcs_bypass_gb     		(hssi_krfec_rx_pcs_bypass_gb    ),
           .hssi_krfec_rx_pcs_clr_ctrl      		(hssi_krfec_rx_pcs_clr_ctrl     ),
           .hssi_krfec_rx_pcs_ctrl_bit_reverse  		(hssi_krfec_rx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_rx_pcs_data_bit_reverse  		(hssi_krfec_rx_pcs_data_bit_reverse ),
           .hssi_krfec_rx_pcs_dv_start      		(hssi_krfec_rx_pcs_dv_start     ),
           .hssi_krfec_rx_pcs_err_mark_type  		(hssi_krfec_rx_pcs_err_mark_type ),
           .hssi_krfec_rx_pcs_error_marking_en  		(hssi_krfec_rx_pcs_error_marking_en ),
           .hssi_krfec_rx_pcs_low_latency_en  		(hssi_krfec_rx_pcs_low_latency_en ),
           .hssi_krfec_rx_pcs_lpbk_mode     		(hssi_krfec_rx_pcs_lpbk_mode    ),
           .hssi_krfec_rx_pcs_parity_invalid_enum  		(hssi_krfec_rx_pcs_parity_invalid_enum ),
           .hssi_krfec_rx_pcs_parity_valid_num  		(hssi_krfec_rx_pcs_parity_valid_num ),
           .hssi_krfec_rx_pcs_pipeln_blksync  		(hssi_krfec_rx_pcs_pipeln_blksync ),
           .hssi_krfec_rx_pcs_pipeln_descrm  		(hssi_krfec_rx_pcs_pipeln_descrm ),
           .hssi_krfec_rx_pcs_pipeln_errcorrect  		(hssi_krfec_rx_pcs_pipeln_errcorrect ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_ind  		(hssi_krfec_rx_pcs_pipeln_errtrap_ind ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_lfsr  		(hssi_krfec_rx_pcs_pipeln_errtrap_lfsr ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_loc  		(hssi_krfec_rx_pcs_pipeln_errtrap_loc ),
           .hssi_krfec_rx_pcs_pipeln_errtrap_pat  		(hssi_krfec_rx_pcs_pipeln_errtrap_pat ),
           .hssi_krfec_rx_pcs_pipeln_gearbox  		(hssi_krfec_rx_pcs_pipeln_gearbox ),
           .hssi_krfec_rx_pcs_pipeln_syndrm  		(hssi_krfec_rx_pcs_pipeln_syndrm ),
           .hssi_krfec_rx_pcs_pipeln_trans_dec  		(hssi_krfec_rx_pcs_pipeln_trans_dec ),
           .hssi_krfec_rx_pcs_prot_mode     		(hssi_krfec_rx_pcs_prot_mode    ),
           .hssi_krfec_rx_pcs_receive_order  		(hssi_krfec_rx_pcs_receive_order ),
           .hssi_krfec_rx_pcs_reconfig_settings  		(hssi_krfec_rx_pcs_reconfig_settings ),
           .hssi_krfec_rx_pcs_rx_testbus_sel  		(hssi_krfec_rx_pcs_rx_testbus_sel ),
           .hssi_krfec_rx_pcs_signal_ok_en  		(hssi_krfec_rx_pcs_signal_ok_en ),
           .hssi_krfec_rx_pcs_sup_mode      		(hssi_krfec_rx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_burst_err     		(hssi_krfec_tx_pcs_burst_err    ),
           .hssi_krfec_tx_pcs_burst_err_len  		(hssi_krfec_tx_pcs_burst_err_len ),
           .hssi_krfec_tx_pcs_ctrl_bit_reverse  		(hssi_krfec_tx_pcs_ctrl_bit_reverse ),
           .hssi_krfec_tx_pcs_data_bit_reverse  		(hssi_krfec_tx_pcs_data_bit_reverse ),
           .hssi_krfec_tx_pcs_enc_frame_query  		(hssi_krfec_tx_pcs_enc_frame_query ),
           .hssi_krfec_tx_pcs_low_latency_en  		(hssi_krfec_tx_pcs_low_latency_en ),
           .hssi_krfec_tx_pcs_pipeln_encoder  		(hssi_krfec_tx_pcs_pipeln_encoder ),
           .hssi_krfec_tx_pcs_pipeln_scrambler  		(hssi_krfec_tx_pcs_pipeln_scrambler ),
           .hssi_krfec_tx_pcs_prot_mode     		(hssi_krfec_tx_pcs_prot_mode    ),
           .hssi_krfec_tx_pcs_sup_mode      		(hssi_krfec_tx_pcs_sup_mode     ),
           .hssi_krfec_tx_pcs_transcode_err  		(hssi_krfec_tx_pcs_transcode_err ),
           .hssi_krfec_tx_pcs_transmit_order  		(hssi_krfec_tx_pcs_transmit_order ),
           .hssi_krfec_tx_pcs_tx_testbus_sel  		(hssi_krfec_tx_pcs_tx_testbus_sel ),
           .hssi_pipe_gen1_2_elec_idle_delay_val  		(hssi_pipe_gen1_2_elec_idle_delay_val ),
           .hssi_pipe_gen1_2_error_replace_pad  		(hssi_pipe_gen1_2_error_replace_pad ),
           .hssi_pipe_gen1_2_hip_mode       		(hssi_pipe_gen1_2_hip_mode      ),
           .hssi_pipe_gen1_2_ind_error_reporting  		(hssi_pipe_gen1_2_ind_error_reporting ),
           .hssi_pipe_gen1_2_phystatus_delay_val  		(hssi_pipe_gen1_2_phystatus_delay_val ),
           .hssi_pipe_gen1_2_phystatus_rst_toggle  		(hssi_pipe_gen1_2_phystatus_rst_toggle ),
           .hssi_pipe_gen1_2_pipe_byte_de_serializer_en  		(hssi_pipe_gen1_2_pipe_byte_de_serializer_en ),
           .hssi_pipe_gen1_2_prot_mode      		(hssi_pipe_gen1_2_prot_mode     ),
           .hssi_pipe_gen1_2_reconfig_settings  		(hssi_pipe_gen1_2_reconfig_settings ),
           .hssi_pipe_gen1_2_rx_pipe_enable  		(hssi_pipe_gen1_2_rx_pipe_enable ),
           .hssi_pipe_gen1_2_rxdetect_bypass  		(hssi_pipe_gen1_2_rxdetect_bypass ),
           .hssi_pipe_gen1_2_sup_mode       		(hssi_pipe_gen1_2_sup_mode      ),
           .hssi_pipe_gen1_2_tx_pipe_enable  		(hssi_pipe_gen1_2_tx_pipe_enable ),
           .hssi_pipe_gen1_2_txswing        		(hssi_pipe_gen1_2_txswing       ),
           .hssi_pipe_gen3_bypass_rx_detection_enable  		(hssi_pipe_gen3_bypass_rx_detection_enable ),
           .hssi_pipe_gen3_bypass_rx_preset  		(hssi_pipe_gen3_bypass_rx_preset ),
           .hssi_pipe_gen3_bypass_rx_preset_enable  		(hssi_pipe_gen3_bypass_rx_preset_enable ),
           .hssi_pipe_gen3_bypass_tx_coefficent  		(hssi_pipe_gen3_bypass_tx_coefficent ),
           .hssi_pipe_gen3_bypass_tx_coefficent_enable  		(hssi_pipe_gen3_bypass_tx_coefficent_enable ),
           .hssi_pipe_gen3_elecidle_delay_g3  		(hssi_pipe_gen3_elecidle_delay_g3 ),
           .hssi_pipe_gen3_ind_error_reporting  		(hssi_pipe_gen3_ind_error_reporting ),
           .hssi_pipe_gen3_mode             		(hssi_pipe_gen3_mode            ),
           .hssi_pipe_gen3_phy_status_delay_g12  		(hssi_pipe_gen3_phy_status_delay_g12 ),
           .hssi_pipe_gen3_phy_status_delay_g3  		(hssi_pipe_gen3_phy_status_delay_g3 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g12  		(hssi_pipe_gen3_phystatus_rst_toggle_g12 ),
           .hssi_pipe_gen3_phystatus_rst_toggle_g3  		(hssi_pipe_gen3_phystatus_rst_toggle_g3 ),
           .hssi_pipe_gen3_rate_match_pad_insertion  		(hssi_pipe_gen3_rate_match_pad_insertion ),
           .hssi_pipe_gen3_sup_mode         		(hssi_pipe_gen3_sup_mode        ),
           .hssi_pipe_gen3_test_out_sel     		(hssi_pipe_gen3_test_out_sel    ),
           .hssi_rx_pcs_pma_interface_block_sel  		(hssi_rx_pcs_pma_interface_block_sel ),
           .hssi_rx_pcs_pma_interface_channel_operation_mode  		(hssi_rx_pcs_pma_interface_channel_operation_mode ),
           .hssi_rx_pcs_pma_interface_clkslip_sel  		(hssi_rx_pcs_pma_interface_clkslip_sel ),
           .hssi_rx_pcs_pma_interface_lpbk_en  		(hssi_rx_pcs_pma_interface_lpbk_en ),
           .hssi_rx_pcs_pma_interface_master_clk_sel  		(hssi_rx_pcs_pma_interface_master_clk_sel ),
           .hssi_rx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_rx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_rx_pcs_pma_interface_pma_dw_rx  		(hssi_rx_pcs_pma_interface_pma_dw_rx ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_en  		(hssi_rx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_rx_pcs_pma_interface_pma_if_dft_val  		(hssi_rx_pcs_pma_interface_pma_if_dft_val ),
           .hssi_rx_pcs_pma_interface_prbs9_dwidth  		(hssi_rx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_rx_pcs_pma_interface_prbs_clken  		(hssi_rx_pcs_pma_interface_prbs_clken ),
           .hssi_rx_pcs_pma_interface_prbs_ver  		(hssi_rx_pcs_pma_interface_prbs_ver ),
           .hssi_rx_pcs_pma_interface_prot_mode_rx  		(hssi_rx_pcs_pma_interface_prot_mode_rx ),
           .hssi_rx_pcs_pma_interface_reconfig_settings  		(hssi_rx_pcs_pma_interface_reconfig_settings ),
           .hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_lpbk_en ),
           .hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok  		(hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mask  		(hssi_rx_pcs_pma_interface_rx_prbs_mask ),
           .hssi_rx_pcs_pma_interface_rx_prbs_mode  		(hssi_rx_pcs_pma_interface_rx_prbs_mode ),
           .hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel  		(hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel ),
           .hssi_rx_pcs_pma_interface_rx_static_polarity_inversion  		(hssi_rx_pcs_pma_interface_rx_static_polarity_inversion ),
           .hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en  		(hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en ),
           .hssi_rx_pcs_pma_interface_sup_mode  		(hssi_rx_pcs_pma_interface_sup_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_rx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_rx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_rx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz  		(hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz ),
           .hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx  		(hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx  		(hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx ),
           .hssi_rx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_rx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode  		(hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode ),
           .hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx  		(hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx ),
           .hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_rx_pld_pcs_interface_pcs_rx_block_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_block_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_clk_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_clk_sel ),
           .hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en  		(hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en ),
           .hssi_rx_pld_pcs_interface_pcs_rx_output_sel  		(hssi_rx_pld_pcs_interface_pcs_rx_output_sel ),
           .hssi_rx_pld_pcs_interface_reconfig_settings  		(hssi_rx_pld_pcs_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_bypass_pma_txelecidle  		(hssi_tx_pcs_pma_interface_bypass_pma_txelecidle ),
           .hssi_tx_pcs_pma_interface_channel_operation_mode  		(hssi_tx_pcs_pma_interface_channel_operation_mode ),
           .hssi_tx_pcs_pma_interface_lpbk_en  		(hssi_tx_pcs_pma_interface_lpbk_en ),
           .hssi_tx_pcs_pma_interface_master_clk_sel  		(hssi_tx_pcs_pma_interface_master_clk_sel ),
           .hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx  		(hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_pldif_datawidth_mode  		(hssi_tx_pcs_pma_interface_pldif_datawidth_mode ),
           .hssi_tx_pcs_pma_interface_pma_dw_tx  		(hssi_tx_pcs_pma_interface_pma_dw_tx ),
           .hssi_tx_pcs_pma_interface_pma_if_dft_en  		(hssi_tx_pcs_pma_interface_pma_if_dft_en ),
           .hssi_tx_pcs_pma_interface_pmagate_en  		(hssi_tx_pcs_pma_interface_pmagate_en ),
           .hssi_tx_pcs_pma_interface_prbs9_dwidth  		(hssi_tx_pcs_pma_interface_prbs9_dwidth ),
           .hssi_tx_pcs_pma_interface_prbs_clken  		(hssi_tx_pcs_pma_interface_prbs_clken ),
           .hssi_tx_pcs_pma_interface_prbs_gen_pat  		(hssi_tx_pcs_pma_interface_prbs_gen_pat ),
           .hssi_tx_pcs_pma_interface_prot_mode_tx  		(hssi_tx_pcs_pma_interface_prot_mode_tx ),
           .hssi_tx_pcs_pma_interface_reconfig_settings  		(hssi_tx_pcs_pma_interface_reconfig_settings ),
           .hssi_tx_pcs_pma_interface_sq_wave_num  		(hssi_tx_pcs_pma_interface_sq_wave_num ),
           .hssi_tx_pcs_pma_interface_sqwgen_clken  		(hssi_tx_pcs_pma_interface_sqwgen_clken ),
           .hssi_tx_pcs_pma_interface_sup_mode  		(hssi_tx_pcs_pma_interface_sup_mode ),
           .hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_tx_pma_data_sel  		(hssi_tx_pcs_pma_interface_tx_pma_data_sel ),
           .hssi_tx_pcs_pma_interface_tx_static_polarity_inversion  		(hssi_tx_pcs_pma_interface_tx_static_polarity_inversion ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period  		(hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period ),
           .hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable  		(hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window ),
           .hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size  		(hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin ),
           .hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value  		(hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control ),
           .hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control  		(hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control ),
           .hssi_tx_pcs_pma_interface_uhsif_enable  		(hssi_tx_pcs_pma_interface_uhsif_enable ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value ),
           .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value  		(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value ),
           .hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_10g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_hip_mode  		(hssi_tx_pld_pcs_interface_hd_8g_hip_mode ),
           .hssi_tx_pld_pcs_interface_hd_8g_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_8g_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en  		(hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_func_mode  		(hssi_tx_pld_pcs_interface_hd_chnl_func_mode ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hip_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hip_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz  		(hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz ),
           .hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx  		(hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx ),
           .hssi_tx_pld_pcs_interface_hd_g3_prot_mode  		(hssi_tx_pld_pcs_interface_hd_g3_prot_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx ),
           .hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en  		(hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en ),
           .hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding  		(hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en  		(hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx  		(hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx ),
           .hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode  		(hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_clk_source  		(hssi_tx_pld_pcs_interface_pcs_tx_clk_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_data_source  		(hssi_tx_pld_pcs_interface_pcs_tx_data_source ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en ),
           .hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl  		(hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl ),
           .hssi_tx_pld_pcs_interface_pcs_tx_output_sel  		(hssi_tx_pld_pcs_interface_pcs_tx_output_sel ),
           .hssi_tx_pld_pcs_interface_reconfig_settings  		(hssi_tx_pld_pcs_interface_reconfig_settings ),
           .avmm_interfaces                 		(avmm_interfaces                ),
           .rcfg_enable                     		(rcfg_enable                    ),
           .enable_avmm                     		(enable_avmm                    ),
           .arbiter_ctrl                    		(arbiter_ctrl                   ),
           .calibration_en                  		(calibration_en                 ),
           .avmm_busy_en                    		(avmm_busy_en                   ),
           .hip_cal_en                      		(hip_cal_en                     ),
           .cal_done                        		(cal_done                       )
                  )
               twentynm_xcvr_native_inst(.*);
             end



endcase
endgenerate



endmodule
module twentynm_xcvr_native_rev_20nm1 #(

        parameter bonded_lanes                   = 1,
        parameter bonding_master_ch              = 0,

    // twentynm_pma parameters
        parameter xcvr_native_mode               = "mode_duplex",       // mode_duplex, mode_rx_only, mode_tx_only
    // parameters for twentynm_hssi_pma_adaptation
        parameter pma_adapt_adapt_mode           = "dfe_vga",           // ctle|dfe_vga|ctle_vga|ctle_vga_dfe|manual
        parameter pma_adapt_adp_1s_ctle_bypass   = "radp_1s_ctle_bypass_0",// radp_1s_ctle_bypass_0|radp_1s_ctle_bypass_1
        parameter pma_adapt_adp_4s_ctle_bypass   = "radp_4s_ctle_bypass_0",// radp_4s_ctle_bypass_0|radp_4s_ctle_bypass_1
        parameter pma_adapt_adp_ctle_adapt_cycle_window = "radp_ctle_adapt_cycle_window_6",// radp_ctle_adapt_cycle_window_0|radp_ctle_adapt_cycle_window_1|radp_ctle_adapt_cycle_window_2|radp_ctle_adapt_cycle_window_3|radp_ctle_adapt_cycle_window_4|radp_ctle_adapt_cycle_window_5|radp_ctle_adapt_cycle_window_6|radp_ctle_adapt_cycle_window_7
        parameter pma_adapt_adp_ctle_en          = "radp_ctle_disable", // radp_ctle_disable|radp_ctle_enable
        parameter pma_adapt_adp_dfe_fltap_bypass = "radp_dfe_fltap_bypass_0",// radp_dfe_fltap_bypass_0|radp_dfe_fltap_bypass_1
        parameter pma_adapt_adp_dfe_fltap_en     = "radp_dfe_fltap_disable",// radp_dfe_fltap_disable|radp_dfe_fltap_enable
        parameter pma_adapt_adp_dfe_fxtap_bypass = "radp_dfe_fxtap_bypass_0",// radp_dfe_fxtap_bypass_0|radp_dfe_fxtap_bypass_1
        parameter pma_adapt_adp_dfe_fxtap_en     = "radp_dfe_fxtap_disable",// radp_dfe_fxtap_disable|radp_dfe_fxtap_enable
        parameter pma_adapt_adp_dfe_fxtap_hold_en = "radp_dfe_fxtap_not_held",// radp_dfe_fxtap_not_held|radp_dfe_fxtap_hold
        parameter pma_adapt_adp_dfe_mode         = "radp_dfe_mode_0",   // radp_dfe_mode_0|radp_dfe_mode_1|radp_dfe_mode_2|radp_dfe_mode_3|radp_dfe_mode_4|radp_dfe_mode_5|radp_dfe_mode_6|radp_dfe_mode_7
        parameter pma_adapt_adp_mode             = "radp_mode_0",       // radp_mode_0|radp_mode_1|radp_mode_2|radp_mode_3|radp_mode_4|radp_mode_5|radp_mode_6|radp_mode_7|radp_mode_8|radp_mode_9|radp_mode_10|radp_mode_11|radp_mode_12|radp_mode_13|radp_mode_14|radp_mode_15
        parameter pma_adapt_adp_onetime_dfe      = "radp_onetime_dfe_0",// radp_onetime_dfe_0|radp_onetime_dfe_1
        parameter pma_adapt_adp_vga_bypass       = "radp_vga_bypass_0", // radp_vga_bypass_0|radp_vga_bypass_1
        parameter pma_adapt_adp_vga_en           = "radp_vga_disable",  // radp_vga_disable|radp_vga_enable
        parameter pma_adapt_adp_vref_bypass      = "radp_vref_bypass_0",// radp_vref_bypass_0|radp_vref_bypass_1
        parameter pma_adapt_adp_vref_en          = "radp_vref_disable", // radp_vref_disable|radp_vref_enable
        parameter pma_adapt_datarate             = "0 bps",             //
        parameter pma_adapt_odi_dfe_spec_en      = "rodi_dfe_spec_en_0",// rodi_dfe_spec_en_0|rodi_dfe_spec_en_1
        parameter pma_adapt_prot_mode            = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_adapt_sup_mode             = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_pma_cdr_refclk_select_mux
        parameter pma_cdr_refclk_inclk0_logical_to_physical_mapping = "ref_iqclk0",// ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
        parameter pma_cdr_refclk_inclk1_logical_to_physical_mapping = "ref_iqclk0",// ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
        parameter pma_cdr_refclk_inclk2_logical_to_physical_mapping = "ref_iqclk0",// ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
        parameter pma_cdr_refclk_inclk3_logical_to_physical_mapping = "ref_iqclk0",// ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
        parameter pma_cdr_refclk_inclk4_logical_to_physical_mapping = "ref_iqclk0",// ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
        parameter pma_cdr_refclk_powerdown_mode  = "powerdown",         // powerup|powerdown
        parameter pma_cdr_refclk_refclk_select   = "ref_iqclk0",        // ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
    // parameters for twentynm_hssi_pma_channel_pll
        parameter cdr_pll_atb_select_control     = "atb_off",           // atb_off|atb_select_tp_1|atb_select_tp_2|atb_select_tp_3|atb_select_tp_4|atb_select_tp_5|atb_select_tp_6|atb_select_tp_7|atb_select_tp_8|atb_select_tp_9|atb_select_tp_10|atb_select_tp_11|atb_select_tp_12|atb_select_tp_13|atb_select_tp_14|atb_select_tp_15|atb_select_tp_16|atb_select_tp_17|atb_select_tp_18|atb_select_tp_19|atb_select_tp_20|atb_select_tp_21|atb_select_tp_22|atb_select_tp_23|atb_select_tp_24|atb_select_tp_25|atb_select_tp_26|atb_select_tp_27|atb_select_tp_28|atb_select_tp_29|atb_select_tp_30|atb_select_tp_31|atb_select_tp_32|atb_select_tp_33|atb_select_tp_34|atb_select_tp_35|atb_select_tp_36|atb_select_tp_37|atb_select_tp_38|atb_select_tp_39|atb_select_tp_40|atb_select_tp_41|atb_select_tp_42|atb_select_tp_43|atb_select_tp_44|atb_select_tp_45|atb_select_tp_46|atb_select_tp_47|atb_select_tp_48|atb_select_tp_49|atb_select_tp_50|atb_select_tp_51|atb_select_tp_52|atb_select_tp_53|atb_select_tp_54|atb_select_tp_55|atb_select_tp_56|atb_select_tp_57|atb_select_tp_58|atb_select_tp_59|atb_select_tp_60|atb_select_tp_61|atb_select_tp_62|atb_select_tp_63
        parameter cdr_pll_auto_reset_on          = "auto_reset_on",     // auto_reset_on|auto_reset_off
        parameter cdr_pll_bbpd_data_pattern_filter_select = "bbpd_data_pat_off",// bbpd_data_pat_off|bbpd_data_pat_1|bbpd_data_pat_2|bbpd_data_pat_3
        parameter cdr_pll_bw_sel                 = "low",               // low|medium|high
        parameter cdr_pll_cal_vco_count_length   = "sel_8b_count",      // sel_8b_count|sel_12b_count
        parameter cdr_pll_cdr_odi_select         = "sel_cdr",           // sel_cdr|sel_odi
        parameter cdr_pll_cdr_phaselock_mode     = "no_ignore_lock",    // no_ignore_lock|ignore_lock
        parameter cdr_pll_cdr_powerdown_mode     = "power_down",        // power_down|power_up
        parameter cdr_pll_cgb_div                = 1,                   // 1|2|4|8
        parameter cdr_pll_chgpmp_current_dn_pd   = "cp_current_pd_dn_setting0",// cp_current_pd_dn_setting0|cp_current_pd_dn_setting1|cp_current_pd_dn_setting2|cp_current_pd_dn_setting3|cp_current_pd_dn_setting4
        parameter cdr_pll_chgpmp_current_dn_trim = "cp_current_trimming_dn_setting0",// cp_current_trimming_dn_setting0|cp_current_trimming_dn_setting1|cp_current_trimming_dn_setting2|cp_current_trimming_dn_setting3|cp_current_trimming_dn_setting4|cp_current_trimming_dn_setting5|cp_current_trimming_dn_setting6|cp_current_trimming_dn_setting7|cp_current_trimming_dn_setting8|cp_current_trimming_dn_setting9|cp_current_trimming_dn_setting10|cp_current_trimming_dn_setting11|cp_current_trimming_dn_setting12|cp_current_trimming_dn_setting13|cp_current_trimming_dn_setting14|cp_current_trimming_dn_setting15
        parameter cdr_pll_chgpmp_current_pd      = "cp_current_pd_setting0",// cp_current_pd_setting0|cp_current_pd_setting1|cp_current_pd_setting2|cp_current_pd_setting3|cp_current_pd_setting4
        parameter cdr_pll_chgpmp_current_pfd     = "cp_current_pfd_setting0",// cp_current_pfd_setting0|cp_current_pfd_setting1|cp_current_pfd_setting2|cp_current_pfd_setting3|cp_current_pfd_setting4
        parameter cdr_pll_chgpmp_current_up_pd   = "cp_current_pd_up_setting0",// cp_current_pd_up_setting0|cp_current_pd_up_setting1|cp_current_pd_up_setting2|cp_current_pd_up_setting3|cp_current_pd_up_setting4
        parameter cdr_pll_chgpmp_current_up_trim = "cp_current_trimming_up_setting0",// cp_current_trimming_up_setting0|cp_current_trimming_up_setting1|cp_current_trimming_up_setting2|cp_current_trimming_up_setting3|cp_current_trimming_up_setting4|cp_current_trimming_up_setting5|cp_current_trimming_up_setting6|cp_current_trimming_up_setting7|cp_current_trimming_up_setting8|cp_current_trimming_up_setting9|cp_current_trimming_up_setting10|cp_current_trimming_up_setting11|cp_current_trimming_up_setting12|cp_current_trimming_up_setting13|cp_current_trimming_up_setting14|cp_current_trimming_up_setting15
        parameter cdr_pll_chgpmp_dn_pd_trim_double = "normal_dn_trim_current",// normal_dn_trim_current|double_dn_trim_current
        parameter cdr_pll_chgpmp_replicate       = "false",             // false|true
        parameter cdr_pll_chgpmp_testmode        = "cp_test_disable",   // cp_test_disable|cp_test_up|cp_test_dn|cp_tristate
        parameter cdr_pll_chgpmp_up_pd_trim_double = "normal_up_trim_current",// normal_up_trim_current|double_up_trim_current
        parameter cdr_pll_clklow_mux_select      = "clklow_mux_cdr_fbclk",// clklow_mux_cdr_fbclk|clklow_mux_fpll_test1|clklow_mux_reserved_1|clklow_mux_rx_deser_pclk_test|clklow_mux_reserved_2|clklow_mux_reserved_3|clklow_mux_reserved_4|clklow_mux_dfe_test
        parameter cdr_pll_datarate               = "0 bps",             //
        parameter cdr_pll_diag_loopback_enable   = "false",             // true|false
        parameter cdr_pll_disable_up_dn          = "true",              // true|false
        parameter cdr_pll_fb_select              = "direct_fb",         // iqtxrxclk_fb|direct_fb
        parameter cdr_pll_fref_clklow_div        = 1,                   // 1|2|4|8
        parameter cdr_pll_fref_mux_select        = "fref_mux_cdr_refclk",// fref_mux_cdr_refclk|fref_mux_fpll_test0|fref_mux_reserved_1|fref_mux_tx_ser_pclk_test|fref_mux_reserved_2|fref_mux_reserved_3|fref_mux_reserved_4|fref_mux_reserved_5
        parameter cdr_pll_gpon_lck2ref_control   = "gpon_lck2ref_off",  // gpon_lck2ref_off|gpon_lck2ref_on
        parameter cdr_pll_initial_settings       = "false",             // false|true
        parameter cdr_pll_iqclk_mux_sel          = "power_down",        // iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|power_down
        parameter cdr_pll_is_cascaded_pll        = "false",             // true|false
        parameter cdr_pll_lck2ref_delay_control  = "lck2ref_delay_off", // lck2ref_delay_off|lck2ref_delay_1|lck2ref_delay_2|lck2ref_delay_3|lck2ref_delay_4|lck2ref_delay_5|lck2ref_delay_6|lck2ref_delay_7
        parameter cdr_pll_lf_resistor_pd         = "lf_pd_setting0",    // lf_pd_setting0|lf_pd_setting1|lf_pd_setting2|lf_pd_setting3
        parameter cdr_pll_lf_resistor_pfd        = "lf_pfd_setting0",   // lf_pfd_setting0|lf_pfd_setting1|lf_pfd_setting2|lf_pfd_setting3
        parameter cdr_pll_lf_ripple_cap          = "lf_no_ripple",      // lf_no_ripple|lf_ripple_cap1
        parameter cdr_pll_loop_filter_bias_select = "lpflt_bias_off",   // lpflt_bias_off|lpflt_bias_1|lpflt_bias_2|lpflt_bias_3|lpflt_bias_4|lpflt_bias_5|lpflt_bias_6|lpflt_bias_7
        parameter cdr_pll_loopback_mode          = "loopback_disabled", // loopback_disabled|loopback_recovered_data|rx_refclk|rx_refclk_cdr_loopback|unused2|loopback_received_data|unused1
        parameter cdr_pll_lpd_counter            = 5'b1,
        parameter cdr_pll_lpfd_counter           = 5'b1,
        parameter cdr_pll_ltd_ltr_micro_controller_select = "ltd_ltr_pcs",// ltd_ltr_pcs|ltr_ucontroller|ltd_ucontroller
        parameter cdr_pll_m_counter              = 16,                  // 0..255
        parameter cdr_pll_n_counter              = 1,                   // 1|2|4|8
        parameter cdr_pll_n_counter_scratch      = 6'b1,
        parameter cdr_pll_output_clock_frequency = "0 hz",              //
        parameter cdr_pll_pcie_gen               = "non_pcie",          // pcie_gen1_100mhzref|pcie_gen2_100mhzref|pcie_gen3_100mhzref|pcie_gen1_125mhzref|pcie_gen2_125mhzref|pcie_gen3_125mhzref|non_pcie
        parameter cdr_pll_pd_fastlock_mode       = "false",             // false|true
        parameter cdr_pll_pd_l_counter           = 1,                   // 0|1|2|4|8|16
        parameter cdr_pll_pfd_l_counter          = 1,                   // 0|1|2|4|8|16|100
        parameter cdr_pll_pma_width              = 8,                   // 8|10|16|20|32|40|64
        parameter cdr_pll_primary_use            = "cmu",               // cmu|cdr
        parameter cdr_pll_prot_mode              = "unused",            // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter cdr_pll_reference_clock_frequency = "0 hz",           //
        parameter cdr_pll_reverse_serial_loopback = "no_loopback",      // no_loopback|loopback_data_no_posttap|loopback_data_with_posttap|loopback_data_0_1
        parameter cdr_pll_set_cdr_input_freq_range = 8'b0,
        parameter cdr_pll_set_cdr_v2i_enable     = "true",              // true|false
        parameter cdr_pll_set_cdr_vco_reset      = "false",             // true|false
        parameter cdr_pll_set_cdr_vco_speed      = 5'b1,
        parameter cdr_pll_set_cdr_vco_speed_fix  = 8'b0,
        parameter cdr_pll_set_cdr_vco_speed_pciegen3 = "cdr_vco_max_speedbin_pciegen3",// cdr_vco_min_speedbin_pciegen3|cdr_vco_max_speedbin_pciegen3
        parameter cdr_pll_sup_mode               = "user_mode",         // user_mode|engineering_mode
        parameter cdr_pll_tx_pll_prot_mode       = "txpll_unused",      // txpll_unused|txpll_enable_pcie|txpll_enable
        parameter cdr_pll_txpll_hclk_driver_enable = "false",           // true|false
        parameter cdr_pll_uc_ro_cal              = "uc_ro_cal_off",     // uc_ro_cal_off|uc_ro_cal_on
        parameter cdr_pll_vco_freq               = "0 hz",              //
        parameter cdr_pll_vco_overrange_voltage  = "vco_overrange_off", // vco_overrange_off|vco_overrange_ref_1|vco_overrange_ref_2|vco_overrange_ref_3
        parameter cdr_pll_vco_underrange_voltage = "vco_underange_off", // vco_underange_off|vco_underange_ref_1|vco_underange_ref_2|vco_underange_ref_3
    // parameters for twentynm_hssi_pma_rx_buf
        parameter pma_rx_buf_bypass_eqz_stages_234 = "bypass_off",      // bypass_off|byypass_stages_234
        parameter pma_rx_buf_datarate            = "0 bps",             //
        parameter pma_rx_buf_diag_lp_en          = "dlp_off",           // dlp_off|dlp_on
        parameter pma_rx_buf_loopback_modes      = "lpbk_disable",      // lpbk_disable|pre_cdr|post_cdr
        parameter pma_rx_buf_pm_tx_rx_cvp_mode   = "cvp_off",           // cvp_off|cvp_on
        parameter pma_rx_buf_pm_tx_rx_pcie_gen   = "non_pcie",          // pcie_gen1_100mhzref|pcie_gen2_100mhzref|pcie_gen3_100mhzref|pcie_gen1_125mhzref|pcie_gen2_125mhzref|pcie_gen3_125mhzref|non_pcie
        parameter pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth = "pcie_gen3_32b",// pcie_gen3_32b|pcie_gen3_16b
        parameter pma_rx_buf_prot_mode           = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_buf_qpi_enable          = "non_qpi_mode",      // non_qpi_mode|qpi_mode
        parameter pma_rx_buf_refclk_en           = "enable",            // disable|enable
        parameter pma_rx_buf_rx_refclk_divider   = "bypass_divider",    // bypass_divider|divide_by_2
        parameter pma_rx_buf_sup_mode            = "user_mode",         // user_mode|engineering_mode
        parameter pma_rx_buf_xrx_path_datarate   = "0 bps",             //
        parameter pma_rx_buf_xrx_path_datawidth  = 8'b0,
        parameter pma_rx_buf_xrx_path_pma_rx_divclk_hz = 32'b0,
        parameter pma_rx_buf_xrx_path_prot_mode  = "unused",            // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_buf_xrx_path_sup_mode   = "user_mode",         // user_mode|engineering_mode
        parameter pma_rx_buf_xrx_path_uc_cal_enable = "rx_cal_off",     // rx_cal_off|rx_cal_on
    // parameters for twentynm_hssi_pma_rx_deser
        parameter pma_rx_deser_bitslip_bypass    = "bs_bypass_no",      // bs_bypass_no|bs_bypass_yes
        parameter pma_rx_deser_clkdiv_source     = "vco_bypass_normal", // vco_bypass_normal|clklow_to_clkdivrx|fref_to_clkdivrx
        parameter pma_rx_deser_clkdivrx_user_mode = "clkdivrx_user_disabled",// clkdivrx_user_disabled|clkdivrx_user_clkdiv|clkdivrx_user_clkdiv_div2|clkdivrx_user_div40|clkdivrx_user_div33|clkdivrx_user_div66
        parameter pma_rx_deser_datarate          = "0 bps",             //
        parameter pma_rx_deser_deser_factor      = 8,                   // 8|10|16|20|32|40|64
        parameter pma_rx_deser_force_clkdiv_for_testing = "normal_clkdiv",// normal_clkdiv|forced_0|forced_1
        parameter pma_rx_deser_pcie_gen          = "non_pcie",          // pcie_gen1_100mhzref|pcie_gen2_100mhzref|pcie_gen3_100mhzref|pcie_gen1_125mhzref|pcie_gen2_125mhzref|pcie_gen3_125mhzref|non_pcie
        parameter pma_rx_deser_pcie_gen_bitwidth = "pcie_gen3_32b",     // pcie_gen3_32b|pcie_gen3_16b
        parameter pma_rx_deser_prot_mode         = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_deser_rst_n_adapt_odi   = "no_rst_adapt_odi",  // yes_rst_adapt_odi|no_rst_adapt_odi
        parameter pma_rx_deser_sdclk_enable      = "false",             // false|true
        parameter pma_rx_deser_sup_mode          = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_pma_rx_dfe
        parameter pma_rx_dfe_datarate            = "0 bps",             //
        parameter pma_rx_dfe_dft_en              = "dft_disable",       // dft_disable|dft_enalbe
        parameter pma_rx_dfe_pdb                 = "dfe_enable",        // dfe_powerdown|dfe_reset|dfe_enable
        parameter pma_rx_dfe_pdb_fixedtap        = "fixtap_dfe_powerdown",// fixtap_dfe_powerdown|fixtap_dfe_enable
        parameter pma_rx_dfe_pdb_floattap        = "floattap_dfe_powerdown",// floattap_dfe_powerdown|floattap_dfe_enable
        parameter pma_rx_dfe_pdb_fxtap4t7        = "fxtap4t7_powerdown",// fxtap4t7_powerdown|fxtap4t7_enable
        parameter pma_rx_dfe_prot_mode           = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_dfe_sup_mode            = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_pma_rx_odi
        parameter pma_rx_odi_datarate            = "0 bps",             //
        parameter pma_rx_odi_prot_mode           = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_odi_step_ctrl_sel       = "feedback_mode",     // dprio_mode|feedback_mode|jm_mode
        parameter pma_rx_odi_sup_mode            = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_pma_rx_sd
        parameter pma_rx_sd_prot_mode            = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_sd_sd_output_off        = 1,                   // 0..28
        parameter pma_rx_sd_sd_output_on         = 1,                   // 0..15
        parameter pma_rx_sd_sd_pdb               = "sd_off",            // sd_on|sd_off
        parameter pma_rx_sd_sup_mode             = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_pma_tx_buf
        parameter pma_tx_buf_datarate            = "0 bps",             //
        parameter pma_tx_buf_mcgb_location_for_pcie = 4'b0,
        parameter pma_tx_buf_prot_mode           = "basic_tx",          // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
        parameter pma_tx_buf_rx_det              = "mode_0",            // mode_0|mode_1|mode_2|mode_3|mode_4|mode_5|mode_6|mode_7|mode_8|mode_9|mode_10|mode_11|mode_12|mode_13|mode_14|mode_15
        parameter pma_tx_buf_rx_det_output_sel   = "rx_det_pcie_out",   // rx_det_pcie_out|rx_det_qpi_out
        parameter pma_tx_buf_rx_det_pdb          = "rx_det_off",        // rx_det_off|rx_det_on
        parameter pma_tx_buf_sup_mode            = "user_mode",         // user_mode|engineering_mode
        parameter pma_tx_buf_user_fir_coeff_ctrl_sel = "ram_ctl",       // ram_ctl|dynamic_ctl
        parameter pma_tx_buf_xtx_path_clock_divider_ratio = 4'b0,
        parameter pma_tx_buf_xtx_path_datarate   = "0 bps",             //
        parameter pma_tx_buf_xtx_path_datawidth  = 8'b0,
        parameter pma_tx_buf_xtx_path_pma_tx_divclk_hz = 32'b0,
        parameter pma_tx_buf_xtx_path_prot_mode  = "basic_tx",          // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
        parameter pma_tx_buf_xtx_path_sup_mode   = "user_mode",         // user_mode|engineering_mode
        parameter pma_tx_buf_xtx_path_tx_pll_clk_hz = "0 hz",           //
    // parameters for twentynm_hssi_pma_tx_cgb
        parameter pma_cgb_bitslip_enable         = "enable_bitslip",    // disable_bitslip|enable_bitslip
        parameter pma_cgb_bonding_reset_enable   = "allow_bonding_reset",// disallow_bonding_reset|allow_bonding_reset
        parameter pma_cgb_datarate               = "0 bps",             //
        parameter pma_cgb_input_select_gen3      = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_input_select_x1        = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_input_select_xn        = "unused",            // sel_xn_up|sel_xn_dn|sel_x6_up|sel_x6_dn|sel_cgb_loc|unused
        parameter pma_cgb_pcie_gen3_bitwidth     = "pciegen3_wide",     // pciegen3_wide|pciegen3_narrow
        parameter pma_cgb_prot_mode              = "basic_tx",          // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
        parameter pma_cgb_scratch0_x1_clock_src  = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_scratch1_x1_clock_src  = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_scratch2_x1_clock_src  = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_scratch3_x1_clock_src  = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_select_done_master_or_slave = "choose_slave_pcie_sw_done",// choose_master_pcie_sw_done|choose_slave_pcie_sw_done
        parameter pma_cgb_ser_mode               = "eight_bit",         // eight_bit|ten_bit|sixteen_bit|twenty_bit|thirty_two_bit|forty_bit|sixty_four_bit
        parameter pma_cgb_sup_mode               = "user_mode",         // user_mode|engineering_mode
        parameter pma_cgb_tx_ucontrol_en         = "disable",           // disable|enable
        parameter pma_cgb_x1_div_m_sel           = "divbypass",         // divbypass|divby2|divby4|divby8
    // parameters for twentynm_hssi_pma_tx_ser
        parameter pma_tx_ser_prot_mode           = "basic_tx",          // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
        parameter pma_tx_ser_ser_clk_divtx_user_sel = "divtx_user_33",  // divtx_user_2|divtx_user_40|divtx_user_33|divtx_user_66|divtx_user_1|divtx_user_off
        parameter pma_tx_ser_sup_mode            = "user_mode",         // user_mode|engineering_mode

    // twentynm_pcs parameters
    // parameters for twentynm_hssi_10g_rx_pcs
        parameter hssi_10g_rx_pcs_advanced_user_mode = "disable",       // disable|enable
        parameter hssi_10g_rx_pcs_align_del      = "align_del_en",      // align_del_dis|align_del_en
        parameter hssi_10g_rx_pcs_ber_bit_err_total_cnt = "bit_err_total_cnt_10g",// bit_err_total_cnt_10g
        parameter hssi_10g_rx_pcs_ber_clken      = "ber_clk_dis",       // ber_clk_dis|ber_clk_en
        parameter hssi_10g_rx_pcs_ber_xus_timer_window = 21'b100110001001010,
        parameter hssi_10g_rx_pcs_bitslip_mode   = "bitslip_dis",       // bitslip_dis|bitslip_en
        parameter hssi_10g_rx_pcs_blksync_bitslip_type = "bitslip_comb",// bitslip_comb|bitslip_reg
        parameter hssi_10g_rx_pcs_blksync_bitslip_wait_cnt = 3'b1,
        parameter hssi_10g_rx_pcs_blksync_bitslip_wait_type = "bitslip_match",// bitslip_match|bitslip_cnt
        parameter hssi_10g_rx_pcs_blksync_bypass = "blksync_bypass_dis",// blksync_bypass_dis|blksync_bypass_en
        parameter hssi_10g_rx_pcs_blksync_clken  = "blksync_clk_dis",   // blksync_clk_dis|blksync_clk_en
        parameter hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt = "enum_invalid_sh_cnt_10g",// enum_invalid_sh_cnt_10g
        parameter hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock = "knum_sh_cnt_postlock_10g",// knum_sh_cnt_postlock_10g
        parameter hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock = "knum_sh_cnt_prelock_10g",// knum_sh_cnt_prelock_10g
        parameter hssi_10g_rx_pcs_blksync_pipeln = "blksync_pipeln_dis",// blksync_pipeln_dis|blksync_pipeln_en
        parameter hssi_10g_rx_pcs_clr_errblk_cnt_en = "disable",        // disable|enable
        parameter hssi_10g_rx_pcs_control_del    = "control_del_all",   // control_del_all|control_del_none
        parameter hssi_10g_rx_pcs_crcchk_bypass  = "crcchk_bypass_dis", // crcchk_bypass_dis|crcchk_bypass_en
        parameter hssi_10g_rx_pcs_crcchk_clken   = "crcchk_clk_dis",    // crcchk_clk_dis|crcchk_clk_en
        parameter hssi_10g_rx_pcs_crcchk_inv     = "crcchk_inv_dis",    // crcchk_inv_dis|crcchk_inv_en
        parameter hssi_10g_rx_pcs_crcchk_pipeln  = "crcchk_pipeln_dis", // crcchk_pipeln_dis|crcchk_pipeln_en
        parameter hssi_10g_rx_pcs_crcflag_pipeln = "crcflag_pipeln_dis",// crcflag_pipeln_dis|crcflag_pipeln_en
        parameter hssi_10g_rx_pcs_ctrl_bit_reverse = "ctrl_bit_reverse_dis",// ctrl_bit_reverse_dis|ctrl_bit_reverse_en
        parameter hssi_10g_rx_pcs_data_bit_reverse = "data_bit_reverse_dis",// data_bit_reverse_dis|data_bit_reverse_en
        parameter hssi_10g_rx_pcs_dec64b66b_clken = "dec64b66b_clk_dis",// dec64b66b_clk_dis|dec64b66b_clk_en
        parameter hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass = "dec_64b66b_rxsm_bypass_dis",// dec_64b66b_rxsm_bypass_dis|dec_64b66b_rxsm_bypass_en
        parameter hssi_10g_rx_pcs_descrm_bypass  = "descrm_bypass_en",  // descrm_bypass_dis|descrm_bypass_en
        parameter hssi_10g_rx_pcs_descrm_clken   = "descrm_clk_dis",    // descrm_clk_dis|descrm_clk_en
        parameter hssi_10g_rx_pcs_descrm_mode    = "async",             // async|sync
        parameter hssi_10g_rx_pcs_descrm_pipeln  = "enable",            // disable|enable
        parameter hssi_10g_rx_pcs_dft_clk_out_sel = "rx_master_clk",    // rx_master_clk|rx_gbexp_clk|rx_blksync_clk|rx_descrm_clk|rx_frmsync_clk|rx_64b66bdec_clk|rx_ber_clk|rx_rand_clk|rx_crcchk_clk|rx_wrfifo_clk|rx_rdfifo_clk|rx_fec_clk
        parameter hssi_10g_rx_pcs_dis_signal_ok  = "dis_signal_ok_dis", // dis_signal_ok_dis|dis_signal_ok_en
        parameter hssi_10g_rx_pcs_dispchk_bypass = "dispchk_bypass_dis",// dispchk_bypass_dis|dispchk_bypass_en
        parameter hssi_10g_rx_pcs_empty_flag_type = "empty_rd_side",    // empty_rd_side|empty_wr_side
        parameter hssi_10g_rx_pcs_fast_path      = "fast_path_dis",     // fast_path_dis|fast_path_en
        parameter hssi_10g_rx_pcs_fec_clken      = "fec_clk_dis",       // fec_clk_dis|fec_clk_en
        parameter hssi_10g_rx_pcs_fec_enable     = "fec_dis",           // fec_en|fec_dis
        parameter hssi_10g_rx_pcs_fifo_double_read = "fifo_double_read_dis",// fifo_double_read_dis|fifo_double_read_en
        parameter hssi_10g_rx_pcs_fifo_stop_rd   = "n_rd_empty",        // rd_empty|n_rd_empty
        parameter hssi_10g_rx_pcs_fifo_stop_wr   = "n_wr_full",         // wr_full|n_wr_full
        parameter hssi_10g_rx_pcs_force_align    = "force_align_dis",   // force_align_dis|force_align_en
        parameter hssi_10g_rx_pcs_frmsync_bypass = "frmsync_bypass_dis",// frmsync_bypass_dis|frmsync_bypass_en
        parameter hssi_10g_rx_pcs_frmsync_clken  = "frmsync_clk_dis",   // frmsync_clk_dis|frmsync_clk_en
        parameter hssi_10g_rx_pcs_frmsync_enum_scrm = "enum_scrm_default",// enum_scrm_default
        parameter hssi_10g_rx_pcs_frmsync_enum_sync = "enum_sync_default",// enum_sync_default
        parameter hssi_10g_rx_pcs_frmsync_flag_type = "all_framing_words",// all_framing_words|location_only
        parameter hssi_10g_rx_pcs_frmsync_knum_sync = "knum_sync_default",// knum_sync_default
        parameter hssi_10g_rx_pcs_frmsync_mfrm_length = 16'b100000000000,
        parameter hssi_10g_rx_pcs_frmsync_pipeln = "frmsync_pipeln_dis",// frmsync_pipeln_dis|frmsync_pipeln_en
        parameter hssi_10g_rx_pcs_full_flag_type = "full_wr_side",      // full_rd_side|full_wr_side
        parameter hssi_10g_rx_pcs_gb_rx_idwidth  = "width_32",          // width_40|width_32|width_64
        parameter hssi_10g_rx_pcs_gb_rx_odwidth  = "width_66",          // width_32|width_40|width_50|width_67|width_64|width_66
        parameter hssi_10g_rx_pcs_gbexp_clken    = "gbexp_clk_dis",     // gbexp_clk_dis|gbexp_clk_en
        parameter hssi_10g_rx_pcs_low_latency_en = "enable",            // disable|enable
        parameter hssi_10g_rx_pcs_lpbk_mode      = "lpbk_dis",          // lpbk_dis|lpbk_en
        parameter hssi_10g_rx_pcs_master_clk_sel = "master_rx_pma_clk", // master_rx_pma_clk|master_tx_pma_clk|master_refclk_dig
        parameter hssi_10g_rx_pcs_pempty_flag_type = "pempty_rd_side",  // pempty_rd_side|pempty_wr_side
        parameter hssi_10g_rx_pcs_pfull_flag_type = "pfull_wr_side",    // pfull_rd_side|pfull_wr_side
        parameter hssi_10g_rx_pcs_phcomp_rd_del  = "phcomp_rd_del2",    // phcomp_rd_del4|phcomp_rd_del3|phcomp_rd_del2
        parameter hssi_10g_rx_pcs_pld_if_type    = "fifo",              // fifo|reg
        parameter hssi_10g_rx_pcs_prot_mode      = "disable_mode",      // disable_mode|teng_baser_mode|interlaken_mode|sfis_mode|teng_sdi_mode|basic_mode|test_prp_mode|test_prp_krfec_mode|teng_1588_mode|teng_baser_krfec_mode|teng_1588_krfec_mode|basic_krfec_mode
        parameter hssi_10g_rx_pcs_rand_clken     = "rand_clk_dis",      // rand_clk_dis|rand_clk_en
        parameter hssi_10g_rx_pcs_rd_clk_sel     = "rd_rx_pma_clk",     // rd_rx_pld_clk|rd_rx_pma_clk|rd_refclk_dig
        parameter hssi_10g_rx_pcs_rdfifo_clken   = "rdfifo_clk_dis",    // rdfifo_clk_dis|rdfifo_clk_en
        parameter hssi_10g_rx_pcs_reconfig_settings = "{}",             //
        parameter hssi_10g_rx_pcs_rx_fifo_write_ctrl = "blklock_stops", // blklock_stops|blklock_ignore
        parameter hssi_10g_rx_pcs_rx_scrm_width  = "bit64",             // bit64|bit66|bit67
        parameter hssi_10g_rx_pcs_rx_sh_location = "lsb",               // lsb|msb
        parameter hssi_10g_rx_pcs_rx_signal_ok_sel = "synchronized_ver",// synchronized_ver|nonsync_ver
        parameter hssi_10g_rx_pcs_rx_sm_bypass   = "rx_sm_bypass_dis",  // rx_sm_bypass_dis|rx_sm_bypass_en
        parameter hssi_10g_rx_pcs_rx_sm_hiber    = "rx_sm_hiber_en",    // rx_sm_hiber_en|rx_sm_hiber_dis
        parameter hssi_10g_rx_pcs_rx_sm_pipeln   = "rx_sm_pipeln_dis",  // rx_sm_pipeln_dis|rx_sm_pipeln_en
        parameter hssi_10g_rx_pcs_rx_testbus_sel = "crc32_chk_testbus1",// crc32_chk_testbus1|crc32_chk_testbus2|frame_sync_testbus1|frame_sync_testbus2|dec64b66b_testbus|rxsm_testbus|ber_testbus|blksync_testbus1|blksync_testbus2|gearbox_exp_testbus|random_ver_testbus|descramble_testbus|blank_testbus|rx_fifo_testbus1|rx_fifo_testbus2
        parameter hssi_10g_rx_pcs_rx_true_b2b    = "b2b",               // single|b2b
        parameter hssi_10g_rx_pcs_rxfifo_empty   = "empty_default",     // empty_default
        parameter hssi_10g_rx_pcs_rxfifo_full    = "full_default",      // full_default
        parameter hssi_10g_rx_pcs_rxfifo_mode    = "phase_comp",        // register_mode|clk_comp_10g|generic_interlaken|generic_basic|phase_comp|phase_comp_dv
        parameter hssi_10g_rx_pcs_rxfifo_pempty  = 5'b10,
        parameter hssi_10g_rx_pcs_rxfifo_pfull   = 5'b10111,
        parameter hssi_10g_rx_pcs_stretch_num_stages = "zero_stage",    // zero_stage|one_stage|two_stage|three_stage
        parameter hssi_10g_rx_pcs_sup_mode       = "user_mode",         // user_mode|engineering_mode
        parameter hssi_10g_rx_pcs_test_mode      = "test_off",          // test_off|pseudo_random
        parameter hssi_10g_rx_pcs_wrfifo_clken   = "wrfifo_clk_dis",    // wrfifo_clk_dis|wrfifo_clk_en
    // parameters for twentynm_hssi_10g_tx_pcs
        parameter hssi_10g_tx_pcs_advanced_user_mode = "disable",       // disable|enable
        parameter hssi_10g_tx_pcs_bitslip_en     = "bitslip_dis",       // bitslip_dis|bitslip_en
        parameter hssi_10g_tx_pcs_bonding_dft_en = "dft_dis",           // dft_dis|dft_en
        parameter hssi_10g_tx_pcs_bonding_dft_val = "dft_0",            // dft_0|dft_1
        parameter hssi_10g_tx_pcs_comp_cnt       = 8'b0,
        parameter hssi_10g_tx_pcs_compin_sel     = "compin_master",     // compin_master|compin_slave_top|compin_slave_bot|compin_default
        parameter hssi_10g_tx_pcs_crcgen_bypass  = "crcgen_bypass_dis", // crcgen_bypass_dis|crcgen_bypass_en
        parameter hssi_10g_tx_pcs_crcgen_clken   = "crcgen_clk_dis",    // crcgen_clk_dis|crcgen_clk_en
        parameter hssi_10g_tx_pcs_crcgen_err     = "crcgen_err_dis",    // crcgen_err_dis|crcgen_err_en
        parameter hssi_10g_tx_pcs_crcgen_inv     = "crcgen_inv_dis",    // crcgen_inv_dis|crcgen_inv_en
        parameter hssi_10g_tx_pcs_ctrl_bit_reverse = "ctrl_bit_reverse_dis",// ctrl_bit_reverse_dis|ctrl_bit_reverse_en
        parameter hssi_10g_tx_pcs_ctrl_plane_bonding = "individual",    // individual|ctrl_master|ctrl_slave_abv|ctrl_slave_blw
        parameter hssi_10g_tx_pcs_data_bit_reverse = "data_bit_reverse_dis",// data_bit_reverse_dis|data_bit_reverse_en
        parameter hssi_10g_tx_pcs_dft_clk_out_sel = "tx_master_clk",    // tx_master_clk|tx_rdfifo_clk|tx_frmgen_clk|tx_crcgen_clk|tx_64b66benc_txsm_clk|tx_scrm_clk|tx_dispgen_clk|tx_gbred_clk|tx_wrfifo_clk|tx_fec_clk
        parameter hssi_10g_tx_pcs_dispgen_bypass = "dispgen_bypass_dis",// dispgen_bypass_dis|dispgen_bypass_en
        parameter hssi_10g_tx_pcs_dispgen_clken  = "dispgen_clk_dis",   // dispgen_clk_dis|dispgen_clk_en
        parameter hssi_10g_tx_pcs_dispgen_err    = "dispgen_err_dis",   // dispgen_err_dis|dispgen_err_en
        parameter hssi_10g_tx_pcs_dispgen_pipeln = "dispgen_pipeln_dis",// dispgen_pipeln_dis|dispgen_pipeln_en
        parameter hssi_10g_tx_pcs_distdwn_bypass_pipeln = "distdwn_bypass_pipeln_dis",// distdwn_bypass_pipeln_dis|distdwn_bypass_pipeln_en
        parameter hssi_10g_tx_pcs_distdwn_master = "distdwn_master_en", // distdwn_master_en|distdwn_master_dis
        parameter hssi_10g_tx_pcs_distup_bypass_pipeln = "distup_bypass_pipeln_dis",// distup_bypass_pipeln_dis|distup_bypass_pipeln_en
        parameter hssi_10g_tx_pcs_distup_master  = "distup_master_en",  // distup_master_en|distup_master_dis
        parameter hssi_10g_tx_pcs_dv_bond        = "dv_bond_dis",       // dv_bond_en|dv_bond_dis
        parameter hssi_10g_tx_pcs_empty_flag_type = "empty_rd_side",    // empty_rd_side|empty_wr_side
        parameter hssi_10g_tx_pcs_enc64b66b_txsm_clken = "enc64b66b_txsm_clk_dis",// enc64b66b_txsm_clk_dis|enc64b66b_txsm_clk_en
        parameter hssi_10g_tx_pcs_enc_64b66b_txsm_bypass = "enc_64b66b_txsm_bypass_dis",// enc_64b66b_txsm_bypass_dis|enc_64b66b_txsm_bypass_en
        parameter hssi_10g_tx_pcs_fastpath       = "fastpath_dis",      // fastpath_dis|fastpath_en
        parameter hssi_10g_tx_pcs_fec_clken      = "fec_clk_dis",       // fec_clk_dis|fec_clk_en
        parameter hssi_10g_tx_pcs_fec_enable     = "fec_dis",           // fec_en|fec_dis
        parameter hssi_10g_tx_pcs_fifo_double_write = "fifo_double_write_dis",// fifo_double_write_dis|fifo_double_write_en
        parameter hssi_10g_tx_pcs_fifo_reg_fast  = "fifo_reg_fast_dis", // fifo_reg_fast_dis|fifo_reg_fast_en
        parameter hssi_10g_tx_pcs_fifo_stop_rd   = "n_rd_empty",        // rd_empty|n_rd_empty
        parameter hssi_10g_tx_pcs_fifo_stop_wr   = "n_wr_full",         // wr_full|n_wr_full
        parameter hssi_10g_tx_pcs_frmgen_burst   = "frmgen_burst_dis",  // frmgen_burst_dis|frmgen_burst_en
        parameter hssi_10g_tx_pcs_frmgen_bypass  = "frmgen_bypass_dis", // frmgen_bypass_dis|frmgen_bypass_en
        parameter hssi_10g_tx_pcs_frmgen_clken   = "frmgen_clk_dis",    // frmgen_clk_dis|frmgen_clk_en
        parameter hssi_10g_tx_pcs_frmgen_mfrm_length = 16'b100000000000,
        parameter hssi_10g_tx_pcs_frmgen_pipeln  = "frmgen_pipeln_dis", // frmgen_pipeln_dis|frmgen_pipeln_en
        parameter hssi_10g_tx_pcs_frmgen_pyld_ins = "frmgen_pyld_ins_dis",// frmgen_pyld_ins_dis|frmgen_pyld_ins_en
        parameter hssi_10g_tx_pcs_frmgen_wordslip = "frmgen_wordslip_dis",// frmgen_wordslip_dis|frmgen_wordslip_en
        parameter hssi_10g_tx_pcs_full_flag_type = "full_wr_side",      // full_rd_side|full_wr_side
        parameter hssi_10g_tx_pcs_gb_pipeln_bypass = "enable",          // disable|enable
        parameter hssi_10g_tx_pcs_gb_tx_idwidth  = "width_50",          // width_32|width_40|width_50|width_67|width_64|width_66
        parameter hssi_10g_tx_pcs_gb_tx_odwidth  = "width_32",          // width_32|width_40|width_64
        parameter hssi_10g_tx_pcs_gbred_clken    = "gbred_clk_dis",     // gbred_clk_dis|gbred_clk_en
        parameter hssi_10g_tx_pcs_indv           = "indv_en",           // indv_en|indv_dis
        parameter hssi_10g_tx_pcs_low_latency_en = "enable",            // disable|enable
        parameter hssi_10g_tx_pcs_master_clk_sel = "master_tx_pma_clk", // master_tx_pma_clk|master_refclk_dig
        parameter hssi_10g_tx_pcs_pempty_flag_type = "pempty_rd_side",  // pempty_rd_side|pempty_wr_side
        parameter hssi_10g_tx_pcs_pfull_flag_type = "pfull_wr_side",    // pfull_rd_side|pfull_wr_side
        parameter hssi_10g_tx_pcs_phcomp_rd_del  = "phcomp_rd_del2",    // phcomp_rd_del6|phcomp_rd_del5|phcomp_rd_del4|phcomp_rd_del3|phcomp_rd_del2
        parameter hssi_10g_tx_pcs_pld_if_type    = "fifo",              // fifo|reg|fastreg
        parameter hssi_10g_tx_pcs_prot_mode      = "disable_mode",      // disable_mode|teng_baser_mode|interlaken_mode|sfis_mode|teng_sdi_mode|basic_mode|test_prp_mode|test_prp_krfec_mode|teng_1588_mode|teng_baser_krfec_mode|teng_1588_krfec_mode|basic_krfec_mode
        parameter hssi_10g_tx_pcs_pseudo_random  = "all_0",             // two_lf|all_0
        parameter hssi_10g_tx_pcs_pseudo_seed_a  = 58'b1111111111111111111111111111111111111111111111111111111111,
        parameter hssi_10g_tx_pcs_pseudo_seed_b  = 58'b1111111111111111111111111111111111111111111111111111111111,
        parameter hssi_10g_tx_pcs_random_disp    = "disable",           // disable|enable
        parameter hssi_10g_tx_pcs_rdfifo_clken   = "rdfifo_clk_dis",    // rdfifo_clk_dis|rdfifo_clk_en
        parameter hssi_10g_tx_pcs_reconfig_settings = "{}",             //
        parameter hssi_10g_tx_pcs_scrm_bypass    = "scrm_bypass_dis",   // scrm_bypass_dis|scrm_bypass_en
        parameter hssi_10g_tx_pcs_scrm_clken     = "scrm_clk_dis",      // scrm_clk_dis|scrm_clk_en
        parameter hssi_10g_tx_pcs_scrm_mode      = "async",             // async|sync
        parameter hssi_10g_tx_pcs_scrm_pipeln    = "enable",            // disable|enable
        parameter hssi_10g_tx_pcs_sh_err         = "sh_err_dis",        // sh_err_dis|sh_err_en
        parameter hssi_10g_tx_pcs_sop_mark       = "sop_mark_dis",      // sop_mark_en|sop_mark_dis
        parameter hssi_10g_tx_pcs_stretch_num_stages = "zero_stage",    // zero_stage|one_stage|two_stage|three_stage
        parameter hssi_10g_tx_pcs_sup_mode       = "user_mode",         // user_mode|engineering_mode
        parameter hssi_10g_tx_pcs_test_mode      = "test_off",          // test_off|pseudo_random
        parameter hssi_10g_tx_pcs_tx_scrm_err    = "scrm_err_dis",      // scrm_err_dis|scrm_err_en
        parameter hssi_10g_tx_pcs_tx_scrm_width  = "bit64",             // bit64|bit66|bit67
        parameter hssi_10g_tx_pcs_tx_sh_location = "lsb",               // lsb|msb
        parameter hssi_10g_tx_pcs_tx_sm_bypass   = "tx_sm_bypass_dis",  // tx_sm_bypass_dis|tx_sm_bypass_en
        parameter hssi_10g_tx_pcs_tx_sm_pipeln   = "tx_sm_pipeln_dis",  // tx_sm_pipeln_dis|tx_sm_pipeln_en
        parameter hssi_10g_tx_pcs_tx_testbus_sel = "crc32_gen_testbus1",// crc32_gen_testbus1|crc32_gen_testbus2|disp_gen_testbus1|disp_gen_testbus2|frame_gen_testbus1|frame_gen_testbus2|enc64b66b_testbus|txsm_testbus|tx_cp_bond_testbus|gearbox_red_testbus|scramble_testbus|blank_testbus|tx_fifo_testbus1|tx_fifo_testbus2
        parameter hssi_10g_tx_pcs_txfifo_empty   = "empty_default",     // empty_default
        parameter hssi_10g_tx_pcs_txfifo_full    = "full_default",      // full_default
        parameter hssi_10g_tx_pcs_txfifo_mode    = "phase_comp",        // register_mode|interlaken_generic|basic_generic|phase_comp
        parameter hssi_10g_tx_pcs_txfifo_pempty  = 4'b10,
        parameter hssi_10g_tx_pcs_txfifo_pfull   = 4'b1011,
        parameter hssi_10g_tx_pcs_wr_clk_sel     = "wr_tx_pma_clk",     // wr_tx_pld_clk|wr_tx_pma_clk|wr_refclk_dig
        parameter hssi_10g_tx_pcs_wrfifo_clken   = "wrfifo_clk_dis",    // wrfifo_clk_dis|wrfifo_clk_en
    // parameters for twentynm_hssi_8g_rx_pcs
        parameter hssi_8g_rx_pcs_auto_error_replacement = "dis_err_replace",// dis_err_replace|en_err_replace
        parameter hssi_8g_rx_pcs_auto_speed_nego = "dis_asn",           // dis_asn|en_asn_g2_freq_scal
        parameter hssi_8g_rx_pcs_bit_reversal    = "dis_bit_reversal",  // dis_bit_reversal|en_bit_reversal
        parameter hssi_8g_rx_pcs_bonding_dft_en  = "dft_dis",           // dft_dis|dft_en
        parameter hssi_8g_rx_pcs_bonding_dft_val = "dft_0",             // dft_0|dft_1
        parameter hssi_8g_rx_pcs_bypass_pipeline_reg = "dis_bypass_pipeline",// dis_bypass_pipeline|en_bypass_pipeline
        parameter hssi_8g_rx_pcs_byte_deserializer = "dis_bds",         // dis_bds|en_bds_by_2|en_bds_by_4|en_bds_by_2_det
        parameter hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask = "dis_rxvalid_mask",// dis_rxvalid_mask|en_rxvalid_mask
        parameter hssi_8g_rx_pcs_clkcmp_pattern_n = 20'b0,
        parameter hssi_8g_rx_pcs_clkcmp_pattern_p = 20'b0,
        parameter hssi_8g_rx_pcs_clock_gate_bds_dec_asn = "dis_bds_dec_asn_clk_gating",// dis_bds_dec_asn_clk_gating|en_bds_dec_asn_clk_gating
        parameter hssi_8g_rx_pcs_clock_gate_cdr_eidle = "dis_cdr_eidle_clk_gating",// dis_cdr_eidle_clk_gating|en_cdr_eidle_clk_gating
        parameter hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk = "dis_dw_pc_wrclk_gating",// dis_dw_pc_wrclk_gating|en_dw_pc_wrclk_gating
        parameter hssi_8g_rx_pcs_clock_gate_dw_rm_rd = "dis_dw_rm_rdclk_gating",// dis_dw_rm_rdclk_gating|en_dw_rm_rdclk_gating
        parameter hssi_8g_rx_pcs_clock_gate_dw_rm_wr = "dis_dw_rm_wrclk_gating",// dis_dw_rm_wrclk_gating|en_dw_rm_wrclk_gating
        parameter hssi_8g_rx_pcs_clock_gate_dw_wa = "dis_dw_wa_clk_gating",// dis_dw_wa_clk_gating|en_dw_wa_clk_gating
        parameter hssi_8g_rx_pcs_clock_gate_pc_rdclk = "dis_pc_rdclk_gating",// dis_pc_rdclk_gating|en_pc_rdclk_gating
        parameter hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk = "dis_sw_pc_wrclk_gating",// dis_sw_pc_wrclk_gating|en_sw_pc_wrclk_gating
        parameter hssi_8g_rx_pcs_clock_gate_sw_rm_rd = "dis_sw_rm_rdclk_gating",// dis_sw_rm_rdclk_gating|en_sw_rm_rdclk_gating
        parameter hssi_8g_rx_pcs_clock_gate_sw_rm_wr = "dis_sw_rm_wrclk_gating",// dis_sw_rm_wrclk_gating|en_sw_rm_wrclk_gating
        parameter hssi_8g_rx_pcs_clock_gate_sw_wa = "dis_sw_wa_clk_gating",// dis_sw_wa_clk_gating|en_sw_wa_clk_gating
        parameter hssi_8g_rx_pcs_clock_observation_in_pld_core = "internal_sw_wa_clk",// internal_sw_wa_clk|internal_dw_wa_clk|internal_cdr_eidle_clk|internal_sm_rm_wr_clk|internal_dw_rm_wr_clk|internal_clk_2_b|internal_sw_rm_rd_clk|internal_dw_rm_rd_clk|internal_sw_rx_wr_clk|internal_dw_rx_wr_clk|internal_rx_rd_clk|internal_rx_pma_clk_gen3|internal_rx_rcvd_clk_gen3
        parameter hssi_8g_rx_pcs_ctrl_plane_bonding_compensation = "dis_compensation",// dis_compensation|en_compensation
        parameter hssi_8g_rx_pcs_ctrl_plane_bonding_consumption = "individual",// individual|bundled_master|bundled_slave_below|bundled_slave_above
        parameter hssi_8g_rx_pcs_ctrl_plane_bonding_distribution = "not_master_chnl_distr",// not_master_chnl_distr|master_chnl_distr
        parameter hssi_8g_rx_pcs_eidle_entry_eios = "dis_eidle_eios",   // dis_eidle_eios|en_eidle_eios
        parameter hssi_8g_rx_pcs_eidle_entry_iei = "dis_eidle_iei",     // dis_eidle_iei|en_eidle_iei
        parameter hssi_8g_rx_pcs_eidle_entry_sd  = "dis_eidle_sd",      // dis_eidle_sd|en_eidle_sd
        parameter hssi_8g_rx_pcs_eightb_tenb_decoder = "dis_8b10b",     // dis_8b10b|en_8b10b_ibm|en_8b10b_sgx
        parameter hssi_8g_rx_pcs_err_flags_sel   = "err_flags_wa",      // err_flags_wa|err_flags_8b10b
        parameter hssi_8g_rx_pcs_fixed_pat_det   = "dis_fixed_patdet",  // dis_fixed_patdet|en_fixed_patdet
        parameter hssi_8g_rx_pcs_fixed_pat_num   = 4'b1111,
        parameter hssi_8g_rx_pcs_force_signal_detect = "en_force_signal_detect",// en_force_signal_detect|dis_force_signal_detect
        parameter hssi_8g_rx_pcs_gen3_clk_en     = "disable_clk",       // disable_clk|enable_clk
        parameter hssi_8g_rx_pcs_gen3_rx_clk_sel = "rcvd_clk",          // en_dig_clk1_8g|rcvd_clk
        parameter hssi_8g_rx_pcs_gen3_tx_clk_sel = "tx_pma_clk",        // en_dig_clk2_8g|tx_pma_clk
        parameter hssi_8g_rx_pcs_hip_mode        = "dis_hip",           // dis_hip|en_hip
        parameter hssi_8g_rx_pcs_ibm_invalid_code = "dis_ibm_invalid_code",// dis_ibm_invalid_code|en_ibm_invalid_code
        parameter hssi_8g_rx_pcs_invalid_code_flag_only = "dis_invalid_code_only",// dis_invalid_code_only|en_invalid_code_only
        parameter hssi_8g_rx_pcs_pad_or_edb_error_replace = "replace_edb",// replace_edb|replace_edb_dynamic|replace_pad
        parameter hssi_8g_rx_pcs_pcs_bypass      = "dis_pcs_bypass",    // dis_pcs_bypass|en_pcs_bypass
        parameter hssi_8g_rx_pcs_phase_comp_rdptr = "enable_rdptr",     // disable_rdptr|enable_rdptr
        parameter hssi_8g_rx_pcs_phase_compensation_fifo = "low_latency",// low_latency|normal_latency|register_fifo|pld_ctrl_low_latency|pld_ctrl_normal_latency
        parameter hssi_8g_rx_pcs_pipe_if_enable  = "dis_pipe_rx",       // dis_pipe_rx|en_pipe_rx|en_pipe3_rx
        parameter hssi_8g_rx_pcs_pma_dw          = "eight_bit",         // eight_bit|ten_bit|sixteen_bit|twenty_bit
        parameter hssi_8g_rx_pcs_polinv_8b10b_dec = "dis_polinv_8b10b_dec",// dis_polinv_8b10b_dec|en_polinv_8b10b_dec
        parameter hssi_8g_rx_pcs_prot_mode       = "gige",              // pipe_g1|pipe_g2|pipe_g3|cpri|cpri_rx_tx|gige|gige_1588|basic_rm_enable|basic_rm_disable|disabled_prot_mode
        parameter hssi_8g_rx_pcs_rate_match      = "dis_rm",            // dis_rm|gige_rm|pipe_rm|pipe_rm_0ppm|sw_basic_rm|dw_basic_rm
        parameter hssi_8g_rx_pcs_rate_match_del_thres = "dis_rm_del_thres",// dis_rm_del_thres|gige_rm_del_thres|pipe_rm_del_thres|pipe_rm_0ppm_del_thres|sw_basic_rm_del_thres|dw_basic_rm_del_thres
        parameter hssi_8g_rx_pcs_rate_match_empty_thres = "dis_rm_empty_thres",// dis_rm_empty_thres|gige_rm_empty_thres|pipe_rm_empty_thres|pipe_rm_0ppm_empty_thres|sw_basic_rm_empty_thres|dw_basic_rm_empty_thres
        parameter hssi_8g_rx_pcs_rate_match_full_thres = "dis_rm_full_thres",// dis_rm_full_thres|gige_rm_full_thres|pipe_rm_full_thres|pipe_rm_0ppm_full_thres|sw_basic_rm_full_thres|dw_basic_rm_full_thres
        parameter hssi_8g_rx_pcs_rate_match_ins_thres = "dis_rm_ins_thres",// dis_rm_ins_thres|gige_rm_ins_thres|pipe_rm_ins_thres|pipe_rm_0ppm_ins_thres|sw_basic_rm_ins_thres|dw_basic_rm_ins_thres
        parameter hssi_8g_rx_pcs_rate_match_start_thres = "dis_rm_start_thres",// dis_rm_start_thres|gige_rm_start_thres|pipe_rm_start_thres|pipe_rm_0ppm_start_thres|sw_basic_rm_start_thres|dw_basic_rm_start_thres
        parameter hssi_8g_rx_pcs_reconfig_settings = "{}",              //
        parameter hssi_8g_rx_pcs_rx_clk2         = "rcvd_clk_clk2",     // rcvd_clk_clk2|tx_pma_clock_clk2|refclk_dig2_clk2
        parameter hssi_8g_rx_pcs_rx_clk_free_running = "en_rx_clk_free_run",// dis_rx_clk_free_run|en_rx_clk_free_run
        parameter hssi_8g_rx_pcs_rx_pcs_urst     = "en_rx_pcs_urst",    // dis_rx_pcs_urst|en_rx_pcs_urst
        parameter hssi_8g_rx_pcs_rx_rcvd_clk     = "rcvd_clk_rcvd_clk", // rcvd_clk_rcvd_clk|tx_pma_clock_rcvd_clk
        parameter hssi_8g_rx_pcs_rx_rd_clk       = "pld_rx_clk",        // pld_rx_clk|rx_clk
        parameter hssi_8g_rx_pcs_rx_refclk       = "dis_refclk_sel",    // dis_refclk_sel|en_refclk_sel
        parameter hssi_8g_rx_pcs_rx_wr_clk       = "rx_clk2_div_1_2_4", // rx_clk2_div_1_2_4|txfifo_rd_clk
        parameter hssi_8g_rx_pcs_sup_mode        = "user_mode",         // user_mode|engineering_mode
        parameter hssi_8g_rx_pcs_symbol_swap     = "dis_symbol_swap",   // dis_symbol_swap|en_symbol_swap
        parameter hssi_8g_rx_pcs_sync_sm_idle_eios = "dis_syncsm_idle", // dis_syncsm_idle|en_syncsm_idle
        parameter hssi_8g_rx_pcs_test_bus_sel    = "tx_testbus",        // tx_testbus|tx_ctrl_plane_testbus|wa_testbus|rm_testbus|rx_ctrl_testbus|pcie_ctrl_testbus|rx_ctrl_plane_testbus
        parameter hssi_8g_rx_pcs_tx_rx_parallel_loopback = "dis_plpbk", // dis_plpbk|en_plpbk
        parameter hssi_8g_rx_pcs_wa_boundary_lock_ctrl = "bit_slip",    // bit_slip|sync_sm|deterministic_latency|auto_align_pld_ctrl
        parameter hssi_8g_rx_pcs_wa_clk_slip_spacing = 10'b10000,
        parameter hssi_8g_rx_pcs_wa_det_latency_sync_status_beh = "assert_sync_status_non_imm",// assert_sync_status_imm|assert_sync_status_non_imm|dont_care_assert_sync
        parameter hssi_8g_rx_pcs_wa_disp_err_flag = "dis_disp_err_flag",// dis_disp_err_flag|en_disp_err_flag
        parameter hssi_8g_rx_pcs_wa_kchar        = "dis_kchar",         // dis_kchar|en_kchar
        parameter hssi_8g_rx_pcs_wa_pd           = "wa_pd_10",          // wa_pd_7|wa_pd_10|wa_pd_20|wa_pd_40|wa_pd_8_sw|wa_pd_8_dw|wa_pd_16_sw|wa_pd_16_dw|wa_pd_32
        parameter hssi_8g_rx_pcs_wa_pd_data      = 40'b0,
        parameter hssi_8g_rx_pcs_wa_pd_polarity  = "dis_pd_both_pol",   // dis_pd_both_pol|en_pd_both_pol|dont_care_both_pol
        parameter hssi_8g_rx_pcs_wa_pld_controlled = "dis_pld_ctrl",    // dis_pld_ctrl|pld_ctrl_sw|rising_edge_sensitive_dw|level_sensitive_dw
        parameter hssi_8g_rx_pcs_wa_renumber_data = 6'b0,
        parameter hssi_8g_rx_pcs_wa_rgnumber_data = 8'b0,
        parameter hssi_8g_rx_pcs_wa_rknumber_data = 8'b0,
        parameter hssi_8g_rx_pcs_wa_rosnumber_data = 2'b0,
        parameter hssi_8g_rx_pcs_wa_rvnumber_data = 13'b0,
        parameter hssi_8g_rx_pcs_wa_sync_sm_ctrl = "gige_sync_sm",      // gige_sync_sm|pipe_sync_sm|sw_basic_sync_sm|dw_basic_sync_sm|fibre_channel_sync_sm
        parameter hssi_8g_rx_pcs_wait_cnt        = 12'b0,
    // parameters for twentynm_hssi_8g_tx_pcs
        parameter hssi_8g_tx_pcs_auto_speed_nego_gen2 = "dis_asn_g2",   // dis_asn_g2|en_asn_g2_freq_scal
        parameter hssi_8g_tx_pcs_bit_reversal    = "dis_bit_reversal",  // dis_bit_reversal|en_bit_reversal
        parameter hssi_8g_tx_pcs_bonding_dft_en  = "dft_dis",           // dft_dis|dft_en
        parameter hssi_8g_tx_pcs_bonding_dft_val = "dft_0",             // dft_0|dft_1
        parameter hssi_8g_tx_pcs_bypass_pipeline_reg = "dis_bypass_pipeline",// dis_bypass_pipeline|en_bypass_pipeline
        parameter hssi_8g_tx_pcs_byte_serializer = "dis_bs",            // dis_bs|en_bs_by_2|en_bs_by_4
        parameter hssi_8g_tx_pcs_clock_gate_bs_enc = "dis_bs_enc_clk_gating",// dis_bs_enc_clk_gating|en_bs_enc_clk_gating
        parameter hssi_8g_tx_pcs_clock_gate_dw_fifowr = "dis_dw_fifowr_clk_gating",// dis_dw_fifowr_clk_gating|en_dw_fifowr_clk_gating
        parameter hssi_8g_tx_pcs_clock_gate_fiford = "dis_fiford_clk_gating",// dis_fiford_clk_gating|en_fiford_clk_gating
        parameter hssi_8g_tx_pcs_clock_gate_sw_fifowr = "dis_sw_fifowr_clk_gating",// dis_sw_fifowr_clk_gating|en_sw_fifowr_clk_gating
        parameter hssi_8g_tx_pcs_clock_observation_in_pld_core = "internal_refclk_b",// internal_refclk_b|internal_fifo_rd_clk|internal_sw_fifo_wr_clk|internal_dw_fifo_wr_clk|internal_tx_clk_out_gen3|internal_pipe_tx_clk_out_gen3
        parameter hssi_8g_tx_pcs_ctrl_plane_bonding_compensation = "dis_compensation",// dis_compensation|en_compensation
        parameter hssi_8g_tx_pcs_ctrl_plane_bonding_consumption = "individual",// individual|bundled_master|bundled_slave_below|bundled_slave_above
        parameter hssi_8g_tx_pcs_ctrl_plane_bonding_distribution = "not_master_chnl_distr",// not_master_chnl_distr|master_chnl_distr
        parameter hssi_8g_tx_pcs_data_selection_8b10b_encoder_input = "normal_data_path",// normal_data_path|gige_idle_conversion
        parameter hssi_8g_tx_pcs_dynamic_clk_switch = "dis_dyn_clk_switch",// dis_dyn_clk_switch|en_dyn_clk_switch
        parameter hssi_8g_tx_pcs_eightb_tenb_disp_ctrl = "dis_disp_ctrl",// dis_disp_ctrl|en_disp_ctrl|en_ib_disp_ctrl
        parameter hssi_8g_tx_pcs_eightb_tenb_encoder = "dis_8b10b",     // dis_8b10b|en_8b10b_ibm|en_8b10b_sgx
        parameter hssi_8g_tx_pcs_force_echar     = "dis_force_echar",   // dis_force_echar|en_force_echar
        parameter hssi_8g_tx_pcs_force_kchar     = "dis_force_kchar",   // dis_force_kchar|en_force_kchar
        parameter hssi_8g_tx_pcs_gen3_tx_clk_sel = "tx_pma_clk",        // dis_tx_clk|tx_pma_clk
        parameter hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel = "func_clk",     // dis_tx_pipe_clk|func_clk
        parameter hssi_8g_tx_pcs_hip_mode        = "dis_hip",           // dis_hip|en_hip
        parameter hssi_8g_tx_pcs_pcs_bypass      = "dis_pcs_bypass",    // dis_pcs_bypass|en_pcs_bypass
        parameter hssi_8g_tx_pcs_phase_comp_rdptr = "enable_rdptr",     // disable_rdptr|enable_rdptr
        parameter hssi_8g_tx_pcs_phase_compensation_fifo = "low_latency",// low_latency|normal_latency|register_fifo|pld_ctrl_low_latency|pld_ctrl_normal_latency
        parameter hssi_8g_tx_pcs_phfifo_write_clk_sel = "pld_tx_clk",   // pld_tx_clk|tx_clk
        parameter hssi_8g_tx_pcs_pma_dw          = "eight_bit",         // eight_bit|ten_bit|sixteen_bit|twenty_bit
        parameter hssi_8g_tx_pcs_prot_mode       = "basic",             // pipe_g1|pipe_g2|pipe_g3|cpri|cpri_rx_tx|gige|gige_1588|basic|disabled_prot_mode
        parameter hssi_8g_tx_pcs_reconfig_settings = "{}",              //
        parameter hssi_8g_tx_pcs_refclk_b_clk_sel = "tx_pma_clock",     // tx_pma_clock|refclk_dig
        parameter hssi_8g_tx_pcs_revloop_back_rm = "dis_rev_loopback_rx_rm",// dis_rev_loopback_rx_rm|en_rev_loopback_rx_rm
        parameter hssi_8g_tx_pcs_sup_mode        = "user_mode",         // user_mode|engineering_mode
        parameter hssi_8g_tx_pcs_symbol_swap     = "dis_symbol_swap",   // dis_symbol_swap|en_symbol_swap
        parameter hssi_8g_tx_pcs_tx_bitslip      = "dis_tx_bitslip",    // dis_tx_bitslip|en_tx_bitslip
        parameter hssi_8g_tx_pcs_tx_compliance_controlled_disparity = "dis_txcompliance",// dis_txcompliance|en_txcompliance_pipe2p0|en_txcompliance_pipe3p0
        parameter hssi_8g_tx_pcs_tx_fast_pld_reg = "dis_tx_fast_pld_reg",// dis_tx_fast_pld_reg|en_tx_fast_pld_reg
        parameter hssi_8g_tx_pcs_txclk_freerun   = "dis_freerun_tx",    // dis_freerun_tx|en_freerun_tx
        parameter hssi_8g_tx_pcs_txpcs_urst      = "en_txpcs_urst",     // dis_txpcs_urst|en_txpcs_urst
    // parameters for twentynm_hssi_common_pcs_pma_interface
        parameter hssi_common_pcs_pma_interface_asn_clk_enable = "false",// false|true
        parameter hssi_common_pcs_pma_interface_asn_enable = "dis_asn", // dis_asn|en_asn
        parameter hssi_common_pcs_pma_interface_block_sel = "eight_g_pcs",// eight_g_pcs|pcie_gen3
        parameter hssi_common_pcs_pma_interface_bypass_early_eios = "false",// false|true
        parameter hssi_common_pcs_pma_interface_bypass_pcie_switch = "false",// false|true
        parameter hssi_common_pcs_pma_interface_bypass_pma_ltr = "false",// false|true
        parameter hssi_common_pcs_pma_interface_bypass_pma_sw_done = "false",// false|true
        parameter hssi_common_pcs_pma_interface_bypass_ppm_lock = "false",// false|true
        parameter hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp = "false",// false|true
        parameter hssi_common_pcs_pma_interface_bypass_txdetectrx = "false",// false|true
        parameter hssi_common_pcs_pma_interface_cdr_control = "en_cdr_ctrl",// dis_cdr_ctrl|en_cdr_ctrl
        parameter hssi_common_pcs_pma_interface_cid_enable = "en_cid_mode",// dis_cid_mode|en_cid_mode
        parameter hssi_common_pcs_pma_interface_cp_cons_sel = "cp_cons_default",// cp_cons_master|cp_cons_slave_abv|cp_cons_slave_blw|cp_cons_default
        parameter hssi_common_pcs_pma_interface_cp_dwn_mstr = "true",   // false|true
        parameter hssi_common_pcs_pma_interface_cp_up_mstr = "true",    // false|true
        parameter hssi_common_pcs_pma_interface_ctrl_plane_bonding = "individual",// individual|ctrl_master|ctrl_slave_blw|ctrl_slave_abv
        parameter hssi_common_pcs_pma_interface_data_mask_count = 16'b100111000100,
        parameter hssi_common_pcs_pma_interface_data_mask_count_multi = 3'b1,
        parameter hssi_common_pcs_pma_interface_dft_observation_clock_selection = "dft_clk_obsrv_tx0",// dft_clk_obsrv_tx0|dft_clk_obsrv_tx1|dft_clk_obsrv_tx2|dft_clk_obsrv_tx3|dft_clk_obsrv_tx4|dft_clk_obsrv_rx|dft_clk_obsrv_hclk|dft_clk_obsrv_fref|dft_clk_obsrv_clklow|dft_clk_obsrv_asn0|dft_clk_obsrv_asn1
        parameter hssi_common_pcs_pma_interface_early_eios_counter = 8'b110010,
        parameter hssi_common_pcs_pma_interface_force_freqdet = "force_freqdet_dis",// force_freqdet_dis|force1_freqdet_en|force0_freqdet_en
        parameter hssi_common_pcs_pma_interface_free_run_clk_enable = "true",// false|true
        parameter hssi_common_pcs_pma_interface_ignore_sigdet_g23 = "false",// false|true
        parameter hssi_common_pcs_pma_interface_pc_en_counter = 7'b110111,
        parameter hssi_common_pcs_pma_interface_pc_rst_counter = 5'b10111,
        parameter hssi_common_pcs_pma_interface_pcie_hip_mode = "hip_disable",// hip_enable|hip_disable
        parameter hssi_common_pcs_pma_interface_ph_fifo_reg_mode = "phfifo_reg_mode_dis",// phfifo_reg_mode_dis|phfifo_reg_mode_en
        parameter hssi_common_pcs_pma_interface_phfifo_flush_wait = 6'b100100,
        parameter hssi_common_pcs_pma_interface_pipe_if_g3pcs = "pipe_if_8gpcs",// pipe_if_g3pcs|pipe_if_8gpcs
        parameter hssi_common_pcs_pma_interface_pma_done_counter = 18'b101010101110011000,
        parameter hssi_common_pcs_pma_interface_pma_if_dft_en = "dft_dis",// dft_dis|dft_en
        parameter hssi_common_pcs_pma_interface_pma_if_dft_val = "dft_0",// dft_0|dft_1
        parameter hssi_common_pcs_pma_interface_ppm_cnt_rst = "ppm_cnt_rst_dis",// ppm_cnt_rst_dis|ppm_cnt_rst_en
        parameter hssi_common_pcs_pma_interface_ppm_deassert_early = "deassert_early_dis",// deassert_early_dis|deassert_early_en
        parameter hssi_common_pcs_pma_interface_ppm_det_buckets = "ppm_100_bucket",// disable_prot|ppm_300_bucket|ppm_100_bucket|ppm_300_100_bucket
        parameter hssi_common_pcs_pma_interface_ppm_gen1_2_cnt = "cnt_32k",// cnt_32k|cnt_64k
        parameter hssi_common_pcs_pma_interface_ppm_post_eidle_delay = "cnt_200_cycles",// cnt_200_cycles|cnt_400_cycles
        parameter hssi_common_pcs_pma_interface_ppmsel = "ppmsel_300",  // ppmsel_disable|ppmsel_5000|ppmsel_2500|ppmsel_1000|ppmsel_500|ppmsel_300|ppmsel_250|ppmsel_200|ppmsel_125|ppmsel_100|ppmsel_62p5|ppm_other
        parameter hssi_common_pcs_pma_interface_prot_mode = "disable_prot_mode",// disable_prot_mode|pipe_g12|pipe_g3|other_protocols
        parameter hssi_common_pcs_pma_interface_reconfig_settings = "{}",//
        parameter hssi_common_pcs_pma_interface_rxvalid_mask = "rxvalid_mask_en",// rxvalid_mask_dis|rxvalid_mask_en
        parameter hssi_common_pcs_pma_interface_sigdet_wait_counter = 12'b100111000100,
        parameter hssi_common_pcs_pma_interface_sigdet_wait_counter_multi = 3'b1,
        parameter hssi_common_pcs_pma_interface_sim_mode = "disable",   // disable|enable
        parameter hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en = "true",// false|true
        parameter hssi_common_pcs_pma_interface_sup_mode = "user_mode", // user_mode|engineering_mode
        parameter hssi_common_pcs_pma_interface_testout_sel = "ppm_det_test",// ppm_det_test|asn_test|pma_pll_test|rxpmaif_test|prbs_gen_test|prbs_ver_test|uhsif_1_test|uhsif_2_test|uhsif_3_test
        parameter hssi_common_pcs_pma_interface_wait_clk_on_off_timer = 4'b100,
        parameter hssi_common_pcs_pma_interface_wait_pipe_synchronizing = 5'b10111,
        parameter hssi_common_pcs_pma_interface_wait_send_syncp_fbkp = 11'b11111010,
    // parameters for twentynm_hssi_common_pld_pcs_interface
        parameter hssi_common_pld_pcs_interface_dft_clk_out_en = "dft_clk_out_disable",// dft_clk_out_disable|dft_clk_out_enable
        parameter hssi_common_pld_pcs_interface_dft_clk_out_sel = "teng_rx_dft_clk",// teng_rx_dft_clk|teng_tx_dft_clk|eightg_rx_dft_clk|eightg_tx_dft_clk|pmaif_dft_clk
        parameter hssi_common_pld_pcs_interface_hrdrstctrl_en = "hrst_dis",// hrst_dis|hrst_en
        parameter hssi_common_pld_pcs_interface_pcs_testbus_block_sel = "eightg",// eightg|g3pcs|teng|krfec|pma_if
        parameter hssi_common_pld_pcs_interface_reconfig_settings = "{}",//
    // parameters for twentynm_hssi_fifo_rx_pcs
        parameter hssi_fifo_rx_pcs_double_read_mode = "double_read_dis",// double_read_en|double_read_dis
        parameter hssi_fifo_rx_pcs_prot_mode     = "teng_mode",         // teng_mode|non_teng_mode
    // parameters for twentynm_hssi_fifo_tx_pcs
        parameter hssi_fifo_tx_pcs_double_write_mode = "double_write_dis",// double_write_en|double_write_dis
        parameter hssi_fifo_tx_pcs_prot_mode     = "teng_mode",         // teng_mode|non_teng_mode
    // parameters for twentynm_hssi_gen3_rx_pcs
        parameter hssi_gen3_rx_pcs_block_sync    = "enable_block_sync", // bypass_block_sync|enable_block_sync
        parameter hssi_gen3_rx_pcs_block_sync_sm = "enable_blk_sync_sm",// disable_blk_sync_sm|enable_blk_sync_sm
        parameter hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn = "enable",    // disable|enable
        parameter hssi_gen3_rx_pcs_lpbk_force    = "lpbk_frce_dis",     // lpbk_frce_dis|lpbk_frce_en
        parameter hssi_gen3_rx_pcs_mode          = "gen3_func",         // gen3_func|disable_pcs
        parameter hssi_gen3_rx_pcs_rate_match_fifo = "enable_rm_fifo_600ppm",// bypass_rm_fifo|enable_rm_fifo_600ppm|enable_rm_fifo_0ppm
        parameter hssi_gen3_rx_pcs_rate_match_fifo_latency = "regular_latency",// regular_latency|low_latency
        parameter hssi_gen3_rx_pcs_reconfig_settings = "{}",            //
        parameter hssi_gen3_rx_pcs_reverse_lpbk  = "rev_lpbk_en",       // rev_lpbk_dis|rev_lpbk_en
        parameter hssi_gen3_rx_pcs_rx_b4gb_par_lpbk = "b4gb_par_lpbk_dis",// b4gb_par_lpbk_dis|b4gb_par_lpbk_en
        parameter hssi_gen3_rx_pcs_rx_force_balign = "en_force_balign", // en_force_balign|dis_force_balign
        parameter hssi_gen3_rx_pcs_rx_ins_del_one_skip = "ins_del_one_skip_en",// ins_del_one_skip_dis|ins_del_one_skip_en
        parameter hssi_gen3_rx_pcs_rx_num_fixed_pat = 4'b1000,
        parameter hssi_gen3_rx_pcs_rx_test_out_sel = "rx_test_out0",    // rx_test_out0|rx_test_out1
        parameter hssi_gen3_rx_pcs_sup_mode      = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_gen3_tx_pcs
        parameter hssi_gen3_tx_pcs_mode          = "gen3_func",         // gen3_func|disable_pcs
        parameter hssi_gen3_tx_pcs_reverse_lpbk  = "rev_lpbk_en",       // rev_lpbk_dis|rev_lpbk_en
        parameter hssi_gen3_tx_pcs_sup_mode      = "user_mode",         // user_mode|engineering_mode
        parameter hssi_gen3_tx_pcs_tx_bitslip    = 5'b0,
        parameter hssi_gen3_tx_pcs_tx_gbox_byp   = "bypass_gbox",       // bypass_gbox|enable_gbox
    // parameters for twentynm_hssi_krfec_rx_pcs
        parameter hssi_krfec_rx_pcs_blksync_cor_en = "detect",          // detect|correct
        parameter hssi_krfec_rx_pcs_bypass_gb    = "bypass_dis",        // bypass_dis|bypass_en
        parameter hssi_krfec_rx_pcs_clr_ctrl     = "both_enabled",      // both_enabled|corr_cnt_only|uncorr_cnt_only
        parameter hssi_krfec_rx_pcs_ctrl_bit_reverse = "ctrl_bit_reverse_dis",// ctrl_bit_reverse_dis|ctrl_bit_reverse_en
        parameter hssi_krfec_rx_pcs_data_bit_reverse = "data_bit_reverse_dis",// data_bit_reverse_dis|data_bit_reverse_en
        parameter hssi_krfec_rx_pcs_dv_start     = "with_blklock",      // with_blksync|with_blklock
        parameter hssi_krfec_rx_pcs_err_mark_type = "err_mark_10g",     // err_mark_10g|err_mark_40g
        parameter hssi_krfec_rx_pcs_error_marking_en = "err_mark_dis",  // err_mark_dis|err_mark_en
        parameter hssi_krfec_rx_pcs_low_latency_en = "disable",         // disable|enable
        parameter hssi_krfec_rx_pcs_lpbk_mode    = "lpbk_dis",          // lpbk_dis|lpbk_en
        parameter hssi_krfec_rx_pcs_parity_invalid_enum = 8'b1000,
        parameter hssi_krfec_rx_pcs_parity_valid_num = 4'b100,
        parameter hssi_krfec_rx_pcs_pipeln_blksync = "enable",          // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_descrm = "enable",           // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_errcorrect = "enable",       // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_errtrap_ind = "enable",      // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_errtrap_lfsr = "enable",     // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_errtrap_loc = "enable",      // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_errtrap_pat = "enable",      // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_gearbox = "enable",          // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_syndrm = "enable",           // disable|enable
        parameter hssi_krfec_rx_pcs_pipeln_trans_dec = "enable",        // disable|enable
        parameter hssi_krfec_rx_pcs_prot_mode    = "disable_mode",      // disable_mode|teng_basekr_mode|fortyg_basekr_mode|teng_1588_basekr_mode|basic_mode
        parameter hssi_krfec_rx_pcs_receive_order = "receive_lsb",      // receive_lsb|receive_msb
        parameter hssi_krfec_rx_pcs_reconfig_settings = "{}",           //
        parameter hssi_krfec_rx_pcs_rx_testbus_sel = "overall",         // overall|fast_search|fast_search_cntrs|blksync|blksync_cntrs|decoder_master_sm|decoder_master_sm_cntrs|syndrm_sm|syndrm1|syndrm2|errtrap_sm|errtrap_ind1|errtrap_ind2|errtrap_ind3|errtrap_ind4|errtrap_ind5|errtrap_loc|errtrap_pat1|errtrap_pat2|errtrap_pat3|errtrap_pat4|decoder_rd_sm|gb_and_trans
        parameter hssi_krfec_rx_pcs_signal_ok_en = "sig_ok_dis",        // sig_ok_dis|sig_ok_en
        parameter hssi_krfec_rx_pcs_sup_mode     = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_krfec_tx_pcs
        parameter hssi_krfec_tx_pcs_burst_err    = "burst_err_dis",     // burst_err_dis|burst_err_en
        parameter hssi_krfec_tx_pcs_burst_err_len = "burst_err_len1",   // burst_err_len1|burst_err_len2|burst_err_len3|burst_err_len4|burst_err_len5|burst_err_len6|burst_err_len7|burst_err_len8|burst_err_len9|burst_err_len10|burst_err_len11|burst_err_len12|burst_err_len13|burst_err_len14|burst_err_len15|burst_err_len16
        parameter hssi_krfec_tx_pcs_ctrl_bit_reverse = "ctrl_bit_reverse_dis",// ctrl_bit_reverse_dis|ctrl_bit_reverse_en
        parameter hssi_krfec_tx_pcs_data_bit_reverse = "data_bit_reverse_dis",// data_bit_reverse_dis|data_bit_reverse_en
        parameter hssi_krfec_tx_pcs_enc_frame_query = "enc_query_dis",  // enc_query_dis|enc_query_en
        parameter hssi_krfec_tx_pcs_low_latency_en = "disable",         // disable|enable
        parameter hssi_krfec_tx_pcs_pipeln_encoder = "enable",          // disable|enable
        parameter hssi_krfec_tx_pcs_pipeln_scrambler = "enable",        // disable|enable
        parameter hssi_krfec_tx_pcs_prot_mode    = "disable_mode",      // disable_mode|teng_basekr_mode|fortyg_basekr_mode|teng_1588_basekr_mode|basic_mode
        parameter hssi_krfec_tx_pcs_sup_mode     = "user_mode",         // user_mode|engineering_mode
        parameter hssi_krfec_tx_pcs_transcode_err = "trans_err_dis",    // trans_err_dis|trans_err_en
        parameter hssi_krfec_tx_pcs_transmit_order = "transmit_lsb",    // transmit_lsb|transmit_msb
        parameter hssi_krfec_tx_pcs_tx_testbus_sel = "overall",         // overall|encoder1|encoder2|scramble1|scramble2|scramble3|gearbox
    // parameters for twentynm_hssi_pipe_gen1_2
        parameter hssi_pipe_gen1_2_elec_idle_delay_val = 3'b0,
        parameter hssi_pipe_gen1_2_error_replace_pad = "replace_edb",   // replace_edb|replace_pad
        parameter hssi_pipe_gen1_2_hip_mode      = "dis_hip",           // dis_hip|en_hip
        parameter hssi_pipe_gen1_2_ind_error_reporting = "dis_ind_error_reporting",// dis_ind_error_reporting|en_ind_error_reporting
        parameter hssi_pipe_gen1_2_phystatus_delay_val = 3'b0,
        parameter hssi_pipe_gen1_2_phystatus_rst_toggle = "dis_phystatus_rst_toggle",// dis_phystatus_rst_toggle|en_phystatus_rst_toggle
        parameter hssi_pipe_gen1_2_pipe_byte_de_serializer_en = "dont_care_bds",// dis_bds|en_bds_by_2|dont_care_bds
        parameter hssi_pipe_gen1_2_prot_mode     = "pipe_g1",           // pipe_g1|pipe_g2|pipe_g3|basic|disabled_prot_mode
        parameter hssi_pipe_gen1_2_reconfig_settings = "{}",            //
        parameter hssi_pipe_gen1_2_rx_pipe_enable = "dis_pipe_rx",      // dis_pipe_rx|en_pipe_rx|en_pipe3_rx
        parameter hssi_pipe_gen1_2_rxdetect_bypass = "dis_rxdetect_bypass",// dis_rxdetect_bypass|en_rxdetect_bypass
        parameter hssi_pipe_gen1_2_sup_mode      = "user_mode",         // user_mode|engineering_mode
        parameter hssi_pipe_gen1_2_tx_pipe_enable = "dis_pipe_tx",      // dis_pipe_tx|en_pipe_tx|en_pipe3_tx
        parameter hssi_pipe_gen1_2_txswing       = "dis_txswing",       // dis_txswing|en_txswing
    // parameters for twentynm_hssi_pipe_gen3
        parameter hssi_pipe_gen3_bypass_rx_detection_enable = "false",  // false|true
        parameter hssi_pipe_gen3_bypass_rx_preset = 3'b0,
        parameter hssi_pipe_gen3_bypass_rx_preset_enable = "false",     // false|true
        parameter hssi_pipe_gen3_bypass_tx_coefficent = 18'b0,
        parameter hssi_pipe_gen3_bypass_tx_coefficent_enable = "false", // false|true
        parameter hssi_pipe_gen3_elecidle_delay_g3 = 3'b110,
        parameter hssi_pipe_gen3_ind_error_reporting = "dis_ind_error_reporting",// dis_ind_error_reporting|en_ind_error_reporting
        parameter hssi_pipe_gen3_mode            = "pipe_g1",           // pipe_g1|pipe_g2|pipe_g3|disable_pcs
        parameter hssi_pipe_gen3_phy_status_delay_g12 = 3'b101,
        parameter hssi_pipe_gen3_phy_status_delay_g3 = 3'b101,
        parameter hssi_pipe_gen3_phystatus_rst_toggle_g12 = "dis_phystatus_rst_toggle",// dis_phystatus_rst_toggle|en_phystatus_rst_toggle
        parameter hssi_pipe_gen3_phystatus_rst_toggle_g3 = "dis_phystatus_rst_toggle_g3",// dis_phystatus_rst_toggle_g3|en_phystatus_rst_toggle_g3
        parameter hssi_pipe_gen3_rate_match_pad_insertion = "dis_rm_fifo_pad_ins",// dis_rm_fifo_pad_ins|en_rm_fifo_pad_ins
        parameter hssi_pipe_gen3_sup_mode        = "user_mode",         // user_mode|engineering_mode
        parameter hssi_pipe_gen3_test_out_sel    = "disable_test_out",  // tx_test_out|rx_test_out|pipe_test_out1|pipe_test_out2|pipe_test_out3|pipe_ctrl_test_out|disable_test_out
    // parameters for twentynm_hssi_rx_pcs_pma_interface
        parameter hssi_rx_pcs_pma_interface_block_sel = "eight_g_pcs",  // eight_g_pcs|ten_g_pcs|direct_pld
        parameter hssi_rx_pcs_pma_interface_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_rx_pcs_pma_interface_clkslip_sel = "pld",        // pld|slip_eight_g_pcs
        parameter hssi_rx_pcs_pma_interface_lpbk_en = "disable",        // disable|enable
        parameter hssi_rx_pcs_pma_interface_master_clk_sel = "master_rx_pma_clk",// master_rx_pma_clk|master_tx_pma_clk|master_refclk_dig
        parameter hssi_rx_pcs_pma_interface_pldif_datawidth_mode = "pldif_data_10bit",// pldif_data_10bit|pldif_data_8bit
        parameter hssi_rx_pcs_pma_interface_pma_dw_rx = "pma_8b_rx",    // pma_8b_rx|pma_10b_rx|pma_16b_rx|pma_20b_rx|pma_32b_rx|pma_40b_rx|pma_64b_rx|pcie_g3_dyn_dw_rx
        parameter hssi_rx_pcs_pma_interface_pma_if_dft_en = "dft_dis",  // dft_dis|dft_en
        parameter hssi_rx_pcs_pma_interface_pma_if_dft_val = "dft_0",   // dft_0|dft_1
        parameter hssi_rx_pcs_pma_interface_prbs9_dwidth = "prbs9_64b", // prbs9_64b|prbs9_10b
        parameter hssi_rx_pcs_pma_interface_prbs_clken = "prbs_clk_dis",// prbs_clk_dis|prbs_clk_en
        parameter hssi_rx_pcs_pma_interface_prbs_ver = "prbs_off",      // prbs_off|prbs_31|prbs_15|prbs_23|prbs_9|prbs_7
        parameter hssi_rx_pcs_pma_interface_prot_mode_rx = "disabled_prot_mode_rx",// disabled_prot_mode_rx|pcs_direct_mode_rx|eightg_only_pld_mode_rx|eightg_pcie_g12_pld_mode_rx|eightg_g3_pcie_g3_pld_mode_rx|eightg_pcie_g12_hip_mode_rx|eightg_g3_pcie_g3_hip_mode_rx|teng_krfec_mode_rx|eightg_basic_mode_rx|teng_basic_mode_rx|teng_sfis_sdi_mode_rx|prbs_mode_rx
        parameter hssi_rx_pcs_pma_interface_reconfig_settings = "{}",   //
        parameter hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion = "rx_dyn_polinv_dis",// rx_dyn_polinv_dis|rx_dyn_polinv_en
        parameter hssi_rx_pcs_pma_interface_rx_lpbk_en = "lpbk_dis",    // lpbk_dis|lpbk_en
        parameter hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok = "unforce_sig_ok",// unforce_sig_ok|force_sig_ok
        parameter hssi_rx_pcs_pma_interface_rx_prbs_mask = "prbsmask128",// prbsmask128|prbsmask256|prbsmask512|prbsmask1024
        parameter hssi_rx_pcs_pma_interface_rx_prbs_mode = "teng_mode", // teng_mode|eightg_mode
        parameter hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel = "sel_sig_det",// sel_sig_det|sel_sig_ok
        parameter hssi_rx_pcs_pma_interface_rx_static_polarity_inversion = "rx_stat_polinv_dis",// rx_stat_polinv_dis|rx_stat_polinv_en
        parameter hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en = "uhsif_lpbk_dis",// uhsif_lpbk_dis|uhsif_lpbk_en
        parameter hssi_rx_pcs_pma_interface_sup_mode = "user_mode",     // user_mode|engineering_mode
    // parameters for twentynm_hssi_rx_pld_pcs_interface
        parameter hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx = "individual_rx",// individual_rx|ctrl_master_rx|ctrl_slave_abv_rx|ctrl_slave_blw_rx
        parameter hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx = "fifo_rx",// fifo_rx|reg_rx
        parameter hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx = "enable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_10g_lpbk_en = "disable", // disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx = "pma_64b_rx",// pma_32b_rx|pma_40b_rx|pma_64b_rx
        parameter hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx = "disabled_prot_mode_rx",// disabled_prot_mode_rx|teng_baser_mode_rx|interlaken_mode_rx|sfis_mode_rx|teng_sdi_mode_rx|basic_mode_rx|test_prp_mode_rx|test_prp_krfec_mode_rx|teng_1588_mode_rx|teng_baser_krfec_mode_rx|teng_1588_krfec_mode_rx|basic_krfec_mode_rx
        parameter hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx = "single_rx",// single_rx|double_rx
        parameter hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode = "tx",// tx|rx
        parameter hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx = "individual_rx",// individual_rx|ctrl_master_rx|ctrl_slave_abv_rx|ctrl_slave_blw_rx
        parameter hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx = "fifo_rx",// fifo_rx|reg_rx
        parameter hssi_rx_pld_pcs_interface_hd_8g_hip_mode = "disable", // disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_8g_lpbk_en = "disable",  // disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx = "pma_8b_rx",// pma_8b_rx|pma_10b_rx|pma_16b_rx|pma_20b_rx
        parameter hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx = "disabled_prot_mode_rx",// pipe_g1_rx|pipe_g2_rx|pipe_g3_rx|cpri_rx|cpri_rx_tx_rx|gige_rx|gige_1588_rx|basic_rm_enable_rx|basic_rm_disable_rx|disabled_prot_mode_rx
        parameter hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz = 30'b0,
        parameter hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx = "individual_rx",// individual_rx|ctrl_master_rx|ctrl_slave_abv_rx|ctrl_slave_blw_rx
        parameter hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz = 30'b0,
        parameter hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_chnl_func_mode = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_chnl_hip_en = "disable", // disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx = "fifo_rx",// fifo_rx|reg_rx
        parameter hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz = 30'b0,
        parameter hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx = "pma_8b_rx",// pma_8b_rx|pma_10b_rx|pma_16b_rx|pma_20b_rx|pma_32b_rx|pma_40b_rx|pma_64b_rx|pcie_g3_dyn_dw_rx
        parameter hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz = 30'b0,
        parameter hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx = "disabled_prot_mode_rx",// disabled_prot_mode_rx|pcie_g1_capable_rx|pcie_g2_capable_rx|pcie_g3_capable_rx|gige_rx|teng_baser_rx|teng_basekr_krfec_rx|fortyg_basekr_krfec_rx|cpri_8b10b_rx|interlaken_rx|sfis_rx|teng_sdi_rx|gige_1588_rx|teng_1588_baser_rx|teng_1588_basekr_krfec_rx|basic_8gpcs_rm_enable_rx|basic_8gpcs_rm_disable_rx|basic_10gpcs_rx|basic_10gpcs_krfec_rx|pcs_direct_rx|prp_rx|prp_krfec_rx|prbs_rx
        parameter hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx = "single_rx",// single_rx|double_rx
        parameter hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx = "teng_mode_rx",// teng_mode_rx|non_teng_mode_rx
        parameter hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx = "single_rx",// single_rx|double_rx
        parameter hssi_rx_pld_pcs_interface_hd_g3_prot_mode = "disabled_prot_mode",// pipe_g1|pipe_g2|pipe_g3|disabled_prot_mode
        parameter hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx = "disabled_prot_mode_rx",// disabled_prot_mode_rx|teng_basekr_mode_rx|fortyg_basekr_mode_rx|teng_1588_basekr_mode_rx|basic_mode_rx
        parameter hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode = "tx",// tx|rx
        parameter hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx = "disabled_prot_mode_rx",// disabled_prot_mode_rx|eightg_and_g3_pld_fifo_mode_rx|eightg_and_g3_reg_mode_rx|eightg_and_g3_reg_mode_hip_rx|teng_pld_fifo_mode_rx|teng_reg_mode_rx|teng_and_krfec_pld_fifo_mode_rx|teng_and_krfec_reg_mode_rx|pcs_direct_reg_mode_rx
        parameter hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx = "pma_8b_rx",// pma_8b_rx|pma_10b_rx|pma_16b_rx|pma_20b_rx|pma_32b_rx|pma_40b_rx|pma_64b_rx|pcie_g3_dyn_dw_rx
        parameter hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx = "disabled_prot_mode_rx",// disabled_prot_mode_rx|pcs_direct_mode_rx|eightg_only_pld_mode_rx|eightg_pcie_g12_pld_mode_rx|eightg_g3_pcie_g3_pld_mode_rx|eightg_pcie_g12_hip_mode_rx|eightg_g3_pcie_g3_hip_mode_rx|teng_krfec_mode_rx|eightg_basic_mode_rx|teng_basic_mode_rx|teng_sfis_sdi_mode_rx|prbs_mode_rx
        parameter hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode = "disable",// disable|enable
        parameter hssi_rx_pld_pcs_interface_pcs_rx_block_sel = "pcs_direct",// eightg|teng|pcs_direct
        parameter hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel = "teng_clk_out",// eightg_clk_out|teng_clk_out|pma_rx_clk|pma_rx_clk_user
        parameter hssi_rx_pld_pcs_interface_pcs_rx_clk_sel = "pld_rx_clk",// pld_rx_clk|pcs_rx_clk
        parameter hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en = "hip_rx_enable",// hip_rx_enable|hip_rx_disable
        parameter hssi_rx_pld_pcs_interface_pcs_rx_output_sel = "teng_output",// krfec_output|teng_output
        parameter hssi_rx_pld_pcs_interface_reconfig_settings = "{}",   //
    // parameters for twentynm_hssi_tx_pcs_pma_interface
        parameter hssi_tx_pcs_pma_interface_bypass_pma_txelecidle = "false",// false|true
        parameter hssi_tx_pcs_pma_interface_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_tx_pcs_pma_interface_lpbk_en = "disable",        // disable|enable
        parameter hssi_tx_pcs_pma_interface_master_clk_sel = "master_tx_pma_clk",// master_tx_pma_clk|master_refclk_dig
        parameter hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx = "other_prot_mode",// pipe_g12|pipe_g3|other_prot_mode
        parameter hssi_tx_pcs_pma_interface_pldif_datawidth_mode = "pldif_data_10bit",// pldif_data_10bit|pldif_data_8bit
        parameter hssi_tx_pcs_pma_interface_pma_dw_tx = "pma_8b_tx",    // pma_8b_tx|pma_10b_tx|pma_16b_tx|pma_20b_tx|pma_32b_tx|pma_40b_tx|pma_64b_tx|pcie_g3_dyn_dw_tx
        parameter hssi_tx_pcs_pma_interface_pma_if_dft_en = "dft_dis",  // dft_dis|dft_en
        parameter hssi_tx_pcs_pma_interface_pmagate_en = "pmagate_dis", // pmagate_dis|pmagate_en
        parameter hssi_tx_pcs_pma_interface_prbs9_dwidth = "prbs9_64b", // prbs9_64b|prbs9_10b
        parameter hssi_tx_pcs_pma_interface_prbs_clken = "prbs_clk_dis",// prbs_clk_dis|prbs_clk_en
        parameter hssi_tx_pcs_pma_interface_prbs_gen_pat = "prbs_gen_dis",// prbs_gen_dis|prbs_31|prbs_23|prbs_15|prbs_9|prbs_7
        parameter hssi_tx_pcs_pma_interface_prot_mode_tx = "disabled_prot_mode_tx",// disabled_prot_mode_tx|pcs_direct_mode_tx|uhsif_reg_mode_tx|uhsif_direct_mode_tx|eightg_only_pld_mode_tx|eightg_pcie_g12_pld_mode_tx|eightg_g3_pcie_g3_pld_mode_tx|eightg_pcie_g12_hip_mode_tx|eightg_g3_pcie_g3_hip_mode_tx|teng_krfec_mode_tx|eightg_basic_mode_tx|teng_basic_mode_tx|teng_sfis_sdi_mode_tx|prbs_mode_tx|sqwave_mode_tx
        parameter hssi_tx_pcs_pma_interface_reconfig_settings = "{}",   //
        parameter hssi_tx_pcs_pma_interface_sq_wave_num = "sq_wave_4",  // sq_wave_1|sq_wave_4|sq_wave_8|sq_wave_6|sq_wave_default
        parameter hssi_tx_pcs_pma_interface_sqwgen_clken = "sqwgen_clk_dis",// sqwgen_clk_dis|sqwgen_clk_en
        parameter hssi_tx_pcs_pma_interface_sup_mode = "user_mode",     // user_mode|engineering_mode
        parameter hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion = "tx_dyn_polinv_dis",// tx_dyn_polinv_dis|tx_dyn_polinv_en
        parameter hssi_tx_pcs_pma_interface_tx_pma_data_sel = "pld_dir",// pld_dir|pcie_gen3|eight_g_pcs|ten_g_pcs|prbs_pat|sq_wave_pat|block_sel_default|registered_uhsif_dat|directed_uhsif_dat
        parameter hssi_tx_pcs_pma_interface_tx_static_polarity_inversion = "tx_stat_polinv_dis",// tx_stat_polinv_dis|tx_stat_polinv_en
        parameter hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock = "uhsif_filt_stepsz_b4lock_4",// uhsif_filt_stepsz_b4lock_2|uhsif_filt_stepsz_b4lock_4|uhsif_filt_stepsz_b4lock_6|uhsif_filt_stepsz_b4lock_8
        parameter hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value = 4'b1011,
        parameter hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock = "uhsif_filt_cntthr_b4lock_16",// uhsif_filt_cntthr_b4lock_8|uhsif_filt_cntthr_b4lock_16|uhsif_filt_cntthr_b4lock_24|uhsif_filt_cntthr_b4lock_32
        parameter hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period = "uhsif_dcn_test_period_4",// uhsif_dcn_test_period_4|uhsif_dcn_test_period_8|uhsif_dcn_test_period_12|uhsif_dcn_test_period_16
        parameter hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable = "uhsif_dcn_test_mode_disable",// uhsif_dcn_test_mode_enable|uhsif_dcn_test_mode_disable
        parameter hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh = "uhsif_dzt_cnt_thr_4",// uhsif_dzt_cnt_thr_2|uhsif_dzt_cnt_thr_4|uhsif_dzt_cnt_thr_6|uhsif_dzt_cnt_thr_8
        parameter hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable = "uhsif_dzt_enable",// uhsif_dzt_disable|uhsif_dzt_enable
        parameter hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window = "uhsif_dzt_obr_win_32",// uhsif_dzt_obr_win_16|uhsif_dzt_obr_win_32|uhsif_dzt_obr_win_48|uhsif_dzt_obr_win_64
        parameter hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size = "uhsif_dzt_skipsz_8",// uhsif_dzt_skipsz_4|uhsif_dzt_skipsz_8|uhsif_dzt_skipsz_12|uhsif_dzt_skipsz_16
        parameter hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel = "uhsif_index_internal",// uhsif_index_internal|uhsif_index_cram
        parameter hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin = "uhsif_dcn_margin_4",// uhsif_dcn_margin_2|uhsif_dcn_margin_3|uhsif_dcn_margin_4|uhsif_dcn_margin_5
        parameter hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value = 8'b10000000,
        parameter hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control = "uhsif_dft_dz_det_val_0",// uhsif_dft_dz_det_val_0|uhsif_dft_dz_det_val_1
        parameter hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control = "uhsif_dft_up_val_0",// uhsif_dft_up_val_0|uhsif_dft_up_val_1
        parameter hssi_tx_pcs_pma_interface_uhsif_enable = "uhsif_disable",// uhsif_disable|uhsif_enable
        parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock = "uhsif_lkd_segsz_aflock_2048",// uhsif_lkd_segsz_aflock_512|uhsif_lkd_segsz_aflock_1024|uhsif_lkd_segsz_aflock_2048|uhsif_lkd_segsz_aflock_4096
        parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock = "uhsif_lkd_segsz_b4lock_32",// uhsif_lkd_segsz_b4lock_16|uhsif_lkd_segsz_b4lock_32|uhsif_lkd_segsz_b4lock_64|uhsif_lkd_segsz_b4lock_128
        parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value = 4'b1000,
        parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value = 4'b1000,
        parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value = 4'b11,
        parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value = 4'b11,
    // parameters for twentynm_hssi_tx_pld_pcs_interface
        parameter hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx = "individual_tx",// individual_tx|ctrl_master_tx|ctrl_slave_abv_tx|ctrl_slave_blw_tx
        parameter hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx = "fifo_tx",// fifo_tx|reg_tx|fastreg_tx
        parameter hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx = "enable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_10g_lpbk_en = "disable", // disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx = "pma_64b_tx",// pma_32b_tx|pma_40b_tx|pma_64b_tx
        parameter hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx = "disabled_prot_mode_tx",// disabled_prot_mode_tx|teng_baser_mode_tx|interlaken_mode_tx|sfis_mode_tx|teng_sdi_mode_tx|basic_mode_tx|test_prp_mode_tx|test_prp_krfec_mode_tx|teng_1588_mode_tx|teng_baser_krfec_mode_tx|teng_1588_krfec_mode_tx|basic_krfec_mode_tx
        parameter hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx = "single_tx",// single_tx|double_tx
        parameter hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx = "individual_tx",// individual_tx|ctrl_master_tx|ctrl_slave_abv_tx|ctrl_slave_blw_tx
        parameter hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx = "fifo_tx",// fifo_tx|reg_tx|fastreg_tx
        parameter hssi_tx_pld_pcs_interface_hd_8g_hip_mode = "disable", // disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_8g_lpbk_en = "disable",  // disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx = "pma_8b_tx",// pma_8b_tx|pma_10b_tx|pma_16b_tx|pma_20b_tx
        parameter hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx = "disabled_prot_mode_tx",// pipe_g1_tx|pipe_g2_tx|pipe_g3_tx|cpri_tx|cpri_rx_tx_tx|gige_tx|gige_1588_tx|basic_tx|disabled_prot_mode_tx
        parameter hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx = "individual_tx",// individual_tx|ctrl_master_tx|ctrl_slave_abv_tx|ctrl_slave_blw_tx
        parameter hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_chnl_func_mode = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_chnl_hip_en = "disable", // disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx = "fifo_tx",// fifo_tx|reg_tx|fastreg_tx
        parameter hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz = 30'b0,
        parameter hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz = 30'b0,
        parameter hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx = "pma_8b_tx",// pma_8b_tx|pma_10b_tx|pma_16b_tx|pma_20b_tx|pma_32b_tx|pma_40b_tx|pma_64b_tx|pcie_g3_dyn_dw_tx
        parameter hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz = 30'b0,
        parameter hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx = "disabled_prot_mode_tx",// disabled_prot_mode_tx|pcie_g1_capable_tx|pcie_g2_capable_tx|pcie_g3_capable_tx|gige_tx|teng_baser_tx|teng_basekr_krfec_tx|fortyg_basekr_krfec_tx|cpri_8b10b_tx|interlaken_tx|sfis_tx|teng_sdi_tx|gige_1588_tx|teng_1588_baser_tx|teng_1588_basekr_krfec_tx|basic_8gpcs_tx|basic_10gpcs_tx|basic_10gpcs_krfec_tx|pcs_direct_tx|uhsif_tx|prp_tx|prp_krfec_tx|prbs_tx|sqwave_tx
        parameter hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx = "single_tx",// single_tx|double_tx
        parameter hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx = "teng_mode_tx",// teng_mode_tx|non_teng_mode_tx
        parameter hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx = "single_tx",// single_tx|double_tx
        parameter hssi_tx_pld_pcs_interface_hd_g3_prot_mode = "disabled_prot_mode",// pipe_g1|pipe_g2|pipe_g3|disabled_prot_mode
        parameter hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx = "disabled_prot_mode_tx",// disabled_prot_mode_tx|teng_basekr_mode_tx|fortyg_basekr_mode_tx|teng_1588_basekr_mode_tx|basic_mode_tx
        parameter hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx = "disabled_prot_mode_tx",// disabled_prot_mode_tx|eightg_and_g3_pld_fifo_mode_tx|eightg_and_g3_reg_mode_tx|eightg_and_g3_reg_mode_hip_tx|eightg_and_g3_fastreg_mode_tx|teng_pld_fifo_mode_tx|teng_reg_mode_tx|teng_fastreg_mode_tx|teng_and_krfec_pld_fifo_mode_tx|teng_and_krfec_reg_mode_tx|teng_and_krfec_fastreg_mode_tx|pcs_direct_fastreg_mode_tx|uhsif_mode_tx
        parameter hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode = "tx_rx_pair_enabled",// tx_rx_pair_enabled|tx_rx_independent
        parameter hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding = "individual",// individual|ctrl_master|ctrl_slave_abv|ctrl_slave_blw
        parameter hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx = "pma_8b_tx",// pma_8b_tx|pma_10b_tx|pma_16b_tx|pma_20b_tx|pma_32b_tx|pma_40b_tx|pma_64b_tx|pcie_g3_dyn_dw_tx
        parameter hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx = "disabled_prot_mode_tx",// disabled_prot_mode_tx|pcs_direct_mode_tx|uhsif_reg_mode_tx|uhsif_direct_mode_tx|eightg_only_pld_mode_tx|eightg_pcie_g12_pld_mode_tx|eightg_g3_pcie_g3_pld_mode_tx|eightg_pcie_g12_hip_mode_tx|eightg_g3_pcie_g3_hip_mode_tx|teng_krfec_mode_tx|eightg_basic_mode_tx|teng_basic_mode_tx|teng_sfis_sdi_mode_tx|prbs_mode_tx|sqwave_mode_tx
        parameter hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode = "disable",// disable|enable
        parameter hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel = "teng_clk_out",// eightg_clk_out|teng_clk_out|pma_tx_clk|pma_tx_clk_user
        parameter hssi_tx_pld_pcs_interface_pcs_tx_clk_source = "teng", // eightg|teng|pma_clk
        parameter hssi_tx_pld_pcs_interface_pcs_tx_data_source = "hip_disable",// hip_disable|hip_enable
        parameter hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en = "delay1_clk_disable",// delay1_clk_enable|delay1_clk_disable
        parameter hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel = "pld_tx_clk",// pld_tx_clk|pcs_tx_clk
        parameter hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl = "delay1_path0",// delay1_path0|delay1_path1|delay1_path2|delay1_path3|delay1_path4
        parameter hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel = "one_ff_delay",// one_ff_delay|two_ff_delay
        parameter hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en = "delay2_clk_disable",// delay2_clk_enable|delay2_clk_disable
        parameter hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl = "delay2_path0",// delay2_path0|delay2_path1|delay2_path2|delay2_path3|delay2_path4
        parameter hssi_tx_pld_pcs_interface_pcs_tx_output_sel = "teng_output",// krfec_output|teng_output
        parameter hssi_tx_pld_pcs_interface_reconfig_settings = "{}",   //

    // twentynm_xcvr_avmm parameters
        parameter avmm_interfaces                = 1,                   //Number of AVMM interfaces required - one for each bonded_lane, PLL, and Master CGB
        parameter rcfg_enable                    = 0,                   //Enable/disable reconfig interface in the Native PHY or PLL IP
        parameter enable_avmm                    = 1,                   //Enable/disable AVMM atom instantiation
        parameter arbiter_ctrl                   = "pld",               //Calibration request at start-up. Valid values: "uc","pld".
    //"uc" =Initial calibration needed at start-up. Internal DPRIO interface is controlled by uC.
    //"pld"=Initial calibration is not needed at start-up. Internal DPRIO interface is controlled by PLD.
        parameter calibration_en                 = "disable",           //Indicates whether calibration by Hard Nios is enabled or not.Should be set to DISABLE in case if Nios is absent or needs to be bypassed. Valid values: enable, disable
        parameter avmm_busy_en                   = "disable",           //Provides a separate interface for determining control of the AVMM bus, and separates its behavior from the avmm_waitreqeust
        parameter hip_cal_en                     = "disable",           //Indicates whether HIP is enabled or not. Valid values: disable, enable
        parameter cal_done                       = "cal_done_assert"    //Indicates whether calibration is done. This is the start-up value for the corresponding CRAM. THe CRAM is eventually accessed and updated by the Hard uC during calibration. Valid values: cal_done_assert, cal_done_deassert
  )(

  // twentynm_pma ports
  input   wire                                  in_adapt_start,
  input   wire                                  in_clk_cdr_b,
  input   wire                                  in_clk_cdr_t,
  input   wire                                  in_clk_fpll_b,
  input   wire                                  in_clk_fpll_t,
  input   wire                                  in_clk_lc_b,
  input   wire                                  in_clk_lc_hs,
  input   wire                                  in_clk_lc_t,
  input   wire                                  in_clkb_cdr_b,
  input   wire                                  in_clkb_cdr_t,
  input   wire                                  in_clkb_fpll_b,
  input   wire                                  in_clkb_fpll_t,
  input   wire                                  in_clkb_lc_b,
  input   wire                                  in_clkb_lc_hs,
  input   wire                                  in_clkb_lc_t,
  input   wire  [5:0]                           in_cpulse_x6_dn_bus,
  input   wire  [5:0]                           in_cpulse_x6_up_bus,
  input   wire  [5:0]                           in_cpulse_xn_dn_bus,
  input   wire  [5:0]                           in_cpulse_xn_up_bus,
  input   wire  [2:0]                           in_i_rxpreset,
  input   wire  [1:0]                           in_pcie_sw_done_master_in,
  input   wire  [11:0]                          in_ref_iqclk,
  input   wire                                  in_rx_n,
  input   wire                                  in_rx_p,
  output  wire                                  out_clk_divrx_iqtxrx,
  output  wire                                  out_clk_divtx_iqtxrx,
  output  wire  [1:0]                           out_pcie_sw_master,
  output  wire                                  out_tx_n,
  output  wire                                  out_tx_p,

  // twentynm_pcs ports
  input   wire  [4:0]                           in_bond_pcs10g_in_bot,
  input   wire  [4:0]                           in_bond_pcs10g_in_top,
  input   wire  [12:0]                          in_bond_pcs8g_in_bot,
  input   wire  [12:0]                          in_bond_pcs8g_in_top,
  input   wire  [11:0]                          in_bond_pmaif_in_bot,
  input   wire  [11:0]                          in_bond_pmaif_in_top,
  input   wire  [63:0]                          in_hip_tx_data,
  input   wire                                  in_pld_10g_krfec_rx_clr_errblk_cnt,
  input   wire                                  in_pld_10g_krfec_rx_pld_rst_n,
  input   wire                                  in_pld_10g_krfec_tx_pld_rst_n,
  input   wire                                  in_pld_10g_rx_align_clr,
  input   wire                                  in_pld_10g_rx_clr_ber_count,
  input   wire                                  in_pld_10g_rx_rd_en,
  input   wire  [6:0]                           in_pld_10g_tx_bitslip,
  input   wire                                  in_pld_10g_tx_burst_en,
  input   wire                                  in_pld_10g_tx_data_valid,
  input   wire  [1:0]                           in_pld_10g_tx_diag_status,
  input   wire                                  in_pld_10g_tx_wordslip,
  input   wire                                  in_pld_8g_a1a2_size,
  input   wire                                  in_pld_8g_bitloc_rev_en,
  input   wire                                  in_pld_8g_byte_rev_en,
  input   wire  [2:0]                           in_pld_8g_eidleinfersel,
  input   wire                                  in_pld_8g_encdt,
  input   wire                                  in_pld_8g_g3_rx_pld_rst_n,
  input   wire                                  in_pld_8g_g3_tx_pld_rst_n,
  input   wire                                  in_pld_8g_rddisable_tx,
  input   wire                                  in_pld_8g_rdenable_rx,
  input   wire                                  in_pld_8g_refclk_dig2,
  input   wire                                  in_pld_8g_rxpolarity,
  input   wire  [4:0]                           in_pld_8g_tx_boundary_sel,
  input   wire                                  in_pld_8g_wrdisable_rx,
  input   wire                                  in_pld_8g_wrenable_tx,
  input   wire                                  in_pld_atpg_los_en_n,
  input   wire                                  in_pld_bitslip,
  input   wire  [17:0]                          in_pld_g3_current_coeff,
  input   wire  [2:0]                           in_pld_g3_current_rxpreset,
  input   wire                                  in_pld_ltr,
  input   wire                                  in_pld_mem_krfec_atpg_rst_n,
  input   wire                                  in_pld_partial_reconfig,
  input   wire                                  in_pld_pcs_refclk_dig,
  input   wire                                  in_pld_pma_adapt_start,
  input   wire                                  in_pld_pma_early_eios,
  input   wire  [5:0]                           in_pld_pma_eye_monitor,
  input   wire                                  in_pld_pma_ltd_b,
  input   wire  [1:0]                           in_pld_pma_pcie_switch,
  input   wire                                  in_pld_pma_ppm_lock,
  input   wire  [4:0]                           in_pld_pma_reserved_out,
  input   wire                                  in_pld_pma_rs_lpbk_b,
  input   wire                                  in_pld_pma_rx_qpi_pullup,
  input   wire                                  in_pld_pma_rxpma_rstb,
  input   wire                                  in_pld_pma_tx_bitslip,
  input   wire                                  in_pld_pma_tx_bonding_rstb,
  input   wire                                  in_pld_pma_tx_qpi_pulldn,
  input   wire                                  in_pld_pma_tx_qpi_pullup,
  input   wire                                  in_pld_pma_txdetectrx,
  input   wire                                  in_pld_pma_txpma_rstb,
  input   wire                                  in_pld_pmaif_rx_pld_rst_n,
  input   wire                                  in_pld_pmaif_rxclkslip,
  input   wire                                  in_pld_pmaif_tx_pld_rst_n,
  input   wire                                  in_pld_polinv_rx,
  input   wire                                  in_pld_polinv_tx,
  input   wire  [1:0]                           in_pld_rate,
  input   wire  [9:0]                           in_pld_reserved_in,
  input   wire                                  in_pld_rx_clk,
  input   wire                                  in_pld_rx_prbs_err_clr,
  input   wire                                  in_pld_syncsm_en,
  input   wire                                  in_pld_tx_clk,
  input   wire  [17:0]                          in_pld_tx_control,
  input   wire  [127:0]                         in_pld_tx_data,
  input   wire                                  in_pld_txelecidle,
  input   wire                                  in_pld_uhsif_tx_clk,
  input   wire                                  in_pma_hclk,
  output  wire  [4:0]                           out_bond_pcs10g_out_bot,
  output  wire  [4:0]                           out_bond_pcs10g_out_top,
  output  wire  [12:0]                          out_bond_pcs8g_out_bot,
  output  wire  [12:0]                          out_bond_pcs8g_out_top,
  output  wire  [11:0]                          out_bond_pmaif_out_bot,
  output  wire  [11:0]                          out_bond_pmaif_out_top,
  output  wire  [2:0]                           out_hip_clk_out,
  output  wire  [7:0]                           out_hip_ctrl_out,
  output  wire                                  out_hip_npor,
  output  wire  [50:0]                          out_hip_rx_data,
  output  wire                                  out_pld_10g_krfec_rx_blk_lock,
  output  wire  [1:0]                           out_pld_10g_krfec_rx_diag_data_status,
  output  wire                                  out_pld_10g_krfec_rx_frame,
  output  wire                                  out_pld_10g_krfec_tx_frame,
  output  wire                                  out_pld_10g_rx_align_val,
  output  wire                                  out_pld_10g_rx_crc32_err,
  output  wire                                  out_pld_10g_rx_data_valid,
  output  wire                                  out_pld_10g_rx_empty,
  output  wire                                  out_pld_10g_rx_fifo_del,
  output  wire                                  out_pld_10g_rx_fifo_insert,
  output  wire  [4:0]                           out_pld_10g_rx_fifo_num,
  output  wire                                  out_pld_10g_rx_frame_lock,
  output  wire                                  out_pld_10g_rx_hi_ber,
  output  wire                                  out_pld_10g_rx_oflw_err,
  output  wire                                  out_pld_10g_rx_pempty,
  output  wire                                  out_pld_10g_rx_pfull,
  output  wire                                  out_pld_10g_tx_burst_en_exe,
  output  wire                                  out_pld_10g_tx_empty,
  output  wire  [3:0]                           out_pld_10g_tx_fifo_num,
  output  wire                                  out_pld_10g_tx_full,
  output  wire                                  out_pld_10g_tx_pempty,
  output  wire                                  out_pld_10g_tx_pfull,
  output  wire                                  out_pld_10g_tx_wordslip_exe,
  output  wire  [3:0]                           out_pld_8g_a1a2_k1k2_flag,
  output  wire                                  out_pld_8g_empty_rmf,
  output  wire                                  out_pld_8g_empty_rx,
  output  wire                                  out_pld_8g_empty_tx,
  output  wire                                  out_pld_8g_full_rmf,
  output  wire                                  out_pld_8g_full_rx,
  output  wire                                  out_pld_8g_full_tx,
  output  wire                                  out_pld_8g_rxelecidle,
  output  wire                                  out_pld_8g_signal_detect_out,
  output  wire  [4:0]                           out_pld_8g_wa_boundary,
  output  wire                                  out_pld_krfec_tx_alignment,
  output  wire                                  out_pld_pcs_rx_clk_out,
  output  wire                                  out_pld_pcs_tx_clk_out,
  output  wire                                  out_pld_pma_adapt_done,
  output  wire                                  out_pld_pma_clkdiv_rx_user,
  output  wire                                  out_pld_pma_clkdiv_tx_user,
  output  wire                                  out_pld_pma_clklow,
  output  wire                                  out_pld_pma_fref,
  output  wire                                  out_pld_pma_hclk,
  output  wire  [1:0]                           out_pld_pma_pcie_sw_done,
  output  wire                                  out_pld_pma_pfdmode_lock,
  output  wire                                  out_pld_pma_rx_clk_out,
  output  wire                                  out_pld_pma_rx_detect_valid,
  output  wire                                  out_pld_pma_rx_found,
  output  wire                                  out_pld_pma_rxpll_lock,
  output  wire                                  out_pld_pma_signal_ok,
  output  wire  [7:0]                           out_pld_pma_testbus,
  output  wire                                  out_pld_pma_tx_clk_out,
  output  wire                                  out_pld_pmaif_mask_tx_pll,
  output  wire  [9:0]                           out_pld_reserved_out,
  output  wire  [19:0]                          out_pld_rx_control,
  output  wire  [127:0]                         out_pld_rx_data,
  output  wire                                  out_pld_rx_prbs_done,
  output  wire                                  out_pld_rx_prbs_err,
  output  wire  [19:0]                          out_pld_test_data,
  output  wire                                  out_pld_uhsif_lock,
  output  wire                                  out_pld_uhsif_tx_clk_out,

  // twentynm_xcvr_avmm ports
  // AVMM slave interface signals (user)
  input   wire  [avmm_interfaces-1     :0]      avmm_clk,
  input   wire  [avmm_interfaces-1     :0]      avmm_reset,
  input   wire  [avmm_interfaces*8-1   :0]      avmm_writedata,
  input   wire  [avmm_interfaces*9-1   :0]      avmm_address,
  input   wire  [avmm_interfaces-1     :0]      avmm_write,
  input   wire  [avmm_interfaces-1     :0]      avmm_read,
  output  wire  [avmm_interfaces*8-1   :0]      avmm_readdata,
  output  wire  [avmm_interfaces-1     :0]      avmm_waitrequest,
  //AVMM interface busy with calibration
  output  wire  [avmm_interfaces-1     :0]      avmm_busy,
  // Calibration Done
  output  wire  [avmm_interfaces-1     :0]      hip_cal_done,                   //To HIP
  output  wire  [avmm_interfaces-1     :0]      pld_cal_done                    //To PLD
);

  wire  [7:0]                           out_avmmreaddata_cdr_pll;
  wire  [7:0]                           out_avmmreaddata_pma_adapt;
  wire  [7:0]                           out_avmmreaddata_pma_cdr_refclk;
  wire  [7:0]                           out_avmmreaddata_pma_cgb;
  wire  [7:0]                           out_avmmreaddata_pma_rx_buf;
  wire  [7:0]                           out_avmmreaddata_pma_rx_deser;
  wire  [7:0]                           out_avmmreaddata_pma_rx_dfe;
  wire  [7:0]                           out_avmmreaddata_pma_rx_odi;
  wire  [7:0]                           out_avmmreaddata_pma_rx_sd;
  wire  [7:0]                           out_avmmreaddata_pma_tx_buf;
  wire  [7:0]                           out_avmmreaddata_pma_tx_ser;
  wire                                  out_blockselect_cdr_pll;
  wire                                  out_blockselect_pma_adapt;
  wire                                  out_blockselect_pma_cdr_refclk;
  wire                                  out_blockselect_pma_cgb;
  wire                                  out_blockselect_pma_rx_buf;
  wire                                  out_blockselect_pma_rx_deser;
  wire                                  out_blockselect_pma_rx_dfe;
  wire                                  out_blockselect_pma_rx_odi;
  wire                                  out_blockselect_pma_rx_sd;
  wire                                  out_blockselect_pma_tx_buf;
  wire                                  out_blockselect_pma_tx_ser;
  wire                                  out_clk0_pfd;
  wire                                  out_clk180_pfd;
  wire                                  out_clkdiv_rx;
  wire                                  out_clkdiv_rx_user;
  wire                                  out_clkdiv_tx;
  wire                                  out_clkdiv_tx_user;
  wire                                  out_clklow;
  wire                                  out_fref;
  wire                                  out_iqtxrxclk_out0;
  wire                                  out_iqtxrxclk_out1;
  wire                                  out_jtaglpxn;
  wire                                  out_jtaglpxp;
  wire  [1:0]                           out_pcie_sw_done;
  wire                                  out_pfdmode_lock;
  wire                                  out_rx_detect_valid;
  wire                                  out_rx_found;
  wire  [63:0]                          out_rxdata;
  wire                                  out_rxpll_lock;
  wire                                  out_sd;
  wire  [7:0]                           out_avmmreaddata_hssi_10g_rx_pcs;
  wire  [7:0]                           out_avmmreaddata_hssi_10g_tx_pcs;
  wire  [7:0]                           out_avmmreaddata_hssi_8g_rx_pcs;
  wire  [7:0]                           out_avmmreaddata_hssi_8g_tx_pcs;
  wire  [7:0]                           out_avmmreaddata_hssi_common_pcs_pma_interface;
  wire  [7:0]                           out_avmmreaddata_hssi_common_pld_pcs_interface;
  wire  [7:0]                           out_avmmreaddata_hssi_fifo_rx_pcs;
  wire  [7:0]                           out_avmmreaddata_hssi_fifo_tx_pcs;
  wire  [7:0]                           out_avmmreaddata_hssi_gen3_rx_pcs;
  wire  [7:0]                           out_avmmreaddata_hssi_gen3_tx_pcs;
  wire  [7:0]                           out_avmmreaddata_hssi_krfec_rx_pcs;
  wire  [7:0]                           out_avmmreaddata_hssi_krfec_tx_pcs;
  wire  [7:0]                           out_avmmreaddata_hssi_pipe_gen1_2;
  wire  [7:0]                           out_avmmreaddata_hssi_pipe_gen3;
  wire  [7:0]                           out_avmmreaddata_hssi_rx_pcs_pma_interface;
  wire  [7:0]                           out_avmmreaddata_hssi_rx_pld_pcs_interface;
  wire  [7:0]                           out_avmmreaddata_hssi_tx_pcs_pma_interface;
  wire  [7:0]                           out_avmmreaddata_hssi_tx_pld_pcs_interface;
  wire                                  out_blockselect_hssi_10g_rx_pcs;
  wire                                  out_blockselect_hssi_10g_tx_pcs;
  wire                                  out_blockselect_hssi_8g_rx_pcs;
  wire                                  out_blockselect_hssi_8g_tx_pcs;
  wire                                  out_blockselect_hssi_common_pcs_pma_interface;
  wire                                  out_blockselect_hssi_common_pld_pcs_interface;
  wire                                  out_blockselect_hssi_fifo_rx_pcs;
  wire                                  out_blockselect_hssi_fifo_tx_pcs;
  wire                                  out_blockselect_hssi_gen3_rx_pcs;
  wire                                  out_blockselect_hssi_gen3_tx_pcs;
  wire                                  out_blockselect_hssi_krfec_rx_pcs;
  wire                                  out_blockselect_hssi_krfec_tx_pcs;
  wire                                  out_blockselect_hssi_pipe_gen1_2;
  wire                                  out_blockselect_hssi_pipe_gen3;
  wire                                  out_blockselect_hssi_rx_pcs_pma_interface;
  wire                                  out_blockselect_hssi_rx_pld_pcs_interface;
  wire                                  out_blockselect_hssi_tx_pcs_pma_interface;
  wire                                  out_blockselect_hssi_tx_pld_pcs_interface;
  wire                                  out_hip_iocsr_rdy;
  wire                                  out_hip_iocsr_rdy_dly;
  wire                                  out_hip_nfrzdrv;
  wire                                  out_hip_usermode;
  wire  [4:0]                           out_pld_pma_reserved_in;
  wire                                  out_pma_adapt_start;
  wire                                  out_pma_atpg_los_en_n;
  wire                                  out_pma_csr_test_dis;
  wire  [17:0]                          out_pma_current_coeff;
  wire  [2:0]                           out_pma_current_rxpreset;
  wire                                  out_pma_early_eios;
  wire  [5:0]                           out_pma_eye_monitor;
  wire  [1:0]                           out_pma_interface_select;
  wire                                  out_pma_ltd_b;
  wire                                  out_pma_ltr;
  wire                                  out_pma_nfrzdrv;
  wire                                  out_pma_nrpi_freeze;
  wire  [1:0]                           out_pma_pcie_switch;
  wire                                  out_pma_ppm_lock;
  wire  [4:0]                           out_pma_reserved_out;
  wire                                  out_pma_rs_lpbk_b;
  wire                                  out_pma_rx_clkslip;
  wire                                  out_pma_rx_qpi_pullup;
  wire                                  out_pma_rxpma_rstb;
  wire                                  out_pma_scan_mode_n;
  wire                                  out_pma_scan_shift_n;
  wire                                  out_pma_tx_bitslip;
  wire                                  out_pma_tx_bonding_rstb;
  wire                                  out_pma_tx_elec_idle;
  wire  [63:0]                          out_pma_tx_pma_data;
  wire                                  out_pma_tx_qpi_pulldn;
  wire                                  out_pma_tx_qpi_pullup;
  wire                                  out_pma_tx_txdetectrx;
  wire                                  out_pma_txpma_rstb;
  wire  [avmm_interfaces-1    :0]       chnl_pll_avmm_clk;
  wire  [avmm_interfaces-1    :0]       chnl_pll_avmm_rstn;
  wire  [avmm_interfaces*8-1  :0]       chnl_pll_avmm_writedata;
  wire  [avmm_interfaces*9-1  :0]       chnl_pll_avmm_address;
  wire  [avmm_interfaces-1    :0]       chnl_pll_avmm_write;
  wire  [avmm_interfaces-1    :0]       chnl_pll_avmm_read;



  twentynm_pma_rev_20nm1 #(
      .xcvr_native_mode              (xcvr_native_mode              ), // mode_duplex, mode_rx_only, mode_tx_only
      // parameters for twentynm_hssi_pma_adaptation
      .pma_adapt_adapt_mode          (pma_adapt_adapt_mode          ), // ctle|dfe_vga|ctle_vga|ctle_vga_dfe|manual
      .pma_adapt_adp_1s_ctle_bypass  (pma_adapt_adp_1s_ctle_bypass  ), // radp_1s_ctle_bypass_0|radp_1s_ctle_bypass_1
      .pma_adapt_adp_4s_ctle_bypass  (pma_adapt_adp_4s_ctle_bypass  ), // radp_4s_ctle_bypass_0|radp_4s_ctle_bypass_1
      .pma_adapt_adp_ctle_adapt_cycle_window(pma_adapt_adp_ctle_adapt_cycle_window), // radp_ctle_adapt_cycle_window_0|radp_ctle_adapt_cycle_window_1|radp_ctle_adapt_cycle_window_2|radp_ctle_adapt_cycle_window_3|radp_ctle_adapt_cycle_window_4|radp_ctle_adapt_cycle_window_5|radp_ctle_adapt_cycle_window_6|radp_ctle_adapt_cycle_window_7
      .pma_adapt_adp_ctle_en         (pma_adapt_adp_ctle_en         ), // radp_ctle_disable|radp_ctle_enable
      .pma_adapt_adp_dfe_fltap_bypass(pma_adapt_adp_dfe_fltap_bypass), // radp_dfe_fltap_bypass_0|radp_dfe_fltap_bypass_1
      .pma_adapt_adp_dfe_fltap_en    (pma_adapt_adp_dfe_fltap_en    ), // radp_dfe_fltap_disable|radp_dfe_fltap_enable
      .pma_adapt_adp_dfe_fxtap_bypass(pma_adapt_adp_dfe_fxtap_bypass), // radp_dfe_fxtap_bypass_0|radp_dfe_fxtap_bypass_1
      .pma_adapt_adp_dfe_fxtap_en    (pma_adapt_adp_dfe_fxtap_en    ), // radp_dfe_fxtap_disable|radp_dfe_fxtap_enable
      .pma_adapt_adp_dfe_fxtap_hold_en(pma_adapt_adp_dfe_fxtap_hold_en), // radp_dfe_fxtap_not_held|radp_dfe_fxtap_hold
      .pma_adapt_adp_dfe_mode        (pma_adapt_adp_dfe_mode        ), // radp_dfe_mode_0|radp_dfe_mode_1|radp_dfe_mode_2|radp_dfe_mode_3|radp_dfe_mode_4|radp_dfe_mode_5|radp_dfe_mode_6|radp_dfe_mode_7
      .pma_adapt_adp_mode            (pma_adapt_adp_mode            ), // radp_mode_0|radp_mode_1|radp_mode_2|radp_mode_3|radp_mode_4|radp_mode_5|radp_mode_6|radp_mode_7|radp_mode_8|radp_mode_9|radp_mode_10|radp_mode_11|radp_mode_12|radp_mode_13|radp_mode_14|radp_mode_15
      .pma_adapt_adp_onetime_dfe     (pma_adapt_adp_onetime_dfe     ), // radp_onetime_dfe_0|radp_onetime_dfe_1
      .pma_adapt_adp_vga_bypass      (pma_adapt_adp_vga_bypass      ), // radp_vga_bypass_0|radp_vga_bypass_1
      .pma_adapt_adp_vga_en          (pma_adapt_adp_vga_en          ), // radp_vga_disable|radp_vga_enable
      .pma_adapt_adp_vref_bypass     (pma_adapt_adp_vref_bypass     ), // radp_vref_bypass_0|radp_vref_bypass_1
      .pma_adapt_adp_vref_en         (pma_adapt_adp_vref_en         ), // radp_vref_disable|radp_vref_enable
      .pma_adapt_datarate            (pma_adapt_datarate            ), //
      .pma_adapt_odi_dfe_spec_en     (pma_adapt_odi_dfe_spec_en     ), // rodi_dfe_spec_en_0|rodi_dfe_spec_en_1
      .pma_adapt_prot_mode           (pma_adapt_prot_mode           ), // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
      .pma_adapt_sup_mode            (pma_adapt_sup_mode            ), // user_mode|engineering_mode
      // parameters for twentynm_hssi_pma_cdr_refclk_select_mux
      .pma_cdr_refclk_inclk0_logical_to_physical_mapping(pma_cdr_refclk_inclk0_logical_to_physical_mapping), // ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
      .pma_cdr_refclk_inclk1_logical_to_physical_mapping(pma_cdr_refclk_inclk1_logical_to_physical_mapping), // ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
      .pma_cdr_refclk_inclk2_logical_to_physical_mapping(pma_cdr_refclk_inclk2_logical_to_physical_mapping), // ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
      .pma_cdr_refclk_inclk3_logical_to_physical_mapping(pma_cdr_refclk_inclk3_logical_to_physical_mapping), // ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
      .pma_cdr_refclk_inclk4_logical_to_physical_mapping(pma_cdr_refclk_inclk4_logical_to_physical_mapping), // ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
      .pma_cdr_refclk_powerdown_mode (pma_cdr_refclk_powerdown_mode ), // powerup|powerdown
      .pma_cdr_refclk_refclk_select  (pma_cdr_refclk_refclk_select  ), // ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
      // parameters for twentynm_hssi_pma_channel_pll
      .cdr_pll_atb_select_control    (cdr_pll_atb_select_control    ), // atb_off|atb_select_tp_1|atb_select_tp_2|atb_select_tp_3|atb_select_tp_4|atb_select_tp_5|atb_select_tp_6|atb_select_tp_7|atb_select_tp_8|atb_select_tp_9|atb_select_tp_10|atb_select_tp_11|atb_select_tp_12|atb_select_tp_13|atb_select_tp_14|atb_select_tp_15|atb_select_tp_16|atb_select_tp_17|atb_select_tp_18|atb_select_tp_19|atb_select_tp_20|atb_select_tp_21|atb_select_tp_22|atb_select_tp_23|atb_select_tp_24|atb_select_tp_25|atb_select_tp_26|atb_select_tp_27|atb_select_tp_28|atb_select_tp_29|atb_select_tp_30|atb_select_tp_31|atb_select_tp_32|atb_select_tp_33|atb_select_tp_34|atb_select_tp_35|atb_select_tp_36|atb_select_tp_37|atb_select_tp_38|atb_select_tp_39|atb_select_tp_40|atb_select_tp_41|atb_select_tp_42|atb_select_tp_43|atb_select_tp_44|atb_select_tp_45|atb_select_tp_46|atb_select_tp_47|atb_select_tp_48|atb_select_tp_49|atb_select_tp_50|atb_select_tp_51|atb_select_tp_52|atb_select_tp_53|atb_select_tp_54|atb_select_tp_55|atb_select_tp_56|atb_select_tp_57|atb_select_tp_58|atb_select_tp_59|atb_select_tp_60|atb_select_tp_61|atb_select_tp_62|atb_select_tp_63
      .cdr_pll_auto_reset_on         (cdr_pll_auto_reset_on         ), // auto_reset_on|auto_reset_off
      .cdr_pll_bbpd_data_pattern_filter_select(cdr_pll_bbpd_data_pattern_filter_select), // bbpd_data_pat_off|bbpd_data_pat_1|bbpd_data_pat_2|bbpd_data_pat_3
      .cdr_pll_bw_sel                (cdr_pll_bw_sel                ), // low|medium|high
      .cdr_pll_cal_vco_count_length  (cdr_pll_cal_vco_count_length  ), // sel_8b_count|sel_12b_count
      .cdr_pll_cdr_odi_select        (cdr_pll_cdr_odi_select        ), // sel_cdr|sel_odi
      .cdr_pll_cdr_phaselock_mode    (cdr_pll_cdr_phaselock_mode    ), // no_ignore_lock|ignore_lock
      .cdr_pll_cdr_powerdown_mode    (cdr_pll_cdr_powerdown_mode    ), // power_down|power_up
      .cdr_pll_cgb_div               (cdr_pll_cgb_div               ), // 1|2|4|8
      .cdr_pll_chgpmp_current_dn_pd  (cdr_pll_chgpmp_current_dn_pd  ), // cp_current_pd_dn_setting0|cp_current_pd_dn_setting1|cp_current_pd_dn_setting2|cp_current_pd_dn_setting3|cp_current_pd_dn_setting4
      .cdr_pll_chgpmp_current_dn_trim(cdr_pll_chgpmp_current_dn_trim), // cp_current_trimming_dn_setting0|cp_current_trimming_dn_setting1|cp_current_trimming_dn_setting2|cp_current_trimming_dn_setting3|cp_current_trimming_dn_setting4|cp_current_trimming_dn_setting5|cp_current_trimming_dn_setting6|cp_current_trimming_dn_setting7|cp_current_trimming_dn_setting8|cp_current_trimming_dn_setting9|cp_current_trimming_dn_setting10|cp_current_trimming_dn_setting11|cp_current_trimming_dn_setting12|cp_current_trimming_dn_setting13|cp_current_trimming_dn_setting14|cp_current_trimming_dn_setting15
      .cdr_pll_chgpmp_current_pd     (cdr_pll_chgpmp_current_pd     ), // cp_current_pd_setting0|cp_current_pd_setting1|cp_current_pd_setting2|cp_current_pd_setting3|cp_current_pd_setting4
      .cdr_pll_chgpmp_current_pfd    (cdr_pll_chgpmp_current_pfd    ), // cp_current_pfd_setting0|cp_current_pfd_setting1|cp_current_pfd_setting2|cp_current_pfd_setting3|cp_current_pfd_setting4
      .cdr_pll_chgpmp_current_up_pd  (cdr_pll_chgpmp_current_up_pd  ), // cp_current_pd_up_setting0|cp_current_pd_up_setting1|cp_current_pd_up_setting2|cp_current_pd_up_setting3|cp_current_pd_up_setting4
      .cdr_pll_chgpmp_current_up_trim(cdr_pll_chgpmp_current_up_trim), // cp_current_trimming_up_setting0|cp_current_trimming_up_setting1|cp_current_trimming_up_setting2|cp_current_trimming_up_setting3|cp_current_trimming_up_setting4|cp_current_trimming_up_setting5|cp_current_trimming_up_setting6|cp_current_trimming_up_setting7|cp_current_trimming_up_setting8|cp_current_trimming_up_setting9|cp_current_trimming_up_setting10|cp_current_trimming_up_setting11|cp_current_trimming_up_setting12|cp_current_trimming_up_setting13|cp_current_trimming_up_setting14|cp_current_trimming_up_setting15
      .cdr_pll_chgpmp_dn_pd_trim_double(cdr_pll_chgpmp_dn_pd_trim_double), // normal_dn_trim_current|double_dn_trim_current
      .cdr_pll_chgpmp_replicate      (cdr_pll_chgpmp_replicate      ), // false|true
      .cdr_pll_chgpmp_testmode       (cdr_pll_chgpmp_testmode       ), // cp_test_disable|cp_test_up|cp_test_dn|cp_tristate
      .cdr_pll_chgpmp_up_pd_trim_double(cdr_pll_chgpmp_up_pd_trim_double), // normal_up_trim_current|double_up_trim_current
      .cdr_pll_clklow_mux_select     (cdr_pll_clklow_mux_select     ), // clklow_mux_cdr_fbclk|clklow_mux_fpll_test1|clklow_mux_reserved_1|clklow_mux_rx_deser_pclk_test|clklow_mux_reserved_2|clklow_mux_reserved_3|clklow_mux_reserved_4|clklow_mux_dfe_test
      .cdr_pll_datarate              (cdr_pll_datarate              ), //
      .cdr_pll_diag_loopback_enable  (cdr_pll_diag_loopback_enable  ), // true|false
      .cdr_pll_disable_up_dn         (cdr_pll_disable_up_dn         ), // true|false
      .cdr_pll_fb_select             (cdr_pll_fb_select             ), // iqtxrxclk_fb|direct_fb
      .cdr_pll_fref_clklow_div       (cdr_pll_fref_clklow_div       ), // 1|2|4|8
      .cdr_pll_fref_mux_select       (cdr_pll_fref_mux_select       ), // fref_mux_cdr_refclk|fref_mux_fpll_test0|fref_mux_reserved_1|fref_mux_tx_ser_pclk_test|fref_mux_reserved_2|fref_mux_reserved_3|fref_mux_reserved_4|fref_mux_reserved_5
      .cdr_pll_gpon_lck2ref_control  (cdr_pll_gpon_lck2ref_control  ), // gpon_lck2ref_off|gpon_lck2ref_on
      .cdr_pll_initial_settings      (cdr_pll_initial_settings      ), // false|true
      .cdr_pll_iqclk_mux_sel         (cdr_pll_iqclk_mux_sel         ), // iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|power_down
      .cdr_pll_is_cascaded_pll       (cdr_pll_is_cascaded_pll       ), // true|false
      .cdr_pll_lck2ref_delay_control (cdr_pll_lck2ref_delay_control ), // lck2ref_delay_off|lck2ref_delay_1|lck2ref_delay_2|lck2ref_delay_3|lck2ref_delay_4|lck2ref_delay_5|lck2ref_delay_6|lck2ref_delay_7
      .cdr_pll_lf_resistor_pd        (cdr_pll_lf_resistor_pd        ), // lf_pd_setting0|lf_pd_setting1|lf_pd_setting2|lf_pd_setting3
      .cdr_pll_lf_resistor_pfd       (cdr_pll_lf_resistor_pfd       ), // lf_pfd_setting0|lf_pfd_setting1|lf_pfd_setting2|lf_pfd_setting3
      .cdr_pll_lf_ripple_cap         (cdr_pll_lf_ripple_cap         ), // lf_no_ripple|lf_ripple_cap1
      .cdr_pll_loop_filter_bias_select(cdr_pll_loop_filter_bias_select), // lpflt_bias_off|lpflt_bias_1|lpflt_bias_2|lpflt_bias_3|lpflt_bias_4|lpflt_bias_5|lpflt_bias_6|lpflt_bias_7
      .cdr_pll_loopback_mode         (cdr_pll_loopback_mode         ), // loopback_disabled|loopback_recovered_data|rx_refclk|rx_refclk_cdr_loopback|unused2|loopback_received_data|unused1
      .cdr_pll_lpd_counter           (cdr_pll_lpd_counter           ),
      .cdr_pll_lpfd_counter          (cdr_pll_lpfd_counter          ),
      .cdr_pll_ltd_ltr_micro_controller_select(cdr_pll_ltd_ltr_micro_controller_select), // ltd_ltr_pcs|ltr_ucontroller|ltd_ucontroller
      .cdr_pll_m_counter             (cdr_pll_m_counter             ), // 0..255
      .cdr_pll_n_counter             (cdr_pll_n_counter             ), // 1|2|4|8
      .cdr_pll_n_counter_scratch     (cdr_pll_n_counter_scratch     ),
      .cdr_pll_output_clock_frequency(cdr_pll_output_clock_frequency), //
      .cdr_pll_pcie_gen              (cdr_pll_pcie_gen              ), // pcie_gen1_100mhzref|pcie_gen2_100mhzref|pcie_gen3_100mhzref|pcie_gen1_125mhzref|pcie_gen2_125mhzref|pcie_gen3_125mhzref|non_pcie
      .cdr_pll_pd_fastlock_mode      (cdr_pll_pd_fastlock_mode      ), // false|true
      .cdr_pll_pd_l_counter          (cdr_pll_pd_l_counter          ), // 0|1|2|4|8|16
      .cdr_pll_pfd_l_counter         (cdr_pll_pfd_l_counter         ), // 0|1|2|4|8|16|100
      .cdr_pll_pma_width             (cdr_pll_pma_width             ), // 8|10|16|20|32|40|64
      .cdr_pll_primary_use           (cdr_pll_primary_use           ), // cmu|cdr
      .cdr_pll_prot_mode             (cdr_pll_prot_mode             ), // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
      .cdr_pll_reference_clock_frequency(cdr_pll_reference_clock_frequency), //
      .cdr_pll_reverse_serial_loopback(cdr_pll_reverse_serial_loopback), // no_loopback|loopback_data_no_posttap|loopback_data_with_posttap|loopback_data_0_1
      .cdr_pll_set_cdr_input_freq_range(cdr_pll_set_cdr_input_freq_range),
      .cdr_pll_set_cdr_v2i_enable    (cdr_pll_set_cdr_v2i_enable    ), // true|false
      .cdr_pll_set_cdr_vco_reset     (cdr_pll_set_cdr_vco_reset     ), // true|false
      .cdr_pll_set_cdr_vco_speed     (cdr_pll_set_cdr_vco_speed     ),
      .cdr_pll_set_cdr_vco_speed_fix (cdr_pll_set_cdr_vco_speed_fix ),
      .cdr_pll_set_cdr_vco_speed_pciegen3(cdr_pll_set_cdr_vco_speed_pciegen3), // cdr_vco_min_speedbin_pciegen3|cdr_vco_max_speedbin_pciegen3
      .cdr_pll_sup_mode              (cdr_pll_sup_mode              ), // user_mode|engineering_mode
      .cdr_pll_tx_pll_prot_mode      (cdr_pll_tx_pll_prot_mode      ), // txpll_unused|txpll_enable_pcie|txpll_enable
      .cdr_pll_txpll_hclk_driver_enable(cdr_pll_txpll_hclk_driver_enable), // true|false
      .cdr_pll_uc_ro_cal             (cdr_pll_uc_ro_cal             ), // uc_ro_cal_off|uc_ro_cal_on
      .cdr_pll_vco_freq              (cdr_pll_vco_freq              ), //
      .cdr_pll_vco_overrange_voltage (cdr_pll_vco_overrange_voltage ), // vco_overrange_off|vco_overrange_ref_1|vco_overrange_ref_2|vco_overrange_ref_3
      .cdr_pll_vco_underrange_voltage(cdr_pll_vco_underrange_voltage), // vco_underange_off|vco_underange_ref_1|vco_underange_ref_2|vco_underange_ref_3
      // parameters for twentynm_hssi_pma_rx_buf
      .pma_rx_buf_bypass_eqz_stages_234(pma_rx_buf_bypass_eqz_stages_234), // bypass_off|byypass_stages_234
      .pma_rx_buf_datarate           (pma_rx_buf_datarate           ), //
      .pma_rx_buf_diag_lp_en         (pma_rx_buf_diag_lp_en         ), // dlp_off|dlp_on
      .pma_rx_buf_loopback_modes     (pma_rx_buf_loopback_modes     ), // lpbk_disable|pre_cdr|post_cdr
      .pma_rx_buf_pm_tx_rx_cvp_mode  (pma_rx_buf_pm_tx_rx_cvp_mode  ), // cvp_off|cvp_on
      .pma_rx_buf_pm_tx_rx_pcie_gen  (pma_rx_buf_pm_tx_rx_pcie_gen  ), // pcie_gen1_100mhzref|pcie_gen2_100mhzref|pcie_gen3_100mhzref|pcie_gen1_125mhzref|pcie_gen2_125mhzref|pcie_gen3_125mhzref|non_pcie
      .pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth(pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth), // pcie_gen3_32b|pcie_gen3_16b
      .pma_rx_buf_prot_mode          (pma_rx_buf_prot_mode          ), // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
      .pma_rx_buf_qpi_enable         (pma_rx_buf_qpi_enable         ), // non_qpi_mode|qpi_mode
      .pma_rx_buf_refclk_en          (pma_rx_buf_refclk_en          ), // disable|enable
      .pma_rx_buf_rx_refclk_divider  (pma_rx_buf_rx_refclk_divider  ), // bypass_divider|divide_by_2
      .pma_rx_buf_sup_mode           (pma_rx_buf_sup_mode           ), // user_mode|engineering_mode
      .pma_rx_buf_xrx_path_datarate  (pma_rx_buf_xrx_path_datarate  ), //
      .pma_rx_buf_xrx_path_datawidth (pma_rx_buf_xrx_path_datawidth ),
      .pma_rx_buf_xrx_path_pma_rx_divclk_hz(pma_rx_buf_xrx_path_pma_rx_divclk_hz),
      .pma_rx_buf_xrx_path_prot_mode (pma_rx_buf_xrx_path_prot_mode ), // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
      .pma_rx_buf_xrx_path_sup_mode  (pma_rx_buf_xrx_path_sup_mode  ), // user_mode|engineering_mode
      .pma_rx_buf_xrx_path_uc_cal_enable(pma_rx_buf_xrx_path_uc_cal_enable), // rx_cal_off|rx_cal_on
      // parameters for twentynm_hssi_pma_rx_deser
      .pma_rx_deser_bitslip_bypass   (pma_rx_deser_bitslip_bypass   ), // bs_bypass_no|bs_bypass_yes
      .pma_rx_deser_clkdiv_source    (pma_rx_deser_clkdiv_source    ), // vco_bypass_normal|clklow_to_clkdivrx|fref_to_clkdivrx
      .pma_rx_deser_clkdivrx_user_mode(pma_rx_deser_clkdivrx_user_mode), // clkdivrx_user_disabled|clkdivrx_user_clkdiv|clkdivrx_user_clkdiv_div2|clkdivrx_user_div40|clkdivrx_user_div33|clkdivrx_user_div66
      .pma_rx_deser_datarate         (pma_rx_deser_datarate         ), //
      .pma_rx_deser_deser_factor     (pma_rx_deser_deser_factor     ), // 8|10|16|20|32|40|64
      .pma_rx_deser_force_clkdiv_for_testing(pma_rx_deser_force_clkdiv_for_testing), // normal_clkdiv|forced_0|forced_1
      .pma_rx_deser_pcie_gen         (pma_rx_deser_pcie_gen         ), // pcie_gen1_100mhzref|pcie_gen2_100mhzref|pcie_gen3_100mhzref|pcie_gen1_125mhzref|pcie_gen2_125mhzref|pcie_gen3_125mhzref|non_pcie
      .pma_rx_deser_pcie_gen_bitwidth(pma_rx_deser_pcie_gen_bitwidth), // pcie_gen3_32b|pcie_gen3_16b
      .pma_rx_deser_prot_mode        (pma_rx_deser_prot_mode        ), // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
      .pma_rx_deser_rst_n_adapt_odi  (pma_rx_deser_rst_n_adapt_odi  ), // yes_rst_adapt_odi|no_rst_adapt_odi
      .pma_rx_deser_sdclk_enable     (pma_rx_deser_sdclk_enable     ), // false|true
      .pma_rx_deser_sup_mode         (pma_rx_deser_sup_mode         ), // user_mode|engineering_mode
      // parameters for twentynm_hssi_pma_rx_dfe
      .pma_rx_dfe_datarate           (pma_rx_dfe_datarate           ), //
      .pma_rx_dfe_dft_en             (pma_rx_dfe_dft_en             ), // dft_disable|dft_enalbe
      .pma_rx_dfe_pdb                (pma_rx_dfe_pdb                ), // dfe_powerdown|dfe_reset|dfe_enable
      .pma_rx_dfe_pdb_fixedtap       (pma_rx_dfe_pdb_fixedtap       ), // fixtap_dfe_powerdown|fixtap_dfe_enable
      .pma_rx_dfe_pdb_floattap       (pma_rx_dfe_pdb_floattap       ), // floattap_dfe_powerdown|floattap_dfe_enable
      .pma_rx_dfe_pdb_fxtap4t7       (pma_rx_dfe_pdb_fxtap4t7       ), // fxtap4t7_powerdown|fxtap4t7_enable
      .pma_rx_dfe_prot_mode          (pma_rx_dfe_prot_mode          ), // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
      .pma_rx_dfe_sup_mode           (pma_rx_dfe_sup_mode           ), // user_mode|engineering_mode
      // parameters for twentynm_hssi_pma_rx_odi
      .pma_rx_odi_datarate           (pma_rx_odi_datarate           ), //
      .pma_rx_odi_prot_mode          (pma_rx_odi_prot_mode          ), // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
      .pma_rx_odi_step_ctrl_sel      (pma_rx_odi_step_ctrl_sel      ), // dprio_mode|feedback_mode|jm_mode
      .pma_rx_odi_sup_mode           (pma_rx_odi_sup_mode           ), // user_mode|engineering_mode
      // parameters for twentynm_hssi_pma_rx_sd
      .pma_rx_sd_prot_mode           (pma_rx_sd_prot_mode           ), // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
      .pma_rx_sd_sd_output_off       (pma_rx_sd_sd_output_off       ), // 0..28
      .pma_rx_sd_sd_output_on        (pma_rx_sd_sd_output_on        ), // 0..15
      .pma_rx_sd_sd_pdb              (pma_rx_sd_sd_pdb              ), // sd_on|sd_off
      .pma_rx_sd_sup_mode            (pma_rx_sd_sup_mode            ), // user_mode|engineering_mode
      // parameters for twentynm_hssi_pma_tx_buf
      .pma_tx_buf_datarate           (pma_tx_buf_datarate           ), //
      .pma_tx_buf_mcgb_location_for_pcie(pma_tx_buf_mcgb_location_for_pcie),
      .pma_tx_buf_prot_mode          (pma_tx_buf_prot_mode          ), // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
      .pma_tx_buf_rx_det             (pma_tx_buf_rx_det             ), // mode_0|mode_1|mode_2|mode_3|mode_4|mode_5|mode_6|mode_7|mode_8|mode_9|mode_10|mode_11|mode_12|mode_13|mode_14|mode_15
      .pma_tx_buf_rx_det_output_sel  (pma_tx_buf_rx_det_output_sel  ), // rx_det_pcie_out|rx_det_qpi_out
      .pma_tx_buf_rx_det_pdb         (pma_tx_buf_rx_det_pdb         ), // rx_det_off|rx_det_on
      .pma_tx_buf_sup_mode           (pma_tx_buf_sup_mode           ), // user_mode|engineering_mode
      .pma_tx_buf_user_fir_coeff_ctrl_sel(pma_tx_buf_user_fir_coeff_ctrl_sel), // ram_ctl|dynamic_ctl
      .pma_tx_buf_xtx_path_clock_divider_ratio(pma_tx_buf_xtx_path_clock_divider_ratio),
      .pma_tx_buf_xtx_path_datarate  (pma_tx_buf_xtx_path_datarate  ), //
      .pma_tx_buf_xtx_path_datawidth (pma_tx_buf_xtx_path_datawidth ),
      .pma_tx_buf_xtx_path_pma_tx_divclk_hz(pma_tx_buf_xtx_path_pma_tx_divclk_hz),
      .pma_tx_buf_xtx_path_prot_mode (pma_tx_buf_xtx_path_prot_mode ), // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
      .pma_tx_buf_xtx_path_sup_mode  (pma_tx_buf_xtx_path_sup_mode  ), // user_mode|engineering_mode
      .pma_tx_buf_xtx_path_tx_pll_clk_hz(pma_tx_buf_xtx_path_tx_pll_clk_hz), //
      // parameters for twentynm_hssi_pma_tx_cgb
      .pma_cgb_bitslip_enable        (pma_cgb_bitslip_enable        ), // disable_bitslip|enable_bitslip
      .pma_cgb_bonding_reset_enable  (pma_cgb_bonding_reset_enable  ), // disallow_bonding_reset|allow_bonding_reset
      .pma_cgb_datarate              (pma_cgb_datarate              ), //
      .pma_cgb_input_select_gen3     (pma_cgb_input_select_gen3     ), // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
      .pma_cgb_input_select_x1       (pma_cgb_input_select_x1       ), // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
      .pma_cgb_input_select_xn       (pma_cgb_input_select_xn       ), // sel_xn_up|sel_xn_dn|sel_x6_up|sel_x6_dn|sel_cgb_loc|unused
      .pma_cgb_pcie_gen3_bitwidth    (pma_cgb_pcie_gen3_bitwidth    ), // pciegen3_wide|pciegen3_narrow
      .pma_cgb_prot_mode             (pma_cgb_prot_mode             ), // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
      .pma_cgb_scratch0_x1_clock_src (pma_cgb_scratch0_x1_clock_src ), // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
      .pma_cgb_scratch1_x1_clock_src (pma_cgb_scratch1_x1_clock_src ), // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
      .pma_cgb_scratch2_x1_clock_src (pma_cgb_scratch2_x1_clock_src ), // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
      .pma_cgb_scratch3_x1_clock_src (pma_cgb_scratch3_x1_clock_src ), // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
      .pma_cgb_select_done_master_or_slave(pma_cgb_select_done_master_or_slave), // choose_master_pcie_sw_done|choose_slave_pcie_sw_done
      .pma_cgb_ser_mode              (pma_cgb_ser_mode              ), // eight_bit|ten_bit|sixteen_bit|twenty_bit|thirty_two_bit|forty_bit|sixty_four_bit
      .pma_cgb_sup_mode              (pma_cgb_sup_mode              ), // user_mode|engineering_mode
      .pma_cgb_tx_ucontrol_en        (pma_cgb_tx_ucontrol_en        ), // disable|enable
      .pma_cgb_x1_div_m_sel          (pma_cgb_x1_div_m_sel          ), // divbypass|divby2|divby4|divby8
      // parameters for twentynm_hssi_pma_tx_ser
      .pma_tx_ser_prot_mode          (pma_tx_ser_prot_mode          ), // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
      .pma_tx_ser_ser_clk_divtx_user_sel(pma_tx_ser_ser_clk_divtx_user_sel), // divtx_user_2|divtx_user_40|divtx_user_33|divtx_user_66|divtx_user_1|divtx_user_off
      .pma_tx_ser_sup_mode           (pma_tx_ser_sup_mode           )  // user_mode|engineering_mode
    ) inst_twentynm_pma (
      .in_adapt_start                (in_adapt_start                ),
      .in_avmmaddress                (chnl_pll_avmm_address         ),
      .in_avmmclk                    (chnl_pll_avmm_clk             ),
      .in_avmmread                   (chnl_pll_avmm_read            ),
      .in_avmmrstn                   (chnl_pll_avmm_rstn            ),
      .in_avmmwrite                  (chnl_pll_avmm_write           ),
      .in_avmmwritedata              (chnl_pll_avmm_writedata       ),
      .in_clk_cdr_b                  (in_clk_cdr_b                  ),
      .in_clk_cdr_t                  (in_clk_cdr_t                  ),
      .in_clk_fpll_b                 (in_clk_fpll_b                 ),
      .in_clk_fpll_t                 (in_clk_fpll_t                 ),
      .in_clk_lc_b                   (in_clk_lc_b                   ),
      .in_clk_lc_hs                  (in_clk_lc_hs                  ),
      .in_clk_lc_t                   (in_clk_lc_t                   ),
      .in_clkb_cdr_b                 (in_clkb_cdr_b                 ),
      .in_clkb_cdr_t                 (in_clkb_cdr_t                 ),
      .in_clkb_fpll_b                (in_clkb_fpll_b                ),
      .in_clkb_fpll_t                (in_clkb_fpll_t                ),
      .in_clkb_lc_b                  (in_clkb_lc_b                  ),
      .in_clkb_lc_hs                 (in_clkb_lc_hs                 ),
      .in_clkb_lc_t                  (in_clkb_lc_t                  ),
      .in_core_refclk_in             ({bonded_lanes{1'b0}}          ),
      .in_cpulse_x6_dn_bus           (in_cpulse_x6_dn_bus           ),
      .in_cpulse_x6_up_bus           (in_cpulse_x6_up_bus           ),
      .in_cpulse_xn_dn_bus           (in_cpulse_xn_dn_bus           ),
      .in_cpulse_xn_up_bus           (in_cpulse_xn_up_bus           ),
      .in_early_eios                 (out_pma_early_eios            ),
      .in_eye_monitor                (out_pma_eye_monitor           ),
      .in_fpll_ppm_clk_in            (2'b0                          ),
      .in_i_coeff                    (out_pma_current_coeff         ),
      .in_i_rxpreset                 (in_i_rxpreset                 ),
      .in_iqtxrxclk                  ({bonded_lanes{6'b0}} /* CMU Mode only */),
      .in_ltd_b                      (out_pma_ltd_b                 ),
      .in_ltr                        (out_pma_ltr                   ),
      .in_pcie_sw                    (out_pma_pcie_switch           ),
      .in_pcie_sw_done_master_in     (in_pcie_sw_done_master_in     ),
      .in_pma_atpg_los_en_n_in       ({bonded_lanes{1'b1}}          ),
      .in_pma_reserved_out           ({bonded_lanes{5'b1}}          ),
      .in_ppm_lock                   (out_pma_ppm_lock              ),
      .in_ref_iqclk                  (in_ref_iqclk                  ),
      .in_rs_lpbk_b                  (out_pma_rs_lpbk_b             ),
      .in_rx50_buf_in                (                              ),
      .in_rx_bitslip                 (out_pma_rx_clkslip            ),
      .in_rx_n                       (in_rx_n                       ),
      .in_rx_p                       (in_rx_p                       ),
      .in_rx_pma_rstb                (out_pma_rxpma_rstb            ),
      .in_rx_qpi_pulldn              (out_pma_rx_qpi_pullup         ),
      .in_scan_mode_n                ({bonded_lanes{1'b1}}          ),
      .in_scan_shift_n               ({bonded_lanes{1'b1}}          ),
      .in_tx50_buf_in                (                              ),
      .in_tx_bitslip                 (out_pma_tx_bitslip            ),
      .in_tx_bonding_rstb            (out_pma_tx_bonding_rstb       ),
      .in_tx_data                    (out_pma_tx_pma_data           ),
      .in_tx_det_rx                  (out_pma_tx_txdetectrx         ),
      .in_tx_elec_idle               (out_pma_tx_elec_idle          ),
      .in_tx_pma_rstb                (out_pma_txpma_rstb            ),
      .in_tx_qpi_pulldn              (out_pma_tx_qpi_pulldn         ),
      .in_tx_qpi_pullup              (out_pma_tx_qpi_pullup         ),
      .out_avmmreaddata_cdr_pll      (out_avmmreaddata_cdr_pll      ),
      .out_avmmreaddata_pma_adapt    (out_avmmreaddata_pma_adapt    ),
      .out_avmmreaddata_pma_cdr_refclk(out_avmmreaddata_pma_cdr_refclk),
      .out_avmmreaddata_pma_cgb      (out_avmmreaddata_pma_cgb      ),
      .out_avmmreaddata_pma_rx_buf   (out_avmmreaddata_pma_rx_buf   ),
      .out_avmmreaddata_pma_rx_deser (out_avmmreaddata_pma_rx_deser ),
      .out_avmmreaddata_pma_rx_dfe   (out_avmmreaddata_pma_rx_dfe   ),
      .out_avmmreaddata_pma_rx_odi   (out_avmmreaddata_pma_rx_odi   ),
      .out_avmmreaddata_pma_rx_sd    (out_avmmreaddata_pma_rx_sd    ),
      .out_avmmreaddata_pma_tx_buf   (out_avmmreaddata_pma_tx_buf   ),
      .out_avmmreaddata_pma_tx_ser   (out_avmmreaddata_pma_tx_ser   ),
      .out_blockselect_cdr_pll       (out_blockselect_cdr_pll       ),
      .out_blockselect_pma_adapt     (out_blockselect_pma_adapt     ),
      .out_blockselect_pma_cdr_refclk(out_blockselect_pma_cdr_refclk),
      .out_blockselect_pma_cgb       (out_blockselect_pma_cgb       ),
      .out_blockselect_pma_rx_buf    (out_blockselect_pma_rx_buf    ),
      .out_blockselect_pma_rx_deser  (out_blockselect_pma_rx_deser  ),
      .out_blockselect_pma_rx_dfe    (out_blockselect_pma_rx_dfe    ),
      .out_blockselect_pma_rx_odi    (out_blockselect_pma_rx_odi    ),
      .out_blockselect_pma_rx_sd     (out_blockselect_pma_rx_sd     ),
      .out_blockselect_pma_tx_buf    (out_blockselect_pma_tx_buf    ),
      .out_blockselect_pma_tx_ser    (out_blockselect_pma_tx_ser    ),
      .out_clk0_pfd                  (                              ),
      .out_clk180_pfd                (                              ),
      .out_clk_divrx_iqtxrx          (out_clk_divrx_iqtxrx          ),
      .out_clk_divtx_iqtxrx          (out_clk_divtx_iqtxrx          ),
      .out_clkdiv_rx                 (out_clkdiv_rx                 ),
      .out_clkdiv_rx_user            (out_clkdiv_rx_user            ),
      .out_clkdiv_tx                 (out_clkdiv_tx                 ),
      .out_clkdiv_tx_user            (out_clkdiv_tx_user            ),
      .out_clklow                    (out_clklow                    ),
      .out_fref                      (out_fref                      ),
      .out_iqtxrxclk_out0            (                              ),
      .out_iqtxrxclk_out1            (                              ),
      .out_jtaglpxn                  (                              ),
      .out_jtaglpxp                  (                              ),
      .out_pcie_sw_done              (out_pcie_sw_done              ),
      .out_pcie_sw_master            (out_pcie_sw_master            ),
      .out_pfdmode_lock              (out_pfdmode_lock              ),
      .out_rx_detect_valid           (out_rx_detect_valid           ),
      .out_rx_found                  (out_rx_found                  ),
      .out_rxdata                    (out_rxdata                    ),
      .out_rxpll_lock                (out_rxpll_lock                ),
      .out_sd                        (out_sd                        ),
      .out_tx_n                      (out_tx_n                      ),
      .out_tx_p                      (out_tx_p                      )
);


  twentynm_pcs_rev_20nm1 #(
      .xcvr_native_mode              (xcvr_native_mode              ), // mode_duplex, mode_rx_only, mode_tx_only
      // parameters for twentynm_hssi_10g_rx_pcs
      .hssi_10g_rx_pcs_advanced_user_mode(hssi_10g_rx_pcs_advanced_user_mode), // disable|enable
      .hssi_10g_rx_pcs_align_del     (hssi_10g_rx_pcs_align_del     ), // align_del_dis|align_del_en
      .hssi_10g_rx_pcs_ber_bit_err_total_cnt(hssi_10g_rx_pcs_ber_bit_err_total_cnt), // bit_err_total_cnt_10g
      .hssi_10g_rx_pcs_ber_clken     (hssi_10g_rx_pcs_ber_clken     ), // ber_clk_dis|ber_clk_en
      .hssi_10g_rx_pcs_ber_xus_timer_window(hssi_10g_rx_pcs_ber_xus_timer_window),
      .hssi_10g_rx_pcs_bitslip_mode  (hssi_10g_rx_pcs_bitslip_mode  ), // bitslip_dis|bitslip_en
      .hssi_10g_rx_pcs_blksync_bitslip_type(hssi_10g_rx_pcs_blksync_bitslip_type), // bitslip_comb|bitslip_reg
      .hssi_10g_rx_pcs_blksync_bitslip_wait_cnt(hssi_10g_rx_pcs_blksync_bitslip_wait_cnt),
      .hssi_10g_rx_pcs_blksync_bitslip_wait_type(hssi_10g_rx_pcs_blksync_bitslip_wait_type), // bitslip_match|bitslip_cnt
      .hssi_10g_rx_pcs_blksync_bypass(hssi_10g_rx_pcs_blksync_bypass), // blksync_bypass_dis|blksync_bypass_en
      .hssi_10g_rx_pcs_blksync_clken (hssi_10g_rx_pcs_blksync_clken ), // blksync_clk_dis|blksync_clk_en
      .hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt(hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt), // enum_invalid_sh_cnt_10g
      .hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock(hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock), // knum_sh_cnt_postlock_10g
      .hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock(hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock), // knum_sh_cnt_prelock_10g
      .hssi_10g_rx_pcs_blksync_pipeln(hssi_10g_rx_pcs_blksync_pipeln), // blksync_pipeln_dis|blksync_pipeln_en
      .hssi_10g_rx_pcs_clr_errblk_cnt_en(hssi_10g_rx_pcs_clr_errblk_cnt_en), // disable|enable
      .hssi_10g_rx_pcs_control_del   (hssi_10g_rx_pcs_control_del   ), // control_del_all|control_del_none
      .hssi_10g_rx_pcs_crcchk_bypass (hssi_10g_rx_pcs_crcchk_bypass ), // crcchk_bypass_dis|crcchk_bypass_en
      .hssi_10g_rx_pcs_crcchk_clken  (hssi_10g_rx_pcs_crcchk_clken  ), // crcchk_clk_dis|crcchk_clk_en
      .hssi_10g_rx_pcs_crcchk_inv    (hssi_10g_rx_pcs_crcchk_inv    ), // crcchk_inv_dis|crcchk_inv_en
      .hssi_10g_rx_pcs_crcchk_pipeln (hssi_10g_rx_pcs_crcchk_pipeln ), // crcchk_pipeln_dis|crcchk_pipeln_en
      .hssi_10g_rx_pcs_crcflag_pipeln(hssi_10g_rx_pcs_crcflag_pipeln), // crcflag_pipeln_dis|crcflag_pipeln_en
      .hssi_10g_rx_pcs_ctrl_bit_reverse(hssi_10g_rx_pcs_ctrl_bit_reverse), // ctrl_bit_reverse_dis|ctrl_bit_reverse_en
      .hssi_10g_rx_pcs_data_bit_reverse(hssi_10g_rx_pcs_data_bit_reverse), // data_bit_reverse_dis|data_bit_reverse_en
      .hssi_10g_rx_pcs_dec64b66b_clken(hssi_10g_rx_pcs_dec64b66b_clken), // dec64b66b_clk_dis|dec64b66b_clk_en
      .hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass(hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass), // dec_64b66b_rxsm_bypass_dis|dec_64b66b_rxsm_bypass_en
      .hssi_10g_rx_pcs_descrm_bypass (hssi_10g_rx_pcs_descrm_bypass ), // descrm_bypass_dis|descrm_bypass_en
      .hssi_10g_rx_pcs_descrm_clken  (hssi_10g_rx_pcs_descrm_clken  ), // descrm_clk_dis|descrm_clk_en
      .hssi_10g_rx_pcs_descrm_mode   (hssi_10g_rx_pcs_descrm_mode   ), // async|sync
      .hssi_10g_rx_pcs_descrm_pipeln (hssi_10g_rx_pcs_descrm_pipeln ), // disable|enable
      .hssi_10g_rx_pcs_dft_clk_out_sel(hssi_10g_rx_pcs_dft_clk_out_sel), // rx_master_clk|rx_gbexp_clk|rx_blksync_clk|rx_descrm_clk|rx_frmsync_clk|rx_64b66bdec_clk|rx_ber_clk|rx_rand_clk|rx_crcchk_clk|rx_wrfifo_clk|rx_rdfifo_clk|rx_fec_clk
      .hssi_10g_rx_pcs_dis_signal_ok (hssi_10g_rx_pcs_dis_signal_ok ), // dis_signal_ok_dis|dis_signal_ok_en
      .hssi_10g_rx_pcs_dispchk_bypass(hssi_10g_rx_pcs_dispchk_bypass), // dispchk_bypass_dis|dispchk_bypass_en
      .hssi_10g_rx_pcs_empty_flag_type(hssi_10g_rx_pcs_empty_flag_type), // empty_rd_side|empty_wr_side
      .hssi_10g_rx_pcs_fast_path     (hssi_10g_rx_pcs_fast_path     ), // fast_path_dis|fast_path_en
      .hssi_10g_rx_pcs_fec_clken     (hssi_10g_rx_pcs_fec_clken     ), // fec_clk_dis|fec_clk_en
      .hssi_10g_rx_pcs_fec_enable    (hssi_10g_rx_pcs_fec_enable    ), // fec_en|fec_dis
      .hssi_10g_rx_pcs_fifo_double_read(hssi_10g_rx_pcs_fifo_double_read), // fifo_double_read_dis|fifo_double_read_en
      .hssi_10g_rx_pcs_fifo_stop_rd  (hssi_10g_rx_pcs_fifo_stop_rd  ), // rd_empty|n_rd_empty
      .hssi_10g_rx_pcs_fifo_stop_wr  (hssi_10g_rx_pcs_fifo_stop_wr  ), // wr_full|n_wr_full
      .hssi_10g_rx_pcs_force_align   (hssi_10g_rx_pcs_force_align   ), // force_align_dis|force_align_en
      .hssi_10g_rx_pcs_frmsync_bypass(hssi_10g_rx_pcs_frmsync_bypass), // frmsync_bypass_dis|frmsync_bypass_en
      .hssi_10g_rx_pcs_frmsync_clken (hssi_10g_rx_pcs_frmsync_clken ), // frmsync_clk_dis|frmsync_clk_en
      .hssi_10g_rx_pcs_frmsync_enum_scrm(hssi_10g_rx_pcs_frmsync_enum_scrm), // enum_scrm_default
      .hssi_10g_rx_pcs_frmsync_enum_sync(hssi_10g_rx_pcs_frmsync_enum_sync), // enum_sync_default
      .hssi_10g_rx_pcs_frmsync_flag_type(hssi_10g_rx_pcs_frmsync_flag_type), // all_framing_words|location_only
      .hssi_10g_rx_pcs_frmsync_knum_sync(hssi_10g_rx_pcs_frmsync_knum_sync), // knum_sync_default
      .hssi_10g_rx_pcs_frmsync_mfrm_length(hssi_10g_rx_pcs_frmsync_mfrm_length),
      .hssi_10g_rx_pcs_frmsync_pipeln(hssi_10g_rx_pcs_frmsync_pipeln), // frmsync_pipeln_dis|frmsync_pipeln_en
      .hssi_10g_rx_pcs_full_flag_type(hssi_10g_rx_pcs_full_flag_type), // full_rd_side|full_wr_side
      .hssi_10g_rx_pcs_gb_rx_idwidth (hssi_10g_rx_pcs_gb_rx_idwidth ), // width_40|width_32|width_64
      .hssi_10g_rx_pcs_gb_rx_odwidth (hssi_10g_rx_pcs_gb_rx_odwidth ), // width_32|width_40|width_50|width_67|width_64|width_66
      .hssi_10g_rx_pcs_gbexp_clken   (hssi_10g_rx_pcs_gbexp_clken   ), // gbexp_clk_dis|gbexp_clk_en
      .hssi_10g_rx_pcs_low_latency_en(hssi_10g_rx_pcs_low_latency_en), // disable|enable
      .hssi_10g_rx_pcs_lpbk_mode     (hssi_10g_rx_pcs_lpbk_mode     ), // lpbk_dis|lpbk_en
      .hssi_10g_rx_pcs_master_clk_sel(hssi_10g_rx_pcs_master_clk_sel), // master_rx_pma_clk|master_tx_pma_clk|master_refclk_dig
      .hssi_10g_rx_pcs_pempty_flag_type(hssi_10g_rx_pcs_pempty_flag_type), // pempty_rd_side|pempty_wr_side
      .hssi_10g_rx_pcs_pfull_flag_type(hssi_10g_rx_pcs_pfull_flag_type), // pfull_rd_side|pfull_wr_side
      .hssi_10g_rx_pcs_phcomp_rd_del (hssi_10g_rx_pcs_phcomp_rd_del ), // phcomp_rd_del4|phcomp_rd_del3|phcomp_rd_del2
      .hssi_10g_rx_pcs_pld_if_type   (hssi_10g_rx_pcs_pld_if_type   ), // fifo|reg
      .hssi_10g_rx_pcs_prot_mode     (hssi_10g_rx_pcs_prot_mode     ), // disable_mode|teng_baser_mode|interlaken_mode|sfis_mode|teng_sdi_mode|basic_mode|test_prp_mode|test_prp_krfec_mode|teng_1588_mode|teng_baser_krfec_mode|teng_1588_krfec_mode|basic_krfec_mode
      .hssi_10g_rx_pcs_rand_clken    (hssi_10g_rx_pcs_rand_clken    ), // rand_clk_dis|rand_clk_en
      .hssi_10g_rx_pcs_rd_clk_sel    (hssi_10g_rx_pcs_rd_clk_sel    ), // rd_rx_pld_clk|rd_rx_pma_clk|rd_refclk_dig
      .hssi_10g_rx_pcs_rdfifo_clken  (hssi_10g_rx_pcs_rdfifo_clken  ), // rdfifo_clk_dis|rdfifo_clk_en
      .hssi_10g_rx_pcs_reconfig_settings(hssi_10g_rx_pcs_reconfig_settings), //
      .hssi_10g_rx_pcs_rx_fifo_write_ctrl(hssi_10g_rx_pcs_rx_fifo_write_ctrl), // blklock_stops|blklock_ignore
      .hssi_10g_rx_pcs_rx_scrm_width (hssi_10g_rx_pcs_rx_scrm_width ), // bit64|bit66|bit67
      .hssi_10g_rx_pcs_rx_sh_location(hssi_10g_rx_pcs_rx_sh_location), // lsb|msb
      .hssi_10g_rx_pcs_rx_signal_ok_sel(hssi_10g_rx_pcs_rx_signal_ok_sel), // synchronized_ver|nonsync_ver
      .hssi_10g_rx_pcs_rx_sm_bypass  (hssi_10g_rx_pcs_rx_sm_bypass  ), // rx_sm_bypass_dis|rx_sm_bypass_en
      .hssi_10g_rx_pcs_rx_sm_hiber   (hssi_10g_rx_pcs_rx_sm_hiber   ), // rx_sm_hiber_en|rx_sm_hiber_dis
      .hssi_10g_rx_pcs_rx_sm_pipeln  (hssi_10g_rx_pcs_rx_sm_pipeln  ), // rx_sm_pipeln_dis|rx_sm_pipeln_en
      .hssi_10g_rx_pcs_rx_testbus_sel(hssi_10g_rx_pcs_rx_testbus_sel), // crc32_chk_testbus1|crc32_chk_testbus2|frame_sync_testbus1|frame_sync_testbus2|dec64b66b_testbus|rxsm_testbus|ber_testbus|blksync_testbus1|blksync_testbus2|gearbox_exp_testbus|random_ver_testbus|descramble_testbus|blank_testbus|rx_fifo_testbus1|rx_fifo_testbus2
      .hssi_10g_rx_pcs_rx_true_b2b   (hssi_10g_rx_pcs_rx_true_b2b   ), // single|b2b
      .hssi_10g_rx_pcs_rxfifo_empty  (hssi_10g_rx_pcs_rxfifo_empty  ), // empty_default
      .hssi_10g_rx_pcs_rxfifo_full   (hssi_10g_rx_pcs_rxfifo_full   ), // full_default
      .hssi_10g_rx_pcs_rxfifo_mode   (hssi_10g_rx_pcs_rxfifo_mode   ), // register_mode|clk_comp_10g|generic_interlaken|generic_basic|phase_comp|phase_comp_dv
      .hssi_10g_rx_pcs_rxfifo_pempty (hssi_10g_rx_pcs_rxfifo_pempty ),
      .hssi_10g_rx_pcs_rxfifo_pfull  (hssi_10g_rx_pcs_rxfifo_pfull  ),
      .hssi_10g_rx_pcs_stretch_num_stages(hssi_10g_rx_pcs_stretch_num_stages), // zero_stage|one_stage|two_stage|three_stage
      .hssi_10g_rx_pcs_sup_mode      (hssi_10g_rx_pcs_sup_mode      ), // user_mode|engineering_mode
      .hssi_10g_rx_pcs_test_mode     (hssi_10g_rx_pcs_test_mode     ), // test_off|pseudo_random
      .hssi_10g_rx_pcs_wrfifo_clken  (hssi_10g_rx_pcs_wrfifo_clken  ), // wrfifo_clk_dis|wrfifo_clk_en
      // parameters for twentynm_hssi_10g_tx_pcs
      .hssi_10g_tx_pcs_advanced_user_mode(hssi_10g_tx_pcs_advanced_user_mode), // disable|enable
      .hssi_10g_tx_pcs_bitslip_en    (hssi_10g_tx_pcs_bitslip_en    ), // bitslip_dis|bitslip_en
      .hssi_10g_tx_pcs_bonding_dft_en(hssi_10g_tx_pcs_bonding_dft_en), // dft_dis|dft_en
      .hssi_10g_tx_pcs_bonding_dft_val(hssi_10g_tx_pcs_bonding_dft_val), // dft_0|dft_1
      .hssi_10g_tx_pcs_comp_cnt      (hssi_10g_tx_pcs_comp_cnt      ),
      .hssi_10g_tx_pcs_compin_sel    (hssi_10g_tx_pcs_compin_sel    ), // compin_master|compin_slave_top|compin_slave_bot|compin_default
      .hssi_10g_tx_pcs_crcgen_bypass (hssi_10g_tx_pcs_crcgen_bypass ), // crcgen_bypass_dis|crcgen_bypass_en
      .hssi_10g_tx_pcs_crcgen_clken  (hssi_10g_tx_pcs_crcgen_clken  ), // crcgen_clk_dis|crcgen_clk_en
      .hssi_10g_tx_pcs_crcgen_err    (hssi_10g_tx_pcs_crcgen_err    ), // crcgen_err_dis|crcgen_err_en
      .hssi_10g_tx_pcs_crcgen_inv    (hssi_10g_tx_pcs_crcgen_inv    ), // crcgen_inv_dis|crcgen_inv_en
      .hssi_10g_tx_pcs_ctrl_bit_reverse(hssi_10g_tx_pcs_ctrl_bit_reverse), // ctrl_bit_reverse_dis|ctrl_bit_reverse_en
      .hssi_10g_tx_pcs_ctrl_plane_bonding(hssi_10g_tx_pcs_ctrl_plane_bonding), // individual|ctrl_master|ctrl_slave_abv|ctrl_slave_blw
      .hssi_10g_tx_pcs_data_bit_reverse(hssi_10g_tx_pcs_data_bit_reverse), // data_bit_reverse_dis|data_bit_reverse_en
      .hssi_10g_tx_pcs_dft_clk_out_sel(hssi_10g_tx_pcs_dft_clk_out_sel), // tx_master_clk|tx_rdfifo_clk|tx_frmgen_clk|tx_crcgen_clk|tx_64b66benc_txsm_clk|tx_scrm_clk|tx_dispgen_clk|tx_gbred_clk|tx_wrfifo_clk|tx_fec_clk
      .hssi_10g_tx_pcs_dispgen_bypass(hssi_10g_tx_pcs_dispgen_bypass), // dispgen_bypass_dis|dispgen_bypass_en
      .hssi_10g_tx_pcs_dispgen_clken (hssi_10g_tx_pcs_dispgen_clken ), // dispgen_clk_dis|dispgen_clk_en
      .hssi_10g_tx_pcs_dispgen_err   (hssi_10g_tx_pcs_dispgen_err   ), // dispgen_err_dis|dispgen_err_en
      .hssi_10g_tx_pcs_dispgen_pipeln(hssi_10g_tx_pcs_dispgen_pipeln), // dispgen_pipeln_dis|dispgen_pipeln_en
      .hssi_10g_tx_pcs_distdwn_bypass_pipeln(hssi_10g_tx_pcs_distdwn_bypass_pipeln), // distdwn_bypass_pipeln_dis|distdwn_bypass_pipeln_en
      .hssi_10g_tx_pcs_distdwn_master(hssi_10g_tx_pcs_distdwn_master), // distdwn_master_en|distdwn_master_dis
      .hssi_10g_tx_pcs_distup_bypass_pipeln(hssi_10g_tx_pcs_distup_bypass_pipeln), // distup_bypass_pipeln_dis|distup_bypass_pipeln_en
      .hssi_10g_tx_pcs_distup_master (hssi_10g_tx_pcs_distup_master ), // distup_master_en|distup_master_dis
      .hssi_10g_tx_pcs_dv_bond       (hssi_10g_tx_pcs_dv_bond       ), // dv_bond_en|dv_bond_dis
      .hssi_10g_tx_pcs_empty_flag_type(hssi_10g_tx_pcs_empty_flag_type), // empty_rd_side|empty_wr_side
      .hssi_10g_tx_pcs_enc64b66b_txsm_clken(hssi_10g_tx_pcs_enc64b66b_txsm_clken), // enc64b66b_txsm_clk_dis|enc64b66b_txsm_clk_en
      .hssi_10g_tx_pcs_enc_64b66b_txsm_bypass(hssi_10g_tx_pcs_enc_64b66b_txsm_bypass), // enc_64b66b_txsm_bypass_dis|enc_64b66b_txsm_bypass_en
      .hssi_10g_tx_pcs_fastpath      (hssi_10g_tx_pcs_fastpath      ), // fastpath_dis|fastpath_en
      .hssi_10g_tx_pcs_fec_clken     (hssi_10g_tx_pcs_fec_clken     ), // fec_clk_dis|fec_clk_en
      .hssi_10g_tx_pcs_fec_enable    (hssi_10g_tx_pcs_fec_enable    ), // fec_en|fec_dis
      .hssi_10g_tx_pcs_fifo_double_write(hssi_10g_tx_pcs_fifo_double_write), // fifo_double_write_dis|fifo_double_write_en
      .hssi_10g_tx_pcs_fifo_reg_fast (hssi_10g_tx_pcs_fifo_reg_fast ), // fifo_reg_fast_dis|fifo_reg_fast_en
      .hssi_10g_tx_pcs_fifo_stop_rd  (hssi_10g_tx_pcs_fifo_stop_rd  ), // rd_empty|n_rd_empty
      .hssi_10g_tx_pcs_fifo_stop_wr  (hssi_10g_tx_pcs_fifo_stop_wr  ), // wr_full|n_wr_full
      .hssi_10g_tx_pcs_frmgen_burst  (hssi_10g_tx_pcs_frmgen_burst  ), // frmgen_burst_dis|frmgen_burst_en
      .hssi_10g_tx_pcs_frmgen_bypass (hssi_10g_tx_pcs_frmgen_bypass ), // frmgen_bypass_dis|frmgen_bypass_en
      .hssi_10g_tx_pcs_frmgen_clken  (hssi_10g_tx_pcs_frmgen_clken  ), // frmgen_clk_dis|frmgen_clk_en
      .hssi_10g_tx_pcs_frmgen_mfrm_length(hssi_10g_tx_pcs_frmgen_mfrm_length),
      .hssi_10g_tx_pcs_frmgen_pipeln (hssi_10g_tx_pcs_frmgen_pipeln ), // frmgen_pipeln_dis|frmgen_pipeln_en
      .hssi_10g_tx_pcs_frmgen_pyld_ins(hssi_10g_tx_pcs_frmgen_pyld_ins), // frmgen_pyld_ins_dis|frmgen_pyld_ins_en
      .hssi_10g_tx_pcs_frmgen_wordslip(hssi_10g_tx_pcs_frmgen_wordslip), // frmgen_wordslip_dis|frmgen_wordslip_en
      .hssi_10g_tx_pcs_full_flag_type(hssi_10g_tx_pcs_full_flag_type), // full_rd_side|full_wr_side
      .hssi_10g_tx_pcs_gb_pipeln_bypass(hssi_10g_tx_pcs_gb_pipeln_bypass), // disable|enable
      .hssi_10g_tx_pcs_gb_tx_idwidth (hssi_10g_tx_pcs_gb_tx_idwidth ), // width_32|width_40|width_50|width_67|width_64|width_66
      .hssi_10g_tx_pcs_gb_tx_odwidth (hssi_10g_tx_pcs_gb_tx_odwidth ), // width_32|width_40|width_64
      .hssi_10g_tx_pcs_gbred_clken   (hssi_10g_tx_pcs_gbred_clken   ), // gbred_clk_dis|gbred_clk_en
      .hssi_10g_tx_pcs_indv          (hssi_10g_tx_pcs_indv          ), // indv_en|indv_dis
      .hssi_10g_tx_pcs_low_latency_en(hssi_10g_tx_pcs_low_latency_en), // disable|enable
      .hssi_10g_tx_pcs_master_clk_sel(hssi_10g_tx_pcs_master_clk_sel), // master_tx_pma_clk|master_refclk_dig
      .hssi_10g_tx_pcs_pempty_flag_type(hssi_10g_tx_pcs_pempty_flag_type), // pempty_rd_side|pempty_wr_side
      .hssi_10g_tx_pcs_pfull_flag_type(hssi_10g_tx_pcs_pfull_flag_type), // pfull_rd_side|pfull_wr_side
      .hssi_10g_tx_pcs_phcomp_rd_del (hssi_10g_tx_pcs_phcomp_rd_del ), // phcomp_rd_del6|phcomp_rd_del5|phcomp_rd_del4|phcomp_rd_del3|phcomp_rd_del2
      .hssi_10g_tx_pcs_pld_if_type   (hssi_10g_tx_pcs_pld_if_type   ), // fifo|reg|fastreg
      .hssi_10g_tx_pcs_prot_mode     (hssi_10g_tx_pcs_prot_mode     ), // disable_mode|teng_baser_mode|interlaken_mode|sfis_mode|teng_sdi_mode|basic_mode|test_prp_mode|test_prp_krfec_mode|teng_1588_mode|teng_baser_krfec_mode|teng_1588_krfec_mode|basic_krfec_mode
      .hssi_10g_tx_pcs_pseudo_random (hssi_10g_tx_pcs_pseudo_random ), // two_lf|all_0
      .hssi_10g_tx_pcs_pseudo_seed_a (hssi_10g_tx_pcs_pseudo_seed_a ),
      .hssi_10g_tx_pcs_pseudo_seed_b (hssi_10g_tx_pcs_pseudo_seed_b ),
      .hssi_10g_tx_pcs_random_disp   (hssi_10g_tx_pcs_random_disp   ), // disable|enable
      .hssi_10g_tx_pcs_rdfifo_clken  (hssi_10g_tx_pcs_rdfifo_clken  ), // rdfifo_clk_dis|rdfifo_clk_en
      .hssi_10g_tx_pcs_reconfig_settings(hssi_10g_tx_pcs_reconfig_settings), //
      .hssi_10g_tx_pcs_scrm_bypass   (hssi_10g_tx_pcs_scrm_bypass   ), // scrm_bypass_dis|scrm_bypass_en
      .hssi_10g_tx_pcs_scrm_clken    (hssi_10g_tx_pcs_scrm_clken    ), // scrm_clk_dis|scrm_clk_en
      .hssi_10g_tx_pcs_scrm_mode     (hssi_10g_tx_pcs_scrm_mode     ), // async|sync
      .hssi_10g_tx_pcs_scrm_pipeln   (hssi_10g_tx_pcs_scrm_pipeln   ), // disable|enable
      .hssi_10g_tx_pcs_sh_err        (hssi_10g_tx_pcs_sh_err        ), // sh_err_dis|sh_err_en
      .hssi_10g_tx_pcs_sop_mark      (hssi_10g_tx_pcs_sop_mark      ), // sop_mark_en|sop_mark_dis
      .hssi_10g_tx_pcs_stretch_num_stages(hssi_10g_tx_pcs_stretch_num_stages), // zero_stage|one_stage|two_stage|three_stage
      .hssi_10g_tx_pcs_sup_mode      (hssi_10g_tx_pcs_sup_mode      ), // user_mode|engineering_mode
      .hssi_10g_tx_pcs_test_mode     (hssi_10g_tx_pcs_test_mode     ), // test_off|pseudo_random
      .hssi_10g_tx_pcs_tx_scrm_err   (hssi_10g_tx_pcs_tx_scrm_err   ), // scrm_err_dis|scrm_err_en
      .hssi_10g_tx_pcs_tx_scrm_width (hssi_10g_tx_pcs_tx_scrm_width ), // bit64|bit66|bit67
      .hssi_10g_tx_pcs_tx_sh_location(hssi_10g_tx_pcs_tx_sh_location), // lsb|msb
      .hssi_10g_tx_pcs_tx_sm_bypass  (hssi_10g_tx_pcs_tx_sm_bypass  ), // tx_sm_bypass_dis|tx_sm_bypass_en
      .hssi_10g_tx_pcs_tx_sm_pipeln  (hssi_10g_tx_pcs_tx_sm_pipeln  ), // tx_sm_pipeln_dis|tx_sm_pipeln_en
      .hssi_10g_tx_pcs_tx_testbus_sel(hssi_10g_tx_pcs_tx_testbus_sel), // crc32_gen_testbus1|crc32_gen_testbus2|disp_gen_testbus1|disp_gen_testbus2|frame_gen_testbus1|frame_gen_testbus2|enc64b66b_testbus|txsm_testbus|tx_cp_bond_testbus|gearbox_red_testbus|scramble_testbus|blank_testbus|tx_fifo_testbus1|tx_fifo_testbus2
      .hssi_10g_tx_pcs_txfifo_empty  (hssi_10g_tx_pcs_txfifo_empty  ), // empty_default
      .hssi_10g_tx_pcs_txfifo_full   (hssi_10g_tx_pcs_txfifo_full   ), // full_default
      .hssi_10g_tx_pcs_txfifo_mode   (hssi_10g_tx_pcs_txfifo_mode   ), // register_mode|interlaken_generic|basic_generic|phase_comp
      .hssi_10g_tx_pcs_txfifo_pempty (hssi_10g_tx_pcs_txfifo_pempty ),
      .hssi_10g_tx_pcs_txfifo_pfull  (hssi_10g_tx_pcs_txfifo_pfull  ),
      .hssi_10g_tx_pcs_wr_clk_sel    (hssi_10g_tx_pcs_wr_clk_sel    ), // wr_tx_pld_clk|wr_tx_pma_clk|wr_refclk_dig
      .hssi_10g_tx_pcs_wrfifo_clken  (hssi_10g_tx_pcs_wrfifo_clken  ), // wrfifo_clk_dis|wrfifo_clk_en
      // parameters for twentynm_hssi_8g_rx_pcs
      .hssi_8g_rx_pcs_auto_error_replacement(hssi_8g_rx_pcs_auto_error_replacement), // dis_err_replace|en_err_replace
      .hssi_8g_rx_pcs_auto_speed_nego(hssi_8g_rx_pcs_auto_speed_nego), // dis_asn|en_asn_g2_freq_scal
      .hssi_8g_rx_pcs_bit_reversal   (hssi_8g_rx_pcs_bit_reversal   ), // dis_bit_reversal|en_bit_reversal
      .hssi_8g_rx_pcs_bonding_dft_en (hssi_8g_rx_pcs_bonding_dft_en ), // dft_dis|dft_en
      .hssi_8g_rx_pcs_bonding_dft_val(hssi_8g_rx_pcs_bonding_dft_val), // dft_0|dft_1
      .hssi_8g_rx_pcs_bypass_pipeline_reg(hssi_8g_rx_pcs_bypass_pipeline_reg), // dis_bypass_pipeline|en_bypass_pipeline
      .hssi_8g_rx_pcs_byte_deserializer(hssi_8g_rx_pcs_byte_deserializer), // dis_bds|en_bds_by_2|en_bds_by_4|en_bds_by_2_det
      .hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask(hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask), // dis_rxvalid_mask|en_rxvalid_mask
      .hssi_8g_rx_pcs_clkcmp_pattern_n(hssi_8g_rx_pcs_clkcmp_pattern_n),
      .hssi_8g_rx_pcs_clkcmp_pattern_p(hssi_8g_rx_pcs_clkcmp_pattern_p),
      .hssi_8g_rx_pcs_clock_gate_bds_dec_asn(hssi_8g_rx_pcs_clock_gate_bds_dec_asn), // dis_bds_dec_asn_clk_gating|en_bds_dec_asn_clk_gating
      .hssi_8g_rx_pcs_clock_gate_cdr_eidle(hssi_8g_rx_pcs_clock_gate_cdr_eidle), // dis_cdr_eidle_clk_gating|en_cdr_eidle_clk_gating
      .hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk(hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk), // dis_dw_pc_wrclk_gating|en_dw_pc_wrclk_gating
      .hssi_8g_rx_pcs_clock_gate_dw_rm_rd(hssi_8g_rx_pcs_clock_gate_dw_rm_rd), // dis_dw_rm_rdclk_gating|en_dw_rm_rdclk_gating
      .hssi_8g_rx_pcs_clock_gate_dw_rm_wr(hssi_8g_rx_pcs_clock_gate_dw_rm_wr), // dis_dw_rm_wrclk_gating|en_dw_rm_wrclk_gating
      .hssi_8g_rx_pcs_clock_gate_dw_wa(hssi_8g_rx_pcs_clock_gate_dw_wa), // dis_dw_wa_clk_gating|en_dw_wa_clk_gating
      .hssi_8g_rx_pcs_clock_gate_pc_rdclk(hssi_8g_rx_pcs_clock_gate_pc_rdclk), // dis_pc_rdclk_gating|en_pc_rdclk_gating
      .hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk(hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk), // dis_sw_pc_wrclk_gating|en_sw_pc_wrclk_gating
      .hssi_8g_rx_pcs_clock_gate_sw_rm_rd(hssi_8g_rx_pcs_clock_gate_sw_rm_rd), // dis_sw_rm_rdclk_gating|en_sw_rm_rdclk_gating
      .hssi_8g_rx_pcs_clock_gate_sw_rm_wr(hssi_8g_rx_pcs_clock_gate_sw_rm_wr), // dis_sw_rm_wrclk_gating|en_sw_rm_wrclk_gating
      .hssi_8g_rx_pcs_clock_gate_sw_wa(hssi_8g_rx_pcs_clock_gate_sw_wa), // dis_sw_wa_clk_gating|en_sw_wa_clk_gating
      .hssi_8g_rx_pcs_clock_observation_in_pld_core(hssi_8g_rx_pcs_clock_observation_in_pld_core), // internal_sw_wa_clk|internal_dw_wa_clk|internal_cdr_eidle_clk|internal_sm_rm_wr_clk|internal_dw_rm_wr_clk|internal_clk_2_b|internal_sw_rm_rd_clk|internal_dw_rm_rd_clk|internal_sw_rx_wr_clk|internal_dw_rx_wr_clk|internal_rx_rd_clk|internal_rx_pma_clk_gen3|internal_rx_rcvd_clk_gen3
      .hssi_8g_rx_pcs_ctrl_plane_bonding_compensation(hssi_8g_rx_pcs_ctrl_plane_bonding_compensation), // dis_compensation|en_compensation
      .hssi_8g_rx_pcs_ctrl_plane_bonding_consumption(hssi_8g_rx_pcs_ctrl_plane_bonding_consumption), // individual|bundled_master|bundled_slave_below|bundled_slave_above
      .hssi_8g_rx_pcs_ctrl_plane_bonding_distribution(hssi_8g_rx_pcs_ctrl_plane_bonding_distribution), // not_master_chnl_distr|master_chnl_distr
      .hssi_8g_rx_pcs_eidle_entry_eios(hssi_8g_rx_pcs_eidle_entry_eios), // dis_eidle_eios|en_eidle_eios
      .hssi_8g_rx_pcs_eidle_entry_iei(hssi_8g_rx_pcs_eidle_entry_iei), // dis_eidle_iei|en_eidle_iei
      .hssi_8g_rx_pcs_eidle_entry_sd (hssi_8g_rx_pcs_eidle_entry_sd ), // dis_eidle_sd|en_eidle_sd
      .hssi_8g_rx_pcs_eightb_tenb_decoder(hssi_8g_rx_pcs_eightb_tenb_decoder), // dis_8b10b|en_8b10b_ibm|en_8b10b_sgx
      .hssi_8g_rx_pcs_err_flags_sel  (hssi_8g_rx_pcs_err_flags_sel  ), // err_flags_wa|err_flags_8b10b
      .hssi_8g_rx_pcs_fixed_pat_det  (hssi_8g_rx_pcs_fixed_pat_det  ), // dis_fixed_patdet|en_fixed_patdet
      .hssi_8g_rx_pcs_fixed_pat_num  (hssi_8g_rx_pcs_fixed_pat_num  ),
      .hssi_8g_rx_pcs_force_signal_detect(hssi_8g_rx_pcs_force_signal_detect), // en_force_signal_detect|dis_force_signal_detect
      .hssi_8g_rx_pcs_gen3_clk_en    (hssi_8g_rx_pcs_gen3_clk_en    ), // disable_clk|enable_clk
      .hssi_8g_rx_pcs_gen3_rx_clk_sel(hssi_8g_rx_pcs_gen3_rx_clk_sel), // en_dig_clk1_8g|rcvd_clk
      .hssi_8g_rx_pcs_gen3_tx_clk_sel(hssi_8g_rx_pcs_gen3_tx_clk_sel), // en_dig_clk2_8g|tx_pma_clk
      .hssi_8g_rx_pcs_hip_mode       (hssi_8g_rx_pcs_hip_mode       ), // dis_hip|en_hip
      .hssi_8g_rx_pcs_ibm_invalid_code(hssi_8g_rx_pcs_ibm_invalid_code), // dis_ibm_invalid_code|en_ibm_invalid_code
      .hssi_8g_rx_pcs_invalid_code_flag_only(hssi_8g_rx_pcs_invalid_code_flag_only), // dis_invalid_code_only|en_invalid_code_only
      .hssi_8g_rx_pcs_pad_or_edb_error_replace(hssi_8g_rx_pcs_pad_or_edb_error_replace), // replace_edb|replace_edb_dynamic|replace_pad
      .hssi_8g_rx_pcs_pcs_bypass     (hssi_8g_rx_pcs_pcs_bypass     ), // dis_pcs_bypass|en_pcs_bypass
      .hssi_8g_rx_pcs_phase_comp_rdptr(hssi_8g_rx_pcs_phase_comp_rdptr), // disable_rdptr|enable_rdptr
      .hssi_8g_rx_pcs_phase_compensation_fifo(hssi_8g_rx_pcs_phase_compensation_fifo), // low_latency|normal_latency|register_fifo|pld_ctrl_low_latency|pld_ctrl_normal_latency
      .hssi_8g_rx_pcs_pipe_if_enable (hssi_8g_rx_pcs_pipe_if_enable ), // dis_pipe_rx|en_pipe_rx|en_pipe3_rx
      .hssi_8g_rx_pcs_pma_dw         (hssi_8g_rx_pcs_pma_dw         ), // eight_bit|ten_bit|sixteen_bit|twenty_bit
      .hssi_8g_rx_pcs_polinv_8b10b_dec(hssi_8g_rx_pcs_polinv_8b10b_dec), // dis_polinv_8b10b_dec|en_polinv_8b10b_dec
      .hssi_8g_rx_pcs_prot_mode      (hssi_8g_rx_pcs_prot_mode      ), // pipe_g1|pipe_g2|pipe_g3|cpri|cpri_rx_tx|gige|gige_1588|basic_rm_enable|basic_rm_disable|disabled_prot_mode
      .hssi_8g_rx_pcs_rate_match     (hssi_8g_rx_pcs_rate_match     ), // dis_rm|gige_rm|pipe_rm|pipe_rm_0ppm|sw_basic_rm|dw_basic_rm
      .hssi_8g_rx_pcs_rate_match_del_thres(hssi_8g_rx_pcs_rate_match_del_thres), // dis_rm_del_thres|gige_rm_del_thres|pipe_rm_del_thres|pipe_rm_0ppm_del_thres|sw_basic_rm_del_thres|dw_basic_rm_del_thres
      .hssi_8g_rx_pcs_rate_match_empty_thres(hssi_8g_rx_pcs_rate_match_empty_thres), // dis_rm_empty_thres|gige_rm_empty_thres|pipe_rm_empty_thres|pipe_rm_0ppm_empty_thres|sw_basic_rm_empty_thres|dw_basic_rm_empty_thres
      .hssi_8g_rx_pcs_rate_match_full_thres(hssi_8g_rx_pcs_rate_match_full_thres), // dis_rm_full_thres|gige_rm_full_thres|pipe_rm_full_thres|pipe_rm_0ppm_full_thres|sw_basic_rm_full_thres|dw_basic_rm_full_thres
      .hssi_8g_rx_pcs_rate_match_ins_thres(hssi_8g_rx_pcs_rate_match_ins_thres), // dis_rm_ins_thres|gige_rm_ins_thres|pipe_rm_ins_thres|pipe_rm_0ppm_ins_thres|sw_basic_rm_ins_thres|dw_basic_rm_ins_thres
      .hssi_8g_rx_pcs_rate_match_start_thres(hssi_8g_rx_pcs_rate_match_start_thres), // dis_rm_start_thres|gige_rm_start_thres|pipe_rm_start_thres|pipe_rm_0ppm_start_thres|sw_basic_rm_start_thres|dw_basic_rm_start_thres
      .hssi_8g_rx_pcs_reconfig_settings(hssi_8g_rx_pcs_reconfig_settings), //
      .hssi_8g_rx_pcs_rx_clk2        (hssi_8g_rx_pcs_rx_clk2        ), // rcvd_clk_clk2|tx_pma_clock_clk2|refclk_dig2_clk2
      .hssi_8g_rx_pcs_rx_clk_free_running(hssi_8g_rx_pcs_rx_clk_free_running), // dis_rx_clk_free_run|en_rx_clk_free_run
      .hssi_8g_rx_pcs_rx_pcs_urst    (hssi_8g_rx_pcs_rx_pcs_urst    ), // dis_rx_pcs_urst|en_rx_pcs_urst
      .hssi_8g_rx_pcs_rx_rcvd_clk    (hssi_8g_rx_pcs_rx_rcvd_clk    ), // rcvd_clk_rcvd_clk|tx_pma_clock_rcvd_clk
      .hssi_8g_rx_pcs_rx_rd_clk      (hssi_8g_rx_pcs_rx_rd_clk      ), // pld_rx_clk|rx_clk
      .hssi_8g_rx_pcs_rx_refclk      (hssi_8g_rx_pcs_rx_refclk      ), // dis_refclk_sel|en_refclk_sel
      .hssi_8g_rx_pcs_rx_wr_clk      (hssi_8g_rx_pcs_rx_wr_clk      ), // rx_clk2_div_1_2_4|txfifo_rd_clk
      .hssi_8g_rx_pcs_sup_mode       (hssi_8g_rx_pcs_sup_mode       ), // user_mode|engineering_mode
      .hssi_8g_rx_pcs_symbol_swap    (hssi_8g_rx_pcs_symbol_swap    ), // dis_symbol_swap|en_symbol_swap
      .hssi_8g_rx_pcs_sync_sm_idle_eios(hssi_8g_rx_pcs_sync_sm_idle_eios), // dis_syncsm_idle|en_syncsm_idle
      .hssi_8g_rx_pcs_test_bus_sel   (hssi_8g_rx_pcs_test_bus_sel   ), // tx_testbus|tx_ctrl_plane_testbus|wa_testbus|rm_testbus|rx_ctrl_testbus|pcie_ctrl_testbus|rx_ctrl_plane_testbus
      .hssi_8g_rx_pcs_tx_rx_parallel_loopback(hssi_8g_rx_pcs_tx_rx_parallel_loopback), // dis_plpbk|en_plpbk
      .hssi_8g_rx_pcs_wa_boundary_lock_ctrl(hssi_8g_rx_pcs_wa_boundary_lock_ctrl), // bit_slip|sync_sm|deterministic_latency|auto_align_pld_ctrl
      .hssi_8g_rx_pcs_wa_clk_slip_spacing(hssi_8g_rx_pcs_wa_clk_slip_spacing),
      .hssi_8g_rx_pcs_wa_det_latency_sync_status_beh(hssi_8g_rx_pcs_wa_det_latency_sync_status_beh), // assert_sync_status_imm|assert_sync_status_non_imm|dont_care_assert_sync
      .hssi_8g_rx_pcs_wa_disp_err_flag(hssi_8g_rx_pcs_wa_disp_err_flag), // dis_disp_err_flag|en_disp_err_flag
      .hssi_8g_rx_pcs_wa_kchar       (hssi_8g_rx_pcs_wa_kchar       ), // dis_kchar|en_kchar
      .hssi_8g_rx_pcs_wa_pd          (hssi_8g_rx_pcs_wa_pd          ), // wa_pd_7|wa_pd_10|wa_pd_20|wa_pd_40|wa_pd_8_sw|wa_pd_8_dw|wa_pd_16_sw|wa_pd_16_dw|wa_pd_32
      .hssi_8g_rx_pcs_wa_pd_data     (hssi_8g_rx_pcs_wa_pd_data     ),
      .hssi_8g_rx_pcs_wa_pd_polarity (hssi_8g_rx_pcs_wa_pd_polarity ), // dis_pd_both_pol|en_pd_both_pol|dont_care_both_pol
      .hssi_8g_rx_pcs_wa_pld_controlled(hssi_8g_rx_pcs_wa_pld_controlled), // dis_pld_ctrl|pld_ctrl_sw|rising_edge_sensitive_dw|level_sensitive_dw
      .hssi_8g_rx_pcs_wa_renumber_data(hssi_8g_rx_pcs_wa_renumber_data),
      .hssi_8g_rx_pcs_wa_rgnumber_data(hssi_8g_rx_pcs_wa_rgnumber_data),
      .hssi_8g_rx_pcs_wa_rknumber_data(hssi_8g_rx_pcs_wa_rknumber_data),
      .hssi_8g_rx_pcs_wa_rosnumber_data(hssi_8g_rx_pcs_wa_rosnumber_data),
      .hssi_8g_rx_pcs_wa_rvnumber_data(hssi_8g_rx_pcs_wa_rvnumber_data),
      .hssi_8g_rx_pcs_wa_sync_sm_ctrl(hssi_8g_rx_pcs_wa_sync_sm_ctrl), // gige_sync_sm|pipe_sync_sm|sw_basic_sync_sm|dw_basic_sync_sm|fibre_channel_sync_sm
      .hssi_8g_rx_pcs_wait_cnt       (hssi_8g_rx_pcs_wait_cnt       ),
      // parameters for twentynm_hssi_8g_tx_pcs
      .hssi_8g_tx_pcs_auto_speed_nego_gen2(hssi_8g_tx_pcs_auto_speed_nego_gen2), // dis_asn_g2|en_asn_g2_freq_scal
      .hssi_8g_tx_pcs_bit_reversal   (hssi_8g_tx_pcs_bit_reversal   ), // dis_bit_reversal|en_bit_reversal
      .hssi_8g_tx_pcs_bonding_dft_en (hssi_8g_tx_pcs_bonding_dft_en ), // dft_dis|dft_en
      .hssi_8g_tx_pcs_bonding_dft_val(hssi_8g_tx_pcs_bonding_dft_val), // dft_0|dft_1
      .hssi_8g_tx_pcs_bypass_pipeline_reg(hssi_8g_tx_pcs_bypass_pipeline_reg), // dis_bypass_pipeline|en_bypass_pipeline
      .hssi_8g_tx_pcs_byte_serializer(hssi_8g_tx_pcs_byte_serializer), // dis_bs|en_bs_by_2|en_bs_by_4
      .hssi_8g_tx_pcs_clock_gate_bs_enc(hssi_8g_tx_pcs_clock_gate_bs_enc), // dis_bs_enc_clk_gating|en_bs_enc_clk_gating
      .hssi_8g_tx_pcs_clock_gate_dw_fifowr(hssi_8g_tx_pcs_clock_gate_dw_fifowr), // dis_dw_fifowr_clk_gating|en_dw_fifowr_clk_gating
      .hssi_8g_tx_pcs_clock_gate_fiford(hssi_8g_tx_pcs_clock_gate_fiford), // dis_fiford_clk_gating|en_fiford_clk_gating
      .hssi_8g_tx_pcs_clock_gate_sw_fifowr(hssi_8g_tx_pcs_clock_gate_sw_fifowr), // dis_sw_fifowr_clk_gating|en_sw_fifowr_clk_gating
      .hssi_8g_tx_pcs_clock_observation_in_pld_core(hssi_8g_tx_pcs_clock_observation_in_pld_core), // internal_refclk_b|internal_fifo_rd_clk|internal_sw_fifo_wr_clk|internal_dw_fifo_wr_clk|internal_tx_clk_out_gen3|internal_pipe_tx_clk_out_gen3
      .hssi_8g_tx_pcs_ctrl_plane_bonding_compensation(hssi_8g_tx_pcs_ctrl_plane_bonding_compensation), // dis_compensation|en_compensation
      .hssi_8g_tx_pcs_ctrl_plane_bonding_consumption(hssi_8g_tx_pcs_ctrl_plane_bonding_consumption), // individual|bundled_master|bundled_slave_below|bundled_slave_above
      .hssi_8g_tx_pcs_ctrl_plane_bonding_distribution(hssi_8g_tx_pcs_ctrl_plane_bonding_distribution), // not_master_chnl_distr|master_chnl_distr
      .hssi_8g_tx_pcs_data_selection_8b10b_encoder_input(hssi_8g_tx_pcs_data_selection_8b10b_encoder_input), // normal_data_path|gige_idle_conversion
      .hssi_8g_tx_pcs_dynamic_clk_switch(hssi_8g_tx_pcs_dynamic_clk_switch), // dis_dyn_clk_switch|en_dyn_clk_switch
      .hssi_8g_tx_pcs_eightb_tenb_disp_ctrl(hssi_8g_tx_pcs_eightb_tenb_disp_ctrl), // dis_disp_ctrl|en_disp_ctrl|en_ib_disp_ctrl
      .hssi_8g_tx_pcs_eightb_tenb_encoder(hssi_8g_tx_pcs_eightb_tenb_encoder), // dis_8b10b|en_8b10b_ibm|en_8b10b_sgx
      .hssi_8g_tx_pcs_force_echar    (hssi_8g_tx_pcs_force_echar    ), // dis_force_echar|en_force_echar
      .hssi_8g_tx_pcs_force_kchar    (hssi_8g_tx_pcs_force_kchar    ), // dis_force_kchar|en_force_kchar
      .hssi_8g_tx_pcs_gen3_tx_clk_sel(hssi_8g_tx_pcs_gen3_tx_clk_sel), // dis_tx_clk|tx_pma_clk
      .hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel(hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel), // dis_tx_pipe_clk|func_clk
      .hssi_8g_tx_pcs_hip_mode       (hssi_8g_tx_pcs_hip_mode       ), // dis_hip|en_hip
      .hssi_8g_tx_pcs_pcs_bypass     (hssi_8g_tx_pcs_pcs_bypass     ), // dis_pcs_bypass|en_pcs_bypass
      .hssi_8g_tx_pcs_phase_comp_rdptr(hssi_8g_tx_pcs_phase_comp_rdptr), // disable_rdptr|enable_rdptr
      .hssi_8g_tx_pcs_phase_compensation_fifo(hssi_8g_tx_pcs_phase_compensation_fifo), // low_latency|normal_latency|register_fifo|pld_ctrl_low_latency|pld_ctrl_normal_latency
      .hssi_8g_tx_pcs_phfifo_write_clk_sel(hssi_8g_tx_pcs_phfifo_write_clk_sel), // pld_tx_clk|tx_clk
      .hssi_8g_tx_pcs_pma_dw         (hssi_8g_tx_pcs_pma_dw         ), // eight_bit|ten_bit|sixteen_bit|twenty_bit
      .hssi_8g_tx_pcs_prot_mode      (hssi_8g_tx_pcs_prot_mode      ), // pipe_g1|pipe_g2|pipe_g3|cpri|cpri_rx_tx|gige|gige_1588|basic|disabled_prot_mode
      .hssi_8g_tx_pcs_reconfig_settings(hssi_8g_tx_pcs_reconfig_settings), //
      .hssi_8g_tx_pcs_refclk_b_clk_sel(hssi_8g_tx_pcs_refclk_b_clk_sel), // tx_pma_clock|refclk_dig
      .hssi_8g_tx_pcs_revloop_back_rm(hssi_8g_tx_pcs_revloop_back_rm), // dis_rev_loopback_rx_rm|en_rev_loopback_rx_rm
      .hssi_8g_tx_pcs_sup_mode       (hssi_8g_tx_pcs_sup_mode       ), // user_mode|engineering_mode
      .hssi_8g_tx_pcs_symbol_swap    (hssi_8g_tx_pcs_symbol_swap    ), // dis_symbol_swap|en_symbol_swap
      .hssi_8g_tx_pcs_tx_bitslip     (hssi_8g_tx_pcs_tx_bitslip     ), // dis_tx_bitslip|en_tx_bitslip
      .hssi_8g_tx_pcs_tx_compliance_controlled_disparity(hssi_8g_tx_pcs_tx_compliance_controlled_disparity), // dis_txcompliance|en_txcompliance_pipe2p0|en_txcompliance_pipe3p0
      .hssi_8g_tx_pcs_tx_fast_pld_reg(hssi_8g_tx_pcs_tx_fast_pld_reg), // dis_tx_fast_pld_reg|en_tx_fast_pld_reg
      .hssi_8g_tx_pcs_txclk_freerun  (hssi_8g_tx_pcs_txclk_freerun  ), // dis_freerun_tx|en_freerun_tx
      .hssi_8g_tx_pcs_txpcs_urst     (hssi_8g_tx_pcs_txpcs_urst     ), // dis_txpcs_urst|en_txpcs_urst
      // parameters for twentynm_hssi_common_pcs_pma_interface
      .hssi_common_pcs_pma_interface_asn_clk_enable(hssi_common_pcs_pma_interface_asn_clk_enable), // false|true
      .hssi_common_pcs_pma_interface_asn_enable(hssi_common_pcs_pma_interface_asn_enable), // dis_asn|en_asn
      .hssi_common_pcs_pma_interface_block_sel(hssi_common_pcs_pma_interface_block_sel), // eight_g_pcs|pcie_gen3
      .hssi_common_pcs_pma_interface_bypass_early_eios(hssi_common_pcs_pma_interface_bypass_early_eios), // false|true
      .hssi_common_pcs_pma_interface_bypass_pcie_switch(hssi_common_pcs_pma_interface_bypass_pcie_switch), // false|true
      .hssi_common_pcs_pma_interface_bypass_pma_ltr(hssi_common_pcs_pma_interface_bypass_pma_ltr), // false|true
      .hssi_common_pcs_pma_interface_bypass_pma_sw_done(hssi_common_pcs_pma_interface_bypass_pma_sw_done), // false|true
      .hssi_common_pcs_pma_interface_bypass_ppm_lock(hssi_common_pcs_pma_interface_bypass_ppm_lock), // false|true
      .hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp(hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp), // false|true
      .hssi_common_pcs_pma_interface_bypass_txdetectrx(hssi_common_pcs_pma_interface_bypass_txdetectrx), // false|true
      .hssi_common_pcs_pma_interface_cdr_control(hssi_common_pcs_pma_interface_cdr_control), // dis_cdr_ctrl|en_cdr_ctrl
      .hssi_common_pcs_pma_interface_cid_enable(hssi_common_pcs_pma_interface_cid_enable), // dis_cid_mode|en_cid_mode
      .hssi_common_pcs_pma_interface_cp_cons_sel(hssi_common_pcs_pma_interface_cp_cons_sel), // cp_cons_master|cp_cons_slave_abv|cp_cons_slave_blw|cp_cons_default
      .hssi_common_pcs_pma_interface_cp_dwn_mstr(hssi_common_pcs_pma_interface_cp_dwn_mstr), // false|true
      .hssi_common_pcs_pma_interface_cp_up_mstr(hssi_common_pcs_pma_interface_cp_up_mstr), // false|true
      .hssi_common_pcs_pma_interface_ctrl_plane_bonding(hssi_common_pcs_pma_interface_ctrl_plane_bonding), // individual|ctrl_master|ctrl_slave_blw|ctrl_slave_abv
      .hssi_common_pcs_pma_interface_data_mask_count(hssi_common_pcs_pma_interface_data_mask_count),
      .hssi_common_pcs_pma_interface_data_mask_count_multi(hssi_common_pcs_pma_interface_data_mask_count_multi),
      .hssi_common_pcs_pma_interface_dft_observation_clock_selection(hssi_common_pcs_pma_interface_dft_observation_clock_selection), // dft_clk_obsrv_tx0|dft_clk_obsrv_tx1|dft_clk_obsrv_tx2|dft_clk_obsrv_tx3|dft_clk_obsrv_tx4|dft_clk_obsrv_rx|dft_clk_obsrv_hclk|dft_clk_obsrv_fref|dft_clk_obsrv_clklow|dft_clk_obsrv_asn0|dft_clk_obsrv_asn1
      .hssi_common_pcs_pma_interface_early_eios_counter(hssi_common_pcs_pma_interface_early_eios_counter),
      .hssi_common_pcs_pma_interface_force_freqdet(hssi_common_pcs_pma_interface_force_freqdet), // force_freqdet_dis|force1_freqdet_en|force0_freqdet_en
      .hssi_common_pcs_pma_interface_free_run_clk_enable(hssi_common_pcs_pma_interface_free_run_clk_enable), // false|true
      .hssi_common_pcs_pma_interface_ignore_sigdet_g23(hssi_common_pcs_pma_interface_ignore_sigdet_g23), // false|true
      .hssi_common_pcs_pma_interface_pc_en_counter(hssi_common_pcs_pma_interface_pc_en_counter),
      .hssi_common_pcs_pma_interface_pc_rst_counter(hssi_common_pcs_pma_interface_pc_rst_counter),
      .hssi_common_pcs_pma_interface_pcie_hip_mode(hssi_common_pcs_pma_interface_pcie_hip_mode), // hip_enable|hip_disable
      .hssi_common_pcs_pma_interface_ph_fifo_reg_mode(hssi_common_pcs_pma_interface_ph_fifo_reg_mode), // phfifo_reg_mode_dis|phfifo_reg_mode_en
      .hssi_common_pcs_pma_interface_phfifo_flush_wait(hssi_common_pcs_pma_interface_phfifo_flush_wait),
      .hssi_common_pcs_pma_interface_pipe_if_g3pcs(hssi_common_pcs_pma_interface_pipe_if_g3pcs), // pipe_if_g3pcs|pipe_if_8gpcs
      .hssi_common_pcs_pma_interface_pma_done_counter(hssi_common_pcs_pma_interface_pma_done_counter),
      .hssi_common_pcs_pma_interface_pma_if_dft_en(hssi_common_pcs_pma_interface_pma_if_dft_en), // dft_dis|dft_en
      .hssi_common_pcs_pma_interface_pma_if_dft_val(hssi_common_pcs_pma_interface_pma_if_dft_val), // dft_0|dft_1
      .hssi_common_pcs_pma_interface_ppm_cnt_rst(hssi_common_pcs_pma_interface_ppm_cnt_rst), // ppm_cnt_rst_dis|ppm_cnt_rst_en
      .hssi_common_pcs_pma_interface_ppm_deassert_early(hssi_common_pcs_pma_interface_ppm_deassert_early), // deassert_early_dis|deassert_early_en
      .hssi_common_pcs_pma_interface_ppm_det_buckets(hssi_common_pcs_pma_interface_ppm_det_buckets), // disable_prot|ppm_300_bucket|ppm_100_bucket|ppm_300_100_bucket
      .hssi_common_pcs_pma_interface_ppm_gen1_2_cnt(hssi_common_pcs_pma_interface_ppm_gen1_2_cnt), // cnt_32k|cnt_64k
      .hssi_common_pcs_pma_interface_ppm_post_eidle_delay(hssi_common_pcs_pma_interface_ppm_post_eidle_delay), // cnt_200_cycles|cnt_400_cycles
      .hssi_common_pcs_pma_interface_ppmsel(hssi_common_pcs_pma_interface_ppmsel), // ppmsel_disable|ppmsel_5000|ppmsel_2500|ppmsel_1000|ppmsel_500|ppmsel_300|ppmsel_250|ppmsel_200|ppmsel_125|ppmsel_100|ppmsel_62p5|ppm_other
      .hssi_common_pcs_pma_interface_prot_mode(hssi_common_pcs_pma_interface_prot_mode), // disable_prot_mode|pipe_g12|pipe_g3|other_protocols
      .hssi_common_pcs_pma_interface_reconfig_settings(hssi_common_pcs_pma_interface_reconfig_settings), //
      .hssi_common_pcs_pma_interface_rxvalid_mask(hssi_common_pcs_pma_interface_rxvalid_mask), // rxvalid_mask_dis|rxvalid_mask_en
      .hssi_common_pcs_pma_interface_sigdet_wait_counter(hssi_common_pcs_pma_interface_sigdet_wait_counter),
      .hssi_common_pcs_pma_interface_sigdet_wait_counter_multi(hssi_common_pcs_pma_interface_sigdet_wait_counter_multi),
      .hssi_common_pcs_pma_interface_sim_mode(hssi_common_pcs_pma_interface_sim_mode), // disable|enable
      .hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en(hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en), // false|true
      .hssi_common_pcs_pma_interface_sup_mode(hssi_common_pcs_pma_interface_sup_mode), // user_mode|engineering_mode
      .hssi_common_pcs_pma_interface_testout_sel(hssi_common_pcs_pma_interface_testout_sel), // ppm_det_test|asn_test|pma_pll_test|rxpmaif_test|prbs_gen_test|prbs_ver_test|uhsif_1_test|uhsif_2_test|uhsif_3_test
      .hssi_common_pcs_pma_interface_wait_clk_on_off_timer(hssi_common_pcs_pma_interface_wait_clk_on_off_timer),
      .hssi_common_pcs_pma_interface_wait_pipe_synchronizing(hssi_common_pcs_pma_interface_wait_pipe_synchronizing),
      .hssi_common_pcs_pma_interface_wait_send_syncp_fbkp(hssi_common_pcs_pma_interface_wait_send_syncp_fbkp),
      // parameters for twentynm_hssi_common_pld_pcs_interface
      .hssi_common_pld_pcs_interface_dft_clk_out_en(hssi_common_pld_pcs_interface_dft_clk_out_en), // dft_clk_out_disable|dft_clk_out_enable
      .hssi_common_pld_pcs_interface_dft_clk_out_sel(hssi_common_pld_pcs_interface_dft_clk_out_sel), // teng_rx_dft_clk|teng_tx_dft_clk|eightg_rx_dft_clk|eightg_tx_dft_clk|pmaif_dft_clk
      .hssi_common_pld_pcs_interface_hrdrstctrl_en(hssi_common_pld_pcs_interface_hrdrstctrl_en), // hrst_dis|hrst_en
      .hssi_common_pld_pcs_interface_pcs_testbus_block_sel(hssi_common_pld_pcs_interface_pcs_testbus_block_sel), // eightg|g3pcs|teng|krfec|pma_if
      .hssi_common_pld_pcs_interface_reconfig_settings(hssi_common_pld_pcs_interface_reconfig_settings), //
      // parameters for twentynm_hssi_fifo_rx_pcs
      .hssi_fifo_rx_pcs_double_read_mode(hssi_fifo_rx_pcs_double_read_mode), // double_read_en|double_read_dis
      .hssi_fifo_rx_pcs_prot_mode    (hssi_fifo_rx_pcs_prot_mode    ), // teng_mode|non_teng_mode
      // parameters for twentynm_hssi_fifo_tx_pcs
      .hssi_fifo_tx_pcs_double_write_mode(hssi_fifo_tx_pcs_double_write_mode), // double_write_en|double_write_dis
      .hssi_fifo_tx_pcs_prot_mode    (hssi_fifo_tx_pcs_prot_mode    ), // teng_mode|non_teng_mode
      // parameters for twentynm_hssi_gen3_rx_pcs
      .hssi_gen3_rx_pcs_block_sync   (hssi_gen3_rx_pcs_block_sync   ), // bypass_block_sync|enable_block_sync
      .hssi_gen3_rx_pcs_block_sync_sm(hssi_gen3_rx_pcs_block_sync_sm), // disable_blk_sync_sm|enable_blk_sync_sm
      .hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn(hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn), // disable|enable
      .hssi_gen3_rx_pcs_lpbk_force   (hssi_gen3_rx_pcs_lpbk_force   ), // lpbk_frce_dis|lpbk_frce_en
      .hssi_gen3_rx_pcs_mode         (hssi_gen3_rx_pcs_mode         ), // gen3_func|disable_pcs
      .hssi_gen3_rx_pcs_rate_match_fifo(hssi_gen3_rx_pcs_rate_match_fifo), // bypass_rm_fifo|enable_rm_fifo_600ppm|enable_rm_fifo_0ppm
      .hssi_gen3_rx_pcs_rate_match_fifo_latency(hssi_gen3_rx_pcs_rate_match_fifo_latency), // regular_latency|low_latency
      .hssi_gen3_rx_pcs_reconfig_settings(hssi_gen3_rx_pcs_reconfig_settings), //
      .hssi_gen3_rx_pcs_reverse_lpbk (hssi_gen3_rx_pcs_reverse_lpbk ), // rev_lpbk_dis|rev_lpbk_en
      .hssi_gen3_rx_pcs_rx_b4gb_par_lpbk(hssi_gen3_rx_pcs_rx_b4gb_par_lpbk), // b4gb_par_lpbk_dis|b4gb_par_lpbk_en
      .hssi_gen3_rx_pcs_rx_force_balign(hssi_gen3_rx_pcs_rx_force_balign), // en_force_balign|dis_force_balign
      .hssi_gen3_rx_pcs_rx_ins_del_one_skip(hssi_gen3_rx_pcs_rx_ins_del_one_skip), // ins_del_one_skip_dis|ins_del_one_skip_en
      .hssi_gen3_rx_pcs_rx_num_fixed_pat(hssi_gen3_rx_pcs_rx_num_fixed_pat),
      .hssi_gen3_rx_pcs_rx_test_out_sel(hssi_gen3_rx_pcs_rx_test_out_sel), // rx_test_out0|rx_test_out1
      .hssi_gen3_rx_pcs_sup_mode     (hssi_gen3_rx_pcs_sup_mode     ), // user_mode|engineering_mode
      // parameters for twentynm_hssi_gen3_tx_pcs
      .hssi_gen3_tx_pcs_mode         (hssi_gen3_tx_pcs_mode         ), // gen3_func|disable_pcs
      .hssi_gen3_tx_pcs_reverse_lpbk (hssi_gen3_tx_pcs_reverse_lpbk ), // rev_lpbk_dis|rev_lpbk_en
      .hssi_gen3_tx_pcs_sup_mode     (hssi_gen3_tx_pcs_sup_mode     ), // user_mode|engineering_mode
      .hssi_gen3_tx_pcs_tx_bitslip   (hssi_gen3_tx_pcs_tx_bitslip   ),
      .hssi_gen3_tx_pcs_tx_gbox_byp  (hssi_gen3_tx_pcs_tx_gbox_byp  ), // bypass_gbox|enable_gbox
      // parameters for twentynm_hssi_krfec_rx_pcs
      .hssi_krfec_rx_pcs_blksync_cor_en(hssi_krfec_rx_pcs_blksync_cor_en), // detect|correct
      .hssi_krfec_rx_pcs_bypass_gb   (hssi_krfec_rx_pcs_bypass_gb   ), // bypass_dis|bypass_en
      .hssi_krfec_rx_pcs_clr_ctrl    (hssi_krfec_rx_pcs_clr_ctrl    ), // both_enabled|corr_cnt_only|uncorr_cnt_only
      .hssi_krfec_rx_pcs_ctrl_bit_reverse(hssi_krfec_rx_pcs_ctrl_bit_reverse), // ctrl_bit_reverse_dis|ctrl_bit_reverse_en
      .hssi_krfec_rx_pcs_data_bit_reverse(hssi_krfec_rx_pcs_data_bit_reverse), // data_bit_reverse_dis|data_bit_reverse_en
      .hssi_krfec_rx_pcs_dv_start    (hssi_krfec_rx_pcs_dv_start    ), // with_blksync|with_blklock
      .hssi_krfec_rx_pcs_err_mark_type(hssi_krfec_rx_pcs_err_mark_type), // err_mark_10g|err_mark_40g
      .hssi_krfec_rx_pcs_error_marking_en(hssi_krfec_rx_pcs_error_marking_en), // err_mark_dis|err_mark_en
      .hssi_krfec_rx_pcs_low_latency_en(hssi_krfec_rx_pcs_low_latency_en), // disable|enable
      .hssi_krfec_rx_pcs_lpbk_mode   (hssi_krfec_rx_pcs_lpbk_mode   ), // lpbk_dis|lpbk_en
      .hssi_krfec_rx_pcs_parity_invalid_enum(hssi_krfec_rx_pcs_parity_invalid_enum),
      .hssi_krfec_rx_pcs_parity_valid_num(hssi_krfec_rx_pcs_parity_valid_num),
      .hssi_krfec_rx_pcs_pipeln_blksync(hssi_krfec_rx_pcs_pipeln_blksync), // disable|enable
      .hssi_krfec_rx_pcs_pipeln_descrm(hssi_krfec_rx_pcs_pipeln_descrm), // disable|enable
      .hssi_krfec_rx_pcs_pipeln_errcorrect(hssi_krfec_rx_pcs_pipeln_errcorrect), // disable|enable
      .hssi_krfec_rx_pcs_pipeln_errtrap_ind(hssi_krfec_rx_pcs_pipeln_errtrap_ind), // disable|enable
      .hssi_krfec_rx_pcs_pipeln_errtrap_lfsr(hssi_krfec_rx_pcs_pipeln_errtrap_lfsr), // disable|enable
      .hssi_krfec_rx_pcs_pipeln_errtrap_loc(hssi_krfec_rx_pcs_pipeln_errtrap_loc), // disable|enable
      .hssi_krfec_rx_pcs_pipeln_errtrap_pat(hssi_krfec_rx_pcs_pipeln_errtrap_pat), // disable|enable
      .hssi_krfec_rx_pcs_pipeln_gearbox(hssi_krfec_rx_pcs_pipeln_gearbox), // disable|enable
      .hssi_krfec_rx_pcs_pipeln_syndrm(hssi_krfec_rx_pcs_pipeln_syndrm), // disable|enable
      .hssi_krfec_rx_pcs_pipeln_trans_dec(hssi_krfec_rx_pcs_pipeln_trans_dec), // disable|enable
      .hssi_krfec_rx_pcs_prot_mode   (hssi_krfec_rx_pcs_prot_mode   ), // disable_mode|teng_basekr_mode|fortyg_basekr_mode|teng_1588_basekr_mode|basic_mode
      .hssi_krfec_rx_pcs_receive_order(hssi_krfec_rx_pcs_receive_order), // receive_lsb|receive_msb
      .hssi_krfec_rx_pcs_reconfig_settings(hssi_krfec_rx_pcs_reconfig_settings), //
      .hssi_krfec_rx_pcs_rx_testbus_sel(hssi_krfec_rx_pcs_rx_testbus_sel), // overall|fast_search|fast_search_cntrs|blksync|blksync_cntrs|decoder_master_sm|decoder_master_sm_cntrs|syndrm_sm|syndrm1|syndrm2|errtrap_sm|errtrap_ind1|errtrap_ind2|errtrap_ind3|errtrap_ind4|errtrap_ind5|errtrap_loc|errtrap_pat1|errtrap_pat2|errtrap_pat3|errtrap_pat4|decoder_rd_sm|gb_and_trans
      .hssi_krfec_rx_pcs_signal_ok_en(hssi_krfec_rx_pcs_signal_ok_en), // sig_ok_dis|sig_ok_en
      .hssi_krfec_rx_pcs_sup_mode    (hssi_krfec_rx_pcs_sup_mode    ), // user_mode|engineering_mode
      // parameters for twentynm_hssi_krfec_tx_pcs
      .hssi_krfec_tx_pcs_burst_err   (hssi_krfec_tx_pcs_burst_err   ), // burst_err_dis|burst_err_en
      .hssi_krfec_tx_pcs_burst_err_len(hssi_krfec_tx_pcs_burst_err_len), // burst_err_len1|burst_err_len2|burst_err_len3|burst_err_len4|burst_err_len5|burst_err_len6|burst_err_len7|burst_err_len8|burst_err_len9|burst_err_len10|burst_err_len11|burst_err_len12|burst_err_len13|burst_err_len14|burst_err_len15|burst_err_len16
      .hssi_krfec_tx_pcs_ctrl_bit_reverse(hssi_krfec_tx_pcs_ctrl_bit_reverse), // ctrl_bit_reverse_dis|ctrl_bit_reverse_en
      .hssi_krfec_tx_pcs_data_bit_reverse(hssi_krfec_tx_pcs_data_bit_reverse), // data_bit_reverse_dis|data_bit_reverse_en
      .hssi_krfec_tx_pcs_enc_frame_query(hssi_krfec_tx_pcs_enc_frame_query), // enc_query_dis|enc_query_en
      .hssi_krfec_tx_pcs_low_latency_en(hssi_krfec_tx_pcs_low_latency_en), // disable|enable
      .hssi_krfec_tx_pcs_pipeln_encoder(hssi_krfec_tx_pcs_pipeln_encoder), // disable|enable
      .hssi_krfec_tx_pcs_pipeln_scrambler(hssi_krfec_tx_pcs_pipeln_scrambler), // disable|enable
      .hssi_krfec_tx_pcs_prot_mode   (hssi_krfec_tx_pcs_prot_mode   ), // disable_mode|teng_basekr_mode|fortyg_basekr_mode|teng_1588_basekr_mode|basic_mode
      .hssi_krfec_tx_pcs_sup_mode    (hssi_krfec_tx_pcs_sup_mode    ), // user_mode|engineering_mode
      .hssi_krfec_tx_pcs_transcode_err(hssi_krfec_tx_pcs_transcode_err), // trans_err_dis|trans_err_en
      .hssi_krfec_tx_pcs_transmit_order(hssi_krfec_tx_pcs_transmit_order), // transmit_lsb|transmit_msb
      .hssi_krfec_tx_pcs_tx_testbus_sel(hssi_krfec_tx_pcs_tx_testbus_sel), // overall|encoder1|encoder2|scramble1|scramble2|scramble3|gearbox
      // parameters for twentynm_hssi_pipe_gen1_2
      .hssi_pipe_gen1_2_elec_idle_delay_val(hssi_pipe_gen1_2_elec_idle_delay_val),
      .hssi_pipe_gen1_2_error_replace_pad(hssi_pipe_gen1_2_error_replace_pad), // replace_edb|replace_pad
      .hssi_pipe_gen1_2_hip_mode     (hssi_pipe_gen1_2_hip_mode     ), // dis_hip|en_hip
      .hssi_pipe_gen1_2_ind_error_reporting(hssi_pipe_gen1_2_ind_error_reporting), // dis_ind_error_reporting|en_ind_error_reporting
      .hssi_pipe_gen1_2_phystatus_delay_val(hssi_pipe_gen1_2_phystatus_delay_val),
      .hssi_pipe_gen1_2_phystatus_rst_toggle(hssi_pipe_gen1_2_phystatus_rst_toggle), // dis_phystatus_rst_toggle|en_phystatus_rst_toggle
      .hssi_pipe_gen1_2_pipe_byte_de_serializer_en(hssi_pipe_gen1_2_pipe_byte_de_serializer_en), // dis_bds|en_bds_by_2|dont_care_bds
      .hssi_pipe_gen1_2_prot_mode    (hssi_pipe_gen1_2_prot_mode    ), // pipe_g1|pipe_g2|pipe_g3|basic|disabled_prot_mode
      .hssi_pipe_gen1_2_reconfig_settings(hssi_pipe_gen1_2_reconfig_settings), //
      .hssi_pipe_gen1_2_rx_pipe_enable(hssi_pipe_gen1_2_rx_pipe_enable), // dis_pipe_rx|en_pipe_rx|en_pipe3_rx
      .hssi_pipe_gen1_2_rxdetect_bypass(hssi_pipe_gen1_2_rxdetect_bypass), // dis_rxdetect_bypass|en_rxdetect_bypass
      .hssi_pipe_gen1_2_sup_mode     (hssi_pipe_gen1_2_sup_mode     ), // user_mode|engineering_mode
      .hssi_pipe_gen1_2_tx_pipe_enable(hssi_pipe_gen1_2_tx_pipe_enable), // dis_pipe_tx|en_pipe_tx|en_pipe3_tx
      .hssi_pipe_gen1_2_txswing      (hssi_pipe_gen1_2_txswing      ), // dis_txswing|en_txswing
      // parameters for twentynm_hssi_pipe_gen3
      .hssi_pipe_gen3_bypass_rx_detection_enable(hssi_pipe_gen3_bypass_rx_detection_enable), // false|true
      .hssi_pipe_gen3_bypass_rx_preset(hssi_pipe_gen3_bypass_rx_preset),
      .hssi_pipe_gen3_bypass_rx_preset_enable(hssi_pipe_gen3_bypass_rx_preset_enable), // false|true
      .hssi_pipe_gen3_bypass_tx_coefficent(hssi_pipe_gen3_bypass_tx_coefficent),
      .hssi_pipe_gen3_bypass_tx_coefficent_enable(hssi_pipe_gen3_bypass_tx_coefficent_enable), // false|true
      .hssi_pipe_gen3_elecidle_delay_g3(hssi_pipe_gen3_elecidle_delay_g3),
      .hssi_pipe_gen3_ind_error_reporting(hssi_pipe_gen3_ind_error_reporting), // dis_ind_error_reporting|en_ind_error_reporting
      .hssi_pipe_gen3_mode           (hssi_pipe_gen3_mode           ), // pipe_g1|pipe_g2|pipe_g3|disable_pcs
      .hssi_pipe_gen3_phy_status_delay_g12(hssi_pipe_gen3_phy_status_delay_g12),
      .hssi_pipe_gen3_phy_status_delay_g3(hssi_pipe_gen3_phy_status_delay_g3),
      .hssi_pipe_gen3_phystatus_rst_toggle_g12(hssi_pipe_gen3_phystatus_rst_toggle_g12), // dis_phystatus_rst_toggle|en_phystatus_rst_toggle
      .hssi_pipe_gen3_phystatus_rst_toggle_g3(hssi_pipe_gen3_phystatus_rst_toggle_g3), // dis_phystatus_rst_toggle_g3|en_phystatus_rst_toggle_g3
      .hssi_pipe_gen3_rate_match_pad_insertion(hssi_pipe_gen3_rate_match_pad_insertion), // dis_rm_fifo_pad_ins|en_rm_fifo_pad_ins
      .hssi_pipe_gen3_sup_mode       (hssi_pipe_gen3_sup_mode       ), // user_mode|engineering_mode
      .hssi_pipe_gen3_test_out_sel   (hssi_pipe_gen3_test_out_sel   ), // tx_test_out|rx_test_out|pipe_test_out1|pipe_test_out2|pipe_test_out3|pipe_ctrl_test_out|disable_test_out
      // parameters for twentynm_hssi_rx_pcs_pma_interface
      .hssi_rx_pcs_pma_interface_block_sel(hssi_rx_pcs_pma_interface_block_sel), // eight_g_pcs|ten_g_pcs|direct_pld
      .hssi_rx_pcs_pma_interface_channel_operation_mode(hssi_rx_pcs_pma_interface_channel_operation_mode), // tx_rx_pair_enabled|tx_rx_independent
      .hssi_rx_pcs_pma_interface_clkslip_sel(hssi_rx_pcs_pma_interface_clkslip_sel), // pld|slip_eight_g_pcs
      .hssi_rx_pcs_pma_interface_lpbk_en(hssi_rx_pcs_pma_interface_lpbk_en), // disable|enable
      .hssi_rx_pcs_pma_interface_master_clk_sel(hssi_rx_pcs_pma_interface_master_clk_sel), // master_rx_pma_clk|master_tx_pma_clk|master_refclk_dig
      .hssi_rx_pcs_pma_interface_pldif_datawidth_mode(hssi_rx_pcs_pma_interface_pldif_datawidth_mode), // pldif_data_10bit|pldif_data_8bit
      .hssi_rx_pcs_pma_interface_pma_dw_rx(hssi_rx_pcs_pma_interface_pma_dw_rx), // pma_8b_rx|pma_10b_rx|pma_16b_rx|pma_20b_rx|pma_32b_rx|pma_40b_rx|pma_64b_rx|pcie_g3_dyn_dw_rx
      .hssi_rx_pcs_pma_interface_pma_if_dft_en(hssi_rx_pcs_pma_interface_pma_if_dft_en), // dft_dis|dft_en
      .hssi_rx_pcs_pma_interface_pma_if_dft_val(hssi_rx_pcs_pma_interface_pma_if_dft_val), // dft_0|dft_1
      .hssi_rx_pcs_pma_interface_prbs9_dwidth(hssi_rx_pcs_pma_interface_prbs9_dwidth), // prbs9_64b|prbs9_10b
      .hssi_rx_pcs_pma_interface_prbs_clken(hssi_rx_pcs_pma_interface_prbs_clken), // prbs_clk_dis|prbs_clk_en
      .hssi_rx_pcs_pma_interface_prbs_ver(hssi_rx_pcs_pma_interface_prbs_ver), // prbs_off|prbs_31|prbs_15|prbs_23|prbs_9|prbs_7
      .hssi_rx_pcs_pma_interface_prot_mode_rx(hssi_rx_pcs_pma_interface_prot_mode_rx), // disabled_prot_mode_rx|pcs_direct_mode_rx|eightg_only_pld_mode_rx|eightg_pcie_g12_pld_mode_rx|eightg_g3_pcie_g3_pld_mode_rx|eightg_pcie_g12_hip_mode_rx|eightg_g3_pcie_g3_hip_mode_rx|teng_krfec_mode_rx|eightg_basic_mode_rx|teng_basic_mode_rx|teng_sfis_sdi_mode_rx|prbs_mode_rx
      .hssi_rx_pcs_pma_interface_reconfig_settings(hssi_rx_pcs_pma_interface_reconfig_settings), //
      .hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion(hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion), // rx_dyn_polinv_dis|rx_dyn_polinv_en
      .hssi_rx_pcs_pma_interface_rx_lpbk_en(hssi_rx_pcs_pma_interface_rx_lpbk_en), // lpbk_dis|lpbk_en
      .hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok(hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok), // unforce_sig_ok|force_sig_ok
      .hssi_rx_pcs_pma_interface_rx_prbs_mask(hssi_rx_pcs_pma_interface_rx_prbs_mask), // prbsmask128|prbsmask256|prbsmask512|prbsmask1024
      .hssi_rx_pcs_pma_interface_rx_prbs_mode(hssi_rx_pcs_pma_interface_rx_prbs_mode), // teng_mode|eightg_mode
      .hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel(hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel), // sel_sig_det|sel_sig_ok
      .hssi_rx_pcs_pma_interface_rx_static_polarity_inversion(hssi_rx_pcs_pma_interface_rx_static_polarity_inversion), // rx_stat_polinv_dis|rx_stat_polinv_en
      .hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en(hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en), // uhsif_lpbk_dis|uhsif_lpbk_en
      .hssi_rx_pcs_pma_interface_sup_mode(hssi_rx_pcs_pma_interface_sup_mode), // user_mode|engineering_mode
      // parameters for twentynm_hssi_rx_pld_pcs_interface
      .hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx(hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode(hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode), // tx_rx_pair_enabled|tx_rx_independent
      .hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx(hssi_rx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_rx), // individual_rx|ctrl_master_rx|ctrl_slave_abv_rx|ctrl_slave_blw_rx
      .hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx(hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx), // fifo_rx|reg_rx
      .hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx(hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_10g_lpbk_en(hssi_rx_pld_pcs_interface_hd_10g_lpbk_en), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx(hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx), // pma_32b_rx|pma_40b_rx|pma_64b_rx
      .hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx(hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx), // disabled_prot_mode_rx|teng_baser_mode_rx|interlaken_mode_rx|sfis_mode_rx|teng_sdi_mode_rx|basic_mode_rx|test_prp_mode_rx|test_prp_krfec_mode_rx|teng_1588_mode_rx|teng_baser_krfec_mode_rx|teng_1588_krfec_mode_rx|basic_krfec_mode_rx
      .hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx(hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx), // single_rx|double_rx
      .hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode(hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode), // tx|rx
      .hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode(hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode), // tx_rx_pair_enabled|tx_rx_independent
      .hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx(hssi_rx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_rx), // individual_rx|ctrl_master_rx|ctrl_slave_abv_rx|ctrl_slave_blw_rx
      .hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx(hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx), // fifo_rx|reg_rx
      .hssi_rx_pld_pcs_interface_hd_8g_hip_mode(hssi_rx_pld_pcs_interface_hd_8g_hip_mode), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_8g_lpbk_en(hssi_rx_pld_pcs_interface_hd_8g_lpbk_en), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx(hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx), // pma_8b_rx|pma_10b_rx|pma_16b_rx|pma_20b_rx
      .hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx(hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx), // pipe_g1_rx|pipe_g2_rx|pipe_g3_rx|cpri_rx|cpri_rx_tx_rx|gige_rx|gige_1588_rx|basic_rm_enable_rx|basic_rm_disable_rx|disabled_prot_mode_rx
      .hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode(hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode), // tx_rx_pair_enabled|tx_rx_independent
      .hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz(hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz),
      .hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx(hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx), // individual_rx|ctrl_master_rx|ctrl_slave_abv_rx|ctrl_slave_blw_rx
      .hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz(hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz),
      .hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en(hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_chnl_func_mode(hssi_rx_pld_pcs_interface_hd_chnl_func_mode), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_chnl_hip_en(hssi_rx_pld_pcs_interface_hd_chnl_hip_en), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en(hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx(hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en(hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx(hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx), // fifo_rx|reg_rx
      .hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz(hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz),
      .hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx(hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx), // pma_8b_rx|pma_10b_rx|pma_16b_rx|pma_20b_rx|pma_32b_rx|pma_40b_rx|pma_64b_rx|pcie_g3_dyn_dw_rx
      .hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz(hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz),
      .hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx(hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx), // disabled_prot_mode_rx|pcie_g1_capable_rx|pcie_g2_capable_rx|pcie_g3_capable_rx|gige_rx|teng_baser_rx|teng_basekr_krfec_rx|fortyg_basekr_krfec_rx|cpri_8b10b_rx|interlaken_rx|sfis_rx|teng_sdi_rx|gige_1588_rx|teng_1588_baser_rx|teng_1588_basekr_krfec_rx|basic_8gpcs_rm_enable_rx|basic_8gpcs_rm_disable_rx|basic_10gpcs_rx|basic_10gpcs_krfec_rx|pcs_direct_rx|prp_rx|prp_krfec_rx|prbs_rx
      .hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx(hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx), // single_rx|double_rx
      .hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx(hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode(hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode), // tx_rx_pair_enabled|tx_rx_independent
      .hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx(hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx), // teng_mode_rx|non_teng_mode_rx
      .hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx(hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx), // single_rx|double_rx
      .hssi_rx_pld_pcs_interface_hd_g3_prot_mode(hssi_rx_pld_pcs_interface_hd_g3_prot_mode), // pipe_g1|pipe_g2|pipe_g3|disabled_prot_mode
      .hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode(hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode), // tx_rx_pair_enabled|tx_rx_independent
      .hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx(hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en(hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx(hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx), // disabled_prot_mode_rx|teng_basekr_mode_rx|fortyg_basekr_mode_rx|teng_1588_basekr_mode_rx|basic_mode_rx
      .hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode(hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode), // tx|rx
      .hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en(hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx(hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx), // disabled_prot_mode_rx|eightg_and_g3_pld_fifo_mode_rx|eightg_and_g3_reg_mode_rx|eightg_and_g3_reg_mode_hip_rx|teng_pld_fifo_mode_rx|teng_reg_mode_rx|teng_and_krfec_pld_fifo_mode_rx|teng_and_krfec_reg_mode_rx|pcs_direct_reg_mode_rx
      .hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode(hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode), // tx_rx_pair_enabled|tx_rx_independent
      .hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en(hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en), // disable|enable
      .hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx(hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx), // pma_8b_rx|pma_10b_rx|pma_16b_rx|pma_20b_rx|pma_32b_rx|pma_40b_rx|pma_64b_rx|pcie_g3_dyn_dw_rx
      .hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx(hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx), // disabled_prot_mode_rx|pcs_direct_mode_rx|eightg_only_pld_mode_rx|eightg_pcie_g12_pld_mode_rx|eightg_g3_pcie_g3_pld_mode_rx|eightg_pcie_g12_hip_mode_rx|eightg_g3_pcie_g3_hip_mode_rx|teng_krfec_mode_rx|eightg_basic_mode_rx|teng_basic_mode_rx|teng_sfis_sdi_mode_rx|prbs_mode_rx
      .hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode(hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode), // disable|enable
      .hssi_rx_pld_pcs_interface_pcs_rx_block_sel(hssi_rx_pld_pcs_interface_pcs_rx_block_sel), // eightg|teng|pcs_direct
      .hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel(hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel), // eightg_clk_out|teng_clk_out|pma_rx_clk|pma_rx_clk_user
      .hssi_rx_pld_pcs_interface_pcs_rx_clk_sel(hssi_rx_pld_pcs_interface_pcs_rx_clk_sel), // pld_rx_clk|pcs_rx_clk
      .hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en(hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en), // hip_rx_enable|hip_rx_disable
      .hssi_rx_pld_pcs_interface_pcs_rx_output_sel(hssi_rx_pld_pcs_interface_pcs_rx_output_sel), // krfec_output|teng_output
      .hssi_rx_pld_pcs_interface_reconfig_settings(hssi_rx_pld_pcs_interface_reconfig_settings), //
      // parameters for twentynm_hssi_tx_pcs_pma_interface
      .hssi_tx_pcs_pma_interface_bypass_pma_txelecidle(hssi_tx_pcs_pma_interface_bypass_pma_txelecidle), // false|true
      .hssi_tx_pcs_pma_interface_channel_operation_mode(hssi_tx_pcs_pma_interface_channel_operation_mode), // tx_rx_pair_enabled|tx_rx_independent
      .hssi_tx_pcs_pma_interface_lpbk_en(hssi_tx_pcs_pma_interface_lpbk_en), // disable|enable
      .hssi_tx_pcs_pma_interface_master_clk_sel(hssi_tx_pcs_pma_interface_master_clk_sel), // master_tx_pma_clk|master_refclk_dig
      .hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx(hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx), // pipe_g12|pipe_g3|other_prot_mode
      .hssi_tx_pcs_pma_interface_pldif_datawidth_mode(hssi_tx_pcs_pma_interface_pldif_datawidth_mode), // pldif_data_10bit|pldif_data_8bit
      .hssi_tx_pcs_pma_interface_pma_dw_tx(hssi_tx_pcs_pma_interface_pma_dw_tx), // pma_8b_tx|pma_10b_tx|pma_16b_tx|pma_20b_tx|pma_32b_tx|pma_40b_tx|pma_64b_tx|pcie_g3_dyn_dw_tx
      .hssi_tx_pcs_pma_interface_pma_if_dft_en(hssi_tx_pcs_pma_interface_pma_if_dft_en), // dft_dis|dft_en
      .hssi_tx_pcs_pma_interface_pmagate_en(hssi_tx_pcs_pma_interface_pmagate_en), // pmagate_dis|pmagate_en
      .hssi_tx_pcs_pma_interface_prbs9_dwidth(hssi_tx_pcs_pma_interface_prbs9_dwidth), // prbs9_64b|prbs9_10b
      .hssi_tx_pcs_pma_interface_prbs_clken(hssi_tx_pcs_pma_interface_prbs_clken), // prbs_clk_dis|prbs_clk_en
      .hssi_tx_pcs_pma_interface_prbs_gen_pat(hssi_tx_pcs_pma_interface_prbs_gen_pat), // prbs_gen_dis|prbs_31|prbs_23|prbs_15|prbs_9|prbs_7
      .hssi_tx_pcs_pma_interface_prot_mode_tx(hssi_tx_pcs_pma_interface_prot_mode_tx), // disabled_prot_mode_tx|pcs_direct_mode_tx|uhsif_reg_mode_tx|uhsif_direct_mode_tx|eightg_only_pld_mode_tx|eightg_pcie_g12_pld_mode_tx|eightg_g3_pcie_g3_pld_mode_tx|eightg_pcie_g12_hip_mode_tx|eightg_g3_pcie_g3_hip_mode_tx|teng_krfec_mode_tx|eightg_basic_mode_tx|teng_basic_mode_tx|teng_sfis_sdi_mode_tx|prbs_mode_tx|sqwave_mode_tx
      .hssi_tx_pcs_pma_interface_reconfig_settings(hssi_tx_pcs_pma_interface_reconfig_settings), //
      .hssi_tx_pcs_pma_interface_sq_wave_num(hssi_tx_pcs_pma_interface_sq_wave_num), // sq_wave_1|sq_wave_4|sq_wave_8|sq_wave_6|sq_wave_default
      .hssi_tx_pcs_pma_interface_sqwgen_clken(hssi_tx_pcs_pma_interface_sqwgen_clken), // sqwgen_clk_dis|sqwgen_clk_en
      .hssi_tx_pcs_pma_interface_sup_mode(hssi_tx_pcs_pma_interface_sup_mode), // user_mode|engineering_mode
      .hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion(hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion), // tx_dyn_polinv_dis|tx_dyn_polinv_en
      .hssi_tx_pcs_pma_interface_tx_pma_data_sel(hssi_tx_pcs_pma_interface_tx_pma_data_sel), // pld_dir|pcie_gen3|eight_g_pcs|ten_g_pcs|prbs_pat|sq_wave_pat|block_sel_default|registered_uhsif_dat|directed_uhsif_dat
      .hssi_tx_pcs_pma_interface_tx_static_polarity_inversion(hssi_tx_pcs_pma_interface_tx_static_polarity_inversion), // tx_stat_polinv_dis|tx_stat_polinv_en
      .hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock(hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock), // uhsif_filt_stepsz_b4lock_2|uhsif_filt_stepsz_b4lock_4|uhsif_filt_stepsz_b4lock_6|uhsif_filt_stepsz_b4lock_8
      .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value),
      .hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock(hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock), // uhsif_filt_cntthr_b4lock_8|uhsif_filt_cntthr_b4lock_16|uhsif_filt_cntthr_b4lock_24|uhsif_filt_cntthr_b4lock_32
      .hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period(hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period), // uhsif_dcn_test_period_4|uhsif_dcn_test_period_8|uhsif_dcn_test_period_12|uhsif_dcn_test_period_16
      .hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable(hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable), // uhsif_dcn_test_mode_enable|uhsif_dcn_test_mode_disable
      .hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh(hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh), // uhsif_dzt_cnt_thr_2|uhsif_dzt_cnt_thr_4|uhsif_dzt_cnt_thr_6|uhsif_dzt_cnt_thr_8
      .hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable(hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable), // uhsif_dzt_disable|uhsif_dzt_enable
      .hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window(hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window), // uhsif_dzt_obr_win_16|uhsif_dzt_obr_win_32|uhsif_dzt_obr_win_48|uhsif_dzt_obr_win_64
      .hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size(hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size), // uhsif_dzt_skipsz_4|uhsif_dzt_skipsz_8|uhsif_dzt_skipsz_12|uhsif_dzt_skipsz_16
      .hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel(hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel), // uhsif_index_internal|uhsif_index_cram
      .hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin(hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin), // uhsif_dcn_margin_2|uhsif_dcn_margin_3|uhsif_dcn_margin_4|uhsif_dcn_margin_5
      .hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value(hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value),
      .hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control(hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control), // uhsif_dft_dz_det_val_0|uhsif_dft_dz_det_val_1
      .hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control(hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control), // uhsif_dft_up_val_0|uhsif_dft_up_val_1
      .hssi_tx_pcs_pma_interface_uhsif_enable(hssi_tx_pcs_pma_interface_uhsif_enable), // uhsif_disable|uhsif_enable
      .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock), // uhsif_lkd_segsz_aflock_512|uhsif_lkd_segsz_aflock_1024|uhsif_lkd_segsz_aflock_2048|uhsif_lkd_segsz_aflock_4096
      .hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock(hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock), // uhsif_lkd_segsz_b4lock_16|uhsif_lkd_segsz_b4lock_32|uhsif_lkd_segsz_b4lock_64|uhsif_lkd_segsz_b4lock_128
      .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value),
      .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value),
      .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value),
      .hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value(hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value),
      // parameters for twentynm_hssi_tx_pld_pcs_interface
      .hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx(hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx), // disable|enable
      .hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode(hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode), // tx_rx_pair_enabled|tx_rx_independent
      .hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx(hssi_tx_pld_pcs_interface_hd_10g_ctrl_plane_bonding_tx), // individual_tx|ctrl_master_tx|ctrl_slave_abv_tx|ctrl_slave_blw_tx
      .hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx(hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx), // fifo_tx|reg_tx|fastreg_tx
      .hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx(hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx), // disable|enable
      .hssi_tx_pld_pcs_interface_hd_10g_lpbk_en(hssi_tx_pld_pcs_interface_hd_10g_lpbk_en), // disable|enable
      .hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx(hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx), // pma_32b_tx|pma_40b_tx|pma_64b_tx
      .hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx(hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx), // disabled_prot_mode_tx|teng_baser_mode_tx|interlaken_mode_tx|sfis_mode_tx|teng_sdi_mode_tx|basic_mode_tx|test_prp_mode_tx|test_prp_krfec_mode_tx|teng_1588_mode_tx|teng_baser_krfec_mode_tx|teng_1588_krfec_mode_tx|basic_krfec_mode_tx
      .hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx(hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx), // single_tx|double_tx
      .hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode(hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode), // tx_rx_pair_enabled|tx_rx_independent
      .hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx(hssi_tx_pld_pcs_interface_hd_8g_ctrl_plane_bonding_tx), // individual_tx|ctrl_master_tx|ctrl_slave_abv_tx|ctrl_slave_blw_tx
      .hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx(hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx), // fifo_tx|reg_tx|fastreg_tx
      .hssi_tx_pld_pcs_interface_hd_8g_hip_mode(hssi_tx_pld_pcs_interface_hd_8g_hip_mode), // disable|enable
      .hssi_tx_pld_pcs_interface_hd_8g_lpbk_en(hssi_tx_pld_pcs_interface_hd_8g_lpbk_en), // disable|enable
      .hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx(hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx), // pma_8b_tx|pma_10b_tx|pma_16b_tx|pma_20b_tx
      .hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx(hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx), // pipe_g1_tx|pipe_g2_tx|pipe_g3_tx|cpri_tx|cpri_rx_tx_tx|gige_tx|gige_1588_tx|basic_tx|disabled_prot_mode_tx
      .hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode(hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode), // tx_rx_pair_enabled|tx_rx_independent
      .hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx(hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx), // individual_tx|ctrl_master_tx|ctrl_slave_abv_tx|ctrl_slave_blw_tx
      .hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en(hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en), // disable|enable
      .hssi_tx_pld_pcs_interface_hd_chnl_func_mode(hssi_tx_pld_pcs_interface_hd_chnl_func_mode), // disable|enable
      .hssi_tx_pld_pcs_interface_hd_chnl_hip_en(hssi_tx_pld_pcs_interface_hd_chnl_hip_en), // disable|enable
      .hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en(hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en), // disable|enable
      .hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx(hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx), // disable|enable
      .hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en(hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en), // disable|enable
      .hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx(hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx), // fifo_tx|reg_tx|fastreg_tx
      .hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz(hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz),
      .hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz(hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz),
      .hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx(hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx), // pma_8b_tx|pma_10b_tx|pma_16b_tx|pma_20b_tx|pma_32b_tx|pma_40b_tx|pma_64b_tx|pcie_g3_dyn_dw_tx
      .hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz(hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz),
      .hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx(hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx), // disabled_prot_mode_tx|pcie_g1_capable_tx|pcie_g2_capable_tx|pcie_g3_capable_tx|gige_tx|teng_baser_tx|teng_basekr_krfec_tx|fortyg_basekr_krfec_tx|cpri_8b10b_tx|interlaken_tx|sfis_tx|teng_sdi_tx|gige_1588_tx|teng_1588_baser_tx|teng_1588_basekr_krfec_tx|basic_8gpcs_tx|basic_10gpcs_tx|basic_10gpcs_krfec_tx|pcs_direct_tx|uhsif_tx|prp_tx|prp_krfec_tx|prbs_tx|sqwave_tx
      .hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx(hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx), // single_tx|double_tx
      .hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode(hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode), // tx_rx_pair_enabled|tx_rx_independent
      .hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx(hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx), // teng_mode_tx|non_teng_mode_tx
      .hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx(hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx), // single_tx|double_tx
      .hssi_tx_pld_pcs_interface_hd_g3_prot_mode(hssi_tx_pld_pcs_interface_hd_g3_prot_mode), // pipe_g1|pipe_g2|pipe_g3|disabled_prot_mode
      .hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode(hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode), // tx_rx_pair_enabled|tx_rx_independent
      .hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx(hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx), // disable|enable
      .hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en(hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en), // disable|enable
      .hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx(hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx), // disabled_prot_mode_tx|teng_basekr_mode_tx|fortyg_basekr_mode_tx|teng_1588_basekr_mode_tx|basic_mode_tx
      .hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en(hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en), // disable|enable
      .hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx(hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx), // disabled_prot_mode_tx|eightg_and_g3_pld_fifo_mode_tx|eightg_and_g3_reg_mode_tx|eightg_and_g3_reg_mode_hip_tx|eightg_and_g3_fastreg_mode_tx|teng_pld_fifo_mode_tx|teng_reg_mode_tx|teng_fastreg_mode_tx|teng_and_krfec_pld_fifo_mode_tx|teng_and_krfec_reg_mode_tx|teng_and_krfec_fastreg_mode_tx|pcs_direct_fastreg_mode_tx|uhsif_mode_tx
      .hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode(hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode), // tx_rx_pair_enabled|tx_rx_independent
      .hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding(hssi_tx_pld_pcs_interface_hd_pmaif_ctrl_plane_bonding), // individual|ctrl_master|ctrl_slave_abv|ctrl_slave_blw
      .hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en(hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en), // disable|enable
      .hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx(hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx), // pma_8b_tx|pma_10b_tx|pma_16b_tx|pma_20b_tx|pma_32b_tx|pma_40b_tx|pma_64b_tx|pcie_g3_dyn_dw_tx
      .hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx(hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx), // disabled_prot_mode_tx|pcs_direct_mode_tx|uhsif_reg_mode_tx|uhsif_direct_mode_tx|eightg_only_pld_mode_tx|eightg_pcie_g12_pld_mode_tx|eightg_g3_pcie_g3_pld_mode_tx|eightg_pcie_g12_hip_mode_tx|eightg_g3_pcie_g3_hip_mode_tx|teng_krfec_mode_tx|eightg_basic_mode_tx|teng_basic_mode_tx|teng_sfis_sdi_mode_tx|prbs_mode_tx|sqwave_mode_tx
      .hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode(hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode), // disable|enable
      .hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel(hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel), // eightg_clk_out|teng_clk_out|pma_tx_clk|pma_tx_clk_user
      .hssi_tx_pld_pcs_interface_pcs_tx_clk_source(hssi_tx_pld_pcs_interface_pcs_tx_clk_source), // eightg|teng|pma_clk
      .hssi_tx_pld_pcs_interface_pcs_tx_data_source(hssi_tx_pld_pcs_interface_pcs_tx_data_source), // hip_disable|hip_enable
      .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en), // delay1_clk_enable|delay1_clk_disable
      .hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel(hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel), // pld_tx_clk|pcs_tx_clk
      .hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl(hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl), // delay1_path0|delay1_path1|delay1_path2|delay1_path3|delay1_path4
      .hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel(hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel), // one_ff_delay|two_ff_delay
      .hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en(hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en), // delay2_clk_enable|delay2_clk_disable
      .hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl(hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl), // delay2_path0|delay2_path1|delay2_path2|delay2_path3|delay2_path4
      .hssi_tx_pld_pcs_interface_pcs_tx_output_sel(hssi_tx_pld_pcs_interface_pcs_tx_output_sel), // krfec_output|teng_output
      .hssi_tx_pld_pcs_interface_reconfig_settings(hssi_tx_pld_pcs_interface_reconfig_settings)  //
    ) inst_twentynm_pcs (
      .in_avmmaddress                (chnl_pll_avmm_address         ),
      .in_avmmclk                    (chnl_pll_avmm_clk             ),
      .in_avmmread                   (chnl_pll_avmm_read            ),
      .in_avmmrstn                   (chnl_pll_avmm_rstn            ),
      .in_avmmwrite                  (chnl_pll_avmm_write           ),
      .in_avmmwritedata              (chnl_pll_avmm_writedata       ),
      .in_bond_pcs10g_in_bot         (in_bond_pcs10g_in_bot         ),
      .in_bond_pcs10g_in_top         (in_bond_pcs10g_in_top         ),
      .in_bond_pcs8g_in_bot          (in_bond_pcs8g_in_bot          ),
      .in_bond_pcs8g_in_top          (in_bond_pcs8g_in_top          ),
      .in_bond_pmaif_in_bot          (in_bond_pmaif_in_bot          ),
      .in_bond_pmaif_in_top          (in_bond_pmaif_in_top          ),
      .in_hip_tx_data                (in_hip_tx_data                ),
      .in_iocsr_clk                  ({bonded_lanes{1'b0}}          ),
      .in_iocsr_config               ({bonded_lanes{6'b0}}          ),
      .in_iocsr_rdy                  ({bonded_lanes{1'b1}}          ),
      .in_iocsr_rdy_dly              ({bonded_lanes{1'b1}}          ),
      .in_pld_10g_krfec_rx_clr_errblk_cnt(in_pld_10g_krfec_rx_clr_errblk_cnt),
      .in_pld_10g_krfec_rx_pld_rst_n (in_pld_10g_krfec_rx_pld_rst_n ),
      .in_pld_10g_krfec_tx_pld_rst_n (in_pld_10g_krfec_tx_pld_rst_n ),
      .in_pld_10g_rx_align_clr       (in_pld_10g_rx_align_clr       ),
      .in_pld_10g_rx_clr_ber_count   (in_pld_10g_rx_clr_ber_count   ),
      .in_pld_10g_rx_rd_en           (in_pld_10g_rx_rd_en           ),
      .in_pld_10g_tx_bitslip         (in_pld_10g_tx_bitslip         ),
      .in_pld_10g_tx_burst_en        (in_pld_10g_tx_burst_en        ),
      .in_pld_10g_tx_data_valid      (in_pld_10g_tx_data_valid      ),
      .in_pld_10g_tx_diag_status     (in_pld_10g_tx_diag_status     ),
      .in_pld_10g_tx_wordslip        (in_pld_10g_tx_wordslip        ),
      .in_pld_8g_a1a2_size           (in_pld_8g_a1a2_size           ),
      .in_pld_8g_bitloc_rev_en       (in_pld_8g_bitloc_rev_en       ),
      .in_pld_8g_byte_rev_en         (in_pld_8g_byte_rev_en         ),
      .in_pld_8g_eidleinfersel       (in_pld_8g_eidleinfersel       ),
      .in_pld_8g_encdt               (in_pld_8g_encdt               ),
      .in_pld_8g_g3_rx_pld_rst_n     (in_pld_8g_g3_rx_pld_rst_n     ),
      .in_pld_8g_g3_tx_pld_rst_n     (in_pld_8g_g3_tx_pld_rst_n     ),
      .in_pld_8g_rddisable_tx        (in_pld_8g_rddisable_tx        ),
      .in_pld_8g_rdenable_rx         (in_pld_8g_rdenable_rx         ),
      .in_pld_8g_refclk_dig2         (in_pld_8g_refclk_dig2         ),
      .in_pld_8g_rxpolarity          (in_pld_8g_rxpolarity          ),
      .in_pld_8g_tx_boundary_sel     (in_pld_8g_tx_boundary_sel     ),
      .in_pld_8g_wrdisable_rx        (in_pld_8g_wrdisable_rx        ),
      .in_pld_8g_wrenable_tx         (in_pld_8g_wrenable_tx         ),
      .in_pld_atpg_los_en_n          (in_pld_atpg_los_en_n          ),
      .in_pld_bitslip                (in_pld_bitslip                ),
      .in_pld_g3_current_coeff       (in_pld_g3_current_coeff       ),
      .in_pld_g3_current_rxpreset    (in_pld_g3_current_rxpreset    ),
      .in_pld_ltr                    (in_pld_ltr                    ),
      .in_pld_mem_krfec_atpg_rst_n   (in_pld_mem_krfec_atpg_rst_n   ),
      .in_pld_partial_reconfig       (in_pld_partial_reconfig       ),
      .in_pld_pcs_refclk_dig         (in_pld_pcs_refclk_dig         ),
      .in_pld_pma_adapt_start        (in_pld_pma_adapt_start        ),
      .in_pld_pma_csr_test_dis       ({bonded_lanes{1'b1}}          ),
      .in_pld_pma_early_eios         (in_pld_pma_early_eios         ),
      .in_pld_pma_eye_monitor        (in_pld_pma_eye_monitor        ),
      .in_pld_pma_ltd_b              (in_pld_pma_ltd_b              ),
      .in_pld_pma_nrpi_freeze        (                              ),
      .in_pld_pma_pcie_switch        (in_pld_pma_pcie_switch        ),
      .in_pld_pma_ppm_lock           (in_pld_pma_ppm_lock           ),
      .in_pld_pma_reserved_out       (in_pld_pma_reserved_out       ),
      .in_pld_pma_rs_lpbk_b          (in_pld_pma_rs_lpbk_b          ),
      .in_pld_pma_rx_qpi_pullup      (in_pld_pma_rx_qpi_pullup      ),
      .in_pld_pma_rxpma_rstb         (in_pld_pma_rxpma_rstb         ),
      .in_pld_pma_tx_bitslip         (in_pld_pma_tx_bitslip         ),
      .in_pld_pma_tx_bonding_rstb    (in_pld_pma_tx_bonding_rstb    ),
      .in_pld_pma_tx_qpi_pulldn      (in_pld_pma_tx_qpi_pulldn      ),
      .in_pld_pma_tx_qpi_pullup      (in_pld_pma_tx_qpi_pullup      ),
      .in_pld_pma_txdetectrx         (in_pld_pma_txdetectrx         ),
      .in_pld_pma_txpma_rstb         (in_pld_pma_txpma_rstb         ),
      .in_pld_pmaif_rx_pld_rst_n     (in_pld_pmaif_rx_pld_rst_n     ),
      .in_pld_pmaif_rxclkslip        (in_pld_pmaif_rxclkslip        ),
      .in_pld_pmaif_tx_pld_rst_n     (in_pld_pmaif_tx_pld_rst_n     ),
      .in_pld_polinv_rx              (in_pld_polinv_rx              ),
      .in_pld_polinv_tx              (in_pld_polinv_tx              ),
      .in_pld_rate                   (in_pld_rate                   ),
      .in_pld_reserved_in            (in_pld_reserved_in            ),
      .in_pld_rx_clk                 (in_pld_rx_clk                 ),
      .in_pld_rx_prbs_err_clr        (in_pld_rx_prbs_err_clr        ),
      .in_pld_scan_mode_n            ({bonded_lanes{1'b1}}          ),
      .in_pld_scan_shift_n           ({bonded_lanes{1'b1}}          ),
      .in_pld_syncsm_en              (in_pld_syncsm_en              ),
      .in_pld_tx_clk                 (in_pld_tx_clk                 ),
      .in_pld_tx_control             (in_pld_tx_control             ),
      .in_pld_tx_data                (in_pld_tx_data                ),
      .in_pld_txelecidle             (in_pld_txelecidle             ),
      .in_pld_uhsif_tx_clk           (in_pld_uhsif_tx_clk           ),
      .in_pma_adapt_done             (1'b0                          ),
      .in_pma_clklow                 (out_clklow                    ),
      .in_pma_fref                   (out_fref                      ),
      .in_pma_hclk                   (in_pma_hclk                   ),
      .in_pma_pcie_sw_done           (out_pcie_sw_done              ),
      .in_pma_pfdmode_lock           (out_pfdmode_lock              ),
      .in_pma_reserved_in            ({bonded_lanes{5'b1}}          ),
      .in_pma_rx_clkdiv_user         (out_clkdiv_rx_user            ),
      .in_pma_rx_detect_valid        (out_rx_detect_valid           ),
      .in_pma_rx_found               (out_rx_found                  ),
      .in_pma_rx_pma_clk             (out_clkdiv_rx                 ),
      .in_pma_rx_pma_data            (out_rxdata                    ),
      .in_pma_rx_signal_ok           (1'b1                          ),
      .in_pma_rxpll_lock             (out_rxpll_lock                ),
      .in_pma_signal_det             (out_sd                        ),
      .in_pma_testbus                ({bonded_lanes{8'b1}} /* to pm_tstmux */),
      .in_pma_tx_clkdiv_user         (out_clkdiv_tx_user            ),
      .in_pma_tx_pma_clk             (out_clkdiv_tx                 ),
      .out_avmmreaddata_hssi_10g_rx_pcs(out_avmmreaddata_hssi_10g_rx_pcs),
      .out_avmmreaddata_hssi_10g_tx_pcs(out_avmmreaddata_hssi_10g_tx_pcs),
      .out_avmmreaddata_hssi_8g_rx_pcs(out_avmmreaddata_hssi_8g_rx_pcs),
      .out_avmmreaddata_hssi_8g_tx_pcs(out_avmmreaddata_hssi_8g_tx_pcs),
      .out_avmmreaddata_hssi_common_pcs_pma_interface(out_avmmreaddata_hssi_common_pcs_pma_interface),
      .out_avmmreaddata_hssi_common_pld_pcs_interface(out_avmmreaddata_hssi_common_pld_pcs_interface),
      .out_avmmreaddata_hssi_fifo_rx_pcs(out_avmmreaddata_hssi_fifo_rx_pcs),
      .out_avmmreaddata_hssi_fifo_tx_pcs(out_avmmreaddata_hssi_fifo_tx_pcs),
      .out_avmmreaddata_hssi_gen3_rx_pcs(out_avmmreaddata_hssi_gen3_rx_pcs),
      .out_avmmreaddata_hssi_gen3_tx_pcs(out_avmmreaddata_hssi_gen3_tx_pcs),
      .out_avmmreaddata_hssi_krfec_rx_pcs(out_avmmreaddata_hssi_krfec_rx_pcs),
      .out_avmmreaddata_hssi_krfec_tx_pcs(out_avmmreaddata_hssi_krfec_tx_pcs),
      .out_avmmreaddata_hssi_pipe_gen1_2(out_avmmreaddata_hssi_pipe_gen1_2),
      .out_avmmreaddata_hssi_pipe_gen3(out_avmmreaddata_hssi_pipe_gen3),
      .out_avmmreaddata_hssi_rx_pcs_pma_interface(out_avmmreaddata_hssi_rx_pcs_pma_interface),
      .out_avmmreaddata_hssi_rx_pld_pcs_interface(out_avmmreaddata_hssi_rx_pld_pcs_interface),
      .out_avmmreaddata_hssi_tx_pcs_pma_interface(out_avmmreaddata_hssi_tx_pcs_pma_interface),
      .out_avmmreaddata_hssi_tx_pld_pcs_interface(out_avmmreaddata_hssi_tx_pld_pcs_interface),
      .out_blockselect_hssi_10g_rx_pcs(out_blockselect_hssi_10g_rx_pcs),
      .out_blockselect_hssi_10g_tx_pcs(out_blockselect_hssi_10g_tx_pcs),
      .out_blockselect_hssi_8g_rx_pcs(out_blockselect_hssi_8g_rx_pcs),
      .out_blockselect_hssi_8g_tx_pcs(out_blockselect_hssi_8g_tx_pcs),
      .out_blockselect_hssi_common_pcs_pma_interface(out_blockselect_hssi_common_pcs_pma_interface),
      .out_blockselect_hssi_common_pld_pcs_interface(out_blockselect_hssi_common_pld_pcs_interface),
      .out_blockselect_hssi_fifo_rx_pcs(out_blockselect_hssi_fifo_rx_pcs),
      .out_blockselect_hssi_fifo_tx_pcs(out_blockselect_hssi_fifo_tx_pcs),
      .out_blockselect_hssi_gen3_rx_pcs(out_blockselect_hssi_gen3_rx_pcs),
      .out_blockselect_hssi_gen3_tx_pcs(out_blockselect_hssi_gen3_tx_pcs),
      .out_blockselect_hssi_krfec_rx_pcs(out_blockselect_hssi_krfec_rx_pcs),
      .out_blockselect_hssi_krfec_tx_pcs(out_blockselect_hssi_krfec_tx_pcs),
      .out_blockselect_hssi_pipe_gen1_2(out_blockselect_hssi_pipe_gen1_2),
      .out_blockselect_hssi_pipe_gen3(out_blockselect_hssi_pipe_gen3),
      .out_blockselect_hssi_rx_pcs_pma_interface(out_blockselect_hssi_rx_pcs_pma_interface),
      .out_blockselect_hssi_rx_pld_pcs_interface(out_blockselect_hssi_rx_pld_pcs_interface),
      .out_blockselect_hssi_tx_pcs_pma_interface(out_blockselect_hssi_tx_pcs_pma_interface),
      .out_blockselect_hssi_tx_pld_pcs_interface(out_blockselect_hssi_tx_pld_pcs_interface),
      .out_bond_pcs10g_out_bot       (out_bond_pcs10g_out_bot       ),
      .out_bond_pcs10g_out_top       (out_bond_pcs10g_out_top       ),
      .out_bond_pcs8g_out_bot        (out_bond_pcs8g_out_bot        ),
      .out_bond_pcs8g_out_top        (out_bond_pcs8g_out_top        ),
      .out_bond_pmaif_out_bot        (out_bond_pmaif_out_bot        ),
      .out_bond_pmaif_out_top        (out_bond_pmaif_out_top        ),
      .out_hip_clk_out               (out_hip_clk_out               ),
      .out_hip_ctrl_out              (out_hip_ctrl_out              ),
      .out_hip_iocsr_rdy             (                              ),
      .out_hip_iocsr_rdy_dly         (                              ),
      .out_hip_nfrzdrv               (                              ),
      .out_hip_npor                  (out_hip_npor                  ),
      .out_hip_rx_data               (out_hip_rx_data               ),
      .out_hip_usermode              (                              ),
      .out_pld_10g_krfec_rx_blk_lock (out_pld_10g_krfec_rx_blk_lock ),
      .out_pld_10g_krfec_rx_diag_data_status(out_pld_10g_krfec_rx_diag_data_status),
      .out_pld_10g_krfec_rx_frame    (out_pld_10g_krfec_rx_frame    ),
      .out_pld_10g_krfec_tx_frame    (out_pld_10g_krfec_tx_frame    ),
      .out_pld_10g_rx_align_val      (out_pld_10g_rx_align_val      ),
      .out_pld_10g_rx_crc32_err      (out_pld_10g_rx_crc32_err      ),
      .out_pld_10g_rx_data_valid     (out_pld_10g_rx_data_valid     ),
      .out_pld_10g_rx_empty          (out_pld_10g_rx_empty          ),
      .out_pld_10g_rx_fifo_del       (out_pld_10g_rx_fifo_del       ),
      .out_pld_10g_rx_fifo_insert    (out_pld_10g_rx_fifo_insert    ),
      .out_pld_10g_rx_fifo_num       (out_pld_10g_rx_fifo_num       ),
      .out_pld_10g_rx_frame_lock     (out_pld_10g_rx_frame_lock     ),
      .out_pld_10g_rx_hi_ber         (out_pld_10g_rx_hi_ber         ),
      .out_pld_10g_rx_oflw_err       (out_pld_10g_rx_oflw_err       ),
      .out_pld_10g_rx_pempty         (out_pld_10g_rx_pempty         ),
      .out_pld_10g_rx_pfull          (out_pld_10g_rx_pfull          ),
      .out_pld_10g_tx_burst_en_exe   (out_pld_10g_tx_burst_en_exe   ),
      .out_pld_10g_tx_empty          (out_pld_10g_tx_empty          ),
      .out_pld_10g_tx_fifo_num       (out_pld_10g_tx_fifo_num       ),
      .out_pld_10g_tx_full           (out_pld_10g_tx_full           ),
      .out_pld_10g_tx_pempty         (out_pld_10g_tx_pempty         ),
      .out_pld_10g_tx_pfull          (out_pld_10g_tx_pfull          ),
      .out_pld_10g_tx_wordslip_exe   (out_pld_10g_tx_wordslip_exe   ),
      .out_pld_8g_a1a2_k1k2_flag     (out_pld_8g_a1a2_k1k2_flag     ),
      .out_pld_8g_empty_rmf          (out_pld_8g_empty_rmf          ),
      .out_pld_8g_empty_rx           (out_pld_8g_empty_rx           ),
      .out_pld_8g_empty_tx           (out_pld_8g_empty_tx           ),
      .out_pld_8g_full_rmf           (out_pld_8g_full_rmf           ),
      .out_pld_8g_full_rx            (out_pld_8g_full_rx            ),
      .out_pld_8g_full_tx            (out_pld_8g_full_tx            ),
      .out_pld_8g_rxelecidle         (out_pld_8g_rxelecidle         ),
      .out_pld_8g_signal_detect_out  (out_pld_8g_signal_detect_out  ),
      .out_pld_8g_wa_boundary        (out_pld_8g_wa_boundary        ),
      .out_pld_krfec_tx_alignment    (out_pld_krfec_tx_alignment    ),
      .out_pld_pcs_rx_clk_out        (out_pld_pcs_rx_clk_out        ),
      .out_pld_pcs_tx_clk_out        (out_pld_pcs_tx_clk_out        ),
      .out_pld_pma_adapt_done        (out_pld_pma_adapt_done        ),
      .out_pld_pma_clkdiv_rx_user    (out_pld_pma_clkdiv_rx_user    ),
      .out_pld_pma_clkdiv_tx_user    (out_pld_pma_clkdiv_tx_user    ),
      .out_pld_pma_clklow            (out_pld_pma_clklow            ),
      .out_pld_pma_fref              (out_pld_pma_fref              ),
      .out_pld_pma_hclk              (out_pld_pma_hclk              ),
      .out_pld_pma_pcie_sw_done      (out_pld_pma_pcie_sw_done      ),
      .out_pld_pma_pfdmode_lock      (out_pld_pma_pfdmode_lock      ),
      .out_pld_pma_reserved_in       (                              ),
      .out_pld_pma_rx_clk_out        (out_pld_pma_rx_clk_out        ),
      .out_pld_pma_rx_detect_valid   (out_pld_pma_rx_detect_valid   ),
      .out_pld_pma_rx_found          (out_pld_pma_rx_found          ),
      .out_pld_pma_rxpll_lock        (out_pld_pma_rxpll_lock        ),
      .out_pld_pma_signal_ok         (out_pld_pma_signal_ok         ),
      .out_pld_pma_testbus           (out_pld_pma_testbus           ),
      .out_pld_pma_tx_clk_out        (out_pld_pma_tx_clk_out        ),
      .out_pld_pmaif_mask_tx_pll     (out_pld_pmaif_mask_tx_pll     ),
      .out_pld_reserved_out          (out_pld_reserved_out          ),
      .out_pld_rx_control            (out_pld_rx_control            ),
      .out_pld_rx_data               (out_pld_rx_data               ),
      .out_pld_rx_prbs_done          (out_pld_rx_prbs_done          ),
      .out_pld_rx_prbs_err           (out_pld_rx_prbs_err           ),
      .out_pld_test_data             (out_pld_test_data             ),
      .out_pld_uhsif_lock            (out_pld_uhsif_lock            ),
      .out_pld_uhsif_tx_clk_out      (out_pld_uhsif_tx_clk_out      ),
      .out_pma_adapt_start           (                              ),
      .out_pma_atpg_los_en_n         (                              ),
      .out_pma_csr_test_dis          (                              ),
      .out_pma_current_coeff         (out_pma_current_coeff         ),
      .out_pma_current_rxpreset      (                              ),
      .out_pma_early_eios            (out_pma_early_eios            ),
      .out_pma_eye_monitor           (out_pma_eye_monitor           ),
      .out_pma_interface_select      (                              ),
      .out_pma_ltd_b                 (out_pma_ltd_b                 ),
      .out_pma_ltr                   (out_pma_ltr                   ),
      .out_pma_nfrzdrv               (                              ),
      .out_pma_nrpi_freeze           (                              ),
      .out_pma_pcie_switch           (out_pma_pcie_switch           ),
      .out_pma_ppm_lock              (out_pma_ppm_lock              ),
      .out_pma_reserved_out          (                              ),
      .out_pma_rs_lpbk_b             (out_pma_rs_lpbk_b             ),
      .out_pma_rx_clkslip            (out_pma_rx_clkslip            ),
      .out_pma_rx_qpi_pullup         (out_pma_rx_qpi_pullup         ),
      .out_pma_rxpma_rstb            (out_pma_rxpma_rstb            ),
      .out_pma_scan_mode_n           (                              ),
      .out_pma_scan_shift_n          (                              ),
      .out_pma_tx_bitslip            (out_pma_tx_bitslip            ),
      .out_pma_tx_bonding_rstb       (out_pma_tx_bonding_rstb       ),
      .out_pma_tx_elec_idle          (out_pma_tx_elec_idle          ),
      .out_pma_tx_pma_data           (out_pma_tx_pma_data           ),
      .out_pma_tx_qpi_pulldn         (out_pma_tx_qpi_pulldn         ),
      .out_pma_tx_qpi_pullup         (out_pma_tx_qpi_pullup         ),
      .out_pma_tx_txdetectrx         (out_pma_tx_txdetectrx         ),
      .out_pma_txpma_rstb            (out_pma_txpma_rstb            )
);


  twentynm_xcvr_avmm #(
      .avmm_interfaces               (avmm_interfaces               ), //Number of AVMM interfaces required - one for each bonded_lane, PLL, and Master CGB
      .rcfg_enable                   (rcfg_enable                   ), //Enable/disable reconfig interface in the Native PHY or PLL IP
      .enable_avmm                   (enable_avmm                   ), //Enable/disable AVMM atom instantiation
      .arbiter_ctrl                  (arbiter_ctrl                  ), //Calibration request at start-up. Valid values: "uc","pld".
      //"uc" =Initial calibration needed at start-up. Internal DPRIO interface is controlled by uC.
      //"pld"=Initial calibration is not needed at start-up. Internal DPRIO interface is controlled by PLD.
      .calibration_en                (calibration_en                ), //Indicates whether calibration by Hard Nios is enabled or not.Should be set to DISABLE in case if Nios is absent or needs to be bypassed. Valid values: enable, disable
      .avmm_busy_en                  (avmm_busy_en                  ), //Provides a separate interface for determining control of the AVMM bus, and separates its behavior from the avmm_waitreqeust
      .hip_cal_en                    (hip_cal_en                    ), //Indicates whether HIP is enabled or not. Valid values: disable, enable
      .cal_done                      (cal_done                      )  //Indicates whether calibration is done. This is the start-up value for the corresponding CRAM. THe CRAM is eventually accessed and updated by the Hard uC during calibration. Valid values: cal_done_assert, cal_done_deassert
    ) inst_twentynm_xcvr_avmm (
      // AVMM slave interface signals (user)
      .avmm_clk                      (avmm_clk                      ),
      .avmm_reset                    (avmm_reset                    ),
      .avmm_writedata                (avmm_writedata                ),
      .avmm_address                  (avmm_address                  ),
      .avmm_write                    (avmm_write                    ),
      .avmm_read                     (avmm_read                     ),
      .avmm_readdata                 (avmm_readdata                 ),
      .avmm_waitrequest              (avmm_waitrequest              ),
      //AVMM interface busy with calibration
      .avmm_busy                     (avmm_busy                     ),
      // Calibration Done
      .hip_cal_done                  (hip_cal_done                  ), //To HIP
      .pld_cal_done                  (pld_cal_done                  ), //To PLD
      // Channel/PLL AVMM interface signals (from AVMM atom fanned-out to all the Channel/PLL atoms)
      .chnl_pll_avmm_clk             (chnl_pll_avmm_clk             ),
      .chnl_pll_avmm_rstn            (chnl_pll_avmm_rstn            ),
      .chnl_pll_avmm_writedata       (chnl_pll_avmm_writedata       ), //Internal AVMM interface is 8-bit wide
      .chnl_pll_avmm_address         (chnl_pll_avmm_address         ),
      .chnl_pll_avmm_write           (chnl_pll_avmm_write           ),
      .chnl_pll_avmm_read            (chnl_pll_avmm_read            ),
      // PMA AVMM signals
      .pma_avmmreaddata_tx_ser       (out_avmmreaddata_pma_tx_ser   ), // TX SER readdata               (8 for each lane)
      .pma_avmmreaddata_tx_cgb       (out_avmmreaddata_pma_cgb      ), // TX Slave CGB readdata         (8 for each lane)
      .pma_avmmreaddata_tx_buf       (out_avmmreaddata_pma_tx_buf   ), // TX BUF readdata               (8 for each lane)
      .pma_avmmreaddata_rx_deser     (out_avmmreaddata_pma_rx_deser ), // RX Deser readdata             (8 for each lane)
      .pma_avmmreaddata_rx_buf       (out_avmmreaddata_pma_rx_buf   ), // RX BUF readdata               (8 for each lane)
      .pma_avmmreaddata_rx_sd        (out_avmmreaddata_pma_rx_sd    ), // RX SD readdata                (8 for each lane)
      .pma_avmmreaddata_rx_odi       (out_avmmreaddata_pma_rx_odi   ), // RX ODI readdata               (8 for each lane)
      .pma_avmmreaddata_rx_dfe       (out_avmmreaddata_pma_rx_dfe   ), // RX DFE readdata               (8 for each lane)
      .pma_avmmreaddata_cdr_pll      (out_avmmreaddata_cdr_pll      ), // CDR readdata               (8 for each lane)
      .pma_avmmreaddata_cdr_refclk_select(out_avmmreaddata_pma_cdr_refclk), // CDR refclk mux readdata    (8 for each lane)
      .pma_avmmreaddata_pma_adapt    (out_avmmreaddata_pma_adapt    ), // PMA adaptation readdata    (8 for each lane)
      .pma_blockselect_tx_ser        (out_blockselect_pma_tx_ser    ), // TX SER blockselect            (1 for each lane)
      .pma_blockselect_tx_cgb        (out_blockselect_pma_cgb       ), // TX Slave CGB blockselect      (1 for each lane)
      .pma_blockselect_tx_buf        (out_blockselect_pma_tx_buf    ), // TX BUF blockselect            (1 for each lane)
      .pma_blockselect_rx_deser      (out_blockselect_pma_rx_deser  ), // RX Deser blockselect          (1 for each lane)
      .pma_blockselect_rx_buf        (out_blockselect_pma_rx_buf    ), // RX BUF blockselect            (1 for each lane)
      .pma_blockselect_rx_sd         (out_blockselect_pma_rx_sd     ), // RX SD blockselect             (1 for each lane)
      .pma_blockselect_rx_odi        (out_blockselect_pma_rx_odi    ), // RX ODI blockselect            (1 for each lane)
      .pma_blockselect_rx_dfe        (out_blockselect_pma_rx_dfe    ), // RX DFE blockselect            (1 for each lane)
      .pma_blockselect_cdr_pll       (out_blockselect_cdr_pll       ), // CDR blockselect            (1 for each lane)
      .pma_blockselect_cdr_refclk_select(out_blockselect_pma_cdr_refclk), // CDR refclk mux blockselect (1 for each lane)
      .pma_blockselect_pma_adapt     (out_blockselect_pma_adapt     ), // PMA adaptation blockselect (1 for each lane)
      // PCS Channel AVMM signals
      .pcs_avmmreaddata_8g_rx_pcs    (out_avmmreaddata_hssi_8g_rx_pcs), // 8G RX PCS readdata            (8 for each lane)
      .pcs_avmmreaddata_pipe_gen1_2  (out_avmmreaddata_hssi_pipe_gen1_2), // Gen1/2 PIPE readdata          (8 for each lane)
      .pcs_avmmreaddata_8g_tx_pcs    (out_avmmreaddata_hssi_8g_tx_pcs), // 8G TX PCS readdata            (8 for each lane)
      .pcs_avmmreaddata_10g_rx_pcs   (out_avmmreaddata_hssi_10g_rx_pcs), // 10G RX PCS readdata           (8 for each lane)
      .pcs_avmmreaddata_10g_tx_pcs   (out_avmmreaddata_hssi_10g_tx_pcs), // 10G TX PCS readdata           (8 for each lane)
      .pcs_avmmreaddata_gen3_rx_pcs  (out_avmmreaddata_hssi_gen3_rx_pcs), // GEN3 RX PCS readdata          (8 for each lane)
      .pcs_avmmreaddata_pipe_gen3    (out_avmmreaddata_hssi_pipe_gen3), // GEN3 PIPE readdata            (8 for each lane)
      .pcs_avmmreaddata_gen3_tx_pcs  (out_avmmreaddata_hssi_gen3_tx_pcs), // GEN3 TX PCS readdata          (8 for each lane)
      .pcs_avmmreaddata_krfec_rx_pcs (out_avmmreaddata_hssi_krfec_rx_pcs), // KRFEC RX PCS readdata         (8 for each lane)
      .pcs_avmmreaddata_krfec_tx_pcs (out_avmmreaddata_hssi_krfec_tx_pcs), // KRFEC TX PCS readdata         (8 for each lane)
      .pcs_avmmreaddata_fifo_rx_pcs  (out_avmmreaddata_hssi_fifo_rx_pcs), // FIFO RX PCS readdata          (8 for each lane)
      .pcs_avmmreaddata_fifo_tx_pcs  (out_avmmreaddata_hssi_fifo_tx_pcs), // FIFO TX PCS readdata          (8 for each lane)
      .pcs_avmmreaddata_rx_pcs_pld_if(out_avmmreaddata_hssi_rx_pld_pcs_interface), // RX PCS PLD IF readdata        (8 for each lane)
      .pcs_avmmreaddata_com_pcs_pld_if(out_avmmreaddata_hssi_common_pld_pcs_interface), // COM PCS PLD IF readdata       (8 for each lane)
      .pcs_avmmreaddata_tx_pcs_pld_if(out_avmmreaddata_hssi_tx_pld_pcs_interface), // TX PCS PLD IF readdata        (8 for each lane)
      .pcs_avmmreaddata_rx_pcs_pma_if(out_avmmreaddata_hssi_rx_pcs_pma_interface), // RX PCS PMA IF readdata        (8 for each lane)
      .pcs_avmmreaddata_com_pcs_pma_if(out_avmmreaddata_hssi_common_pcs_pma_interface), // COm PCS PMA IF readdata       (8 for each lane)
      .pcs_avmmreaddata_tx_pcs_pma_if(out_avmmreaddata_hssi_tx_pcs_pma_interface), // TX PCS PMA IF readdata        (8 for each lane)
      .pcs_blockselect_8g_rx_pcs     (out_blockselect_hssi_8g_rx_pcs), // 8G RX PCS blockselect         (1 for each lane)
      .pcs_blockselect_pipe_gen1_2   (out_blockselect_hssi_pipe_gen1_2), // Gen1/2 PIPE blockselect       (1 for each lane)
      .pcs_blockselect_8g_tx_pcs     (out_blockselect_hssi_8g_tx_pcs), // 8G TX PCS blockselect         (1 for each lane)
      .pcs_blockselect_10g_rx_pcs    (out_blockselect_hssi_10g_rx_pcs), // 10G RX PCS blockselect        (1 for each lane)
      .pcs_blockselect_10g_tx_pcs    (out_blockselect_hssi_10g_tx_pcs), // 10G TX PCS blockselect        (1 for each lane)
      .pcs_blockselect_gen3_rx_pcs   (out_blockselect_hssi_gen3_rx_pcs), // GEN3 RX PCS blockselect       (1 for each lane)
      .pcs_blockselect_pipe_gen3     (out_blockselect_hssi_pipe_gen3), // GEN3 PIPE blockselect         (1 for each lane)
      .pcs_blockselect_gen3_tx_pcs   (out_blockselect_hssi_gen3_tx_pcs), // GEN3 TX PCS blockselect       (1 for each lane)
      .pcs_blockselect_krfec_rx_pcs  (out_blockselect_hssi_krfec_rx_pcs), // KRFEC RX PCS blockselect      (1 for each lane)
      .pcs_blockselect_krfec_tx_pcs  (out_blockselect_hssi_krfec_tx_pcs), // KRFEC TX PCS blockselect      (1 for each lane)
      .pcs_blockselect_fifo_rx_pcs   (out_blockselect_hssi_fifo_rx_pcs), // FIFO RX PCS blockselect       (1 for each lane)
      .pcs_blockselect_fifo_tx_pcs   (out_blockselect_hssi_fifo_tx_pcs), // FIFO TX PCS blockselect       (1 for each lane)
      .pcs_blockselect_rx_pcs_pld_if (out_blockselect_hssi_rx_pld_pcs_interface), // RX PCS PLD IF blockselect     (1 for each lane)
      .pcs_blockselect_com_pcs_pld_if(out_blockselect_hssi_common_pld_pcs_interface), // COM PCS PLD IF blockselect    (1 for each lane)
      .pcs_blockselect_tx_pcs_pld_if (out_blockselect_hssi_tx_pld_pcs_interface), // TX PCS PLD IF blockselect     (1 for each lane)
      .pcs_blockselect_rx_pcs_pma_if (out_blockselect_hssi_rx_pcs_pma_interface), // RX PCS PMA IF blockselect     (1 for each lane)
      .pcs_blockselect_com_pcs_pma_if(out_blockselect_hssi_common_pcs_pma_interface), // COM PCS PMA IF blockselect    (1 for each lane)
      .pcs_blockselect_tx_pcs_pma_if (out_blockselect_hssi_tx_pcs_pma_interface), // TX PCS PMA IF blockselect     (1 for each lane)
      // PLL AVMM signals
      .pll_avmmreaddata_lc_pll       ({bonded_lanes{8'b0}}          ), // LC PLL readdata                  (8 for each PLL)
      .pll_avmmreaddata_lc_refclk_select({bonded_lanes{8'b0}}          ), // LC Refclk Select Mux readdata    (8 for each PLL)
      .pll_avmmreaddata_cgb_master   ({bonded_lanes{8'b0}}          ), // Master CGB readdata              (8 for each PLL)
      .pll_avmmreaddata_cmu_fpll     ({bonded_lanes{8'b0}}          ), // CMU-FPLL readdata                (8 for each PLL)
      .pll_avmmreaddata_cmu_fpll_refclk_select({bonded_lanes{8'b0}}          ), // CMU-FPLL refclk mux readdata     (8 for each PLL)
      // CDR Tx PLL will connect to pma_avmmreaddata_cdr_pll and pma_avmmreaddata_cdr_refclk_select
      .pll_blockselect_lc_pll        ({bonded_lanes{1'b0}}          ), // LC PLL blockselect               (1 for each PLL)
      .pll_blockselect_lc_refclk_select({bonded_lanes{1'b0}}          ), // LC Refclk Select Mux blockselect (1 for each PLL)
      .pll_blockselect_cgb_master    ({bonded_lanes{1'b0}}          ), // Master CGB blockselect           (1 for each PLL)
      .pll_blockselect_cmu_fpll      ({bonded_lanes{1'b0}}          ), // CMU-FPLL blockselect             (1 for each PLL)
      .pll_blockselect_cmu_fpll_refclk_select({bonded_lanes{1'b0}}          )  // CMU-FPLL refclk mux blockselect  (1 for each PLL)
);
endmodule
module twentynm_xcvr_native_rev_20nm2 #(

        parameter bonded_lanes                   = 1,
        parameter bonding_master_ch              = 0,

    // twentynm_pma parameters
        parameter xcvr_native_mode               = "mode_duplex",       // mode_duplex, mode_rx_only, mode_tx_only
    // parameters for twentynm_hssi_pma_adaptation
        parameter pma_adapt_adapt_mode           = "dfe_vga",           // ctle|dfe_vga|ctle_vga|ctle_vga_dfe|manual
        parameter pma_adapt_adp_1s_ctle_bypass   = "radp_1s_ctle_bypass_0",// radp_1s_ctle_bypass_0|radp_1s_ctle_bypass_1
        parameter pma_adapt_adp_4s_ctle_bypass   = "radp_4s_ctle_bypass_0",// radp_4s_ctle_bypass_0|radp_4s_ctle_bypass_1
        parameter pma_adapt_adp_ctle_adapt_cycle_window = "radp_ctle_adapt_cycle_window_6",// radp_ctle_adapt_cycle_window_0|radp_ctle_adapt_cycle_window_1|radp_ctle_adapt_cycle_window_2|radp_ctle_adapt_cycle_window_3|radp_ctle_adapt_cycle_window_4|radp_ctle_adapt_cycle_window_5|radp_ctle_adapt_cycle_window_6|radp_ctle_adapt_cycle_window_7
        parameter pma_adapt_adp_ctle_en          = "radp_ctle_disable", // radp_ctle_disable|radp_ctle_enable
        parameter pma_adapt_adp_dfe_fltap_bypass = "radp_dfe_fltap_bypass_0",// radp_dfe_fltap_bypass_0|radp_dfe_fltap_bypass_1
        parameter pma_adapt_adp_dfe_fltap_en     = "radp_dfe_fltap_disable",// radp_dfe_fltap_disable|radp_dfe_fltap_enable
        parameter pma_adapt_adp_dfe_fxtap_bypass = "radp_dfe_fxtap_bypass_0",// radp_dfe_fxtap_bypass_0|radp_dfe_fxtap_bypass_1
        parameter pma_adapt_adp_dfe_fxtap_en     = "radp_dfe_fxtap_disable",// radp_dfe_fxtap_disable|radp_dfe_fxtap_enable
        parameter pma_adapt_adp_dfe_fxtap_hold_en = "radp_dfe_fxtap_not_held",// radp_dfe_fxtap_not_held|radp_dfe_fxtap_hold
        parameter pma_adapt_adp_dfe_mode         = "radp_dfe_mode_0",   // radp_dfe_mode_0|radp_dfe_mode_1|radp_dfe_mode_2|radp_dfe_mode_3|radp_dfe_mode_4|radp_dfe_mode_5|radp_dfe_mode_6|radp_dfe_mode_7
        parameter pma_adapt_adp_mode             = "radp_mode_0",       // radp_mode_0|radp_mode_1|radp_mode_2|radp_mode_3|radp_mode_4|radp_mode_5|radp_mode_6|radp_mode_7|radp_mode_8|radp_mode_9|radp_mode_10|radp_mode_11|radp_mode_12|radp_mode_13|radp_mode_14|radp_mode_15
        parameter pma_adapt_adp_onetime_dfe      = "radp_onetime_dfe_0",// radp_onetime_dfe_0|radp_onetime_dfe_1
        parameter pma_adapt_adp_vga_bypass       = "radp_vga_bypass_0", // radp_vga_bypass_0|radp_vga_bypass_1
        parameter pma_adapt_adp_vga_en           = "radp_vga_disable",  // radp_vga_disable|radp_vga_enable
        parameter pma_adapt_adp_vref_bypass      = "radp_vref_bypass_0",// radp_vref_bypass_0|radp_vref_bypass_1
        parameter pma_adapt_adp_vref_en          = "radp_vref_disable", // radp_vref_disable|radp_vref_enable
        parameter pma_adapt_datarate             = "0 bps",             //
        parameter pma_adapt_odi_dfe_spec_en      = "rodi_dfe_spec_en_0",// rodi_dfe_spec_en_0|rodi_dfe_spec_en_1
        parameter pma_adapt_prot_mode            = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_adapt_sup_mode             = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_pma_cdr_refclk_select_mux
        parameter pma_cdr_refclk_inclk0_logical_to_physical_mapping = "ref_iqclk0",// ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
        parameter pma_cdr_refclk_inclk1_logical_to_physical_mapping = "ref_iqclk0",// ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
        parameter pma_cdr_refclk_inclk2_logical_to_physical_mapping = "ref_iqclk0",// ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
        parameter pma_cdr_refclk_inclk3_logical_to_physical_mapping = "ref_iqclk0",// ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
        parameter pma_cdr_refclk_inclk4_logical_to_physical_mapping = "ref_iqclk0",// ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
        parameter pma_cdr_refclk_powerdown_mode  = "powerdown",         // powerup|powerdown
        parameter pma_cdr_refclk_refclk_select   = "ref_iqclk0",        // ref_iqclk0|ref_iqclk1|ref_iqclk2|ref_iqclk3|ref_iqclk4|ref_iqclk5|ref_iqclk6|ref_iqclk7|ref_iqclk8|ref_iqclk9|ref_iqclk10|ref_iqclk11|iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|coreclk|fixed_clk|lvpecl|adj_pll_clk|power_down
    // parameters for twentynm_hssi_pma_channel_pll
        parameter cdr_pll_atb_select_control     = "atb_off",           // atb_off|atb_select_tp_1|atb_select_tp_2|atb_select_tp_3|atb_select_tp_4|atb_select_tp_5|atb_select_tp_6|atb_select_tp_7|atb_select_tp_8|atb_select_tp_9|atb_select_tp_10|atb_select_tp_11|atb_select_tp_12|atb_select_tp_13|atb_select_tp_14|atb_select_tp_15|atb_select_tp_16|atb_select_tp_17|atb_select_tp_18|atb_select_tp_19|atb_select_tp_20|atb_select_tp_21|atb_select_tp_22|atb_select_tp_23|atb_select_tp_24|atb_select_tp_25|atb_select_tp_26|atb_select_tp_27|atb_select_tp_28|atb_select_tp_29|atb_select_tp_30|atb_select_tp_31|atb_select_tp_32|atb_select_tp_33|atb_select_tp_34|atb_select_tp_35|atb_select_tp_36|atb_select_tp_37|atb_select_tp_38|atb_select_tp_39|atb_select_tp_40|atb_select_tp_41|atb_select_tp_42|atb_select_tp_43|atb_select_tp_44|atb_select_tp_45|atb_select_tp_46|atb_select_tp_47|atb_select_tp_48|atb_select_tp_49|atb_select_tp_50|atb_select_tp_51|atb_select_tp_52|atb_select_tp_53|atb_select_tp_54|atb_select_tp_55|atb_select_tp_56|atb_select_tp_57|atb_select_tp_58|atb_select_tp_59|atb_select_tp_60|atb_select_tp_61|atb_select_tp_62|atb_select_tp_63
        parameter cdr_pll_auto_reset_on          = "auto_reset_on",     // auto_reset_on|auto_reset_off
        parameter cdr_pll_bbpd_data_pattern_filter_select = "bbpd_data_pat_off",// bbpd_data_pat_off|bbpd_data_pat_1|bbpd_data_pat_2|bbpd_data_pat_3
        parameter cdr_pll_bw_sel                 = "low",               // low|medium|high
        parameter cdr_pll_cal_vco_count_length   = "sel_8b_count",      // sel_8b_count|sel_12b_count
        parameter cdr_pll_cdr_odi_select         = "sel_cdr",           // sel_cdr|sel_odi
        parameter cdr_pll_cdr_phaselock_mode     = "no_ignore_lock",    // no_ignore_lock|ignore_lock
        parameter cdr_pll_cdr_powerdown_mode     = "power_down",        // power_down|power_up
        parameter cdr_pll_cgb_div                = 1,                   // 1|2|4|8
        parameter cdr_pll_chgpmp_current_dn_pd   = "cp_current_pd_dn_setting0",// cp_current_pd_dn_setting0|cp_current_pd_dn_setting1|cp_current_pd_dn_setting2|cp_current_pd_dn_setting3|cp_current_pd_dn_setting4
        parameter cdr_pll_chgpmp_current_dn_trim = "cp_current_trimming_dn_setting0",// cp_current_trimming_dn_setting0|cp_current_trimming_dn_setting1|cp_current_trimming_dn_setting2|cp_current_trimming_dn_setting3|cp_current_trimming_dn_setting4|cp_current_trimming_dn_setting5|cp_current_trimming_dn_setting6|cp_current_trimming_dn_setting7|cp_current_trimming_dn_setting8|cp_current_trimming_dn_setting9|cp_current_trimming_dn_setting10|cp_current_trimming_dn_setting11|cp_current_trimming_dn_setting12|cp_current_trimming_dn_setting13|cp_current_trimming_dn_setting14|cp_current_trimming_dn_setting15
        parameter cdr_pll_chgpmp_current_pd      = "cp_current_pd_setting0",// cp_current_pd_setting0|cp_current_pd_setting1|cp_current_pd_setting2|cp_current_pd_setting3|cp_current_pd_setting4
        parameter cdr_pll_chgpmp_current_pfd     = "cp_current_pfd_setting0",// cp_current_pfd_setting0|cp_current_pfd_setting1|cp_current_pfd_setting2|cp_current_pfd_setting3|cp_current_pfd_setting4
        parameter cdr_pll_chgpmp_current_up_pd   = "cp_current_pd_up_setting0",// cp_current_pd_up_setting0|cp_current_pd_up_setting1|cp_current_pd_up_setting2|cp_current_pd_up_setting3|cp_current_pd_up_setting4
        parameter cdr_pll_chgpmp_current_up_trim = "cp_current_trimming_up_setting0",// cp_current_trimming_up_setting0|cp_current_trimming_up_setting1|cp_current_trimming_up_setting2|cp_current_trimming_up_setting3|cp_current_trimming_up_setting4|cp_current_trimming_up_setting5|cp_current_trimming_up_setting6|cp_current_trimming_up_setting7|cp_current_trimming_up_setting8|cp_current_trimming_up_setting9|cp_current_trimming_up_setting10|cp_current_trimming_up_setting11|cp_current_trimming_up_setting12|cp_current_trimming_up_setting13|cp_current_trimming_up_setting14|cp_current_trimming_up_setting15
        parameter cdr_pll_chgpmp_dn_pd_trim_double = "normal_dn_trim_current",// normal_dn_trim_current|double_dn_trim_current
        parameter cdr_pll_chgpmp_replicate       = "false",             // false|true
        parameter cdr_pll_chgpmp_testmode        = "cp_test_disable",   // cp_test_disable|cp_test_up|cp_test_dn|cp_tristate
        parameter cdr_pll_chgpmp_up_pd_trim_double = "normal_up_trim_current",// normal_up_trim_current|double_up_trim_current
        parameter cdr_pll_clklow_mux_select      = "clklow_mux_cdr_fbclk",// clklow_mux_cdr_fbclk|clklow_mux_fpll_test1|clklow_mux_reserved_1|clklow_mux_rx_deser_pclk_test|clklow_mux_reserved_2|clklow_mux_reserved_3|clklow_mux_reserved_4|clklow_mux_dfe_test
        parameter cdr_pll_datarate               = "0 bps",             //
        parameter cdr_pll_diag_loopback_enable   = "false",             // true|false
        parameter cdr_pll_disable_up_dn          = "true",              // true|false
        parameter cdr_pll_fb_select              = "direct_fb",         // iqtxrxclk_fb|direct_fb
        parameter cdr_pll_fref_clklow_div        = 1,                   // 1|2|4|8
        parameter cdr_pll_fref_mux_select        = "fref_mux_cdr_refclk",// fref_mux_cdr_refclk|fref_mux_fpll_test0|fref_mux_reserved_1|fref_mux_tx_ser_pclk_test|fref_mux_reserved_2|fref_mux_reserved_3|fref_mux_reserved_4|fref_mux_reserved_5
        parameter cdr_pll_gpon_lck2ref_control   = "gpon_lck2ref_off",  // gpon_lck2ref_off|gpon_lck2ref_on
        parameter cdr_pll_initial_settings       = "false",             // false|true
        parameter cdr_pll_iqclk_mux_sel          = "power_down",        // iqtxrxclk0|iqtxrxclk1|iqtxrxclk2|iqtxrxclk3|iqtxrxclk4|iqtxrxclk5|power_down
        parameter cdr_pll_is_cascaded_pll        = "false",             // true|false
        parameter cdr_pll_lck2ref_delay_control  = "lck2ref_delay_off", // lck2ref_delay_off|lck2ref_delay_1|lck2ref_delay_2|lck2ref_delay_3|lck2ref_delay_4|lck2ref_delay_5|lck2ref_delay_6|lck2ref_delay_7
        parameter cdr_pll_lf_resistor_pd         = "lf_pd_setting0",    // lf_pd_setting0|lf_pd_setting1|lf_pd_setting2|lf_pd_setting3
        parameter cdr_pll_lf_resistor_pfd        = "lf_pfd_setting0",   // lf_pfd_setting0|lf_pfd_setting1|lf_pfd_setting2|lf_pfd_setting3
        parameter cdr_pll_lf_ripple_cap          = "lf_no_ripple",      // lf_no_ripple|lf_ripple_cap1
        parameter cdr_pll_loop_filter_bias_select = "lpflt_bias_off",   // lpflt_bias_off|lpflt_bias_1|lpflt_bias_2|lpflt_bias_3|lpflt_bias_4|lpflt_bias_5|lpflt_bias_6|lpflt_bias_7
        parameter cdr_pll_loopback_mode          = "loopback_disabled", // loopback_disabled|loopback_recovered_data|rx_refclk|rx_refclk_cdr_loopback|unused2|loopback_received_data|unused1
        parameter cdr_pll_lpd_counter            = 5'b1,
        parameter cdr_pll_lpfd_counter           = 5'b1,
        parameter cdr_pll_ltd_ltr_micro_controller_select = "ltd_ltr_pcs",// ltd_ltr_pcs|ltr_ucontroller|ltd_ucontroller
        parameter cdr_pll_m_counter              = 16,                  // 0..255
        parameter cdr_pll_n_counter              = 1,                   // 1|2|4|8
        parameter cdr_pll_n_counter_scratch      = 6'b1,
        parameter cdr_pll_output_clock_frequency = "0 hz",              //
        parameter cdr_pll_pcie_gen               = "non_pcie",          // pcie_gen1_100mhzref|pcie_gen2_100mhzref|pcie_gen3_100mhzref|pcie_gen1_125mhzref|pcie_gen2_125mhzref|pcie_gen3_125mhzref|non_pcie
        parameter cdr_pll_pd_fastlock_mode       = "false",             // false|true
        parameter cdr_pll_pd_l_counter           = 1,                   // 0|1|2|4|8|16
        parameter cdr_pll_pfd_l_counter          = 1,                   // 0|1|2|4|8|16|100
        parameter cdr_pll_pma_width              = 8,                   // 8|10|16|20|32|40|64
        parameter cdr_pll_primary_use            = "cmu",               // cmu|cdr
        parameter cdr_pll_prot_mode              = "unused",            // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter cdr_pll_reference_clock_frequency = "0 hz",           //
        parameter cdr_pll_reverse_serial_loopback = "no_loopback",      // no_loopback|loopback_data_no_posttap|loopback_data_with_posttap|loopback_data_0_1
        parameter cdr_pll_set_cdr_input_freq_range = 8'b0,
        parameter cdr_pll_set_cdr_v2i_enable     = "true",              // true|false
        parameter cdr_pll_set_cdr_vco_reset      = "false",             // true|false
        parameter cdr_pll_set_cdr_vco_speed      = 5'b1,
        parameter cdr_pll_set_cdr_vco_speed_fix  = 8'b0,
        parameter cdr_pll_set_cdr_vco_speed_pciegen3 = "cdr_vco_max_speedbin_pciegen3",// cdr_vco_min_speedbin_pciegen3|cdr_vco_max_speedbin_pciegen3
        parameter cdr_pll_sup_mode               = "user_mode",         // user_mode|engineering_mode
        parameter cdr_pll_tx_pll_prot_mode       = "txpll_unused",      // txpll_unused|txpll_enable_pcie|txpll_enable
        parameter cdr_pll_txpll_hclk_driver_enable = "false",           // true|false
        parameter cdr_pll_uc_ro_cal              = "uc_ro_cal_off",     // uc_ro_cal_off|uc_ro_cal_on
        parameter cdr_pll_vco_freq               = "0 hz",              //
        parameter cdr_pll_vco_overrange_voltage  = "vco_overrange_off", // vco_overrange_off|vco_overrange_ref_1|vco_overrange_ref_2|vco_overrange_ref_3
        parameter cdr_pll_vco_underrange_voltage = "vco_underange_off", // vco_underange_off|vco_underange_ref_1|vco_underange_ref_2|vco_underange_ref_3
    // parameters for twentynm_hssi_pma_rx_buf
        parameter pma_rx_buf_bypass_eqz_stages_234 = "bypass_off",      // bypass_off|byypass_stages_234
        parameter pma_rx_buf_datarate            = "0 bps",             //
        parameter pma_rx_buf_diag_lp_en          = "dlp_off",           // dlp_off|dlp_on
        parameter pma_rx_buf_loopback_modes      = "lpbk_disable",      // lpbk_disable|pre_cdr|post_cdr
        parameter pma_rx_buf_pm_tx_rx_cvp_mode   = "cvp_off",           // cvp_off|cvp_on
        parameter pma_rx_buf_pm_tx_rx_pcie_gen   = "non_pcie",          // pcie_gen1_100mhzref|pcie_gen2_100mhzref|pcie_gen3_100mhzref|pcie_gen1_125mhzref|pcie_gen2_125mhzref|pcie_gen3_125mhzref|non_pcie
        parameter pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth = "pcie_gen3_32b",// pcie_gen3_32b|pcie_gen3_16b
        parameter pma_rx_buf_prot_mode           = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_buf_qpi_enable          = "non_qpi_mode",      // non_qpi_mode|qpi_mode
        parameter pma_rx_buf_refclk_en           = "enable",            // disable|enable
        parameter pma_rx_buf_rx_refclk_divider   = "bypass_divider",    // bypass_divider|divide_by_2
        parameter pma_rx_buf_sup_mode            = "user_mode",         // user_mode|engineering_mode
        parameter pma_rx_buf_xrx_path_datarate   = "0 bps",             //
        parameter pma_rx_buf_xrx_path_datawidth  = 8'b0,
        parameter pma_rx_buf_xrx_path_pma_rx_divclk_hz = 32'b0,
        parameter pma_rx_buf_xrx_path_prot_mode  = "unused",            // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_buf_xrx_path_sup_mode   = "user_mode",         // user_mode|engineering_mode
        parameter pma_rx_buf_xrx_path_uc_cal_enable = "rx_cal_off",     // rx_cal_off|rx_cal_on
    // parameters for twentynm_hssi_pma_rx_deser
        parameter pma_rx_deser_bitslip_bypass    = "bs_bypass_no",      // bs_bypass_no|bs_bypass_yes
        parameter pma_rx_deser_clkdiv_source     = "vco_bypass_normal", // vco_bypass_normal|clklow_to_clkdivrx|fref_to_clkdivrx
        parameter pma_rx_deser_clkdivrx_user_mode = "clkdivrx_user_disabled",// clkdivrx_user_disabled|clkdivrx_user_clkdiv|clkdivrx_user_clkdiv_div2|clkdivrx_user_div40|clkdivrx_user_div33|clkdivrx_user_div66
        parameter pma_rx_deser_datarate          = "0 bps",             //
        parameter pma_rx_deser_deser_factor      = 8,                   // 8|10|16|20|32|40|64
        parameter pma_rx_deser_force_clkdiv_for_testing = "normal_clkdiv",// normal_clkdiv|forced_0|forced_1
        parameter pma_rx_deser_pcie_gen          = "non_pcie",          // pcie_gen1_100mhzref|pcie_gen2_100mhzref|pcie_gen3_100mhzref|pcie_gen1_125mhzref|pcie_gen2_125mhzref|pcie_gen3_125mhzref|non_pcie
        parameter pma_rx_deser_pcie_gen_bitwidth = "pcie_gen3_32b",     // pcie_gen3_32b|pcie_gen3_16b
        parameter pma_rx_deser_prot_mode         = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_deser_rst_n_adapt_odi   = "no_rst_adapt_odi",  // yes_rst_adapt_odi|no_rst_adapt_odi
        parameter pma_rx_deser_sdclk_enable      = "false",             // false|true
        parameter pma_rx_deser_sup_mode          = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_pma_rx_dfe
        parameter pma_rx_dfe_datarate            = "0 bps",             //
        parameter pma_rx_dfe_dft_en              = "dft_disable",       // dft_disable|dft_enalbe
        parameter pma_rx_dfe_pdb                 = "dfe_enable",        // dfe_powerdown|dfe_reset|dfe_enable
        parameter pma_rx_dfe_pdb_fixedtap        = "fixtap_dfe_powerdown",// fixtap_dfe_powerdown|fixtap_dfe_enable
        parameter pma_rx_dfe_pdb_floattap        = "floattap_dfe_powerdown",// floattap_dfe_powerdown|floattap_dfe_enable
        parameter pma_rx_dfe_pdb_fxtap4t7        = "fxtap4t7_powerdown",// fxtap4t7_powerdown|fxtap4t7_enable
        parameter pma_rx_dfe_prot_mode           = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_dfe_sup_mode            = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_pma_rx_odi
        parameter pma_rx_odi_datarate            = "0 bps",             //
        parameter pma_rx_odi_prot_mode           = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_odi_step_ctrl_sel       = "feedback_mode",     // dprio_mode|feedback_mode|jm_mode
        parameter pma_rx_odi_sup_mode            = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_pma_rx_sd
        parameter pma_rx_sd_prot_mode            = "basic_rx",          // basic_rx|pcie_gen1_rx|pcie_gen2_rx|pcie_gen3_rx|pcie_gen4_rx|qpi_rx|unused|gpon_rx|sata_rx
        parameter pma_rx_sd_sd_output_off        = 1,                   // 0..28
        parameter pma_rx_sd_sd_output_on         = 1,                   // 0..15
        parameter pma_rx_sd_sd_pdb               = "sd_off",            // sd_on|sd_off
        parameter pma_rx_sd_sup_mode             = "user_mode",         // user_mode|engineering_mode
    // parameters for twentynm_hssi_pma_tx_buf
        parameter pma_tx_buf_datarate            = "0 bps",             //
        parameter pma_tx_buf_mcgb_location_for_pcie = 4'b0,
        parameter pma_tx_buf_prot_mode           = "basic_tx",          // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
        parameter pma_tx_buf_rx_det              = "mode_0",            // mode_0|mode_1|mode_2|mode_3|mode_4|mode_5|mode_6|mode_7|mode_8|mode_9|mode_10|mode_11|mode_12|mode_13|mode_14|mode_15
        parameter pma_tx_buf_rx_det_output_sel   = "rx_det_pcie_out",   // rx_det_pcie_out|rx_det_qpi_out
        parameter pma_tx_buf_rx_det_pdb          = "rx_det_off",        // rx_det_off|rx_det_on
        parameter pma_tx_buf_sup_mode            = "user_mode",         // user_mode|engineering_mode
        parameter pma_tx_buf_user_fir_coeff_ctrl_sel = "ram_ctl",       // ram_ctl|dynamic_ctl
        parameter pma_tx_buf_xtx_path_clock_divider_ratio = 4'b0,
        parameter pma_tx_buf_xtx_path_datarate   = "0 bps",             //
        parameter pma_tx_buf_xtx_path_datawidth  = 8'b0,
        parameter pma_tx_buf_xtx_path_pma_tx_divclk_hz = 32'b0,
        parameter pma_tx_buf_xtx_path_prot_mode  = "basic_tx",          // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
        parameter pma_tx_buf_xtx_path_sup_mode   = "user_mode",         // user_mode|engineering_mode
        parameter pma_tx_buf_xtx_path_tx_pll_clk_hz = "0 hz",           //
    // parameters for twentynm_hssi_pma_tx_cgb
        parameter pma_cgb_bitslip_enable         = "enable_bitslip",    // disable_bitslip|enable_bitslip
        parameter pma_cgb_bonding_reset_enable   = "allow_bonding_reset",// disallow_bonding_reset|allow_bonding_reset
        parameter pma_cgb_datarate               = "0 bps",             //
        parameter pma_cgb_input_select_gen3      = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_input_select_x1        = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_input_select_xn        = "unused",            // sel_xn_up|sel_xn_dn|sel_x6_up|sel_x6_dn|sel_cgb_loc|unused
        parameter pma_cgb_pcie_gen3_bitwidth     = "pciegen3_wide",     // pciegen3_wide|pciegen3_narrow
        parameter pma_cgb_prot_mode              = "basic_tx",          // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
        parameter pma_cgb_scratch0_x1_clock_src  = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_scratch1_x1_clock_src  = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_scratch2_x1_clock_src  = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_scratch3_x1_clock_src  = "unused",            // lcpll_bot|lcpll_top|fpll_bot|fpll_top|cdr_txpll_b|cdr_txpll_t|same_ch_txpll|lcpll_hs|hfclk_xn_up|hfclk_x6_dn|hfclk_xn_dn|hfclk_x6_up|unused
        parameter pma_cgb_select_done_master_or_slave = "choose_slave_pcie_sw_done",// choose_master_pcie_sw_done|choose_slave_pcie_sw_done
        parameter pma_cgb_ser_mode               = "eight_bit",         // eight_bit|ten_bit|sixteen_bit|twenty_bit|thirty_two_bit|forty_bit|sixty_four_bit
        parameter pma_cgb_sup_mode               = "user_mode",         // user_mode|engineering_mode
        parameter pma_cgb_tx_ucontrol_en         = "disable",           // disable|enable
        parameter pma_cgb_x1_div_m_sel           = "divbypass",         // divbypass|divby2|divby4|divby8
    // parameters for twentynm_hssi_pma_tx_ser
        parameter pma_tx_ser_prot_mode           = "basic_tx",          // unused|basic_tx|pcie_gen1_tx|pcie_gen2_tx|pcie_gen3_tx|pcie_gen4_tx|qpi_tx|gpon_tx|sata_tx
        parameter pma_tx_ser_ser_clk_divtx_user_sel = "divtx_user_33",  // divtx_user_2|divtx_user_40|divtx_user_33|divtx_user_66|divtx_user_1|divtx_user_off
        parameter pma_tx_ser_sup_mode            = "user_mode",         // user_mode|engineering_mode

    // twentynm_pcs parameters
    // parameters for twentynm_hssi_10g_rx_pcs
        parameter hssi_10g_rx_pcs_advanced_user_mode = "disable",       // disable|enable
        parameter hssi_10g_rx_pcs_align_del      = "align_del_en",      // align_del_dis|align_del_en
        parameter hssi_10g_rx_pcs_ber_bit_err_total_cnt = "bit_err_total_cnt_10g",// bit_err_total_cnt_10g
        parameter hssi_10g_rx_pcs_ber_clken      = "ber_clk_dis",       // ber_clk_dis|ber_clk_en
        parameter hssi_10g_rx_pcs_ber_xus_timer_window = 21'b100110001001010,
        parameter hssi_10g_rx_pcs_bitslip_mode   = "bitslip_dis",       // bitslip_dis|bitslip_en
        parameter hssi_10g_rx_pcs_blksync_bitslip_type = "bitslip_comb",// bitslip_comb|bitslip_reg
        parameter hssi_10g_rx_pcs_blksync_bitslip_wait_cnt = 3'b1,
        parameter hssi_10g_rx_pcs_blksync_bitslip_wait_type = "bitslip_match",// bitslip_match|bitslip_cnt
        parameter hssi_10g_rx_pcs_blksync_bypass = "blksync_bypass_dis",// blksync_bypass_dis|blksync_bypass_en
        parameter hssi_10g_rx_pcs_blksync_clken  = "blksync_clk_dis",   // blksync_clk_dis|blksync_clk_en
        parameter hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt = "enum_invalid_sh_cnt_10g",// enum_invalid_sh_cnt_10g
        parameter hssi_10g_rx_pcs_blksync_knum