#include "stdio.h"
#include "stdlib.h"
#include <altera_avalon_pio_regs.h>
#include "system.h"
#include "altera_avalon_jtag_uart_regs.h"
#include "alt_types.h"
#include "io.h"

#define CH_NUMBER 11


char input_char(void)
{
	char in_char, rx_char;

	rx_char = 0;
	while (1)
	{
		in_char = getchar();
		if (in_char != '\r' && in_char != '\n')

			rx_char = in_char;
		else if (in_char == '\n')
			break;
	};
	return (rx_char);
}


int main()
{
	char rx_char;
	int  i;
	int  temp, control_reg;
	unsigned long NumBits_L[CH_NUMBER];
	unsigned long NumBits_H[CH_NUMBER];
	unsigned long ErrBits_L[CH_NUMBER];
	unsigned long ErrBits_H[CH_NUMBER];




	control_reg = 0x0000;
	IOWR(DATA_PATTERN_GENERATOR_0_BASE, 0, 0);
	IOWR(DATA_PATTERN_CHECKER_0_BASE, 0, 0);
	IOWR(DATA_PATTERN_GENERATOR_1_BASE, 0, 0);
	IOWR(DATA_PATTERN_CHECKER_1_BASE, 0, 0);
	IOWR(DATA_PATTERN_GENERATOR_2_BASE, 0, 0);
	IOWR(DATA_PATTERN_CHECKER_2_BASE, 0, 0);
	IOWR(DATA_PATTERN_GENERATOR_3_BASE, 0, 0);
	IOWR(DATA_PATTERN_CHECKER_3_BASE, 0, 0);
	IOWR(DATA_PATTERN_GENERATOR_4_BASE, 0, 0);
	IOWR(DATA_PATTERN_CHECKER_4_BASE, 0, 0);
	IOWR(DATA_PATTERN_GENERATOR_5_BASE, 0, 0);
	IOWR(DATA_PATTERN_CHECKER_5_BASE, 0, 0);
	IOWR(DATA_PATTERN_GENERATOR_6_BASE, 0, 0);
	IOWR(DATA_PATTERN_CHECKER_6_BASE, 0, 0);
	IOWR(DATA_PATTERN_GENERATOR_7_BASE, 0, 0);
	IOWR(DATA_PATTERN_CHECKER_7_BASE, 0, 0);
	IOWR(DATA_PATTERN_GENERATOR_8_BASE, 0, 0);
	IOWR(DATA_PATTERN_CHECKER_8_BASE, 0, 0);
	IOWR(DATA_PATTERN_GENERATOR_9_BASE, 0, 0);
	IOWR(DATA_PATTERN_CHECKER_9_BASE, 0, 0);
	IOWR(DATA_PATTERN_GENERATOR_10_BASE, 0, 0);
	IOWR(DATA_PATTERN_CHECKER_10_BASE, 0, 0);
	IOWR_ALTERA_AVALON_PIO_DATA(CONTROL_REG_BASE,control_reg);


	while(1)
	{
		IOWR(DATA_PATTERN_CHECKER_0_BASE, 2, 0x1);
		NumBits_L[0] = IORD(DATA_PATTERN_CHECKER_0_BASE, 3);
		NumBits_H[0] = IORD(DATA_PATTERN_CHECKER_0_BASE, 4);
		ErrBits_L[0] = IORD(DATA_PATTERN_CHECKER_0_BASE, 5);
		ErrBits_H[0] = IORD(DATA_PATTERN_CHECKER_0_BASE, 6);
		IOWR(DATA_PATTERN_CHECKER_1_BASE, 2, 0x1);
		NumBits_L[1] = IORD(DATA_PATTERN_CHECKER_1_BASE, 3);
		NumBits_H[1] = IORD(DATA_PATTERN_CHECKER_1_BASE, 4);
		ErrBits_L[1] = IORD(DATA_PATTERN_CHECKER_1_BASE, 5);
		ErrBits_H[1] = IORD(DATA_PATTERN_CHECKER_1_BASE, 6);
		IOWR(DATA_PATTERN_CHECKER_2_BASE, 2, 0x1);
		NumBits_L[2] = IORD(DATA_PATTERN_CHECKER_2_BASE, 3);
		NumBits_H[2] = IORD(DATA_PATTERN_CHECKER_2_BASE, 4);
		ErrBits_L[2] = IORD(DATA_PATTERN_CHECKER_2_BASE, 5);
		ErrBits_H[2] = IORD(DATA_PATTERN_CHECKER_2_BASE, 6);
		IOWR(DATA_PATTERN_CHECKER_3_BASE, 2, 0x1);
		NumBits_L[3] = IORD(DATA_PATTERN_CHECKER_3_BASE, 3);
		NumBits_H[3] = IORD(DATA_PATTERN_CHECKER_3_BASE, 4);
		ErrBits_L[3] = IORD(DATA_PATTERN_CHECKER_3_BASE, 5);
		ErrBits_H[3] = IORD(DATA_PATTERN_CHECKER_3_BASE, 6);
		IOWR(DATA_PATTERN_CHECKER_4_BASE, 2, 0x1);
		NumBits_L[4] = IORD(DATA_PATTERN_CHECKER_4_BASE, 3);
		NumBits_H[4] = IORD(DATA_PATTERN_CHECKER_4_BASE, 4);
		ErrBits_L[4] = IORD(DATA_PATTERN_CHECKER_4_BASE, 5);
		ErrBits_H[4] = IORD(DATA_PATTERN_CHECKER_4_BASE, 6);
		IOWR(DATA_PATTERN_CHECKER_5_BASE, 2, 0x1);
		NumBits_L[5] = IORD(DATA_PATTERN_CHECKER_5_BASE, 3);
		NumBits_H[5] = IORD(DATA_PATTERN_CHECKER_5_BASE, 4);
		ErrBits_L[5] = IORD(DATA_PATTERN_CHECKER_5_BASE, 5);
		ErrBits_H[5] = IORD(DATA_PATTERN_CHECKER_5_BASE, 6);
		IOWR(DATA_PATTERN_CHECKER_6_BASE, 2, 0x1);
		NumBits_L[6] = IORD(DATA_PATTERN_CHECKER_6_BASE, 3);
		NumBits_H[6] = IORD(DATA_PATTERN_CHECKER_6_BASE, 4);
		ErrBits_L[6] = IORD(DATA_PATTERN_CHECKER_6_BASE, 5);
		ErrBits_H[6] = IORD(DATA_PATTERN_CHECKER_6_BASE, 6);
		IOWR(DATA_PATTERN_CHECKER_7_BASE, 2, 0x1);
		NumBits_L[7] = IORD(DATA_PATTERN_CHECKER_7_BASE, 3);
		NumBits_H[7] = IORD(DATA_PATTERN_CHECKER_7_BASE, 4);
		ErrBits_L[7] = IORD(DATA_PATTERN_CHECKER_7_BASE, 5);
		ErrBits_H[7] = IORD(DATA_PATTERN_CHECKER_7_BASE, 6);
		IOWR(DATA_PATTERN_CHECKER_8_BASE, 2, 0x1);
		NumBits_L[8] = IORD(DATA_PATTERN_CHECKER_8_BASE, 3);
		NumBits_H[8] = IORD(DATA_PATTERN_CHECKER_8_BASE, 4);
		ErrBits_L[8] = IORD(DATA_PATTERN_CHECKER_8_BASE, 5);
		ErrBits_H[8] = IORD(DATA_PATTERN_CHECKER_8_BASE, 6);
		IOWR(DATA_PATTERN_CHECKER_9_BASE, 2, 0x1);
		NumBits_L[9] = IORD(DATA_PATTERN_CHECKER_9_BASE, 3);
		NumBits_H[9] = IORD(DATA_PATTERN_CHECKER_9_BASE, 4);
		ErrBits_L[9] = IORD(DATA_PATTERN_CHECKER_9_BASE, 5);
		ErrBits_H[9] = IORD(DATA_PATTERN_CHECKER_9_BASE, 6);
		IOWR(DATA_PATTERN_CHECKER_10_BASE, 2, 0x1);
		NumBits_L[10] = IORD(DATA_PATTERN_CHECKER_10_BASE, 3);
		NumBits_H[10] = IORD(DATA_PATTERN_CHECKER_10_BASE, 4);
		ErrBits_L[10] = IORD(DATA_PATTERN_CHECKER_10_BASE, 5);
		ErrBits_H[10] = IORD(DATA_PATTERN_CHECKER_10_BASE, 6);


		printf("Channel                                  :|");
		for (i = 0; i < CH_NUMBER ; i++)
		{
			printf("%10X|",i);
		}
		printf("\n");
		printf("Number of received bits[31:0]            :|");
		for (i = 0; i < CH_NUMBER ; i++)
		{
			printf("%10u|",NumBits_L[i]);
		}
		printf("\n");
		printf("Number of received bits[63:32]           :|");
		for (i = 0; i < CH_NUMBER ; i++)
		{
			printf("%10u|",NumBits_H[i]);
		}
		printf("\n");
		printf("Number of received Error bits[31:0]      :|");
		for (i = 0; i < CH_NUMBER ; i++)
		{
			printf("%10X|",ErrBits_L[i]);
		}
		printf("\n");
		printf("Number of received Error bits[63:32]     :|");
		for (i = 0; i < CH_NUMBER ; i++)
		{
			printf("%10X|",ErrBits_H[i]);
		}
		printf("\n");
		printf("PMA Internal Serial Loopback             :|");
		for (i = 0; i < CH_NUMBER ; i++)
		{
			switch (i){
			case 0 :
				temp = control_reg & (0x0001);
				if (temp == 0x0001)
					printf("    enable|");
				else
					printf("   disable|");
				break;
			case 1 :
				temp = control_reg & (0x0002);
				if (temp == 0x0002)
					printf("    enable|");
				else
					printf("   disable|");
				break;
			case 2 :
				temp = control_reg & (0x0004);
				if (temp == 0x0004)
					printf("    enable|");
				else
					printf("   disable|");
				break;
			case 3 :
				temp = control_reg & (0x0008);
				if (temp == 0x0008)
					printf("    enable|");
				else
					printf("   disable|");
				break;
			case 4 :
				temp = control_reg & (0x0010);
				if (temp == 0x0010)
					printf("    enable|");
				else
					printf("   disable|");
				break;
			case 5 :
				temp = control_reg & (0x0020);
				if (temp == 0x0020)
					printf("    enable|");
				else
					printf("   disable|");
				break;
			case 6 :
				temp = control_reg & (0x0040);
				if (temp == 0x0040)
					printf("    enable|");
				else
					printf("   disable|");
				break;
			case 7 :
				temp = control_reg & (0x0080);
				if (temp == 0x0080)
					printf("    enable|");
				else
					printf("   disable|");
				break;
			case 8 :
				temp = control_reg & (0x0100);
				if (temp == 0x0100)
					printf("    enable|");
				else
					printf("   disable|");
				break;
			case 9 :
				temp = control_reg & (0x0200);
				if (temp == 0x0200)
					printf("    enable|");
				else
					printf("   disable|");
				break;
			case 10 :
				temp = control_reg & (0x0400);
				if (temp == 0x0400)
					printf("    enable|");
				else
					printf("   disable|");
				break;
			}
		}
		printf("\n");


		printf("\nSelect Action : \n");
		printf("===============\n");
		printf("0. PRBS31 Generator/Checker on\n");
		printf("1. PRBS31 Generator/Checker off & Counter Reset\n");
		printf("2. PMA Serial Loopback on/off\n");

		rx_char = input_char();
		usleep(10);
		printf("input char : %c\n" , rx_char);

		switch (rx_char){
		case '0' :
			printf("Channel [0-a] ?\n");
			rx_char = input_char();
			usleep(10);
			printf("selected channel : %c\n" , rx_char);
			switch (rx_char){
			case '0' :
				IOWR(DATA_PATTERN_GENERATOR_0_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_GENERATOR_0_BASE, 0, 0x1);
				usleep(10);
				IOWR(DATA_PATTERN_CHECKER_0_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_CHECKER_0_BASE, 0, 0x1);
				break;
			case '1' :
				IOWR(DATA_PATTERN_GENERATOR_1_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_GENERATOR_1_BASE, 0, 0x1);
				usleep(10);
				IOWR(DATA_PATTERN_CHECKER_1_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_CHECKER_1_BASE, 0, 0x1);
				break;
			case '2' :
				IOWR(DATA_PATTERN_GENERATOR_2_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_GENERATOR_2_BASE, 0, 0x1);
				usleep(10);
				IOWR(DATA_PATTERN_CHECKER_2_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_CHECKER_2_BASE, 0, 0x1);
				break;
			case '3' :
				IOWR(DATA_PATTERN_GENERATOR_3_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_GENERATOR_3_BASE, 0, 0x1);
				usleep(10);
				IOWR(DATA_PATTERN_CHECKER_3_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_CHECKER_3_BASE, 0, 0x1);
				break;
			case '4' :
				IOWR(DATA_PATTERN_GENERATOR_4_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_GENERATOR_4_BASE, 0, 0x1);
				usleep(10);
				IOWR(DATA_PATTERN_CHECKER_4_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_CHECKER_4_BASE, 0, 0x1);
				break;
			case '5' :
				IOWR(DATA_PATTERN_GENERATOR_5_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_GENERATOR_5_BASE, 0, 0x1);
				usleep(10);
				IOWR(DATA_PATTERN_CHECKER_5_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_CHECKER_5_BASE, 0, 0x1);
				break;
			case '6' :
				IOWR(DATA_PATTERN_GENERATOR_6_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_GENERATOR_6_BASE, 0, 0x1);
				usleep(10);
				IOWR(DATA_PATTERN_CHECKER_6_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_CHECKER_6_BASE, 0, 0x1);
				break;
			case '7' :
				IOWR(DATA_PATTERN_GENERATOR_7_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_GENERATOR_7_BASE, 0, 0x1);
				usleep(10);
				IOWR(DATA_PATTERN_CHECKER_7_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_CHECKER_7_BASE, 0, 0x1);
				break;
			case '8' :
				IOWR(DATA_PATTERN_GENERATOR_8_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_GENERATOR_8_BASE, 0, 0x1);
				usleep(10);
				IOWR(DATA_PATTERN_CHECKER_8_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_CHECKER_8_BASE, 0, 0x1);
				break;
			case '9' :
				IOWR(DATA_PATTERN_GENERATOR_9_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_GENERATOR_9_BASE, 0, 0x1);
				usleep(10);
				IOWR(DATA_PATTERN_CHECKER_9_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_CHECKER_9_BASE, 0, 0x1);
				break;
			case 'a' :
				IOWR(DATA_PATTERN_GENERATOR_10_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_GENERATOR_10_BASE, 0, 0x1);
				usleep(10);
				IOWR(DATA_PATTERN_CHECKER_10_BASE, 1, 0x8);
				IOWR(DATA_PATTERN_CHECKER_10_BASE, 0, 0x1);
				break;
			}
			break;

			case '1' :
				printf("Channel [0-a] ?\n");
				rx_char = input_char();
				usleep(10);
				printf("selected channel : %c\n" , rx_char);
				switch (rx_char){
				case '0' :
					IOWR(DATA_PATTERN_GENERATOR_0_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_GENERATOR_0_BASE, 0, 0x0);
					usleep(10);
					IOWR(DATA_PATTERN_CHECKER_0_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_CHECKER_0_BASE, 0, 0x0);
					IOWR(DATA_PATTERN_CHECKER_0_BASE, 2, 0x2);
					break;
				case '1' :
					IOWR(DATA_PATTERN_GENERATOR_1_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_GENERATOR_1_BASE, 0, 0x0);
					usleep(10);
					IOWR(DATA_PATTERN_CHECKER_1_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_CHECKER_1_BASE, 0, 0x0);
					IOWR(DATA_PATTERN_CHECKER_1_BASE, 2, 0x2);
					break;
				case '2' :
					IOWR(DATA_PATTERN_GENERATOR_2_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_GENERATOR_2_BASE, 0, 0x0);
					usleep(10);
					IOWR(DATA_PATTERN_CHECKER_2_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_CHECKER_2_BASE, 0, 0x0);
					IOWR(DATA_PATTERN_CHECKER_2_BASE, 2, 0x2);
					break;
				case '3' :
					IOWR(DATA_PATTERN_GENERATOR_3_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_GENERATOR_3_BASE, 0, 0x0);
					usleep(10);
					IOWR(DATA_PATTERN_CHECKER_3_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_CHECKER_3_BASE, 0, 0x0);
					IOWR(DATA_PATTERN_CHECKER_3_BASE, 2, 0x2);
					break;
				case '4' :
					IOWR(DATA_PATTERN_GENERATOR_4_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_GENERATOR_4_BASE, 0, 0x0);
					usleep(10);
					IOWR(DATA_PATTERN_CHECKER_4_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_CHECKER_4_BASE, 0, 0x0);
					IOWR(DATA_PATTERN_CHECKER_4_BASE, 2, 0x2);
					break;
				case '5' :
					IOWR(DATA_PATTERN_GENERATOR_5_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_GENERATOR_5_BASE, 0, 0x0);
					usleep(10);
					IOWR(DATA_PATTERN_CHECKER_5_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_CHECKER_5_BASE, 0, 0x0);
					IOWR(DATA_PATTERN_CHECKER_5_BASE, 2, 0x2);
					break;
				case '6' :
					IOWR(DATA_PATTERN_GENERATOR_6_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_GENERATOR_6_BASE, 0, 0x0);
					usleep(10);
					IOWR(DATA_PATTERN_CHECKER_6_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_CHECKER_6_BASE, 0, 0x0);
					IOWR(DATA_PATTERN_CHECKER_6_BASE, 2, 0x2);
					break;
				case '7' :
					IOWR(DATA_PATTERN_GENERATOR_7_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_GENERATOR_7_BASE, 0, 0x0);
					usleep(10);
					IOWR(DATA_PATTERN_CHECKER_7_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_CHECKER_7_BASE, 0, 0x0);
					IOWR(DATA_PATTERN_CHECKER_7_BASE, 2, 0x2);
					break;
				case '8' :
					IOWR(DATA_PATTERN_GENERATOR_8_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_GENERATOR_8_BASE, 0, 0x0);
					usleep(10);
					IOWR(DATA_PATTERN_CHECKER_8_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_CHECKER_8_BASE, 0, 0x0);
					IOWR(DATA_PATTERN_CHECKER_8_BASE, 2, 0x2);
					break;
				case '9' :
					IOWR(DATA_PATTERN_GENERATOR_9_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_GENERATOR_9_BASE, 0, 0x0);
					usleep(10);
					IOWR(DATA_PATTERN_CHECKER_9_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_CHECKER_9_BASE, 0, 0x0);
					IOWR(DATA_PATTERN_CHECKER_9_BASE, 2, 0x2);
					break;
				case 'a' :
					IOWR(DATA_PATTERN_GENERATOR_10_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_GENERATOR_10_BASE, 0, 0x0);
					usleep(10);
					IOWR(DATA_PATTERN_CHECKER_10_BASE, 1, 0x8);
					IOWR(DATA_PATTERN_CHECKER_10_BASE, 0, 0x0);
					IOWR(DATA_PATTERN_CHECKER_10_BASE, 2, 0x2);
					break;
				}
				break;

				case '2' :
					printf("Channel [0-a] ?\n");
					rx_char = input_char();
					usleep(10);
					printf("selected channel : %c\n" , rx_char);
					switch (rx_char){
					case '0' :
						temp = control_reg & (0x0001);
						if (temp == 0x0000)
							control_reg = control_reg | (0x0001);
						else
							control_reg = control_reg & (0xFFFE);

						IOWR_ALTERA_AVALON_PIO_DATA(CONTROL_REG_BASE,control_reg);
						break;
					case '1' :
						temp = control_reg & (0x0002);
						if (temp == 0x0000)
							control_reg = control_reg | (0x0002);
						else
							control_reg = control_reg & (0xFFFD);

						IOWR_ALTERA_AVALON_PIO_DATA(CONTROL_REG_BASE,control_reg);
						break;
					case '2' :
						temp = control_reg & (0x0004);
						if (temp == 0x0000)
							control_reg = control_reg | (0x0004);
						else
							control_reg = control_reg & (0xFFFB);

						IOWR_ALTERA_AVALON_PIO_DATA(CONTROL_REG_BASE,control_reg);
						break;
					case '3' :
						temp = control_reg & (0x0008);
						if (temp == 0x0000)
							control_reg = control_reg | (0x0008);
						else
							control_reg = control_reg & (0xFFF7);

						IOWR_ALTERA_AVALON_PIO_DATA(CONTROL_REG_BASE,control_reg);
						break;
					case '4' :
						temp = control_reg & (0x0010);
						if (temp == 0x0000)
							control_reg = control_reg | (0x0010);
						else
							control_reg = control_reg & (0xFFEF);

						IOWR_ALTERA_AVALON_PIO_DATA(CONTROL_REG_BASE,control_reg);
						break;
					case '5' :
						temp = control_reg & (0x0020);
						if (temp == 0x0000)
							control_reg = control_reg | (0x0020);
						else
							control_reg = control_reg & (0xFFDF);

						IOWR_ALTERA_AVALON_PIO_DATA(CONTROL_REG_BASE,control_reg);
						break;
					case '6' :
						temp = control_reg & (0x0040);
						if (temp == 0x0000)
							control_reg = control_reg | (0x0040);
						else
							control_reg = control_reg & (0xFFBF);

						IOWR_ALTERA_AVALON_PIO_DATA(CONTROL_REG_BASE,control_reg);
						break;
					case '7' :
						temp = control_reg & (0x0080);
						if (temp == 0x0000)
							control_reg = control_reg | (0x0080);
						else
							control_reg = control_reg & (0xFF7F);

						IOWR_ALTERA_AVALON_PIO_DATA(CONTROL_REG_BASE,control_reg);
						break;
					case '8' :
						temp = control_reg & (0x0100);
						if (temp == 0x0000)
							control_reg = control_reg | (0x0100);
						else
							control_reg = control_reg & (0xFEFF);

						IOWR_ALTERA_AVALON_PIO_DATA(CONTROL_REG_BASE,control_reg);
						break;
					case '9' :
						temp = control_reg & (0x0200);
						if (temp == 0x0000)
							control_reg = control_reg | (0x0200);
						else
							control_reg = control_reg & (0xFDFF);

						IOWR_ALTERA_AVALON_PIO_DATA(CONTROL_REG_BASE,control_reg);
						break;
					case 'a' :
						temp = control_reg & (0x0400);
						if (temp == 0x0000)
							control_reg = control_reg | (0x0400);
						else
							control_reg = control_reg & (0xFBFF);

						IOWR_ALTERA_AVALON_PIO_DATA(CONTROL_REG_BASE,control_reg);
						break;
					}
					break;

		}
	}

	return 0;
}
