#!/bin/sh

#export ACDS=~/intelFPGA/17.1
#export QUARTUS_ROOTDIR=$ACDS/quartus
#export SOPC_KIT_NIOS2=$ACDS/nios2eds

#export PATH=$PATH:$QUARTUS_ROOTDIR/bin
#export PATH=$PATH:$SOPC_KIT_NIOS2/bin

export project_sof=./output_files/golden_top.sof
export project_jic=./output_files/magnes.jic
export device_sfl_sof=$QUARTUS_ROOTDIR/common/devinfo/programmer/sfl_enhanced_04_02ee60dd.sof


echo "Please Select Menu"
echo "0: Generate JIC"
echo "1: Program JIC"
echo "2: Program SOF"
echo "3: Exit"

DEVICE_POSITION=1

read CH

if [ $CH = "0" ]; then
	echo "Generate JIC"
	quartus_cpf -c -o bitstream_compression=on -d epcql1024 -s 10AX090N2F40E2SG $project_sof $project_jic
fi

if [ $CH = "1" ]; then
	echo "Program JIC"
	jtagconfig --setparam 1 JtagClock 16M
	quartus_pgm -m jtag -c 1 -o "p;$device_sfl_sof@$DEVICE_POSITION"
	quartus_pgm -m jtag -c 1 -o "p;$project_jic@$DEVICE_POSITION"
fi

if [ $CH = "2" ]; then
	echo "Program SOF"
	jtagconfig --setparam 1 JtagClock 16M
	quartus_pgm -m jtag -c 1 -o "p;$project_sof@$DEVICE_POSITION"
fi

if [ $CH = "3" ]; then
	echo "Exit"
fi

