// phy_g2x4.v

// Generated using ACDS version 17.1 593

`timescale 1 ps / 1 ps
module phy_g2x4 #(
		parameter device_revision                                                        = "20nm5",
		parameter duplex_mode                                                            = "duplex",
		parameter channels                                                               = 4,
		parameter enable_calibration                                                     = 1,
		parameter enable_analog_resets                                                   = 1,
		parameter enable_reset_sequence                                                  = 1,
		parameter bonded_mode                                                            = "pma_pcs",
		parameter pcs_bonding_master                                                     = 3,
		parameter plls                                                                   = 1,
		parameter number_physical_bonding_clocks                                         = 1,
		parameter cdr_refclk_cnt                                                         = 1,
		parameter enable_hip                                                             = 1,
		parameter hip_cal_en                                                             = "enable",
		parameter rcfg_enable                                                            = 1,
		parameter rcfg_shared                                                            = 1,
		parameter rcfg_jtag_enable                                                       = 0,
		parameter rcfg_separate_avmm_busy                                                = 0,
		parameter adme_prot_mode                                                         = "pipe_g2",
		parameter adme_data_rate                                                         = "5000000000",
		parameter enable_pcie_dfe_ip                                                     = 0,
		parameter sim_reduced_counters                                                   = 0,
		parameter disable_continuous_dfe                                                 = 0,
		parameter dbg_embedded_debug_enable                                              = 0,
		parameter dbg_capability_reg_enable                                              = 0,
		parameter dbg_user_identifier                                                    = 0,
		parameter dbg_stat_soft_logic_enable                                             = 0,
		parameter dbg_ctrl_soft_logic_enable                                             = 0,
		parameter dbg_prbs_soft_logic_enable                                             = 0,
		parameter dbg_odi_soft_logic_enable                                              = 0,
		parameter rcfg_emb_strm_enable                                                   = 0,
		parameter rcfg_profile_cnt                                                       = 2,
		parameter hssi_gen3_rx_pcs_block_sync                                            = "bypass_block_sync",
		parameter hssi_gen3_rx_pcs_block_sync_sm                                         = "disable_blk_sync_sm",
		parameter hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn                                 = "disable",
		parameter hssi_gen3_rx_pcs_lpbk_force                                            = "lpbk_frce_dis",
		parameter hssi_gen3_rx_pcs_mode                                                  = "disable_pcs",
		parameter hssi_gen3_rx_pcs_rate_match_fifo                                       = "bypass_rm_fifo",
		parameter hssi_gen3_rx_pcs_rate_match_fifo_latency                               = "low_latency",
		parameter hssi_gen3_rx_pcs_reverse_lpbk                                          = "rev_lpbk_dis",
		parameter hssi_gen3_rx_pcs_rx_b4gb_par_lpbk                                      = "b4gb_par_lpbk_dis",
		parameter hssi_gen3_rx_pcs_rx_force_balign                                       = "dis_force_balign",
		parameter hssi_gen3_rx_pcs_rx_ins_del_one_skip                                   = "ins_del_one_skip_dis",
		parameter hssi_gen3_rx_pcs_rx_num_fixed_pat                                      = 0,
		parameter hssi_gen3_rx_pcs_rx_test_out_sel                                       = "rx_test_out0",
		parameter hssi_gen3_rx_pcs_sup_mode                                              = "user_mode",
		parameter hssi_gen3_tx_pcs_mode                                                  = "disable_pcs",
		parameter hssi_gen3_tx_pcs_reverse_lpbk                                          = "rev_lpbk_dis",
		parameter hssi_gen3_tx_pcs_sup_mode                                              = "user_mode",
		parameter hssi_gen3_tx_pcs_tx_bitslip                                            = 0,
		parameter hssi_gen3_tx_pcs_tx_gbox_byp                                           = "bypass_gbox",
		parameter hssi_krfec_rx_pcs_blksync_cor_en                                       = "detect",
		parameter hssi_krfec_rx_pcs_bypass_gb                                            = "bypass_dis",
		parameter hssi_krfec_rx_pcs_clr_ctrl                                             = "both_enabled",
		parameter hssi_krfec_rx_pcs_ctrl_bit_reverse                                     = "ctrl_bit_reverse_en",
		parameter hssi_krfec_rx_pcs_data_bit_reverse                                     = "data_bit_reverse_dis",
		parameter hssi_krfec_rx_pcs_dv_start                                             = "with_blklock",
		parameter hssi_krfec_rx_pcs_err_mark_type                                        = "err_mark_10g",
		parameter hssi_krfec_rx_pcs_error_marking_en                                     = "err_mark_dis",
		parameter hssi_krfec_rx_pcs_low_latency_en                                       = "disable",
		parameter hssi_krfec_rx_pcs_lpbk_mode                                            = "lpbk_dis",
		parameter hssi_krfec_rx_pcs_parity_invalid_enum                                  = 8,
		parameter hssi_krfec_rx_pcs_parity_valid_num                                     = 4,
		parameter hssi_krfec_rx_pcs_pipeln_blksync                                       = "enable",
		parameter hssi_krfec_rx_pcs_pipeln_descrm                                        = "disable",
		parameter hssi_krfec_rx_pcs_pipeln_errcorrect                                    = "disable",
		parameter hssi_krfec_rx_pcs_pipeln_errtrap_ind                                   = "enable",
		parameter hssi_krfec_rx_pcs_pipeln_errtrap_lfsr                                  = "disable",
		parameter hssi_krfec_rx_pcs_pipeln_errtrap_loc                                   = "disable",
		parameter hssi_krfec_rx_pcs_pipeln_errtrap_pat                                   = "disable",
		parameter hssi_krfec_rx_pcs_pipeln_gearbox                                       = "enable",
		parameter hssi_krfec_rx_pcs_pipeln_syndrm                                        = "enable",
		parameter hssi_krfec_rx_pcs_pipeln_trans_dec                                     = "disable",
		parameter hssi_krfec_rx_pcs_prot_mode                                            = "disable_mode",
		parameter hssi_krfec_rx_pcs_receive_order                                        = "receive_lsb",
		parameter hssi_krfec_rx_pcs_rx_testbus_sel                                       = "overall",
		parameter hssi_krfec_rx_pcs_signal_ok_en                                         = "sig_ok_en",
		parameter hssi_krfec_rx_pcs_sup_mode                                             = "user_mode",
		parameter hssi_krfec_tx_pcs_burst_err                                            = "burst_err_dis",
		parameter hssi_krfec_tx_pcs_burst_err_len                                        = "burst_err_len1",
		parameter hssi_krfec_tx_pcs_ctrl_bit_reverse                                     = "ctrl_bit_reverse_en",
		parameter hssi_krfec_tx_pcs_data_bit_reverse                                     = "data_bit_reverse_dis",
		parameter hssi_krfec_tx_pcs_enc_frame_query                                      = "enc_query_dis",
		parameter hssi_krfec_tx_pcs_low_latency_en                                       = "disable",
		parameter hssi_krfec_tx_pcs_pipeln_encoder                                       = "enable",
		parameter hssi_krfec_tx_pcs_pipeln_scrambler                                     = "enable",
		parameter hssi_krfec_tx_pcs_prot_mode                                            = "disable_mode",
		parameter hssi_krfec_tx_pcs_sup_mode                                             = "user_mode",
		parameter hssi_krfec_tx_pcs_transcode_err                                        = "trans_err_dis",
		parameter hssi_krfec_tx_pcs_transmit_order                                       = "transmit_lsb",
		parameter hssi_krfec_tx_pcs_tx_testbus_sel                                       = "overall",
		parameter hssi_10g_rx_pcs_align_del                                              = "align_del_dis",
		parameter hssi_10g_rx_pcs_ber_bit_err_total_cnt                                  = "bit_err_total_cnt_10g",
		parameter hssi_10g_rx_pcs_ber_clken                                              = "ber_clk_dis",
		parameter hssi_10g_rx_pcs_ber_xus_timer_window                                   = 19530,
		parameter hssi_10g_rx_pcs_bitslip_mode                                           = "bitslip_dis",
		parameter hssi_10g_rx_pcs_blksync_bitslip_type                                   = "bitslip_comb",
		parameter hssi_10g_rx_pcs_blksync_bitslip_wait_cnt                               = 1,
		parameter hssi_10g_rx_pcs_blksync_bitslip_wait_type                              = "bitslip_cnt",
		parameter hssi_10g_rx_pcs_blksync_bypass                                         = "blksync_bypass_en",
		parameter hssi_10g_rx_pcs_blksync_clken                                          = "blksync_clk_dis",
		parameter hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt                            = "enum_invalid_sh_cnt_10g",
		parameter hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock                           = "knum_sh_cnt_postlock_10g",
		parameter hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock                            = "knum_sh_cnt_prelock_10g",
		parameter hssi_10g_rx_pcs_blksync_pipeln                                         = "blksync_pipeln_dis",
		parameter hssi_10g_rx_pcs_clr_errblk_cnt_en                                      = "disable",
		parameter hssi_10g_rx_pcs_control_del                                            = "control_del_none",
		parameter hssi_10g_rx_pcs_crcchk_bypass                                          = "crcchk_bypass_en",
		parameter hssi_10g_rx_pcs_crcchk_clken                                           = "crcchk_clk_dis",
		parameter hssi_10g_rx_pcs_crcchk_inv                                             = "crcchk_inv_en",
		parameter hssi_10g_rx_pcs_crcchk_pipeln                                          = "crcchk_pipeln_en",
		parameter hssi_10g_rx_pcs_crcflag_pipeln                                         = "crcflag_pipeln_en",
		parameter hssi_10g_rx_pcs_ctrl_bit_reverse                                       = "ctrl_bit_reverse_dis",
		parameter hssi_10g_rx_pcs_data_bit_reverse                                       = "data_bit_reverse_dis",
		parameter hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass                                 = "dec_64b66b_rxsm_bypass_en",
		parameter hssi_10g_rx_pcs_dec64b66b_clken                                        = "dec64b66b_clk_dis",
		parameter hssi_10g_rx_pcs_descrm_bypass                                          = "descrm_bypass_en",
		parameter hssi_10g_rx_pcs_descrm_clken                                           = "descrm_clk_dis",
		parameter hssi_10g_rx_pcs_descrm_mode                                            = "async",
		parameter hssi_10g_rx_pcs_descrm_pipeln                                          = "enable",
		parameter hssi_10g_rx_pcs_dft_clk_out_sel                                        = "rx_master_clk",
		parameter hssi_10g_rx_pcs_dis_signal_ok                                          = "dis_signal_ok_en",
		parameter hssi_10g_rx_pcs_dispchk_bypass                                         = "dispchk_bypass_en",
		parameter hssi_10g_rx_pcs_empty_flag_type                                        = "empty_rd_side",
		parameter hssi_10g_rx_pcs_fast_path                                              = "fast_path_en",
		parameter hssi_10g_rx_pcs_fec_clken                                              = "fec_clk_dis",
		parameter hssi_10g_rx_pcs_fec_enable                                             = "fec_dis",
		parameter hssi_10g_rx_pcs_fifo_double_read                                       = "fifo_double_read_dis",
		parameter hssi_10g_rx_pcs_fifo_stop_rd                                           = "n_rd_empty",
		parameter hssi_10g_rx_pcs_fifo_stop_wr                                           = "n_wr_full",
		parameter hssi_10g_rx_pcs_force_align                                            = "force_align_dis",
		parameter hssi_10g_rx_pcs_frmsync_bypass                                         = "frmsync_bypass_en",
		parameter hssi_10g_rx_pcs_frmsync_clken                                          = "frmsync_clk_dis",
		parameter hssi_10g_rx_pcs_frmsync_enum_scrm                                      = "enum_scrm_default",
		parameter hssi_10g_rx_pcs_frmsync_enum_sync                                      = "enum_sync_default",
		parameter hssi_10g_rx_pcs_frmsync_flag_type                                      = "location_only",
		parameter hssi_10g_rx_pcs_frmsync_knum_sync                                      = "knum_sync_default",
		parameter hssi_10g_rx_pcs_frmsync_mfrm_length                                    = 2048,
		parameter hssi_10g_rx_pcs_frmsync_pipeln                                         = "frmsync_pipeln_en",
		parameter hssi_10g_rx_pcs_full_flag_type                                         = "full_wr_side",
		parameter hssi_10g_rx_pcs_gb_rx_idwidth                                          = "width_64",
		parameter hssi_10g_rx_pcs_gb_rx_odwidth                                          = "width_64",
		parameter hssi_10g_rx_pcs_gbexp_clken                                            = "gbexp_clk_dis",
		parameter hssi_10g_rx_pcs_low_latency_en                                         = "disable",
		parameter hssi_10g_rx_pcs_lpbk_mode                                              = "lpbk_dis",
		parameter hssi_10g_rx_pcs_master_clk_sel                                         = "master_rx_pma_clk",
		parameter hssi_10g_rx_pcs_pempty_flag_type                                       = "pempty_rd_side",
		parameter hssi_10g_rx_pcs_pfull_flag_type                                        = "pfull_wr_side",
		parameter hssi_10g_rx_pcs_phcomp_rd_del                                          = "phcomp_rd_del2",
		parameter hssi_10g_rx_pcs_pld_if_type                                            = "fifo",
		parameter hssi_10g_rx_pcs_prot_mode                                              = "disable_mode",
		parameter hssi_10g_rx_pcs_rand_clken                                             = "rand_clk_dis",
		parameter hssi_10g_rx_pcs_rd_clk_sel                                             = "rd_rx_pld_clk",
		parameter hssi_10g_rx_pcs_rdfifo_clken                                           = "rdfifo_clk_dis",
		parameter hssi_10g_rx_pcs_rx_fifo_write_ctrl                                     = "blklock_stops",
		parameter hssi_10g_rx_pcs_rx_scrm_width                                          = "bit64",
		parameter hssi_10g_rx_pcs_rx_sh_location                                         = "msb",
		parameter hssi_10g_rx_pcs_rx_signal_ok_sel                                       = "synchronized_ver",
		parameter hssi_10g_rx_pcs_rx_sm_bypass                                           = "rx_sm_bypass_en",
		parameter hssi_10g_rx_pcs_rx_sm_hiber                                            = "rx_sm_hiber_en",
		parameter hssi_10g_rx_pcs_rx_sm_pipeln                                           = "rx_sm_pipeln_en",
		parameter hssi_10g_rx_pcs_rx_testbus_sel                                         = "rx_fifo_testbus1",
		parameter hssi_10g_rx_pcs_rx_true_b2b                                            = "b2b",
		parameter hssi_10g_rx_pcs_rxfifo_empty                                           = "empty_default",
		parameter hssi_10g_rx_pcs_rxfifo_full                                            = "full_default",
		parameter hssi_10g_rx_pcs_rxfifo_mode                                            = "phase_comp",
		parameter hssi_10g_rx_pcs_rxfifo_pempty                                          = 2,
		parameter hssi_10g_rx_pcs_rxfifo_pfull                                           = 23,
		parameter hssi_10g_rx_pcs_stretch_num_stages                                     = "zero_stage",
		parameter hssi_10g_rx_pcs_sup_mode                                               = "user_mode",
		parameter hssi_10g_rx_pcs_test_mode                                              = "test_off",
		parameter hssi_10g_rx_pcs_wrfifo_clken                                           = "wrfifo_clk_dis",
		parameter hssi_10g_rx_pcs_advanced_user_mode                                     = "disable",
		parameter hssi_10g_tx_pcs_bitslip_en                                             = "bitslip_dis",
		parameter hssi_10g_tx_pcs_bonding_dft_en                                         = "dft_dis",
		parameter hssi_10g_tx_pcs_bonding_dft_val                                        = "dft_0",
		parameter hssi_10g_tx_pcs_crcgen_bypass                                          = "crcgen_bypass_en",
		parameter hssi_10g_tx_pcs_crcgen_clken                                           = "crcgen_clk_dis",
		parameter hssi_10g_tx_pcs_crcgen_err                                             = "crcgen_err_dis",
		parameter hssi_10g_tx_pcs_crcgen_inv                                             = "crcgen_inv_en",
		parameter hssi_10g_tx_pcs_ctrl_bit_reverse                                       = "ctrl_bit_reverse_dis",
		parameter hssi_10g_tx_pcs_data_bit_reverse                                       = "data_bit_reverse_dis",
		parameter hssi_10g_tx_pcs_dft_clk_out_sel                                        = "tx_master_clk",
		parameter hssi_10g_tx_pcs_dispgen_bypass                                         = "dispgen_bypass_en",
		parameter hssi_10g_tx_pcs_dispgen_clken                                          = "dispgen_clk_dis",
		parameter hssi_10g_tx_pcs_dispgen_err                                            = "dispgen_err_dis",
		parameter hssi_10g_tx_pcs_dispgen_pipeln                                         = "dispgen_pipeln_dis",
		parameter hssi_10g_tx_pcs_empty_flag_type                                        = "empty_rd_side",
		parameter hssi_10g_tx_pcs_enc_64b66b_txsm_bypass                                 = "enc_64b66b_txsm_bypass_en",
		parameter hssi_10g_tx_pcs_enc64b66b_txsm_clken                                   = "enc64b66b_txsm_clk_dis",
		parameter hssi_10g_tx_pcs_fastpath                                               = "fastpath_en",
		parameter hssi_10g_tx_pcs_fec_clken                                              = "fec_clk_dis",
		parameter hssi_10g_tx_pcs_fec_enable                                             = "fec_dis",
		parameter hssi_10g_tx_pcs_fifo_double_write                                      = "fifo_double_write_dis",
		parameter hssi_10g_tx_pcs_fifo_reg_fast                                          = "fifo_reg_fast_dis",
		parameter hssi_10g_tx_pcs_fifo_stop_rd                                           = "rd_empty",
		parameter hssi_10g_tx_pcs_fifo_stop_wr                                           = "n_wr_full",
		parameter hssi_10g_tx_pcs_frmgen_burst                                           = "frmgen_burst_dis",
		parameter hssi_10g_tx_pcs_frmgen_bypass                                          = "frmgen_bypass_en",
		parameter hssi_10g_tx_pcs_frmgen_clken                                           = "frmgen_clk_dis",
		parameter hssi_10g_tx_pcs_frmgen_mfrm_length                                     = 2048,
		parameter hssi_10g_tx_pcs_frmgen_pipeln                                          = "frmgen_pipeln_en",
		parameter hssi_10g_tx_pcs_frmgen_pyld_ins                                        = "frmgen_pyld_ins_dis",
		parameter hssi_10g_tx_pcs_frmgen_wordslip                                        = "frmgen_wordslip_dis",
		parameter hssi_10g_tx_pcs_full_flag_type                                         = "full_wr_side",
		parameter hssi_10g_tx_pcs_gb_pipeln_bypass                                       = "disable",
		parameter hssi_10g_tx_pcs_gb_tx_idwidth                                          = "width_64",
		parameter hssi_10g_tx_pcs_gb_tx_odwidth                                          = "width_64",
		parameter hssi_10g_tx_pcs_gbred_clken                                            = "gbred_clk_dis",
		parameter hssi_10g_tx_pcs_low_latency_en                                         = "disable",
		parameter hssi_10g_tx_pcs_master_clk_sel                                         = "master_tx_pma_clk",
		parameter hssi_10g_tx_pcs_pempty_flag_type                                       = "pempty_rd_side",
		parameter hssi_10g_tx_pcs_pfull_flag_type                                        = "pfull_wr_side",
		parameter hssi_10g_tx_pcs_phcomp_rd_del                                          = "phcomp_rd_del2",
		parameter hssi_10g_tx_pcs_pld_if_type                                            = "fifo",
		parameter hssi_10g_tx_pcs_prot_mode                                              = "disable_mode",
		parameter hssi_10g_tx_pcs_pseudo_random                                          = "all_0",
		parameter hssi_10g_tx_pcs_pseudo_seed_a                                          = "288230376151711743",
		parameter hssi_10g_tx_pcs_pseudo_seed_b                                          = "288230376151711743",
		parameter hssi_10g_tx_pcs_random_disp                                            = "disable",
		parameter hssi_10g_tx_pcs_rdfifo_clken                                           = "rdfifo_clk_dis",
		parameter hssi_10g_tx_pcs_scrm_bypass                                            = "scrm_bypass_en",
		parameter hssi_10g_tx_pcs_scrm_clken                                             = "scrm_clk_dis",
		parameter hssi_10g_tx_pcs_scrm_mode                                              = "async",
		parameter hssi_10g_tx_pcs_scrm_pipeln                                            = "enable",
		parameter hssi_10g_tx_pcs_sh_err                                                 = "sh_err_dis",
		parameter hssi_10g_tx_pcs_sop_mark                                               = "sop_mark_dis",
		parameter hssi_10g_tx_pcs_stretch_num_stages                                     = "zero_stage",
		parameter hssi_10g_tx_pcs_sup_mode                                               = "user_mode",
		parameter hssi_10g_tx_pcs_test_mode                                              = "test_off",
		parameter hssi_10g_tx_pcs_tx_scrm_err                                            = "scrm_err_dis",
		parameter hssi_10g_tx_pcs_tx_scrm_width                                          = "bit64",
		parameter hssi_10g_tx_pcs_tx_sh_location                                         = "msb",
		parameter hssi_10g_tx_pcs_tx_sm_bypass                                           = "tx_sm_bypass_en",
		parameter hssi_10g_tx_pcs_tx_sm_pipeln                                           = "tx_sm_pipeln_en",
		parameter hssi_10g_tx_pcs_tx_testbus_sel                                         = "tx_fifo_testbus1",
		parameter hssi_10g_tx_pcs_txfifo_empty                                           = "empty_default",
		parameter hssi_10g_tx_pcs_txfifo_full                                            = "full_default",
		parameter hssi_10g_tx_pcs_txfifo_mode                                            = "phase_comp",
		parameter hssi_10g_tx_pcs_txfifo_pempty                                          = 2,
		parameter hssi_10g_tx_pcs_txfifo_pfull                                           = 11,
		parameter hssi_10g_tx_pcs_wr_clk_sel                                             = "wr_tx_pld_clk",
		parameter hssi_10g_tx_pcs_wrfifo_clken                                           = "wrfifo_clk_dis",
		parameter hssi_10g_tx_pcs_advanced_user_mode                                     = "disable",
		parameter hssi_8g_rx_pcs_auto_error_replacement                                  = "en_err_replace",
		parameter hssi_8g_rx_pcs_bit_reversal                                            = "dis_bit_reversal",
		parameter hssi_8g_rx_pcs_bonding_dft_en                                          = "dft_dis",
		parameter hssi_8g_rx_pcs_bonding_dft_val                                         = "dft_0",
		parameter hssi_8g_rx_pcs_bypass_pipeline_reg                                     = "dis_bypass_pipeline",
		parameter hssi_8g_rx_pcs_byte_deserializer                                       = "en_bds_by_4",
		parameter hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask                                   = "en_rxvalid_mask",
		parameter hssi_8g_rx_pcs_clkcmp_pattern_n                                        = 192892,
		parameter hssi_8g_rx_pcs_clkcmp_pattern_p                                        = 855683,
		parameter hssi_8g_rx_pcs_clock_gate_bds_dec_asn                                  = "dis_bds_dec_asn_clk_gating",
		parameter hssi_8g_rx_pcs_clock_gate_cdr_eidle                                    = "dis_cdr_eidle_clk_gating",
		parameter hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk                                  = "en_dw_pc_wrclk_gating",
		parameter hssi_8g_rx_pcs_clock_gate_dw_rm_rd                                     = "en_dw_rm_rdclk_gating",
		parameter hssi_8g_rx_pcs_clock_gate_dw_rm_wr                                     = "en_dw_rm_wrclk_gating",
		parameter hssi_8g_rx_pcs_clock_gate_dw_wa                                        = "en_dw_wa_clk_gating",
		parameter hssi_8g_rx_pcs_clock_gate_pc_rdclk                                     = "dis_pc_rdclk_gating",
		parameter hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk                                  = "dis_sw_pc_wrclk_gating",
		parameter hssi_8g_rx_pcs_clock_gate_sw_rm_rd                                     = "dis_sw_rm_rdclk_gating",
		parameter hssi_8g_rx_pcs_clock_gate_sw_rm_wr                                     = "dis_sw_rm_wrclk_gating",
		parameter hssi_8g_rx_pcs_clock_gate_sw_wa                                        = "dis_sw_wa_clk_gating",
		parameter hssi_8g_rx_pcs_clock_observation_in_pld_core                           = "internal_sw_wa_clk",
		parameter hssi_8g_rx_pcs_eidle_entry_eios                                        = "dis_eidle_eios",
		parameter hssi_8g_rx_pcs_eidle_entry_iei                                         = "dis_eidle_iei",
		parameter hssi_8g_rx_pcs_eidle_entry_sd                                          = "en_eidle_sd",
		parameter hssi_8g_rx_pcs_eightb_tenb_decoder                                     = "en_8b10b_ibm",
		parameter hssi_8g_rx_pcs_err_flags_sel                                           = "err_flags_wa",
		parameter hssi_8g_rx_pcs_fixed_pat_det                                           = "dis_fixed_patdet",
		parameter hssi_8g_rx_pcs_fixed_pat_num                                           = 0,
		parameter hssi_8g_rx_pcs_force_signal_detect                                     = "en_force_signal_detect",
		parameter hssi_8g_rx_pcs_gen3_clk_en                                             = "disable_clk",
		parameter hssi_8g_rx_pcs_gen3_rx_clk_sel                                         = "rcvd_clk",
		parameter hssi_8g_rx_pcs_gen3_tx_clk_sel                                         = "tx_pma_clk",
		parameter hssi_8g_rx_pcs_hip_mode                                                = "en_hip",
		parameter hssi_8g_rx_pcs_ibm_invalid_code                                        = "dis_ibm_invalid_code",
		parameter hssi_8g_rx_pcs_invalid_code_flag_only                                  = "dis_invalid_code_only",
		parameter hssi_8g_rx_pcs_pad_or_edb_error_replace                                = "replace_edb_dynamic",
		parameter hssi_8g_rx_pcs_pcs_bypass                                              = "dis_pcs_bypass",
		parameter hssi_8g_rx_pcs_phase_comp_rdptr                                        = "disable_rdptr",
		parameter hssi_8g_rx_pcs_phase_compensation_fifo                                 = "register_fifo",
		parameter hssi_8g_rx_pcs_pipe_if_enable                                          = "en_pipe3_rx",
		parameter hssi_8g_rx_pcs_pma_dw                                                  = "ten_bit",
		parameter hssi_8g_rx_pcs_polinv_8b10b_dec                                        = "en_polinv_8b10b_dec",
		parameter hssi_8g_rx_pcs_prot_mode                                               = "pipe_g2",
		parameter hssi_8g_rx_pcs_rate_match                                              = "pipe_rm",
		parameter hssi_8g_rx_pcs_rate_match_del_thres                                    = "pipe_rm_del_thres",
		parameter hssi_8g_rx_pcs_rate_match_empty_thres                                  = "pipe_rm_empty_thres",
		parameter hssi_8g_rx_pcs_rate_match_full_thres                                   = "pipe_rm_full_thres",
		parameter hssi_8g_rx_pcs_rate_match_ins_thres                                    = "pipe_rm_ins_thres",
		parameter hssi_8g_rx_pcs_rate_match_start_thres                                  = "pipe_rm_start_thres",
		parameter hssi_8g_rx_pcs_rx_clk_free_running                                     = "en_rx_clk_free_run",
		parameter hssi_8g_rx_pcs_rx_clk2                                                 = "tx_pma_clock_clk2",
		parameter hssi_8g_rx_pcs_rx_pcs_urst                                             = "en_rx_pcs_urst",
		parameter hssi_8g_rx_pcs_rx_rcvd_clk                                             = "rcvd_clk_rcvd_clk",
		parameter hssi_8g_rx_pcs_rx_rd_clk                                               = "rx_clk",
		parameter hssi_8g_rx_pcs_rx_refclk                                               = "dis_refclk_sel",
		parameter hssi_8g_rx_pcs_rx_wr_clk                                               = "txfifo_rd_clk",
		parameter hssi_8g_rx_pcs_sup_mode                                                = "user_mode",
		parameter hssi_8g_rx_pcs_symbol_swap                                             = "dis_symbol_swap",
		parameter hssi_8g_rx_pcs_sync_sm_idle_eios                                       = "en_syncsm_idle",
		parameter hssi_8g_rx_pcs_test_bus_sel                                            = "tx_testbus",
		parameter hssi_8g_rx_pcs_tx_rx_parallel_loopback                                 = "dis_plpbk",
		parameter hssi_8g_rx_pcs_wa_boundary_lock_ctrl                                   = "sync_sm",
		parameter hssi_8g_rx_pcs_wa_clk_slip_spacing                                     = 16,
		parameter hssi_8g_rx_pcs_wa_det_latency_sync_status_beh                          = "dont_care_assert_sync",
		parameter hssi_8g_rx_pcs_wa_disp_err_flag                                        = "en_disp_err_flag",
		parameter hssi_8g_rx_pcs_wa_kchar                                                = "dis_kchar",
		parameter hssi_8g_rx_pcs_wa_pd                                                   = "wa_pd_10",
		parameter hssi_8g_rx_pcs_wa_pd_data                                              = "380",
		parameter hssi_8g_rx_pcs_wa_pd_polarity                                          = "dont_care_both_pol",
		parameter hssi_8g_rx_pcs_wa_pld_controlled                                       = "dis_pld_ctrl",
		parameter hssi_8g_rx_pcs_wa_renumber_data                                        = 16,
		parameter hssi_8g_rx_pcs_wa_rgnumber_data                                        = 15,
		parameter hssi_8g_rx_pcs_wa_rknumber_data                                        = 3,
		parameter hssi_8g_rx_pcs_wa_rosnumber_data                                       = 0,
		parameter hssi_8g_rx_pcs_wa_rvnumber_data                                        = 0,
		parameter hssi_8g_rx_pcs_wa_sync_sm_ctrl                                         = "pipe_sync_sm",
		parameter hssi_8g_rx_pcs_wait_cnt                                                = 0,
		parameter hssi_8g_tx_pcs_bit_reversal                                            = "dis_bit_reversal",
		parameter hssi_8g_tx_pcs_bonding_dft_en                                          = "dft_dis",
		parameter hssi_8g_tx_pcs_bonding_dft_val                                         = "dft_0",
		parameter hssi_8g_tx_pcs_bypass_pipeline_reg                                     = "dis_bypass_pipeline",
		parameter hssi_8g_tx_pcs_byte_serializer                                         = "en_bs_by_4",
		parameter hssi_8g_tx_pcs_clock_gate_bs_enc                                       = "dis_bs_enc_clk_gating",
		parameter hssi_8g_tx_pcs_clock_gate_dw_fifowr                                    = "en_dw_fifowr_clk_gating",
		parameter hssi_8g_tx_pcs_clock_gate_fiford                                       = "dis_fiford_clk_gating",
		parameter hssi_8g_tx_pcs_clock_gate_sw_fifowr                                    = "dis_sw_fifowr_clk_gating",
		parameter hssi_8g_tx_pcs_clock_observation_in_pld_core                           = "internal_refclk_b",
		parameter hssi_8g_tx_pcs_data_selection_8b10b_encoder_input                      = "normal_data_path",
		parameter hssi_8g_tx_pcs_dynamic_clk_switch                                      = "dis_dyn_clk_switch",
		parameter hssi_8g_tx_pcs_eightb_tenb_disp_ctrl                                   = "en_disp_ctrl",
		parameter hssi_8g_tx_pcs_eightb_tenb_encoder                                     = "en_8b10b_ibm",
		parameter hssi_8g_tx_pcs_force_echar                                             = "dis_force_echar",
		parameter hssi_8g_tx_pcs_force_kchar                                             = "dis_force_kchar",
		parameter hssi_8g_tx_pcs_gen3_tx_clk_sel                                         = "dis_tx_clk",
		parameter hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel                                    = "func_clk",
		parameter hssi_8g_tx_pcs_hip_mode                                                = "en_hip",
		parameter hssi_8g_tx_pcs_pcs_bypass                                              = "dis_pcs_bypass",
		parameter hssi_8g_tx_pcs_phase_comp_rdptr                                        = "disable_rdptr",
		parameter hssi_8g_tx_pcs_phase_compensation_fifo                                 = "register_fifo",
		parameter hssi_8g_tx_pcs_phfifo_write_clk_sel                                    = "tx_clk",
		parameter hssi_8g_tx_pcs_pma_dw                                                  = "ten_bit",
		parameter hssi_8g_tx_pcs_prot_mode                                               = "pipe_g2",
		parameter hssi_8g_tx_pcs_refclk_b_clk_sel                                        = "tx_pma_clock",
		parameter hssi_8g_tx_pcs_revloop_back_rm                                         = "en_rev_loopback_rx_rm",
		parameter hssi_8g_tx_pcs_sup_mode                                                = "user_mode",
		parameter hssi_8g_tx_pcs_symbol_swap                                             = "dis_symbol_swap",
		parameter hssi_8g_tx_pcs_tx_bitslip                                              = "dis_tx_bitslip",
		parameter hssi_8g_tx_pcs_tx_compliance_controlled_disparity                      = "en_txcompliance_pipe3p0",
		parameter hssi_8g_tx_pcs_tx_fast_pld_reg                                         = "dis_tx_fast_pld_reg",
		parameter hssi_8g_tx_pcs_txclk_freerun                                           = "en_freerun_tx",
		parameter hssi_8g_tx_pcs_txpcs_urst                                              = "en_txpcs_urst",
		parameter hssi_tx_pld_pcs_interface_hd_chnl_hip_en                               = "enable",
		parameter hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en                         = "enable",
		parameter hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx                         = "pcie_g2_capable_tx",
		parameter hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx                = "ctrl_master_tx",
		parameter hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx                            = "pma_10b_tx",
		parameter hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx                     = "reg_tx",
		parameter hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx                 = "single_tx",
		parameter hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx                    = "disable",
		parameter hssi_tx_pld_pcs_interface_hd_chnl_func_mode                            = "enable",
		parameter hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode               = "tx_rx_pair_enabled",
		parameter hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en                              = "disable",
		parameter hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en                   = "enable",
		parameter hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz                        = 500000000,
		parameter hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz                        = 0,
		parameter hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz                  = 0,
		parameter hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode               = "tx_rx_pair_enabled",
		parameter hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx                         = "non_teng_mode_tx",
		parameter hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx                 = "single_tx",
		parameter hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode                = "tx_rx_pair_enabled",
		parameter hssi_tx_pld_pcs_interface_hd_10g_lpbk_en                               = "disable",
		parameter hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx                 = "disable",
		parameter hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx                             = "pma_64b_tx",
		parameter hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx                          = "fifo_tx",
		parameter hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx                          = "disabled_prot_mode_tx",
		parameter hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx                     = "disable",
		parameter hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx                  = "single_tx",
		parameter hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode                 = "tx_rx_pair_enabled",
		parameter hssi_tx_pld_pcs_interface_hd_8g_lpbk_en                                = "disable",
		parameter hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx                           = "pipe_g2_tx",
		parameter hssi_tx_pld_pcs_interface_hd_8g_hip_mode                               = "enable",
		parameter hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx                              = "pma_10b_tx",
		parameter hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx                           = "reg_tx",
		parameter hssi_tx_pld_pcs_interface_hd_g3_prot_mode                              = "pipe_g2",
		parameter hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode              = "tx_rx_pair_enabled",
		parameter hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en                             = "disable",
		parameter hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx                        = "disabled_prot_mode_tx",
		parameter hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx                   = "disable",
		parameter hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en                             = "disable",
		parameter hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode              = "tx_rx_pair_enabled",
		parameter hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode                            = "disable",
		parameter hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx                        = "eightg_pcie_g12_hip_mode_tx",
		parameter hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx                           = "pma_10b_tx",
		parameter hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx                        = "eightg_and_g3_reg_mode_hip_tx",
		parameter hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en                        = "enable",
		parameter hssi_tx_pld_pcs_interface_pcs_tx_clk_source                            = "eightg",
		parameter hssi_tx_pld_pcs_interface_pcs_tx_data_source                           = "hip_enable",
		parameter hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en                         = "delay1_clk_disable",
		parameter hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel                        = "pcs_tx_clk",
		parameter hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl                           = "delay1_path0",
		parameter hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel                       = "one_ff_delay",
		parameter hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en                         = "delay2_clk_disable",
		parameter hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl                           = "delay2_path0",
		parameter hssi_tx_pld_pcs_interface_pcs_tx_output_sel                            = "teng_output",
		parameter hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel                           = "eightg_clk_out",
		parameter hssi_rx_pld_pcs_interface_hd_chnl_hip_en                               = "enable",
		parameter hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx                   = "disable",
		parameter hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en                         = "enable",
		parameter hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx                         = "pcie_g2_capable_rx",
		parameter hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx                = "ctrl_master_rx",
		parameter hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx                            = "pma_10b_rx",
		parameter hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx                     = "reg_rx",
		parameter hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx                 = "single_rx",
		parameter hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx                    = "disable",
		parameter hssi_rx_pld_pcs_interface_hd_chnl_func_mode                            = "enable",
		parameter hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode               = "tx_rx_pair_enabled",
		parameter hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en                              = "disable",
		parameter hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx                 = "disable",
		parameter hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en                   = "enable",
		parameter hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz                        = 500000000,
		parameter hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz                        = 0,
		parameter hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz                          = 100000000,
		parameter hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz                        = 100000000,
		parameter hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode               = "tx_rx_pair_enabled",
		parameter hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx                         = "non_teng_mode_rx",
		parameter hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx                 = "single_rx",
		parameter hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode                = "tx_rx_pair_enabled",
		parameter hssi_rx_pld_pcs_interface_hd_10g_lpbk_en                               = "disable",
		parameter hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx                             = "pma_64b_rx",
		parameter hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx                          = "fifo_rx",
		parameter hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx                          = "disabled_prot_mode_rx",
		parameter hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx                     = "disable",
		parameter hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx                  = "single_rx",
		parameter hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode                         = "rx",
		parameter hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode                 = "tx_rx_pair_enabled",
		parameter hssi_rx_pld_pcs_interface_hd_8g_lpbk_en                                = "disable",
		parameter hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx                           = "pipe_g2_rx",
		parameter hssi_rx_pld_pcs_interface_hd_8g_hip_mode                               = "enable",
		parameter hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx                              = "pma_10b_rx",
		parameter hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx                           = "reg_rx",
		parameter hssi_rx_pld_pcs_interface_hd_g3_prot_mode                              = "pipe_g2",
		parameter hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode              = "tx_rx_pair_enabled",
		parameter hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en                             = "disable",
		parameter hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx                        = "disabled_prot_mode_rx",
		parameter hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx                   = "disable",
		parameter hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode                       = "tx",
		parameter hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en                             = "disable",
		parameter hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode              = "tx_rx_pair_enabled",
		parameter hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode                            = "disable",
		parameter hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx                        = "eightg_pcie_g12_hip_mode_rx",
		parameter hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx                           = "pma_10b_rx",
		parameter hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx                        = "eightg_and_g3_reg_mode_hip_rx",
		parameter hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en                        = "enable",
		parameter hssi_rx_pld_pcs_interface_pcs_rx_block_sel                             = "eightg",
		parameter hssi_rx_pld_pcs_interface_pcs_rx_clk_sel                               = "pcs_rx_clk",
		parameter hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en                            = "hip_rx_enable",
		parameter hssi_rx_pld_pcs_interface_pcs_rx_output_sel                            = "teng_output",
		parameter hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel                           = "eightg_clk_out",
		parameter hssi_common_pld_pcs_interface_dft_clk_out_en                           = "dft_clk_out_disable",
		parameter hssi_common_pld_pcs_interface_dft_clk_out_sel                          = "teng_rx_dft_clk",
		parameter hssi_common_pld_pcs_interface_hrdrstctrl_en                            = "hrst_en",
		parameter hssi_common_pld_pcs_interface_pcs_testbus_block_sel                    = "pma_if",
		parameter hssi_rx_pcs_pma_interface_block_sel                                    = "eight_g_pcs",
		parameter hssi_rx_pcs_pma_interface_channel_operation_mode                       = "tx_rx_pair_enabled",
		parameter hssi_rx_pcs_pma_interface_clkslip_sel                                  = "pld",
		parameter hssi_rx_pcs_pma_interface_lpbk_en                                      = "disable",
		parameter hssi_rx_pcs_pma_interface_master_clk_sel                               = "master_rx_pma_clk",
		parameter hssi_rx_pcs_pma_interface_pldif_datawidth_mode                         = "pldif_data_10bit",
		parameter hssi_rx_pcs_pma_interface_pma_dw_rx                                    = "pma_10b_rx",
		parameter hssi_rx_pcs_pma_interface_pma_if_dft_en                                = "dft_dis",
		parameter hssi_rx_pcs_pma_interface_pma_if_dft_val                               = "dft_0",
		parameter hssi_rx_pcs_pma_interface_prbs_clken                                   = "prbs_clk_dis",
		parameter hssi_rx_pcs_pma_interface_prbs_ver                                     = "prbs_off",
		parameter hssi_rx_pcs_pma_interface_prbs9_dwidth                                 = "prbs9_64b",
		parameter hssi_rx_pcs_pma_interface_prot_mode_rx                                 = "eightg_pcie_g12_hip_mode_rx",
		parameter hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion                    = "rx_dyn_polinv_dis",
		parameter hssi_rx_pcs_pma_interface_rx_lpbk_en                                   = "lpbk_dis",
		parameter hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok                      = "force_sig_ok",
		parameter hssi_rx_pcs_pma_interface_rx_prbs_mask                                 = "prbsmask128",
		parameter hssi_rx_pcs_pma_interface_rx_prbs_mode                                 = "teng_mode",
		parameter hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel                    = "sel_sig_det",
		parameter hssi_rx_pcs_pma_interface_rx_static_polarity_inversion                 = "rx_stat_polinv_dis",
		parameter hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en                             = "uhsif_lpbk_dis",
		parameter hssi_rx_pcs_pma_interface_sup_mode                                     = "user_mode",
		parameter hssi_tx_pcs_pma_interface_bypass_pma_txelecidle                        = "false",
		parameter hssi_tx_pcs_pma_interface_channel_operation_mode                       = "tx_rx_pair_enabled",
		parameter hssi_tx_pcs_pma_interface_lpbk_en                                      = "disable",
		parameter hssi_tx_pcs_pma_interface_master_clk_sel                               = "master_tx_pma_clk",
		parameter hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx                        = "pipe_g12",
		parameter hssi_tx_pcs_pma_interface_pldif_datawidth_mode                         = "pldif_data_10bit",
		parameter hssi_tx_pcs_pma_interface_pma_dw_tx                                    = "pma_10b_tx",
		parameter hssi_tx_pcs_pma_interface_pma_if_dft_en                                = "dft_dis",
		parameter hssi_tx_pcs_pma_interface_pmagate_en                                   = "pmagate_dis",
		parameter hssi_tx_pcs_pma_interface_prbs_clken                                   = "prbs_clk_dis",
		parameter hssi_tx_pcs_pma_interface_prbs_gen_pat                                 = "prbs_gen_dis",
		parameter hssi_tx_pcs_pma_interface_prbs9_dwidth                                 = "prbs9_64b",
		parameter hssi_tx_pcs_pma_interface_prot_mode_tx                                 = "eightg_pcie_g12_hip_mode_tx",
		parameter hssi_tx_pcs_pma_interface_sq_wave_num                                  = "sq_wave_default",
		parameter hssi_tx_pcs_pma_interface_sqwgen_clken                                 = "sqwgen_clk_dis",
		parameter hssi_tx_pcs_pma_interface_sup_mode                                     = "user_mode",
		parameter hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion                    = "tx_dyn_polinv_dis",
		parameter hssi_tx_pcs_pma_interface_tx_pma_data_sel                              = "eight_g_pcs",
		parameter hssi_tx_pcs_pma_interface_tx_static_polarity_inversion                 = "tx_stat_polinv_dis",
		parameter hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock              = "uhsif_filt_stepsz_b4lock_2",
		parameter hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value       = 0,
		parameter hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock            = "uhsif_filt_cntthr_b4lock_8",
		parameter hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period                 = "uhsif_dcn_test_period_4",
		parameter hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable                    = "uhsif_dcn_test_mode_disable",
		parameter hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh                 = "uhsif_dzt_cnt_thr_2",
		parameter hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable             = "uhsif_dzt_disable",
		parameter hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window                 = "uhsif_dzt_obr_win_16",
		parameter hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size                    = "uhsif_dzt_skipsz_4",
		parameter hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel                   = "uhsif_index_cram",
		parameter hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin                      = "uhsif_dcn_margin_2",
		parameter hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value          = 0,
		parameter hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control                  = "uhsif_dft_dz_det_val_0",
		parameter hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control                    = "uhsif_dft_up_val_0",
		parameter hssi_tx_pcs_pma_interface_uhsif_enable                                 = "uhsif_disable",
		parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock              = "uhsif_lkd_segsz_aflock_512",
		parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock             = "uhsif_lkd_segsz_b4lock_16",
		parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value   = 0,
		parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value  = 0,
		parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value  = 0,
		parameter hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value = 0,
		parameter hssi_common_pcs_pma_interface_asn_clk_enable                           = "true",
		parameter hssi_common_pcs_pma_interface_asn_enable                               = "en_asn",
		parameter hssi_common_pcs_pma_interface_block_sel                                = "eight_g_pcs",
		parameter hssi_common_pcs_pma_interface_bypass_early_eios                        = "false",
		parameter hssi_common_pcs_pma_interface_bypass_pcie_switch                       = "false",
		parameter hssi_common_pcs_pma_interface_bypass_pma_ltr                           = "false",
		parameter hssi_common_pcs_pma_interface_bypass_pma_sw_done                       = "true",
		parameter hssi_common_pcs_pma_interface_bypass_ppm_lock                          = "false",
		parameter hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp                   = "true",
		parameter hssi_common_pcs_pma_interface_bypass_txdetectrx                        = "false",
		parameter hssi_common_pcs_pma_interface_cdr_control                              = "en_cdr_ctrl",
		parameter hssi_common_pcs_pma_interface_cid_enable                               = "en_cid_mode",
		parameter hssi_common_pcs_pma_interface_data_mask_count                          = 2500,
		parameter hssi_common_pcs_pma_interface_data_mask_count_multi                    = 1,
		parameter hssi_common_pcs_pma_interface_dft_observation_clock_selection          = "dft_clk_obsrv_tx0",
		parameter hssi_common_pcs_pma_interface_early_eios_counter                       = 50,
		parameter hssi_common_pcs_pma_interface_force_freqdet                            = "force_freqdet_dis",
		parameter hssi_common_pcs_pma_interface_free_run_clk_enable                      = "true",
		parameter hssi_common_pcs_pma_interface_ignore_sigdet_g23                        = "false",
		parameter hssi_common_pcs_pma_interface_pc_en_counter                            = 55,
		parameter hssi_common_pcs_pma_interface_pc_rst_counter                           = 23,
		parameter hssi_common_pcs_pma_interface_pcie_hip_mode                            = "hip_enable",
		parameter hssi_common_pcs_pma_interface_ph_fifo_reg_mode                         = "phfifo_reg_mode_en",
		parameter hssi_common_pcs_pma_interface_phfifo_flush_wait                        = 36,
		parameter hssi_common_pcs_pma_interface_pipe_if_g3pcs                            = "pipe_if_g3pcs",
		parameter hssi_common_pcs_pma_interface_pma_done_counter                         = 175000,
		parameter hssi_common_pcs_pma_interface_pma_if_dft_en                            = "dft_dis",
		parameter hssi_common_pcs_pma_interface_pma_if_dft_val                           = "dft_0",
		parameter hssi_common_pcs_pma_interface_ppm_cnt_rst                              = "ppm_cnt_rst_dis",
		parameter hssi_common_pcs_pma_interface_ppm_deassert_early                       = "deassert_early_dis",
		parameter hssi_common_pcs_pma_interface_ppm_gen1_2_cnt                           = "cnt_32k",
		parameter hssi_common_pcs_pma_interface_ppm_post_eidle_delay                     = "cnt_200_cycles",
		parameter hssi_common_pcs_pma_interface_ppmsel                                   = "ppmsel_300",
		parameter hssi_common_pcs_pma_interface_prot_mode                                = "pipe_g12",
		parameter hssi_common_pcs_pma_interface_rxvalid_mask                             = "rxvalid_mask_en",
		parameter hssi_common_pcs_pma_interface_sigdet_wait_counter                      = 2500,
		parameter hssi_common_pcs_pma_interface_sigdet_wait_counter_multi                = 1,
		parameter hssi_common_pcs_pma_interface_sim_mode                                 = "disable",
		parameter hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en                  = "true",
		parameter hssi_common_pcs_pma_interface_sup_mode                                 = "user_mode",
		parameter hssi_common_pcs_pma_interface_testout_sel                              = "asn_test",
		parameter hssi_common_pcs_pma_interface_wait_clk_on_off_timer                    = 0,
		parameter hssi_common_pcs_pma_interface_wait_pipe_synchronizing                  = 23,
		parameter hssi_common_pcs_pma_interface_wait_send_syncp_fbkp                     = 250,
		parameter hssi_common_pcs_pma_interface_ppm_det_buckets                          = "ppm_300_bucket",
		parameter hssi_fifo_rx_pcs_double_read_mode                                      = "double_read_dis",
		parameter hssi_fifo_rx_pcs_prot_mode                                             = "non_teng_mode",
		parameter hssi_fifo_tx_pcs_double_write_mode                                     = "double_write_dis",
		parameter hssi_fifo_tx_pcs_prot_mode                                             = "non_teng_mode",
		parameter hssi_pipe_gen3_bypass_rx_detection_enable                              = "false",
		parameter hssi_pipe_gen3_bypass_rx_preset                                        = 0,
		parameter hssi_pipe_gen3_bypass_rx_preset_enable                                 = "false",
		parameter hssi_pipe_gen3_bypass_tx_coefficent                                    = 0,
		parameter hssi_pipe_gen3_bypass_tx_coefficent_enable                             = "false",
		parameter hssi_pipe_gen3_elecidle_delay_g3                                       = 6,
		parameter hssi_pipe_gen3_ind_error_reporting                                     = "dis_ind_error_reporting",
		parameter hssi_pipe_gen3_mode                                                    = "pipe_g2",
		parameter hssi_pipe_gen3_phy_status_delay_g12                                    = 5,
		parameter hssi_pipe_gen3_phy_status_delay_g3                                     = 5,
		parameter hssi_pipe_gen3_phystatus_rst_toggle_g12                                = "dis_phystatus_rst_toggle",
		parameter hssi_pipe_gen3_phystatus_rst_toggle_g3                                 = "dis_phystatus_rst_toggle_g3",
		parameter hssi_pipe_gen3_rate_match_pad_insertion                                = "dis_rm_fifo_pad_ins",
		parameter hssi_pipe_gen3_sup_mode                                                = "user_mode",
		parameter hssi_pipe_gen3_test_out_sel                                            = "disable_test_out",
		parameter hssi_pipe_gen1_2_elec_idle_delay_val                                   = 3,
		parameter hssi_pipe_gen1_2_error_replace_pad                                     = "replace_edb",
		parameter hssi_pipe_gen1_2_hip_mode                                              = "en_hip",
		parameter hssi_pipe_gen1_2_ind_error_reporting                                   = "dis_ind_error_reporting",
		parameter hssi_pipe_gen1_2_phystatus_delay_val                                   = 0,
		parameter hssi_pipe_gen1_2_phystatus_rst_toggle                                  = "dis_phystatus_rst_toggle",
		parameter hssi_pipe_gen1_2_pipe_byte_de_serializer_en                            = "dont_care_bds",
		parameter hssi_pipe_gen1_2_prot_mode                                             = "pipe_g2",
		parameter hssi_pipe_gen1_2_rx_pipe_enable                                        = "en_pipe3_rx",
		parameter hssi_pipe_gen1_2_rxdetect_bypass                                       = "dis_rxdetect_bypass",
		parameter hssi_pipe_gen1_2_sup_mode                                              = "user_mode",
		parameter hssi_pipe_gen1_2_tx_pipe_enable                                        = "en_pipe3_tx",
		parameter hssi_pipe_gen1_2_txswing                                               = "dis_txswing",
		parameter pma_adapt_adp_1s_ctle_bypass                                           = "radp_1s_ctle_bypass_1",
		parameter pma_adapt_adp_4s_ctle_bypass                                           = "radp_4s_ctle_bypass_1",
		parameter pma_adapt_adp_ctle_en                                                  = "radp_ctle_disable",
		parameter pma_adapt_adp_dfe_fltap_bypass                                         = "radp_dfe_fltap_bypass_1",
		parameter pma_adapt_adp_dfe_fltap_en                                             = "radp_dfe_fltap_disable",
		parameter pma_adapt_adp_dfe_fxtap_bypass                                         = "radp_dfe_fxtap_bypass_1",
		parameter pma_adapt_adp_dfe_fxtap_en                                             = "radp_dfe_fxtap_disable",
		parameter pma_adapt_adp_dfe_fxtap_hold_en                                        = "radp_dfe_fxtap_not_held",
		parameter pma_adapt_adp_dfe_mode                                                 = "radp_dfe_mode_4",
		parameter pma_adapt_adp_vga_bypass                                               = "radp_vga_bypass_1",
		parameter pma_adapt_adp_vga_en                                                   = "radp_vga_disable",
		parameter pma_adapt_adp_vref_bypass                                              = "radp_vref_bypass_1",
		parameter pma_adapt_adp_vref_en                                                  = "radp_vref_disable",
		parameter pma_adapt_datarate                                                     = "5000000000 bps",
		parameter pma_adapt_prot_mode                                                    = "pcie_gen2_rx",
		parameter pma_adapt_sup_mode                                                     = "user_mode",
		parameter pma_adapt_adp_ctle_adapt_cycle_window                                  = "radp_ctle_adapt_cycle_window_7",
		parameter pma_adapt_odi_dfe_spec_en                                              = "rodi_dfe_spec_en_0",
		parameter pma_adapt_adapt_mode                                                   = "manual",
		parameter pma_adapt_adp_onetime_dfe                                              = "radp_onetime_dfe_0",
		parameter pma_adapt_adp_mode                                                     = "radp_mode_8",
		parameter pma_cdr_refclk_powerdown_mode                                          = "powerup",
		parameter pma_cdr_refclk_refclk_select                                           = "ref_iqclk0",
		parameter pma_cgb_bitslip_enable                                                 = "disable_bitslip",
		parameter pma_cgb_bonding_reset_enable                                           = "disallow_bonding_reset",
		parameter pma_cgb_datarate                                                       = "5000000000 bps",
		parameter pma_cgb_pcie_gen3_bitwidth                                             = "pciegen3_wide",
		parameter pma_cgb_prot_mode                                                      = "pcie_gen2_tx",
		parameter pma_cgb_ser_mode                                                       = "ten_bit",
		parameter pma_cgb_sup_mode                                                       = "user_mode",
		parameter pma_cgb_x1_div_m_sel                                                   = "divbypass",
		parameter pma_cgb_input_select_x1                                                = "unused",
		parameter pma_cgb_input_select_gen3                                              = "unused",
		parameter pma_cgb_input_select_xn                                                = "sel_x6_dn",
		parameter pma_cgb_tx_ucontrol_en                                                 = "disable",
		parameter pma_rx_dfe_datarate                                                    = "5000000000 bps",
		parameter pma_rx_dfe_dft_en                                                      = "dft_disable",
		parameter pma_rx_dfe_pdb                                                         = "dfe_enable",
		parameter pma_rx_dfe_pdb_fixedtap                                                = "fixtap_dfe_powerdown",
		parameter pma_rx_dfe_pdb_floattap                                                = "floattap_dfe_powerdown",
		parameter pma_rx_dfe_pdb_fxtap4t7                                                = "fxtap4t7_powerdown",
		parameter pma_rx_dfe_sup_mode                                                    = "user_mode",
		parameter pma_rx_dfe_prot_mode                                                   = "pcie_gen2_rx",
		parameter pma_rx_odi_datarate                                                    = "5000000000 bps",
		parameter pma_rx_odi_sup_mode                                                    = "user_mode",
		parameter pma_rx_odi_step_ctrl_sel                                               = "dprio_mode",
		parameter pma_rx_odi_prot_mode                                                   = "pcie_gen2_rx",
		parameter pma_rx_buf_bypass_eqz_stages_234                                       = "bypass_off",
		parameter pma_rx_buf_datarate                                                    = "5000000000 bps",
		parameter pma_rx_buf_diag_lp_en                                                  = "dlp_off",
		parameter pma_rx_buf_prot_mode                                                   = "pcie_gen2_rx",
		parameter pma_rx_buf_qpi_enable                                                  = "non_qpi_mode",
		parameter pma_rx_buf_rx_refclk_divider                                           = "bypass_divider",
		parameter pma_rx_buf_sup_mode                                                    = "user_mode",
		parameter pma_rx_buf_loopback_modes                                              = "lpbk_disable",
		parameter pma_rx_buf_refclk_en                                                   = "disable",
		parameter pma_rx_buf_pm_tx_rx_pcie_gen                                           = "non_pcie",
		parameter pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth                                  = "pcie_gen3_32b",
		parameter pma_rx_buf_pm_tx_rx_cvp_mode                                           = "cvp_off",
		parameter pma_rx_buf_xrx_path_uc_cal_enable                                      = "rx_cal_off",
		parameter pma_rx_buf_xrx_path_sup_mode                                           = "user_mode",
		parameter pma_rx_buf_xrx_path_prot_mode                                          = "pcie_gen2_rx",
		parameter pma_rx_buf_xrx_path_datarate                                           = "5000000000 bps",
		parameter pma_rx_buf_xrx_path_datawidth                                          = 10,
		parameter pma_rx_buf_xrx_path_pma_rx_divclk_hz                                   = "500000000",
		parameter pma_rx_sd_prot_mode                                                    = "pcie_gen2_rx",
		parameter pma_rx_sd_sd_output_off                                                = 13,
		parameter pma_rx_sd_sd_output_on                                                 = 1,
		parameter pma_rx_sd_sd_pdb                                                       = "sd_on",
		parameter pma_rx_sd_sup_mode                                                     = "user_mode",
		parameter pma_tx_ser_ser_clk_divtx_user_sel                                      = "divtx_user_off",
		parameter pma_tx_ser_sup_mode                                                    = "user_mode",
		parameter pma_tx_ser_prot_mode                                                   = "pcie_gen2_tx",
		parameter pma_tx_buf_datarate                                                    = "5000000000 bps",
		parameter pma_tx_buf_prot_mode                                                   = "pcie_gen2_tx",
		parameter pma_tx_buf_rx_det                                                      = "mode_0",
		parameter pma_tx_buf_rx_det_output_sel                                           = "rx_det_pcie_out",
		parameter pma_tx_buf_rx_det_pdb                                                  = "rx_det_on",
		parameter pma_tx_buf_sup_mode                                                    = "user_mode",
		parameter pma_tx_buf_user_fir_coeff_ctrl_sel                                     = "dynamic_ctl",
		parameter pma_tx_buf_xtx_path_prot_mode                                          = "pcie_gen2_tx",
		parameter pma_tx_buf_xtx_path_datarate                                           = "5000000000 bps",
		parameter pma_tx_buf_xtx_path_datawidth                                          = 10,
		parameter pma_tx_buf_xtx_path_clock_divider_ratio                                = 1,
		parameter pma_tx_buf_xtx_path_pma_tx_divclk_hz                                   = "500000000",
		parameter pma_tx_buf_xtx_path_tx_pll_clk_hz                                      = "2500000000",
		parameter pma_tx_buf_xtx_path_sup_mode                                           = "user_mode",
		parameter cdr_pll_pma_width                                                      = 10,
		parameter cdr_pll_cgb_div                                                        = 1,
		parameter cdr_pll_is_cascaded_pll                                                = "false",
		parameter cdr_pll_datarate                                                       = "5000000000 bps",
		parameter cdr_pll_lpd_counter                                                    = 4,
		parameter cdr_pll_lpfd_counter                                                   = 4,
		parameter cdr_pll_n_counter_scratch                                              = 1,
		parameter cdr_pll_output_clock_frequency                                         = "2500000000 Hz",
		parameter cdr_pll_reference_clock_frequency                                      = "100000000 hz",
		parameter cdr_pll_set_cdr_vco_speed                                              = 2,
		parameter cdr_pll_set_cdr_vco_speed_fix                                          = 117,
		parameter cdr_pll_vco_freq                                                       = "10000000000 Hz",
		parameter cdr_pll_atb_select_control                                             = "atb_off",
		parameter cdr_pll_auto_reset_on                                                  = "auto_reset_off",
		parameter cdr_pll_bbpd_data_pattern_filter_select                                = "bbpd_data_pat_off",
		parameter cdr_pll_bw_sel                                                         = "medium",
		parameter cdr_pll_cdr_odi_select                                                 = "sel_cdr",
		parameter cdr_pll_cdr_phaselock_mode                                             = "no_ignore_lock",
		parameter cdr_pll_cdr_powerdown_mode                                             = "power_up",
		parameter cdr_pll_chgpmp_current_pd                                              = "cp_current_pd_setting0",
		parameter cdr_pll_chgpmp_current_pfd                                             = "cp_current_pfd_setting4",
		parameter cdr_pll_chgpmp_replicate                                               = "false",
		parameter cdr_pll_chgpmp_testmode                                                = "cp_test_disable",
		parameter cdr_pll_clklow_mux_select                                              = "clklow_mux_cdr_fbclk",
		parameter cdr_pll_diag_loopback_enable                                           = "false",
		parameter cdr_pll_disable_up_dn                                                  = "true",
		parameter cdr_pll_fref_clklow_div                                                = 1,
		parameter cdr_pll_fref_mux_select                                                = "fref_mux_cdr_refclk",
		parameter cdr_pll_gpon_lck2ref_control                                           = "gpon_lck2ref_off",
		parameter cdr_pll_initial_settings                                               = "true",
		parameter cdr_pll_lck2ref_delay_control                                          = "lck2ref_delay_2",
		parameter cdr_pll_lf_resistor_pd                                                 = "lf_pd_setting3",
		parameter cdr_pll_lf_resistor_pfd                                                = "lf_pfd_setting2",
		parameter cdr_pll_lf_ripple_cap                                                  = "lf_no_ripple",
		parameter cdr_pll_loop_filter_bias_select                                        = "lpflt_bias_7",
		parameter cdr_pll_loopback_mode                                                  = "loopback_disabled",
		parameter cdr_pll_ltd_ltr_micro_controller_select                                = "ltd_ltr_pcs",
		parameter cdr_pll_m_counter                                                      = 25,
		parameter cdr_pll_n_counter                                                      = 1,
		parameter cdr_pll_pd_fastlock_mode                                               = "false",
		parameter cdr_pll_pd_l_counter                                                   = 4,
		parameter cdr_pll_pfd_l_counter                                                  = 4,
		parameter cdr_pll_primary_use                                                    = "cdr",
		parameter cdr_pll_prot_mode                                                      = "pcie_gen2_rx",
		parameter cdr_pll_reverse_serial_loopback                                        = "no_loopback",
		parameter cdr_pll_set_cdr_v2i_enable                                             = "true",
		parameter cdr_pll_set_cdr_vco_reset                                              = "false",
		parameter cdr_pll_set_cdr_vco_speed_pciegen3                                     = "cdr_vco_max_speedbin_pciegen3",
		parameter cdr_pll_sup_mode                                                       = "user_mode",
		parameter cdr_pll_tx_pll_prot_mode                                               = "txpll_unused",
		parameter cdr_pll_txpll_hclk_driver_enable                                       = "false",
		parameter cdr_pll_vco_overrange_voltage                                          = "vco_overrange_off",
		parameter cdr_pll_vco_underrange_voltage                                         = "vco_underange_off",
		parameter cdr_pll_fb_select                                                      = "direct_fb",
		parameter cdr_pll_uc_ro_cal                                                      = "uc_ro_cal_on",
		parameter cdr_pll_iqclk_mux_sel                                                  = "power_down",
		parameter cdr_pll_pcie_gen                                                       = "pcie_gen2_100mhzref",
		parameter cdr_pll_set_cdr_input_freq_range                                       = 0,
		parameter cdr_pll_chgpmp_current_dn_trim                                         = "cp_current_trimming_dn_setting0",
		parameter cdr_pll_chgpmp_up_pd_trim_double                                       = "normal_up_trim_current",
		parameter cdr_pll_chgpmp_current_up_pd                                           = "cp_current_pd_up_setting4",
		parameter cdr_pll_chgpmp_current_up_trim                                         = "cp_current_trimming_up_setting0",
		parameter cdr_pll_chgpmp_dn_pd_trim_double                                       = "normal_dn_trim_current",
		parameter cdr_pll_cal_vco_count_length                                           = "sel_8b_count",
		parameter cdr_pll_chgpmp_current_dn_pd                                           = "cp_current_pd_dn_setting4",
		parameter pma_rx_deser_clkdiv_source                                             = "vco_bypass_normal",
		parameter pma_rx_deser_clkdivrx_user_mode                                        = "clkdivrx_user_disabled",
		parameter pma_rx_deser_datarate                                                  = "5000000000 bps",
		parameter pma_rx_deser_deser_factor                                              = 10,
		parameter pma_rx_deser_force_clkdiv_for_testing                                  = "normal_clkdiv",
		parameter pma_rx_deser_sdclk_enable                                              = "true",
		parameter pma_rx_deser_sup_mode                                                  = "user_mode",
		parameter pma_rx_deser_rst_n_adapt_odi                                           = "no_rst_adapt_odi",
		parameter pma_rx_deser_bitslip_bypass                                            = "bs_bypass_yes",
		parameter pma_rx_deser_prot_mode                                                 = "pcie_gen2_rx",
		parameter pma_rx_deser_pcie_gen                                                  = "pcie_gen2_100mhzref",
		parameter pma_rx_deser_pcie_gen_bitwidth                                         = "pcie_gen3_32b"
	) (
		output wire         hip_pipe_pclk,         //         hip_pipe_pclk.hip_pipe_pclk
		output wire         hip_fixedclk,          //          hip_fixedclk.hip_fixedclk
		input  wire         ltssm_detect_quiet,    //    ltssm_detect_quiet.ltssm_detect_quiet
		input  wire         ltssm_detect_active,   //   ltssm_detect_active.ltssm_detect_active
		input  wire         ltssm_rcvr_phase_two,  //  ltssm_rcvr_phase_two.ltssm_rcvr_phase_two
		input  wire         hip_reduce_counters,   //   hip_reduce_counters.hip_reduce_counters
		input  wire [1:0]   pcie_rate,             //             pcie_rate.pcie_rate
		input  wire [7:0]   pipe_rate,             //             pipe_rate.pipe_rate
		input  wire [1:0]   pipe_sw_done,          //          pipe_sw_done.pipe_sw_done
		output wire [1:0]   pipe_sw,               //               pipe_sw.pipe_sw
		input  wire [3:0]   tx_analogreset,        //        tx_analogreset.tx_analogreset
		input  wire [3:0]   tx_digitalreset,       //       tx_digitalreset.tx_digitalreset
		input  wire [3:0]   rx_analogreset,        //        rx_analogreset.rx_analogreset
		input  wire [3:0]   rx_digitalreset,       //       rx_digitalreset.rx_digitalreset
		output wire [3:0]   tx_cal_busy,           //           tx_cal_busy.tx_cal_busy
		output wire [3:0]   rx_cal_busy,           //           rx_cal_busy.rx_cal_busy
		input  wire [23:0]  tx_bonding_clocks,     //     tx_bonding_clocks.clk
		input  wire         rx_cdr_refclk0,        //        rx_cdr_refclk0.clk
		output wire [3:0]   tx_serial_data,        //        tx_serial_data.tx_serial_data
		input  wire [3:0]   rx_serial_data,        //        rx_serial_data.rx_serial_data
		input  wire [3:0]   rx_set_locktodata,     //     rx_set_locktodata.rx_set_locktodata
		input  wire [3:0]   rx_set_locktoref,      //      rx_set_locktoref.rx_set_locktoref
		output wire [3:0]   rx_is_lockedtoref,     //     rx_is_lockedtoref.rx_is_lockedtoref
		output wire [3:0]   rx_is_lockedtodata,    //    rx_is_lockedtodata.rx_is_lockedtodata
		input  wire [3:0]   rx_polinv,             //             rx_polinv.rx_polinv
		input  wire [255:0] tx_hip_data,           //           tx_hip_data.tx_hip_data
		output wire [203:0] rx_hip_data,           //           rx_hip_data.rx_hip_data
		output wire [3:0]   hip_frefclk,           //           hip_frefclk.hip_frefclk
		output wire [31:0]  hip_ctrl,              //              hip_ctrl.hip_ctrl
		output wire [3:0]   hip_cal_done,          //          hip_cal_done.hip_cal_done
		input  wire         pipe_hclk_in,          //          pipe_hclk_in.clk
		input  wire [11:0]  pipe_rx_eidleinfersel, // pipe_rx_eidleinfersel.pipe_rx_eidleinfersel
		output wire [3:0]   pipe_rx_elecidle,      //      pipe_rx_elecidle.pipe_rx_elecidle
		input  wire [3:0]   pipe_rx_polarity,      //      pipe_rx_polarity.pipe_rx_polarity
		input  wire [0:0]   reconfig_clk,          //          reconfig_clk.clk
		input  wire [0:0]   reconfig_reset,        //        reconfig_reset.reset
		input  wire [0:0]   reconfig_write,        //         reconfig_avmm.write
		input  wire [0:0]   reconfig_read,         //                      .read
		input  wire [11:0]  reconfig_address,      //                      .address
		input  wire [31:0]  reconfig_writedata,    //                      .writedata
		output wire [31:0]  reconfig_readdata,     //                      .readdata
		output wire [0:0]   reconfig_waitrequest   //                      .waitrequest
	);

	generate
		// If any of the display statements (or deliberately broken
		// instantiations) within this generate block triggers then this module
		// has been instantiated this module with a set of parameters different
		// from those it was generated for.  This will usually result in a
		// non-functioning system.
		if (device_revision != "20nm5")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					device_revision_check ( .error(1'b1) );
		end
		if (duplex_mode != "duplex")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					duplex_mode_check ( .error(1'b1) );
		end
		if (channels != 4)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					channels_check ( .error(1'b1) );
		end
		if (enable_calibration != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					enable_calibration_check ( .error(1'b1) );
		end
		if (enable_analog_resets != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					enable_analog_resets_check ( .error(1'b1) );
		end
		if (enable_reset_sequence != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					enable_reset_sequence_check ( .error(1'b1) );
		end
		if (bonded_mode != "pma_pcs")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					bonded_mode_check ( .error(1'b1) );
		end
		if (pcs_bonding_master != 3)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pcs_bonding_master_check ( .error(1'b1) );
		end
		if (plls != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					plls_check ( .error(1'b1) );
		end
		if (number_physical_bonding_clocks != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					number_physical_bonding_clocks_check ( .error(1'b1) );
		end
		if (cdr_refclk_cnt != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_refclk_cnt_check ( .error(1'b1) );
		end
		if (enable_hip != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					enable_hip_check ( .error(1'b1) );
		end
		if (hip_cal_en != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hip_cal_en_check ( .error(1'b1) );
		end
		if (rcfg_enable != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					rcfg_enable_check ( .error(1'b1) );
		end
		if (rcfg_shared != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					rcfg_shared_check ( .error(1'b1) );
		end
		if (rcfg_jtag_enable != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					rcfg_jtag_enable_check ( .error(1'b1) );
		end
		if (rcfg_separate_avmm_busy != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					rcfg_separate_avmm_busy_check ( .error(1'b1) );
		end
		if (adme_prot_mode != "pipe_g2")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					adme_prot_mode_check ( .error(1'b1) );
		end
		if (adme_data_rate != "5000000000")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					adme_data_rate_check ( .error(1'b1) );
		end
		if (enable_pcie_dfe_ip != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					enable_pcie_dfe_ip_check ( .error(1'b1) );
		end
		if (sim_reduced_counters != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					sim_reduced_counters_check ( .error(1'b1) );
		end
		if (disable_continuous_dfe != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					disable_continuous_dfe_check ( .error(1'b1) );
		end
		if (dbg_embedded_debug_enable != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					dbg_embedded_debug_enable_check ( .error(1'b1) );
		end
		if (dbg_capability_reg_enable != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					dbg_capability_reg_enable_check ( .error(1'b1) );
		end
		if (dbg_user_identifier != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					dbg_user_identifier_check ( .error(1'b1) );
		end
		if (dbg_stat_soft_logic_enable != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					dbg_stat_soft_logic_enable_check ( .error(1'b1) );
		end
		if (dbg_ctrl_soft_logic_enable != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					dbg_ctrl_soft_logic_enable_check ( .error(1'b1) );
		end
		if (dbg_prbs_soft_logic_enable != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					dbg_prbs_soft_logic_enable_check ( .error(1'b1) );
		end
		if (dbg_odi_soft_logic_enable != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					dbg_odi_soft_logic_enable_check ( .error(1'b1) );
		end
		if (rcfg_emb_strm_enable != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					rcfg_emb_strm_enable_check ( .error(1'b1) );
		end
		if (rcfg_profile_cnt != 2)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					rcfg_profile_cnt_check ( .error(1'b1) );
		end
		if (hssi_gen3_rx_pcs_block_sync != "bypass_block_sync")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_rx_pcs_block_sync_check ( .error(1'b1) );
		end
		if (hssi_gen3_rx_pcs_block_sync_sm != "disable_blk_sync_sm")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_rx_pcs_block_sync_sm_check ( .error(1'b1) );
		end
		if (hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn_check ( .error(1'b1) );
		end
		if (hssi_gen3_rx_pcs_lpbk_force != "lpbk_frce_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_rx_pcs_lpbk_force_check ( .error(1'b1) );
		end
		if (hssi_gen3_rx_pcs_mode != "disable_pcs")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_rx_pcs_mode_check ( .error(1'b1) );
		end
		if (hssi_gen3_rx_pcs_rate_match_fifo != "bypass_rm_fifo")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_rx_pcs_rate_match_fifo_check ( .error(1'b1) );
		end
		if (hssi_gen3_rx_pcs_rate_match_fifo_latency != "low_latency")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_rx_pcs_rate_match_fifo_latency_check ( .error(1'b1) );
		end
		if (hssi_gen3_rx_pcs_reverse_lpbk != "rev_lpbk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_rx_pcs_reverse_lpbk_check ( .error(1'b1) );
		end
		if (hssi_gen3_rx_pcs_rx_b4gb_par_lpbk != "b4gb_par_lpbk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_rx_pcs_rx_b4gb_par_lpbk_check ( .error(1'b1) );
		end
		if (hssi_gen3_rx_pcs_rx_force_balign != "dis_force_balign")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_rx_pcs_rx_force_balign_check ( .error(1'b1) );
		end
		if (hssi_gen3_rx_pcs_rx_ins_del_one_skip != "ins_del_one_skip_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_rx_pcs_rx_ins_del_one_skip_check ( .error(1'b1) );
		end
		if (hssi_gen3_rx_pcs_rx_num_fixed_pat != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_rx_pcs_rx_num_fixed_pat_check ( .error(1'b1) );
		end
		if (hssi_gen3_rx_pcs_rx_test_out_sel != "rx_test_out0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_rx_pcs_rx_test_out_sel_check ( .error(1'b1) );
		end
		if (hssi_gen3_rx_pcs_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_rx_pcs_sup_mode_check ( .error(1'b1) );
		end
		if (hssi_gen3_tx_pcs_mode != "disable_pcs")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_tx_pcs_mode_check ( .error(1'b1) );
		end
		if (hssi_gen3_tx_pcs_reverse_lpbk != "rev_lpbk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_tx_pcs_reverse_lpbk_check ( .error(1'b1) );
		end
		if (hssi_gen3_tx_pcs_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_tx_pcs_sup_mode_check ( .error(1'b1) );
		end
		if (hssi_gen3_tx_pcs_tx_bitslip != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_tx_pcs_tx_bitslip_check ( .error(1'b1) );
		end
		if (hssi_gen3_tx_pcs_tx_gbox_byp != "bypass_gbox")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_gen3_tx_pcs_tx_gbox_byp_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_blksync_cor_en != "detect")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_blksync_cor_en_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_bypass_gb != "bypass_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_bypass_gb_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_clr_ctrl != "both_enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_clr_ctrl_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_ctrl_bit_reverse != "ctrl_bit_reverse_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_ctrl_bit_reverse_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_data_bit_reverse != "data_bit_reverse_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_data_bit_reverse_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_dv_start != "with_blklock")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_dv_start_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_err_mark_type != "err_mark_10g")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_err_mark_type_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_error_marking_en != "err_mark_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_error_marking_en_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_low_latency_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_low_latency_en_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_lpbk_mode != "lpbk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_lpbk_mode_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_parity_invalid_enum != 8)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_parity_invalid_enum_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_parity_valid_num != 4)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_parity_valid_num_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_pipeln_blksync != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_pipeln_blksync_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_pipeln_descrm != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_pipeln_descrm_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_pipeln_errcorrect != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_pipeln_errcorrect_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_pipeln_errtrap_ind != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_pipeln_errtrap_ind_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_pipeln_errtrap_lfsr != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_pipeln_errtrap_lfsr_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_pipeln_errtrap_loc != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_pipeln_errtrap_loc_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_pipeln_errtrap_pat != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_pipeln_errtrap_pat_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_pipeln_gearbox != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_pipeln_gearbox_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_pipeln_syndrm != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_pipeln_syndrm_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_pipeln_trans_dec != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_pipeln_trans_dec_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_prot_mode != "disable_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_prot_mode_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_receive_order != "receive_lsb")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_receive_order_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_rx_testbus_sel != "overall")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_rx_testbus_sel_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_signal_ok_en != "sig_ok_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_signal_ok_en_check ( .error(1'b1) );
		end
		if (hssi_krfec_rx_pcs_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_rx_pcs_sup_mode_check ( .error(1'b1) );
		end
		if (hssi_krfec_tx_pcs_burst_err != "burst_err_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_tx_pcs_burst_err_check ( .error(1'b1) );
		end
		if (hssi_krfec_tx_pcs_burst_err_len != "burst_err_len1")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_tx_pcs_burst_err_len_check ( .error(1'b1) );
		end
		if (hssi_krfec_tx_pcs_ctrl_bit_reverse != "ctrl_bit_reverse_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_tx_pcs_ctrl_bit_reverse_check ( .error(1'b1) );
		end
		if (hssi_krfec_tx_pcs_data_bit_reverse != "data_bit_reverse_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_tx_pcs_data_bit_reverse_check ( .error(1'b1) );
		end
		if (hssi_krfec_tx_pcs_enc_frame_query != "enc_query_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_tx_pcs_enc_frame_query_check ( .error(1'b1) );
		end
		if (hssi_krfec_tx_pcs_low_latency_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_tx_pcs_low_latency_en_check ( .error(1'b1) );
		end
		if (hssi_krfec_tx_pcs_pipeln_encoder != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_tx_pcs_pipeln_encoder_check ( .error(1'b1) );
		end
		if (hssi_krfec_tx_pcs_pipeln_scrambler != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_tx_pcs_pipeln_scrambler_check ( .error(1'b1) );
		end
		if (hssi_krfec_tx_pcs_prot_mode != "disable_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_tx_pcs_prot_mode_check ( .error(1'b1) );
		end
		if (hssi_krfec_tx_pcs_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_tx_pcs_sup_mode_check ( .error(1'b1) );
		end
		if (hssi_krfec_tx_pcs_transcode_err != "trans_err_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_tx_pcs_transcode_err_check ( .error(1'b1) );
		end
		if (hssi_krfec_tx_pcs_transmit_order != "transmit_lsb")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_tx_pcs_transmit_order_check ( .error(1'b1) );
		end
		if (hssi_krfec_tx_pcs_tx_testbus_sel != "overall")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_krfec_tx_pcs_tx_testbus_sel_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_align_del != "align_del_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_align_del_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_ber_bit_err_total_cnt != "bit_err_total_cnt_10g")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_ber_bit_err_total_cnt_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_ber_clken != "ber_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_ber_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_ber_xus_timer_window != 19530)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_ber_xus_timer_window_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_bitslip_mode != "bitslip_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_bitslip_mode_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_blksync_bitslip_type != "bitslip_comb")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_blksync_bitslip_type_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_blksync_bitslip_wait_cnt != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_blksync_bitslip_wait_cnt_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_blksync_bitslip_wait_type != "bitslip_cnt")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_blksync_bitslip_wait_type_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_blksync_bypass != "blksync_bypass_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_blksync_bypass_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_blksync_clken != "blksync_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_blksync_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt != "enum_invalid_sh_cnt_10g")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock != "knum_sh_cnt_postlock_10g")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock != "knum_sh_cnt_prelock_10g")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_blksync_pipeln != "blksync_pipeln_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_blksync_pipeln_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_clr_errblk_cnt_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_clr_errblk_cnt_en_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_control_del != "control_del_none")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_control_del_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_crcchk_bypass != "crcchk_bypass_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_crcchk_bypass_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_crcchk_clken != "crcchk_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_crcchk_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_crcchk_inv != "crcchk_inv_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_crcchk_inv_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_crcchk_pipeln != "crcchk_pipeln_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_crcchk_pipeln_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_crcflag_pipeln != "crcflag_pipeln_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_crcflag_pipeln_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_ctrl_bit_reverse != "ctrl_bit_reverse_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_ctrl_bit_reverse_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_data_bit_reverse != "data_bit_reverse_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_data_bit_reverse_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass != "dec_64b66b_rxsm_bypass_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_dec64b66b_clken != "dec64b66b_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_dec64b66b_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_descrm_bypass != "descrm_bypass_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_descrm_bypass_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_descrm_clken != "descrm_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_descrm_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_descrm_mode != "async")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_descrm_mode_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_descrm_pipeln != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_descrm_pipeln_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_dft_clk_out_sel != "rx_master_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_dft_clk_out_sel_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_dis_signal_ok != "dis_signal_ok_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_dis_signal_ok_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_dispchk_bypass != "dispchk_bypass_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_dispchk_bypass_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_empty_flag_type != "empty_rd_side")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_empty_flag_type_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_fast_path != "fast_path_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_fast_path_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_fec_clken != "fec_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_fec_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_fec_enable != "fec_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_fec_enable_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_fifo_double_read != "fifo_double_read_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_fifo_double_read_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_fifo_stop_rd != "n_rd_empty")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_fifo_stop_rd_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_fifo_stop_wr != "n_wr_full")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_fifo_stop_wr_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_force_align != "force_align_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_force_align_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_frmsync_bypass != "frmsync_bypass_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_frmsync_bypass_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_frmsync_clken != "frmsync_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_frmsync_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_frmsync_enum_scrm != "enum_scrm_default")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_frmsync_enum_scrm_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_frmsync_enum_sync != "enum_sync_default")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_frmsync_enum_sync_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_frmsync_flag_type != "location_only")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_frmsync_flag_type_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_frmsync_knum_sync != "knum_sync_default")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_frmsync_knum_sync_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_frmsync_mfrm_length != 2048)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_frmsync_mfrm_length_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_frmsync_pipeln != "frmsync_pipeln_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_frmsync_pipeln_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_full_flag_type != "full_wr_side")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_full_flag_type_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_gb_rx_idwidth != "width_64")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_gb_rx_idwidth_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_gb_rx_odwidth != "width_64")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_gb_rx_odwidth_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_gbexp_clken != "gbexp_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_gbexp_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_low_latency_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_low_latency_en_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_lpbk_mode != "lpbk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_lpbk_mode_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_master_clk_sel != "master_rx_pma_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_master_clk_sel_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_pempty_flag_type != "pempty_rd_side")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_pempty_flag_type_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_pfull_flag_type != "pfull_wr_side")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_pfull_flag_type_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_phcomp_rd_del != "phcomp_rd_del2")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_phcomp_rd_del_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_pld_if_type != "fifo")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_pld_if_type_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_prot_mode != "disable_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_prot_mode_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rand_clken != "rand_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rand_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rd_clk_sel != "rd_rx_pld_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rd_clk_sel_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rdfifo_clken != "rdfifo_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rdfifo_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rx_fifo_write_ctrl != "blklock_stops")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rx_fifo_write_ctrl_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rx_scrm_width != "bit64")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rx_scrm_width_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rx_sh_location != "msb")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rx_sh_location_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rx_signal_ok_sel != "synchronized_ver")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rx_signal_ok_sel_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rx_sm_bypass != "rx_sm_bypass_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rx_sm_bypass_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rx_sm_hiber != "rx_sm_hiber_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rx_sm_hiber_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rx_sm_pipeln != "rx_sm_pipeln_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rx_sm_pipeln_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rx_testbus_sel != "rx_fifo_testbus1")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rx_testbus_sel_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rx_true_b2b != "b2b")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rx_true_b2b_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rxfifo_empty != "empty_default")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rxfifo_empty_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rxfifo_full != "full_default")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rxfifo_full_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rxfifo_mode != "phase_comp")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rxfifo_mode_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rxfifo_pempty != 2)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rxfifo_pempty_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_rxfifo_pfull != 23)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_rxfifo_pfull_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_stretch_num_stages != "zero_stage")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_stretch_num_stages_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_sup_mode_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_test_mode != "test_off")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_test_mode_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_wrfifo_clken != "wrfifo_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_wrfifo_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_rx_pcs_advanced_user_mode != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_rx_pcs_advanced_user_mode_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_bitslip_en != "bitslip_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_bitslip_en_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_bonding_dft_en != "dft_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_bonding_dft_en_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_bonding_dft_val != "dft_0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_bonding_dft_val_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_crcgen_bypass != "crcgen_bypass_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_crcgen_bypass_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_crcgen_clken != "crcgen_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_crcgen_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_crcgen_err != "crcgen_err_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_crcgen_err_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_crcgen_inv != "crcgen_inv_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_crcgen_inv_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_ctrl_bit_reverse != "ctrl_bit_reverse_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_ctrl_bit_reverse_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_data_bit_reverse != "data_bit_reverse_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_data_bit_reverse_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_dft_clk_out_sel != "tx_master_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_dft_clk_out_sel_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_dispgen_bypass != "dispgen_bypass_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_dispgen_bypass_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_dispgen_clken != "dispgen_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_dispgen_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_dispgen_err != "dispgen_err_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_dispgen_err_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_dispgen_pipeln != "dispgen_pipeln_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_dispgen_pipeln_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_empty_flag_type != "empty_rd_side")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_empty_flag_type_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_enc_64b66b_txsm_bypass != "enc_64b66b_txsm_bypass_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_enc_64b66b_txsm_bypass_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_enc64b66b_txsm_clken != "enc64b66b_txsm_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_enc64b66b_txsm_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_fastpath != "fastpath_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_fastpath_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_fec_clken != "fec_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_fec_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_fec_enable != "fec_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_fec_enable_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_fifo_double_write != "fifo_double_write_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_fifo_double_write_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_fifo_reg_fast != "fifo_reg_fast_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_fifo_reg_fast_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_fifo_stop_rd != "rd_empty")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_fifo_stop_rd_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_fifo_stop_wr != "n_wr_full")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_fifo_stop_wr_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_frmgen_burst != "frmgen_burst_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_frmgen_burst_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_frmgen_bypass != "frmgen_bypass_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_frmgen_bypass_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_frmgen_clken != "frmgen_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_frmgen_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_frmgen_mfrm_length != 2048)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_frmgen_mfrm_length_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_frmgen_pipeln != "frmgen_pipeln_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_frmgen_pipeln_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_frmgen_pyld_ins != "frmgen_pyld_ins_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_frmgen_pyld_ins_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_frmgen_wordslip != "frmgen_wordslip_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_frmgen_wordslip_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_full_flag_type != "full_wr_side")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_full_flag_type_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_gb_pipeln_bypass != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_gb_pipeln_bypass_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_gb_tx_idwidth != "width_64")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_gb_tx_idwidth_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_gb_tx_odwidth != "width_64")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_gb_tx_odwidth_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_gbred_clken != "gbred_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_gbred_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_low_latency_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_low_latency_en_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_master_clk_sel != "master_tx_pma_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_master_clk_sel_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_pempty_flag_type != "pempty_rd_side")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_pempty_flag_type_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_pfull_flag_type != "pfull_wr_side")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_pfull_flag_type_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_phcomp_rd_del != "phcomp_rd_del2")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_phcomp_rd_del_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_pld_if_type != "fifo")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_pld_if_type_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_prot_mode != "disable_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_prot_mode_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_pseudo_random != "all_0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_pseudo_random_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_pseudo_seed_a != "288230376151711743")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_pseudo_seed_a_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_pseudo_seed_b != "288230376151711743")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_pseudo_seed_b_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_random_disp != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_random_disp_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_rdfifo_clken != "rdfifo_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_rdfifo_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_scrm_bypass != "scrm_bypass_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_scrm_bypass_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_scrm_clken != "scrm_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_scrm_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_scrm_mode != "async")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_scrm_mode_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_scrm_pipeln != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_scrm_pipeln_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_sh_err != "sh_err_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_sh_err_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_sop_mark != "sop_mark_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_sop_mark_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_stretch_num_stages != "zero_stage")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_stretch_num_stages_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_sup_mode_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_test_mode != "test_off")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_test_mode_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_tx_scrm_err != "scrm_err_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_tx_scrm_err_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_tx_scrm_width != "bit64")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_tx_scrm_width_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_tx_sh_location != "msb")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_tx_sh_location_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_tx_sm_bypass != "tx_sm_bypass_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_tx_sm_bypass_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_tx_sm_pipeln != "tx_sm_pipeln_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_tx_sm_pipeln_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_tx_testbus_sel != "tx_fifo_testbus1")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_tx_testbus_sel_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_txfifo_empty != "empty_default")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_txfifo_empty_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_txfifo_full != "full_default")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_txfifo_full_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_txfifo_mode != "phase_comp")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_txfifo_mode_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_txfifo_pempty != 2)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_txfifo_pempty_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_txfifo_pfull != 11)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_txfifo_pfull_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_wr_clk_sel != "wr_tx_pld_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_wr_clk_sel_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_wrfifo_clken != "wrfifo_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_wrfifo_clken_check ( .error(1'b1) );
		end
		if (hssi_10g_tx_pcs_advanced_user_mode != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_10g_tx_pcs_advanced_user_mode_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_auto_error_replacement != "en_err_replace")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_auto_error_replacement_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_bit_reversal != "dis_bit_reversal")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_bit_reversal_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_bonding_dft_en != "dft_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_bonding_dft_en_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_bonding_dft_val != "dft_0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_bonding_dft_val_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_bypass_pipeline_reg != "dis_bypass_pipeline")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_bypass_pipeline_reg_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_byte_deserializer != "en_bds_by_4")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_byte_deserializer_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask != "en_rxvalid_mask")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_clkcmp_pattern_n != 192892)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_clkcmp_pattern_n_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_clkcmp_pattern_p != 855683)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_clkcmp_pattern_p_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_clock_gate_bds_dec_asn != "dis_bds_dec_asn_clk_gating")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_clock_gate_bds_dec_asn_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_clock_gate_cdr_eidle != "dis_cdr_eidle_clk_gating")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_clock_gate_cdr_eidle_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk != "en_dw_pc_wrclk_gating")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_clock_gate_dw_rm_rd != "en_dw_rm_rdclk_gating")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_clock_gate_dw_rm_rd_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_clock_gate_dw_rm_wr != "en_dw_rm_wrclk_gating")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_clock_gate_dw_rm_wr_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_clock_gate_dw_wa != "en_dw_wa_clk_gating")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_clock_gate_dw_wa_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_clock_gate_pc_rdclk != "dis_pc_rdclk_gating")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_clock_gate_pc_rdclk_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk != "dis_sw_pc_wrclk_gating")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_clock_gate_sw_rm_rd != "dis_sw_rm_rdclk_gating")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_clock_gate_sw_rm_rd_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_clock_gate_sw_rm_wr != "dis_sw_rm_wrclk_gating")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_clock_gate_sw_rm_wr_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_clock_gate_sw_wa != "dis_sw_wa_clk_gating")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_clock_gate_sw_wa_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_clock_observation_in_pld_core != "internal_sw_wa_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_clock_observation_in_pld_core_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_eidle_entry_eios != "dis_eidle_eios")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_eidle_entry_eios_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_eidle_entry_iei != "dis_eidle_iei")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_eidle_entry_iei_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_eidle_entry_sd != "en_eidle_sd")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_eidle_entry_sd_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_eightb_tenb_decoder != "en_8b10b_ibm")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_eightb_tenb_decoder_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_err_flags_sel != "err_flags_wa")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_err_flags_sel_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_fixed_pat_det != "dis_fixed_patdet")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_fixed_pat_det_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_fixed_pat_num != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_fixed_pat_num_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_force_signal_detect != "en_force_signal_detect")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_force_signal_detect_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_gen3_clk_en != "disable_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_gen3_clk_en_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_gen3_rx_clk_sel != "rcvd_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_gen3_rx_clk_sel_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_gen3_tx_clk_sel != "tx_pma_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_gen3_tx_clk_sel_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_hip_mode != "en_hip")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_hip_mode_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_ibm_invalid_code != "dis_ibm_invalid_code")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_ibm_invalid_code_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_invalid_code_flag_only != "dis_invalid_code_only")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_invalid_code_flag_only_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_pad_or_edb_error_replace != "replace_edb_dynamic")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_pad_or_edb_error_replace_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_pcs_bypass != "dis_pcs_bypass")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_pcs_bypass_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_phase_comp_rdptr != "disable_rdptr")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_phase_comp_rdptr_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_phase_compensation_fifo != "register_fifo")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_phase_compensation_fifo_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_pipe_if_enable != "en_pipe3_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_pipe_if_enable_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_pma_dw != "ten_bit")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_pma_dw_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_polinv_8b10b_dec != "en_polinv_8b10b_dec")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_polinv_8b10b_dec_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_prot_mode != "pipe_g2")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_prot_mode_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_rate_match != "pipe_rm")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_rate_match_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_rate_match_del_thres != "pipe_rm_del_thres")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_rate_match_del_thres_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_rate_match_empty_thres != "pipe_rm_empty_thres")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_rate_match_empty_thres_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_rate_match_full_thres != "pipe_rm_full_thres")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_rate_match_full_thres_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_rate_match_ins_thres != "pipe_rm_ins_thres")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_rate_match_ins_thres_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_rate_match_start_thres != "pipe_rm_start_thres")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_rate_match_start_thres_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_rx_clk_free_running != "en_rx_clk_free_run")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_rx_clk_free_running_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_rx_clk2 != "tx_pma_clock_clk2")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_rx_clk2_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_rx_pcs_urst != "en_rx_pcs_urst")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_rx_pcs_urst_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_rx_rcvd_clk != "rcvd_clk_rcvd_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_rx_rcvd_clk_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_rx_rd_clk != "rx_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_rx_rd_clk_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_rx_refclk != "dis_refclk_sel")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_rx_refclk_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_rx_wr_clk != "txfifo_rd_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_rx_wr_clk_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_sup_mode_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_symbol_swap != "dis_symbol_swap")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_symbol_swap_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_sync_sm_idle_eios != "en_syncsm_idle")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_sync_sm_idle_eios_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_test_bus_sel != "tx_testbus")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_test_bus_sel_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_tx_rx_parallel_loopback != "dis_plpbk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_tx_rx_parallel_loopback_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wa_boundary_lock_ctrl != "sync_sm")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wa_boundary_lock_ctrl_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wa_clk_slip_spacing != 16)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wa_clk_slip_spacing_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wa_det_latency_sync_status_beh != "dont_care_assert_sync")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wa_det_latency_sync_status_beh_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wa_disp_err_flag != "en_disp_err_flag")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wa_disp_err_flag_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wa_kchar != "dis_kchar")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wa_kchar_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wa_pd != "wa_pd_10")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wa_pd_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wa_pd_data != "380")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wa_pd_data_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wa_pd_polarity != "dont_care_both_pol")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wa_pd_polarity_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wa_pld_controlled != "dis_pld_ctrl")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wa_pld_controlled_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wa_renumber_data != 16)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wa_renumber_data_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wa_rgnumber_data != 15)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wa_rgnumber_data_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wa_rknumber_data != 3)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wa_rknumber_data_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wa_rosnumber_data != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wa_rosnumber_data_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wa_rvnumber_data != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wa_rvnumber_data_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wa_sync_sm_ctrl != "pipe_sync_sm")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wa_sync_sm_ctrl_check ( .error(1'b1) );
		end
		if (hssi_8g_rx_pcs_wait_cnt != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_rx_pcs_wait_cnt_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_bit_reversal != "dis_bit_reversal")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_bit_reversal_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_bonding_dft_en != "dft_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_bonding_dft_en_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_bonding_dft_val != "dft_0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_bonding_dft_val_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_bypass_pipeline_reg != "dis_bypass_pipeline")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_bypass_pipeline_reg_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_byte_serializer != "en_bs_by_4")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_byte_serializer_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_clock_gate_bs_enc != "dis_bs_enc_clk_gating")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_clock_gate_bs_enc_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_clock_gate_dw_fifowr != "en_dw_fifowr_clk_gating")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_clock_gate_dw_fifowr_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_clock_gate_fiford != "dis_fiford_clk_gating")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_clock_gate_fiford_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_clock_gate_sw_fifowr != "dis_sw_fifowr_clk_gating")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_clock_gate_sw_fifowr_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_clock_observation_in_pld_core != "internal_refclk_b")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_clock_observation_in_pld_core_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_data_selection_8b10b_encoder_input != "normal_data_path")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_data_selection_8b10b_encoder_input_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_dynamic_clk_switch != "dis_dyn_clk_switch")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_dynamic_clk_switch_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_eightb_tenb_disp_ctrl != "en_disp_ctrl")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_eightb_tenb_disp_ctrl_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_eightb_tenb_encoder != "en_8b10b_ibm")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_eightb_tenb_encoder_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_force_echar != "dis_force_echar")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_force_echar_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_force_kchar != "dis_force_kchar")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_force_kchar_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_gen3_tx_clk_sel != "dis_tx_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_gen3_tx_clk_sel_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel != "func_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_hip_mode != "en_hip")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_hip_mode_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_pcs_bypass != "dis_pcs_bypass")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_pcs_bypass_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_phase_comp_rdptr != "disable_rdptr")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_phase_comp_rdptr_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_phase_compensation_fifo != "register_fifo")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_phase_compensation_fifo_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_phfifo_write_clk_sel != "tx_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_phfifo_write_clk_sel_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_pma_dw != "ten_bit")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_pma_dw_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_prot_mode != "pipe_g2")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_prot_mode_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_refclk_b_clk_sel != "tx_pma_clock")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_refclk_b_clk_sel_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_revloop_back_rm != "en_rev_loopback_rx_rm")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_revloop_back_rm_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_sup_mode_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_symbol_swap != "dis_symbol_swap")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_symbol_swap_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_tx_bitslip != "dis_tx_bitslip")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_tx_bitslip_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_tx_compliance_controlled_disparity != "en_txcompliance_pipe3p0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_tx_compliance_controlled_disparity_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_tx_fast_pld_reg != "dis_tx_fast_pld_reg")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_tx_fast_pld_reg_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_txclk_freerun != "en_freerun_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_txclk_freerun_check ( .error(1'b1) );
		end
		if (hssi_8g_tx_pcs_txpcs_urst != "en_txpcs_urst")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_8g_tx_pcs_txpcs_urst_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_chnl_hip_en != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_chnl_hip_en_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx != "pcie_g2_capable_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx != "ctrl_master_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx != "pma_10b_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx != "reg_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx != "single_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_chnl_func_mode != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_chnl_func_mode_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode != "tx_rx_pair_enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz != 500000000)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode != "tx_rx_pair_enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx != "non_teng_mode_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx != "single_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode != "tx_rx_pair_enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_10g_lpbk_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_10g_lpbk_en_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx != "pma_64b_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx != "fifo_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx != "disabled_prot_mode_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx != "single_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode != "tx_rx_pair_enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_8g_lpbk_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_8g_lpbk_en_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx != "pipe_g2_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_8g_hip_mode != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_8g_hip_mode_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx != "pma_10b_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx != "reg_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_g3_prot_mode != "pipe_g2")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_g3_prot_mode_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode != "tx_rx_pair_enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx != "disabled_prot_mode_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode != "tx_rx_pair_enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx != "eightg_pcie_g12_hip_mode_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx != "pma_10b_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx != "eightg_and_g3_reg_mode_hip_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_pcs_tx_clk_source != "eightg")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_pcs_tx_clk_source_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_pcs_tx_data_source != "hip_enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_pcs_tx_data_source_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en != "delay1_clk_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel != "pcs_tx_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl != "delay1_path0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel != "one_ff_delay")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en != "delay2_clk_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl != "delay2_path0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_pcs_tx_output_sel != "teng_output")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_pcs_tx_output_sel_check ( .error(1'b1) );
		end
		if (hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel != "eightg_clk_out")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_hip_en != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_hip_en_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx != "pcie_g2_capable_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx != "ctrl_master_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx != "pma_10b_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx != "reg_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx != "single_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_func_mode != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_func_mode_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode != "tx_rx_pair_enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz != 500000000)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz != 100000000)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz != 100000000)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode != "tx_rx_pair_enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx != "non_teng_mode_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx != "single_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode != "tx_rx_pair_enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_10g_lpbk_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_10g_lpbk_en_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx != "pma_64b_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx != "fifo_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx != "disabled_prot_mode_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx != "single_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode != "rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode != "tx_rx_pair_enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_8g_lpbk_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_8g_lpbk_en_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx != "pipe_g2_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_8g_hip_mode != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_8g_hip_mode_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx != "pma_10b_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx != "reg_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_g3_prot_mode != "pipe_g2")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_g3_prot_mode_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode != "tx_rx_pair_enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx != "disabled_prot_mode_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode != "tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode != "tx_rx_pair_enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx != "eightg_pcie_g12_hip_mode_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx != "pma_10b_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx != "eightg_and_g3_reg_mode_hip_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_pcs_rx_block_sel != "eightg")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_pcs_rx_block_sel_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_pcs_rx_clk_sel != "pcs_rx_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_pcs_rx_clk_sel_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en != "hip_rx_enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_pcs_rx_output_sel != "teng_output")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_pcs_rx_output_sel_check ( .error(1'b1) );
		end
		if (hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel != "eightg_clk_out")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel_check ( .error(1'b1) );
		end
		if (hssi_common_pld_pcs_interface_dft_clk_out_en != "dft_clk_out_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pld_pcs_interface_dft_clk_out_en_check ( .error(1'b1) );
		end
		if (hssi_common_pld_pcs_interface_dft_clk_out_sel != "teng_rx_dft_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pld_pcs_interface_dft_clk_out_sel_check ( .error(1'b1) );
		end
		if (hssi_common_pld_pcs_interface_hrdrstctrl_en != "hrst_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pld_pcs_interface_hrdrstctrl_en_check ( .error(1'b1) );
		end
		if (hssi_common_pld_pcs_interface_pcs_testbus_block_sel != "pma_if")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pld_pcs_interface_pcs_testbus_block_sel_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_block_sel != "eight_g_pcs")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_block_sel_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_channel_operation_mode != "tx_rx_pair_enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_channel_operation_mode_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_clkslip_sel != "pld")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_clkslip_sel_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_lpbk_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_lpbk_en_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_master_clk_sel != "master_rx_pma_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_master_clk_sel_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_pldif_datawidth_mode != "pldif_data_10bit")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_pldif_datawidth_mode_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_pma_dw_rx != "pma_10b_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_pma_dw_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_pma_if_dft_en != "dft_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_pma_if_dft_en_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_pma_if_dft_val != "dft_0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_pma_if_dft_val_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_prbs_clken != "prbs_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_prbs_clken_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_prbs_ver != "prbs_off")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_prbs_ver_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_prbs9_dwidth != "prbs9_64b")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_prbs9_dwidth_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_prot_mode_rx != "eightg_pcie_g12_hip_mode_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_prot_mode_rx_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion != "rx_dyn_polinv_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_rx_lpbk_en != "lpbk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_rx_lpbk_en_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok != "force_sig_ok")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_rx_prbs_mask != "prbsmask128")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_rx_prbs_mask_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_rx_prbs_mode != "teng_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_rx_prbs_mode_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel != "sel_sig_det")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_rx_static_polarity_inversion != "rx_stat_polinv_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_rx_static_polarity_inversion_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en != "uhsif_lpbk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en_check ( .error(1'b1) );
		end
		if (hssi_rx_pcs_pma_interface_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_rx_pcs_pma_interface_sup_mode_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_bypass_pma_txelecidle != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_bypass_pma_txelecidle_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_channel_operation_mode != "tx_rx_pair_enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_channel_operation_mode_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_lpbk_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_lpbk_en_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_master_clk_sel != "master_tx_pma_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_master_clk_sel_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx != "pipe_g12")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_pldif_datawidth_mode != "pldif_data_10bit")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_pldif_datawidth_mode_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_pma_dw_tx != "pma_10b_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_pma_dw_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_pma_if_dft_en != "dft_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_pma_if_dft_en_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_pmagate_en != "pmagate_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_pmagate_en_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_prbs_clken != "prbs_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_prbs_clken_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_prbs_gen_pat != "prbs_gen_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_prbs_gen_pat_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_prbs9_dwidth != "prbs9_64b")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_prbs9_dwidth_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_prot_mode_tx != "eightg_pcie_g12_hip_mode_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_prot_mode_tx_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_sq_wave_num != "sq_wave_default")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_sq_wave_num_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_sqwgen_clken != "sqwgen_clk_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_sqwgen_clken_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_sup_mode_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion != "tx_dyn_polinv_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_tx_pma_data_sel != "eight_g_pcs")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_tx_pma_data_sel_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_tx_static_polarity_inversion != "tx_stat_polinv_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_tx_static_polarity_inversion_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock != "uhsif_filt_stepsz_b4lock_2")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock != "uhsif_filt_cntthr_b4lock_8")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period != "uhsif_dcn_test_period_4")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable != "uhsif_dcn_test_mode_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh != "uhsif_dzt_cnt_thr_2")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable != "uhsif_dzt_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window != "uhsif_dzt_obr_win_16")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size != "uhsif_dzt_skipsz_4")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel != "uhsif_index_cram")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin != "uhsif_dcn_margin_2")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control != "uhsif_dft_dz_det_val_0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control != "uhsif_dft_up_val_0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_enable != "uhsif_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_enable_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock != "uhsif_lkd_segsz_aflock_512")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock != "uhsif_lkd_segsz_b4lock_16")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value_check ( .error(1'b1) );
		end
		if (hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_asn_clk_enable != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_asn_clk_enable_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_asn_enable != "en_asn")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_asn_enable_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_block_sel != "eight_g_pcs")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_block_sel_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_bypass_early_eios != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_bypass_early_eios_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_bypass_pcie_switch != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_bypass_pcie_switch_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_bypass_pma_ltr != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_bypass_pma_ltr_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_bypass_pma_sw_done != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_bypass_pma_sw_done_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_bypass_ppm_lock != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_bypass_ppm_lock_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_bypass_txdetectrx != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_bypass_txdetectrx_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_cdr_control != "en_cdr_ctrl")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_cdr_control_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_cid_enable != "en_cid_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_cid_enable_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_data_mask_count != 2500)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_data_mask_count_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_data_mask_count_multi != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_data_mask_count_multi_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_dft_observation_clock_selection != "dft_clk_obsrv_tx0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_dft_observation_clock_selection_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_early_eios_counter != 50)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_early_eios_counter_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_force_freqdet != "force_freqdet_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_force_freqdet_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_free_run_clk_enable != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_free_run_clk_enable_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_ignore_sigdet_g23 != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_ignore_sigdet_g23_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_pc_en_counter != 55)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_pc_en_counter_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_pc_rst_counter != 23)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_pc_rst_counter_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_pcie_hip_mode != "hip_enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_pcie_hip_mode_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_ph_fifo_reg_mode != "phfifo_reg_mode_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_ph_fifo_reg_mode_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_phfifo_flush_wait != 36)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_phfifo_flush_wait_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_pipe_if_g3pcs != "pipe_if_g3pcs")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_pipe_if_g3pcs_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_pma_done_counter != 175000)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_pma_done_counter_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_pma_if_dft_en != "dft_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_pma_if_dft_en_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_pma_if_dft_val != "dft_0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_pma_if_dft_val_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_ppm_cnt_rst != "ppm_cnt_rst_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_ppm_cnt_rst_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_ppm_deassert_early != "deassert_early_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_ppm_deassert_early_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_ppm_gen1_2_cnt != "cnt_32k")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_ppm_gen1_2_cnt_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_ppm_post_eidle_delay != "cnt_200_cycles")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_ppm_post_eidle_delay_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_ppmsel != "ppmsel_300")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_ppmsel_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_prot_mode != "pipe_g12")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_prot_mode_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_rxvalid_mask != "rxvalid_mask_en")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_rxvalid_mask_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_sigdet_wait_counter != 2500)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_sigdet_wait_counter_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_sigdet_wait_counter_multi != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_sigdet_wait_counter_multi_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_sim_mode != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_sim_mode_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_sup_mode_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_testout_sel != "asn_test")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_testout_sel_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_wait_clk_on_off_timer != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_wait_clk_on_off_timer_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_wait_pipe_synchronizing != 23)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_wait_pipe_synchronizing_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_wait_send_syncp_fbkp != 250)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_wait_send_syncp_fbkp_check ( .error(1'b1) );
		end
		if (hssi_common_pcs_pma_interface_ppm_det_buckets != "ppm_300_bucket")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_common_pcs_pma_interface_ppm_det_buckets_check ( .error(1'b1) );
		end
		if (hssi_fifo_rx_pcs_double_read_mode != "double_read_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_fifo_rx_pcs_double_read_mode_check ( .error(1'b1) );
		end
		if (hssi_fifo_rx_pcs_prot_mode != "non_teng_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_fifo_rx_pcs_prot_mode_check ( .error(1'b1) );
		end
		if (hssi_fifo_tx_pcs_double_write_mode != "double_write_dis")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_fifo_tx_pcs_double_write_mode_check ( .error(1'b1) );
		end
		if (hssi_fifo_tx_pcs_prot_mode != "non_teng_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_fifo_tx_pcs_prot_mode_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen3_bypass_rx_detection_enable != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen3_bypass_rx_detection_enable_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen3_bypass_rx_preset != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen3_bypass_rx_preset_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen3_bypass_rx_preset_enable != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen3_bypass_rx_preset_enable_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen3_bypass_tx_coefficent != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen3_bypass_tx_coefficent_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen3_bypass_tx_coefficent_enable != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen3_bypass_tx_coefficent_enable_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen3_elecidle_delay_g3 != 6)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen3_elecidle_delay_g3_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen3_ind_error_reporting != "dis_ind_error_reporting")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen3_ind_error_reporting_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen3_mode != "pipe_g2")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen3_mode_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen3_phy_status_delay_g12 != 5)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen3_phy_status_delay_g12_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen3_phy_status_delay_g3 != 5)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen3_phy_status_delay_g3_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen3_phystatus_rst_toggle_g12 != "dis_phystatus_rst_toggle")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen3_phystatus_rst_toggle_g12_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen3_phystatus_rst_toggle_g3 != "dis_phystatus_rst_toggle_g3")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen3_phystatus_rst_toggle_g3_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen3_rate_match_pad_insertion != "dis_rm_fifo_pad_ins")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen3_rate_match_pad_insertion_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen3_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen3_sup_mode_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen3_test_out_sel != "disable_test_out")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen3_test_out_sel_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen1_2_elec_idle_delay_val != 3)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen1_2_elec_idle_delay_val_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen1_2_error_replace_pad != "replace_edb")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen1_2_error_replace_pad_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen1_2_hip_mode != "en_hip")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen1_2_hip_mode_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen1_2_ind_error_reporting != "dis_ind_error_reporting")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen1_2_ind_error_reporting_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen1_2_phystatus_delay_val != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen1_2_phystatus_delay_val_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen1_2_phystatus_rst_toggle != "dis_phystatus_rst_toggle")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen1_2_phystatus_rst_toggle_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen1_2_pipe_byte_de_serializer_en != "dont_care_bds")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen1_2_pipe_byte_de_serializer_en_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen1_2_prot_mode != "pipe_g2")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen1_2_prot_mode_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen1_2_rx_pipe_enable != "en_pipe3_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen1_2_rx_pipe_enable_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen1_2_rxdetect_bypass != "dis_rxdetect_bypass")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen1_2_rxdetect_bypass_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen1_2_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen1_2_sup_mode_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen1_2_tx_pipe_enable != "en_pipe3_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen1_2_tx_pipe_enable_check ( .error(1'b1) );
		end
		if (hssi_pipe_gen1_2_txswing != "dis_txswing")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pipe_gen1_2_txswing_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_1s_ctle_bypass != "radp_1s_ctle_bypass_1")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_1s_ctle_bypass_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_4s_ctle_bypass != "radp_4s_ctle_bypass_1")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_4s_ctle_bypass_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_ctle_en != "radp_ctle_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_ctle_en_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_dfe_fltap_bypass != "radp_dfe_fltap_bypass_1")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_dfe_fltap_bypass_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_dfe_fltap_en != "radp_dfe_fltap_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_dfe_fltap_en_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_dfe_fxtap_bypass != "radp_dfe_fxtap_bypass_1")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_dfe_fxtap_bypass_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_dfe_fxtap_en != "radp_dfe_fxtap_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_dfe_fxtap_en_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_dfe_fxtap_hold_en != "radp_dfe_fxtap_not_held")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_dfe_fxtap_hold_en_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_dfe_mode != "radp_dfe_mode_4")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_dfe_mode_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_vga_bypass != "radp_vga_bypass_1")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_vga_bypass_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_vga_en != "radp_vga_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_vga_en_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_vref_bypass != "radp_vref_bypass_1")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_vref_bypass_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_vref_en != "radp_vref_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_vref_en_check ( .error(1'b1) );
		end
		if (pma_adapt_datarate != "5000000000 bps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_datarate_check ( .error(1'b1) );
		end
		if (pma_adapt_prot_mode != "pcie_gen2_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_prot_mode_check ( .error(1'b1) );
		end
		if (pma_adapt_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_sup_mode_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_ctle_adapt_cycle_window != "radp_ctle_adapt_cycle_window_7")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_ctle_adapt_cycle_window_check ( .error(1'b1) );
		end
		if (pma_adapt_odi_dfe_spec_en != "rodi_dfe_spec_en_0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_odi_dfe_spec_en_check ( .error(1'b1) );
		end
		if (pma_adapt_adapt_mode != "manual")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adapt_mode_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_onetime_dfe != "radp_onetime_dfe_0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_onetime_dfe_check ( .error(1'b1) );
		end
		if (pma_adapt_adp_mode != "radp_mode_8")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_adapt_adp_mode_check ( .error(1'b1) );
		end
		if (pma_cdr_refclk_powerdown_mode != "powerup")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_cdr_refclk_powerdown_mode_check ( .error(1'b1) );
		end
		if (pma_cdr_refclk_refclk_select != "ref_iqclk0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_cdr_refclk_refclk_select_check ( .error(1'b1) );
		end
		if (pma_cgb_bitslip_enable != "disable_bitslip")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_cgb_bitslip_enable_check ( .error(1'b1) );
		end
		if (pma_cgb_bonding_reset_enable != "disallow_bonding_reset")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_cgb_bonding_reset_enable_check ( .error(1'b1) );
		end
		if (pma_cgb_datarate != "5000000000 bps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_cgb_datarate_check ( .error(1'b1) );
		end
		if (pma_cgb_pcie_gen3_bitwidth != "pciegen3_wide")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_cgb_pcie_gen3_bitwidth_check ( .error(1'b1) );
		end
		if (pma_cgb_prot_mode != "pcie_gen2_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_cgb_prot_mode_check ( .error(1'b1) );
		end
		if (pma_cgb_ser_mode != "ten_bit")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_cgb_ser_mode_check ( .error(1'b1) );
		end
		if (pma_cgb_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_cgb_sup_mode_check ( .error(1'b1) );
		end
		if (pma_cgb_x1_div_m_sel != "divbypass")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_cgb_x1_div_m_sel_check ( .error(1'b1) );
		end
		if (pma_cgb_input_select_x1 != "unused")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_cgb_input_select_x1_check ( .error(1'b1) );
		end
		if (pma_cgb_input_select_gen3 != "unused")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_cgb_input_select_gen3_check ( .error(1'b1) );
		end
		if (pma_cgb_input_select_xn != "sel_x6_dn")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_cgb_input_select_xn_check ( .error(1'b1) );
		end
		if (pma_cgb_tx_ucontrol_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_cgb_tx_ucontrol_en_check ( .error(1'b1) );
		end
		if (pma_rx_dfe_datarate != "5000000000 bps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_dfe_datarate_check ( .error(1'b1) );
		end
		if (pma_rx_dfe_dft_en != "dft_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_dfe_dft_en_check ( .error(1'b1) );
		end
		if (pma_rx_dfe_pdb != "dfe_enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_dfe_pdb_check ( .error(1'b1) );
		end
		if (pma_rx_dfe_pdb_fixedtap != "fixtap_dfe_powerdown")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_dfe_pdb_fixedtap_check ( .error(1'b1) );
		end
		if (pma_rx_dfe_pdb_floattap != "floattap_dfe_powerdown")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_dfe_pdb_floattap_check ( .error(1'b1) );
		end
		if (pma_rx_dfe_pdb_fxtap4t7 != "fxtap4t7_powerdown")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_dfe_pdb_fxtap4t7_check ( .error(1'b1) );
		end
		if (pma_rx_dfe_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_dfe_sup_mode_check ( .error(1'b1) );
		end
		if (pma_rx_dfe_prot_mode != "pcie_gen2_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_dfe_prot_mode_check ( .error(1'b1) );
		end
		if (pma_rx_odi_datarate != "5000000000 bps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_odi_datarate_check ( .error(1'b1) );
		end
		if (pma_rx_odi_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_odi_sup_mode_check ( .error(1'b1) );
		end
		if (pma_rx_odi_step_ctrl_sel != "dprio_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_odi_step_ctrl_sel_check ( .error(1'b1) );
		end
		if (pma_rx_odi_prot_mode != "pcie_gen2_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_odi_prot_mode_check ( .error(1'b1) );
		end
		if (pma_rx_buf_bypass_eqz_stages_234 != "bypass_off")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_bypass_eqz_stages_234_check ( .error(1'b1) );
		end
		if (pma_rx_buf_datarate != "5000000000 bps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_datarate_check ( .error(1'b1) );
		end
		if (pma_rx_buf_diag_lp_en != "dlp_off")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_diag_lp_en_check ( .error(1'b1) );
		end
		if (pma_rx_buf_prot_mode != "pcie_gen2_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_prot_mode_check ( .error(1'b1) );
		end
		if (pma_rx_buf_qpi_enable != "non_qpi_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_qpi_enable_check ( .error(1'b1) );
		end
		if (pma_rx_buf_rx_refclk_divider != "bypass_divider")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_rx_refclk_divider_check ( .error(1'b1) );
		end
		if (pma_rx_buf_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_sup_mode_check ( .error(1'b1) );
		end
		if (pma_rx_buf_loopback_modes != "lpbk_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_loopback_modes_check ( .error(1'b1) );
		end
		if (pma_rx_buf_refclk_en != "disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_refclk_en_check ( .error(1'b1) );
		end
		if (pma_rx_buf_pm_tx_rx_pcie_gen != "non_pcie")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_pm_tx_rx_pcie_gen_check ( .error(1'b1) );
		end
		if (pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth != "pcie_gen3_32b")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth_check ( .error(1'b1) );
		end
		if (pma_rx_buf_pm_tx_rx_cvp_mode != "cvp_off")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_pm_tx_rx_cvp_mode_check ( .error(1'b1) );
		end
		if (pma_rx_buf_xrx_path_uc_cal_enable != "rx_cal_off")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_xrx_path_uc_cal_enable_check ( .error(1'b1) );
		end
		if (pma_rx_buf_xrx_path_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_xrx_path_sup_mode_check ( .error(1'b1) );
		end
		if (pma_rx_buf_xrx_path_prot_mode != "pcie_gen2_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_xrx_path_prot_mode_check ( .error(1'b1) );
		end
		if (pma_rx_buf_xrx_path_datarate != "5000000000 bps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_xrx_path_datarate_check ( .error(1'b1) );
		end
		if (pma_rx_buf_xrx_path_datawidth != 10)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_xrx_path_datawidth_check ( .error(1'b1) );
		end
		if (pma_rx_buf_xrx_path_pma_rx_divclk_hz != "500000000")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_buf_xrx_path_pma_rx_divclk_hz_check ( .error(1'b1) );
		end
		if (pma_rx_sd_prot_mode != "pcie_gen2_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_sd_prot_mode_check ( .error(1'b1) );
		end
		if (pma_rx_sd_sd_output_off != 13)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_sd_sd_output_off_check ( .error(1'b1) );
		end
		if (pma_rx_sd_sd_output_on != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_sd_sd_output_on_check ( .error(1'b1) );
		end
		if (pma_rx_sd_sd_pdb != "sd_on")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_sd_sd_pdb_check ( .error(1'b1) );
		end
		if (pma_rx_sd_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_sd_sup_mode_check ( .error(1'b1) );
		end
		if (pma_tx_ser_ser_clk_divtx_user_sel != "divtx_user_off")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_ser_ser_clk_divtx_user_sel_check ( .error(1'b1) );
		end
		if (pma_tx_ser_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_ser_sup_mode_check ( .error(1'b1) );
		end
		if (pma_tx_ser_prot_mode != "pcie_gen2_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_ser_prot_mode_check ( .error(1'b1) );
		end
		if (pma_tx_buf_datarate != "5000000000 bps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_buf_datarate_check ( .error(1'b1) );
		end
		if (pma_tx_buf_prot_mode != "pcie_gen2_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_buf_prot_mode_check ( .error(1'b1) );
		end
		if (pma_tx_buf_rx_det != "mode_0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_buf_rx_det_check ( .error(1'b1) );
		end
		if (pma_tx_buf_rx_det_output_sel != "rx_det_pcie_out")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_buf_rx_det_output_sel_check ( .error(1'b1) );
		end
		if (pma_tx_buf_rx_det_pdb != "rx_det_on")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_buf_rx_det_pdb_check ( .error(1'b1) );
		end
		if (pma_tx_buf_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_buf_sup_mode_check ( .error(1'b1) );
		end
		if (pma_tx_buf_user_fir_coeff_ctrl_sel != "dynamic_ctl")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_buf_user_fir_coeff_ctrl_sel_check ( .error(1'b1) );
		end
		if (pma_tx_buf_xtx_path_prot_mode != "pcie_gen2_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_buf_xtx_path_prot_mode_check ( .error(1'b1) );
		end
		if (pma_tx_buf_xtx_path_datarate != "5000000000 bps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_buf_xtx_path_datarate_check ( .error(1'b1) );
		end
		if (pma_tx_buf_xtx_path_datawidth != 10)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_buf_xtx_path_datawidth_check ( .error(1'b1) );
		end
		if (pma_tx_buf_xtx_path_clock_divider_ratio != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_buf_xtx_path_clock_divider_ratio_check ( .error(1'b1) );
		end
		if (pma_tx_buf_xtx_path_pma_tx_divclk_hz != "500000000")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_buf_xtx_path_pma_tx_divclk_hz_check ( .error(1'b1) );
		end
		if (pma_tx_buf_xtx_path_tx_pll_clk_hz != "2500000000")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_buf_xtx_path_tx_pll_clk_hz_check ( .error(1'b1) );
		end
		if (pma_tx_buf_xtx_path_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_tx_buf_xtx_path_sup_mode_check ( .error(1'b1) );
		end
		if (cdr_pll_pma_width != 10)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_pma_width_check ( .error(1'b1) );
		end
		if (cdr_pll_cgb_div != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_cgb_div_check ( .error(1'b1) );
		end
		if (cdr_pll_is_cascaded_pll != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_is_cascaded_pll_check ( .error(1'b1) );
		end
		if (cdr_pll_datarate != "5000000000 bps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_datarate_check ( .error(1'b1) );
		end
		if (cdr_pll_lpd_counter != 4)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_lpd_counter_check ( .error(1'b1) );
		end
		if (cdr_pll_lpfd_counter != 4)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_lpfd_counter_check ( .error(1'b1) );
		end
		if (cdr_pll_n_counter_scratch != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_n_counter_scratch_check ( .error(1'b1) );
		end
		if (cdr_pll_output_clock_frequency != "2500000000 Hz")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_output_clock_frequency_check ( .error(1'b1) );
		end
		if (cdr_pll_reference_clock_frequency != "100000000 hz")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_reference_clock_frequency_check ( .error(1'b1) );
		end
		if (cdr_pll_set_cdr_vco_speed != 2)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_set_cdr_vco_speed_check ( .error(1'b1) );
		end
		if (cdr_pll_set_cdr_vco_speed_fix != 117)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_set_cdr_vco_speed_fix_check ( .error(1'b1) );
		end
		if (cdr_pll_vco_freq != "10000000000 Hz")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_vco_freq_check ( .error(1'b1) );
		end
		if (cdr_pll_atb_select_control != "atb_off")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_atb_select_control_check ( .error(1'b1) );
		end
		if (cdr_pll_auto_reset_on != "auto_reset_off")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_auto_reset_on_check ( .error(1'b1) );
		end
		if (cdr_pll_bbpd_data_pattern_filter_select != "bbpd_data_pat_off")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_bbpd_data_pattern_filter_select_check ( .error(1'b1) );
		end
		if (cdr_pll_bw_sel != "medium")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_bw_sel_check ( .error(1'b1) );
		end
		if (cdr_pll_cdr_odi_select != "sel_cdr")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_cdr_odi_select_check ( .error(1'b1) );
		end
		if (cdr_pll_cdr_phaselock_mode != "no_ignore_lock")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_cdr_phaselock_mode_check ( .error(1'b1) );
		end
		if (cdr_pll_cdr_powerdown_mode != "power_up")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_cdr_powerdown_mode_check ( .error(1'b1) );
		end
		if (cdr_pll_chgpmp_current_pd != "cp_current_pd_setting0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_chgpmp_current_pd_check ( .error(1'b1) );
		end
		if (cdr_pll_chgpmp_current_pfd != "cp_current_pfd_setting4")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_chgpmp_current_pfd_check ( .error(1'b1) );
		end
		if (cdr_pll_chgpmp_replicate != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_chgpmp_replicate_check ( .error(1'b1) );
		end
		if (cdr_pll_chgpmp_testmode != "cp_test_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_chgpmp_testmode_check ( .error(1'b1) );
		end
		if (cdr_pll_clklow_mux_select != "clklow_mux_cdr_fbclk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_clklow_mux_select_check ( .error(1'b1) );
		end
		if (cdr_pll_diag_loopback_enable != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_diag_loopback_enable_check ( .error(1'b1) );
		end
		if (cdr_pll_disable_up_dn != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_disable_up_dn_check ( .error(1'b1) );
		end
		if (cdr_pll_fref_clklow_div != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_fref_clklow_div_check ( .error(1'b1) );
		end
		if (cdr_pll_fref_mux_select != "fref_mux_cdr_refclk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_fref_mux_select_check ( .error(1'b1) );
		end
		if (cdr_pll_gpon_lck2ref_control != "gpon_lck2ref_off")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_gpon_lck2ref_control_check ( .error(1'b1) );
		end
		if (cdr_pll_initial_settings != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_initial_settings_check ( .error(1'b1) );
		end
		if (cdr_pll_lck2ref_delay_control != "lck2ref_delay_2")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_lck2ref_delay_control_check ( .error(1'b1) );
		end
		if (cdr_pll_lf_resistor_pd != "lf_pd_setting3")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_lf_resistor_pd_check ( .error(1'b1) );
		end
		if (cdr_pll_lf_resistor_pfd != "lf_pfd_setting2")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_lf_resistor_pfd_check ( .error(1'b1) );
		end
		if (cdr_pll_lf_ripple_cap != "lf_no_ripple")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_lf_ripple_cap_check ( .error(1'b1) );
		end
		if (cdr_pll_loop_filter_bias_select != "lpflt_bias_7")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_loop_filter_bias_select_check ( .error(1'b1) );
		end
		if (cdr_pll_loopback_mode != "loopback_disabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_loopback_mode_check ( .error(1'b1) );
		end
		if (cdr_pll_ltd_ltr_micro_controller_select != "ltd_ltr_pcs")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_ltd_ltr_micro_controller_select_check ( .error(1'b1) );
		end
		if (cdr_pll_m_counter != 25)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_m_counter_check ( .error(1'b1) );
		end
		if (cdr_pll_n_counter != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_n_counter_check ( .error(1'b1) );
		end
		if (cdr_pll_pd_fastlock_mode != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_pd_fastlock_mode_check ( .error(1'b1) );
		end
		if (cdr_pll_pd_l_counter != 4)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_pd_l_counter_check ( .error(1'b1) );
		end
		if (cdr_pll_pfd_l_counter != 4)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_pfd_l_counter_check ( .error(1'b1) );
		end
		if (cdr_pll_primary_use != "cdr")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_primary_use_check ( .error(1'b1) );
		end
		if (cdr_pll_prot_mode != "pcie_gen2_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_prot_mode_check ( .error(1'b1) );
		end
		if (cdr_pll_reverse_serial_loopback != "no_loopback")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_reverse_serial_loopback_check ( .error(1'b1) );
		end
		if (cdr_pll_set_cdr_v2i_enable != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_set_cdr_v2i_enable_check ( .error(1'b1) );
		end
		if (cdr_pll_set_cdr_vco_reset != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_set_cdr_vco_reset_check ( .error(1'b1) );
		end
		if (cdr_pll_set_cdr_vco_speed_pciegen3 != "cdr_vco_max_speedbin_pciegen3")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_set_cdr_vco_speed_pciegen3_check ( .error(1'b1) );
		end
		if (cdr_pll_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_sup_mode_check ( .error(1'b1) );
		end
		if (cdr_pll_tx_pll_prot_mode != "txpll_unused")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_tx_pll_prot_mode_check ( .error(1'b1) );
		end
		if (cdr_pll_txpll_hclk_driver_enable != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_txpll_hclk_driver_enable_check ( .error(1'b1) );
		end
		if (cdr_pll_vco_overrange_voltage != "vco_overrange_off")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_vco_overrange_voltage_check ( .error(1'b1) );
		end
		if (cdr_pll_vco_underrange_voltage != "vco_underange_off")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_vco_underrange_voltage_check ( .error(1'b1) );
		end
		if (cdr_pll_fb_select != "direct_fb")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_fb_select_check ( .error(1'b1) );
		end
		if (cdr_pll_uc_ro_cal != "uc_ro_cal_on")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_uc_ro_cal_check ( .error(1'b1) );
		end
		if (cdr_pll_iqclk_mux_sel != "power_down")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_iqclk_mux_sel_check ( .error(1'b1) );
		end
		if (cdr_pll_pcie_gen != "pcie_gen2_100mhzref")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_pcie_gen_check ( .error(1'b1) );
		end
		if (cdr_pll_set_cdr_input_freq_range != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_set_cdr_input_freq_range_check ( .error(1'b1) );
		end
		if (cdr_pll_chgpmp_current_dn_trim != "cp_current_trimming_dn_setting0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_chgpmp_current_dn_trim_check ( .error(1'b1) );
		end
		if (cdr_pll_chgpmp_up_pd_trim_double != "normal_up_trim_current")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_chgpmp_up_pd_trim_double_check ( .error(1'b1) );
		end
		if (cdr_pll_chgpmp_current_up_pd != "cp_current_pd_up_setting4")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_chgpmp_current_up_pd_check ( .error(1'b1) );
		end
		if (cdr_pll_chgpmp_current_up_trim != "cp_current_trimming_up_setting0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_chgpmp_current_up_trim_check ( .error(1'b1) );
		end
		if (cdr_pll_chgpmp_dn_pd_trim_double != "normal_dn_trim_current")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_chgpmp_dn_pd_trim_double_check ( .error(1'b1) );
		end
		if (cdr_pll_cal_vco_count_length != "sel_8b_count")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_cal_vco_count_length_check ( .error(1'b1) );
		end
		if (cdr_pll_chgpmp_current_dn_pd != "cp_current_pd_dn_setting4")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cdr_pll_chgpmp_current_dn_pd_check ( .error(1'b1) );
		end
		if (pma_rx_deser_clkdiv_source != "vco_bypass_normal")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_deser_clkdiv_source_check ( .error(1'b1) );
		end
		if (pma_rx_deser_clkdivrx_user_mode != "clkdivrx_user_disabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_deser_clkdivrx_user_mode_check ( .error(1'b1) );
		end
		if (pma_rx_deser_datarate != "5000000000 bps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_deser_datarate_check ( .error(1'b1) );
		end
		if (pma_rx_deser_deser_factor != 10)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_deser_deser_factor_check ( .error(1'b1) );
		end
		if (pma_rx_deser_force_clkdiv_for_testing != "normal_clkdiv")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_deser_force_clkdiv_for_testing_check ( .error(1'b1) );
		end
		if (pma_rx_deser_sdclk_enable != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_deser_sdclk_enable_check ( .error(1'b1) );
		end
		if (pma_rx_deser_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_deser_sup_mode_check ( .error(1'b1) );
		end
		if (pma_rx_deser_rst_n_adapt_odi != "no_rst_adapt_odi")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_deser_rst_n_adapt_odi_check ( .error(1'b1) );
		end
		if (pma_rx_deser_bitslip_bypass != "bs_bypass_yes")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_deser_bitslip_bypass_check ( .error(1'b1) );
		end
		if (pma_rx_deser_prot_mode != "pcie_gen2_rx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_deser_prot_mode_check ( .error(1'b1) );
		end
		if (pma_rx_deser_pcie_gen != "pcie_gen2_100mhzref")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_deser_pcie_gen_check ( .error(1'b1) );
		end
		if (pma_rx_deser_pcie_gen_bitwidth != "pcie_gen3_32b")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					pma_rx_deser_pcie_gen_bitwidth_check ( .error(1'b1) );
		end
	endgenerate

	main_altera_xcvr_native_a10_171_ymh4x7q #(
		.device_revision                                                        ("20nm5"),
		.duplex_mode                                                            ("duplex"),
		.channels                                                               (4),
		.enable_calibration                                                     (1),
		.enable_analog_resets                                                   (1),
		.enable_reset_sequence                                                  (1),
		.bonded_mode                                                            ("pma_pcs"),
		.pcs_bonding_master                                                     (3),
		.plls                                                                   (1),
		.number_physical_bonding_clocks                                         (1),
		.cdr_refclk_cnt                                                         (1),
		.enable_hip                                                             (1),
		.hip_cal_en                                                             ("enable"),
		.rcfg_enable                                                            (1),
		.rcfg_shared                                                            (1),
		.rcfg_jtag_enable                                                       (0),
		.rcfg_separate_avmm_busy                                                (0),
		.adme_prot_mode                                                         ("pipe_g2"),
		.adme_data_rate                                                         ("5000000000"),
		.enable_pcie_dfe_ip                                                     (0),
		.sim_reduced_counters                                                   (0),
		.disable_continuous_dfe                                                 (0),
		.dbg_embedded_debug_enable                                              (0),
		.dbg_capability_reg_enable                                              (0),
		.dbg_user_identifier                                                    (0),
		.dbg_stat_soft_logic_enable                                             (0),
		.dbg_ctrl_soft_logic_enable                                             (0),
		.dbg_prbs_soft_logic_enable                                             (0),
		.dbg_odi_soft_logic_enable                                              (0),
		.rcfg_emb_strm_enable                                                   (0),
		.rcfg_profile_cnt                                                       (2),
		.hssi_gen3_rx_pcs_block_sync                                            ("bypass_block_sync"),
		.hssi_gen3_rx_pcs_block_sync_sm                                         ("disable_blk_sync_sm"),
		.hssi_gen3_rx_pcs_cdr_ctrl_force_unalgn                                 ("disable"),
		.hssi_gen3_rx_pcs_lpbk_force                                            ("lpbk_frce_dis"),
		.hssi_gen3_rx_pcs_mode                                                  ("disable_pcs"),
		.hssi_gen3_rx_pcs_rate_match_fifo                                       ("bypass_rm_fifo"),
		.hssi_gen3_rx_pcs_rate_match_fifo_latency                               ("low_latency"),
		.hssi_gen3_rx_pcs_reverse_lpbk                                          ("rev_lpbk_dis"),
		.hssi_gen3_rx_pcs_rx_b4gb_par_lpbk                                      ("b4gb_par_lpbk_dis"),
		.hssi_gen3_rx_pcs_rx_force_balign                                       ("dis_force_balign"),
		.hssi_gen3_rx_pcs_rx_ins_del_one_skip                                   ("ins_del_one_skip_dis"),
		.hssi_gen3_rx_pcs_rx_num_fixed_pat                                      (0),
		.hssi_gen3_rx_pcs_rx_test_out_sel                                       ("rx_test_out0"),
		.hssi_gen3_rx_pcs_sup_mode                                              ("user_mode"),
		.hssi_gen3_tx_pcs_mode                                                  ("disable_pcs"),
		.hssi_gen3_tx_pcs_reverse_lpbk                                          ("rev_lpbk_dis"),
		.hssi_gen3_tx_pcs_sup_mode                                              ("user_mode"),
		.hssi_gen3_tx_pcs_tx_bitslip                                            (0),
		.hssi_gen3_tx_pcs_tx_gbox_byp                                           ("bypass_gbox"),
		.hssi_krfec_rx_pcs_blksync_cor_en                                       ("detect"),
		.hssi_krfec_rx_pcs_bypass_gb                                            ("bypass_dis"),
		.hssi_krfec_rx_pcs_clr_ctrl                                             ("both_enabled"),
		.hssi_krfec_rx_pcs_ctrl_bit_reverse                                     ("ctrl_bit_reverse_en"),
		.hssi_krfec_rx_pcs_data_bit_reverse                                     ("data_bit_reverse_dis"),
		.hssi_krfec_rx_pcs_dv_start                                             ("with_blklock"),
		.hssi_krfec_rx_pcs_err_mark_type                                        ("err_mark_10g"),
		.hssi_krfec_rx_pcs_error_marking_en                                     ("err_mark_dis"),
		.hssi_krfec_rx_pcs_low_latency_en                                       ("disable"),
		.hssi_krfec_rx_pcs_lpbk_mode                                            ("lpbk_dis"),
		.hssi_krfec_rx_pcs_parity_invalid_enum                                  (8),
		.hssi_krfec_rx_pcs_parity_valid_num                                     (4),
		.hssi_krfec_rx_pcs_pipeln_blksync                                       ("enable"),
		.hssi_krfec_rx_pcs_pipeln_descrm                                        ("disable"),
		.hssi_krfec_rx_pcs_pipeln_errcorrect                                    ("disable"),
		.hssi_krfec_rx_pcs_pipeln_errtrap_ind                                   ("enable"),
		.hssi_krfec_rx_pcs_pipeln_errtrap_lfsr                                  ("disable"),
		.hssi_krfec_rx_pcs_pipeln_errtrap_loc                                   ("disable"),
		.hssi_krfec_rx_pcs_pipeln_errtrap_pat                                   ("disable"),
		.hssi_krfec_rx_pcs_pipeln_gearbox                                       ("enable"),
		.hssi_krfec_rx_pcs_pipeln_syndrm                                        ("enable"),
		.hssi_krfec_rx_pcs_pipeln_trans_dec                                     ("disable"),
		.hssi_krfec_rx_pcs_prot_mode                                            ("disable_mode"),
		.hssi_krfec_rx_pcs_receive_order                                        ("receive_lsb"),
		.hssi_krfec_rx_pcs_rx_testbus_sel                                       ("overall"),
		.hssi_krfec_rx_pcs_signal_ok_en                                         ("sig_ok_en"),
		.hssi_krfec_rx_pcs_sup_mode                                             ("user_mode"),
		.hssi_krfec_tx_pcs_burst_err                                            ("burst_err_dis"),
		.hssi_krfec_tx_pcs_burst_err_len                                        ("burst_err_len1"),
		.hssi_krfec_tx_pcs_ctrl_bit_reverse                                     ("ctrl_bit_reverse_en"),
		.hssi_krfec_tx_pcs_data_bit_reverse                                     ("data_bit_reverse_dis"),
		.hssi_krfec_tx_pcs_enc_frame_query                                      ("enc_query_dis"),
		.hssi_krfec_tx_pcs_low_latency_en                                       ("disable"),
		.hssi_krfec_tx_pcs_pipeln_encoder                                       ("enable"),
		.hssi_krfec_tx_pcs_pipeln_scrambler                                     ("enable"),
		.hssi_krfec_tx_pcs_prot_mode                                            ("disable_mode"),
		.hssi_krfec_tx_pcs_sup_mode                                             ("user_mode"),
		.hssi_krfec_tx_pcs_transcode_err                                        ("trans_err_dis"),
		.hssi_krfec_tx_pcs_transmit_order                                       ("transmit_lsb"),
		.hssi_krfec_tx_pcs_tx_testbus_sel                                       ("overall"),
		.hssi_10g_rx_pcs_align_del                                              ("align_del_dis"),
		.hssi_10g_rx_pcs_ber_bit_err_total_cnt                                  ("bit_err_total_cnt_10g"),
		.hssi_10g_rx_pcs_ber_clken                                              ("ber_clk_dis"),
		.hssi_10g_rx_pcs_ber_xus_timer_window                                   (19530),
		.hssi_10g_rx_pcs_bitslip_mode                                           ("bitslip_dis"),
		.hssi_10g_rx_pcs_blksync_bitslip_type                                   ("bitslip_comb"),
		.hssi_10g_rx_pcs_blksync_bitslip_wait_cnt                               (1),
		.hssi_10g_rx_pcs_blksync_bitslip_wait_type                              ("bitslip_cnt"),
		.hssi_10g_rx_pcs_blksync_bypass                                         ("blksync_bypass_en"),
		.hssi_10g_rx_pcs_blksync_clken                                          ("blksync_clk_dis"),
		.hssi_10g_rx_pcs_blksync_enum_invalid_sh_cnt                            ("enum_invalid_sh_cnt_10g"),
		.hssi_10g_rx_pcs_blksync_knum_sh_cnt_postlock                           ("knum_sh_cnt_postlock_10g"),
		.hssi_10g_rx_pcs_blksync_knum_sh_cnt_prelock                            ("knum_sh_cnt_prelock_10g"),
		.hssi_10g_rx_pcs_blksync_pipeln                                         ("blksync_pipeln_dis"),
		.hssi_10g_rx_pcs_clr_errblk_cnt_en                                      ("disable"),
		.hssi_10g_rx_pcs_control_del                                            ("control_del_none"),
		.hssi_10g_rx_pcs_crcchk_bypass                                          ("crcchk_bypass_en"),
		.hssi_10g_rx_pcs_crcchk_clken                                           ("crcchk_clk_dis"),
		.hssi_10g_rx_pcs_crcchk_inv                                             ("crcchk_inv_en"),
		.hssi_10g_rx_pcs_crcchk_pipeln                                          ("crcchk_pipeln_en"),
		.hssi_10g_rx_pcs_crcflag_pipeln                                         ("crcflag_pipeln_en"),
		.hssi_10g_rx_pcs_ctrl_bit_reverse                                       ("ctrl_bit_reverse_dis"),
		.hssi_10g_rx_pcs_data_bit_reverse                                       ("data_bit_reverse_dis"),
		.hssi_10g_rx_pcs_dec_64b66b_rxsm_bypass                                 ("dec_64b66b_rxsm_bypass_en"),
		.hssi_10g_rx_pcs_dec64b66b_clken                                        ("dec64b66b_clk_dis"),
		.hssi_10g_rx_pcs_descrm_bypass                                          ("descrm_bypass_en"),
		.hssi_10g_rx_pcs_descrm_clken                                           ("descrm_clk_dis"),
		.hssi_10g_rx_pcs_descrm_mode                                            ("async"),
		.hssi_10g_rx_pcs_descrm_pipeln                                          ("enable"),
		.hssi_10g_rx_pcs_dft_clk_out_sel                                        ("rx_master_clk"),
		.hssi_10g_rx_pcs_dis_signal_ok                                          ("dis_signal_ok_en"),
		.hssi_10g_rx_pcs_dispchk_bypass                                         ("dispchk_bypass_en"),
		.hssi_10g_rx_pcs_empty_flag_type                                        ("empty_rd_side"),
		.hssi_10g_rx_pcs_fast_path                                              ("fast_path_en"),
		.hssi_10g_rx_pcs_fec_clken                                              ("fec_clk_dis"),
		.hssi_10g_rx_pcs_fec_enable                                             ("fec_dis"),
		.hssi_10g_rx_pcs_fifo_double_read                                       ("fifo_double_read_dis"),
		.hssi_10g_rx_pcs_fifo_stop_rd                                           ("n_rd_empty"),
		.hssi_10g_rx_pcs_fifo_stop_wr                                           ("n_wr_full"),
		.hssi_10g_rx_pcs_force_align                                            ("force_align_dis"),
		.hssi_10g_rx_pcs_frmsync_bypass                                         ("frmsync_bypass_en"),
		.hssi_10g_rx_pcs_frmsync_clken                                          ("frmsync_clk_dis"),
		.hssi_10g_rx_pcs_frmsync_enum_scrm                                      ("enum_scrm_default"),
		.hssi_10g_rx_pcs_frmsync_enum_sync                                      ("enum_sync_default"),
		.hssi_10g_rx_pcs_frmsync_flag_type                                      ("location_only"),
		.hssi_10g_rx_pcs_frmsync_knum_sync                                      ("knum_sync_default"),
		.hssi_10g_rx_pcs_frmsync_mfrm_length                                    (2048),
		.hssi_10g_rx_pcs_frmsync_pipeln                                         ("frmsync_pipeln_en"),
		.hssi_10g_rx_pcs_full_flag_type                                         ("full_wr_side"),
		.hssi_10g_rx_pcs_gb_rx_idwidth                                          ("width_64"),
		.hssi_10g_rx_pcs_gb_rx_odwidth                                          ("width_64"),
		.hssi_10g_rx_pcs_gbexp_clken                                            ("gbexp_clk_dis"),
		.hssi_10g_rx_pcs_low_latency_en                                         ("disable"),
		.hssi_10g_rx_pcs_lpbk_mode                                              ("lpbk_dis"),
		.hssi_10g_rx_pcs_master_clk_sel                                         ("master_rx_pma_clk"),
		.hssi_10g_rx_pcs_pempty_flag_type                                       ("pempty_rd_side"),
		.hssi_10g_rx_pcs_pfull_flag_type                                        ("pfull_wr_side"),
		.hssi_10g_rx_pcs_phcomp_rd_del                                          ("phcomp_rd_del2"),
		.hssi_10g_rx_pcs_pld_if_type                                            ("fifo"),
		.hssi_10g_rx_pcs_prot_mode                                              ("disable_mode"),
		.hssi_10g_rx_pcs_rand_clken                                             ("rand_clk_dis"),
		.hssi_10g_rx_pcs_rd_clk_sel                                             ("rd_rx_pld_clk"),
		.hssi_10g_rx_pcs_rdfifo_clken                                           ("rdfifo_clk_dis"),
		.hssi_10g_rx_pcs_rx_fifo_write_ctrl                                     ("blklock_stops"),
		.hssi_10g_rx_pcs_rx_scrm_width                                          ("bit64"),
		.hssi_10g_rx_pcs_rx_sh_location                                         ("msb"),
		.hssi_10g_rx_pcs_rx_signal_ok_sel                                       ("synchronized_ver"),
		.hssi_10g_rx_pcs_rx_sm_bypass                                           ("rx_sm_bypass_en"),
		.hssi_10g_rx_pcs_rx_sm_hiber                                            ("rx_sm_hiber_en"),
		.hssi_10g_rx_pcs_rx_sm_pipeln                                           ("rx_sm_pipeln_en"),
		.hssi_10g_rx_pcs_rx_testbus_sel                                         ("rx_fifo_testbus1"),
		.hssi_10g_rx_pcs_rx_true_b2b                                            ("b2b"),
		.hssi_10g_rx_pcs_rxfifo_empty                                           ("empty_default"),
		.hssi_10g_rx_pcs_rxfifo_full                                            ("full_default"),
		.hssi_10g_rx_pcs_rxfifo_mode                                            ("phase_comp"),
		.hssi_10g_rx_pcs_rxfifo_pempty                                          (2),
		.hssi_10g_rx_pcs_rxfifo_pfull                                           (23),
		.hssi_10g_rx_pcs_stretch_num_stages                                     ("zero_stage"),
		.hssi_10g_rx_pcs_sup_mode                                               ("user_mode"),
		.hssi_10g_rx_pcs_test_mode                                              ("test_off"),
		.hssi_10g_rx_pcs_wrfifo_clken                                           ("wrfifo_clk_dis"),
		.hssi_10g_rx_pcs_advanced_user_mode                                     ("disable"),
		.hssi_10g_tx_pcs_bitslip_en                                             ("bitslip_dis"),
		.hssi_10g_tx_pcs_bonding_dft_en                                         ("dft_dis"),
		.hssi_10g_tx_pcs_bonding_dft_val                                        ("dft_0"),
		.hssi_10g_tx_pcs_crcgen_bypass                                          ("crcgen_bypass_en"),
		.hssi_10g_tx_pcs_crcgen_clken                                           ("crcgen_clk_dis"),
		.hssi_10g_tx_pcs_crcgen_err                                             ("crcgen_err_dis"),
		.hssi_10g_tx_pcs_crcgen_inv                                             ("crcgen_inv_en"),
		.hssi_10g_tx_pcs_ctrl_bit_reverse                                       ("ctrl_bit_reverse_dis"),
		.hssi_10g_tx_pcs_data_bit_reverse                                       ("data_bit_reverse_dis"),
		.hssi_10g_tx_pcs_dft_clk_out_sel                                        ("tx_master_clk"),
		.hssi_10g_tx_pcs_dispgen_bypass                                         ("dispgen_bypass_en"),
		.hssi_10g_tx_pcs_dispgen_clken                                          ("dispgen_clk_dis"),
		.hssi_10g_tx_pcs_dispgen_err                                            ("dispgen_err_dis"),
		.hssi_10g_tx_pcs_dispgen_pipeln                                         ("dispgen_pipeln_dis"),
		.hssi_10g_tx_pcs_empty_flag_type                                        ("empty_rd_side"),
		.hssi_10g_tx_pcs_enc_64b66b_txsm_bypass                                 ("enc_64b66b_txsm_bypass_en"),
		.hssi_10g_tx_pcs_enc64b66b_txsm_clken                                   ("enc64b66b_txsm_clk_dis"),
		.hssi_10g_tx_pcs_fastpath                                               ("fastpath_en"),
		.hssi_10g_tx_pcs_fec_clken                                              ("fec_clk_dis"),
		.hssi_10g_tx_pcs_fec_enable                                             ("fec_dis"),
		.hssi_10g_tx_pcs_fifo_double_write                                      ("fifo_double_write_dis"),
		.hssi_10g_tx_pcs_fifo_reg_fast                                          ("fifo_reg_fast_dis"),
		.hssi_10g_tx_pcs_fifo_stop_rd                                           ("rd_empty"),
		.hssi_10g_tx_pcs_fifo_stop_wr                                           ("n_wr_full"),
		.hssi_10g_tx_pcs_frmgen_burst                                           ("frmgen_burst_dis"),
		.hssi_10g_tx_pcs_frmgen_bypass                                          ("frmgen_bypass_en"),
		.hssi_10g_tx_pcs_frmgen_clken                                           ("frmgen_clk_dis"),
		.hssi_10g_tx_pcs_frmgen_mfrm_length                                     (2048),
		.hssi_10g_tx_pcs_frmgen_pipeln                                          ("frmgen_pipeln_en"),
		.hssi_10g_tx_pcs_frmgen_pyld_ins                                        ("frmgen_pyld_ins_dis"),
		.hssi_10g_tx_pcs_frmgen_wordslip                                        ("frmgen_wordslip_dis"),
		.hssi_10g_tx_pcs_full_flag_type                                         ("full_wr_side"),
		.hssi_10g_tx_pcs_gb_pipeln_bypass                                       ("disable"),
		.hssi_10g_tx_pcs_gb_tx_idwidth                                          ("width_64"),
		.hssi_10g_tx_pcs_gb_tx_odwidth                                          ("width_64"),
		.hssi_10g_tx_pcs_gbred_clken                                            ("gbred_clk_dis"),
		.hssi_10g_tx_pcs_low_latency_en                                         ("disable"),
		.hssi_10g_tx_pcs_master_clk_sel                                         ("master_tx_pma_clk"),
		.hssi_10g_tx_pcs_pempty_flag_type                                       ("pempty_rd_side"),
		.hssi_10g_tx_pcs_pfull_flag_type                                        ("pfull_wr_side"),
		.hssi_10g_tx_pcs_phcomp_rd_del                                          ("phcomp_rd_del2"),
		.hssi_10g_tx_pcs_pld_if_type                                            ("fifo"),
		.hssi_10g_tx_pcs_prot_mode                                              ("disable_mode"),
		.hssi_10g_tx_pcs_pseudo_random                                          ("all_0"),
		.hssi_10g_tx_pcs_pseudo_seed_a                                          ("288230376151711743"),
		.hssi_10g_tx_pcs_pseudo_seed_b                                          ("288230376151711743"),
		.hssi_10g_tx_pcs_random_disp                                            ("disable"),
		.hssi_10g_tx_pcs_rdfifo_clken                                           ("rdfifo_clk_dis"),
		.hssi_10g_tx_pcs_scrm_bypass                                            ("scrm_bypass_en"),
		.hssi_10g_tx_pcs_scrm_clken                                             ("scrm_clk_dis"),
		.hssi_10g_tx_pcs_scrm_mode                                              ("async"),
		.hssi_10g_tx_pcs_scrm_pipeln                                            ("enable"),
		.hssi_10g_tx_pcs_sh_err                                                 ("sh_err_dis"),
		.hssi_10g_tx_pcs_sop_mark                                               ("sop_mark_dis"),
		.hssi_10g_tx_pcs_stretch_num_stages                                     ("zero_stage"),
		.hssi_10g_tx_pcs_sup_mode                                               ("user_mode"),
		.hssi_10g_tx_pcs_test_mode                                              ("test_off"),
		.hssi_10g_tx_pcs_tx_scrm_err                                            ("scrm_err_dis"),
		.hssi_10g_tx_pcs_tx_scrm_width                                          ("bit64"),
		.hssi_10g_tx_pcs_tx_sh_location                                         ("msb"),
		.hssi_10g_tx_pcs_tx_sm_bypass                                           ("tx_sm_bypass_en"),
		.hssi_10g_tx_pcs_tx_sm_pipeln                                           ("tx_sm_pipeln_en"),
		.hssi_10g_tx_pcs_tx_testbus_sel                                         ("tx_fifo_testbus1"),
		.hssi_10g_tx_pcs_txfifo_empty                                           ("empty_default"),
		.hssi_10g_tx_pcs_txfifo_full                                            ("full_default"),
		.hssi_10g_tx_pcs_txfifo_mode                                            ("phase_comp"),
		.hssi_10g_tx_pcs_txfifo_pempty                                          (2),
		.hssi_10g_tx_pcs_txfifo_pfull                                           (11),
		.hssi_10g_tx_pcs_wr_clk_sel                                             ("wr_tx_pld_clk"),
		.hssi_10g_tx_pcs_wrfifo_clken                                           ("wrfifo_clk_dis"),
		.hssi_10g_tx_pcs_advanced_user_mode                                     ("disable"),
		.hssi_8g_rx_pcs_auto_error_replacement                                  ("en_err_replace"),
		.hssi_8g_rx_pcs_bit_reversal                                            ("dis_bit_reversal"),
		.hssi_8g_rx_pcs_bonding_dft_en                                          ("dft_dis"),
		.hssi_8g_rx_pcs_bonding_dft_val                                         ("dft_0"),
		.hssi_8g_rx_pcs_bypass_pipeline_reg                                     ("dis_bypass_pipeline"),
		.hssi_8g_rx_pcs_byte_deserializer                                       ("en_bds_by_4"),
		.hssi_8g_rx_pcs_cdr_ctrl_rxvalid_mask                                   ("en_rxvalid_mask"),
		.hssi_8g_rx_pcs_clkcmp_pattern_n                                        (192892),
		.hssi_8g_rx_pcs_clkcmp_pattern_p                                        (855683),
		.hssi_8g_rx_pcs_clock_gate_bds_dec_asn                                  ("dis_bds_dec_asn_clk_gating"),
		.hssi_8g_rx_pcs_clock_gate_cdr_eidle                                    ("dis_cdr_eidle_clk_gating"),
		.hssi_8g_rx_pcs_clock_gate_dw_pc_wrclk                                  ("en_dw_pc_wrclk_gating"),
		.hssi_8g_rx_pcs_clock_gate_dw_rm_rd                                     ("en_dw_rm_rdclk_gating"),
		.hssi_8g_rx_pcs_clock_gate_dw_rm_wr                                     ("en_dw_rm_wrclk_gating"),
		.hssi_8g_rx_pcs_clock_gate_dw_wa                                        ("en_dw_wa_clk_gating"),
		.hssi_8g_rx_pcs_clock_gate_pc_rdclk                                     ("dis_pc_rdclk_gating"),
		.hssi_8g_rx_pcs_clock_gate_sw_pc_wrclk                                  ("dis_sw_pc_wrclk_gating"),
		.hssi_8g_rx_pcs_clock_gate_sw_rm_rd                                     ("dis_sw_rm_rdclk_gating"),
		.hssi_8g_rx_pcs_clock_gate_sw_rm_wr                                     ("dis_sw_rm_wrclk_gating"),
		.hssi_8g_rx_pcs_clock_gate_sw_wa                                        ("dis_sw_wa_clk_gating"),
		.hssi_8g_rx_pcs_clock_observation_in_pld_core                           ("internal_sw_wa_clk"),
		.hssi_8g_rx_pcs_eidle_entry_eios                                        ("dis_eidle_eios"),
		.hssi_8g_rx_pcs_eidle_entry_iei                                         ("dis_eidle_iei"),
		.hssi_8g_rx_pcs_eidle_entry_sd                                          ("en_eidle_sd"),
		.hssi_8g_rx_pcs_eightb_tenb_decoder                                     ("en_8b10b_ibm"),
		.hssi_8g_rx_pcs_err_flags_sel                                           ("err_flags_wa"),
		.hssi_8g_rx_pcs_fixed_pat_det                                           ("dis_fixed_patdet"),
		.hssi_8g_rx_pcs_fixed_pat_num                                           (0),
		.hssi_8g_rx_pcs_force_signal_detect                                     ("en_force_signal_detect"),
		.hssi_8g_rx_pcs_gen3_clk_en                                             ("disable_clk"),
		.hssi_8g_rx_pcs_gen3_rx_clk_sel                                         ("rcvd_clk"),
		.hssi_8g_rx_pcs_gen3_tx_clk_sel                                         ("tx_pma_clk"),
		.hssi_8g_rx_pcs_hip_mode                                                ("en_hip"),
		.hssi_8g_rx_pcs_ibm_invalid_code                                        ("dis_ibm_invalid_code"),
		.hssi_8g_rx_pcs_invalid_code_flag_only                                  ("dis_invalid_code_only"),
		.hssi_8g_rx_pcs_pad_or_edb_error_replace                                ("replace_edb_dynamic"),
		.hssi_8g_rx_pcs_pcs_bypass                                              ("dis_pcs_bypass"),
		.hssi_8g_rx_pcs_phase_comp_rdptr                                        ("disable_rdptr"),
		.hssi_8g_rx_pcs_phase_compensation_fifo                                 ("register_fifo"),
		.hssi_8g_rx_pcs_pipe_if_enable                                          ("en_pipe3_rx"),
		.hssi_8g_rx_pcs_pma_dw                                                  ("ten_bit"),
		.hssi_8g_rx_pcs_polinv_8b10b_dec                                        ("en_polinv_8b10b_dec"),
		.hssi_8g_rx_pcs_prot_mode                                               ("pipe_g2"),
		.hssi_8g_rx_pcs_rate_match                                              ("pipe_rm"),
		.hssi_8g_rx_pcs_rate_match_del_thres                                    ("pipe_rm_del_thres"),
		.hssi_8g_rx_pcs_rate_match_empty_thres                                  ("pipe_rm_empty_thres"),
		.hssi_8g_rx_pcs_rate_match_full_thres                                   ("pipe_rm_full_thres"),
		.hssi_8g_rx_pcs_rate_match_ins_thres                                    ("pipe_rm_ins_thres"),
		.hssi_8g_rx_pcs_rate_match_start_thres                                  ("pipe_rm_start_thres"),
		.hssi_8g_rx_pcs_rx_clk_free_running                                     ("en_rx_clk_free_run"),
		.hssi_8g_rx_pcs_rx_clk2                                                 ("tx_pma_clock_clk2"),
		.hssi_8g_rx_pcs_rx_pcs_urst                                             ("en_rx_pcs_urst"),
		.hssi_8g_rx_pcs_rx_rcvd_clk                                             ("rcvd_clk_rcvd_clk"),
		.hssi_8g_rx_pcs_rx_rd_clk                                               ("rx_clk"),
		.hssi_8g_rx_pcs_rx_refclk                                               ("dis_refclk_sel"),
		.hssi_8g_rx_pcs_rx_wr_clk                                               ("txfifo_rd_clk"),
		.hssi_8g_rx_pcs_sup_mode                                                ("user_mode"),
		.hssi_8g_rx_pcs_symbol_swap                                             ("dis_symbol_swap"),
		.hssi_8g_rx_pcs_sync_sm_idle_eios                                       ("en_syncsm_idle"),
		.hssi_8g_rx_pcs_test_bus_sel                                            ("tx_testbus"),
		.hssi_8g_rx_pcs_tx_rx_parallel_loopback                                 ("dis_plpbk"),
		.hssi_8g_rx_pcs_wa_boundary_lock_ctrl                                   ("sync_sm"),
		.hssi_8g_rx_pcs_wa_clk_slip_spacing                                     (16),
		.hssi_8g_rx_pcs_wa_det_latency_sync_status_beh                          ("dont_care_assert_sync"),
		.hssi_8g_rx_pcs_wa_disp_err_flag                                        ("en_disp_err_flag"),
		.hssi_8g_rx_pcs_wa_kchar                                                ("dis_kchar"),
		.hssi_8g_rx_pcs_wa_pd                                                   ("wa_pd_10"),
		.hssi_8g_rx_pcs_wa_pd_data                                              ("380"),
		.hssi_8g_rx_pcs_wa_pd_polarity                                          ("dont_care_both_pol"),
		.hssi_8g_rx_pcs_wa_pld_controlled                                       ("dis_pld_ctrl"),
		.hssi_8g_rx_pcs_wa_renumber_data                                        (16),
		.hssi_8g_rx_pcs_wa_rgnumber_data                                        (15),
		.hssi_8g_rx_pcs_wa_rknumber_data                                        (3),
		.hssi_8g_rx_pcs_wa_rosnumber_data                                       (0),
		.hssi_8g_rx_pcs_wa_rvnumber_data                                        (0),
		.hssi_8g_rx_pcs_wa_sync_sm_ctrl                                         ("pipe_sync_sm"),
		.hssi_8g_rx_pcs_wait_cnt                                                (0),
		.hssi_8g_tx_pcs_bit_reversal                                            ("dis_bit_reversal"),
		.hssi_8g_tx_pcs_bonding_dft_en                                          ("dft_dis"),
		.hssi_8g_tx_pcs_bonding_dft_val                                         ("dft_0"),
		.hssi_8g_tx_pcs_bypass_pipeline_reg                                     ("dis_bypass_pipeline"),
		.hssi_8g_tx_pcs_byte_serializer                                         ("en_bs_by_4"),
		.hssi_8g_tx_pcs_clock_gate_bs_enc                                       ("dis_bs_enc_clk_gating"),
		.hssi_8g_tx_pcs_clock_gate_dw_fifowr                                    ("en_dw_fifowr_clk_gating"),
		.hssi_8g_tx_pcs_clock_gate_fiford                                       ("dis_fiford_clk_gating"),
		.hssi_8g_tx_pcs_clock_gate_sw_fifowr                                    ("dis_sw_fifowr_clk_gating"),
		.hssi_8g_tx_pcs_clock_observation_in_pld_core                           ("internal_refclk_b"),
		.hssi_8g_tx_pcs_data_selection_8b10b_encoder_input                      ("normal_data_path"),
		.hssi_8g_tx_pcs_dynamic_clk_switch                                      ("dis_dyn_clk_switch"),
		.hssi_8g_tx_pcs_eightb_tenb_disp_ctrl                                   ("en_disp_ctrl"),
		.hssi_8g_tx_pcs_eightb_tenb_encoder                                     ("en_8b10b_ibm"),
		.hssi_8g_tx_pcs_force_echar                                             ("dis_force_echar"),
		.hssi_8g_tx_pcs_force_kchar                                             ("dis_force_kchar"),
		.hssi_8g_tx_pcs_gen3_tx_clk_sel                                         ("dis_tx_clk"),
		.hssi_8g_tx_pcs_gen3_tx_pipe_clk_sel                                    ("func_clk"),
		.hssi_8g_tx_pcs_hip_mode                                                ("en_hip"),
		.hssi_8g_tx_pcs_pcs_bypass                                              ("dis_pcs_bypass"),
		.hssi_8g_tx_pcs_phase_comp_rdptr                                        ("disable_rdptr"),
		.hssi_8g_tx_pcs_phase_compensation_fifo                                 ("register_fifo"),
		.hssi_8g_tx_pcs_phfifo_write_clk_sel                                    ("tx_clk"),
		.hssi_8g_tx_pcs_pma_dw                                                  ("ten_bit"),
		.hssi_8g_tx_pcs_prot_mode                                               ("pipe_g2"),
		.hssi_8g_tx_pcs_refclk_b_clk_sel                                        ("tx_pma_clock"),
		.hssi_8g_tx_pcs_revloop_back_rm                                         ("en_rev_loopback_rx_rm"),
		.hssi_8g_tx_pcs_sup_mode                                                ("user_mode"),
		.hssi_8g_tx_pcs_symbol_swap                                             ("dis_symbol_swap"),
		.hssi_8g_tx_pcs_tx_bitslip                                              ("dis_tx_bitslip"),
		.hssi_8g_tx_pcs_tx_compliance_controlled_disparity                      ("en_txcompliance_pipe3p0"),
		.hssi_8g_tx_pcs_tx_fast_pld_reg                                         ("dis_tx_fast_pld_reg"),
		.hssi_8g_tx_pcs_txclk_freerun                                           ("en_freerun_tx"),
		.hssi_8g_tx_pcs_txpcs_urst                                              ("en_txpcs_urst"),
		.hssi_tx_pld_pcs_interface_hd_chnl_hip_en                               ("enable"),
		.hssi_tx_pld_pcs_interface_hd_chnl_hrdrstctl_en                         ("enable"),
		.hssi_tx_pld_pcs_interface_hd_chnl_prot_mode_tx                         ("pcie_g2_capable_tx"),
		.hssi_tx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_tx                ("ctrl_master_tx"),
		.hssi_tx_pld_pcs_interface_hd_chnl_pma_dw_tx                            ("pma_10b_tx"),
		.hssi_tx_pld_pcs_interface_hd_chnl_pld_fifo_mode_tx                     ("reg_tx"),
		.hssi_tx_pld_pcs_interface_hd_chnl_shared_fifo_width_tx                 ("single_tx"),
		.hssi_tx_pld_pcs_interface_hd_chnl_low_latency_en_tx                    ("disable"),
		.hssi_tx_pld_pcs_interface_hd_chnl_func_mode                            ("enable"),
		.hssi_tx_pld_pcs_interface_hd_chnl_channel_operation_mode               ("tx_rx_pair_enabled"),
		.hssi_tx_pld_pcs_interface_hd_chnl_lpbk_en                              ("disable"),
		.hssi_tx_pld_pcs_interface_hd_chnl_frequency_rules_en                   ("enable"),
		.hssi_tx_pld_pcs_interface_hd_chnl_pma_tx_clk_hz                        (500000000),
		.hssi_tx_pld_pcs_interface_hd_chnl_pld_tx_clk_hz                        (0),
		.hssi_tx_pld_pcs_interface_hd_chnl_pld_uhsif_tx_clk_hz                  (0),
		.hssi_tx_pld_pcs_interface_hd_fifo_channel_operation_mode               ("tx_rx_pair_enabled"),
		.hssi_tx_pld_pcs_interface_hd_fifo_prot_mode_tx                         ("non_teng_mode_tx"),
		.hssi_tx_pld_pcs_interface_hd_fifo_shared_fifo_width_tx                 ("single_tx"),
		.hssi_tx_pld_pcs_interface_hd_10g_channel_operation_mode                ("tx_rx_pair_enabled"),
		.hssi_tx_pld_pcs_interface_hd_10g_lpbk_en                               ("disable"),
		.hssi_tx_pld_pcs_interface_hd_10g_advanced_user_mode_tx                 ("disable"),
		.hssi_tx_pld_pcs_interface_hd_10g_pma_dw_tx                             ("pma_64b_tx"),
		.hssi_tx_pld_pcs_interface_hd_10g_fifo_mode_tx                          ("fifo_tx"),
		.hssi_tx_pld_pcs_interface_hd_10g_prot_mode_tx                          ("disabled_prot_mode_tx"),
		.hssi_tx_pld_pcs_interface_hd_10g_low_latency_en_tx                     ("disable"),
		.hssi_tx_pld_pcs_interface_hd_10g_shared_fifo_width_tx                  ("single_tx"),
		.hssi_tx_pld_pcs_interface_hd_8g_channel_operation_mode                 ("tx_rx_pair_enabled"),
		.hssi_tx_pld_pcs_interface_hd_8g_lpbk_en                                ("disable"),
		.hssi_tx_pld_pcs_interface_hd_8g_prot_mode_tx                           ("pipe_g2_tx"),
		.hssi_tx_pld_pcs_interface_hd_8g_hip_mode                               ("enable"),
		.hssi_tx_pld_pcs_interface_hd_8g_pma_dw_tx                              ("pma_10b_tx"),
		.hssi_tx_pld_pcs_interface_hd_8g_fifo_mode_tx                           ("reg_tx"),
		.hssi_tx_pld_pcs_interface_hd_g3_prot_mode                              ("pipe_g2"),
		.hssi_tx_pld_pcs_interface_hd_krfec_channel_operation_mode              ("tx_rx_pair_enabled"),
		.hssi_tx_pld_pcs_interface_hd_krfec_lpbk_en                             ("disable"),
		.hssi_tx_pld_pcs_interface_hd_krfec_prot_mode_tx                        ("disabled_prot_mode_tx"),
		.hssi_tx_pld_pcs_interface_hd_krfec_low_latency_en_tx                   ("disable"),
		.hssi_tx_pld_pcs_interface_hd_pmaif_lpbk_en                             ("disable"),
		.hssi_tx_pld_pcs_interface_hd_pmaif_channel_operation_mode              ("tx_rx_pair_enabled"),
		.hssi_tx_pld_pcs_interface_hd_pmaif_sim_mode                            ("disable"),
		.hssi_tx_pld_pcs_interface_hd_pmaif_prot_mode_tx                        ("eightg_pcie_g12_hip_mode_tx"),
		.hssi_tx_pld_pcs_interface_hd_pmaif_pma_dw_tx                           ("pma_10b_tx"),
		.hssi_tx_pld_pcs_interface_hd_pldif_prot_mode_tx                        ("eightg_and_g3_reg_mode_hip_tx"),
		.hssi_tx_pld_pcs_interface_hd_pldif_hrdrstctl_en                        ("enable"),
		.hssi_tx_pld_pcs_interface_pcs_tx_clk_source                            ("eightg"),
		.hssi_tx_pld_pcs_interface_pcs_tx_data_source                           ("hip_enable"),
		.hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_en                         ("delay1_clk_disable"),
		.hssi_tx_pld_pcs_interface_pcs_tx_delay1_clk_sel                        ("pcs_tx_clk"),
		.hssi_tx_pld_pcs_interface_pcs_tx_delay1_ctrl                           ("delay1_path0"),
		.hssi_tx_pld_pcs_interface_pcs_tx_delay1_data_sel                       ("one_ff_delay"),
		.hssi_tx_pld_pcs_interface_pcs_tx_delay2_clk_en                         ("delay2_clk_disable"),
		.hssi_tx_pld_pcs_interface_pcs_tx_delay2_ctrl                           ("delay2_path0"),
		.hssi_tx_pld_pcs_interface_pcs_tx_output_sel                            ("teng_output"),
		.hssi_tx_pld_pcs_interface_pcs_tx_clk_out_sel                           ("eightg_clk_out"),
		.hssi_rx_pld_pcs_interface_hd_chnl_hip_en                               ("enable"),
		.hssi_rx_pld_pcs_interface_hd_chnl_transparent_pcs_rx                   ("disable"),
		.hssi_rx_pld_pcs_interface_hd_chnl_hrdrstctl_en                         ("enable"),
		.hssi_rx_pld_pcs_interface_hd_chnl_prot_mode_rx                         ("pcie_g2_capable_rx"),
		.hssi_rx_pld_pcs_interface_hd_chnl_ctrl_plane_bonding_rx                ("ctrl_master_rx"),
		.hssi_rx_pld_pcs_interface_hd_chnl_pma_dw_rx                            ("pma_10b_rx"),
		.hssi_rx_pld_pcs_interface_hd_chnl_pld_fifo_mode_rx                     ("reg_rx"),
		.hssi_rx_pld_pcs_interface_hd_chnl_shared_fifo_width_rx                 ("single_rx"),
		.hssi_rx_pld_pcs_interface_hd_chnl_low_latency_en_rx                    ("disable"),
		.hssi_rx_pld_pcs_interface_hd_chnl_func_mode                            ("enable"),
		.hssi_rx_pld_pcs_interface_hd_chnl_channel_operation_mode               ("tx_rx_pair_enabled"),
		.hssi_rx_pld_pcs_interface_hd_chnl_lpbk_en                              ("disable"),
		.hssi_rx_pld_pcs_interface_hd_10g_advanced_user_mode_rx                 ("disable"),
		.hssi_rx_pld_pcs_interface_hd_chnl_frequency_rules_en                   ("enable"),
		.hssi_rx_pld_pcs_interface_hd_chnl_pma_rx_clk_hz                        (500000000),
		.hssi_rx_pld_pcs_interface_hd_chnl_pld_rx_clk_hz                        (0),
		.hssi_rx_pld_pcs_interface_hd_chnl_fref_clk_hz                          (100000000),
		.hssi_rx_pld_pcs_interface_hd_chnl_clklow_clk_hz                        (100000000),
		.hssi_rx_pld_pcs_interface_hd_fifo_channel_operation_mode               ("tx_rx_pair_enabled"),
		.hssi_rx_pld_pcs_interface_hd_fifo_prot_mode_rx                         ("non_teng_mode_rx"),
		.hssi_rx_pld_pcs_interface_hd_fifo_shared_fifo_width_rx                 ("single_rx"),
		.hssi_rx_pld_pcs_interface_hd_10g_channel_operation_mode                ("tx_rx_pair_enabled"),
		.hssi_rx_pld_pcs_interface_hd_10g_lpbk_en                               ("disable"),
		.hssi_rx_pld_pcs_interface_hd_10g_pma_dw_rx                             ("pma_64b_rx"),
		.hssi_rx_pld_pcs_interface_hd_10g_fifo_mode_rx                          ("fifo_rx"),
		.hssi_rx_pld_pcs_interface_hd_10g_prot_mode_rx                          ("disabled_prot_mode_rx"),
		.hssi_rx_pld_pcs_interface_hd_10g_low_latency_en_rx                     ("disable"),
		.hssi_rx_pld_pcs_interface_hd_10g_shared_fifo_width_rx                  ("single_rx"),
		.hssi_rx_pld_pcs_interface_hd_10g_test_bus_mode                         ("rx"),
		.hssi_rx_pld_pcs_interface_hd_8g_channel_operation_mode                 ("tx_rx_pair_enabled"),
		.hssi_rx_pld_pcs_interface_hd_8g_lpbk_en                                ("disable"),
		.hssi_rx_pld_pcs_interface_hd_8g_prot_mode_rx                           ("pipe_g2_rx"),
		.hssi_rx_pld_pcs_interface_hd_8g_hip_mode                               ("enable"),
		.hssi_rx_pld_pcs_interface_hd_8g_pma_dw_rx                              ("pma_10b_rx"),
		.hssi_rx_pld_pcs_interface_hd_8g_fifo_mode_rx                           ("reg_rx"),
		.hssi_rx_pld_pcs_interface_hd_g3_prot_mode                              ("pipe_g2"),
		.hssi_rx_pld_pcs_interface_hd_krfec_channel_operation_mode              ("tx_rx_pair_enabled"),
		.hssi_rx_pld_pcs_interface_hd_krfec_lpbk_en                             ("disable"),
		.hssi_rx_pld_pcs_interface_hd_krfec_prot_mode_rx                        ("disabled_prot_mode_rx"),
		.hssi_rx_pld_pcs_interface_hd_krfec_low_latency_en_rx                   ("disable"),
		.hssi_rx_pld_pcs_interface_hd_krfec_test_bus_mode                       ("tx"),
		.hssi_rx_pld_pcs_interface_hd_pmaif_lpbk_en                             ("disable"),
		.hssi_rx_pld_pcs_interface_hd_pmaif_channel_operation_mode              ("tx_rx_pair_enabled"),
		.hssi_rx_pld_pcs_interface_hd_pmaif_sim_mode                            ("disable"),
		.hssi_rx_pld_pcs_interface_hd_pmaif_prot_mode_rx                        ("eightg_pcie_g12_hip_mode_rx"),
		.hssi_rx_pld_pcs_interface_hd_pmaif_pma_dw_rx                           ("pma_10b_rx"),
		.hssi_rx_pld_pcs_interface_hd_pldif_prot_mode_rx                        ("eightg_and_g3_reg_mode_hip_rx"),
		.hssi_rx_pld_pcs_interface_hd_pldif_hrdrstctl_en                        ("enable"),
		.hssi_rx_pld_pcs_interface_pcs_rx_block_sel                             ("eightg"),
		.hssi_rx_pld_pcs_interface_pcs_rx_clk_sel                               ("pcs_rx_clk"),
		.hssi_rx_pld_pcs_interface_pcs_rx_hip_clk_en                            ("hip_rx_enable"),
		.hssi_rx_pld_pcs_interface_pcs_rx_output_sel                            ("teng_output"),
		.hssi_rx_pld_pcs_interface_pcs_rx_clk_out_sel                           ("eightg_clk_out"),
		.hssi_common_pld_pcs_interface_dft_clk_out_en                           ("dft_clk_out_disable"),
		.hssi_common_pld_pcs_interface_dft_clk_out_sel                          ("teng_rx_dft_clk"),
		.hssi_common_pld_pcs_interface_hrdrstctrl_en                            ("hrst_en"),
		.hssi_common_pld_pcs_interface_pcs_testbus_block_sel                    ("pma_if"),
		.hssi_rx_pcs_pma_interface_block_sel                                    ("eight_g_pcs"),
		.hssi_rx_pcs_pma_interface_channel_operation_mode                       ("tx_rx_pair_enabled"),
		.hssi_rx_pcs_pma_interface_clkslip_sel                                  ("pld"),
		.hssi_rx_pcs_pma_interface_lpbk_en                                      ("disable"),
		.hssi_rx_pcs_pma_interface_master_clk_sel                               ("master_rx_pma_clk"),
		.hssi_rx_pcs_pma_interface_pldif_datawidth_mode                         ("pldif_data_10bit"),
		.hssi_rx_pcs_pma_interface_pma_dw_rx                                    ("pma_10b_rx"),
		.hssi_rx_pcs_pma_interface_pma_if_dft_en                                ("dft_dis"),
		.hssi_rx_pcs_pma_interface_pma_if_dft_val                               ("dft_0"),
		.hssi_rx_pcs_pma_interface_prbs_clken                                   ("prbs_clk_dis"),
		.hssi_rx_pcs_pma_interface_prbs_ver                                     ("prbs_off"),
		.hssi_rx_pcs_pma_interface_prbs9_dwidth                                 ("prbs9_64b"),
		.hssi_rx_pcs_pma_interface_prot_mode_rx                                 ("eightg_pcie_g12_hip_mode_rx"),
		.hssi_rx_pcs_pma_interface_rx_dyn_polarity_inversion                    ("rx_dyn_polinv_dis"),
		.hssi_rx_pcs_pma_interface_rx_lpbk_en                                   ("lpbk_dis"),
		.hssi_rx_pcs_pma_interface_rx_prbs_force_signal_ok                      ("force_sig_ok"),
		.hssi_rx_pcs_pma_interface_rx_prbs_mask                                 ("prbsmask128"),
		.hssi_rx_pcs_pma_interface_rx_prbs_mode                                 ("teng_mode"),
		.hssi_rx_pcs_pma_interface_rx_signalok_signaldet_sel                    ("sel_sig_det"),
		.hssi_rx_pcs_pma_interface_rx_static_polarity_inversion                 ("rx_stat_polinv_dis"),
		.hssi_rx_pcs_pma_interface_rx_uhsif_lpbk_en                             ("uhsif_lpbk_dis"),
		.hssi_rx_pcs_pma_interface_sup_mode                                     ("user_mode"),
		.hssi_tx_pcs_pma_interface_bypass_pma_txelecidle                        ("false"),
		.hssi_tx_pcs_pma_interface_channel_operation_mode                       ("tx_rx_pair_enabled"),
		.hssi_tx_pcs_pma_interface_lpbk_en                                      ("disable"),
		.hssi_tx_pcs_pma_interface_master_clk_sel                               ("master_tx_pma_clk"),
		.hssi_tx_pcs_pma_interface_pcie_sub_prot_mode_tx                        ("pipe_g12"),
		.hssi_tx_pcs_pma_interface_pldif_datawidth_mode                         ("pldif_data_10bit"),
		.hssi_tx_pcs_pma_interface_pma_dw_tx                                    ("pma_10b_tx"),
		.hssi_tx_pcs_pma_interface_pma_if_dft_en                                ("dft_dis"),
		.hssi_tx_pcs_pma_interface_pmagate_en                                   ("pmagate_dis"),
		.hssi_tx_pcs_pma_interface_prbs_clken                                   ("prbs_clk_dis"),
		.hssi_tx_pcs_pma_interface_prbs_gen_pat                                 ("prbs_gen_dis"),
		.hssi_tx_pcs_pma_interface_prbs9_dwidth                                 ("prbs9_64b"),
		.hssi_tx_pcs_pma_interface_prot_mode_tx                                 ("eightg_pcie_g12_hip_mode_tx"),
		.hssi_tx_pcs_pma_interface_sq_wave_num                                  ("sq_wave_default"),
		.hssi_tx_pcs_pma_interface_sqwgen_clken                                 ("sqwgen_clk_dis"),
		.hssi_tx_pcs_pma_interface_sup_mode                                     ("user_mode"),
		.hssi_tx_pcs_pma_interface_tx_dyn_polarity_inversion                    ("tx_dyn_polinv_dis"),
		.hssi_tx_pcs_pma_interface_tx_pma_data_sel                              ("eight_g_pcs"),
		.hssi_tx_pcs_pma_interface_tx_static_polarity_inversion                 ("tx_stat_polinv_dis"),
		.hssi_tx_pcs_pma_interface_uhsif_cnt_step_filt_before_lock              ("uhsif_filt_stepsz_b4lock_2"),
		.hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_after_lock_value       (0),
		.hssi_tx_pcs_pma_interface_uhsif_cnt_thresh_filt_before_lock            ("uhsif_filt_cntthr_b4lock_8"),
		.hssi_tx_pcs_pma_interface_uhsif_dcn_test_update_period                 ("uhsif_dcn_test_period_4"),
		.hssi_tx_pcs_pma_interface_uhsif_dcn_testmode_enable                    ("uhsif_dcn_test_mode_disable"),
		.hssi_tx_pcs_pma_interface_uhsif_dead_zone_count_thresh                 ("uhsif_dzt_cnt_thr_2"),
		.hssi_tx_pcs_pma_interface_uhsif_dead_zone_detection_enable             ("uhsif_dzt_disable"),
		.hssi_tx_pcs_pma_interface_uhsif_dead_zone_obser_window                 ("uhsif_dzt_obr_win_16"),
		.hssi_tx_pcs_pma_interface_uhsif_dead_zone_skip_size                    ("uhsif_dzt_skipsz_4"),
		.hssi_tx_pcs_pma_interface_uhsif_delay_cell_index_sel                   ("uhsif_index_cram"),
		.hssi_tx_pcs_pma_interface_uhsif_delay_cell_margin                      ("uhsif_dcn_margin_2"),
		.hssi_tx_pcs_pma_interface_uhsif_delay_cell_static_index_value          (0),
		.hssi_tx_pcs_pma_interface_uhsif_dft_dead_zone_control                  ("uhsif_dft_dz_det_val_0"),
		.hssi_tx_pcs_pma_interface_uhsif_dft_up_filt_control                    ("uhsif_dft_up_val_0"),
		.hssi_tx_pcs_pma_interface_uhsif_enable                                 ("uhsif_disable"),
		.hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_after_lock              ("uhsif_lkd_segsz_aflock_512"),
		.hssi_tx_pcs_pma_interface_uhsif_lock_det_segsz_before_lock             ("uhsif_lkd_segsz_b4lock_16"),
		.hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_after_lock_value   (0),
		.hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_cnt_before_lock_value  (0),
		.hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_after_lock_value  (0),
		.hssi_tx_pcs_pma_interface_uhsif_lock_det_thresh_diff_before_lock_value (0),
		.hssi_common_pcs_pma_interface_asn_clk_enable                           ("true"),
		.hssi_common_pcs_pma_interface_asn_enable                               ("en_asn"),
		.hssi_common_pcs_pma_interface_block_sel                                ("eight_g_pcs"),
		.hssi_common_pcs_pma_interface_bypass_early_eios                        ("false"),
		.hssi_common_pcs_pma_interface_bypass_pcie_switch                       ("false"),
		.hssi_common_pcs_pma_interface_bypass_pma_ltr                           ("false"),
		.hssi_common_pcs_pma_interface_bypass_pma_sw_done                       ("true"),
		.hssi_common_pcs_pma_interface_bypass_ppm_lock                          ("false"),
		.hssi_common_pcs_pma_interface_bypass_send_syncp_fbkp                   ("true"),
		.hssi_common_pcs_pma_interface_bypass_txdetectrx                        ("false"),
		.hssi_common_pcs_pma_interface_cdr_control                              ("en_cdr_ctrl"),
		.hssi_common_pcs_pma_interface_cid_enable                               ("en_cid_mode"),
		.hssi_common_pcs_pma_interface_data_mask_count                          (2500),
		.hssi_common_pcs_pma_interface_data_mask_count_multi                    (1),
		.hssi_common_pcs_pma_interface_dft_observation_clock_selection          ("dft_clk_obsrv_tx0"),
		.hssi_common_pcs_pma_interface_early_eios_counter                       (50),
		.hssi_common_pcs_pma_interface_force_freqdet                            ("force_freqdet_dis"),
		.hssi_common_pcs_pma_interface_free_run_clk_enable                      ("true"),
		.hssi_common_pcs_pma_interface_ignore_sigdet_g23                        ("false"),
		.hssi_common_pcs_pma_interface_pc_en_counter                            (55),
		.hssi_common_pcs_pma_interface_pc_rst_counter                           (23),
		.hssi_common_pcs_pma_interface_pcie_hip_mode                            ("hip_enable"),
		.hssi_common_pcs_pma_interface_ph_fifo_reg_mode                         ("phfifo_reg_mode_en"),
		.hssi_common_pcs_pma_interface_phfifo_flush_wait                        (36),
		.hssi_common_pcs_pma_interface_pipe_if_g3pcs                            ("pipe_if_g3pcs"),
		.hssi_common_pcs_pma_interface_pma_done_counter                         (175000),
		.hssi_common_pcs_pma_interface_pma_if_dft_en                            ("dft_dis"),
		.hssi_common_pcs_pma_interface_pma_if_dft_val                           ("dft_0"),
		.hssi_common_pcs_pma_interface_ppm_cnt_rst                              ("ppm_cnt_rst_dis"),
		.hssi_common_pcs_pma_interface_ppm_deassert_early                       ("deassert_early_dis"),
		.hssi_common_pcs_pma_interface_ppm_gen1_2_cnt                           ("cnt_32k"),
		.hssi_common_pcs_pma_interface_ppm_post_eidle_delay                     ("cnt_200_cycles"),
		.hssi_common_pcs_pma_interface_ppmsel                                   ("ppmsel_300"),
		.hssi_common_pcs_pma_interface_prot_mode                                ("pipe_g12"),
		.hssi_common_pcs_pma_interface_rxvalid_mask                             ("rxvalid_mask_en"),
		.hssi_common_pcs_pma_interface_sigdet_wait_counter                      (2500),
		.hssi_common_pcs_pma_interface_sigdet_wait_counter_multi                (1),
		.hssi_common_pcs_pma_interface_sim_mode                                 ("disable"),
		.hssi_common_pcs_pma_interface_spd_chg_rst_wait_cnt_en                  ("true"),
		.hssi_common_pcs_pma_interface_sup_mode                                 ("user_mode"),
		.hssi_common_pcs_pma_interface_testout_sel                              ("asn_test"),
		.hssi_common_pcs_pma_interface_wait_clk_on_off_timer                    (0),
		.hssi_common_pcs_pma_interface_wait_pipe_synchronizing                  (23),
		.hssi_common_pcs_pma_interface_wait_send_syncp_fbkp                     (250),
		.hssi_common_pcs_pma_interface_ppm_det_buckets                          ("ppm_300_bucket"),
		.hssi_fifo_rx_pcs_double_read_mode                                      ("double_read_dis"),
		.hssi_fifo_rx_pcs_prot_mode                                             ("non_teng_mode"),
		.hssi_fifo_tx_pcs_double_write_mode                                     ("double_write_dis"),
		.hssi_fifo_tx_pcs_prot_mode                                             ("non_teng_mode"),
		.hssi_pipe_gen3_bypass_rx_detection_enable                              ("false"),
		.hssi_pipe_gen3_bypass_rx_preset                                        (0),
		.hssi_pipe_gen3_bypass_rx_preset_enable                                 ("false"),
		.hssi_pipe_gen3_bypass_tx_coefficent                                    (0),
		.hssi_pipe_gen3_bypass_tx_coefficent_enable                             ("false"),
		.hssi_pipe_gen3_elecidle_delay_g3                                       (6),
		.hssi_pipe_gen3_ind_error_reporting                                     ("dis_ind_error_reporting"),
		.hssi_pipe_gen3_mode                                                    ("pipe_g2"),
		.hssi_pipe_gen3_phy_status_delay_g12                                    (5),
		.hssi_pipe_gen3_phy_status_delay_g3                                     (5),
		.hssi_pipe_gen3_phystatus_rst_toggle_g12                                ("dis_phystatus_rst_toggle"),
		.hssi_pipe_gen3_phystatus_rst_toggle_g3                                 ("dis_phystatus_rst_toggle_g3"),
		.hssi_pipe_gen3_rate_match_pad_insertion                                ("dis_rm_fifo_pad_ins"),
		.hssi_pipe_gen3_sup_mode                                                ("user_mode"),
		.hssi_pipe_gen3_test_out_sel                                            ("disable_test_out"),
		.hssi_pipe_gen1_2_elec_idle_delay_val                                   (3),
		.hssi_pipe_gen1_2_error_replace_pad                                     ("replace_edb"),
		.hssi_pipe_gen1_2_hip_mode                                              ("en_hip"),
		.hssi_pipe_gen1_2_ind_error_reporting                                   ("dis_ind_error_reporting"),
		.hssi_pipe_gen1_2_phystatus_delay_val                                   (0),
		.hssi_pipe_gen1_2_phystatus_rst_toggle                                  ("dis_phystatus_rst_toggle"),
		.hssi_pipe_gen1_2_pipe_byte_de_serializer_en                            ("dont_care_bds"),
		.hssi_pipe_gen1_2_prot_mode                                             ("pipe_g2"),
		.hssi_pipe_gen1_2_rx_pipe_enable                                        ("en_pipe3_rx"),
		.hssi_pipe_gen1_2_rxdetect_bypass                                       ("dis_rxdetect_bypass"),
		.hssi_pipe_gen1_2_sup_mode                                              ("user_mode"),
		.hssi_pipe_gen1_2_tx_pipe_enable                                        ("en_pipe3_tx"),
		.hssi_pipe_gen1_2_txswing                                               ("dis_txswing"),
		.pma_adapt_adp_1s_ctle_bypass                                           ("radp_1s_ctle_bypass_1"),
		.pma_adapt_adp_4s_ctle_bypass                                           ("radp_4s_ctle_bypass_1"),
		.pma_adapt_adp_ctle_en                                                  ("radp_ctle_disable"),
		.pma_adapt_adp_dfe_fltap_bypass                                         ("radp_dfe_fltap_bypass_1"),
		.pma_adapt_adp_dfe_fltap_en                                             ("radp_dfe_fltap_disable"),
		.pma_adapt_adp_dfe_fxtap_bypass                                         ("radp_dfe_fxtap_bypass_1"),
		.pma_adapt_adp_dfe_fxtap_en                                             ("radp_dfe_fxtap_disable"),
		.pma_adapt_adp_dfe_fxtap_hold_en                                        ("radp_dfe_fxtap_not_held"),
		.pma_adapt_adp_dfe_mode                                                 ("radp_dfe_mode_4"),
		.pma_adapt_adp_vga_bypass                                               ("radp_vga_bypass_1"),
		.pma_adapt_adp_vga_en                                                   ("radp_vga_disable"),
		.pma_adapt_adp_vref_bypass                                              ("radp_vref_bypass_1"),
		.pma_adapt_adp_vref_en                                                  ("radp_vref_disable"),
		.pma_adapt_datarate                                                     ("5000000000 bps"),
		.pma_adapt_prot_mode                                                    ("pcie_gen2_rx"),
		.pma_adapt_sup_mode                                                     ("user_mode"),
		.pma_adapt_adp_ctle_adapt_cycle_window                                  ("radp_ctle_adapt_cycle_window_7"),
		.pma_adapt_odi_dfe_spec_en                                              ("rodi_dfe_spec_en_0"),
		.pma_adapt_adapt_mode                                                   ("manual"),
		.pma_adapt_adp_onetime_dfe                                              ("radp_onetime_dfe_0"),
		.pma_adapt_adp_mode                                                     ("radp_mode_8"),
		.pma_cdr_refclk_powerdown_mode                                          ("powerup"),
		.pma_cdr_refclk_refclk_select                                           ("ref_iqclk0"),
		.pma_cgb_bitslip_enable                                                 ("disable_bitslip"),
		.pma_cgb_bonding_reset_enable                                           ("disallow_bonding_reset"),
		.pma_cgb_datarate                                                       ("5000000000 bps"),
		.pma_cgb_pcie_gen3_bitwidth                                             ("pciegen3_wide"),
		.pma_cgb_prot_mode                                                      ("pcie_gen2_tx"),
		.pma_cgb_ser_mode                                                       ("ten_bit"),
		.pma_cgb_sup_mode                                                       ("user_mode"),
		.pma_cgb_x1_div_m_sel                                                   ("divbypass"),
		.pma_cgb_input_select_x1                                                ("unused"),
		.pma_cgb_input_select_gen3                                              ("unused"),
		.pma_cgb_input_select_xn                                                ("sel_x6_dn"),
		.pma_cgb_tx_ucontrol_en                                                 ("disable"),
		.pma_rx_dfe_datarate                                                    ("5000000000 bps"),
		.pma_rx_dfe_dft_en                                                      ("dft_disable"),
		.pma_rx_dfe_pdb                                                         ("dfe_enable"),
		.pma_rx_dfe_pdb_fixedtap                                                ("fixtap_dfe_powerdown"),
		.pma_rx_dfe_pdb_floattap                                                ("floattap_dfe_powerdown"),
		.pma_rx_dfe_pdb_fxtap4t7                                                ("fxtap4t7_powerdown"),
		.pma_rx_dfe_sup_mode                                                    ("user_mode"),
		.pma_rx_dfe_prot_mode                                                   ("pcie_gen2_rx"),
		.pma_rx_odi_datarate                                                    ("5000000000 bps"),
		.pma_rx_odi_sup_mode                                                    ("user_mode"),
		.pma_rx_odi_step_ctrl_sel                                               ("dprio_mode"),
		.pma_rx_odi_prot_mode                                                   ("pcie_gen2_rx"),
		.pma_rx_buf_bypass_eqz_stages_234                                       ("bypass_off"),
		.pma_rx_buf_datarate                                                    ("5000000000 bps"),
		.pma_rx_buf_diag_lp_en                                                  ("dlp_off"),
		.pma_rx_buf_prot_mode                                                   ("pcie_gen2_rx"),
		.pma_rx_buf_qpi_enable                                                  ("non_qpi_mode"),
		.pma_rx_buf_rx_refclk_divider                                           ("bypass_divider"),
		.pma_rx_buf_sup_mode                                                    ("user_mode"),
		.pma_rx_buf_loopback_modes                                              ("lpbk_disable"),
		.pma_rx_buf_refclk_en                                                   ("disable"),
		.pma_rx_buf_pm_tx_rx_pcie_gen                                           ("non_pcie"),
		.pma_rx_buf_pm_tx_rx_pcie_gen_bitwidth                                  ("pcie_gen3_32b"),
		.pma_rx_buf_pm_tx_rx_cvp_mode                                           ("cvp_off"),
		.pma_rx_buf_xrx_path_uc_cal_enable                                      ("rx_cal_off"),
		.pma_rx_buf_xrx_path_sup_mode                                           ("user_mode"),
		.pma_rx_buf_xrx_path_prot_mode                                          ("pcie_gen2_rx"),
		.pma_rx_buf_xrx_path_datarate                                           ("5000000000 bps"),
		.pma_rx_buf_xrx_path_datawidth                                          (10),
		.pma_rx_buf_xrx_path_pma_rx_divclk_hz                                   ("500000000"),
		.pma_rx_sd_prot_mode                                                    ("pcie_gen2_rx"),
		.pma_rx_sd_sd_output_off                                                (13),
		.pma_rx_sd_sd_output_on                                                 (1),
		.pma_rx_sd_sd_pdb                                                       ("sd_on"),
		.pma_rx_sd_sup_mode                                                     ("user_mode"),
		.pma_tx_ser_ser_clk_divtx_user_sel                                      ("divtx_user_off"),
		.pma_tx_ser_sup_mode                                                    ("user_mode"),
		.pma_tx_ser_prot_mode                                                   ("pcie_gen2_tx"),
		.pma_tx_buf_datarate                                                    ("5000000000 bps"),
		.pma_tx_buf_prot_mode                                                   ("pcie_gen2_tx"),
		.pma_tx_buf_rx_det                                                      ("mode_0"),
		.pma_tx_buf_rx_det_output_sel                                           ("rx_det_pcie_out"),
		.pma_tx_buf_rx_det_pdb                                                  ("rx_det_on"),
		.pma_tx_buf_sup_mode                                                    ("user_mode"),
		.pma_tx_buf_user_fir_coeff_ctrl_sel                                     ("dynamic_ctl"),
		.pma_tx_buf_xtx_path_prot_mode                                          ("pcie_gen2_tx"),
		.pma_tx_buf_xtx_path_datarate                                           ("5000000000 bps"),
		.pma_tx_buf_xtx_path_datawidth                                          (10),
		.pma_tx_buf_xtx_path_clock_divider_ratio                                (1),
		.pma_tx_buf_xtx_path_pma_tx_divclk_hz                                   ("500000000"),
		.pma_tx_buf_xtx_path_tx_pll_clk_hz                                      ("2500000000"),
		.pma_tx_buf_xtx_path_sup_mode                                           ("user_mode"),
		.cdr_pll_pma_width                                                      (10),
		.cdr_pll_cgb_div                                                        (1),
		.cdr_pll_is_cascaded_pll                                                ("false"),
		.cdr_pll_datarate                                                       ("5000000000 bps"),
		.cdr_pll_lpd_counter                                                    (4),
		.cdr_pll_lpfd_counter                                                   (4),
		.cdr_pll_n_counter_scratch                                              (1),
		.cdr_pll_output_clock_frequency                                         ("2500000000 Hz"),
		.cdr_pll_reference_clock_frequency                                      ("100000000 hz"),
		.cdr_pll_set_cdr_vco_speed                                              (2),
		.cdr_pll_set_cdr_vco_speed_fix                                          (117),
		.cdr_pll_vco_freq                                                       ("10000000000 Hz"),
		.cdr_pll_atb_select_control                                             ("atb_off"),
		.cdr_pll_auto_reset_on                                                  ("auto_reset_off"),
		.cdr_pll_bbpd_data_pattern_filter_select                                ("bbpd_data_pat_off"),
		.cdr_pll_bw_sel                                                         ("medium"),
		.cdr_pll_cdr_odi_select                                                 ("sel_cdr"),
		.cdr_pll_cdr_phaselock_mode                                             ("no_ignore_lock"),
		.cdr_pll_cdr_powerdown_mode                                             ("power_up"),
		.cdr_pll_chgpmp_current_pd                                              ("cp_current_pd_setting0"),
		.cdr_pll_chgpmp_current_pfd                                             ("cp_current_pfd_setting4"),
		.cdr_pll_chgpmp_replicate                                               ("false"),
		.cdr_pll_chgpmp_testmode                                                ("cp_test_disable"),
		.cdr_pll_clklow_mux_select                                              ("clklow_mux_cdr_fbclk"),
		.cdr_pll_diag_loopback_enable                                           ("false"),
		.cdr_pll_disable_up_dn                                                  ("true"),
		.cdr_pll_fref_clklow_div                                                (1),
		.cdr_pll_fref_mux_select                                                ("fref_mux_cdr_refclk"),
		.cdr_pll_gpon_lck2ref_control                                           ("gpon_lck2ref_off"),
		.cdr_pll_initial_settings                                               ("true"),
		.cdr_pll_lck2ref_delay_control                                          ("lck2ref_delay_2"),
		.cdr_pll_lf_resistor_pd                                                 ("lf_pd_setting3"),
		.cdr_pll_lf_resistor_pfd                                                ("lf_pfd_setting2"),
		.cdr_pll_lf_ripple_cap                                                  ("lf_no_ripple"),
		.cdr_pll_loop_filter_bias_select                                        ("lpflt_bias_7"),
		.cdr_pll_loopback_mode                                                  ("loopback_disabled"),
		.cdr_pll_ltd_ltr_micro_controller_select                                ("ltd_ltr_pcs"),
		.cdr_pll_m_counter                                                      (25),
		.cdr_pll_n_counter                                                      (1),
		.cdr_pll_pd_fastlock_mode                                               ("false"),
		.cdr_pll_pd_l_counter                                                   (4),
		.cdr_pll_pfd_l_counter                                                  (4),
		.cdr_pll_primary_use                                                    ("cdr"),
		.cdr_pll_prot_mode                                                      ("pcie_gen2_rx"),
		.cdr_pll_reverse_serial_loopback                                        ("no_loopback"),
		.cdr_pll_set_cdr_v2i_enable                                             ("true"),
		.cdr_pll_set_cdr_vco_reset                                              ("false"),
		.cdr_pll_set_cdr_vco_speed_pciegen3                                     ("cdr_vco_max_speedbin_pciegen3"),
		.cdr_pll_sup_mode                                                       ("user_mode"),
		.cdr_pll_tx_pll_prot_mode                                               ("txpll_unused"),
		.cdr_pll_txpll_hclk_driver_enable                                       ("false"),
		.cdr_pll_vco_overrange_voltage                                          ("vco_overrange_off"),
		.cdr_pll_vco_underrange_voltage                                         ("vco_underange_off"),
		.cdr_pll_fb_select                                                      ("direct_fb"),
		.cdr_pll_uc_ro_cal                                                      ("uc_ro_cal_on"),
		.cdr_pll_iqclk_mux_sel                                                  ("power_down"),
		.cdr_pll_pcie_gen                                                       ("pcie_gen2_100mhzref"),
		.cdr_pll_set_cdr_input_freq_range                                       (0),
		.cdr_pll_chgpmp_current_dn_trim                                         ("cp_current_trimming_dn_setting0"),
		.cdr_pll_chgpmp_up_pd_trim_double                                       ("normal_up_trim_current"),
		.cdr_pll_chgpmp_current_up_pd                                           ("cp_current_pd_up_setting4"),
		.cdr_pll_chgpmp_current_up_trim                                         ("cp_current_trimming_up_setting0"),
		.cdr_pll_chgpmp_dn_pd_trim_double                                       ("normal_dn_trim_current"),
		.cdr_pll_cal_vco_count_length                                           ("sel_8b_count"),
		.cdr_pll_chgpmp_current_dn_pd                                           ("cp_current_pd_dn_setting4"),
		.pma_rx_deser_clkdiv_source                                             ("vco_bypass_normal"),
		.pma_rx_deser_clkdivrx_user_mode                                        ("clkdivrx_user_disabled"),
		.pma_rx_deser_datarate                                                  ("5000000000 bps"),
		.pma_rx_deser_deser_factor                                              (10),
		.pma_rx_deser_force_clkdiv_for_testing                                  ("normal_clkdiv"),
		.pma_rx_deser_sdclk_enable                                              ("true"),
		.pma_rx_deser_sup_mode                                                  ("user_mode"),
		.pma_rx_deser_rst_n_adapt_odi                                           ("no_rst_adapt_odi"),
		.pma_rx_deser_bitslip_bypass                                            ("bs_bypass_yes"),
		.pma_rx_deser_prot_mode                                                 ("pcie_gen2_rx"),
		.pma_rx_deser_pcie_gen                                                  ("pcie_gen2_100mhzref"),
		.pma_rx_deser_pcie_gen_bitwidth                                         ("pcie_gen3_32b")
	) phy_g2x4 (
		.hip_pipe_pclk             (hip_pipe_pclk),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         //         hip_pipe_pclk.hip_pipe_pclk
		.hip_fixedclk              (hip_fixedclk),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          //          hip_fixedclk.hip_fixedclk
		.ltssm_detect_quiet        (ltssm_detect_quiet),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    //    ltssm_detect_quiet.ltssm_detect_quiet
		.ltssm_detect_active       (ltssm_detect_active),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   //   ltssm_detect_active.ltssm_detect_active
		.ltssm_rcvr_phase_two      (ltssm_rcvr_phase_two),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  //  ltssm_rcvr_phase_two.ltssm_rcvr_phase_two
		.hip_reduce_counters       (hip_reduce_counters),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   //   hip_reduce_counters.hip_reduce_counters
		.pcie_rate                 (pcie_rate),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //             pcie_rate.pcie_rate
		.pipe_rate                 (pipe_rate),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //             pipe_rate.pipe_rate
		.pipe_sw_done              (pipe_sw_done),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          //          pipe_sw_done.pipe_sw_done
		.pipe_sw                   (pipe_sw),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //               pipe_sw.pipe_sw
		.tx_analogreset            (tx_analogreset),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        //        tx_analogreset.tx_analogreset
		.tx_digitalreset           (tx_digitalreset),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       //       tx_digitalreset.tx_digitalreset
		.rx_analogreset            (rx_analogreset),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        //        rx_analogreset.rx_analogreset
		.rx_digitalreset           (rx_digitalreset),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       //       rx_digitalreset.rx_digitalreset
		.tx_cal_busy               (tx_cal_busy),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           //           tx_cal_busy.tx_cal_busy
		.rx_cal_busy               (rx_cal_busy),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           //           rx_cal_busy.rx_cal_busy
		.tx_bonding_clocks         (tx_bonding_clocks),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     //     tx_bonding_clocks.clk
		.rx_cdr_refclk0            (rx_cdr_refclk0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        //        rx_cdr_refclk0.clk
		.tx_serial_data            (tx_serial_data),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        //        tx_serial_data.tx_serial_data
		.rx_serial_data            (rx_serial_data),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        //        rx_serial_data.rx_serial_data
		.rx_set_locktodata         (rx_set_locktodata),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     //     rx_set_locktodata.rx_set_locktodata
		.rx_set_locktoref          (rx_set_locktoref),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //      rx_set_locktoref.rx_set_locktoref
		.rx_is_lockedtoref         (rx_is_lockedtoref),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     //     rx_is_lockedtoref.rx_is_lockedtoref
		.rx_is_lockedtodata        (rx_is_lockedtodata),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    //    rx_is_lockedtodata.rx_is_lockedtodata
		.rx_polinv                 (rx_polinv),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             //             rx_polinv.rx_polinv
		.tx_hip_data               (tx_hip_data),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           //           tx_hip_data.tx_hip_data
		.rx_hip_data               (rx_hip_data),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           //           rx_hip_data.rx_hip_data
		.hip_frefclk               (hip_frefclk),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           //           hip_frefclk.hip_frefclk
		.hip_ctrl                  (hip_ctrl),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //              hip_ctrl.hip_ctrl
		.hip_cal_done              (hip_cal_done),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          //          hip_cal_done.hip_cal_done
		.pipe_hclk_in              (pipe_hclk_in),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          //          pipe_hclk_in.clk
		.pipe_rx_eidleinfersel     (pipe_rx_eidleinfersel),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 // pipe_rx_eidleinfersel.pipe_rx_eidleinfersel
		.pipe_rx_elecidle          (pipe_rx_elecidle),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //      pipe_rx_elecidle.pipe_rx_elecidle
		.pipe_rx_polarity          (pipe_rx_polarity),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //      pipe_rx_polarity.pipe_rx_polarity
		.reconfig_clk              (reconfig_clk),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          //          reconfig_clk.clk
		.reconfig_reset            (reconfig_reset),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        //        reconfig_reset.reset
		.reconfig_write            (reconfig_write),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        //         reconfig_avmm.write
		.reconfig_read             (reconfig_read),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         //                      .read
		.reconfig_address          (reconfig_address),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //                      .address
		.reconfig_writedata        (reconfig_writedata),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    //                      .writedata
		.reconfig_readdata         (reconfig_readdata),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     //                      .readdata
		.reconfig_waitrequest      (reconfig_waitrequest),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  //                      .waitrequest
		.tx_analogreset_ack        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_analogreset_ack        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_serial_clk0            (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_serial_clk1            (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_serial_clk2            (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_serial_clk3            (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_bonding_clocks1        (24'b000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          //           (terminated)
		.tx_bonding_clocks2        (24'b000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          //           (terminated)
		.tx_bonding_clocks3        (24'b000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          //           (terminated)
		.rx_cdr_refclk1            (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  //           (terminated)
		.rx_cdr_refclk2            (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  //           (terminated)
		.rx_cdr_refclk3            (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  //           (terminated)
		.rx_cdr_refclk4            (1'b0),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  //           (terminated)
		.rx_pma_clkslip            (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.rx_seriallpbken           (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.rx_pma_qpipulldn          (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_pma_qpipulldn          (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_pma_qpipullup          (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_pma_txdetectrx         (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_pma_elecidle           (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_pma_rxfound            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_clklow                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_fref                   (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_coreclkin              (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.rx_coreclkin              (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_clkout                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_clkout                 (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_pma_clkout             (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_pma_div_clkout         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_pma_iqtxrx_clkout      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_pma_clkout             (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_pma_div_clkout         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_pma_iqtxrx_clkout      (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_parallel_data          (512'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000), //           (terminated)
		.tx_control                (72'b000000000000000000000000000000000000000000000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                          //           (terminated)
		.rx_parallel_data          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_control                (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_bitslip                (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.rx_adapt_reset            (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.rx_adapt_start            (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.rx_prbs_err_clr           (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.rx_prbs_done              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_prbs_err               (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_uhsif_clk              (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_uhsif_clkout           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_uhsif_lock             (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_std_pcfifo_full        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_std_pcfifo_empty       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_std_pcfifo_full        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_std_pcfifo_empty       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_std_bitrev_ena         (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.rx_std_byterev_ena        (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_polinv                 (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_std_bitslipboundarysel (20'b00000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              //           (terminated)
		.rx_std_bitslipboundarysel (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_std_wa_patternalign    (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.rx_std_wa_a1a2size        (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.rx_std_rmfifo_full        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_std_rmfifo_empty       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_std_signaldetect       (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_enh_data_valid         (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_enh_fifo_full          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_enh_fifo_pfull         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_enh_fifo_empty         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_enh_fifo_pempty        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_enh_fifo_cnt           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_enh_fifo_rd_en         (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.rx_enh_data_valid         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_enh_fifo_full          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_enh_fifo_pfull         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_enh_fifo_empty         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_enh_fifo_pempty        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_enh_fifo_del           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_enh_fifo_insert        (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_enh_fifo_cnt           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_enh_fifo_align_val     (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_enh_fifo_align_clr     (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_enh_frame              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_enh_frame_burst_en     (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.tx_enh_frame_diag_status  (8'b00000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           //           (terminated)
		.rx_enh_frame              (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_enh_frame_lock         (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_enh_frame_diag_status  (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_enh_crc32_err          (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_enh_highber            (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.rx_enh_highber_clr_cnt    (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.rx_enh_clr_errblk_count   (4'b0000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               //           (terminated)
		.rx_enh_blk_lock           (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.tx_enh_bitslip            (28'b0000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.pipe_hclk_out             (),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.pipe_g3_txdeemph          (72'b000000000000000000000000000000000000000000000000000000000000000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                          //           (terminated)
		.pipe_g3_rxpresethint      (12'b000000000000),                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      //           (terminated)
		.avmm_busy                 ()                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       //           (terminated)
	);

endmodule
