// fpll_g1g2xn.v

// Generated using ACDS version 17.1 593

`timescale 1 ps / 1 ps
module fpll_g1g2xn #(
		parameter enable_pll_reconfig                                                          = 1,
		parameter rcfg_jtag_enable                                                             = 0,
		parameter rcfg_separate_avmm_busy                                                      = 0,
		parameter dbg_embedded_debug_enable                                                    = 0,
		parameter dbg_capability_reg_enable                                                    = 0,
		parameter dbg_user_identifier                                                          = 0,
		parameter dbg_stat_soft_logic_enable                                                   = 0,
		parameter dbg_ctrl_soft_logic_enable                                                   = 0,
		parameter cmu_fpll_silicon_rev                                                         = "20nm5",
		parameter cmu_fpll_is_otn                                                              = "false",
		parameter cmu_fpll_is_sdi                                                              = "false",
		parameter cmu_fpll_f_max_vco                                                           = "12500000000",
		parameter cmu_fpll_f_min_vco                                                           = "6000000000",
		parameter cmu_fpll_feedback                                                            = "normal",
		parameter cmu_fpll_fpll_cas_out_enable                                                 = "fpll_cas_out_disable",
		parameter cmu_fpll_fpll_hclk_out_enable                                                = "fpll_hclk_out_enable",
		parameter cmu_fpll_fpll_iqtxrxclk_out_enable                                           = "fpll_iqtxrxclk_out_disable",
		parameter cmu_fpll_l_counter                                                           = 2,
		parameter cmu_fpll_m_counter                                                           = 50,
		parameter cmu_fpll_n_counter                                                           = 1,
		parameter cmu_fpll_out_freq_hz                                                         = "0 hz",
		parameter cmu_fpll_out_freq                                                            = "000010010101000000101111100100000000",
		parameter cmu_fpll_pll_vco_freq_band_0                                                 = "pll_freq_band0",
		parameter cmu_fpll_pll_vco_freq_band_1                                                 = "pll_freq_band0_1",
		parameter cmu_fpll_primary_use                                                         = "tx",
		parameter cmu_fpll_prot_mode                                                           = "pcie_gen2_tx",
		parameter cmu_fpll_reference_clock_frequency_scratch                                   = "0 hz",
		parameter cmu_fpll_side                                                                = "side_unknown",
		parameter cmu_fpll_top_or_bottom                                                       = "tb_unknown",
		parameter cmu_fpll_vco_freq_hz                                                         = "10000000000",
		parameter cmu_fpll_vco_freq                                                            = "001001010100000010111110010000000000",
		parameter cmu_fpll_pll_bw_mode                                                         = "hi_bw",
		parameter cmu_fpll_datarate                                                            = "5000000000 bps",
		parameter cmu_fpll_pll_cmu_rstn_value                                                  = "true",
		parameter cmu_fpll_pll_lpf_rstn_value                                                  = "lpf_normal",
		parameter cmu_fpll_pll_ppm_clk0_src                                                    = "ppm_clk0_vss",
		parameter cmu_fpll_pll_ppm_clk1_src                                                    = "ppm_clk1_vss",
		parameter cmu_fpll_pll_rstn_override                                                   = "false",
		parameter cmu_fpll_pll_op_mode                                                         = "false",
		parameter cmu_fpll_pll_optimal                                                         = "true",
		parameter cmu_fpll_is_pa_core                                                          = "false",
		parameter cmu_fpll_pll_powerdown_mode                                                  = "false",
		parameter cmu_fpll_pll_sup_mode                                                        = "user_mode",
		parameter cmu_fpll_pll_c0_pllcout_enable                                               = "true",
		parameter cmu_fpll_pll_c_counter_0                                                     = 5,
		parameter cmu_fpll_pll_c_counter_0_min_tco_enable                                      = "false",
		parameter cmu_fpll_pll_c_counter_0_in_src                                              = "m_cnt_in_src_ph_mux_clk",
		parameter cmu_fpll_pll_c_counter_0_ph_mux_prst                                         = 0,
		parameter cmu_fpll_pll_c_counter_0_prst                                                = 1,
		parameter cmu_fpll_pll_c_counter_0_coarse_dly                                          = "0 ps",
		parameter cmu_fpll_pll_c_counter_0_fine_dly                                            = "0 ps",
		parameter cmu_fpll_pll_c1_pllcout_enable                                               = "false",
		parameter cmu_fpll_pll_c_counter_1                                                     = 1,
		parameter cmu_fpll_pll_c_counter_1_min_tco_enable                                      = "false",
		parameter cmu_fpll_pll_c_counter_1_in_src                                              = "m_cnt_in_src_test_clk",
		parameter cmu_fpll_pll_c_counter_1_ph_mux_prst                                         = 0,
		parameter cmu_fpll_pll_c_counter_1_prst                                                = 1,
		parameter cmu_fpll_pll_c_counter_1_coarse_dly                                          = "0 ps",
		parameter cmu_fpll_pll_c_counter_1_fine_dly                                            = "0 ps",
		parameter cmu_fpll_pll_c2_pllcout_enable                                               = "false",
		parameter cmu_fpll_pll_c_counter_2                                                     = 1,
		parameter cmu_fpll_pll_c_counter_2_min_tco_enable                                      = "false",
		parameter cmu_fpll_pll_c_counter_2_in_src                                              = "m_cnt_in_src_test_clk",
		parameter cmu_fpll_pll_c_counter_2_ph_mux_prst                                         = 0,
		parameter cmu_fpll_pll_c_counter_2_prst                                                = 1,
		parameter cmu_fpll_pll_c_counter_2_coarse_dly                                          = "0 ps",
		parameter cmu_fpll_pll_c_counter_2_fine_dly                                            = "0 ps",
		parameter cmu_fpll_pll_c3_pllcout_enable                                               = "false",
		parameter cmu_fpll_pll_c_counter_3                                                     = 1,
		parameter cmu_fpll_pll_c_counter_3_min_tco_enable                                      = "false",
		parameter cmu_fpll_pll_c_counter_3_in_src                                              = "m_cnt_in_src_test_clk",
		parameter cmu_fpll_pll_c_counter_3_ph_mux_prst                                         = 0,
		parameter cmu_fpll_pll_c_counter_3_prst                                                = 1,
		parameter cmu_fpll_pll_c_counter_3_coarse_dly                                          = "0 ps",
		parameter cmu_fpll_pll_c_counter_3_fine_dly                                            = "0 ps",
		parameter cmu_fpll_pll_atb                                                             = "atb_selectdisable",
		parameter cmu_fpll_pll_fbclk_mux_1                                                     = "pll_fbclk_mux_1_glb",
		parameter cmu_fpll_pll_fbclk_mux_2                                                     = "pll_fbclk_mux_2_m_cnt",
		parameter cmu_fpll_pll_iqclk_mux_sel                                                   = "power_down",
		parameter cmu_fpll_pll_cp_compensation                                                 = "true",
		parameter cmu_fpll_pll_cp_current_setting                                              = "cp_current_setting26",
		parameter cmu_fpll_pll_cp_testmode                                                     = "cp_normal",
		parameter cmu_fpll_pll_cp_lf_3rd_pole_freq                                             = "lf_3rd_pole_setting0",
		parameter cmu_fpll_pll_lf_cbig                                                         = "lf_cbig_setting4",
		parameter cmu_fpll_pll_cp_lf_order                                                     = "lf_2nd_order",
		parameter cmu_fpll_pll_lf_resistance                                                   = "lf_res_setting1",
		parameter cmu_fpll_pll_lf_ripplecap                                                    = "lf_no_ripple",
		parameter cmu_fpll_pll_vco_ph0_en                                                      = "true",
		parameter cmu_fpll_pll_vco_ph0_value                                                   = "pll_vco_ph0_vss",
		parameter cmu_fpll_pll_vco_ph1_en                                                      = "false",
		parameter cmu_fpll_pll_vco_ph1_value                                                   = "pll_vco_ph1_vss",
		parameter cmu_fpll_pll_vco_ph2_en                                                      = "false",
		parameter cmu_fpll_pll_vco_ph2_value                                                   = "pll_vco_ph2_vss",
		parameter cmu_fpll_pll_vco_ph3_en                                                      = "false",
		parameter cmu_fpll_pll_vco_ph3_value                                                   = "pll_vco_ph3_vss",
		parameter cmu_fpll_pll_dsm_mode                                                        = "dsm_mode_integer",
		parameter cmu_fpll_pll_dsm_out_sel                                                     = "pll_dsm_disable",
		parameter cmu_fpll_pll_dsm_ecn_bypass                                                  = "false",
		parameter cmu_fpll_pll_dsm_ecn_test_en                                                 = "false",
		parameter cmu_fpll_pll_dsm_fractional_division                                         = "1",
		parameter cmu_fpll_pll_dsm_fractional_value_ready                                      = "pll_k_ready",
		parameter cmu_fpll_pll_l_counter_bypass                                                = "false",
		parameter cmu_fpll_pll_l_counter                                                       = 2,
		parameter cmu_fpll_pll_l_counter_enable                                                = "true",
		parameter cmu_fpll_pll_lock_fltr_cfg                                                   = 25,
		parameter cmu_fpll_pll_lock_fltr_test                                                  = "pll_lock_fltr_nrm",
		parameter cmu_fpll_pll_unlock_fltr_cfg                                                 = 2,
		parameter cmu_fpll_pll_m_counter                                                       = 50,
		parameter cmu_fpll_pll_m_counter_min_tco_enable                                        = "false",
		parameter cmu_fpll_pll_m_counter_in_src                                                = "m_cnt_in_src_ph_mux_clk",
		parameter cmu_fpll_pll_n_counter                                                       = 1,
		parameter cmu_fpll_pll_tclk_mux_en                                                     = "false",
		parameter cmu_fpll_pll_tclk_sel                                                        = "pll_tclk_m_src",
		parameter cmu_fpll_pll_dprio_base_addr                                                 = 256,
		parameter cmu_fpll_pll_dprio_broadcast_en                                              = "false",
		parameter cmu_fpll_pll_dprio_cvp_inter_sel                                             = "false",
		parameter cmu_fpll_pll_dprio_force_inter_sel                                           = "false",
		parameter cmu_fpll_pll_dprio_power_iso_en                                              = "false",
		parameter cmu_fpll_pll_dprio_status_select                                             = "dprio_normal_status",
		parameter cmu_fpll_pll_extra_csr                                                       = 0,
		parameter cmu_fpll_pll_nreset_invert                                                   = "false",
		parameter cmu_fpll_pll_ctrl_override_setting                                           = "true",
		parameter cmu_fpll_pll_enable                                                          = "true",
		parameter cmu_fpll_pll_test_enable                                                     = "false",
		parameter cmu_fpll_pll_ctrl_plniotri_override                                          = "false",
		parameter cmu_fpll_pll_vccr_pd_en                                                      = "true",
		parameter cmu_fpll_bw_sel                                                              = "high",
		parameter cmu_fpll_compensation_mode                                                   = "direct",
		parameter cmu_fpll_duty_cycle_0                                                        = 50,
		parameter cmu_fpll_duty_cycle_1                                                        = 50,
		parameter cmu_fpll_duty_cycle_2                                                        = 50,
		parameter cmu_fpll_duty_cycle_3                                                        = 50,
		parameter cmu_fpll_hssi_output_clock_frequency                                         = "2500.0 MHz",
		parameter cmu_fpll_is_cascaded_pll                                                     = "false",
		parameter cmu_fpll_output_clock_frequency_0                                            = "500 MHz",
		parameter cmu_fpll_output_clock_frequency_1                                            = "0 ps",
		parameter cmu_fpll_output_clock_frequency_2                                            = "0 ps",
		parameter cmu_fpll_output_clock_frequency_3                                            = "0 ps",
		parameter cmu_fpll_phase_shift_0                                                       = "0 ps",
		parameter cmu_fpll_phase_shift_1                                                       = "0 ps",
		parameter cmu_fpll_phase_shift_2                                                       = "0 ps",
		parameter cmu_fpll_phase_shift_3                                                       = "0 ps",
		parameter cmu_fpll_reference_clock_frequency                                           = "100.0 MHz",
		parameter cmu_fpll_vco_frequency                                                       = "10000.0 MHz",
		parameter cmu_fpll_cgb_div                                                             = 1,
		parameter cmu_fpll_pma_width                                                           = 10,
		parameter cmu_fpll_f_out_c3_hz                                                         = "0 hz",
		parameter cmu_fpll_f_out_c1_hz                                                         = "0 hz",
		parameter cmu_fpll_f_out_c0_hz                                                         = "0 hz",
		parameter cmu_fpll_f_out_c2_hz                                                         = "0 hz",
		parameter cmu_fpll_f_out_c3                                                            = "000000000000000000000000000000000000",
		parameter cmu_fpll_f_out_c1                                                            = "000000000000000000000000000000000000",
		parameter cmu_fpll_f_out_c0                                                            = "000000011101110011010110010100000000",
		parameter cmu_fpll_f_out_c2                                                            = "000000000000000000000000000000000000",
		parameter cmu_fpll_initial_settings                                                    = "true",
		parameter cmu_fpll_m_counter_c2                                                        = 1,
		parameter cmu_fpll_m_counter_c3                                                        = 1,
		parameter cmu_fpll_m_counter_c0                                                        = 1,
		parameter cmu_fpll_m_counter_c1                                                        = 1,
		parameter cmu_fpll_pfd_freq                                                            = "000000000101111101011110000100000000",
		parameter cmu_fpll_pll_vco_freq_band_0_fix_high                                        = "pll_vco_freq_band_0_fix_high_0",
		parameter cmu_fpll_pll_vco_freq_band_1_fix_high                                        = "pll_vco_freq_band_1_fix_high_0",
		parameter cmu_fpll_xpm_cmu_fpll_core_cal_vco_count_length                              = "sel_8b_count",
		parameter cmu_fpll_xpm_cmu_fpll_core_pfd_pulse_width                                   = "pulse_width_setting0",
		parameter cmu_fpll_pll_vco_freq_band_1_dyn_high_bits                                   = 0,
		parameter cmu_fpll_set_fpll_input_freq_range                                           = 0,
		parameter cmu_fpll_pll_vco_freq_band_0_fix                                             = 1,
		parameter cmu_fpll_pll_vco_freq_band_0_dyn_high_bits                                   = 0,
		parameter cmu_fpll_pll_vco_freq_band_1_fix                                             = 1,
		parameter cmu_fpll_xpm_cmu_fpll_core_xpm_cpvco_fpll_xpm_chgpmplf_fpll_cp_current_boost = "normal_setting",
		parameter cmu_fpll_xpm_cmu_fpll_core_fpll_refclk_source                                = "normal_refclk",
		parameter cmu_fpll_pll_vco_freq_band_0_dyn_low_bits                                    = 0,
		parameter cmu_fpll_xpm_cmu_fpll_core_pfd_delay_compensation                            = "normal_delay",
		parameter cmu_fpll_pll_vco_freq_band_1_dyn_low_bits                                    = 0,
		parameter cmu_fpll_refclk_select_mux_pll_clk_sel_override                              = "normal",
		parameter cmu_fpll_refclk_select_mux_pll_clk_sel_override_value                        = "select_clk0",
		parameter cmu_fpll_refclk_select_mux_pll_auto_clk_sw_en                                = "false",
		parameter cmu_fpll_refclk_select_mux_pll_clk_loss_edge                                 = "pll_clk_loss_both_edges",
		parameter cmu_fpll_refclk_select_mux_pll_clk_loss_sw_en                                = "false",
		parameter cmu_fpll_refclk_select_mux_pll_clk_sw_dly                                    = 0,
		parameter cmu_fpll_refclk_select_mux_pll_manu_clk_sw_en                                = "false",
		parameter cmu_fpll_refclk_select_mux_pll_sw_refclk_src                                 = "pll_sw_refclk_src_clk_0",
		parameter cmu_fpll_refclk_select_mux_silicon_rev                                       = "20nm5es",
		parameter cmu_fpll_refclk_select_mux_refclk_select0                                    = "lvpecl",
		parameter cmu_fpll_refclk_select_mux_refclk_select1                                    = "ref_iqclk0",
		parameter cmu_fpll_refclk_select_mux_mux0_inclk0_logical_to_physical_mapping           = "lvpecl",
		parameter cmu_fpll_refclk_select_mux_mux0_inclk1_logical_to_physical_mapping           = "power_down",
		parameter cmu_fpll_refclk_select_mux_mux0_inclk2_logical_to_physical_mapping           = "power_down",
		parameter cmu_fpll_refclk_select_mux_mux0_inclk3_logical_to_physical_mapping           = "power_down",
		parameter cmu_fpll_refclk_select_mux_mux0_inclk4_logical_to_physical_mapping           = "power_down",
		parameter cmu_fpll_refclk_select_mux_mux1_inclk0_logical_to_physical_mapping           = "lvpecl",
		parameter cmu_fpll_refclk_select_mux_mux1_inclk1_logical_to_physical_mapping           = "power_down",
		parameter cmu_fpll_refclk_select_mux_mux1_inclk2_logical_to_physical_mapping           = "power_down",
		parameter cmu_fpll_refclk_select_mux_mux1_inclk3_logical_to_physical_mapping           = "power_down",
		parameter cmu_fpll_refclk_select_mux_mux1_inclk4_logical_to_physical_mapping           = "power_down",
		parameter enable_analog_resets                                                         = 0,
		parameter hip_cal_en                                                                   = "enable",
		parameter cmu_fpll_reconfig_en                                                         = "1",
		parameter cmu_fpll_dps_en                                                              = "false",
		parameter cmu_fpll_calibration_en                                                      = "enable",
		parameter cmu_fpll_refclk_freq                                                         = "000000000101111101011110000100000000",
		parameter enable_mcgb                                                                  = 1,
		parameter enable_mcgb_debug_ports_parameters                                           = 0,
		parameter hssi_pma_cgb_master_prot_mode                                                = "pcie_gen2_tx",
		parameter hssi_pma_cgb_master_silicon_rev                                              = "20nm5",
		parameter hssi_pma_cgb_master_x1_div_m_sel                                             = "divbypass",
		parameter hssi_pma_cgb_master_cgb_enable_iqtxrxclk                                     = "disable_iqtxrxclk",
		parameter hssi_pma_cgb_master_ser_mode                                                 = "ten_bit",
		parameter hssi_pma_cgb_master_datarate                                                 = "5000000000 bps",
		parameter hssi_pma_cgb_master_cgb_power_down                                           = "normal_cgb",
		parameter hssi_pma_cgb_master_observe_cgb_clocks                                       = "observe_nothing",
		parameter hssi_pma_cgb_master_op_mode                                                  = "enabled",
		parameter hssi_pma_cgb_master_tx_ucontrol_reset_pcie                                   = "pcscorehip_controls_mcgb",
		parameter hssi_pma_cgb_master_vccdreg_output                                           = "vccdreg_nominal",
		parameter hssi_pma_cgb_master_input_select                                             = "fpll_top",
		parameter hssi_pma_cgb_master_input_select_gen3                                        = "unused"
	) (
		input  wire        pll_refclk0,           //       pll_refclk0.clk
		input  wire        pll_powerdown,         //     pll_powerdown.pll_powerdown
		output wire        pll_locked,            //        pll_locked.pll_locked
		output wire        tx_serial_clk,         //     tx_serial_clk.clk
		output wire        pll_pcie_clk,          //      pll_pcie_clk.pll_pcie_clk
		input  wire        reconfig_clk0,         //     reconfig_clk0.clk
		input  wire        reconfig_reset0,       //   reconfig_reset0.reset
		input  wire        reconfig_write0,       //    reconfig_avmm0.write
		input  wire        reconfig_read0,        //                  .read
		input  wire [9:0]  reconfig_address0,     //                  .address
		input  wire [31:0] reconfig_writedata0,   //                  .writedata
		output wire [31:0] reconfig_readdata0,    //                  .readdata
		output wire        reconfig_waitrequest0, //                  .waitrequest
		output wire        pll_cal_busy,          //      pll_cal_busy.pll_cal_busy
		output wire        hip_cal_done,          //      hip_cal_done.hip_cal_done
		input  wire        mcgb_rst,              //          mcgb_rst.mcgb_rst
		output wire [5:0]  tx_bonding_clocks,     // tx_bonding_clocks.clk
		input  wire [1:0]  pcie_sw,               //           pcie_sw.pcie_sw
		output wire [1:0]  pcie_sw_done,          //      pcie_sw_done.pcie_sw_done
		output wire        mcgb_hip_cal_done      // mcgb_hip_cal_done.hip_cal_done
	);

	generate
		// If any of the display statements (or deliberately broken
		// instantiations) within this generate block triggers then this module
		// has been instantiated this module with a set of parameters different
		// from those it was generated for.  This will usually result in a
		// non-functioning system.
		if (enable_pll_reconfig != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					enable_pll_reconfig_check ( .error(1'b1) );
		end
		if (rcfg_jtag_enable != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					rcfg_jtag_enable_check ( .error(1'b1) );
		end
		if (rcfg_separate_avmm_busy != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					rcfg_separate_avmm_busy_check ( .error(1'b1) );
		end
		if (dbg_embedded_debug_enable != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					dbg_embedded_debug_enable_check ( .error(1'b1) );
		end
		if (dbg_capability_reg_enable != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					dbg_capability_reg_enable_check ( .error(1'b1) );
		end
		if (dbg_user_identifier != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					dbg_user_identifier_check ( .error(1'b1) );
		end
		if (dbg_stat_soft_logic_enable != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					dbg_stat_soft_logic_enable_check ( .error(1'b1) );
		end
		if (dbg_ctrl_soft_logic_enable != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					dbg_ctrl_soft_logic_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_silicon_rev != "20nm5")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_silicon_rev_check ( .error(1'b1) );
		end
		if (cmu_fpll_is_otn != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_is_otn_check ( .error(1'b1) );
		end
		if (cmu_fpll_is_sdi != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_is_sdi_check ( .error(1'b1) );
		end
		if (cmu_fpll_f_max_vco != "12500000000")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_f_max_vco_check ( .error(1'b1) );
		end
		if (cmu_fpll_f_min_vco != "6000000000")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_f_min_vco_check ( .error(1'b1) );
		end
		if (cmu_fpll_feedback != "normal")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_feedback_check ( .error(1'b1) );
		end
		if (cmu_fpll_fpll_cas_out_enable != "fpll_cas_out_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_fpll_cas_out_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_fpll_hclk_out_enable != "fpll_hclk_out_enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_fpll_hclk_out_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_fpll_iqtxrxclk_out_enable != "fpll_iqtxrxclk_out_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_fpll_iqtxrxclk_out_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_l_counter != 2)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_l_counter_check ( .error(1'b1) );
		end
		if (cmu_fpll_m_counter != 50)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_m_counter_check ( .error(1'b1) );
		end
		if (cmu_fpll_n_counter != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_n_counter_check ( .error(1'b1) );
		end
		if (cmu_fpll_out_freq_hz != "0 hz")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_out_freq_hz_check ( .error(1'b1) );
		end
		if (cmu_fpll_out_freq != "000010010101000000101111100100000000")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_out_freq_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_freq_band_0 != "pll_freq_band0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_freq_band_0_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_freq_band_1 != "pll_freq_band0_1")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_freq_band_1_check ( .error(1'b1) );
		end
		if (cmu_fpll_primary_use != "tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_primary_use_check ( .error(1'b1) );
		end
		if (cmu_fpll_prot_mode != "pcie_gen2_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_prot_mode_check ( .error(1'b1) );
		end
		if (cmu_fpll_reference_clock_frequency_scratch != "0 hz")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_reference_clock_frequency_scratch_check ( .error(1'b1) );
		end
		if (cmu_fpll_side != "side_unknown")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_side_check ( .error(1'b1) );
		end
		if (cmu_fpll_top_or_bottom != "tb_unknown")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_top_or_bottom_check ( .error(1'b1) );
		end
		if (cmu_fpll_vco_freq_hz != "10000000000")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_vco_freq_hz_check ( .error(1'b1) );
		end
		if (cmu_fpll_vco_freq != "001001010100000010111110010000000000")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_vco_freq_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_bw_mode != "hi_bw")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_bw_mode_check ( .error(1'b1) );
		end
		if (cmu_fpll_datarate != "5000000000 bps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_datarate_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_cmu_rstn_value != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_cmu_rstn_value_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_lpf_rstn_value != "lpf_normal")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_lpf_rstn_value_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_ppm_clk0_src != "ppm_clk0_vss")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_ppm_clk0_src_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_ppm_clk1_src != "ppm_clk1_vss")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_ppm_clk1_src_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_rstn_override != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_rstn_override_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_op_mode != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_op_mode_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_optimal != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_optimal_check ( .error(1'b1) );
		end
		if (cmu_fpll_is_pa_core != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_is_pa_core_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_powerdown_mode != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_powerdown_mode_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_sup_mode != "user_mode")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_sup_mode_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c0_pllcout_enable != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c0_pllcout_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_0 != 5)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_0_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_0_min_tco_enable != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_0_min_tco_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_0_in_src != "m_cnt_in_src_ph_mux_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_0_in_src_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_0_ph_mux_prst != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_0_ph_mux_prst_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_0_prst != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_0_prst_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_0_coarse_dly != "0 ps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_0_coarse_dly_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_0_fine_dly != "0 ps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_0_fine_dly_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c1_pllcout_enable != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c1_pllcout_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_1 != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_1_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_1_min_tco_enable != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_1_min_tco_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_1_in_src != "m_cnt_in_src_test_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_1_in_src_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_1_ph_mux_prst != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_1_ph_mux_prst_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_1_prst != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_1_prst_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_1_coarse_dly != "0 ps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_1_coarse_dly_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_1_fine_dly != "0 ps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_1_fine_dly_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c2_pllcout_enable != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c2_pllcout_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_2 != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_2_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_2_min_tco_enable != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_2_min_tco_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_2_in_src != "m_cnt_in_src_test_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_2_in_src_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_2_ph_mux_prst != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_2_ph_mux_prst_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_2_prst != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_2_prst_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_2_coarse_dly != "0 ps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_2_coarse_dly_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_2_fine_dly != "0 ps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_2_fine_dly_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c3_pllcout_enable != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c3_pllcout_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_3 != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_3_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_3_min_tco_enable != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_3_min_tco_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_3_in_src != "m_cnt_in_src_test_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_3_in_src_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_3_ph_mux_prst != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_3_ph_mux_prst_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_3_prst != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_3_prst_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_3_coarse_dly != "0 ps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_3_coarse_dly_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_c_counter_3_fine_dly != "0 ps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_c_counter_3_fine_dly_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_atb != "atb_selectdisable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_atb_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_fbclk_mux_1 != "pll_fbclk_mux_1_glb")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_fbclk_mux_1_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_fbclk_mux_2 != "pll_fbclk_mux_2_m_cnt")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_fbclk_mux_2_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_iqclk_mux_sel != "power_down")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_iqclk_mux_sel_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_cp_compensation != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_cp_compensation_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_cp_current_setting != "cp_current_setting26")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_cp_current_setting_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_cp_testmode != "cp_normal")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_cp_testmode_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_cp_lf_3rd_pole_freq != "lf_3rd_pole_setting0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_cp_lf_3rd_pole_freq_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_lf_cbig != "lf_cbig_setting4")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_lf_cbig_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_cp_lf_order != "lf_2nd_order")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_cp_lf_order_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_lf_resistance != "lf_res_setting1")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_lf_resistance_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_lf_ripplecap != "lf_no_ripple")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_lf_ripplecap_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_ph0_en != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_ph0_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_ph0_value != "pll_vco_ph0_vss")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_ph0_value_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_ph1_en != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_ph1_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_ph1_value != "pll_vco_ph1_vss")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_ph1_value_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_ph2_en != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_ph2_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_ph2_value != "pll_vco_ph2_vss")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_ph2_value_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_ph3_en != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_ph3_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_ph3_value != "pll_vco_ph3_vss")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_ph3_value_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_dsm_mode != "dsm_mode_integer")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_dsm_mode_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_dsm_out_sel != "pll_dsm_disable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_dsm_out_sel_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_dsm_ecn_bypass != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_dsm_ecn_bypass_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_dsm_ecn_test_en != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_dsm_ecn_test_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_dsm_fractional_division != "1")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_dsm_fractional_division_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_dsm_fractional_value_ready != "pll_k_ready")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_dsm_fractional_value_ready_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_l_counter_bypass != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_l_counter_bypass_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_l_counter != 2)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_l_counter_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_l_counter_enable != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_l_counter_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_lock_fltr_cfg != 25)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_lock_fltr_cfg_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_lock_fltr_test != "pll_lock_fltr_nrm")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_lock_fltr_test_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_unlock_fltr_cfg != 2)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_unlock_fltr_cfg_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_m_counter != 50)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_m_counter_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_m_counter_min_tco_enable != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_m_counter_min_tco_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_m_counter_in_src != "m_cnt_in_src_ph_mux_clk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_m_counter_in_src_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_n_counter != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_n_counter_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_tclk_mux_en != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_tclk_mux_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_tclk_sel != "pll_tclk_m_src")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_tclk_sel_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_dprio_base_addr != 256)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_dprio_base_addr_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_dprio_broadcast_en != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_dprio_broadcast_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_dprio_cvp_inter_sel != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_dprio_cvp_inter_sel_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_dprio_force_inter_sel != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_dprio_force_inter_sel_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_dprio_power_iso_en != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_dprio_power_iso_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_dprio_status_select != "dprio_normal_status")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_dprio_status_select_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_extra_csr != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_extra_csr_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_nreset_invert != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_nreset_invert_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_ctrl_override_setting != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_ctrl_override_setting_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_enable != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_test_enable != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_test_enable_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_ctrl_plniotri_override != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_ctrl_plniotri_override_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vccr_pd_en != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vccr_pd_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_bw_sel != "high")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_bw_sel_check ( .error(1'b1) );
		end
		if (cmu_fpll_compensation_mode != "direct")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_compensation_mode_check ( .error(1'b1) );
		end
		if (cmu_fpll_duty_cycle_0 != 50)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_duty_cycle_0_check ( .error(1'b1) );
		end
		if (cmu_fpll_duty_cycle_1 != 50)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_duty_cycle_1_check ( .error(1'b1) );
		end
		if (cmu_fpll_duty_cycle_2 != 50)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_duty_cycle_2_check ( .error(1'b1) );
		end
		if (cmu_fpll_duty_cycle_3 != 50)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_duty_cycle_3_check ( .error(1'b1) );
		end
		if (cmu_fpll_hssi_output_clock_frequency != "2500.0 MHz")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_hssi_output_clock_frequency_check ( .error(1'b1) );
		end
		if (cmu_fpll_is_cascaded_pll != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_is_cascaded_pll_check ( .error(1'b1) );
		end
		if (cmu_fpll_output_clock_frequency_0 != "500 MHz")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_output_clock_frequency_0_check ( .error(1'b1) );
		end
		if (cmu_fpll_output_clock_frequency_1 != "0 ps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_output_clock_frequency_1_check ( .error(1'b1) );
		end
		if (cmu_fpll_output_clock_frequency_2 != "0 ps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_output_clock_frequency_2_check ( .error(1'b1) );
		end
		if (cmu_fpll_output_clock_frequency_3 != "0 ps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_output_clock_frequency_3_check ( .error(1'b1) );
		end
		if (cmu_fpll_phase_shift_0 != "0 ps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_phase_shift_0_check ( .error(1'b1) );
		end
		if (cmu_fpll_phase_shift_1 != "0 ps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_phase_shift_1_check ( .error(1'b1) );
		end
		if (cmu_fpll_phase_shift_2 != "0 ps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_phase_shift_2_check ( .error(1'b1) );
		end
		if (cmu_fpll_phase_shift_3 != "0 ps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_phase_shift_3_check ( .error(1'b1) );
		end
		if (cmu_fpll_reference_clock_frequency != "100.0 MHz")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_reference_clock_frequency_check ( .error(1'b1) );
		end
		if (cmu_fpll_vco_frequency != "10000.0 MHz")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_vco_frequency_check ( .error(1'b1) );
		end
		if (cmu_fpll_cgb_div != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_cgb_div_check ( .error(1'b1) );
		end
		if (cmu_fpll_pma_width != 10)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pma_width_check ( .error(1'b1) );
		end
		if (cmu_fpll_f_out_c3_hz != "0 hz")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_f_out_c3_hz_check ( .error(1'b1) );
		end
		if (cmu_fpll_f_out_c1_hz != "0 hz")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_f_out_c1_hz_check ( .error(1'b1) );
		end
		if (cmu_fpll_f_out_c0_hz != "0 hz")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_f_out_c0_hz_check ( .error(1'b1) );
		end
		if (cmu_fpll_f_out_c2_hz != "0 hz")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_f_out_c2_hz_check ( .error(1'b1) );
		end
		if (cmu_fpll_f_out_c3 != "000000000000000000000000000000000000")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_f_out_c3_check ( .error(1'b1) );
		end
		if (cmu_fpll_f_out_c1 != "000000000000000000000000000000000000")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_f_out_c1_check ( .error(1'b1) );
		end
		if (cmu_fpll_f_out_c0 != "000000011101110011010110010100000000")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_f_out_c0_check ( .error(1'b1) );
		end
		if (cmu_fpll_f_out_c2 != "000000000000000000000000000000000000")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_f_out_c2_check ( .error(1'b1) );
		end
		if (cmu_fpll_initial_settings != "true")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_initial_settings_check ( .error(1'b1) );
		end
		if (cmu_fpll_m_counter_c2 != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_m_counter_c2_check ( .error(1'b1) );
		end
		if (cmu_fpll_m_counter_c3 != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_m_counter_c3_check ( .error(1'b1) );
		end
		if (cmu_fpll_m_counter_c0 != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_m_counter_c0_check ( .error(1'b1) );
		end
		if (cmu_fpll_m_counter_c1 != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_m_counter_c1_check ( .error(1'b1) );
		end
		if (cmu_fpll_pfd_freq != "000000000101111101011110000100000000")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pfd_freq_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_freq_band_0_fix_high != "pll_vco_freq_band_0_fix_high_0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_freq_band_0_fix_high_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_freq_band_1_fix_high != "pll_vco_freq_band_1_fix_high_0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_freq_band_1_fix_high_check ( .error(1'b1) );
		end
		if (cmu_fpll_xpm_cmu_fpll_core_cal_vco_count_length != "sel_8b_count")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_xpm_cmu_fpll_core_cal_vco_count_length_check ( .error(1'b1) );
		end
		if (cmu_fpll_xpm_cmu_fpll_core_pfd_pulse_width != "pulse_width_setting0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_xpm_cmu_fpll_core_pfd_pulse_width_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_freq_band_1_dyn_high_bits != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_freq_band_1_dyn_high_bits_check ( .error(1'b1) );
		end
		if (cmu_fpll_set_fpll_input_freq_range != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_set_fpll_input_freq_range_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_freq_band_0_fix != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_freq_band_0_fix_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_freq_band_0_dyn_high_bits != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_freq_band_0_dyn_high_bits_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_freq_band_1_fix != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_freq_band_1_fix_check ( .error(1'b1) );
		end
		if (cmu_fpll_xpm_cmu_fpll_core_xpm_cpvco_fpll_xpm_chgpmplf_fpll_cp_current_boost != "normal_setting")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_xpm_cmu_fpll_core_xpm_cpvco_fpll_xpm_chgpmplf_fpll_cp_current_boost_check ( .error(1'b1) );
		end
		if (cmu_fpll_xpm_cmu_fpll_core_fpll_refclk_source != "normal_refclk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_xpm_cmu_fpll_core_fpll_refclk_source_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_freq_band_0_dyn_low_bits != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_freq_band_0_dyn_low_bits_check ( .error(1'b1) );
		end
		if (cmu_fpll_xpm_cmu_fpll_core_pfd_delay_compensation != "normal_delay")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_xpm_cmu_fpll_core_pfd_delay_compensation_check ( .error(1'b1) );
		end
		if (cmu_fpll_pll_vco_freq_band_1_dyn_low_bits != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_pll_vco_freq_band_1_dyn_low_bits_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_pll_clk_sel_override != "normal")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_pll_clk_sel_override_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_pll_clk_sel_override_value != "select_clk0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_pll_clk_sel_override_value_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_pll_auto_clk_sw_en != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_pll_auto_clk_sw_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_pll_clk_loss_edge != "pll_clk_loss_both_edges")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_pll_clk_loss_edge_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_pll_clk_loss_sw_en != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_pll_clk_loss_sw_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_pll_clk_sw_dly != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_pll_clk_sw_dly_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_pll_manu_clk_sw_en != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_pll_manu_clk_sw_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_pll_sw_refclk_src != "pll_sw_refclk_src_clk_0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_pll_sw_refclk_src_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_silicon_rev != "20nm5es")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_silicon_rev_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_refclk_select0 != "lvpecl")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_refclk_select0_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_refclk_select1 != "ref_iqclk0")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_refclk_select1_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_mux0_inclk0_logical_to_physical_mapping != "lvpecl")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_mux0_inclk0_logical_to_physical_mapping_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_mux0_inclk1_logical_to_physical_mapping != "power_down")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_mux0_inclk1_logical_to_physical_mapping_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_mux0_inclk2_logical_to_physical_mapping != "power_down")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_mux0_inclk2_logical_to_physical_mapping_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_mux0_inclk3_logical_to_physical_mapping != "power_down")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_mux0_inclk3_logical_to_physical_mapping_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_mux0_inclk4_logical_to_physical_mapping != "power_down")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_mux0_inclk4_logical_to_physical_mapping_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_mux1_inclk0_logical_to_physical_mapping != "lvpecl")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_mux1_inclk0_logical_to_physical_mapping_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_mux1_inclk1_logical_to_physical_mapping != "power_down")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_mux1_inclk1_logical_to_physical_mapping_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_mux1_inclk2_logical_to_physical_mapping != "power_down")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_mux1_inclk2_logical_to_physical_mapping_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_mux1_inclk3_logical_to_physical_mapping != "power_down")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_mux1_inclk3_logical_to_physical_mapping_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_select_mux_mux1_inclk4_logical_to_physical_mapping != "power_down")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_select_mux_mux1_inclk4_logical_to_physical_mapping_check ( .error(1'b1) );
		end
		if (enable_analog_resets != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					enable_analog_resets_check ( .error(1'b1) );
		end
		if (hip_cal_en != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hip_cal_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_reconfig_en != "1")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_reconfig_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_dps_en != "false")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_dps_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_calibration_en != "enable")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_calibration_en_check ( .error(1'b1) );
		end
		if (cmu_fpll_refclk_freq != "000000000101111101011110000100000000")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					cmu_fpll_refclk_freq_check ( .error(1'b1) );
		end
		if (enable_mcgb != 1)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					enable_mcgb_check ( .error(1'b1) );
		end
		if (enable_mcgb_debug_ports_parameters != 0)
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					enable_mcgb_debug_ports_parameters_check ( .error(1'b1) );
		end
		if (hssi_pma_cgb_master_prot_mode != "pcie_gen2_tx")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pma_cgb_master_prot_mode_check ( .error(1'b1) );
		end
		if (hssi_pma_cgb_master_silicon_rev != "20nm5")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pma_cgb_master_silicon_rev_check ( .error(1'b1) );
		end
		if (hssi_pma_cgb_master_x1_div_m_sel != "divbypass")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pma_cgb_master_x1_div_m_sel_check ( .error(1'b1) );
		end
		if (hssi_pma_cgb_master_cgb_enable_iqtxrxclk != "disable_iqtxrxclk")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pma_cgb_master_cgb_enable_iqtxrxclk_check ( .error(1'b1) );
		end
		if (hssi_pma_cgb_master_ser_mode != "ten_bit")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pma_cgb_master_ser_mode_check ( .error(1'b1) );
		end
		if (hssi_pma_cgb_master_datarate != "5000000000 bps")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pma_cgb_master_datarate_check ( .error(1'b1) );
		end
		if (hssi_pma_cgb_master_cgb_power_down != "normal_cgb")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pma_cgb_master_cgb_power_down_check ( .error(1'b1) );
		end
		if (hssi_pma_cgb_master_observe_cgb_clocks != "observe_nothing")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pma_cgb_master_observe_cgb_clocks_check ( .error(1'b1) );
		end
		if (hssi_pma_cgb_master_op_mode != "enabled")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pma_cgb_master_op_mode_check ( .error(1'b1) );
		end
		if (hssi_pma_cgb_master_tx_ucontrol_reset_pcie != "pcscorehip_controls_mcgb")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pma_cgb_master_tx_ucontrol_reset_pcie_check ( .error(1'b1) );
		end
		if (hssi_pma_cgb_master_vccdreg_output != "vccdreg_nominal")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pma_cgb_master_vccdreg_output_check ( .error(1'b1) );
		end
		if (hssi_pma_cgb_master_input_select != "fpll_top")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pma_cgb_master_input_select_check ( .error(1'b1) );
		end
		if (hssi_pma_cgb_master_input_select_gen3 != "unused")
		begin
			initial begin
				$display("Generated module instantiated with wrong parameters");
				$stop;
			end
			instantiated_with_wrong_parameters_error_see_comment_above
					hssi_pma_cgb_master_input_select_gen3_check ( .error(1'b1) );
		end
	endgenerate

	altera_xcvr_fpll_a10 #(
		.enable_pll_reconfig                                                          (1),
		.rcfg_jtag_enable                                                             (0),
		.rcfg_separate_avmm_busy                                                      (0),
		.dbg_embedded_debug_enable                                                    (0),
		.dbg_capability_reg_enable                                                    (0),
		.dbg_user_identifier                                                          (0),
		.dbg_stat_soft_logic_enable                                                   (0),
		.dbg_ctrl_soft_logic_enable                                                   (0),
		.cmu_fpll_silicon_rev                                                         ("20nm5"),
		.cmu_fpll_is_otn                                                              ("false"),
		.cmu_fpll_is_sdi                                                              ("false"),
		.cmu_fpll_f_max_vco                                                           ("12500000000"),
		.cmu_fpll_f_min_vco                                                           ("6000000000"),
		.cmu_fpll_feedback                                                            ("normal"),
		.cmu_fpll_fpll_cas_out_enable                                                 ("fpll_cas_out_disable"),
		.cmu_fpll_fpll_hclk_out_enable                                                ("fpll_hclk_out_enable"),
		.cmu_fpll_fpll_iqtxrxclk_out_enable                                           ("fpll_iqtxrxclk_out_disable"),
		.cmu_fpll_l_counter                                                           (2),
		.cmu_fpll_m_counter                                                           (50),
		.cmu_fpll_n_counter                                                           (1),
		.cmu_fpll_out_freq_hz                                                         ("0 hz"),
		.cmu_fpll_out_freq                                                            ("000010010101000000101111100100000000"),
		.cmu_fpll_pll_vco_freq_band_0                                                 ("pll_freq_band0"),
		.cmu_fpll_pll_vco_freq_band_1                                                 ("pll_freq_band0_1"),
		.cmu_fpll_primary_use                                                         ("tx"),
		.cmu_fpll_prot_mode                                                           ("pcie_gen2_tx"),
		.cmu_fpll_reference_clock_frequency_scratch                                   ("0 hz"),
		.cmu_fpll_side                                                                ("side_unknown"),
		.cmu_fpll_top_or_bottom                                                       ("tb_unknown"),
		.cmu_fpll_vco_freq_hz                                                         ("10000000000"),
		.cmu_fpll_vco_freq                                                            ("001001010100000010111110010000000000"),
		.cmu_fpll_pll_bw_mode                                                         ("hi_bw"),
		.cmu_fpll_datarate                                                            ("5000000000 bps"),
		.cmu_fpll_pll_cmu_rstn_value                                                  ("true"),
		.cmu_fpll_pll_lpf_rstn_value                                                  ("lpf_normal"),
		.cmu_fpll_pll_ppm_clk0_src                                                    ("ppm_clk0_vss"),
		.cmu_fpll_pll_ppm_clk1_src                                                    ("ppm_clk1_vss"),
		.cmu_fpll_pll_rstn_override                                                   ("false"),
		.cmu_fpll_pll_op_mode                                                         ("false"),
		.cmu_fpll_pll_optimal                                                         ("true"),
		.cmu_fpll_is_pa_core                                                          ("false"),
		.cmu_fpll_pll_powerdown_mode                                                  ("false"),
		.cmu_fpll_pll_sup_mode                                                        ("user_mode"),
		.cmu_fpll_pll_c0_pllcout_enable                                               ("true"),
		.cmu_fpll_pll_c_counter_0                                                     (5),
		.cmu_fpll_pll_c_counter_0_min_tco_enable                                      ("false"),
		.cmu_fpll_pll_c_counter_0_in_src                                              ("m_cnt_in_src_ph_mux_clk"),
		.cmu_fpll_pll_c_counter_0_ph_mux_prst                                         (0),
		.cmu_fpll_pll_c_counter_0_prst                                                (1),
		.cmu_fpll_pll_c_counter_0_coarse_dly                                          ("0 ps"),
		.cmu_fpll_pll_c_counter_0_fine_dly                                            ("0 ps"),
		.cmu_fpll_pll_c1_pllcout_enable                                               ("false"),
		.cmu_fpll_pll_c_counter_1                                                     (1),
		.cmu_fpll_pll_c_counter_1_min_tco_enable                                      ("false"),
		.cmu_fpll_pll_c_counter_1_in_src                                              ("m_cnt_in_src_test_clk"),
		.cmu_fpll_pll_c_counter_1_ph_mux_prst                                         (0),
		.cmu_fpll_pll_c_counter_1_prst                                                (1),
		.cmu_fpll_pll_c_counter_1_coarse_dly                                          ("0 ps"),
		.cmu_fpll_pll_c_counter_1_fine_dly                                            ("0 ps"),
		.cmu_fpll_pll_c2_pllcout_enable                                               ("false"),
		.cmu_fpll_pll_c_counter_2                                                     (1),
		.cmu_fpll_pll_c_counter_2_min_tco_enable                                      ("false"),
		.cmu_fpll_pll_c_counter_2_in_src                                              ("m_cnt_in_src_test_clk"),
		.cmu_fpll_pll_c_counter_2_ph_mux_prst                                         (0),
		.cmu_fpll_pll_c_counter_2_prst                                                (1),
		.cmu_fpll_pll_c_counter_2_coarse_dly                                          ("0 ps"),
		.cmu_fpll_pll_c_counter_2_fine_dly                                            ("0 ps"),
		.cmu_fpll_pll_c3_pllcout_enable                                               ("false"),
		.cmu_fpll_pll_c_counter_3                                                     (1),
		.cmu_fpll_pll_c_counter_3_min_tco_enable                                      ("false"),
		.cmu_fpll_pll_c_counter_3_in_src                                              ("m_cnt_in_src_test_clk"),
		.cmu_fpll_pll_c_counter_3_ph_mux_prst                                         (0),
		.cmu_fpll_pll_c_counter_3_prst                                                (1),
		.cmu_fpll_pll_c_counter_3_coarse_dly                                          ("0 ps"),
		.cmu_fpll_pll_c_counter_3_fine_dly                                            ("0 ps"),
		.cmu_fpll_pll_atb                                                             ("atb_selectdisable"),
		.cmu_fpll_pll_fbclk_mux_1                                                     ("pll_fbclk_mux_1_glb"),
		.cmu_fpll_pll_fbclk_mux_2                                                     ("pll_fbclk_mux_2_m_cnt"),
		.cmu_fpll_pll_iqclk_mux_sel                                                   ("power_down"),
		.cmu_fpll_pll_cp_compensation                                                 ("true"),
		.cmu_fpll_pll_cp_current_setting                                              ("cp_current_setting26"),
		.cmu_fpll_pll_cp_testmode                                                     ("cp_normal"),
		.cmu_fpll_pll_cp_lf_3rd_pole_freq                                             ("lf_3rd_pole_setting0"),
		.cmu_fpll_pll_lf_cbig                                                         ("lf_cbig_setting4"),
		.cmu_fpll_pll_cp_lf_order                                                     ("lf_2nd_order"),
		.cmu_fpll_pll_lf_resistance                                                   ("lf_res_setting1"),
		.cmu_fpll_pll_lf_ripplecap                                                    ("lf_no_ripple"),
		.cmu_fpll_pll_vco_ph0_en                                                      ("true"),
		.cmu_fpll_pll_vco_ph0_value                                                   ("pll_vco_ph0_vss"),
		.cmu_fpll_pll_vco_ph1_en                                                      ("false"),
		.cmu_fpll_pll_vco_ph1_value                                                   ("pll_vco_ph1_vss"),
		.cmu_fpll_pll_vco_ph2_en                                                      ("false"),
		.cmu_fpll_pll_vco_ph2_value                                                   ("pll_vco_ph2_vss"),
		.cmu_fpll_pll_vco_ph3_en                                                      ("false"),
		.cmu_fpll_pll_vco_ph3_value                                                   ("pll_vco_ph3_vss"),
		.cmu_fpll_pll_dsm_mode                                                        ("dsm_mode_integer"),
		.cmu_fpll_pll_dsm_out_sel                                                     ("pll_dsm_disable"),
		.cmu_fpll_pll_dsm_ecn_bypass                                                  ("false"),
		.cmu_fpll_pll_dsm_ecn_test_en                                                 ("false"),
		.cmu_fpll_pll_dsm_fractional_division                                         ("1"),
		.cmu_fpll_pll_dsm_fractional_value_ready                                      ("pll_k_ready"),
		.cmu_fpll_pll_l_counter_bypass                                                ("false"),
		.cmu_fpll_pll_l_counter                                                       (2),
		.cmu_fpll_pll_l_counter_enable                                                ("true"),
		.cmu_fpll_pll_lock_fltr_cfg                                                   (25),
		.cmu_fpll_pll_lock_fltr_test                                                  ("pll_lock_fltr_nrm"),
		.cmu_fpll_pll_unlock_fltr_cfg                                                 (2),
		.cmu_fpll_pll_m_counter                                                       (50),
		.cmu_fpll_pll_m_counter_min_tco_enable                                        ("false"),
		.cmu_fpll_pll_m_counter_in_src                                                ("m_cnt_in_src_ph_mux_clk"),
		.cmu_fpll_pll_n_counter                                                       (1),
		.cmu_fpll_pll_tclk_mux_en                                                     ("false"),
		.cmu_fpll_pll_tclk_sel                                                        ("pll_tclk_m_src"),
		.cmu_fpll_pll_dprio_base_addr                                                 (256),
		.cmu_fpll_pll_dprio_broadcast_en                                              ("false"),
		.cmu_fpll_pll_dprio_cvp_inter_sel                                             ("false"),
		.cmu_fpll_pll_dprio_force_inter_sel                                           ("false"),
		.cmu_fpll_pll_dprio_power_iso_en                                              ("false"),
		.cmu_fpll_pll_dprio_status_select                                             ("dprio_normal_status"),
		.cmu_fpll_pll_extra_csr                                                       (0),
		.cmu_fpll_pll_nreset_invert                                                   ("false"),
		.cmu_fpll_pll_ctrl_override_setting                                           ("true"),
		.cmu_fpll_pll_enable                                                          ("true"),
		.cmu_fpll_pll_test_enable                                                     ("false"),
		.cmu_fpll_pll_ctrl_plniotri_override                                          ("false"),
		.cmu_fpll_pll_vccr_pd_en                                                      ("true"),
		.cmu_fpll_bw_sel                                                              ("high"),
		.cmu_fpll_compensation_mode                                                   ("direct"),
		.cmu_fpll_duty_cycle_0                                                        (50),
		.cmu_fpll_duty_cycle_1                                                        (50),
		.cmu_fpll_duty_cycle_2                                                        (50),
		.cmu_fpll_duty_cycle_3                                                        (50),
		.cmu_fpll_hssi_output_clock_frequency                                         ("2500.0 MHz"),
		.cmu_fpll_is_cascaded_pll                                                     ("false"),
		.cmu_fpll_output_clock_frequency_0                                            ("500 MHz"),
		.cmu_fpll_output_clock_frequency_1                                            ("0 ps"),
		.cmu_fpll_output_clock_frequency_2                                            ("0 ps"),
		.cmu_fpll_output_clock_frequency_3                                            ("0 ps"),
		.cmu_fpll_phase_shift_0                                                       ("0 ps"),
		.cmu_fpll_phase_shift_1                                                       ("0 ps"),
		.cmu_fpll_phase_shift_2                                                       ("0 ps"),
		.cmu_fpll_phase_shift_3                                                       ("0 ps"),
		.cmu_fpll_reference_clock_frequency                                           ("100.0 MHz"),
		.cmu_fpll_vco_frequency                                                       ("10000.0 MHz"),
		.cmu_fpll_cgb_div                                                             (1),
		.cmu_fpll_pma_width                                                           (10),
		.cmu_fpll_f_out_c3_hz                                                         ("0 hz"),
		.cmu_fpll_f_out_c1_hz                                                         ("0 hz"),
		.cmu_fpll_f_out_c0_hz                                                         ("0 hz"),
		.cmu_fpll_f_out_c2_hz                                                         ("0 hz"),
		.cmu_fpll_f_out_c3                                                            ("000000000000000000000000000000000000"),
		.cmu_fpll_f_out_c1                                                            ("000000000000000000000000000000000000"),
		.cmu_fpll_f_out_c0                                                            ("000000011101110011010110010100000000"),
		.cmu_fpll_f_out_c2                                                            ("000000000000000000000000000000000000"),
		.cmu_fpll_initial_settings                                                    ("true"),
		.cmu_fpll_m_counter_c2                                                        (1),
		.cmu_fpll_m_counter_c3                                                        (1),
		.cmu_fpll_m_counter_c0                                                        (1),
		.cmu_fpll_m_counter_c1                                                        (1),
		.cmu_fpll_pfd_freq                                                            ("000000000101111101011110000100000000"),
		.cmu_fpll_pll_vco_freq_band_0_fix_high                                        ("pll_vco_freq_band_0_fix_high_0"),
		.cmu_fpll_pll_vco_freq_band_1_fix_high                                        ("pll_vco_freq_band_1_fix_high_0"),
		.cmu_fpll_xpm_cmu_fpll_core_cal_vco_count_length                              ("sel_8b_count"),
		.cmu_fpll_xpm_cmu_fpll_core_pfd_pulse_width                                   ("pulse_width_setting0"),
		.cmu_fpll_pll_vco_freq_band_1_dyn_high_bits                                   (0),
		.cmu_fpll_set_fpll_input_freq_range                                           (0),
		.cmu_fpll_pll_vco_freq_band_0_fix                                             (1),
		.cmu_fpll_pll_vco_freq_band_0_dyn_high_bits                                   (0),
		.cmu_fpll_pll_vco_freq_band_1_fix                                             (1),
		.cmu_fpll_xpm_cmu_fpll_core_xpm_cpvco_fpll_xpm_chgpmplf_fpll_cp_current_boost ("normal_setting"),
		.cmu_fpll_xpm_cmu_fpll_core_fpll_refclk_source                                ("normal_refclk"),
		.cmu_fpll_pll_vco_freq_band_0_dyn_low_bits                                    (0),
		.cmu_fpll_xpm_cmu_fpll_core_pfd_delay_compensation                            ("normal_delay"),
		.cmu_fpll_pll_vco_freq_band_1_dyn_low_bits                                    (0),
		.cmu_fpll_refclk_select_mux_pll_clk_sel_override                              ("normal"),
		.cmu_fpll_refclk_select_mux_pll_clk_sel_override_value                        ("select_clk0"),
		.cmu_fpll_refclk_select_mux_pll_auto_clk_sw_en                                ("false"),
		.cmu_fpll_refclk_select_mux_pll_clk_loss_edge                                 ("pll_clk_loss_both_edges"),
		.cmu_fpll_refclk_select_mux_pll_clk_loss_sw_en                                ("false"),
		.cmu_fpll_refclk_select_mux_pll_clk_sw_dly                                    (0),
		.cmu_fpll_refclk_select_mux_pll_manu_clk_sw_en                                ("false"),
		.cmu_fpll_refclk_select_mux_pll_sw_refclk_src                                 ("pll_sw_refclk_src_clk_0"),
		.cmu_fpll_refclk_select_mux_silicon_rev                                       ("20nm5es"),
		.cmu_fpll_refclk_select_mux_refclk_select0                                    ("lvpecl"),
		.cmu_fpll_refclk_select_mux_refclk_select1                                    ("ref_iqclk0"),
		.cmu_fpll_refclk_select_mux_mux0_inclk0_logical_to_physical_mapping           ("lvpecl"),
		.cmu_fpll_refclk_select_mux_mux0_inclk1_logical_to_physical_mapping           ("power_down"),
		.cmu_fpll_refclk_select_mux_mux0_inclk2_logical_to_physical_mapping           ("power_down"),
		.cmu_fpll_refclk_select_mux_mux0_inclk3_logical_to_physical_mapping           ("power_down"),
		.cmu_fpll_refclk_select_mux_mux0_inclk4_logical_to_physical_mapping           ("power_down"),
		.cmu_fpll_refclk_select_mux_mux1_inclk0_logical_to_physical_mapping           ("lvpecl"),
		.cmu_fpll_refclk_select_mux_mux1_inclk1_logical_to_physical_mapping           ("power_down"),
		.cmu_fpll_refclk_select_mux_mux1_inclk2_logical_to_physical_mapping           ("power_down"),
		.cmu_fpll_refclk_select_mux_mux1_inclk3_logical_to_physical_mapping           ("power_down"),
		.cmu_fpll_refclk_select_mux_mux1_inclk4_logical_to_physical_mapping           ("power_down"),
		.enable_analog_resets                                                         (0),
		.hip_cal_en                                                                   ("enable"),
		.cmu_fpll_reconfig_en                                                         ("1"),
		.cmu_fpll_dps_en                                                              ("false"),
		.cmu_fpll_calibration_en                                                      ("enable"),
		.cmu_fpll_refclk_freq                                                         ("000000000101111101011110000100000000"),
		.enable_mcgb                                                                  (1),
		.enable_mcgb_debug_ports_parameters                                           (0),
		.hssi_pma_cgb_master_prot_mode                                                ("pcie_gen2_tx"),
		.hssi_pma_cgb_master_silicon_rev                                              ("20nm5"),
		.hssi_pma_cgb_master_x1_div_m_sel                                             ("divbypass"),
		.hssi_pma_cgb_master_cgb_enable_iqtxrxclk                                     ("disable_iqtxrxclk"),
		.hssi_pma_cgb_master_ser_mode                                                 ("ten_bit"),
		.hssi_pma_cgb_master_datarate                                                 ("5000000000 bps"),
		.hssi_pma_cgb_master_cgb_power_down                                           ("normal_cgb"),
		.hssi_pma_cgb_master_observe_cgb_clocks                                       ("observe_nothing"),
		.hssi_pma_cgb_master_op_mode                                                  ("enabled"),
		.hssi_pma_cgb_master_tx_ucontrol_reset_pcie                                   ("pcscorehip_controls_mcgb"),
		.hssi_pma_cgb_master_vccdreg_output                                           ("vccdreg_nominal"),
		.hssi_pma_cgb_master_input_select                                             ("fpll_top"),
		.hssi_pma_cgb_master_input_select_gen3                                        ("unused")
	) fpll_g1g2xn (
		.pll_refclk0              (pll_refclk0),                          //       pll_refclk0.clk
		.pll_powerdown            (pll_powerdown),                        //     pll_powerdown.pll_powerdown
		.pll_locked               (pll_locked),                           //        pll_locked.pll_locked
		.tx_serial_clk            (tx_serial_clk),                        //     tx_serial_clk.clk
		.pll_pcie_clk             (pll_pcie_clk),                         //      pll_pcie_clk.pll_pcie_clk
		.reconfig_clk0            (reconfig_clk0),                        //     reconfig_clk0.clk
		.reconfig_reset0          (reconfig_reset0),                      //   reconfig_reset0.reset
		.reconfig_write0          (reconfig_write0),                      //    reconfig_avmm0.write
		.reconfig_read0           (reconfig_read0),                       //                  .read
		.reconfig_address0        (reconfig_address0),                    //                  .address
		.reconfig_writedata0      (reconfig_writedata0),                  //                  .writedata
		.reconfig_readdata0       (reconfig_readdata0),                   //                  .readdata
		.reconfig_waitrequest0    (reconfig_waitrequest0),                //                  .waitrequest
		.pll_cal_busy             (pll_cal_busy),                         //      pll_cal_busy.pll_cal_busy
		.hip_cal_done             (hip_cal_done),                         //      hip_cal_done.hip_cal_done
		.mcgb_rst                 (mcgb_rst),                             //          mcgb_rst.mcgb_rst
		.tx_bonding_clocks        (tx_bonding_clocks),                    // tx_bonding_clocks.clk
		.pcie_sw                  (pcie_sw),                              //           pcie_sw.pcie_sw
		.pcie_sw_done             (pcie_sw_done),                         //      pcie_sw_done.pcie_sw_done
		.mcgb_hip_cal_done        (mcgb_hip_cal_done),                    // mcgb_hip_cal_done.hip_cal_done
		.pll_refclk1              (1'b0),                                 //       (terminated)
		.pll_refclk2              (1'b0),                                 //       (terminated)
		.pll_refclk3              (1'b0),                                 //       (terminated)
		.pll_refclk4              (1'b0),                                 //       (terminated)
		.outclk0                  (),                                     //       (terminated)
		.outclk1                  (),                                     //       (terminated)
		.outclk2                  (),                                     //       (terminated)
		.outclk3                  (),                                     //       (terminated)
		.fpll_to_fpll_cascade_clk (),                                     //       (terminated)
		.hssi_pll_cascade_clk     (),                                     //       (terminated)
		.atx_to_fpll_cascade_clk  (1'b0),                                 //       (terminated)
		.avmm_busy0               (),                                     //       (terminated)
		.phase_reset              (1'b0),                                 //       (terminated)
		.phase_en                 (1'b0),                                 //       (terminated)
		.updn                     (1'b0),                                 //       (terminated)
		.cntsel                   (4'b0000),                              //       (terminated)
		.phase_done               (),                                     //       (terminated)
		.extswitch                (1'b0),                                 //       (terminated)
		.activeclk                (),                                     //       (terminated)
		.clkbad                   (),                                     //       (terminated)
		.clklow                   (),                                     //       (terminated)
		.fref                     (),                                     //       (terminated)
		.mcgb_aux_clk0            (1'b0),                                 //       (terminated)
		.mcgb_aux_clk1            (1'b0),                                 //       (terminated)
		.mcgb_aux_clk2            (1'b0),                                 //       (terminated)
		.mcgb_serial_clk          (),                                     //       (terminated)
		.reconfig_clk1            (1'b0),                                 //       (terminated)
		.reconfig_reset1          (1'b0),                                 //       (terminated)
		.reconfig_write1          (1'b0),                                 //       (terminated)
		.reconfig_read1           (1'b0),                                 //       (terminated)
		.reconfig_address1        (10'b0000000000),                       //       (terminated)
		.reconfig_writedata1      (32'b00000000000000000000000000000000), //       (terminated)
		.reconfig_readdata1       (),                                     //       (terminated)
		.reconfig_waitrequest1    (),                                     //       (terminated)
		.mcgb_cal_busy            ()                                      //       (terminated)
	);

endmodule
