module golden_top (
    // Bank 1J FMC HPC XCVR & RefCLK SMA input
    input  wire            HPC_GBTCLK1_M2C          , //
    output wire            HPC_DP9_C2M              , //
    input  wire            HPC_DP9_M2C              , //
    output wire            HPC_DP8_C2M              , //
    input  wire            HPC_DP8_M2C              , //
    output wire            HPC_DP7_C2M              , //
    input  wire            HPC_DP7_M2C              , //
    output wire            HPC_DP6_C2M              , //
    input  wire            HPC_DP6_M2C              , //
    output wire            HPC_DP5_C2M              , //
    input  wire            HPC_DP5_M2C              , //
    output wire            HPC_DP4_C2M              , //
    input  wire            HPC_DP4_M2C              , //
    input  wire            REFCLK_SMA0              , //

    // Bank 1I FMC HPC XCVR
    input  wire            HPC_GBTCLK0_M2C          , //
    output wire            HPC_DP3_C2M              , //
    input  wire            HPC_DP3_M2C              , //
    output wire            HPC_DP2_C2M              , //
    input  wire            HPC_DP2_M2C              , //
    output wire            HPC_DP1_C2M              , //
    input  wire            HPC_DP1_M2C              , //
    output wire            HPC_DP0_C2M              , //
    input  wire            HPC_DP0_M2C              , //

    // Bank 1H XCVR
    input  wire            ETH_GTX_REF_CLK          , // 125MHz U41.OUT2

    // Bank 1E FMC LPC XCVR
    input  wire            REFCLK_3                 , //
    output wire            LPC_DP0_C2M              , //
    input  wire            LPC_DP0_M2C              , //
    input  wire            LPC_GBTCLK0_M2C          , //

    // Bank 1D COMe PCIe
    output wire            COMe_PCIE_TX_3           , //
    input  wire            COMe_PCIE_RX_3           , //
    output wire            COMe_PCIE_TX_2           , //
    input  wire            COMe_PCIE_RX_2           , //

    // Bank 1C COMe PCIe
    input  wire            PCIE_OB_REFCLK           , // 100MHz U41.OUT0
    output wire            COMe_PCIE_TX_1           , //
    input  wire            COMe_PCIE_RX_1           , //
    output wire            COMe_PCIE_TX_0           , //
    input  wire            COMe_PCIE_RX_0           , //
    input  wire            COMe_PCIE_REFCLK         , // COMe PCIe clock


    // Bank 2L FMC HPC GPIO/LVDS port
    inout  wire            HPC_LA31_N               , //
    inout  wire            HPC_LA31_P               , //
    inout  wire            HPC_LA03_N               , //
    inout  wire            HPC_LA03_P               , //
    inout  wire            HPC_LA33_N               , //
    inout  wire            HPC_LA33_P               , //
    inout  wire            HPC_LA02_N               , //
    inout  wire            HPC_LA02_P               , //
    inout  wire            HPC_LA32_N               , //
    inout  wire            HPC_LA32_P               , //
    inout  wire            HPC_LA30_N               , //
    inout  wire            HPC_LA30_P               , //
    inout  wire            HPC_LA04_N               , //
    inout  wire            HPC_LA04_P               , //
    inout  wire            HPC_LA08_N               , //
    inout  wire            HPC_LA08_P               , //
    inout  wire            HPC_LA28_N               , //
    inout  wire            HPC_LA28_P               , //
    inout  wire            HPC_LA25_N               , // CLKOUT
    inout  wire            HPC_LA25_P               , // CLKOUT
    inout  wire            HPC_LA07_N               , //
    inout  wire            HPC_LA07_P               , //
    inout  wire            HPC_CLK1_M2C_N           , // CLK
    inout  wire            HPC_CLK1_M2C_P           , // CLK
    inout  wire            HPC_CLK0_M2C_N           , // CLK
    inout  wire            HPC_CLK0_M2C_P           , // CLK
    inout  wire            HPC_LA15_N               , //
    inout  wire            HPC_LA15_P               , //
    inout  wire            HPC_LA12_N               , // CLKOUT
    inout  wire            HPC_LA12_P               , // CLKOUT
    inout  wire            HPC_LA11_N               , //
    inout  wire            HPC_LA11_P               , //
    inout  wire            HPC_LA22_N               , //
    inout  wire            HPC_LA22_P               , //
    inout  wire            HPC_LA29_N               , //
    inout  wire            HPC_LA29_P               , //
    inout  wire            HPC_LA16_N               , //
    inout  wire            HPC_LA16_P               , //
    inout  wire            HPC_LA20_N               , //
    inout  wire            HPC_LA20_P               , //
    inout  wire            HPC_LA21_N               , //
    inout  wire            HPC_LA21_P               , //
    inout  wire            HPC_LA24_N               , //
    inout  wire            HPC_LA24_P               , //
    inout  wire            HPC_LA19_N               , //
    inout  wire            HPC_LA19_P               , //

    // Bank 2K FMC HPC GPIO/LVDS port
    inout  wire            HPC_HA03_N               , //
    inout  wire            HPC_HA03_P               , //
    inout  wire            HPC_HA07_N               , //
    inout  wire            HPC_HA07_P               , //
    inout  wire            HPC_HB17_N               , //
    inout  wire            HPC_HB17_P               , //
    inout  wire            HPC_HB18_N               , //
    inout  wire            HPC_HB18_P               , //
    inout  wire            HPC_HA02_N               , //
    inout  wire            HPC_HA02_P               , //
    inout  wire            HPC_HB15_N               , //
    inout  wire            HPC_HB15_P               , //
    inout  wire            HPC_HB14_N               , //
    inout  wire            HPC_HB14_P               , //
    inout  wire            HPC_HA10_N               , //
    inout  wire            HPC_HA10_P               , //
    inout  wire            HPC_HA06_N               , //
    inout  wire            HPC_HA06_P               , //
    inout  wire            HPC_HB00_N_CC            , // CLKOUT
    inout  wire            HPC_HB00_P_CC            , // CLKOUT
    inout  wire            HPC_HA11_N               , //
    inout  wire            HPC_HA11_P               , //
    inout  wire            HPC_CLK3_M2C_N           , // CLK
    inout  wire            HPC_CLK3_M2C_P           , // CLK
    inout  wire            HPC_CLK2_M2C_N           , // CLK
    inout  wire            HPC_CLK2_M2C_P           , // CLK
    inout  wire            HPC_HA23_N               , //
    inout  wire            HPC_HA23_P               , //
    inout  wire            HPC_HA17_N_CC            , // CLKOUT
    inout  wire            HPC_HA17_P_CC            , // CLKOUT
    inout  wire            HPC_HA21_N               , //
    inout  wire            HPC_HA21_P               , //
    inout  wire            HPC_HB07_N               , //
    inout  wire            HPC_HB07_P               , //
    inout  wire            HPC_HA14_N               , //
    inout  wire            HPC_HA14_P               , //
    inout  wire            HPC_HB10_N               , //
    inout  wire            HPC_HB10_P               , //
    inout  wire            HPC_HB11_N               , //
    inout  wire            HPC_HB11_P               , //
    inout  wire            HPC_HA22_N               , //
    inout  wire            HPC_HA22_P               , //
    inout  wire            HPC_HA18_N               , //
    inout  wire            HPC_HA18_P               , //
    inout  wire            HPC_HB01_N               , //
    inout  wire            HPC_HB01_P               , //
    inout  wire            HPC_HB06_N               , //
    inout  wire            HPC_HB06_P               , //

    // Bank 2J HDMI ADV7511
    output wire            HDMI_TX_HPD_IO           , //
    input  wire            FP_HDMI_TX_INT           , //
    output wire            USB_UART_RXD             , //
    input  wire            USB_UART_TXD             , //
    output wire            FP_HDMI_TX_RESET_N       , //
    inout  wire            FP_HDMI_TX_SDA           , //
    inout  wire            FP_HDMI_TX_SCL           , //
    output wire            FP_HDMI_TX_HSYNC         , //
    output wire            FP_HDMI_TX_VSYNC         , //
    output wire            FP_HDMI_TX_DE            , //
    output wire [7:0]      FP_HDMI_TX_DR            , //
    output wire            FP_HDMI_TX_CLK           , //
    input  wire            REFCLK_HDMI              , // 148.5MHz U40.OUT3
    output wire [7:0]      FP_HDMI_TX_DG            , //
    output wire [7:0]      FP_HDMI_TX_DB            , //

    // Bank 2I
    input  wire            REFCLK_2                 , // 100MHz U39.OUT2
    input  wire            REFCLK_1                 , // 100MHz U40.OUT0
    input  wire            FP_DONE_RST_N            , // CONF_DONE

    // Bank 2A User IO (DIP Switch /Push Button / LED)
    inout  wire            SI5340B_SDA              , //
    inout  wire            SI5340B_SCL              , //
    input  wire            FP_DIP_SW7               , //
    input  wire            FP_DIP_SW6               , //
    input  wire            FP_DIP_SW5               , //
    input  wire            FP_DIP_SW4               , //
    input  wire            FP_DIP_SW3               , //
    input  wire            FP_DIP_SW2               , //
    input  wire            FP_DIP_SW1               , //
    input  wire            FP_DIP_SW0               , //
    output wire            FP_LED_G3                , //
    output wire            FP_LED_G2                , //
    output wire            FP_LED_G1                , //
    output wire            FP_LED_G0                , //
    input  wire            REFCLK_0                 , // 125MHz U40.OUT2
    output wire            FP_LED_R3                , //
    output wire            FP_LED_R2                , //
    output wire            FP_LED_R1                , //
    output wire            FP_LED_R0                , //
    input  wire            COMe_PCIE_RESETn         , //
    input  wire            FP_PSW0                  , //
    input  wire            FP_PSW1                  , //
    input  wire            FP_PSW2                  , //
    input  wire            FP_PSW3                  , //

    // Bank 3H FMC HPC GPIO/LVDS
    inout  wire            HPC_LA09_N               , //
    inout  wire            HPC_LA09_P               , //
    inout  wire            HPC_LA06_N               , //
    inout  wire            HPC_LA06_P               , //
    inout  wire            HPC_LA05_N               , //
    inout  wire            HPC_LA05_P               , //
    inout  wire            HPC_LA10_N               , //
    inout  wire            HPC_LA10_P               , //
    inout  wire            HPC_LA14_N               , // CLKOUT
    inout  wire            HPC_LA14_P               , // CLKOUT
    inout  wire            HPC_LA17_N               , //
    inout  wire            HPC_LA17_P               , //
    inout  wire            HPC_LA01_N_CC            , // CLK
    inout  wire            HPC_LA01_P_CC            , // CLK
    inout  wire            HPC_LA00_N_CC            , // CLK
    inout  wire            HPC_LA00_P_CC            , // CLK
    inout  wire            HPC_LA13_N               , //
    inout  wire            HPC_LA13_P               , //
    inout  wire            HPC_LA26_N               , // CLKOUT
    inout  wire            HPC_LA26_P               , // CLKOUT
    inout  wire            HPC_LA23_N               , //
    inout  wire            HPC_LA23_P               , //
    inout  wire            HPC_LA27_N               , //
    inout  wire            HPC_LA27_P               , //
    inout  wire            HPC_LA18_N               , //
    inout  wire            HPC_LA18_P               , //
    inout  wire            HPC_SCL                  , //
    inout  wire            HPC_SDA                  , //
    output wire            HPC_GA0                  , //
    output wire            HPC_GA1                  , //

    // Bank 3G FMC HPC GPIO/LVDS
    inout  wire            HPC_HA15_N               , //
    inout  wire            HPC_HA15_P               , //
    inout  wire            HPC_HB05_N               , //
    inout  wire            HPC_HB05_P               , //
    inout  wire            HPC_HB03_N               , //
    inout  wire            HPC_HB03_P               , //
    inout  wire            HPC_HB09_N               , //
    inout  wire            HPC_HB09_P               , //
    inout  wire            HPC_HB20_N               , //
    inout  wire            HPC_HB20_P               , //
    inout  wire            HPC_HB12_N               , //
    inout  wire            HPC_HB12_P               , //
    inout  wire            HPC_HB19_N               , //
    inout  wire            HPC_HB19_P               , //
    inout  wire            HPC_HB16_N               , //
    inout  wire            HPC_HB16_P               , //
    inout  wire            HPC_HB02_N               , //
    inout  wire            HPC_HB02_P               , //
    inout  wire            HPC_HB04_N               , // CLKOUT
    inout  wire            HPC_HB04_P               , // CLKOUT
    inout  wire            HPC_HB08_N               , //
    inout  wire            HPC_HB08_P               , //
    inout  wire            HPC_HA01_N_CC            , // CLK
    inout  wire            HPC_HA01_P_CC            , // CLK
    inout  wire            HPC_HA00_N_CC            , // CLK
    inout  wire            HPC_HA00_P_CC            , // CLK
    inout  wire            HPC_HA16_N               , //
    inout  wire            HPC_HA16_P               , //
    inout  wire            HPC_HA20_N               , // CLKOUT
    inout  wire            HPC_HA20_P               , // CLKOUT
    inout  wire            HPC_HB13_N               , //
    inout  wire            HPC_HB13_P               , //
    inout  wire            HPC_HA19_N               , //
    inout  wire            HPC_HA19_P               , //
    inout  wire            HPC_HB21_N               , //
    inout  wire            HPC_HB21_P               , //
    inout  wire            HPC_HA13_N               , //
    inout  wire            HPC_HA13_P               , //
    inout  wire            HPC_HA08_N               , //
    inout  wire            HPC_HA08_P               , //
    inout  wire            HPC_HA05_N               , //
    inout  wire            HPC_HA05_P               , //
    inout  wire            HPC_HA09_N               , //
    inout  wire            HPC_HA09_P               , //
    inout  wire            HPC_HA12_N               , //
    inout  wire            HPC_HA12_P               , //
    inout  wire            HPC_HA04_N               , //
    inout  wire            HPC_HA04_P               , //

    // Bank 3B FMC LPC GPIO/LVDS
    inout  wire            LPC_LA33_N               , //
    inout  wire            LPC_LA33_P               , //
    inout  wire            LPC_LA32_N               , //
    inout  wire            LPC_LA32_P               , //
    inout  wire            LPC_LA31_N               , //
    inout  wire            LPC_LA31_P               , //
    inout  wire            LPC_LA30_N               , //
    inout  wire            LPC_LA30_P               , //
    inout  wire            LPC_LA29_N               , //
    inout  wire            LPC_LA29_P               , //
    inout  wire            LPC_LA28_N               , //
    inout  wire            LPC_LA28_P               , //
    inout  wire            LPC_LA25_N               , //
    inout  wire            LPC_LA25_P               , //
    inout  wire            LPC_LA24_N               , //
    inout  wire            LPC_LA24_P               , //
    inout  wire            LPC_LA22_N               , //
    inout  wire            LPC_LA22_P               , //
    inout  wire            LPC_LA21_N               , // CLKOUT
    inout  wire            LPC_LA21_P               , // CLKOUT
    inout  wire            LPC_LA20_N               , //
    inout  wire            LPC_LA20_P               , //
    inout  wire            LPC_CLK1_M2C_N           , // CLK
    inout  wire            LPC_CLK1_M2C_P           , // CLK
    inout  wire            LPC_CLK0_M2C_N           , // CLK
    inout  wire            LPC_CLK0_M2C_P           , // CLK
    inout  wire            LPC_LA19_N               , //
    inout  wire            LPC_LA19_P               , //
    inout  wire            LPC_LA16_N               , // CLKOUT
    inout  wire            LPC_LA16_P               , // CLKOUT
    inout  wire            LPC_LA15_N               , //
    inout  wire            LPC_LA15_P               , //
    inout  wire            LPC_LA12_N               , //
    inout  wire            LPC_LA12_P               , //
    inout  wire            LPC_LA11_N               , //
    inout  wire            LPC_LA11_P               , //
    inout  wire            LPC_LA09_N               , //
    inout  wire            LPC_LA09_P               , //
    inout  wire            LPC_LA08_N               , //
    inout  wire            LPC_LA08_P               , //
    inout  wire            LPC_LA07_N               , //
    inout  wire            LPC_LA07_P               , //
    inout  wire            LPC_LA04_N               , //
    inout  wire            LPC_LA04_P               , //
    inout  wire            LPC_LA03_N               , //
    inout  wire            LPC_LA03_P               , //
    inout  wire            LPC_LA02_N               , //
    inout  wire            LPC_LA02_P               , //

    // Bank 3A LPC GPIO/LVDS
    inout  wire            LPC_LA27_N               , //
    inout  wire            LPC_LA27_P               , //
    inout  wire            LPC_LA26_N               , //
    inout  wire            LPC_LA26_P               , //
    inout  wire            LPC_LA23_N               , //
    inout  wire            LPC_LA23_P               , //
    inout  wire            LPC_LA14_N               , //
    inout  wire            LPC_LA14_P               , //
    inout  wire            LPC_LA13_N               , //
    inout  wire            LPC_LA13_P               , //
    inout  wire            LPC_LA10_N               , //
    inout  wire            LPC_LA10_P               , //
    inout  wire            LPC_LA05_N               , //
    inout  wire            LPC_LA05_P               , //
    inout  wire            LPC_LA06_N               , //
    inout  wire            LPC_LA06_P               , //
    inout  wire            LPC_LA18_N_CC            , // CLKOUT
    inout  wire            LPC_LA18_P_CC            , // CLKOUT
    inout  wire            LPC_LA01_N_CC            , // CLK
    inout  wire            LPC_LA01_P_CC            , // CLK
    inout  wire            LPC_LA00_N_CC            , // CLK
    inout  wire            LPC_LA00_P_CC            , // CLK
    inout  wire            LPC_LA17_N_CC            , // CLKOUT
    inout  wire            LPC_LA17_P_CC            , // CLKOUT
    inout  wire            LPC_SDA                  , //
    inout  wire            LPC_SCL                  , //
    output wire            LPC_GA0                  , //
    output wire            LPC_GA1                  , //

    // Bank 3E,3F DDR4_0
    output wire            DDR4_MEM0_CK             , // emif_0_mem_mem_ck
    output wire            DDR4_MEM0_CK_N           , // emif_0_mem_mem_ck_n
    output wire [16:0]     DDR4_MEM0_A              , // emif_0_mem_mem_a
    output wire            DDR4_MEM0_ACT_N          , // emif_0_mem_mem_act_n
    output wire [1:0]      DDR4_MEM0_BA             , // emif_0_mem_mem_ba
    output wire            DDR4_MEM0_BG             , // emif_0_mem_mem_bg
    output wire            DDR4_MEM0_CKE            , // emif_0_mem_mem_cke
    output wire            DDR4_MEM0_CS_N           , // emif_0_mem_mem_cs_n
    output wire            DDR4_MEM0_ODT            , // emif_0_mem_mem_odt
    output wire            DDR4_MEM0_RESET_N        , // emif_0_mem_mem_reset_n
    output wire            DDR4_MEM0_PAR            , // emif_0_mem_mem_par
    input  wire            DDR4_MEM0_ALERT_N        , // emif_0_mem_mem_alert_n
    inout  wire [3:0]      DDR4_MEM0_DQS            , // emif_0_mem_mem_dqs
    inout  wire [3:0]      DDR4_MEM0_DQS_N          , // emif_0_mem_mem_dqs_n
    inout  wire [31:0]     DDR4_MEM0_DQ             , // emif_0_mem_mem_dq
    inout  wire [3:0]      DDR4_MEM0_DBI_N          , // emif_0_mem_mem_dbi_n
    input  wire            DDR4_PLL_REF_CLK0_P      , // emif_0_pll_ref_clk_clk 233.33MHz U39.OUT0/OUT0b
    input  wire            DDR4_MEM0_OCT_RZQIN      , // emif_0_oct_oct_rzqin

    // Bank 3C,3D DDR4_1
    output wire            DDR4_MEM1_CK             , // emif_0_mem_mem_ck
    output wire            DDR4_MEM1_CK_N           , // emif_0_mem_mem_ck_n
    output wire [16:0]     DDR4_MEM1_A              , // emif_0_mem_mem_a
    output wire            DDR4_MEM1_ACT_N          , // emif_0_mem_mem_act_n
    output wire [1:0]      DDR4_MEM1_BA             , // emif_0_mem_mem_ba
    output wire            DDR4_MEM1_BG             , // emif_0_mem_mem_bg
    output wire            DDR4_MEM1_CKE            , // emif_0_mem_mem_cke
    output wire            DDR4_MEM1_CS_N           , // emif_0_mem_mem_cs_n
    output wire            DDR4_MEM1_ODT            , // emif_0_mem_mem_odt
    output wire            DDR4_MEM1_RESET_N        , // emif_0_mem_mem_reset_n
    output wire            DDR4_MEM1_PAR            , // emif_0_mem_mem_par
    input  wire            DDR4_MEM1_ALERT_N        , // emif_0_mem_mem_alert_n
    inout  wire [3:0]      DDR4_MEM1_DQS            , // emif_0_mem_mem_dqs
    inout  wire [3:0]      DDR4_MEM1_DQS_N          , // emif_0_mem_mem_dqs_n
    inout  wire [31:0]     DDR4_MEM1_DQ             , // emif_0_mem_mem_dq
    inout  wire [3:0]      DDR4_MEM1_DBI_N          , // emif_0_mem_mem_dbi_n
    input  wire            DDR4_PLL_REF_CLK1_P      , // emif_0_pll_ref_clk_clk 233.33MHz U39.OUT1/OUT1b
    input  wire            DDR4_MEM1_OCT_RZQIN       // emif_0_oct_oct_rzqin

);

    parameter ch_num = 11;
    parameter tx_pll_num = 3;

    wire                   clk_125m;
    wire                   reset_n;
    wire                   pll_refclk;
    wire  [ch_num-1:0]     rx_serial_data;
    wire  [ch_num-1:0]     tx_serial_data;   	  
    wire  [31:0]           control_reg;
    wire  [tx_pll_num-1:0] tx_serial_clk, pll_locked, pll_powerdown;
    wire  [ch_num-1:0]     xcvr_tx_serial_clk, xcvr_pll_locked;
    wire  [ch_num-1:0]     rx_clkout, tx_clkout;
    wire  [ch_num-1:0]     rx_ready, tx_ready;
    wire  [ch_num-1:0]     rx_enh_data_valid, tx_enh_data_valid;
    wire  [ch_num*64-1:0]  rx_parallel_data, tx_parallel_data;
    wire  [ch_num*8-1:0]   rx_control, tx_control;
    wire  [ch_num-1:0]     rx_seriallpbken;
	 
    wire                   hdmi_reset_n;
    wire                   pll_50m;
    wire                   i2c_mst_scl_oe;
    wire                   i2c_mst_sda_oe;
    //PCI Express Gen2 x4, Avalon-MM 128bit 125MHz
    wire                   coreclkout;
    wire  [3:0]            lane_act;
    wire  [1:0]            currentspeed;
    wire  [4:0]            ltssmstate;
    //User LED Internal
    wire  [3:0]            user_led;
    wire  [7:0]            user_dip_sw;
    wire  [3:0]            user_push_sw;
 
    assign FP_LED_G0 = user_led[0];
    assign FP_LED_G1 = user_led[1];
    assign FP_LED_G2 = user_led[2];
    assign FP_LED_G3 = user_led[3];
 
    assign user_dip_sw[0] = FP_DIP_SW0;
    assign user_dip_sw[1] = FP_DIP_SW1;
    assign user_dip_sw[2] = FP_DIP_SW2;
    assign user_dip_sw[3] = FP_DIP_SW3;
    assign user_dip_sw[4] = FP_DIP_SW4;
    assign user_dip_sw[5] = FP_DIP_SW5;
    assign user_dip_sw[6] = FP_DIP_SW6;
    assign user_dip_sw[7] = FP_DIP_SW7;
 
    assign user_push_sw[0] = FP_PSW0;
    assign user_push_sw[1] = FP_PSW1;
    assign user_push_sw[2] = FP_PSW2;
    assign user_push_sw[3] = FP_PSW3;
	 
    assign clk_125m       = REFCLK_0;   //125MHz, LVDS, termination
    assign reset_n        = FP_PSW0;    //1.8V
    assign pll_refclk     = REFCLK_3;   //270MHz, LVDS, termination
    assign rx_serial_data[0] = HPC_DP0_M2C;
    assign HPC_DP0_C2M =  tx_serial_data[0];	 
    assign rx_serial_data[1] = HPC_DP1_M2C;
    assign HPC_DP1_C2M =  tx_serial_data[1];	 
    assign rx_serial_data[2] = HPC_DP2_M2C;
    assign HPC_DP2_C2M =  tx_serial_data[2];	 
    assign rx_serial_data[3] = HPC_DP3_M2C;
    assign HPC_DP3_C2M =  tx_serial_data[3];	 
    assign rx_serial_data[4] = HPC_DP4_M2C;
    assign HPC_DP4_C2M =  tx_serial_data[4];	 
    assign rx_serial_data[5] = HPC_DP5_M2C;
    assign HPC_DP5_C2M =  tx_serial_data[5];	 
    assign rx_serial_data[6] = HPC_DP6_M2C;
    assign HPC_DP6_C2M =  tx_serial_data[6];	 
    assign rx_serial_data[7] = HPC_DP7_M2C;
    assign HPC_DP7_C2M =  tx_serial_data[7];	 
    assign rx_serial_data[8] = HPC_DP8_M2C;
    assign HPC_DP8_C2M =  tx_serial_data[8];	 
    assign rx_serial_data[9] = HPC_DP9_M2C;
    assign HPC_DP9_C2M =  tx_serial_data[9];	 
    assign rx_serial_data[10] = LPC_DP0_M2C;
    assign LPC_DP0_C2M =  tx_serial_data[10];
	
    assign xcvr_tx_serial_clk[0]  = tx_serial_clk[0];
    assign xcvr_tx_serial_clk[1]  = tx_serial_clk[0];
    assign xcvr_tx_serial_clk[2]  = tx_serial_clk[0];
    assign xcvr_tx_serial_clk[3]  = tx_serial_clk[0];
    assign xcvr_tx_serial_clk[4]  = tx_serial_clk[1];
    assign xcvr_tx_serial_clk[5]  = tx_serial_clk[1];
    assign xcvr_tx_serial_clk[6]  = tx_serial_clk[1];
    assign xcvr_tx_serial_clk[7]  = tx_serial_clk[1];
    assign xcvr_tx_serial_clk[8]  = tx_serial_clk[1];
    assign xcvr_tx_serial_clk[9]  = tx_serial_clk[1];
    assign xcvr_tx_serial_clk[10] = tx_serial_clk[2];
    assign xcvr_pll_locked[0]  = pll_locked[0];
    assign xcvr_pll_locked[1]  = pll_locked[0];
    assign xcvr_pll_locked[2]  = pll_locked[0];
    assign xcvr_pll_locked[3]  = pll_locked[0];
    assign xcvr_pll_locked[4]  = pll_locked[1];
    assign xcvr_pll_locked[5]  = pll_locked[1];
    assign xcvr_pll_locked[6]  = pll_locked[1];
    assign xcvr_pll_locked[7]  = pll_locked[1];
    assign xcvr_pll_locked[8]  = pll_locked[1];
    assign xcvr_pll_locked[9]  = pll_locked[1];
    assign xcvr_pll_locked[10] = pll_locked[2];

    assign HDMI_TX_HPD_IO = 1'b1;
    assign FP_HDMI_TX_SCL = i2c_mst_scl_oe ? 0 : 1'bz ;
    assign FP_HDMI_TX_SDA = i2c_mst_sda_oe ? 0 : 1'bz ;
    assign FP_HDMI_TX_CLK = REFCLK_HDMI; 

    assign FP_LED_R0      = (ltssmstate == 5'b01111) ? 1'b1 : 1'b0;

    // NPOR Synchronize
    reg  [2:0] npor;
    always @( posedge COMe_PCIE_REFCLK/*PCIE_OB_REFCLK*/ ) begin     //If using SECO, Assign to "COMe_PCIE_REFCLK".
        npor <= {npor[1:0], COMe_PCIE_RESETn};
    end
	 
    generate
       genvar k;
       for(k=0; k<ch_num; k=k+1)
	    begin : loop_signal
          assign tx_control[8*k+7:8*k]  = (tx_enh_data_valid[k] == 1'b0) ? 8'hff : 8'h00;
          assign rx_seriallpbken[k] = control_reg[k];
	    end
    endgenerate 


control u0(
        //Clock & Reset
        .clk_clk                                          ( REFCLK_1                          ),
        .reset_reset_n                                    ( FP_DONE_RST_N                     ),
		  
        // Nios II UART
        .uart_0_external_connection_rxd                   ( USB_UART_TXD ),
        .uart_0_external_connection_txd                   ( USB_UART_RXD ),

        //XCVR Control
        .control_reg_export                               ( control_reg                       ),

        .data_pattern_checker_0_clk_clk                   ( rx_clkout[0]                      ),
        .data_pattern_checker_0_data_valid                ( rx_enh_data_valid[0]              ),
        .data_pattern_checker_0_data_ready                (                                   ),
        .data_pattern_checker_0_data_data                 ( rx_parallel_data[63:0]            ), 
        .data_pattern_generator_0_clk_clk                 ( tx_clkout[0]                      ),
        .data_pattern_generator_0_data_valid              ( tx_enh_data_valid[0]              ),
        .data_pattern_generator_0_data_ready              ( 1'b1                              ),
        .data_pattern_generator_0_data_data               ( tx_parallel_data[63:0]            ),

        .data_pattern_checker_1_clk_clk                   ( rx_clkout[1]                      ),
        .data_pattern_checker_1_data_valid                ( rx_enh_data_valid[1]              ),
        .data_pattern_checker_1_data_ready                (                                   ),
        .data_pattern_checker_1_data_data                 ( rx_parallel_data[127:64]          ), 
        .data_pattern_generator_1_clk_clk                 ( tx_clkout[1]                      ),
        .data_pattern_generator_1_data_valid              ( tx_enh_data_valid[1]              ),
        .data_pattern_generator_1_data_ready              ( 1'b1                              ),
        .data_pattern_generator_1_data_data               ( tx_parallel_data[127:64]          ),

        .data_pattern_checker_2_clk_clk                   ( rx_clkout[2]                      ),
        .data_pattern_checker_2_data_valid                ( rx_enh_data_valid[2]              ),
        .data_pattern_checker_2_data_ready                (                                   ),
        .data_pattern_checker_2_data_data                 ( rx_parallel_data[191:128]         ), 
        .data_pattern_generator_2_clk_clk                 ( tx_clkout[2]                      ),
        .data_pattern_generator_2_data_valid              ( tx_enh_data_valid[2]              ),
        .data_pattern_generator_2_data_ready              ( 1'b1                              ),
        .data_pattern_generator_2_data_data               ( tx_parallel_data[191:128]         ),

        .data_pattern_checker_3_clk_clk                   ( rx_clkout[3]                      ),
        .data_pattern_checker_3_data_valid                ( rx_enh_data_valid[3]              ),
        .data_pattern_checker_3_data_ready                (                                   ),
        .data_pattern_checker_3_data_data                 ( rx_parallel_data[255:192]         ), 
        .data_pattern_generator_3_clk_clk                 ( tx_clkout[3]                      ),
        .data_pattern_generator_3_data_valid              ( tx_enh_data_valid[3]              ),
        .data_pattern_generator_3_data_ready              ( 1'b1                              ),
        .data_pattern_generator_3_data_data               ( tx_parallel_data[255:192]         ),

        .data_pattern_checker_4_clk_clk                   ( rx_clkout[4]                      ),
        .data_pattern_checker_4_data_valid                ( rx_enh_data_valid[4]              ),
        .data_pattern_checker_4_data_ready                (                                   ),
        .data_pattern_checker_4_data_data                 ( rx_parallel_data[319:256]         ), 
        .data_pattern_generator_4_clk_clk                 ( tx_clkout[4]                      ),
        .data_pattern_generator_4_data_valid              ( tx_enh_data_valid[4]              ),
        .data_pattern_generator_4_data_ready              ( 1'b1                              ),
        .data_pattern_generator_4_data_data               ( tx_parallel_data[319:256]         ),

        .data_pattern_checker_5_clk_clk                   ( rx_clkout[5]                      ),
        .data_pattern_checker_5_data_valid                ( rx_enh_data_valid[5]              ),
        .data_pattern_checker_5_data_ready                (                                   ),
        .data_pattern_checker_5_data_data                 ( rx_parallel_data[383:320]         ), 
        .data_pattern_generator_5_clk_clk                 ( tx_clkout[5]                      ),
        .data_pattern_generator_5_data_valid              ( tx_enh_data_valid[5]              ),
        .data_pattern_generator_5_data_ready              ( 1'b1                              ),
        .data_pattern_generator_5_data_data               ( tx_parallel_data[383:320]         ),

        .data_pattern_checker_6_clk_clk                   ( rx_clkout[6]                      ),
        .data_pattern_checker_6_data_valid                ( rx_enh_data_valid[6]              ),
        .data_pattern_checker_6_data_ready                (                                   ),
        .data_pattern_checker_6_data_data                 ( rx_parallel_data[447:384]         ), 
        .data_pattern_generator_6_clk_clk                 ( tx_clkout[6]                      ),
        .data_pattern_generator_6_data_valid              ( tx_enh_data_valid[6]              ),
        .data_pattern_generator_6_data_ready              ( 1'b1                              ),
        .data_pattern_generator_6_data_data               ( tx_parallel_data[447:384]         ),

        .data_pattern_checker_7_clk_clk                   ( rx_clkout[7]                      ),
        .data_pattern_checker_7_data_valid                ( rx_enh_data_valid[7]              ),
        .data_pattern_checker_7_data_ready                (                                   ),
        .data_pattern_checker_7_data_data                 ( rx_parallel_data[511:448]         ), 
        .data_pattern_generator_7_clk_clk                 ( tx_clkout[7]                      ),
        .data_pattern_generator_7_data_valid              ( tx_enh_data_valid[7]              ),
        .data_pattern_generator_7_data_ready              ( 1'b1                              ),
        .data_pattern_generator_7_data_data               ( tx_parallel_data[511:448]         ),

        .data_pattern_checker_8_clk_clk                   ( rx_clkout[8]                      ),
        .data_pattern_checker_8_data_valid                ( rx_enh_data_valid[8]              ),
        .data_pattern_checker_8_data_ready                (                                   ),
        .data_pattern_checker_8_data_data                 ( rx_parallel_data[575:512]         ), 
        .data_pattern_generator_8_clk_clk                 ( tx_clkout[8]                      ),
        .data_pattern_generator_8_data_valid              ( tx_enh_data_valid[8]              ),
        .data_pattern_generator_8_data_ready              ( 1'b1                              ),
        .data_pattern_generator_8_data_data               ( tx_parallel_data[575:512]         ),

        .data_pattern_checker_9_clk_clk                   ( rx_clkout[9]                      ),
        .data_pattern_checker_9_data_valid                ( rx_enh_data_valid[9]              ),
        .data_pattern_checker_9_data_ready                (                                   ),
        .data_pattern_checker_9_data_data                 ( rx_parallel_data[639:576]         ), 
        .data_pattern_generator_9_clk_clk                 ( tx_clkout[9]                      ),
        .data_pattern_generator_9_data_valid              ( tx_enh_data_valid[9]              ),
        .data_pattern_generator_9_data_ready              ( 1'b1                              ),
        .data_pattern_generator_9_data_data               ( tx_parallel_data[639:576]         ),

        .data_pattern_checker_10_clk_clk                  ( rx_clkout[10]                     ),
        .data_pattern_checker_10_data_valid               ( rx_enh_data_valid[10]             ),
        .data_pattern_checker_10_data_ready               (                                   ),
        .data_pattern_checker_10_data_data                ( rx_parallel_data[703:640]         ), 
        .data_pattern_generator_10_clk_clk                ( tx_clkout[10]                     ),
        .data_pattern_generator_10_data_valid             ( tx_enh_data_valid[10]             ),
        .data_pattern_generator_10_data_ready             ( 1'b1                              ),
        .data_pattern_generator_10_data_data              ( tx_parallel_data[703:640]         )
        );

generate
  genvar j;
   for(j=0; j<tx_pll_num; j=j+1) begin : loop_tx_pll
    txpll u1(
        .clk_clk                                          ( clk_125m                          ),
        .pll_cal_busy0_pll_cal_busy                       (                                   ),
        .pll_locked_pll_locked                            ( pll_locked[j]                     ),
        .pll_refclk0_clk                                  ( pll_refclk                        ),
        .reset_reset_n                                    ( reset_n                           ),
        .tx_serial_clk_clk                                ( tx_serial_clk[j]                  ),
        .pll_powerdown_out_pll_powerdown                  ( pll_powerdown[j]                  ),
        .pll_powerdown_pll_powerdown                      ( pll_powerdown[j]                  )
        );
   end
endgenerate	



generate
  genvar i;
   for(i=0; i<ch_num; i=i+1) begin : loop_xcvr
    xcvr u2(
        .clk_clk                                          ( clk_125m                          ),
        .pll_select0_pll_select                           ( 1'b0                              ),
        .reset_reset_n                                    ( reset_n                           ),
        .rx_cdr_refclk0_clk                               ( pll_refclk                        ),
        .rx_clkout0_clk                                   (                                   ),
        .rx_pma_div_clkout0_clk                           ( rx_clkout[i]                      ),
        .rx_coreclkin0_clk                                ( rx_clkout[i]                      ),
        .rx_enh_data_valid0_rx_enh_data_valid             ( rx_enh_data_valid[i]              ),
        .rx_enh_blk_lock_rx_enh_blk_lock                  (                                   ),
        .rx_enh_fifo_empty0_rx_enh_fifo_empty             (                                   ),
        .rx_enh_fifo_full0_rx_enh_fifo_full               (                                   ),
        .rx_is_lockedtoref0_rx_is_lockedtoref             (                                   ),
        .rx_parallel_data0_rx_parallel_data               ( rx_parallel_data[64*i+63:64*i]    ),
        .rx_control0_rx_control                           (                                   ),
        .rx_ready0_rx_ready                               (                                   ),
        .rx_serial_data0_rx_serial_data                   ( rx_serial_data[i]                 ),
        .rx_seriallpbken0_rx_seriallpbken                 ( rx_seriallpbken[i]                ),
        .tx_clkout0_clk                                   (                                   ),
        .tx_pma_div_clkout0_clk                           ( tx_clkout[i]                      ),
        .tx_coreclkin0_clk                                ( tx_clkout[i]                      ),
        .tx_enh_data_valid0_tx_enh_data_valid             ( 1'b1                              ),
        .tx_enh_fifo_empty0_tx_enh_fifo_empty             (                                   ),
        .tx_enh_fifo_full0_tx_enh_fifo_full               (                                   ),
        .tx_enh_fifo_pempty0_tx_enh_fifo_pempty           (                                   ),
        .tx_enh_fifo_pfull0_tx_enh_fifo_pfull             (                                   ),
        .tx_parallel_data0_tx_parallel_data               ( tx_parallel_data[64*i+63:64*i]    ),
        .tx_control0_tx_control                           ( tx_control[8*i+7:8*i]             ),
        .tx_ready0_tx_ready                               (                                   ),       
        .tx_serial_data0_tx_serial_data                   ( tx_serial_data[i]                 ),
        .tx_err_ins_tx_err_ins                            ( 1'b0                              ),
        .tx_serial_clk0_clk                               ( xcvr_tx_serial_clk[i]             ),
        .pll_locked0_pll_locked                           ( xcvr_pll_locked[i]                ),
        .unused_rx_control_unused_rx_control              (                                   ),
        .unused_rx_parallel_data_unused_rx_parallel_data  (                                   ),
        .unused_tx_control_unused_tx_control              ( 9'b000000000                      ),
        .unused_tx_parallel_data_unused_tx_parallel_data  ( 64'h0000000000000000              )
        );
   end
endgenerate	

//PCIe Interface
//HDMI TX interface & Color Bar Generator 
hdmi_pll u3(
        .refclk                                           ( REFCLK_1                          ), // 100MHz
        .rst                                              ( !FP_DONE_RST_N                    ),
        .outclk_0                                         ( pll_50m                           ), // 50MHz
        .locked                                           ( hdmi_reset_n                      ) 
        );

		  
main u4(
        .alt_vip_cl_cvo_0_clocked_video_vid_clk           ( REFCLK_HDMI                       ),
        .alt_vip_cl_cvo_0_clocked_video_vid_data          ( {FP_HDMI_TX_DR, FP_HDMI_TX_DG, FP_HDMI_TX_DB} ),
        .alt_vip_cl_cvo_0_clocked_video_underflow         (                                   ),
        .alt_vip_cl_cvo_0_clocked_video_vid_datavalid     ( FP_HDMI_TX_DE                     ),
        .alt_vip_cl_cvo_0_clocked_video_vid_v_sync        ( FP_HDMI_TX_VSYNC                  ),
        .alt_vip_cl_cvo_0_clocked_video_vid_h_sync        ( FP_HDMI_TX_HSYNC                  ),
        .alt_vip_cl_cvo_0_clocked_video_vid_f             (                                   ),
        .alt_vip_cl_cvo_0_clocked_video_vid_h             (                                   ),
        .alt_vip_cl_cvo_0_clocked_video_vid_v             (                                   ),
        //DDR4 Memory0
        .emif_0_global_reset_n_reset_n                    ( FP_DONE_RST_N                     ),
        .emif_0_mem_mem_ck                                ( DDR4_MEM0_CK                      ),
        .emif_0_mem_mem_ck_n                              ( DDR4_MEM0_CK_N                    ),
        .emif_0_mem_mem_a                                 ( DDR4_MEM0_A                       ),
        .emif_0_mem_mem_act_n                             ( DDR4_MEM0_ACT_N                   ),
        .emif_0_mem_mem_ba                                ( DDR4_MEM0_BA                      ),
        .emif_0_mem_mem_bg                                ( DDR4_MEM0_BG                      ),
        .emif_0_mem_mem_cke                               ( DDR4_MEM0_CKE                     ),
        .emif_0_mem_mem_cs_n                              ( DDR4_MEM0_CS_N                    ),
        .emif_0_mem_mem_odt                               ( DDR4_MEM0_ODT                     ),
        .emif_0_mem_mem_reset_n                           ( DDR4_MEM0_RESET_N                 ),
        .emif_0_mem_mem_par                               ( DDR4_MEM0_PAR                     ),
        .emif_0_mem_mem_alert_n                           ( DDR4_MEM0_ALERT_N                 ),
        .emif_0_mem_mem_dqs                               ( DDR4_MEM0_DQS                     ),
        .emif_0_mem_mem_dqs_n                             ( DDR4_MEM0_DQS_N                   ),
        .emif_0_mem_mem_dq                                ( DDR4_MEM0_DQ                      ),
        .emif_0_mem_mem_dbi_n                             ( DDR4_MEM0_DBI_N                   ),
        .emif_0_oct_oct_rzqin                             ( DDR4_MEM0_OCT_RZQIN               ),
        .emif_0_pll_ref_clk_clk                           ( DDR4_PLL_REF_CLK0_P               ),
        .emif_0_status_local_cal_success                  (                                   ),
        .emif_0_status_local_cal_fail                     (                                   ),
		  //DDR4 Memory1 for Frame buffer
        .emif_1_global_reset_n_reset_n                    ( FP_DONE_RST_N                     ),
        .emif_1_mem_mem_ck                                ( DDR4_MEM1_CK                      ),
        .emif_1_mem_mem_ck_n                              ( DDR4_MEM1_CK_N                    ),
        .emif_1_mem_mem_a                                 ( DDR4_MEM1_A                       ),
        .emif_1_mem_mem_act_n                             ( DDR4_MEM1_ACT_N                   ),
        .emif_1_mem_mem_ba                                ( DDR4_MEM1_BA                      ),
        .emif_1_mem_mem_bg                                ( DDR4_MEM1_BG                      ),
        .emif_1_mem_mem_cke                               ( DDR4_MEM1_CKE                     ),
        .emif_1_mem_mem_cs_n                              ( DDR4_MEM1_CS_N                    ),
        .emif_1_mem_mem_odt                               ( DDR4_MEM1_ODT                     ),
        .emif_1_mem_mem_reset_n                           ( DDR4_MEM1_RESET_N                 ),
        .emif_1_mem_mem_par                               ( DDR4_MEM1_PAR                     ),
        .emif_1_mem_mem_alert_n                           ( DDR4_MEM1_ALERT_N                 ),
        .emif_1_mem_mem_dqs                               ( DDR4_MEM1_DQS                     ),
        .emif_1_mem_mem_dqs_n                             ( DDR4_MEM1_DQS_N                   ),
        .emif_1_mem_mem_dq                                ( DDR4_MEM1_DQ                      ),
        .emif_1_mem_mem_dbi_n                             ( DDR4_MEM1_DBI_N                   ),
        .emif_1_oct_oct_rzqin                             ( DDR4_MEM1_OCT_RZQIN               ),
        .emif_1_pll_ref_clk_clk                           ( DDR4_PLL_REF_CLK1_P               ),
        .emif_1_status_local_cal_success                  (                                   ),
        .emif_1_status_local_cal_fail                     (                                   ),
        .clk_148_clk                                      ( REFCLK_HDMI                       ),                         
        .reset_148_reset_n                                ( FP_DONE_RST_N                     ),
        // PCIe Interface
        .npor_npor                                        ( npor[2]                           ),
        .npor_pin_perst                                   ( COMe_PCIE_RESETn                  ),
        .refclk_clk                                       ( COMe_PCIE_REFCLK/*PCIE_OB_REFCLK*/),  //If using SECO, Assign to "COMe_PCIE_REFCLK".
        .hip_serial_rx_in0                                ( COMe_PCIE_RX_0                    ),
        .hip_serial_rx_in1                                ( COMe_PCIE_RX_1                    ),
        .hip_serial_rx_in2                                ( COMe_PCIE_RX_2                    ),
        .hip_serial_rx_in3                                ( COMe_PCIE_RX_3                    ),
        .hip_serial_tx_out0                               ( COMe_PCIE_TX_0                    ),
        .hip_serial_tx_out1                               ( COMe_PCIE_TX_1                    ),
        .hip_serial_tx_out2                               ( COMe_PCIE_TX_2                    ),
        .hip_serial_tx_out3                               ( COMe_PCIE_TX_3                    ),
        .coreclkout_clk                                   ( coreclkout                        ),
        .hip_ctrl_test_in                                 ( 32'h188                           ),
        .hip_ctrl_simu_mode_pipe                          ( 1'b0                              ),
        .hip_status_lane_act                              ( lane_act                          ),
        .hip_status_ltssmstate                            ( ltssmstate                        ),
        .currentspeed_currentspeed                        ( currentspeed                      ),
		  .led_pio_external_connection_export               ( user_led                          ),
		  .push_sw_pio_external_connection_export           ( user_push_sw                      ),
        .dip_sw_pio_external_connection_export            ( user_dip_sw                       )
        );	
	
	
	
hdmi_i2c u5(
        .i2c_0_i2c_serial_sda_in                          ( FP_HDMI_TX_SDA                    ),
        .i2c_0_i2c_serial_scl_in                          ( FP_HDMI_TX_SCL                    ),
        .i2c_0_i2c_serial_sda_oe                          ( i2c_mst_sda_oe                    ),
        .i2c_0_i2c_serial_scl_oe                          ( i2c_mst_scl_oe                    ),
        .reset_50_reset_n                                 ( hdmi_reset_n                      ),
        .clk_50_clk                                       ( pll_50m                           ),
        .hdmi_int_pio_external_connection_export          ( FP_HDMI_TX_INT                    ),
        .hdmi_reset_pio_external_connection_export        ( FP_HDMI_TX_RESET_N                )
        );	
	
	
endmodule // golden_top
