create_clock -name pcie_refclk -period 100MHz [get_ports COMe_PCIE_REFCLK]
create_clock -name pcie_refclk -period 100MHz [get_ports PCIE_OB_REFCLK]
create_clock -name REFCLK_0 -period 125MHz [get_ports {REFCLK_0}]
create_clock -name REFCLK_1 -period 100MHz [get_ports {REFCLK_1}]
create_clock -name REFCLK_3 -period 270MHz [get_ports {REFCLK_3}]
create_clock -name REFCLK_HDMI -period 148.5MHz [get_ports {REFCLK_HDMI}]
create_clock -name DDR4_PLL_REF_CLK0_P -period 233.3333MHz [get_ports {DDR4_PLL_REF_CLK0_P}]
create_clock -name DDR4_PLL_REF_CLK1_P -period 233.3333MHz [get_ports {DDR4_PLL_REF_CLK1_P}]
create_clock -name altera_reserved_tck -period 24MHz [get_ports {altera_reserved_tck}]

derive_pll_clocks
derive_clock_uncertainty

create_generated_clock [get_ports {FP_HDMI_TX_CLK}] -name HDMI_TX_CLK -source [get_ports {REFCLK_HDMI}] -divide_by 1
set_output_delay 1 -clock HDMI_TX_CLK                       [get_ports {FP_HDMI_TX_VSYNC}]
set_output_delay 1 -clock HDMI_TX_CLK                       [get_ports {FP_HDMI_TX_HSYNC}]
set_output_delay 1 -clock HDMI_TX_CLK                       [get_ports {FP_HDMI_TX_DE}]
set_output_delay 1 -clock HDMI_TX_CLK                       [get_ports {FP_HDMI_TX_DR[*]}]
set_output_delay 1 -clock HDMI_TX_CLK                       [get_ports {FP_HDMI_TX_DG[*]}]
set_output_delay 1 -clock HDMI_TX_CLK                       [get_ports {FP_HDMI_TX_DB[*]}]

set_false_path -to   [get_ports {FP_LED_R*}]
set_false_path -to   [get_ports {FP_LED_G*}]
set_false_path -from [get_ports {FP_DIP_SW*}] -to *
set_false_path -from [get_ports {FP_PSW*}] -to *
set_false_path -from [get_ports {FP_DONE_RST_N}] -to *
set_false_path -to   [get_ports {FP_HDMI_TX_RESET_N}]

set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[0].u2|xcvr_native_a10_0|tx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[0].u2|xcvr_native_a10_0|rx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[1].u2|xcvr_native_a10_0|tx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[1].u2|xcvr_native_a10_0|rx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[2].u2|xcvr_native_a10_0|tx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[2].u2|xcvr_native_a10_0|rx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[3].u2|xcvr_native_a10_0|tx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[3].u2|xcvr_native_a10_0|rx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[4].u2|xcvr_native_a10_0|tx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[4].u2|xcvr_native_a10_0|rx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[5].u2|xcvr_native_a10_0|tx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[5].u2|xcvr_native_a10_0|rx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[6].u2|xcvr_native_a10_0|tx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[6].u2|xcvr_native_a10_0|rx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[7].u2|xcvr_native_a10_0|tx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[7].u2|xcvr_native_a10_0|rx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[8].u2|xcvr_native_a10_0|tx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[8].u2|xcvr_native_a10_0|rx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[9].u2|xcvr_native_a10_0|tx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[9].u2|xcvr_native_a10_0|rx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[10].u2|xcvr_native_a10_0|tx_pma_div_clk}]
set_false_path  -from  [get_clocks {REFCLK_1}]  -to  [get_clocks {loop_xcvr[10].u2|xcvr_native_a10_0|rx_pma_div_clk}]

set_clock_groups -asynchronous -group {altera_reserved_tck} -group {COMe_PCIE_REFCLK} -group {u4|pcie_a10_hip_0|coreclkout} -group {PCIE_OB_REFCLK}

# 0706 add by ikeda-k
set_false_path -from [get_ports {FP_HDMI_TX_SCL}] -to *
set_false_path -from * -to [get_ports {FP_HDMI_TX_SCL}]
set_false_path -from [get_ports {FP_HDMI_TX_SDA}] -to *
set_false_path -from * -to [get_ports {FP_HDMI_TX_SDA}]
set_false_path -from [get_ports {FP_HDMI_TX_INT}] -to *
set_false_path -from [get_ports {COMe_PCIE_RESETn}] -to *
set_false_path -from * -to [get_ports {USB_UART_RXD}]

# for JTAG
set_input_delay -clock altera_reserved_tck 10 [get_ports altera_reserved_ntrst]
set_input_delay -clock altera_reserved_tck 10 [get_ports altera_reserved_tdi]
set_input_delay -clock altera_reserved_tck 10 [get_ports altera_reserved_tms]
set_output_delay -clock altera_reserved_tck 9.5 [get_ports altera_reserved_tdo]