// (C) 2001-2017 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.



// Your use of Altera Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License Subscription 
// Agreement, Altera MegaCore Function License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the applicable 
// agreement for further details.


// $Id: //acds/rel/17.1std/ip/merlin/altera_merlin_router/altera_merlin_router.sv.terp#1 $
// $Revision: #1 $
// $Date: 2017/07/30 $
// $Author: swbranch $

// -------------------------------------------------------
// Merlin Router
//
// Asserts the appropriate one-hot encoded channel based on 
// either (a) the address or (b) the dest id. The DECODER_TYPE
// parameter controls this behaviour. 0 means address decoder,
// 1 means dest id decoder.
//
// In the case of (a), it also sets the destination id.
// -------------------------------------------------------

`timescale 1 ns / 1 ns

module control_altera_merlin_router_171_4b44r2i_default_decode
  #(
     parameter DEFAULT_CHANNEL = 29,
               DEFAULT_WR_CHANNEL = -1,
               DEFAULT_RD_CHANNEL = -1,
               DEFAULT_DESTID = 1 
   )
  (output [98 - 94 : 0] default_destination_id,
   output [30-1 : 0] default_wr_channel,
   output [30-1 : 0] default_rd_channel,
   output [30-1 : 0] default_src_channel
  );

  assign default_destination_id = 
    DEFAULT_DESTID[98 - 94 : 0];

  generate
    if (DEFAULT_CHANNEL == -1) begin : no_default_channel_assignment
      assign default_src_channel = '0;
    end
    else begin : default_channel_assignment
      assign default_src_channel = 30'b1 << DEFAULT_CHANNEL;
    end
  endgenerate

  generate
    if (DEFAULT_RD_CHANNEL == -1) begin : no_default_rw_channel_assignment
      assign default_wr_channel = '0;
      assign default_rd_channel = '0;
    end
    else begin : default_rw_channel_assignment
      assign default_wr_channel = 30'b1 << DEFAULT_WR_CHANNEL;
      assign default_rd_channel = 30'b1 << DEFAULT_RD_CHANNEL;
    end
  endgenerate

endmodule


module control_altera_merlin_router_171_4b44r2i
(
    // -------------------
    // Clock & Reset
    // -------------------
    input clk,
    input reset,

    // -------------------
    // Command Sink (Input)
    // -------------------
    input                       sink_valid,
    input  [112-1 : 0]    sink_data,
    input                       sink_startofpacket,
    input                       sink_endofpacket,
    output                      sink_ready,

    // -------------------
    // Command Source (Output)
    // -------------------
    output                          src_valid,
    output reg [112-1    : 0] src_data,
    output reg [30-1 : 0] src_channel,
    output                          src_startofpacket,
    output                          src_endofpacket,
    input                           src_ready
);

    // -------------------------------------------------------
    // Local parameters and variables
    // -------------------------------------------------------
    localparam PKT_ADDR_H = 66;
    localparam PKT_ADDR_L = 36;
    localparam PKT_DEST_ID_H = 98;
    localparam PKT_DEST_ID_L = 94;
    localparam PKT_PROTECTION_H = 102;
    localparam PKT_PROTECTION_L = 100;
    localparam ST_DATA_W = 112;
    localparam ST_CHANNEL_W = 30;
    localparam DECODER_TYPE = 0;

    localparam PKT_TRANS_WRITE = 69;
    localparam PKT_TRANS_READ  = 70;

    localparam PKT_ADDR_W = PKT_ADDR_H-PKT_ADDR_L + 1;
    localparam PKT_DEST_ID_W = PKT_DEST_ID_H-PKT_DEST_ID_L + 1;



    // -------------------------------------------------------
    // Figure out the number of bits to mask off for each slave span
    // during address decoding
    // -------------------------------------------------------
    localparam PAD0 = log2ceil(64'h8 - 64'h0); 
    localparam PAD1 = log2ceil(64'h1020 - 64'h1000); 
    localparam PAD2 = log2ceil(64'h2020 - 64'h2000); 
    localparam PAD3 = log2ceil(64'h3010 - 64'h3000); 
    localparam PAD4 = log2ceil(64'h4020 - 64'h4000); 
    localparam PAD5 = log2ceil(64'h5020 - 64'h5000); 
    localparam PAD6 = log2ceil(64'h6020 - 64'h6000); 
    localparam PAD7 = log2ceil(64'h7020 - 64'h7000); 
    localparam PAD8 = log2ceil(64'h8020 - 64'h8000); 
    localparam PAD9 = log2ceil(64'h9020 - 64'h9000); 
    localparam PAD10 = log2ceil(64'ha020 - 64'ha000); 
    localparam PAD11 = log2ceil(64'hb020 - 64'hb000); 
    localparam PAD12 = log2ceil(64'hc020 - 64'hc000); 
    localparam PAD13 = log2ceil(64'hd020 - 64'hd000); 
    localparam PAD14 = log2ceil(64'he020 - 64'he000); 
    localparam PAD15 = log2ceil(64'hf020 - 64'hf000); 
    localparam PAD16 = log2ceil(64'h10020 - 64'h10000); 
    localparam PAD17 = log2ceil(64'h11020 - 64'h11000); 
    localparam PAD18 = log2ceil(64'h12020 - 64'h12000); 
    localparam PAD19 = log2ceil(64'h13020 - 64'h13000); 
    localparam PAD20 = log2ceil(64'h14020 - 64'h14000); 
    localparam PAD21 = log2ceil(64'h15020 - 64'h15000); 
    localparam PAD22 = log2ceil(64'h16020 - 64'h16000); 
    localparam PAD23 = log2ceil(64'h17020 - 64'h17000); 
    localparam PAD24 = log2ceil(64'h18020 - 64'h18000); 
    localparam PAD25 = log2ceil(64'h19020 - 64'h19000); 
    localparam PAD26 = log2ceil(64'h41000 - 64'h40800); 
    localparam PAD27 = log2ceil(64'h41010 - 64'h41008); 
    localparam PAD28 = log2ceil(64'h10020000 - 64'h10000000); 
    localparam PAD29 = log2ceil(64'h80000000 - 64'h40000000); 
    // -------------------------------------------------------
    // Work out which address bits are significant based on the
    // address range of the slaves. If the required width is too
    // large or too small, we use the address field width instead.
    // -------------------------------------------------------
    localparam ADDR_RANGE = 64'h80000000;
    localparam RANGE_ADDR_WIDTH = log2ceil(ADDR_RANGE);
    localparam OPTIMIZED_ADDR_H = (RANGE_ADDR_WIDTH > PKT_ADDR_W) ||
                                  (RANGE_ADDR_WIDTH == 0) ?
                                        PKT_ADDR_H :
                                        PKT_ADDR_L + RANGE_ADDR_WIDTH - 1;

    localparam RG = RANGE_ADDR_WIDTH-1;
    localparam REAL_ADDRESS_RANGE = OPTIMIZED_ADDR_H - PKT_ADDR_L;

      reg [PKT_ADDR_W-1 : 0] address;
      always @* begin
        address = {PKT_ADDR_W{1'b0}};
        address [REAL_ADDRESS_RANGE:0] = sink_data[OPTIMIZED_ADDR_H : PKT_ADDR_L];
      end   

    // -------------------------------------------------------
    // Pass almost everything through, untouched
    // -------------------------------------------------------
    assign sink_ready        = src_ready;
    assign src_valid         = sink_valid;
    assign src_startofpacket = sink_startofpacket;
    assign src_endofpacket   = sink_endofpacket;
    wire [PKT_DEST_ID_W-1:0] default_destid;
    wire [30-1 : 0] default_src_channel;






    control_altera_merlin_router_171_4b44r2i_default_decode the_default_decode(
      .default_destination_id (default_destid),
      .default_wr_channel   (),
      .default_rd_channel   (),
      .default_src_channel  (default_src_channel)
    );

    always @* begin
        src_data    = sink_data;
        src_channel = default_src_channel;
        src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = default_destid;

        // --------------------------------------------------
        // Address Decoder
        // Sets the channel and destination ID based on the address
        // --------------------------------------------------

    // ( 0x0 .. 0x8 )
    if ( {address[RG:PAD0],{PAD0{1'b0}}} == 31'h0   ) begin
            src_channel = 30'b000000000000000000000000000010;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 0;
    end

    // ( 0x1000 .. 0x1020 )
    if ( {address[RG:PAD1],{PAD1{1'b0}}} == 31'h1000   ) begin
            src_channel = 30'b000100000000000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 25;
    end

    // ( 0x2000 .. 0x2020 )
    if ( {address[RG:PAD2],{PAD2{1'b0}}} == 31'h2000   ) begin
            src_channel = 30'b001000000000000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 29;
    end

    // ( 0x3000 .. 0x3010 )
    if ( {address[RG:PAD3],{PAD3{1'b0}}} == 31'h3000   ) begin
            src_channel = 30'b010000000000000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 2;
    end

    // ( 0x4000 .. 0x4020 )
    if ( {address[RG:PAD4],{PAD4{1'b0}}} == 31'h4000   ) begin
            src_channel = 30'b000000000000000000000000000100;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 14;
    end

    // ( 0x5000 .. 0x5020 )
    if ( {address[RG:PAD5],{PAD5{1'b0}}} == 31'h5000   ) begin
            src_channel = 30'b000000000000000000000000001000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 3;
    end

    // ( 0x6000 .. 0x6020 )
    if ( {address[RG:PAD6],{PAD6{1'b0}}} == 31'h6000   ) begin
            src_channel = 30'b000000000000000000000000010000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 16;
    end

    // ( 0x7000 .. 0x7020 )
    if ( {address[RG:PAD7],{PAD7{1'b0}}} == 31'h7000   ) begin
            src_channel = 30'b000000000000000000000000100000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 5;
    end

    // ( 0x8000 .. 0x8020 )
    if ( {address[RG:PAD8],{PAD8{1'b0}}} == 31'h8000   ) begin
            src_channel = 30'b000000000000000000000001000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 17;
    end

    // ( 0x9000 .. 0x9020 )
    if ( {address[RG:PAD9],{PAD9{1'b0}}} == 31'h9000   ) begin
            src_channel = 30'b000000000000000000000010000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 6;
    end

    // ( 0xa000 .. 0xa020 )
    if ( {address[RG:PAD10],{PAD10{1'b0}}} == 31'ha000   ) begin
            src_channel = 30'b000000000000000000000100000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 18;
    end

    // ( 0xb000 .. 0xb020 )
    if ( {address[RG:PAD11],{PAD11{1'b0}}} == 31'hb000   ) begin
            src_channel = 30'b000000000000000000001000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 7;
    end

    // ( 0xc000 .. 0xc020 )
    if ( {address[RG:PAD12],{PAD12{1'b0}}} == 31'hc000   ) begin
            src_channel = 30'b000000000000000000010000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 19;
    end

    // ( 0xd000 .. 0xd020 )
    if ( {address[RG:PAD13],{PAD13{1'b0}}} == 31'hd000   ) begin
            src_channel = 30'b000000000000000000100000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 8;
    end

    // ( 0xe000 .. 0xe020 )
    if ( {address[RG:PAD14],{PAD14{1'b0}}} == 31'he000   ) begin
            src_channel = 30'b000000000000000001000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 20;
    end

    // ( 0xf000 .. 0xf020 )
    if ( {address[RG:PAD15],{PAD15{1'b0}}} == 31'hf000   ) begin
            src_channel = 30'b000000000000000010000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 9;
    end

    // ( 0x10000 .. 0x10020 )
    if ( {address[RG:PAD16],{PAD16{1'b0}}} == 31'h10000   ) begin
            src_channel = 30'b000000000000000100000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 21;
    end

    // ( 0x11000 .. 0x11020 )
    if ( {address[RG:PAD17],{PAD17{1'b0}}} == 31'h11000   ) begin
            src_channel = 30'b000000000000001000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 10;
    end

    // ( 0x12000 .. 0x12020 )
    if ( {address[RG:PAD18],{PAD18{1'b0}}} == 31'h12000   ) begin
            src_channel = 30'b000000000000010000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 22;
    end

    // ( 0x13000 .. 0x13020 )
    if ( {address[RG:PAD19],{PAD19{1'b0}}} == 31'h13000   ) begin
            src_channel = 30'b000000000000100000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 11;
    end

    // ( 0x14000 .. 0x14020 )
    if ( {address[RG:PAD20],{PAD20{1'b0}}} == 31'h14000   ) begin
            src_channel = 30'b000000000001000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 23;
    end

    // ( 0x15000 .. 0x15020 )
    if ( {address[RG:PAD21],{PAD21{1'b0}}} == 31'h15000   ) begin
            src_channel = 30'b000000000010000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 12;
    end

    // ( 0x16000 .. 0x16020 )
    if ( {address[RG:PAD22],{PAD22{1'b0}}} == 31'h16000   ) begin
            src_channel = 30'b000000000100000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 24;
    end

    // ( 0x17000 .. 0x17020 )
    if ( {address[RG:PAD23],{PAD23{1'b0}}} == 31'h17000   ) begin
            src_channel = 30'b000000001000000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 13;
    end

    // ( 0x18000 .. 0x18020 )
    if ( {address[RG:PAD24],{PAD24{1'b0}}} == 31'h18000   ) begin
            src_channel = 30'b000000010000000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 15;
    end

    // ( 0x19000 .. 0x19020 )
    if ( {address[RG:PAD25],{PAD25{1'b0}}} == 31'h19000   ) begin
            src_channel = 30'b000000100000000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 4;
    end

    // ( 0x40800 .. 0x41000 )
    if ( {address[RG:PAD26],{PAD26{1'b0}}} == 31'h40800   ) begin
            src_channel = 30'b000001000000000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 27;
    end

    // ( 0x41008 .. 0x41010 )
    if ( {address[RG:PAD27],{PAD27{1'b0}}} == 31'h41008   ) begin
            src_channel = 30'b000000000000000000000000000001;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 26;
    end

    // ( 0x10000000 .. 0x10020000 )
    if ( {address[RG:PAD28],{PAD28{1'b0}}} == 31'h10000000   ) begin
            src_channel = 30'b000010000000000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 28;
    end

    // ( 0x40000000 .. 0x80000000 )
    if ( {address[RG:PAD29],{PAD29{1'b0}}} == 31'h40000000   ) begin
            src_channel = 30'b100000000000000000000000000000;
            src_data[PKT_DEST_ID_H:PKT_DEST_ID_L] = 1;
    end

end


    // --------------------------------------------------
    // Ceil(log2()) function
    // --------------------------------------------------
    function integer log2ceil;
        input reg[65:0] val;
        reg [65:0] i;

        begin
            i = 1;
            log2ceil = 0;

            while (i < val) begin
                log2ceil = log2ceil + 1;
                i = i << 1;
            end
        end
    endfunction

endmodule


