module nios2_adc_lab ( 
	input 		 clk,
	input        reset_n,
	input	 [2:0] SW,
	output [2:0] LED
);


wire adc_10M_clk;
wire nios_50M_clk;
wire pll_locked;
wire reset;

assign reset = !reset_n;


	all_pll	alt_pll_inst (
   .areset 	( reset ),
	.inclk0 	( clk ),
	.c0 		( adc_10M_clk ),
	.c1 		( nios_50M_clk ),
	.locked 	( pll_locked )
	);


	nios2_system u0 (
		.clk_clk                         	(nios_50M_clk),   //	clk.clk
		.reset_reset_n                      (reset_n),        //	reset.reset_n
		.led_io_external_connection_export  (LED),    			// led_pio_external_connection.export
		.sw_io_external_connection_export	(SW), 				// switch_pio_external_connection.export
		.modular_adc_0_adc_pll_clock_clk    (adc_10M_clk),    // modular_adc_adc_pll_clock.clk
		.modular_adc_0_adc_pll_locked_export(pll_locked)    	// modular_adc_adc_pll_locked.export
	);
	
	
endmodule