LIBRARY ieee;
USE ieee.std_logic_1164.all; 

ENTITY nios2_basic_lab IS 
	PORT
	(
		clk 	:  IN  STD_LOGIC;
		reset_n :  IN  STD_LOGIC;
		leds 	:  OUT  STD_LOGIC_VECTOR(7 DOWNTO 0)
	);
END nios2_basic_lab;


ARCHITECTURE rtl OF nios2_basic_lab IS 

COMPONENT nios2_system
	PORT(clk_clk	 	: IN STD_LOGIC;
		 reset_reset_n 	: IN STD_LOGIC;
		 led_pio_export : OUT STD_LOGIC_VECTOR(7 DOWNTO 0)
	);
END COMPONENT;

SIGNAL	osc_clk :  STD_LOGIC;
SIGNAL	tmp :  STD_LOGIC_VECTOR(7 DOWNTO 0);

BEGIN 

u0 : nios2_system
PORT MAP (	clk_clk => CONNECTED_TO_clk_clk,   -- 　clk.clk
			led_pio_export => CONNECTED_TO_led_pio_export,   -- 　led_pio.export
			reset_reset_n => CONNECTED_TO_reset_reset_n   --  reset.reset_n
		);

leds <= NOT(tmp);
osc_clk <= clk;

END rtl;