library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

ENTITY LED_Flash IS 
	PORT
	(
		CLK :  IN  STD_LOGIC;
		LED1 :  OUT  STD_LOGIC;
		LED2 :  OUT  STD_LOGIC;
		LED3 :  OUT  STD_LOGIC;
		LED4 :  OUT  STD_LOGIC;
		LED5 :  OUT  STD_LOGIC
	);
END LED_Flash;

ARCHITECTURE RTL OF LED_Flash IS 

		signal div_cntr1 : std_logic_vector(15 downto 0) := X"0000";
		signal div_cntr2 : std_logic_vector(9 downto 0) := "0000000000";
		signal dec_cntr : std_logic := '0';
		signal half_sec_pulse : std_logic;
		
BEGIN 

PROCESS (CLK) BEGIN
	
	if (CLK'event and CLK = '1') then
		div_cntr1 <= div_cntr1 + X"01";
	
		if (div_cntr1 = X"00") then
			if (div_cntr2 = X"2FA") then
				div_cntr2 <= "0000000000";
				half_sec_pulse <= '1';
			else
				div_cntr2 <= div_cntr2 + "0000000001";
			end if;
		else
			half_sec_pulse <= '0';
		end if;
	
		if (half_sec_pulse = '1') then
			dec_cntr <= not dec_cntr;
		end if;
	end if;

END PROCESS;

	LED1 <= dec_cntr;
	LED2 <= dec_cntr;
	LED3 <= dec_cntr;
	LED4 <= dec_cntr;
	LED5 <= dec_cntr;
			
END RTL;
