module LED_Flash(
    input CLK,
    output LED1,
    output LED2,
    output LED3,
    output LED4,
    output LED5
    );

	reg[15:0] div_cntr1;
	reg[9:0] div_cntr2;
	reg dec_cntr;
	reg half_sec_pulse;
	
	initial begin
		div_cntr1 = 0;
		div_cntr2 = 0;
		dec_cntr  = 0;
		end
		
	
	always@(posedge CLK)
		begin
		div_cntr1 <= div_cntr1 + 1;
		if (div_cntr1 == 0) 
			if (div_cntr2 == 762) 
				begin
				div_cntr2 <= 0;
				half_sec_pulse <= 1;  
				end
			else
				div_cntr2 <= div_cntr2 + 1;
		else
			half_sec_pulse <= 0;
		
		if (half_sec_pulse == 1)	
			dec_cntr <= !dec_cntr;
			
		end	
		
		
	assign LED1 = dec_cntr ;
	assign LED2 = dec_cntr ;
	assign LED3 = dec_cntr ;
	assign LED4 = dec_cntr ;
	assign LED5 = dec_cntr ;
				
endmodule
