library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity st_demo is
	port
	(	clk		: in std_logic;
		areset	: in std_logic;
		led		: out std_logic_vector(3 downto 0):=(others => '0')	);

end st_demo;

architecture rtl of st_demo is

	signal pll_c0			: std_logic;
	signal palse			: std_logic;
	signal bcouter_out	: std_logic_vector(3 downto 0);
	signal bcounter_rst	: std_logic;
	signal dout				: std_logic_vector(3 downto 0);
	
	component prescaler
	port
	(	clk		: in std_logic;
		sreset	: in std_logic;
		q		  	: out std_logic	);
	end component;	
	
	component bcounter
	port
	(	clk		: in std_logic;
		sreset	: in std_logic;
		areset	: in std_logic;
		enable	: in std_logic;
		q		  	: out std_logic_vector(3 downto 0)	);	
	end component;

	component deco
	port
	(	din		: in	std_logic_vector(3 downto 0);
		dout		: out std_logic_vector(3 downto 0)	);	
	end component;
	
	
begin

u1 : prescaler
port map
	(	clk		=> clk,
		sreset	=> not areset,
		q		  	=>	palse);

u2 : bcounter
port map
	(	clk		=> clk,
		sreset	=> bcounter_rst,
		areset	=> areset,
		enable	=> palse,
		q			=> bcouter_out	);
		
u3 : deco
port map
	(	din	=> bcouter_out,
		dout	=> dout	);
		
		led <= not dout;

		
process (bcouter_out)
begin
	if (bcouter_out = "1001") then
		bcounter_rst <= '0';
	else
		bcounter_rst <= '1';
	end if;	
end process;	
		
end rtl;
