library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity prescaler is
	port
	(	clk		: in std_logic;
		sreset	: in std_logic;
		q		  	: out std_logic	);
end prescaler;

architecture rtl of prescaler is

	signal cnt	: std_logic_vector(23 downto 0):= "111100000000101111111101";
	signal en 	: std_logic; 

begin

	q <= en;

	process (clk)
	begin
	if (rising_edge(clk)) then
		if sreset = '1' then
			cnt <= (others => '0');
		else			
			cnt <= "111100000000101111111101";
			if (en = '0') then
				cnt <= cnt - 1;
			else
				cnt <= "111100000000101111111101";
			end if;
		end if;
	end if;	
	end process;
	
	process (cnt)
	begin
	if (cnt = "000000000000000000000000") then
				en <= '1';
			else
				en <= '0';
			end if;
	end process;		
	
end rtl;
