library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity bcounter is
	generic	(
		MIN_COUNT : natural := 0;
		MAX_COUNT : natural := 4	);
	port	(
		clk		: in std_logic;
		sreset	: in std_logic;
		areset	: in std_logic;
		enable	: in std_logic;
		q		  	: out std_logic_vector(MAX_COUNT-1 downto MIN_COUNT)	);
end bcounter;

architecture rtl of bcounter is

	signal cnt : std_logic_vector(MAX_COUNT-1 downto MIN_COUNT):=(others => '0');

begin

	process (clk, areset)
	begin
	if (areset = '0') then
		cnt <= (others => '0');
	elsif (rising_edge(clk)) then
		if sreset = '0' then
			cnt <= (others => '0');
		elsif enable = '1' then
			cnt <= cnt + 1;
		end if;
	end if;
	end process;

	q <= cnt;

end rtl;
